/*
  Copyright (c) 2024-2025, Intel Corporation

  SPDX-License-Identifier: BSD-3-Clause
*/

#include <stdio.h>

#include "binary_type.h"
#include "bitcode_lib.h"
#include "ispc.h"
#include "util.h"

#include <llvm/ADT/SmallString.h>
#include <llvm/Support/Path.h>

using namespace ispc;

void printBinaryType() { printf("slim\n"); }

void initializeBinaryType(const char *ISPCExecutableAbsPath) {
    llvm::SmallString<128> includeDir(ISPCExecutableAbsPath);
    llvm::sys::path::remove_filename(includeDir);
    llvm::sys::path::remove_filename(includeDir);
    llvm::SmallString<128> shareDir(includeDir);
    llvm::sys::path::append(includeDir, "include", "stdlib");
    g->includePath.push_back(std::string(includeDir.c_str()));
    llvm::sys::path::append(shareDir, "share", "ispc");
    g->shareDirPath = std::string(shareDir.str());
    g->isSlimBinary = true;
}

llvm::StringRef getCoreISPHRef() {
    Assert(0 && "getCoreISPHRef() should not be called for slim binaries");
    return llvm::StringRef();
}

llvm::StringRef getStdlibISPHRef() {
    Assert(0 && "getStdlibISPHRef() should not be called for slim binaries");
    return llvm::StringRef();
}

// This file is to be generated by the build system.
#include "bitcode_libs_generated.cpp"
