// BAse64Test.cc
// -------------
// file class test module
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2009 by Bjoern Lemke                        
//
//
///////////////////////////////////////////////////////////////////////////////

#include "../src/Exception.h"
#include "../src/File.h"
#include "../src/Base64Coder.h"

#define BUFSIZE 8000

int main(int argc, char **argv)
{

    int numCheck = 4;
    int checkCount = 1;
    
    try {
	
	
	cout << "1.." << numCheck << endl;
	
	File testFile(Chain("testFile"));
	testFile.open(File::WRITE);
	testFile.writeChain(Chain("THIS IS A TESTFILE"));
	testFile.writeChain(Chain("THIS IS A TESTFILE"));
	testFile.writeChain(Chain("THIS IS A TESTFILE"));
	testFile.writeChain(Chain("THIS IS A TESTFILE"));											
	testFile.close();

	cout << "ok " << checkCount << " - writeChain" << endl;
	checkCount++;
	
	testFile.open(File::READ);
	unsigned char byteBuf[BUFSIZE];

	
	unsigned long long rb = 0;
	int n;
	while ( ( n =  testFile.readByte((char*)(rb + byteBuf), BUFSIZE - rb)) > 0 )
	{
	    rb += n;
	    // cout << "<<< read byte = " << rb << ">>>" << endl;
	}
	
	testFile.close();
	cout << "ok " << checkCount << " - readByte" << endl;
	checkCount++;
	
	Base64Coder b64;
	
	Chain b64String = b64.encode(rb , byteBuf);

	cout << "ok " << checkCount << " - encode64" << endl;
	checkCount++;
	
	unsigned char decBuf[BUFSIZE];
	b64.decode(b64String, decBuf, rb);

	cout << "ok " << checkCount << " - decode64" << endl;
	checkCount++;
	
	
    }
    catch (Exception e)
    {

	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;

	return 1;
    }
    
    return 0;;
}
  

