// lex.SEAMS.cpp generated by reflex 3.5.0 from aprepro.ll

#define REFLEX_VERSION "3.5.0"

////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//  OPTIONS USED                                                              //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

#undef REFLEX_OPTION_bison
#undef REFLEX_OPTION_ctorarg
#undef REFLEX_OPTION_ctorinit
#undef REFLEX_OPTION_debug
#undef REFLEX_OPTION_flex
#undef REFLEX_OPTION_lex
#undef REFLEX_OPTION_lexer
#undef REFLEX_OPTION_namespace
#undef REFLEX_OPTION_outfile
#undef REFLEX_OPTION_params
#undef REFLEX_OPTION_prefix
#undef REFLEX_OPTION_stack

#define REFLEX_OPTION_bison     true
#define REFLEX_OPTION_ctorarg   Aprepro &aprepro_yyarg
#define REFLEX_OPTION_ctorinit  aprepro(aprepro_yyarg)
#define REFLEX_OPTION_debug     true
#define REFLEX_OPTION_flex      true
#define REFLEX_OPTION_lex       lex
#define REFLEX_OPTION_lexer     Scanner
#define REFLEX_OPTION_namespace SEAMS
#define REFLEX_OPTION_outfile   "lex.SEAMS.cpp"
#define REFLEX_OPTION_params    SEAMS::Parser::semantic_type *yylval
#define REFLEX_OPTION_prefix    yy
#define REFLEX_OPTION_stack     true

// --debug option enables ASSERT:
#define ASSERT(c) assert(c)

////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//  SECTION 1: %top user code                                                 //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

#line 12 "aprepro.ll"

#include "aprepro_parser.h"

////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//  FLEX-COMPATIBLE DEFINITIONS                                               //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

#define INITIAL       (0)
#define PARSING       (1)
#define GET_FILENAME  (2)
#define IF_SKIP       (3)
#define GET_VAR       (4)
#define VERBATIM      (5)
#define IF_WHILE_SKIP (6)
#define GET_LOOP_VAR  (7)
#define LOOP          (8)
#define LOOP_SKIP     (9)
#define END_CASE_SKIP (10)
#define YY_NUM_RULES  (222)

////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//  REGEX MATCHER                                                             //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

#include <reflex/matcher.h>

////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//  FLEX-COMPATIBLE ABSTRACT LEXER CLASS                                      //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

#include <reflex/flexlexer.h>

namespace SEAMS {

  typedef reflex::FlexLexer<reflex::Matcher> FlexLexer;

} // namespace SEAMS
#undef yytext
#undef yyleng
#undef yylineno

////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//  LEXER CLASS                                                               //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

namespace SEAMS {

  class Scanner : public FlexLexer
  {
#line 113 "aprepro.ll"

  public:
    friend class Parser;

    /** Required for virtual functions */
    ~Scanner() override;

    bool   add_include_file(const std::string &filename, bool must_exist);
    int    yywrap() override;
    void   yyerror(const char *s);
    void   LexerOutput(const char *buf, size_t size) override;
    size_t LexerInput(char *buf, size_t max_size) override;

    char *rescan(char *string);
    char *execute(char *string);
    char *import_handler(char *string);
    char *if_handler(double x);
    char *elseif_handler(double x);
    char *switch_handler(double x);
    char *case_handler(double x);

    /** Enable debug output (via arg_yyout) if compiled into the scanner. */
    void set_debug(bool b);

    /* User arguments.  */
    class Aprepro &aprepro;

    /* save the original string for substitution history */
    void save_history_string();

  public:
    Scanner(Aprepro &aprepro_yyarg,
            // a persistent source of input, empty by default
            const reflex::Input &input = reflex::Input(),
            // optional output stream, NULL means std::cout by default
            std::ostream *os = NULL)
        : FlexLexer(input, os), aprepro(aprepro_yyarg)
    {
      set_debug(true);
    }
    virtual int yylex(void)
    {
      LexerError("Scanner::yylex invoked but %option lex=lex is used");
      yyterminate();
    }
    // the flex lexer function defined by SECTION 2
    virtual int lex(SEAMS::Parser::semantic_type *yylval);
    // lexer functions accepting new input to scan
    int lex(const reflex::Input &input, SEAMS::Parser::semantic_type *yylval)
    {
      in(input);
      return lex(yylval);
    }
    int lex(const reflex::Input &input, std::ostream *os, SEAMS::Parser::semantic_type *yylval)
    {
      in(input);
      if (os)
        out(*os);
      return lex(yylval);
    }
  };

} // namespace SEAMS

////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//  SECTION 1: %{ user code %}                                                //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

#line 1 "aprepro.ll"
/* -*- Mode: c++ -*- */

#line 3 "aprepro.ll"
/*
 * Copyright(C) 1999-2023 National Technology & Engineering Solutions
 * of Sandia, LLC (NTESS).  Under the terms of Contract DE-NA0003525 with
 * NTESS, the U.S. Government retains certain rights in this software.
 *
 * See packages/seacas/LICENSE for details
 */

#line 16 "aprepro.ll"

#include <assert.h>
#include <fcntl.h>
#include <fstream>
#include <iostream>
#include <sstream>
#include <stack>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "apr_getline.h"
#include "apr_tokenize.h"
#include "apr_util.h"
#include "aprepro.h"
#include "fmt/format.h"
#include "fmt/ostream.h"

#define YY_NO_UNISTD_H
/* import the parser's token type into a local typedef */
typedef SEAMS::Parser::token      token;
typedef SEAMS::Parser::token_type token_type;

/* By default yylex returns int, we use token_type. Unfortunately yyterminate
 * by default returns 0, which is not of token_type. */
#undef yyterminate
#define yyterminate() return token::END

#define show(x) *(aprepro->infoStream) << "<" << x << ">" << std::flush;
namespace SEAMS {
  extern bool do_echo;
  void        yyerror(const char *s);
} // namespace SEAMS

namespace {
  bool begin_double_brace = false;
  bool end_double_brace   = false;
  bool string_is_ascii(const char *line, size_t len)
  {
    for (size_t i = 0; i < len; i++) {
      if (!(std::isspace(static_cast<unsigned char>(line[i])) ||
            std::isprint(static_cast<unsigned char>(line[i])))) {
        return false;
      }
    }
    return true;
  }
} // namespace

int file_must_exist = 0; /* Global used by include/conditional include */

/* Global variables used by the looping mechanism */
SEAMS::file_rec *outer_file = nullptr;
int              loop_lvl   = 0;
std::fstream    *tmp_file;
const char      *temp_f;

#if defined __NVCC__
#pragma diag_suppress code_is_unreachable
#endif

#define MAX_IF_NESTING 1024

int    if_state[MAX_IF_NESTING]    = {0};     // INITIAL
int    if_case_run[MAX_IF_NESTING] = {false}; /* Has any if or elseif condition executed */
int    if_lvl                      = 0;
int    if_skip_level               = 0;
bool   suppress_nl                 = false;
bool   switch_active               = false; // Are we in a switch
bool   switch_case_run             = false; // has there been a case which matched condition run?
bool   switch_skip_to_endcase      = false;
double switch_condition            = 0.0; // Value specified in "switch(condition)"

// For substitution history
size_t      curr_index = 0;
std::string history_string;
size_t      hist_start = 0;

#undef YY_USER_ACTION
#define YY_USER_ACTION curr_index += yyleng;

#line 99 "aprepro.ll"
/*** Flex Declarations and Options ***/

#line 101 "aprepro.ll"
/* enable c++ scanner class generation */
#line 104 "aprepro.ll"
/* change the name of the scanner class. results in "SEAMSFlexLexer" */
#line 144 "aprepro.ll"
/* enable scanner to generate debug output. disable this for release
 * versions. */
#line 148 "aprepro.ll"
/* enables the use of start condition stacks */

////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//  BISON                                                                     //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

SEAMS::Scanner YY_SCANNER;

#ifndef YY_EXTERN_C
#define YY_EXTERN_C
#endif

char     *yytext;
yy_size_t yyleng;
int       yylineno;

YY_EXTERN_C int yylex(SEAMS::Parser::semantic_type *yylval)
{
  int lex_token = YY_SCANNER.lex(yylval);
  yytext        = const_cast<char *>(YY_SCANNER.YYText());
  yyleng        = static_cast<yy_size_t>(YY_SCANNER.YYLeng());
  yylineno      = static_cast<int>(YY_SCANNER.lineno());
  return lex_token;
}

#define yytext   const_cast<char *>(YY_SCANNER.YYText())
#define yyleng   static_cast<yy_size_t>(YY_SCANNER.YYLeng())
#define yylineno static_cast<int>(YY_SCANNER.lineno())

////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//  SECTION 2: rules                                                          //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

int SEAMS::Scanner::lex(SEAMS::Parser::semantic_type *yylval)
{
  static const char *REGEX_INITIAL =
      "(?m)((?:\\Q{VERBATIM(ON)}\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{ECHO}\\E))|((?:["
      "\\x09\\x0c\\x20]*)(?:\\Q{ECHO(ON)}\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{NOECHO}\\E))|((?:["
      "\\x09\\x0c\\x20]*)(?:\\Q{ECHO(OFF)}\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{IMMUTABLE(ON)}\\E))|("
      "(?:[\\x09\\x0c\\x20]*)(?:\\Q{IMMUTABLE(OFF)}\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ll](?:"
      "\\Qoop\\E)(?:[\\x09\\x0c\\x20]*)(?:\\Q(\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)(?:["
      "\\x09\\x0c\\x20]*)(?:\\Qdefault\\E)(?:[\\x09\\x0c\\x20]*)(?:\\Q}\\E).*(?:\\Q\\n\\E))|((?:["
      "\\x09\\x0c\\x20]*)(?:\\Q{\\E)(?:[\\x09\\x0c\\x20]*)(?:\\Qendswitch\\E)(?:[\\x09\\x0c\\x20]*)"
      "(?:\\Q}\\E).*(?:\\Q\\n\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ii](?:\\Qfdef\\E)(?:["
      "\\x09\\x0c\\x20]*)(?:\\Q(\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ii](?:\\Qfndef\\E)(?:["
      "\\x09\\x0c\\x20]*)(?:\\Q(\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ee](?:\\Qlse}\\E).*(?:"
      "\\Q\\n\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ee](?:\\Qnd\\E)[Ii](?:\\Qf}\\E).*(?:"
      "\\Q\\n\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ii](?:\\Qnclude\\E)(?:[\\x09\\x0c\\x20]*)(?:"
      "\\Q(\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Cc](?:\\Qinclude\\E)(?:[\\x09\\x0c\\x20]*)(?:"
      "\\Q(\\E))|((?:\\Q\\\\\\{\\E))|((?:\\Q\\\\\\}\\E))|((?:\\Q{{\\E))|((?:\\Q{\\E))|([Ee][Xx][Ii]"
      "[Tt])|([Qq][Uu][Ii][Tt])|(\\$)|((?:(?:[A-Z_a-z])(?:(?:[A-Z_a-z])|(?:[0-9])|:)*))|(.)|((?:"
      "\\Q\\n\\E))";
  static const reflex::Pattern PATTERN_INITIAL(REGEX_INITIAL);
  static const char           *REGEX_PARSING =
      "(?m)((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ee](?:\\Qlse}\\E).*(?:\\Q\\n\\E))|((?:["
      "\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ee](?:\\Qnd\\E)[Ii](?:\\Qf}\\E).*(?:\\Q\\n\\E))|((?:(?:[0-9])+"
      "(?:(?:[Ee][\\x2b\\x2d]?(?:[0-9])+))?))|((?:(?:[0-9])*\\.(?:(?:[0-9])+)?(?:(?:[Ee]["
      "\\x2b\\x2d]?(?:[0-9])+))?))|((?:[\\x09\\x0c\\x20]*))|((?:(?:[A-Z_a-z])(?:(?:[A-Z_a-z])|(?:["
      "0-9])|:)*))|((?:\\Q=\\E))|((?:\\Q+=\\E))|((?:\\Q-=\\E))|((?:\\Q*=\\E))|((?:\\Q/"
      "=\\E))|((?:\\Q^=\\E))|((?:\\Q**=\\E))|((?:\\Q++\\E))|((?:\\Q--\\E))|((?:\\Q+\\E))|((?:\\Q-"
      "\\E))|((?:\\Q*\\E))|((?:\\Q~\\E))|((?:\\Q//\\E))|((?:\\Q/"
      "\\E))|((?:\\Q%\\E))|((?:\\Q^\\E))|((?:\\Q**\\E))|((?:\\Q\\n\\E))|((?:\\Q(\\E))|((?:\\Q)\\E))"
      "|((?:\\Q,\\E))|((?:\\Q;\\E))|((?:\\Q:\\E))|((?:\\Q?\\E))|((?:\\Q<\\E))|((?:\\Q>\\E))|((?:"
      "\\Q<=\\E))|((?:\\Q>=\\E))|((?:\\Q==\\E))|((?:\\Q!=\\E))|((?:\\Q&&\\E))|((?:\\Q||\\E))|((?:"
      "\\Q!\\E))|((?:\\Q[\\E))|((?:\\Q]\\E))|((?:\"[^\\x0a\"]*[\\x0a\"]))|((?:'[^']*[']))|((?:\\Q}"
      "\\E))|((?:\\Q}}\\E))|((?:\\Q\\\\\\{\\E))|((?:\\Q\\\\\\}\\E))|((?:\\Q{{\\E))|((?:\\Q{\\E))|(["
      "Ee][Xx][Ii][Tt])|([Qq][Uu][Ii][Tt])|(\\$)|((?:(?:[A-Z_a-z])(?:(?:[A-Z_a-z])|(?:[0-9])|:)*))|"
      "(.)|((?:\\Q\\n\\E))";
  static const reflex::Pattern PATTERN_PARSING(REGEX_PARSING);
  static const char           *REGEX_GET_FILENAME =
      "(?m)((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ee](?:\\Qlse}\\E).*(?:\\Q\\n\\E))|((?:["
      "\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ee](?:\\Qnd\\E)[Ii](?:\\Qf}\\E).*(?:\\Q\\n\\E))|(.+(?:\\Q)\\E)"
      "(?:[\\x09\\x0c\\x20]*)(?:\\Q}\\E)(?:(?:\\Q\\n\\E))*)|((?:\\Q\\\\\\{\\E))|((?:\\Q\\\\\\}\\E))"
      "|((?:\\Q{{\\E))|((?:\\Q{\\E))|([Ee][Xx][Ii][Tt])|([Qq][Uu][Ii][Tt])|(\\$)|((?:(?:[A-Z_a-z])("
      "?:(?:[A-Z_a-z])|(?:[0-9])|:)*))|(.)|((?:\\Q\\n\\E))";
  static const reflex::Pattern PATTERN_GET_FILENAME(REGEX_GET_FILENAME);
  static const char           *REGEX_IF_SKIP =
      "(?m)((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ii](?:\\Qfdef\\E)(?:[\\x09\\x0c\\x20]*)(?:\\Q(\\E))|("
      "(?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ii](?:\\Qf\\E)(?:[\\x09\\x0c\\x20]*)(?:\\Q(\\E))|((?:["
      "\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ii](?:\\Qfndef\\E)(?:[\\x09\\x0c\\x20]*)(?:\\Q(\\E))|((?:["
      "\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ee](?:\\Qlse}\\E).*(?:\\Q\\n\\E))|((?:[\\x09\\x0c\\x20]*)(?:"
      "\\Q{\\E)(?:[\\x09\\x0c\\x20]*)[Ee](?:\\Qlse\\E)[Ii](?:\\Qf\\E).*(?:\\Q\\n\\E))|([\\x200-9A-"
      "Z_a-z]*)|(\\\\\\{)|(\\\\\\})|(.)|((?:\\Q\\n\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ee](?:"
      "\\Qnd\\E)[Ii](?:\\Qf}\\E).*(?:\\Q\\n\\E))|((?:\\Q\\\\\\{\\E))|((?:\\Q\\\\\\}\\E))|((?:\\Q{{"
      "\\E))|((?:\\Q{\\E))|([Ee][Xx][Ii][Tt])|([Qq][Uu][Ii][Tt])|(\\$)|((?:(?:[A-Z_a-z])(?:(?:[A-Z_"
      "a-z])|(?:[0-9])|:)*))|(.)|((?:\\Q\\n\\E))";
  static const reflex::Pattern PATTERN_IF_SKIP(REGEX_IF_SKIP);
  static const char           *REGEX_GET_VAR =
      "(?m)((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ee](?:\\Qlse}\\E).*(?:\\Q\\n\\E))|((?:["
      "\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ee](?:\\Qnd\\E)[Ii](?:\\Qf}\\E).*(?:\\Q\\n\\E))|((?:\\Q\\\\\\{"
      "\\E))|((?:\\Q\\\\\\}\\E))|((?:\\Q{{\\E))|((?:\\Q{\\E))|([Ee][Xx][Ii][Tt])|([Qq][Uu][Ii][Tt])"
      "|(\\$)|((?:(?:[A-Z_a-z])(?:(?:[A-Z_a-z])|(?:[0-9])|:)*))|(.)|((?:\\Q\\n\\E))";
  static const reflex::Pattern PATTERN_GET_VAR(REGEX_GET_VAR);
  static const char           *REGEX_VERBATIM =
      "(?m)((?:\\Q{VERBATIM(OFF)}\\E))|([\\x200-9A-Z_a-z]*)|(.)|((?:\\Q\\n\\E))|((?:["
      "\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ee](?:\\Qlse}\\E).*(?:\\Q\\n\\E))|((?:[\\x09\\x0c\\x20]*)(?:"
      "\\Q{\\E)[Ee](?:\\Qnd\\E)[Ii](?:\\Qf}\\E).*(?:\\Q\\n\\E))|((?:\\Q\\\\\\{\\E))|((?:\\Q\\\\\\}"
      "\\E))|((?:\\Q{{\\E))|((?:\\Q{\\E))|([Ee][Xx][Ii][Tt])|([Qq][Uu][Ii][Tt])|(\\$)|((?:(?:[A-Z_"
      "a-z])(?:(?:[A-Z_a-z])|(?:[0-9])|:)*))|(.)|((?:\\Q\\n\\E))";
  static const reflex::Pattern PATTERN_VERBATIM(REGEX_VERBATIM);
  static const char           *REGEX_IF_WHILE_SKIP =
      "(?m)((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ee](?:\\Qnd\\E)[Ii](?:\\Qf}\\E).*(?:\\Q\\n\\E))|((?:["
      "\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ii](?:\\Qfdef\\E)(?:[\\x09\\x0c\\x20]*)(?:\\Q(\\E).*(?:"
      "\\Q\\n\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ii](?:\\Qf\\E)(?:[\\x09\\x0c\\x20]*)(?:\\Q("
      "\\E).*(?:\\Q\\n\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ii](?:\\Qfndef\\E)(?:["
      "\\x09\\x0c\\x20]*)(?:\\Q(\\E).*(?:\\Q\\n\\E))|(.*(?:\\Q\\n\\E))|((?:[\\x09\\x0c\\x20]*)(?:"
      "\\Q{\\E)[Ee](?:\\Qlse}\\E).*(?:\\Q\\n\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ee](?:"
      "\\Qnd\\E)[Ii](?:\\Qf}\\E).*(?:\\Q\\n\\E))|((?:\\Q\\\\\\{\\E))|((?:\\Q\\\\\\}\\E))|((?:\\Q{{"
      "\\E))|((?:\\Q{\\E))|([Ee][Xx][Ii][Tt])|([Qq][Uu][Ii][Tt])|(\\$)|((?:(?:[A-Z_a-z])(?:(?:[A-Z_"
      "a-z])|(?:[0-9])|:)*))|(.)|((?:\\Q\\n\\E))";
  static const reflex::Pattern PATTERN_IF_WHILE_SKIP(REGEX_IF_WHILE_SKIP);
  static const char           *REGEX_GET_LOOP_VAR =
      "(?m)(.+(?:\\Q)}\\E).*(?:\\Q\\n\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ee](?:\\Qlse}\\E).*(?"
      ":\\Q\\n\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ee](?:\\Qnd\\E)[Ii](?:\\Qf}\\E).*(?:"
      "\\Q\\n\\E))|((?:\\Q\\\\\\{\\E))|((?:\\Q\\\\\\}\\E))|((?:\\Q{{\\E))|((?:\\Q{\\E))|([Ee][Xx]["
      "Ii][Tt])|([Qq][Uu][Ii][Tt])|(\\$)|((?:(?:[A-Z_a-z])(?:(?:[A-Z_a-z])|(?:[0-9])|:)*))|(.)|((?:"
      "\\Q\\n\\E))";
  static const reflex::Pattern PATTERN_GET_LOOP_VAR(REGEX_GET_LOOP_VAR);
  static const char           *REGEX_LOOP =
      "(?m)((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ee](?:\\Qnd\\E)[Ll](?:\\Qoop\\E).*(?:\\Q\\n\\E))|((?:"
      "[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ll](?:\\Qoop\\E)(?:[\\x09\\x0c\\x20]*)(?:\\Q(\\E).*(?:"
      "\\Q\\n\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Aa](?:\\Qbort\\E)[Ll](?:\\Qoop\\E).*(?:"
      "\\Q\\n\\E))|(.*(?:\\Q\\n\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ee](?:\\Qlse}\\E).*(?:"
      "\\Q\\n\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ee](?:\\Qnd\\E)[Ii](?:\\Qf}\\E).*(?:"
      "\\Q\\n\\E))|((?:\\Q\\\\\\{\\E))|((?:\\Q\\\\\\}\\E))|((?:\\Q{{\\E))|((?:\\Q{\\E))|([Ee][Xx]["
      "Ii][Tt])|([Qq][Uu][Ii][Tt])|(\\$)|((?:(?:[A-Z_a-z])(?:(?:[A-Z_a-z])|(?:[0-9])|:)*))|(.)|((?:"
      "\\Q\\n\\E))";
  static const reflex::Pattern PATTERN_LOOP(REGEX_LOOP);
  static const char           *REGEX_LOOP_SKIP =
      "(?m)((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ee](?:\\Qnd\\E)[Ll](?:\\Qoop\\E).*(?:\\Q\\n\\E))|((?:"
      "[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ll](?:\\Qoop\\E)(?:[\\x09\\x0c\\x20]*)(?:\\Q(\\E).*(?:"
      "\\Q\\n\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Aa](?:\\Qbort\\E)[Ll](?:\\Qoop\\E).*(?:"
      "\\Q\\n\\E))|(.*(?:\\Q\\n\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ee](?:\\Qlse}\\E).*(?:"
      "\\Q\\n\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ee](?:\\Qnd\\E)[Ii](?:\\Qf}\\E).*(?:"
      "\\Q\\n\\E))|((?:\\Q\\\\\\{\\E))|((?:\\Q\\\\\\}\\E))|((?:\\Q{{\\E))|((?:\\Q{\\E))|([Ee][Xx]["
      "Ii][Tt])|([Qq][Uu][Ii][Tt])|(\\$)|((?:(?:[A-Z_a-z])(?:(?:[A-Z_a-z])|(?:[0-9])|:)*))|(.)|((?:"
      "\\Q\\n\\E))";
  static const reflex::Pattern PATTERN_LOOP_SKIP(REGEX_LOOP_SKIP);
  static const char           *REGEX_END_CASE_SKIP =
      "(?m)((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)(?:[\\x09\\x0c\\x20]*)(?:\\Qcase\\E).*(?:\\Q\\n\\E))|("
      "(?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)(?:[\\x09\\x0c\\x20]*)(?:\\Qdefault\\E)(?:[\\x09\\x0c\\x20]"
      "*)(?:\\Q}\\E).*(?:\\Q\\n\\E))|((?:[\\x09\\x0c\\x20]*)(?:\\Q{\\E)(?:[\\x09\\x0c\\x20]*)(?:"
      "\\Qendswitch\\E)(?:[\\x09\\x0c\\x20]*)(?:\\Q}\\E).*(?:\\Q\\n\\E))|(.*(?:\\Q\\n\\E))|((?:["
      "\\x09\\x0c\\x20]*)(?:\\Q{\\E)[Ee](?:\\Qlse}\\E).*(?:\\Q\\n\\E))|((?:[\\x09\\x0c\\x20]*)(?:"
      "\\Q{\\E)[Ee](?:\\Qnd\\E)[Ii](?:\\Qf}\\E).*(?:\\Q\\n\\E))|((?:\\Q\\\\\\{\\E))|((?:\\Q\\\\\\}"
      "\\E))|((?:\\Q{{\\E))|((?:\\Q{\\E))|([Ee][Xx][Ii][Tt])|([Qq][Uu][Ii][Tt])|(\\$)|((?:(?:[A-Z_"
      "a-z])(?:(?:[A-Z_a-z])|(?:[0-9])|:)*))|(.)|((?:\\Q\\n\\E))";
  static const reflex::Pattern PATTERN_END_CASE_SKIP(REGEX_END_CASE_SKIP);
  if (!has_matcher()) {
    matcher(new Matcher(PATTERN_INITIAL, stdinit(), this));
    YY_USER_INIT
  }
  switch (start()) {
  case INITIAL:
#line 429 "aprepro.ll"
    /* This restores the old behavior of ifdef and ifndef
     * where they would eat up any leading whitespace on
     * a line.
     */
    break;
  case IF_SKIP:
#line 500 "aprepro.ll"
    /* IF an if, ifdef, or ifndef found while skipping, then
     * skip the entire block up and including the endif.
     * The (IF_WHILE_SKIP) start condition handles this skipping.
     */
    break;
  case IF_WHILE_SKIP:
#line 469 "aprepro.ll"
    /* If an if was found while skipping, then eat
     * that entire if block until endif
     * found since there is no way that
     * any of the code in that if block could be executed.
     * Make sure to handle multiple levels of skipped ifs...
     *
     * NOTE: if_lvl was not incremented, so don't need to decrement when
     *       endif found.
     */
    break;
  }
  while (true) {
    switch (start()) {
    case INITIAL:
      matcher().pattern(PATTERN_INITIAL);
      switch (matcher().scan()) {
      case 0:
        if (matcher().at_end()) {
          if (debug())
            std::cerr << "--\033[1;35mEOF\033[0m start(" << start() << ")\n";
          yyterminate();
        }
        else {
          if (debug())
            std::cerr << "--\033[1;31mdefault rule\033[0m\n";
          output(matcher().input());
        }
        YY_BREAK
      case 1: // rule aprepro.ll:173: "{VERBATIM(ON)}" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:173\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 173 "aprepro.ll"
        {
          BEGIN(VERBATIM);
        }
        YY_BREAK
      case 2: // rule aprepro.ll:174: {WS}"{ECHO}" :
      case 3: // rule aprepro.ll:175: {WS}"{ECHO(ON)}" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:175\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 175 "aprepro.ll"
        {
          do_echo = true;
        }
        YY_BREAK
      case 4: // rule aprepro.ll:176: {WS}"{NOECHO}" :
      case 5: // rule aprepro.ll:177: {WS}"{ECHO(OFF)}" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:177\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 177 "aprepro.ll"
        {
          do_echo = false;
        }

        YY_BREAK
      case 6: // rule aprepro.ll:179: {WS}"{IMMUTABLE(ON)}" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:179\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 179 "aprepro.ll"
        {
          aprepro.stateImmutable = true;
        }
        YY_BREAK
      case 7: // rule aprepro.ll:180: {WS}"{IMMUTABLE(OFF)}" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:180\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 180 "aprepro.ll"
        {
          aprepro.stateImmutable = aprepro.ap_options.immutable;
        }

        YY_BREAK
      case 8: // rule aprepro.ll:182: {WS}"{"[Ll]"oop"{WS}"(" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:182\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 182 "aprepro.ll"
        {
          BEGIN(GET_LOOP_VAR);
        }
        YY_BREAK
      case 9: // rule aprepro.ll:379: {WS}"{"{WS}"default"{WS}"}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:379\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 379 "aprepro.ll"
        {
          if (!switch_active) {
            yyerror("default statement found outside switch statement.");
          }

          if (!switch_case_run) {
            switch_case_run = true;
            BEGIN(INITIAL);
            switch_skip_to_endcase = false;
            if (aprepro.ap_options.debugging)
              fprintf(stderr, "DEBUG SWITCH: 'default' code executing at line %d\n",
                      aprepro.ap_file_list.top().lineno);
          }
          else {
            if (aprepro.ap_options.debugging)
              fprintf(stderr,
                      "DEBUG SWITCH: 'default' not executing since a previous case already ran at "
                      "line %d\n",
                      aprepro.ap_file_list.top().lineno);

            /* Need to skip all code until end of case */
            BEGIN(END_CASE_SKIP);
          }
        }

        YY_BREAK
      case 10: // rule aprepro.ll:415: {WS}"{"{WS}"endswitch"{WS}"}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:415\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 415 "aprepro.ll"
        {
          aprepro.ap_file_list.top().lineno++;
          if (!switch_active) {
            yyerror("endswitch statement found without matching switch.");
          }
          switch_active          = false;
          switch_skip_to_endcase = false;
        }

        YY_BREAK
      case 11: // rule aprepro.ll:429: {WS}"{"[Ii]"fdef"{WS}"(" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:429\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 429 "aprepro.ll"
        {
          // Used to avoid undefined variable warnings in old ifdef/ifndef construct
          aprepro.inIfdefGetvar = true;
          unput('(');
          unput('f');
          unput('e');
          unput('d');
          unput('f');
          unput('i');
          unput('_');
          unput('{');
          curr_index = 0;
        }

        YY_BREAK
      case 12: // rule aprepro.ll:443: {WS}"{"[Ii]"fndef"{WS}"(" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:443\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 443 "aprepro.ll"
        {
          // Used to avoid undefined variable warnings in old ifdef/ifndef construct
          aprepro.inIfdefGetvar = true;
          unput('(');
          unput('f');
          unput('e');
          unput('d');
          unput('n');
          unput('f');
          unput('i');
          unput('_');
          unput('{');
          curr_index = 0;
        }
        YY_BREAK
      case 13: // rule aprepro.ll:525: {WS}"{"[Ee]"lse}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:525\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 525 "aprepro.ll"
        {
          aprepro.ap_file_list.top().lineno++;
          if (aprepro.ap_options.debugging)
            fprintf(stderr, "DEBUG IF: 'else'   at level = %d at line %d\n", if_lvl,
                    aprepro.ap_file_list.top().lineno);
          if (YY_START == VERBATIM) {
            if (do_echo)
              ECHO;
          }
          else if (if_state[if_lvl] == IF_SKIP) {
            if (!if_case_run[if_lvl]) {
              BEGIN(INITIAL);
              if_state[if_lvl]    = INITIAL;
              if_case_run[if_lvl] = true;
            }
            else {
              BEGIN(IF_SKIP);
              if_state[if_lvl] = IF_SKIP;
            }
          }
          else if (if_state[if_lvl] == INITIAL) {
            BEGIN(IF_SKIP);
            if_state[if_lvl] = IF_SKIP;
          }

          /* If neither is true, this is a nested
             if that should be skipped */
        }

        YY_BREAK
      case 14: // rule aprepro.ll:584: {WS}"{"[Ee]"nd"[Ii]"f}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:584\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 584 "aprepro.ll"
        {

          if (YY_START == VERBATIM) {
            if (do_echo)
              ECHO;
          }
          else {
            if (if_state[if_lvl] == IF_SKIP || if_state[if_lvl] == INITIAL) {
              BEGIN(INITIAL);
              suppress_nl = false;
            }
            /* If neither is true, this is a nested
               if that should be skipped */
            if (aprepro.ap_options.debugging)
              printf("DEBUG IF: 'endif'  at level = %d at line %d\n", if_lvl,
                     aprepro.ap_file_list.top().lineno);
            if (--if_lvl < 0) {
              if_lvl = 0;
              yyerror("Improperly Nested ifdef/ifndef statements");
            }
            /* Ignore endif if not skipping */
          }
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      case 15: // rule aprepro.ll:609: {WS}"{"[Ii]"nclude"{WS}"(" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:609\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 609 "aprepro.ll"
        {
          BEGIN(GET_FILENAME);
          file_must_exist = true;
        }
        YY_BREAK
      case 16: // rule aprepro.ll:611: {WS}"{"[Cc]"include"{WS}"(" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:611\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 611 "aprepro.ll"
        {
          BEGIN(GET_FILENAME);
          file_must_exist = false;
        }
        YY_BREAK
      case 17: // rule aprepro.ll:746: "\\\{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:746\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 746 "aprepro.ll"
        {
          if (do_echo)
            LexerOutput("{", 1);
        }

        YY_BREAK
      case 18: // rule aprepro.ll:748: "\\\}" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:748\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 748 "aprepro.ll"
        {
          if (do_echo)
            LexerOutput("}", 1);
        }

        YY_BREAK
      case 19: // rule aprepro.ll:750: "{{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:750\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 750 "aprepro.ll"
        {
          // Check if we need to save the substitution history first.
          if (aprepro.ap_options.keep_history && (aprepro.ap_file_list.top().name != "_string_")) {
            if (curr_index > yyleng)
              hist_start = curr_index - yyleng;
            else
              hist_start = 0;
          }

          BEGIN(PARSING);
          do_echo            = false;
          begin_double_brace = true;
          return (token::LBRACE);
        }

        YY_BREAK
      case 20: // rule aprepro.ll:767: "{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:767\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 767 "aprepro.ll"
        {
          // Check if we need to save the substitution history first.
          if (aprepro.ap_options.keep_history && (aprepro.ap_file_list.top().name != "_string_")) {
            if (curr_index > yyleng)
              hist_start = curr_index - yyleng;
            else
              hist_start = 0;
          }

          BEGIN(PARSING);

          return (token::LBRACE);
        }

        YY_BREAK
      case 21: // rule aprepro.ll:783: [Ee][Xx][Ii][Tt] :
      case 22: // rule aprepro.ll:784: [Qq][Uu][Ii][Tt] :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:784\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 784 "aprepro.ll"
        {
          if (aprepro.ap_options.end_on_exit) {
            if (do_echo)
              ECHO;
            return ((token::yytokentype)-1);
          }
          else if (do_echo)
            ECHO;
        }

        YY_BREAK
      case 23: // rule aprepro.ll:794: \$ :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:794\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 794 "aprepro.ll"
        {
          if (do_echo)
            ECHO;
        }

        YY_BREAK
      case 24: // rule aprepro.ll:797: {id} :
      case 25: // rule aprepro.ll:798: . :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:798\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 798 "aprepro.ll"
        {
          if (do_echo && if_state[if_lvl] != IF_SKIP)
            ECHO;
        }

        YY_BREAK
      case 26: // rule aprepro.ll:800: "\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:800\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 800 "aprepro.ll"
        {
          if (do_echo && !suppress_nl)
            ECHO;
          suppress_nl = false;
          if (end_double_brace) {
            do_echo            = true;
            begin_double_brace = false;
            end_double_brace   = false;
          }
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      }
      break;
    case PARSING:
      matcher().pattern(PATTERN_PARSING);
      switch (matcher().scan()) {
      case 0:
        if (matcher().at_end()) {
          if (debug())
            std::cerr << "--\033[1;35mEOF\033[0m start(" << start() << ")\n";
          yyterminate();
        }
        else {
          if (debug())
            std::cerr << "--\033[1;31mdefault rule\033[0m\n";
          output(matcher().input());
        }
        YY_BREAK
      case 1: // rule aprepro.ll:525: {WS}"{"[Ee]"lse}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:525\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 525 "aprepro.ll"
        {
          aprepro.ap_file_list.top().lineno++;
          if (aprepro.ap_options.debugging)
            fprintf(stderr, "DEBUG IF: 'else'   at level = %d at line %d\n", if_lvl,
                    aprepro.ap_file_list.top().lineno);
          if (YY_START == VERBATIM) {
            if (do_echo)
              ECHO;
          }
          else if (if_state[if_lvl] == IF_SKIP) {
            if (!if_case_run[if_lvl]) {
              BEGIN(INITIAL);
              if_state[if_lvl]    = INITIAL;
              if_case_run[if_lvl] = true;
            }
            else {
              BEGIN(IF_SKIP);
              if_state[if_lvl] = IF_SKIP;
            }
          }
          else if (if_state[if_lvl] == INITIAL) {
            BEGIN(IF_SKIP);
            if_state[if_lvl] = IF_SKIP;
          }

          /* If neither is true, this is a nested
             if that should be skipped */
        }

        YY_BREAK
      case 2: // rule aprepro.ll:584: {WS}"{"[Ee]"nd"[Ii]"f}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:584\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 584 "aprepro.ll"
        {

          if (YY_START == VERBATIM) {
            if (do_echo)
              ECHO;
          }
          else {
            if (if_state[if_lvl] == IF_SKIP || if_state[if_lvl] == INITIAL) {
              BEGIN(INITIAL);
              suppress_nl = false;
            }
            /* If neither is true, this is a nested
               if that should be skipped */
            if (aprepro.ap_options.debugging)
              printf("DEBUG IF: 'endif'  at level = %d at line %d\n", if_lvl,
                     aprepro.ap_file_list.top().lineno);
            if (--if_lvl < 0) {
              if_lvl = 0;
              yyerror("Improperly Nested ifdef/ifndef statements");
            }
            /* Ignore endif if not skipping */
          }
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      case 3: // rule aprepro.ll:652: {integer} :
      case 4: // rule aprepro.ll:653: {number} :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:653\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 653 "aprepro.ll"
        {
          sscanf(yytext, "%lf", &yylval->val);
          return (token::NUM);
        }

        YY_BREAK
      case 5: // rule aprepro.ll:656: {WS} :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:656\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 656 "aprepro.ll"
            ; // Empty rule

        YY_BREAK
      case 6: // rule aprepro.ll:658: {id} :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:658\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 658 "aprepro.ll"
        {
          symrec *s;
          s = aprepro.getsym(yytext);
          if (s == nullptr)
            s = aprepro.putsym(yytext, SEAMS::Aprepro::SYMBOL_TYPE::UNDEFINED_VARIABLE, false);
          yylval->tptr = s;
          return ((token::yytokentype)s->type);
        }
        YY_BREAK
      case 7: // rule aprepro.ll:666: "=" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:666\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 666 "aprepro.ll"
        return (token::EQUAL);
        YY_BREAK
      case 8: // rule aprepro.ll:667: "+=" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:667\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 667 "aprepro.ll"
        return (token::EQ_PLUS);
        YY_BREAK
      case 9: // rule aprepro.ll:668: "-=" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:668\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 668 "aprepro.ll"
        return (token::EQ_MINUS);
        YY_BREAK
      case 10: // rule aprepro.ll:669: "*=" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:669\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 669 "aprepro.ll"
        return (token::EQ_TIME);
        YY_BREAK
      case 11: // rule aprepro.ll:670: "/=" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:670\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 670 "aprepro.ll"
        return (token::EQ_DIV);
        YY_BREAK
      case 12: // rule aprepro.ll:671: "^=" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:671\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 671 "aprepro.ll"
        return (token::EQ_POW);
        YY_BREAK
      case 13: // rule aprepro.ll:672: "**=" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:672\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 672 "aprepro.ll"
        return (token::EQ_POW);
        YY_BREAK
      case 14: // rule aprepro.ll:673: "++" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:673\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 673 "aprepro.ll"
        return (token::INC);
        YY_BREAK
      case 15: // rule aprepro.ll:674: "--" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:674\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 674 "aprepro.ll"
        return (token::DEC);
        YY_BREAK
      case 16: // rule aprepro.ll:675: "+" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:675\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 675 "aprepro.ll"
        return (token::PLU);
        YY_BREAK
      case 17: // rule aprepro.ll:676: "-" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:676\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 676 "aprepro.ll"
        return (token::SUB);
        YY_BREAK
      case 18: // rule aprepro.ll:677: "*" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:677\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 677 "aprepro.ll"
        return (token::TIM);
        YY_BREAK
      case 19: // rule aprepro.ll:678: "~" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:678\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 678 "aprepro.ll"
        return (token::TIM); /* ~ is same as multiply */
        YY_BREAK
      case 20: // rule aprepro.ll:679: "//" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:679\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 679 "aprepro.ll"
        return (token::CONCAT); /* String concatenation */
        YY_BREAK
      case 21: // rule aprepro.ll:680: "/" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:680\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 680 "aprepro.ll"
        return (token::DIV);
        YY_BREAK
      case 22: // rule aprepro.ll:681: "%" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:681\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 681 "aprepro.ll"
        return (token::MOD);
        YY_BREAK
      case 23: // rule aprepro.ll:682: "^" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:682\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 682 "aprepro.ll"
        return (token::POW);
        YY_BREAK
      case 24: // rule aprepro.ll:683: "**" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:683\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 683 "aprepro.ll"
        return (token::POW);
        YY_BREAK
      case 25: // rule aprepro.ll:684: "\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:684\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 684 "aprepro.ll"
        aprepro.ap_file_list.top().lineno++;
        YY_BREAK
      case 26: // rule aprepro.ll:685: "(" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:685\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 685 "aprepro.ll"
        return (token::LPAR);
        YY_BREAK
      case 27: // rule aprepro.ll:686: ")" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:686\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 686 "aprepro.ll"
        return (token::RPAR);
        YY_BREAK
      case 28: // rule aprepro.ll:687: "," :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:687\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 687 "aprepro.ll"
        return (token::COMMA);
        YY_BREAK
      case 29: // rule aprepro.ll:688: ";" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:688\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 688 "aprepro.ll"
        return (token::SEMI);
        YY_BREAK
      case 30: // rule aprepro.ll:689: ":" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:689\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 689 "aprepro.ll"
        return (token::COLON);
        YY_BREAK
      case 31: // rule aprepro.ll:690: "?" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:690\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 690 "aprepro.ll"
        return (token::QUEST);
        YY_BREAK
      case 32: // rule aprepro.ll:691: "<" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:691\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 691 "aprepro.ll"
        return (token::LT);
        YY_BREAK
      case 33: // rule aprepro.ll:692: ">" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:692\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 692 "aprepro.ll"
        return (token::GT);
        YY_BREAK
      case 34: // rule aprepro.ll:693: "<=" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:693\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 693 "aprepro.ll"
        return (token::LE);
        YY_BREAK
      case 35: // rule aprepro.ll:694: ">=" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:694\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 694 "aprepro.ll"
        return (token::GE);
        YY_BREAK
      case 36: // rule aprepro.ll:695: "==" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:695\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 695 "aprepro.ll"
        return (token::EQ);
        YY_BREAK
      case 37: // rule aprepro.ll:696: "!=" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:696\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 696 "aprepro.ll"
        return (token::NE);
        YY_BREAK
      case 38: // rule aprepro.ll:697: "&&" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:697\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 697 "aprepro.ll"
        return (token::LAND);
        YY_BREAK
      case 39: // rule aprepro.ll:698: "||" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:698\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 698 "aprepro.ll"
        return (token::LOR);
        YY_BREAK
      case 40: // rule aprepro.ll:699: "!" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:699\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 699 "aprepro.ll"
        return (token::NOT);
        YY_BREAK
      case 41: // rule aprepro.ll:700: "[" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:700\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 700 "aprepro.ll"
        return (token::LBRACK);
        YY_BREAK
      case 42: // rule aprepro.ll:701: "]" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:701\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 701 "aprepro.ll"
        return (token::RBRACK);
        YY_BREAK
      case 43: // rule aprepro.ll:702: {qstring} :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:702\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 702 "aprepro.ll"
        {
          char *pt = strrchr(yytext, '"');
          *pt      = '\0';
          new_string(yytext + 1, &yylval->string);
          return token::QSTRING;
        }

        YY_BREAK
      case 44: // rule aprepro.ll:708: {mlstring} :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:708\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 708 "aprepro.ll"
        {
          char *pt = strrchr(yytext, '\'');
          *pt      = '\0';
          new_string(yytext + 1, &yylval->string);
          return token::QSTRING;
        }

        YY_BREAK
      case 45: // rule aprepro.ll:714: "}" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:714\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 714 "aprepro.ll"
        {
          // Add to the history string
          save_history_string();

          if (switch_skip_to_endcase)
            BEGIN(END_CASE_SKIP);
          else
            BEGIN(if_state[if_lvl]);
          return (token::RBRACE);
        }

        YY_BREAK
      case 46: // rule aprepro.ll:726: "}}" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:726\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 726 "aprepro.ll"
        {
          if (begin_double_brace) {
            end_double_brace = true;
          }
          else {
            yyerror("Found an unexpected double end brace ('}}').\n\t"
                    "It can only end an expression started with a double brace ('{{').\n\tCheck "
                    "syntax.");
          }

          // Add to the history string
          save_history_string();

          if (switch_skip_to_endcase)
            BEGIN(END_CASE_SKIP);
          else
            BEGIN(if_state[if_lvl]);
          return (token::RBRACE);
        }

        YY_BREAK
      case 47: // rule aprepro.ll:746: "\\\{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:746\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 746 "aprepro.ll"
        {
          if (do_echo)
            LexerOutput("{", 1);
        }

        YY_BREAK
      case 48: // rule aprepro.ll:748: "\\\}" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:748\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 748 "aprepro.ll"
        {
          if (do_echo)
            LexerOutput("}", 1);
        }

        YY_BREAK
      case 49: // rule aprepro.ll:750: "{{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:750\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 750 "aprepro.ll"
        {
          // Check if we need to save the substitution history first.
          if (aprepro.ap_options.keep_history && (aprepro.ap_file_list.top().name != "_string_")) {
            if (curr_index > yyleng)
              hist_start = curr_index - yyleng;
            else
              hist_start = 0;
          }

          BEGIN(PARSING);
          do_echo            = false;
          begin_double_brace = true;
          return (token::LBRACE);
        }

        YY_BREAK
      case 50: // rule aprepro.ll:767: "{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:767\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 767 "aprepro.ll"
        {
          // Check if we need to save the substitution history first.
          if (aprepro.ap_options.keep_history && (aprepro.ap_file_list.top().name != "_string_")) {
            if (curr_index > yyleng)
              hist_start = curr_index - yyleng;
            else
              hist_start = 0;
          }

          BEGIN(PARSING);

          return (token::LBRACE);
        }

        YY_BREAK
      case 51: // rule aprepro.ll:783: [Ee][Xx][Ii][Tt] :
      case 52: // rule aprepro.ll:784: [Qq][Uu][Ii][Tt] :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:784\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 784 "aprepro.ll"
        {
          if (aprepro.ap_options.end_on_exit) {
            if (do_echo)
              ECHO;
            return ((token::yytokentype)-1);
          }
          else if (do_echo)
            ECHO;
        }

        YY_BREAK
      case 53: // rule aprepro.ll:794: \$ :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:794\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 794 "aprepro.ll"
        {
          if (do_echo)
            ECHO;
        }

        YY_BREAK
      case 54: // rule aprepro.ll:797: {id} :
      case 55: // rule aprepro.ll:798: . :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:798\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 798 "aprepro.ll"
        {
          if (do_echo && if_state[if_lvl] != IF_SKIP)
            ECHO;
        }

        YY_BREAK
      case 56: // rule aprepro.ll:800: "\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:800\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 800 "aprepro.ll"
        {
          if (do_echo && !suppress_nl)
            ECHO;
          suppress_nl = false;
          if (end_double_brace) {
            do_echo            = true;
            begin_double_brace = false;
            end_double_brace   = false;
          }
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      }
      break;
    case GET_FILENAME:
      matcher().pattern(PATTERN_GET_FILENAME);
      switch (matcher().scan()) {
      case 0:
        if (matcher().at_end()) {
          if (debug())
            std::cerr << "--\033[1;35mEOF\033[0m start(" << start() << ")\n";
          yyterminate();
        }
        else {
          if (debug())
            std::cerr << "--\033[1;31mdefault rule\033[0m\n";
          output(matcher().input());
        }
        YY_BREAK
      case 1: // rule aprepro.ll:525: {WS}"{"[Ee]"lse}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:525\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 525 "aprepro.ll"
        {
          aprepro.ap_file_list.top().lineno++;
          if (aprepro.ap_options.debugging)
            fprintf(stderr, "DEBUG IF: 'else'   at level = %d at line %d\n", if_lvl,
                    aprepro.ap_file_list.top().lineno);
          if (YY_START == VERBATIM) {
            if (do_echo)
              ECHO;
          }
          else if (if_state[if_lvl] == IF_SKIP) {
            if (!if_case_run[if_lvl]) {
              BEGIN(INITIAL);
              if_state[if_lvl]    = INITIAL;
              if_case_run[if_lvl] = true;
            }
            else {
              BEGIN(IF_SKIP);
              if_state[if_lvl] = IF_SKIP;
            }
          }
          else if (if_state[if_lvl] == INITIAL) {
            BEGIN(IF_SKIP);
            if_state[if_lvl] = IF_SKIP;
          }

          /* If neither is true, this is a nested
             if that should be skipped */
        }

        YY_BREAK
      case 2: // rule aprepro.ll:584: {WS}"{"[Ee]"nd"[Ii]"f}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:584\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 584 "aprepro.ll"
        {

          if (YY_START == VERBATIM) {
            if (do_echo)
              ECHO;
          }
          else {
            if (if_state[if_lvl] == IF_SKIP || if_state[if_lvl] == INITIAL) {
              BEGIN(INITIAL);
              suppress_nl = false;
            }
            /* If neither is true, this is a nested
               if that should be skipped */
            if (aprepro.ap_options.debugging)
              printf("DEBUG IF: 'endif'  at level = %d at line %d\n", if_lvl,
                     aprepro.ap_file_list.top().lineno);
            if (--if_lvl < 0) {
              if_lvl = 0;
              yyerror("Improperly Nested ifdef/ifndef statements");
            }
            /* Ignore endif if not skipping */
          }
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      case 3: // rule aprepro.ll:613: .+")"{WS}"}"{NL}* :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:613\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 613 "aprepro.ll"
        {
          aprepro.ap_file_list.top().lineno++;
          BEGIN(INITIAL);
          {
            symrec *s;
            int     quoted = 0;
            char   *pt     = strchr(yytext, ')');
            *pt            = '\0';
            /* Check to see if surrounded by double quote */
            if ((pt = strchr(yytext, '"')) != nullptr) {
              yytext++;
              quoted = 1;
            }
            if ((pt = strrchr(yytext, '"')) != nullptr) {
              *pt    = '\0';
              quoted = 1;
            }

            if (quoted == 0) {
              /* See if this is an aprepro variable referring to a name */
              s = aprepro.getsym(yytext);
              if (s == nullptr || (s->type != token::SVAR && s->type != token::IMMSVAR)) {
                pt = yytext;
              }
              else {
                pt = (char *)s->value.svar.c_str();
              }
            }
            else {
              pt = yytext;
            }

            bool added = add_include_file(pt, file_must_exist);

            if (added && !aprepro.doIncludeSubstitution)
              yy_push_state(VERBATIM);

            aprepro.ap_file_list.top().lineno++;
          }
        }

        YY_BREAK
      case 4: // rule aprepro.ll:746: "\\\{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:746\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 746 "aprepro.ll"
        {
          if (do_echo)
            LexerOutput("{", 1);
        }

        YY_BREAK
      case 5: // rule aprepro.ll:748: "\\\}" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:748\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 748 "aprepro.ll"
        {
          if (do_echo)
            LexerOutput("}", 1);
        }

        YY_BREAK
      case 6: // rule aprepro.ll:750: "{{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:750\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 750 "aprepro.ll"
        {
          // Check if we need to save the substitution history first.
          if (aprepro.ap_options.keep_history && (aprepro.ap_file_list.top().name != "_string_")) {
            if (curr_index > yyleng)
              hist_start = curr_index - yyleng;
            else
              hist_start = 0;
          }

          BEGIN(PARSING);
          do_echo            = false;
          begin_double_brace = true;
          return (token::LBRACE);
        }

        YY_BREAK
      case 7: // rule aprepro.ll:767: "{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:767\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 767 "aprepro.ll"
        {
          // Check if we need to save the substitution history first.
          if (aprepro.ap_options.keep_history && (aprepro.ap_file_list.top().name != "_string_")) {
            if (curr_index > yyleng)
              hist_start = curr_index - yyleng;
            else
              hist_start = 0;
          }

          BEGIN(PARSING);

          return (token::LBRACE);
        }

        YY_BREAK
      case 8: // rule aprepro.ll:783: [Ee][Xx][Ii][Tt] :
      case 9: // rule aprepro.ll:784: [Qq][Uu][Ii][Tt] :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:784\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 784 "aprepro.ll"
        {
          if (aprepro.ap_options.end_on_exit) {
            if (do_echo)
              ECHO;
            return ((token::yytokentype)-1);
          }
          else if (do_echo)
            ECHO;
        }

        YY_BREAK
      case 10: // rule aprepro.ll:794: \$ :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:794\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 794 "aprepro.ll"
        {
          if (do_echo)
            ECHO;
        }

        YY_BREAK
      case 11: // rule aprepro.ll:797: {id} :
      case 12: // rule aprepro.ll:798: . :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:798\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 798 "aprepro.ll"
        {
          if (do_echo && if_state[if_lvl] != IF_SKIP)
            ECHO;
        }

        YY_BREAK
      case 13: // rule aprepro.ll:800: "\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:800\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 800 "aprepro.ll"
        {
          if (do_echo && !suppress_nl)
            ECHO;
          suppress_nl = false;
          if (end_double_brace) {
            do_echo            = true;
            begin_double_brace = false;
            end_double_brace   = false;
          }
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      }
      break;
    case IF_SKIP:
      matcher().pattern(PATTERN_IF_SKIP);
      switch (matcher().scan()) {
      case 0:
        if (matcher().at_end()) {
          if (debug())
            std::cerr << "--\033[1;35mEOF\033[0m start(" << start() << ")\n";
          yyterminate();
        }
        else {
          if (debug())
            std::cerr << "--\033[1;31mdefault rule\033[0m\n";
          output(matcher().input());
        }
        YY_BREAK
      case 1: // rule aprepro.ll:500: {WS}"{"[Ii]"fdef"{WS}"(" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:500\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 500 "aprepro.ll"
        {
          if (aprepro.ap_options.debugging)
            fprintf(stderr, "DEBUG IF: 'ifdef'  found while skipping at line %d\n",
                    aprepro.ap_file_list.top().lineno);
          if_skip_level = 1;
          BEGIN(IF_WHILE_SKIP);
        }

        YY_BREAK
      case 2: // rule aprepro.ll:508: {WS}"{"[Ii]"f"{WS}"(" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:508\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 508 "aprepro.ll"
        {
          if (aprepro.ap_options.debugging)
            fprintf(stderr, "DEBUG IF: 'ifdef'  found while skipping at line %d\n",
                    aprepro.ap_file_list.top().lineno);
          if_skip_level = 1;
          BEGIN(IF_WHILE_SKIP);
        }

        YY_BREAK
      case 3: // rule aprepro.ll:516: {WS}"{"[Ii]"fndef"{WS}"(" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:516\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 516 "aprepro.ll"
        {
          if (aprepro.ap_options.debugging)
            fprintf(stderr, "DEBUG IF: 'ifndef'  found while skipping at line %d\n",
                    aprepro.ap_file_list.top().lineno);
          if_skip_level = 1;
          BEGIN(IF_WHILE_SKIP);
        }
        YY_BREAK
      case 4: // rule aprepro.ll:525: {WS}"{"[Ee]"lse}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:525\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 525 "aprepro.ll"
        {
          aprepro.ap_file_list.top().lineno++;
          if (aprepro.ap_options.debugging)
            fprintf(stderr, "DEBUG IF: 'else'   at level = %d at line %d\n", if_lvl,
                    aprepro.ap_file_list.top().lineno);
          if (YY_START == VERBATIM) {
            if (do_echo)
              ECHO;
          }
          else if (if_state[if_lvl] == IF_SKIP) {
            if (!if_case_run[if_lvl]) {
              BEGIN(INITIAL);
              if_state[if_lvl]    = INITIAL;
              if_case_run[if_lvl] = true;
            }
            else {
              BEGIN(IF_SKIP);
              if_state[if_lvl] = IF_SKIP;
            }
          }
          else if (if_state[if_lvl] == INITIAL) {
            BEGIN(IF_SKIP);
            if_state[if_lvl] = IF_SKIP;
          }

          /* If neither is true, this is a nested
             if that should be skipped */
        }

        YY_BREAK
      case 5: // rule aprepro.ll:553: {WS}"{"{WS}[Ee]"lse"[Ii]"f".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:553\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 553 "aprepro.ll"
        {
          /* If any previous 'block' of this if has executed, then
           * just skip this block; otherwise see if condition is
           * true and execute this block
           */
          if (aprepro.ap_options.debugging)
            fprintf(stderr, "DEBUG IF: 'elseif'   at level = %d at line %d\n", if_lvl,
                    aprepro.ap_file_list.top().lineno);

          if (if_case_run[if_lvl]) { /* A previous else/elseif has run */
            aprepro.ap_file_list.top().lineno++;
            /* Already in IF_SKIP, so don't need to change state */
          }
          else {
            /* Need to check the elseif condition; push back and parse */
            yyless(0);
            curr_index = 0;
            BEGIN(INITIAL);
            if_state[if_lvl] = INITIAL;
          }
        }

        YY_BREAK
      case 6: // rule aprepro.ll:574: [A-Za-z0-9_ ]* :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:574\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 574 "aprepro.ll"
        {
          ;
        }
        YY_BREAK
      case 7: // rule aprepro.ll:575: \\\{ :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:575\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 575 "aprepro.ll"
        {
          ;
        }
        YY_BREAK
      case 8: // rule aprepro.ll:576: \\\} :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:576\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 576 "aprepro.ll"
        {
          ;
        }
        YY_BREAK
      case 9: // rule aprepro.ll:577: . :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:577\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 577 "aprepro.ll"
        {
          ;
        }

        YY_BREAK
      case 10: // rule aprepro.ll:579: "\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:579\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 579 "aprepro.ll"
        {
          aprepro.ap_file_list.top().lineno++;
        }
        YY_BREAK
      case 11: // rule aprepro.ll:584: {WS}"{"[Ee]"nd"[Ii]"f}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:584\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 584 "aprepro.ll"
        {

          if (YY_START == VERBATIM) {
            if (do_echo)
              ECHO;
          }
          else {
            if (if_state[if_lvl] == IF_SKIP || if_state[if_lvl] == INITIAL) {
              BEGIN(INITIAL);
              suppress_nl = false;
            }
            /* If neither is true, this is a nested
               if that should be skipped */
            if (aprepro.ap_options.debugging)
              printf("DEBUG IF: 'endif'  at level = %d at line %d\n", if_lvl,
                     aprepro.ap_file_list.top().lineno);
            if (--if_lvl < 0) {
              if_lvl = 0;
              yyerror("Improperly Nested ifdef/ifndef statements");
            }
            /* Ignore endif if not skipping */
          }
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      case 12: // rule aprepro.ll:746: "\\\{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:746\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 746 "aprepro.ll"
        {
          if (do_echo)
            LexerOutput("{", 1);
        }

        YY_BREAK
      case 13: // rule aprepro.ll:748: "\\\}" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:748\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 748 "aprepro.ll"
        {
          if (do_echo)
            LexerOutput("}", 1);
        }

        YY_BREAK
      case 14: // rule aprepro.ll:750: "{{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:750\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 750 "aprepro.ll"
        {
          // Check if we need to save the substitution history first.
          if (aprepro.ap_options.keep_history && (aprepro.ap_file_list.top().name != "_string_")) {
            if (curr_index > yyleng)
              hist_start = curr_index - yyleng;
            else
              hist_start = 0;
          }

          BEGIN(PARSING);
          do_echo            = false;
          begin_double_brace = true;
          return (token::LBRACE);
        }

        YY_BREAK
      case 15: // rule aprepro.ll:767: "{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:767\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 767 "aprepro.ll"
        {
          // Check if we need to save the substitution history first.
          if (aprepro.ap_options.keep_history && (aprepro.ap_file_list.top().name != "_string_")) {
            if (curr_index > yyleng)
              hist_start = curr_index - yyleng;
            else
              hist_start = 0;
          }

          BEGIN(PARSING);

          return (token::LBRACE);
        }

        YY_BREAK
      case 16: // rule aprepro.ll:783: [Ee][Xx][Ii][Tt] :
      case 17: // rule aprepro.ll:784: [Qq][Uu][Ii][Tt] :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:784\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 784 "aprepro.ll"
        {
          if (aprepro.ap_options.end_on_exit) {
            if (do_echo)
              ECHO;
            return ((token::yytokentype)-1);
          }
          else if (do_echo)
            ECHO;
        }

        YY_BREAK
      case 18: // rule aprepro.ll:794: \$ :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:794\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 794 "aprepro.ll"
        {
          if (do_echo)
            ECHO;
        }

        YY_BREAK
      case 19: // rule aprepro.ll:797: {id} :
      case 20: // rule aprepro.ll:798: . :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:798\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 798 "aprepro.ll"
        {
          if (do_echo && if_state[if_lvl] != IF_SKIP)
            ECHO;
        }

        YY_BREAK
      case 21: // rule aprepro.ll:800: "\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:800\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 800 "aprepro.ll"
        {
          if (do_echo && !suppress_nl)
            ECHO;
          suppress_nl = false;
          if (end_double_brace) {
            do_echo            = true;
            begin_double_brace = false;
            end_double_brace   = false;
          }
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      }
      break;
    case GET_VAR:
      matcher().pattern(PATTERN_GET_VAR);
      switch (matcher().scan()) {
      case 0:
        if (matcher().at_end()) {
          if (debug())
            std::cerr << "--\033[1;35mEOF\033[0m start(" << start() << ")\n";
          yyterminate();
        }
        else {
          if (debug())
            std::cerr << "--\033[1;31mdefault rule\033[0m\n";
          output(matcher().input());
        }
        YY_BREAK
      case 1: // rule aprepro.ll:525: {WS}"{"[Ee]"lse}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:525\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 525 "aprepro.ll"
        {
          aprepro.ap_file_list.top().lineno++;
          if (aprepro.ap_options.debugging)
            fprintf(stderr, "DEBUG IF: 'else'   at level = %d at line %d\n", if_lvl,
                    aprepro.ap_file_list.top().lineno);
          if (YY_START == VERBATIM) {
            if (do_echo)
              ECHO;
          }
          else if (if_state[if_lvl] == IF_SKIP) {
            if (!if_case_run[if_lvl]) {
              BEGIN(INITIAL);
              if_state[if_lvl]    = INITIAL;
              if_case_run[if_lvl] = true;
            }
            else {
              BEGIN(IF_SKIP);
              if_state[if_lvl] = IF_SKIP;
            }
          }
          else if (if_state[if_lvl] == INITIAL) {
            BEGIN(IF_SKIP);
            if_state[if_lvl] = IF_SKIP;
          }

          /* If neither is true, this is a nested
             if that should be skipped */
        }

        YY_BREAK
      case 2: // rule aprepro.ll:584: {WS}"{"[Ee]"nd"[Ii]"f}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:584\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 584 "aprepro.ll"
        {

          if (YY_START == VERBATIM) {
            if (do_echo)
              ECHO;
          }
          else {
            if (if_state[if_lvl] == IF_SKIP || if_state[if_lvl] == INITIAL) {
              BEGIN(INITIAL);
              suppress_nl = false;
            }
            /* If neither is true, this is a nested
               if that should be skipped */
            if (aprepro.ap_options.debugging)
              printf("DEBUG IF: 'endif'  at level = %d at line %d\n", if_lvl,
                     aprepro.ap_file_list.top().lineno);
            if (--if_lvl < 0) {
              if_lvl = 0;
              yyerror("Improperly Nested ifdef/ifndef statements");
            }
            /* Ignore endif if not skipping */
          }
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      case 3: // rule aprepro.ll:746: "\\\{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:746\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 746 "aprepro.ll"
        {
          if (do_echo)
            LexerOutput("{", 1);
        }

        YY_BREAK
      case 4: // rule aprepro.ll:748: "\\\}" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:748\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 748 "aprepro.ll"
        {
          if (do_echo)
            LexerOutput("}", 1);
        }

        YY_BREAK
      case 5: // rule aprepro.ll:750: "{{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:750\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 750 "aprepro.ll"
        {
          // Check if we need to save the substitution history first.
          if (aprepro.ap_options.keep_history && (aprepro.ap_file_list.top().name != "_string_")) {
            if (curr_index > yyleng)
              hist_start = curr_index - yyleng;
            else
              hist_start = 0;
          }

          BEGIN(PARSING);
          do_echo            = false;
          begin_double_brace = true;
          return (token::LBRACE);
        }

        YY_BREAK
      case 6: // rule aprepro.ll:767: "{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:767\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 767 "aprepro.ll"
        {
          // Check if we need to save the substitution history first.
          if (aprepro.ap_options.keep_history && (aprepro.ap_file_list.top().name != "_string_")) {
            if (curr_index > yyleng)
              hist_start = curr_index - yyleng;
            else
              hist_start = 0;
          }

          BEGIN(PARSING);

          return (token::LBRACE);
        }

        YY_BREAK
      case 7: // rule aprepro.ll:783: [Ee][Xx][Ii][Tt] :
      case 8: // rule aprepro.ll:784: [Qq][Uu][Ii][Tt] :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:784\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 784 "aprepro.ll"
        {
          if (aprepro.ap_options.end_on_exit) {
            if (do_echo)
              ECHO;
            return ((token::yytokentype)-1);
          }
          else if (do_echo)
            ECHO;
        }

        YY_BREAK
      case 9: // rule aprepro.ll:794: \$ :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:794\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 794 "aprepro.ll"
        {
          if (do_echo)
            ECHO;
        }

        YY_BREAK
      case 10: // rule aprepro.ll:797: {id} :
      case 11: // rule aprepro.ll:798: . :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:798\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 798 "aprepro.ll"
        {
          if (do_echo && if_state[if_lvl] != IF_SKIP)
            ECHO;
        }

        YY_BREAK
      case 12: // rule aprepro.ll:800: "\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:800\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 800 "aprepro.ll"
        {
          if (do_echo && !suppress_nl)
            ECHO;
          suppress_nl = false;
          if (end_double_brace) {
            do_echo            = true;
            begin_double_brace = false;
            end_double_brace   = false;
          }
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      }
      break;
    case VERBATIM:
      matcher().pattern(PATTERN_VERBATIM);
      switch (matcher().scan()) {
      case 0:
        if (matcher().at_end()) {
          if (debug())
            std::cerr << "--\033[1;35mEOF\033[0m start(" << start() << ")\n";
          yyterminate();
        }
        else {
          if (debug())
            std::cerr << "--\033[1;31mdefault rule\033[0m\n";
          output(matcher().input());
        }
        YY_BREAK
      case 1: // rule aprepro.ll:166: "{VERBATIM(OFF)}" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:166\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 166 "aprepro.ll"
        {
          BEGIN(INITIAL);
        }
        YY_BREAK
      case 2: // rule aprepro.ll:167: [A-Za-z0-9_ ]* :
      case 3: // rule aprepro.ll:168: . :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:168\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 168 "aprepro.ll"
        {
          if (do_echo)
            ECHO;
        }
        YY_BREAK
      case 4: // rule aprepro.ll:169: "\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:169\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 169 "aprepro.ll"
        {
          if (do_echo)
            ECHO;
          aprepro.ap_file_list.top().lineno++;
        }
        YY_BREAK
      case 5: // rule aprepro.ll:525: {WS}"{"[Ee]"lse}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:525\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 525 "aprepro.ll"
        {
          aprepro.ap_file_list.top().lineno++;
          if (aprepro.ap_options.debugging)
            fprintf(stderr, "DEBUG IF: 'else'   at level = %d at line %d\n", if_lvl,
                    aprepro.ap_file_list.top().lineno);
          if (YY_START == VERBATIM) {
            if (do_echo)
              ECHO;
          }
          else if (if_state[if_lvl] == IF_SKIP) {
            if (!if_case_run[if_lvl]) {
              BEGIN(INITIAL);
              if_state[if_lvl]    = INITIAL;
              if_case_run[if_lvl] = true;
            }
            else {
              BEGIN(IF_SKIP);
              if_state[if_lvl] = IF_SKIP;
            }
          }
          else if (if_state[if_lvl] == INITIAL) {
            BEGIN(IF_SKIP);
            if_state[if_lvl] = IF_SKIP;
          }

          /* If neither is true, this is a nested
             if that should be skipped */
        }

        YY_BREAK
      case 6: // rule aprepro.ll:584: {WS}"{"[Ee]"nd"[Ii]"f}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:584\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 584 "aprepro.ll"
        {

          if (YY_START == VERBATIM) {
            if (do_echo)
              ECHO;
          }
          else {
            if (if_state[if_lvl] == IF_SKIP || if_state[if_lvl] == INITIAL) {
              BEGIN(INITIAL);
              suppress_nl = false;
            }
            /* If neither is true, this is a nested
               if that should be skipped */
            if (aprepro.ap_options.debugging)
              printf("DEBUG IF: 'endif'  at level = %d at line %d\n", if_lvl,
                     aprepro.ap_file_list.top().lineno);
            if (--if_lvl < 0) {
              if_lvl = 0;
              yyerror("Improperly Nested ifdef/ifndef statements");
            }
            /* Ignore endif if not skipping */
          }
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      case 7: // rule aprepro.ll:746: "\\\{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:746\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 746 "aprepro.ll"
        {
          if (do_echo)
            LexerOutput("{", 1);
        }

        YY_BREAK
      case 8: // rule aprepro.ll:748: "\\\}" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:748\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 748 "aprepro.ll"
        {
          if (do_echo)
            LexerOutput("}", 1);
        }

        YY_BREAK
      case 9: // rule aprepro.ll:750: "{{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:750\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 750 "aprepro.ll"
        {
          // Check if we need to save the substitution history first.
          if (aprepro.ap_options.keep_history && (aprepro.ap_file_list.top().name != "_string_")) {
            if (curr_index > yyleng)
              hist_start = curr_index - yyleng;
            else
              hist_start = 0;
          }

          BEGIN(PARSING);
          do_echo            = false;
          begin_double_brace = true;
          return (token::LBRACE);
        }

        YY_BREAK
      case 10: // rule aprepro.ll:767: "{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:767\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 767 "aprepro.ll"
        {
          // Check if we need to save the substitution history first.
          if (aprepro.ap_options.keep_history && (aprepro.ap_file_list.top().name != "_string_")) {
            if (curr_index > yyleng)
              hist_start = curr_index - yyleng;
            else
              hist_start = 0;
          }

          BEGIN(PARSING);

          return (token::LBRACE);
        }

        YY_BREAK
      case 11: // rule aprepro.ll:783: [Ee][Xx][Ii][Tt] :
      case 12: // rule aprepro.ll:784: [Qq][Uu][Ii][Tt] :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:784\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 784 "aprepro.ll"
        {
          if (aprepro.ap_options.end_on_exit) {
            if (do_echo)
              ECHO;
            return ((token::yytokentype)-1);
          }
          else if (do_echo)
            ECHO;
        }

        YY_BREAK
      case 13: // rule aprepro.ll:794: \$ :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:794\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 794 "aprepro.ll"
        {
          if (do_echo)
            ECHO;
        }

        YY_BREAK
      case 14: // rule aprepro.ll:797: {id} :
      case 15: // rule aprepro.ll:798: . :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:798\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 798 "aprepro.ll"
        {
          if (do_echo && if_state[if_lvl] != IF_SKIP)
            ECHO;
        }

        YY_BREAK
      case 16: // rule aprepro.ll:800: "\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:800\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 800 "aprepro.ll"
        {
          if (do_echo && !suppress_nl)
            ECHO;
          suppress_nl = false;
          if (end_double_brace) {
            do_echo            = true;
            begin_double_brace = false;
            end_double_brace   = false;
          }
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      }
      break;
    case IF_WHILE_SKIP:
      matcher().pattern(PATTERN_IF_WHILE_SKIP);
      switch (matcher().scan()) {
      case 0:
        if (matcher().at_end()) {
          if (debug())
            std::cerr << "--\033[1;35mEOF\033[0m start(" << start() << ")\n";
          yyterminate();
        }
        else {
          if (debug())
            std::cerr << "--\033[1;31mdefault rule\033[0m\n";
          output(matcher().input());
        }
        YY_BREAK
      case 1: // rule aprepro.ll:469: {WS}"{"[Ee]"nd"[Ii]"f}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:469\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 469 "aprepro.ll"
        {
          aprepro.ap_file_list.top().lineno++;
          if (--if_skip_level == 0)
            BEGIN(IF_SKIP);
        }

        YY_BREAK
      case 2: // rule aprepro.ll:475: {WS}"{"[Ii]"fdef"{WS}"(".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:475\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 475 "aprepro.ll"
        {
          aprepro.ap_file_list.top().lineno++;
          if_skip_level++;
        }

        YY_BREAK
      case 3: // rule aprepro.ll:480: {WS}"{"[Ii]"f"{WS}"(".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:480\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 480 "aprepro.ll"
        {
          aprepro.ap_file_list.top().lineno++;
          if_skip_level++;
        }

        YY_BREAK
      case 4: // rule aprepro.ll:485: {WS}"{"[Ii]"fndef"{WS}"(".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:485\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 485 "aprepro.ll"
        {
          aprepro.ap_file_list.top().lineno++;
          if_skip_level++;
        }

        YY_BREAK
      case 5: // rule aprepro.ll:490: .*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:490\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 490 "aprepro.ll"
        {
          aprepro.ap_file_list.top().lineno++;
        }
        YY_BREAK
      case 6: // rule aprepro.ll:525: {WS}"{"[Ee]"lse}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:525\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 525 "aprepro.ll"
        {
          aprepro.ap_file_list.top().lineno++;
          if (aprepro.ap_options.debugging)
            fprintf(stderr, "DEBUG IF: 'else'   at level = %d at line %d\n", if_lvl,
                    aprepro.ap_file_list.top().lineno);
          if (YY_START == VERBATIM) {
            if (do_echo)
              ECHO;
          }
          else if (if_state[if_lvl] == IF_SKIP) {
            if (!if_case_run[if_lvl]) {
              BEGIN(INITIAL);
              if_state[if_lvl]    = INITIAL;
              if_case_run[if_lvl] = true;
            }
            else {
              BEGIN(IF_SKIP);
              if_state[if_lvl] = IF_SKIP;
            }
          }
          else if (if_state[if_lvl] == INITIAL) {
            BEGIN(IF_SKIP);
            if_state[if_lvl] = IF_SKIP;
          }

          /* If neither is true, this is a nested
             if that should be skipped */
        }

        YY_BREAK
      case 7: // rule aprepro.ll:584: {WS}"{"[Ee]"nd"[Ii]"f}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:584\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 584 "aprepro.ll"
        {

          if (YY_START == VERBATIM) {
            if (do_echo)
              ECHO;
          }
          else {
            if (if_state[if_lvl] == IF_SKIP || if_state[if_lvl] == INITIAL) {
              BEGIN(INITIAL);
              suppress_nl = false;
            }
            /* If neither is true, this is a nested
               if that should be skipped */
            if (aprepro.ap_options.debugging)
              printf("DEBUG IF: 'endif'  at level = %d at line %d\n", if_lvl,
                     aprepro.ap_file_list.top().lineno);
            if (--if_lvl < 0) {
              if_lvl = 0;
              yyerror("Improperly Nested ifdef/ifndef statements");
            }
            /* Ignore endif if not skipping */
          }
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      case 8: // rule aprepro.ll:746: "\\\{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:746\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 746 "aprepro.ll"
        {
          if (do_echo)
            LexerOutput("{", 1);
        }

        YY_BREAK
      case 9: // rule aprepro.ll:748: "\\\}" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:748\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 748 "aprepro.ll"
        {
          if (do_echo)
            LexerOutput("}", 1);
        }

        YY_BREAK
      case 10: // rule aprepro.ll:750: "{{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:750\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 750 "aprepro.ll"
        {
          // Check if we need to save the substitution history first.
          if (aprepro.ap_options.keep_history && (aprepro.ap_file_list.top().name != "_string_")) {
            if (curr_index > yyleng)
              hist_start = curr_index - yyleng;
            else
              hist_start = 0;
          }

          BEGIN(PARSING);
          do_echo            = false;
          begin_double_brace = true;
          return (token::LBRACE);
        }

        YY_BREAK
      case 11: // rule aprepro.ll:767: "{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:767\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 767 "aprepro.ll"
        {
          // Check if we need to save the substitution history first.
          if (aprepro.ap_options.keep_history && (aprepro.ap_file_list.top().name != "_string_")) {
            if (curr_index > yyleng)
              hist_start = curr_index - yyleng;
            else
              hist_start = 0;
          }

          BEGIN(PARSING);

          return (token::LBRACE);
        }

        YY_BREAK
      case 12: // rule aprepro.ll:783: [Ee][Xx][Ii][Tt] :
      case 13: // rule aprepro.ll:784: [Qq][Uu][Ii][Tt] :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:784\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 784 "aprepro.ll"
        {
          if (aprepro.ap_options.end_on_exit) {
            if (do_echo)
              ECHO;
            return ((token::yytokentype)-1);
          }
          else if (do_echo)
            ECHO;
        }

        YY_BREAK
      case 14: // rule aprepro.ll:794: \$ :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:794\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 794 "aprepro.ll"
        {
          if (do_echo)
            ECHO;
        }

        YY_BREAK
      case 15: // rule aprepro.ll:797: {id} :
      case 16: // rule aprepro.ll:798: . :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:798\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 798 "aprepro.ll"
        {
          if (do_echo && if_state[if_lvl] != IF_SKIP)
            ECHO;
        }

        YY_BREAK
      case 17: // rule aprepro.ll:800: "\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:800\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 800 "aprepro.ll"
        {
          if (do_echo && !suppress_nl)
            ECHO;
          suppress_nl = false;
          if (end_double_brace) {
            do_echo            = true;
            begin_double_brace = false;
            end_double_brace   = false;
          }
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      }
      break;
    case GET_LOOP_VAR:
      matcher().pattern(PATTERN_GET_LOOP_VAR);
      switch (matcher().scan()) {
      case 0:
        if (matcher().at_end()) {
          if (debug())
            std::cerr << "--\033[1;35mEOF\033[0m start(" << start() << ")\n";
          yyterminate();
        }
        else {
          if (debug())
            std::cerr << "--\033[1;31mdefault rule\033[0m\n";
          output(matcher().input());
        }
        YY_BREAK
      case 1: // rule aprepro.ll:188: .+")}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:188\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 188 "aprepro.ll"
        {
          aprepro.ap_file_list.top().lineno++;
          /* `yytext` includes closing `)}` and newline...  Strip these */
          char *pt    = strchr(yytext, ')');
          *pt         = '\0';
          auto tokens = tokenize(yytext, " ,\t");
          if (aprepro.ap_options.debugging) {
            fmt::print(stderr, "DEBUG LOOP: tokens = {}\n", fmt::join(tokens, ", "));
          }

          /* Determine if the first token is a symbol or an explicit number... */
          auto count           = tokens[0];
          bool all_dig         = count.find_first_not_of("0123456789") == std::string::npos;
          int  loop_iterations = 0;
          if (all_dig) {
            loop_iterations = std::stoi(count);
          }
          else {
            symrec *s;
            if (!check_valid_var(tokens[0].c_str())) {
              aprepro.warning("Invalid variable name syntax '" + tokens[0] + "'");
              BEGIN(LOOP_SKIP);
            }
            else {
              s = aprepro.getsym(tokens[0]);
              if (s == nullptr ||
                  (s->type != token::SVAR && s->type != token::IMMSVAR && s->value.var == 0.)) {
                BEGIN(LOOP_SKIP);
              }
              else {
                loop_iterations = (int)s->value.var;
              }
            }
          }

          if (loop_iterations <= 0) {
            BEGIN(LOOP_SKIP);
            if (aprepro.ap_options.debugging) {
              fmt::print(stderr, "DEBUG LOOP: iteration count = {}, Skipping loop...\n",
                         loop_iterations);
            }
          }
          else {
            temp_f = get_temp_filename();
            SEAMS::file_rec new_file(temp_f, 0, true, loop_iterations);
            outer_file          = &aprepro.ap_file_list.top();
            new_file.loop_level = outer_file->loop_level + 1;

            // Get optional loop index...
            std::string sym_name;
            if (tokens.size() == 1) {
              // Default loop index variable name if not specified in loop command.
              sym_name = fmt::format("__loop_{}", new_file.loop_level);
            }
            else {
              sym_name = tokens[1];
            }
            SEAMS::symrec *li = aprepro.getsym(sym_name);
            if (li == nullptr) {
              li = aprepro.putsym(sym_name, SEAMS::Aprepro::SYMBOL_TYPE::VARIABLE, true);
            }

            // Get optional loop index initial value.  Default to 0 if not specified.
            double init = 0.0;
            if (tokens.size() >= 3) {
              init = std::stod(tokens[2]);
            }
            li->value.var = init;

            // Get optional loop index increment value.  Default to 1 if not specified.
            if (tokens.size() >= 4) {
              double increment        = std::stod(tokens[3]);
              new_file.loop_increment = increment;
            }

            new_file.loop_index = li;
            aprepro.ap_file_list.push(new_file);

            tmp_file = new std::fstream(temp_f, std::ios::out);
            loop_lvl++;
            BEGIN(LOOP);
            aprepro.isCollectingLoop = true;
            if (aprepro.ap_options.debugging) {
              fmt::print(stderr,
                         "DEBUG LOOP: iteration count = {}, loop_index variable = {}, initial "
                         "value = {}, increment = {}\n",
                         loop_iterations, sym_name, init, new_file.loop_increment);
            }
          }
        }
        YY_BREAK
      case 2: // rule aprepro.ll:525: {WS}"{"[Ee]"lse}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:525\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 525 "aprepro.ll"
        {
          aprepro.ap_file_list.top().lineno++;
          if (aprepro.ap_options.debugging)
            fprintf(stderr, "DEBUG IF: 'else'   at level = %d at line %d\n", if_lvl,
                    aprepro.ap_file_list.top().lineno);
          if (YY_START == VERBATIM) {
            if (do_echo)
              ECHO;
          }
          else if (if_state[if_lvl] == IF_SKIP) {
            if (!if_case_run[if_lvl]) {
              BEGIN(INITIAL);
              if_state[if_lvl]    = INITIAL;
              if_case_run[if_lvl] = true;
            }
            else {
              BEGIN(IF_SKIP);
              if_state[if_lvl] = IF_SKIP;
            }
          }
          else if (if_state[if_lvl] == INITIAL) {
            BEGIN(IF_SKIP);
            if_state[if_lvl] = IF_SKIP;
          }

          /* If neither is true, this is a nested
             if that should be skipped */
        }

        YY_BREAK
      case 3: // rule aprepro.ll:584: {WS}"{"[Ee]"nd"[Ii]"f}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:584\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 584 "aprepro.ll"
        {

          if (YY_START == VERBATIM) {
            if (do_echo)
              ECHO;
          }
          else {
            if (if_state[if_lvl] == IF_SKIP || if_state[if_lvl] == INITIAL) {
              BEGIN(INITIAL);
              suppress_nl = false;
            }
            /* If neither is true, this is a nested
               if that should be skipped */
            if (aprepro.ap_options.debugging)
              printf("DEBUG IF: 'endif'  at level = %d at line %d\n", if_lvl,
                     aprepro.ap_file_list.top().lineno);
            if (--if_lvl < 0) {
              if_lvl = 0;
              yyerror("Improperly Nested ifdef/ifndef statements");
            }
            /* Ignore endif if not skipping */
          }
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      case 4: // rule aprepro.ll:746: "\\\{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:746\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 746 "aprepro.ll"
        {
          if (do_echo)
            LexerOutput("{", 1);
        }

        YY_BREAK
      case 5: // rule aprepro.ll:748: "\\\}" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:748\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 748 "aprepro.ll"
        {
          if (do_echo)
            LexerOutput("}", 1);
        }

        YY_BREAK
      case 6: // rule aprepro.ll:750: "{{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:750\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 750 "aprepro.ll"
        {
          // Check if we need to save the substitution history first.
          if (aprepro.ap_options.keep_history && (aprepro.ap_file_list.top().name != "_string_")) {
            if (curr_index > yyleng)
              hist_start = curr_index - yyleng;
            else
              hist_start = 0;
          }

          BEGIN(PARSING);
          do_echo            = false;
          begin_double_brace = true;
          return (token::LBRACE);
        }

        YY_BREAK
      case 7: // rule aprepro.ll:767: "{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:767\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 767 "aprepro.ll"
        {
          // Check if we need to save the substitution history first.
          if (aprepro.ap_options.keep_history && (aprepro.ap_file_list.top().name != "_string_")) {
            if (curr_index > yyleng)
              hist_start = curr_index - yyleng;
            else
              hist_start = 0;
          }

          BEGIN(PARSING);

          return (token::LBRACE);
        }

        YY_BREAK
      case 8: // rule aprepro.ll:783: [Ee][Xx][Ii][Tt] :
      case 9: // rule aprepro.ll:784: [Qq][Uu][Ii][Tt] :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:784\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 784 "aprepro.ll"
        {
          if (aprepro.ap_options.end_on_exit) {
            if (do_echo)
              ECHO;
            return ((token::yytokentype)-1);
          }
          else if (do_echo)
            ECHO;
        }

        YY_BREAK
      case 10: // rule aprepro.ll:794: \$ :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:794\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 794 "aprepro.ll"
        {
          if (do_echo)
            ECHO;
        }

        YY_BREAK
      case 11: // rule aprepro.ll:797: {id} :
      case 12: // rule aprepro.ll:798: . :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:798\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 798 "aprepro.ll"
        {
          if (do_echo && if_state[if_lvl] != IF_SKIP)
            ECHO;
        }

        YY_BREAK
      case 13: // rule aprepro.ll:800: "\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:800\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 800 "aprepro.ll"
        {
          if (do_echo && !suppress_nl)
            ECHO;
          suppress_nl = false;
          if (end_double_brace) {
            do_echo            = true;
            begin_double_brace = false;
            end_double_brace   = false;
          }
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      }
      break;
    case LOOP:
      matcher().pattern(PATTERN_LOOP);
      switch (matcher().scan()) {
      case 0:
        if (matcher().at_end()) {
          if (debug())
            std::cerr << "--\033[1;35mEOF\033[0m start(" << start() << ")\n";
          yyterminate();
        }
        else {
          if (debug())
            std::cerr << "--\033[1;31mdefault rule\033[0m\n";
          output(matcher().input());
        }
        YY_BREAK
      case 1: // rule aprepro.ll:279: {WS}"{"[Ee]"nd"[Ll]"oop".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:279\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 279 "aprepro.ll"
        {
          outer_file->lineno++;
          if (loop_lvl > 0)
            --loop_lvl;

          if (loop_lvl == 0) {
            BEGIN(INITIAL);
            tmp_file->close();
            delete tmp_file;

            if (!aprepro.doLoopSubstitution)
              yy_push_state(VERBATIM);

            aprepro.isCollectingLoop = false;

            yyin = aprepro.open_file(aprepro.ap_file_list.top().name, "r");
            FlexLexer::yypush_buffer_state(FlexLexer::yy_create_buffer(yyin, YY_BUF_SIZE));
            curr_index = 0;
          }
          else {
            (*tmp_file) << yytext;
          }
        }

        YY_BREAK
      case 2: // rule aprepro.ll:303: {WS}"{"[Ll]"oop"{WS}"(".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:303\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 303 "aprepro.ll"
        {
          loop_lvl++; /* Nested Loop */
          (*tmp_file) << yytext;
          outer_file->lineno++;
        }

        YY_BREAK
      case 3: // rule aprepro.ll:309: {WS}"{"[Aa]"bort"[Ll]"oop".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:309\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 309 "aprepro.ll"
        {
          if (aprepro.ap_options.interactive || aprepro.string_interactive()) {
            aprepro.warning("Aborting loop(s).", false);

            // Leave the looping state and remove the loop file
            BEGIN(INITIAL);
            tmp_file->close();
            delete tmp_file;

            if (aprepro.ap_file_list.top().tmp_file) {
              remove(aprepro.ap_file_list.top().name.c_str());
              aprepro.ap_file_list.pop();
            }

            loop_lvl                 = 0;
            aprepro.isCollectingLoop = false;
          }
        }

        YY_BREAK
      case 4: // rule aprepro.ll:330: .*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:330\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 330 "aprepro.ll"
        {
          (*tmp_file) << yytext;
          outer_file->lineno++;
        }
        YY_BREAK
      case 5: // rule aprepro.ll:525: {WS}"{"[Ee]"lse}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:525\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 525 "aprepro.ll"
        {
          aprepro.ap_file_list.top().lineno++;
          if (aprepro.ap_options.debugging)
            fprintf(stderr, "DEBUG IF: 'else'   at level = %d at line %d\n", if_lvl,
                    aprepro.ap_file_list.top().lineno);
          if (YY_START == VERBATIM) {
            if (do_echo)
              ECHO;
          }
          else if (if_state[if_lvl] == IF_SKIP) {
            if (!if_case_run[if_lvl]) {
              BEGIN(INITIAL);
              if_state[if_lvl]    = INITIAL;
              if_case_run[if_lvl] = true;
            }
            else {
              BEGIN(IF_SKIP);
              if_state[if_lvl] = IF_SKIP;
            }
          }
          else if (if_state[if_lvl] == INITIAL) {
            BEGIN(IF_SKIP);
            if_state[if_lvl] = IF_SKIP;
          }

          /* If neither is true, this is a nested
             if that should be skipped */
        }

        YY_BREAK
      case 6: // rule aprepro.ll:584: {WS}"{"[Ee]"nd"[Ii]"f}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:584\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 584 "aprepro.ll"
        {

          if (YY_START == VERBATIM) {
            if (do_echo)
              ECHO;
          }
          else {
            if (if_state[if_lvl] == IF_SKIP || if_state[if_lvl] == INITIAL) {
              BEGIN(INITIAL);
              suppress_nl = false;
            }
            /* If neither is true, this is a nested
               if that should be skipped */
            if (aprepro.ap_options.debugging)
              printf("DEBUG IF: 'endif'  at level = %d at line %d\n", if_lvl,
                     aprepro.ap_file_list.top().lineno);
            if (--if_lvl < 0) {
              if_lvl = 0;
              yyerror("Improperly Nested ifdef/ifndef statements");
            }
            /* Ignore endif if not skipping */
          }
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      case 7: // rule aprepro.ll:746: "\\\{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:746\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 746 "aprepro.ll"
        {
          if (do_echo)
            LexerOutput("{", 1);
        }

        YY_BREAK
      case 8: // rule aprepro.ll:748: "\\\}" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:748\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 748 "aprepro.ll"
        {
          if (do_echo)
            LexerOutput("}", 1);
        }

        YY_BREAK
      case 9: // rule aprepro.ll:750: "{{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:750\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 750 "aprepro.ll"
        {
          // Check if we need to save the substitution history first.
          if (aprepro.ap_options.keep_history && (aprepro.ap_file_list.top().name != "_string_")) {
            if (curr_index > yyleng)
              hist_start = curr_index - yyleng;
            else
              hist_start = 0;
          }

          BEGIN(PARSING);
          do_echo            = false;
          begin_double_brace = true;
          return (token::LBRACE);
        }

        YY_BREAK
      case 10: // rule aprepro.ll:767: "{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:767\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 767 "aprepro.ll"
        {
          // Check if we need to save the substitution history first.
          if (aprepro.ap_options.keep_history && (aprepro.ap_file_list.top().name != "_string_")) {
            if (curr_index > yyleng)
              hist_start = curr_index - yyleng;
            else
              hist_start = 0;
          }

          BEGIN(PARSING);

          return (token::LBRACE);
        }

        YY_BREAK
      case 11: // rule aprepro.ll:783: [Ee][Xx][Ii][Tt] :
      case 12: // rule aprepro.ll:784: [Qq][Uu][Ii][Tt] :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:784\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 784 "aprepro.ll"
        {
          if (aprepro.ap_options.end_on_exit) {
            if (do_echo)
              ECHO;
            return ((token::yytokentype)-1);
          }
          else if (do_echo)
            ECHO;
        }

        YY_BREAK
      case 13: // rule aprepro.ll:794: \$ :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:794\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 794 "aprepro.ll"
        {
          if (do_echo)
            ECHO;
        }

        YY_BREAK
      case 14: // rule aprepro.ll:797: {id} :
      case 15: // rule aprepro.ll:798: . :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:798\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 798 "aprepro.ll"
        {
          if (do_echo && if_state[if_lvl] != IF_SKIP)
            ECHO;
        }

        YY_BREAK
      case 16: // rule aprepro.ll:800: "\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:800\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 800 "aprepro.ll"
        {
          if (do_echo && !suppress_nl)
            ECHO;
          suppress_nl = false;
          if (end_double_brace) {
            do_echo            = true;
            begin_double_brace = false;
            end_double_brace   = false;
          }
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      }
      break;
    case LOOP_SKIP:
      matcher().pattern(PATTERN_LOOP_SKIP);
      switch (matcher().scan()) {
      case 0:
        if (matcher().at_end()) {
          if (debug())
            std::cerr << "--\033[1;35mEOF\033[0m start(" << start() << ")\n";
          yyterminate();
        }
        else {
          if (debug())
            std::cerr << "--\033[1;31mdefault rule\033[0m\n";
          output(matcher().input());
        }
        YY_BREAK
      case 1: // rule aprepro.ll:337: {WS}"{"[Ee]"nd"[Ll]"oop".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:337\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 337 "aprepro.ll"
        {
          aprepro.ap_file_list.top().lineno++;
          if (loop_lvl > 0)
            --loop_lvl;

          if (loop_lvl == 0) {
            BEGIN(INITIAL);
            aprepro.isCollectingLoop = false;
          }
        }

        YY_BREAK
      case 2: // rule aprepro.ll:348: {WS}"{"[Ll]"oop"{WS}"(".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:348\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 348 "aprepro.ll"
        {
          loop_lvl++; /* Nested Loop */
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      case 3: // rule aprepro.ll:353: {WS}"{"[Aa]"bort"[Ll]"oop".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:353\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 353 "aprepro.ll"
        {
          if (aprepro.ap_options.interactive || aprepro.string_interactive()) {
            aprepro.warning("Aborting loops(s).", false);

            // Leave the looping state
            BEGIN(INITIAL);

            loop_lvl                 = 0;
            aprepro.isCollectingLoop = false;
          }
        }

        YY_BREAK
      case 4: // rule aprepro.ll:367: .*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:367\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 367 "aprepro.ll"
        { /* Do not increment line count */
          ;
        }
        YY_BREAK
      case 5: // rule aprepro.ll:525: {WS}"{"[Ee]"lse}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:525\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 525 "aprepro.ll"
        {
          aprepro.ap_file_list.top().lineno++;
          if (aprepro.ap_options.debugging)
            fprintf(stderr, "DEBUG IF: 'else'   at level = %d at line %d\n", if_lvl,
                    aprepro.ap_file_list.top().lineno);
          if (YY_START == VERBATIM) {
            if (do_echo)
              ECHO;
          }
          else if (if_state[if_lvl] == IF_SKIP) {
            if (!if_case_run[if_lvl]) {
              BEGIN(INITIAL);
              if_state[if_lvl]    = INITIAL;
              if_case_run[if_lvl] = true;
            }
            else {
              BEGIN(IF_SKIP);
              if_state[if_lvl] = IF_SKIP;
            }
          }
          else if (if_state[if_lvl] == INITIAL) {
            BEGIN(IF_SKIP);
            if_state[if_lvl] = IF_SKIP;
          }

          /* If neither is true, this is a nested
             if that should be skipped */
        }

        YY_BREAK
      case 6: // rule aprepro.ll:584: {WS}"{"[Ee]"nd"[Ii]"f}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:584\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 584 "aprepro.ll"
        {

          if (YY_START == VERBATIM) {
            if (do_echo)
              ECHO;
          }
          else {
            if (if_state[if_lvl] == IF_SKIP || if_state[if_lvl] == INITIAL) {
              BEGIN(INITIAL);
              suppress_nl = false;
            }
            /* If neither is true, this is a nested
               if that should be skipped */
            if (aprepro.ap_options.debugging)
              printf("DEBUG IF: 'endif'  at level = %d at line %d\n", if_lvl,
                     aprepro.ap_file_list.top().lineno);
            if (--if_lvl < 0) {
              if_lvl = 0;
              yyerror("Improperly Nested ifdef/ifndef statements");
            }
            /* Ignore endif if not skipping */
          }
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      case 7: // rule aprepro.ll:746: "\\\{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:746\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 746 "aprepro.ll"
        {
          if (do_echo)
            LexerOutput("{", 1);
        }

        YY_BREAK
      case 8: // rule aprepro.ll:748: "\\\}" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:748\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 748 "aprepro.ll"
        {
          if (do_echo)
            LexerOutput("}", 1);
        }

        YY_BREAK
      case 9: // rule aprepro.ll:750: "{{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:750\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 750 "aprepro.ll"
        {
          // Check if we need to save the substitution history first.
          if (aprepro.ap_options.keep_history && (aprepro.ap_file_list.top().name != "_string_")) {
            if (curr_index > yyleng)
              hist_start = curr_index - yyleng;
            else
              hist_start = 0;
          }

          BEGIN(PARSING);
          do_echo            = false;
          begin_double_brace = true;
          return (token::LBRACE);
        }

        YY_BREAK
      case 10: // rule aprepro.ll:767: "{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:767\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 767 "aprepro.ll"
        {
          // Check if we need to save the substitution history first.
          if (aprepro.ap_options.keep_history && (aprepro.ap_file_list.top().name != "_string_")) {
            if (curr_index > yyleng)
              hist_start = curr_index - yyleng;
            else
              hist_start = 0;
          }

          BEGIN(PARSING);

          return (token::LBRACE);
        }

        YY_BREAK
      case 11: // rule aprepro.ll:783: [Ee][Xx][Ii][Tt] :
      case 12: // rule aprepro.ll:784: [Qq][Uu][Ii][Tt] :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:784\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 784 "aprepro.ll"
        {
          if (aprepro.ap_options.end_on_exit) {
            if (do_echo)
              ECHO;
            return ((token::yytokentype)-1);
          }
          else if (do_echo)
            ECHO;
        }

        YY_BREAK
      case 13: // rule aprepro.ll:794: \$ :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:794\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 794 "aprepro.ll"
        {
          if (do_echo)
            ECHO;
        }

        YY_BREAK
      case 14: // rule aprepro.ll:797: {id} :
      case 15: // rule aprepro.ll:798: . :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:798\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 798 "aprepro.ll"
        {
          if (do_echo && if_state[if_lvl] != IF_SKIP)
            ECHO;
        }

        YY_BREAK
      case 16: // rule aprepro.ll:800: "\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:800\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 800 "aprepro.ll"
        {
          if (do_echo && !suppress_nl)
            ECHO;
          suppress_nl = false;
          if (end_double_brace) {
            do_echo            = true;
            begin_double_brace = false;
            end_double_brace   = false;
          }
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      }
      break;
    case END_CASE_SKIP:
      matcher().pattern(PATTERN_END_CASE_SKIP);
      switch (matcher().scan()) {
      case 0:
        if (matcher().at_end()) {
          if (debug())
            std::cerr << "--\033[1;35mEOF\033[0m start(" << start() << ")\n";
          yyterminate();
        }
        else {
          if (debug())
            std::cerr << "--\033[1;31mdefault rule\033[0m\n";
          output(matcher().input());
        }
        YY_BREAK
      case 1: // rule aprepro.ll:372: {WS}"{"{WS}"case".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:372\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 372 "aprepro.ll"
        {
          yyless(0);
          curr_index = 0;
          BEGIN(INITIAL);
          switch_skip_to_endcase = false;
        }

        YY_BREAK
      case 2: // rule aprepro.ll:379: {WS}"{"{WS}"default"{WS}"}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:379\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 379 "aprepro.ll"
        {
          if (!switch_active) {
            yyerror("default statement found outside switch statement.");
          }

          if (!switch_case_run) {
            switch_case_run = true;
            BEGIN(INITIAL);
            switch_skip_to_endcase = false;
            if (aprepro.ap_options.debugging)
              fprintf(stderr, "DEBUG SWITCH: 'default' code executing at line %d\n",
                      aprepro.ap_file_list.top().lineno);
          }
          else {
            if (aprepro.ap_options.debugging)
              fprintf(stderr,
                      "DEBUG SWITCH: 'default' not executing since a previous case already ran at "
                      "line %d\n",
                      aprepro.ap_file_list.top().lineno);

            /* Need to skip all code until end of case */
            BEGIN(END_CASE_SKIP);
          }
        }

        YY_BREAK
      case 3: // rule aprepro.ll:402: {WS}"{"{WS}"endswitch"{WS}"}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:402\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 402 "aprepro.ll"
        {
          aprepro.ap_file_list.top().lineno++;
          BEGIN(INITIAL);
          switch_active          = false;
          switch_skip_to_endcase = false;
          suppress_nl            = false;
          if (aprepro.ap_options.debugging)
            fprintf(stderr, "DEBUG SWITCH: 'endswitch' at line %d\n",
                    aprepro.ap_file_list.top().lineno);
        }

        YY_BREAK
      case 4: // rule aprepro.ll:413: .*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:413\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 413 "aprepro.ll"
        {
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      case 5: // rule aprepro.ll:525: {WS}"{"[Ee]"lse}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:525\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 525 "aprepro.ll"
        {
          aprepro.ap_file_list.top().lineno++;
          if (aprepro.ap_options.debugging)
            fprintf(stderr, "DEBUG IF: 'else'   at level = %d at line %d\n", if_lvl,
                    aprepro.ap_file_list.top().lineno);
          if (YY_START == VERBATIM) {
            if (do_echo)
              ECHO;
          }
          else if (if_state[if_lvl] == IF_SKIP) {
            if (!if_case_run[if_lvl]) {
              BEGIN(INITIAL);
              if_state[if_lvl]    = INITIAL;
              if_case_run[if_lvl] = true;
            }
            else {
              BEGIN(IF_SKIP);
              if_state[if_lvl] = IF_SKIP;
            }
          }
          else if (if_state[if_lvl] == INITIAL) {
            BEGIN(IF_SKIP);
            if_state[if_lvl] = IF_SKIP;
          }

          /* If neither is true, this is a nested
             if that should be skipped */
        }

        YY_BREAK
      case 6: // rule aprepro.ll:584: {WS}"{"[Ee]"nd"[Ii]"f}".*"\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:584\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 584 "aprepro.ll"
        {

          if (YY_START == VERBATIM) {
            if (do_echo)
              ECHO;
          }
          else {
            if (if_state[if_lvl] == IF_SKIP || if_state[if_lvl] == INITIAL) {
              BEGIN(INITIAL);
              suppress_nl = false;
            }
            /* If neither is true, this is a nested
               if that should be skipped */
            if (aprepro.ap_options.debugging)
              printf("DEBUG IF: 'endif'  at level = %d at line %d\n", if_lvl,
                     aprepro.ap_file_list.top().lineno);
            if (--if_lvl < 0) {
              if_lvl = 0;
              yyerror("Improperly Nested ifdef/ifndef statements");
            }
            /* Ignore endif if not skipping */
          }
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      case 7: // rule aprepro.ll:746: "\\\{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:746\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 746 "aprepro.ll"
        {
          if (do_echo)
            LexerOutput("{", 1);
        }

        YY_BREAK
      case 8: // rule aprepro.ll:748: "\\\}" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:748\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 748 "aprepro.ll"
        {
          if (do_echo)
            LexerOutput("}", 1);
        }

        YY_BREAK
      case 9: // rule aprepro.ll:750: "{{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:750\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 750 "aprepro.ll"
        {
          // Check if we need to save the substitution history first.
          if (aprepro.ap_options.keep_history && (aprepro.ap_file_list.top().name != "_string_")) {
            if (curr_index > yyleng)
              hist_start = curr_index - yyleng;
            else
              hist_start = 0;
          }

          BEGIN(PARSING);
          do_echo            = false;
          begin_double_brace = true;
          return (token::LBRACE);
        }

        YY_BREAK
      case 10: // rule aprepro.ll:767: "{" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:767\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 767 "aprepro.ll"
        {
          // Check if we need to save the substitution history first.
          if (aprepro.ap_options.keep_history && (aprepro.ap_file_list.top().name != "_string_")) {
            if (curr_index > yyleng)
              hist_start = curr_index - yyleng;
            else
              hist_start = 0;
          }

          BEGIN(PARSING);

          return (token::LBRACE);
        }

        YY_BREAK
      case 11: // rule aprepro.ll:783: [Ee][Xx][Ii][Tt] :
      case 12: // rule aprepro.ll:784: [Qq][Uu][Ii][Tt] :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:784\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 784 "aprepro.ll"
        {
          if (aprepro.ap_options.end_on_exit) {
            if (do_echo)
              ECHO;
            return ((token::yytokentype)-1);
          }
          else if (do_echo)
            ECHO;
        }

        YY_BREAK
      case 13: // rule aprepro.ll:794: \$ :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:794\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 794 "aprepro.ll"
        {
          if (do_echo)
            ECHO;
        }

        YY_BREAK
      case 14: // rule aprepro.ll:797: {id} :
      case 15: // rule aprepro.ll:798: . :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:798\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 798 "aprepro.ll"
        {
          if (do_echo && if_state[if_lvl] != IF_SKIP)
            ECHO;
        }

        YY_BREAK
      case 16: // rule aprepro.ll:800: "\n" :
        if (debug())
          std::cerr << "--\033[1;35mrule aprepro.ll:800\033[0m start(" << start() << ") "
                    << matcher().lineno() << "," << matcher().columno() << ":\"\033[1m"
                    << matcher().text() << "\033[0m\"\n";
        YY_USER_ACTION
#line 800 "aprepro.ll"
        {
          if (do_echo && !suppress_nl)
            ECHO;
          suppress_nl = false;
          if (end_double_brace) {
            do_echo            = true;
            begin_double_brace = false;
            end_double_brace   = false;
          }
          aprepro.ap_file_list.top().lineno++;
        }

        YY_BREAK
      }
      break;
    default: start(0);
    }
  }
}

////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//  SECTION 3: user code                                                      //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

#line 810 "aprepro.ll"

/* When the scanner receives an end-of-file indication from YY_INPUT, it then
 * checks the yywrap() function. If yywrap() returns false (zero), then it is
 * assumed that the function has gone ahead and set up `yyin' to point to
 * another input file, and scanning continues. If it returns true (non-zero),
 * then the scanner terminates, returning 0 to its caller. */

namespace SEAMS {

  Scanner::~Scanner()
  {
    while (aprepro.ap_file_list.size() > 1) {
      auto kk = aprepro.ap_file_list.top();
      if (kk.name != "STDIN") {
        FlexLexer::yy_load_buffer_state();
      }
      aprepro.ap_file_list.pop();
      FlexLexer::yypop_buffer_state();
    };
  }

  bool Scanner::add_include_file(const std::string &filename, bool must_exist)
  {
    std::fstream *yytmp = nullptr;
    if (must_exist)
      yytmp = aprepro.open_file(filename, "r");
    else
      yytmp = aprepro.check_open_file(filename, "r");

    if (yytmp) {
      if (yyin && !yy_init) {
        FlexLexer::yypush_buffer_state(FlexLexer::yy_create_buffer(yyin, YY_BUF_SIZE));
      }

      yyin = yytmp;
      aprepro.info("Included File: '" + filename + "'", true);

      SEAMS::file_rec new_file(filename.c_str(), 0, false, 0);
      aprepro.ap_file_list.push(new_file);

      FlexLexer::yypush_buffer_state(FlexLexer::yy_create_buffer(yytmp, YY_BUF_SIZE));
      curr_index = 0;
    }
    return yytmp != nullptr;
  }

  void Scanner::LexerOutput(const char *buf, size_t size)
  {
    // Do this before writing so that we have the correct index in the
    // output stream.
    if (aprepro.ap_options.keep_history) {
      aprepro.add_history(history_string, buf);
      history_string.clear();
      hist_start = 0;
    }

    aprepro.outputStream.top()->write(buf, size);
    if (aprepro.ap_options.interactive && aprepro.outputStream.size() == 1) {
      // In interactive mode, output to stdout in addition to the
      // output stream, unless user has redirected output...
      std::cout << buf;
    }
  }

  size_t Scanner::LexerInput(char *buf, size_t max_size)
  {
    if (yyin.eof() || yyin.fail()) {
      return 0;
    }

    if (aprepro.ap_options.interactive && yyin == &std::cin && isatty(0) != 0 && isatty(1) != 0) {
      char *line = SEAMS::getline_int(nullptr);

      if (strlen(line) == 0) {
        return 0;
      }

      if (!string_is_ascii(line, strlen(line))) {
        aprepro.warning("input line contains non-ASCII (probably UTF-8) characters which might be "
                        "parsed incorrectly.");
      }

      SEAMS::gl_histadd(line);

      if (strlen(line) > (size_t)max_size - 2) {
        yyerror("input line is too long");
        return 0;
      }

      strcpy(buf, line);
      strcat(buf, "\n");

      return strlen(buf);
    }
    else {
      (void)yyin.read(buf, max_size);

      if (yyin.bad()) {
        return -1;
      }
      else {
        if (!string_is_ascii(buf, yyin.gcount())) {
          aprepro.warning("input file contains non-ASCII (probably UTF-8) characters which will "
                          "might be parsed incorrectly.");
        }
        return yyin.gcount();
      }
    }
  }

  int Scanner::yywrap()
  {
    // Clear the history string.
    history_string.clear();
    hist_start = 0;
    curr_index = 0;

    // If we are using the string interactive method, we want to return to
    // our original state if parsing was cutoff prematurely.
    if (aprepro.string_interactive() && YY_START == PARSING) {
      if (switch_skip_to_endcase) {
        BEGIN(END_CASE_SKIP);
      }
      else {
        BEGIN(if_state[if_lvl]);
      }
    }

    if (aprepro.ap_file_list.size() <= 1) { /* End of main file, not in nested include */
      return (1);
    }
    else if (aprepro.string_interactive() && loop_lvl) {
      return (1);
    }
    else if (aprepro.isCollectingLoop) {
      yyerror("End-of-file detected inside loop. Check loop syntax. {endloop} must be on line by "
              "itself.");
      return (1);
    }
    else {
      /* We are in an included or looping file */
      if (aprepro.ap_file_list.top().tmp_file) {
        if (aprepro.ap_options.debugging) {
          std::cerr << "DEBUG LOOP: Loop count = " << aprepro.ap_file_list.top().loop_count << "\n";
        }
        if (--aprepro.ap_file_list.top().loop_count <= 0) {
          // On Windows, you can't remove the temp file until all the references to the
          // file object have been released, so we will delete it here.

          if (aprepro.ap_file_list.top().name != "_string_") {
            if (!aprepro.ap_options.debugging) {
              remove(aprepro.ap_file_list.top().name.c_str()); /* Delete file if temporary */
            }
            if (!aprepro.doLoopSubstitution) {
              yy_pop_state();
            }
          }

          aprepro.ap_file_list.pop();
          FlexLexer::yypop_buffer_state();
        }
        else {
          // Do not pop ap_file_list; we are rereading that file...
          FlexLexer::yypop_buffer_state();
          yyin = aprepro.open_file(aprepro.ap_file_list.top().name, "r");
          FlexLexer::yypush_buffer_state(FlexLexer::yy_create_buffer(yyin, YY_BUF_SIZE));
          aprepro.ap_file_list.top().lineno = 0;

          if (aprepro.ap_file_list.top().loop_index != nullptr) {
            aprepro.ap_file_list.top().loop_index->value.var +=
                aprepro.ap_file_list.top().loop_increment;
          }
        }
      }
      else {
        aprepro.ap_file_list.pop();
        FlexLexer::yypop_buffer_state();

        if (aprepro.ap_file_list.top().name == "standard input") {
          yyin = &std::cin;
        }

        /* Turn echoing back on at end of included files. */
        do_echo = true;

        // If we are not doing aprepro substitutions for the included file, but
        // just collecting lines, pop the state from VERBATIM back to what it
        // was previously.
        if (!aprepro.doIncludeSubstitution) {
          yy_pop_state();
        }

        /* Set immutable mode back to global immutable
         * state at end of included file*/
        aprepro.stateImmutable = aprepro.ap_options.immutable;
      }

      // Reset the current character index.
      curr_index = 0;
      if (yyin != nullptr) {
        curr_index = yyin.tellg();
      }

      return (0);
    }
  }

  /* Print error message to standard error and return.  Note: internally
   *   'lineno' starts at zero.  To avoid confusion, we add 1 to value
   *   when it is output.
   */

  void Scanner::yyerror(const char *s) { aprepro.error(s); }

  char *Scanner::execute(char string[])
  {
    /* Push the contents of 'string' onto the stack to be reread.
     * 'string' will be surrounded by {} so it must be a valid expression.
     */

    /*
     * NOTE: The closing } has not yet been scanned in the call to execute();
     *       therefore, we read it ourselves using input(), then we push:
     *       '}{' + our string + '}'
     */
    int i;
    while ((i = FlexLexer::yyinput()) != '}' && i != EOF)
      curr_index++; /* eat up values */

    // Increment curr_index to account for the '}' and save history
    curr_index++;
    save_history_string();

    /* Allocate space for string + '}' + '{' + end_of_string */
    std::string new_string;
    new_string += "}{";
    new_string += string;
    new_string += "}";

    aprepro.ap_file_list.push(SEAMS::file_rec("_string_", 0, true, -1));

    auto ins = new std::istringstream(new_string); // Declare an input string stream.
    FlexLexer::yypush_buffer_state(FlexLexer::yy_create_buffer(ins, new_string.size()));
    return (nullptr);
  }

  /* Push the contents of 'string' onto the stack to be reread.
   * 'string' will not be surrounded by {}.
   */

  char *Scanner::rescan(char *string)
  {
    int i;
    /*
     * NOTE: The closing } has not yet been scanned in the call to rescan();
     *       therefore, we read it ourselves using input(), then we push our
     *       string and then put the closing } back on the stack last
     *       (to be read first),
     */
    while ((i = FlexLexer::yyinput()) != '}' && i != EOF)
      curr_index++; /* eat up values */

    // Increment curr_index to account for the '}' and save history
    curr_index++;
    save_history_string();

    {
      aprepro.ap_file_list.push(SEAMS::file_rec("_string_", 0, true, -1));
      std::string new_string("}");
      new_string += string;

      auto ins = new std::istringstream(new_string); // Declare an input string stream.
      FlexLexer::yypush_buffer_state(FlexLexer::yy_create_buffer(ins, new_string.size()));
    }
    return (nullptr);
  }

  char *Scanner::import_handler(char *string)
  {
    /*
     * NOTE: The closing } has not yet been scanned in the call to rescan();
     *       therefore, we read it ourselves using input().
     */
    int i = 0;
    while ((i = FlexLexer::yyinput()) != '}' && i != EOF)
      curr_index++; /* eat up values */

    add_include_file(string, true);
    std::string info_string = std::string("Imported File: '") + string + "'";
    aprepro.info(info_string, true);

    if (!aprepro.doIncludeSubstitution) {
      yy_push_state(VERBATIM);
    }

    /*
     * Now we need to push back the closing } so it is the first thing read.
     * We no longer have the initial file stream (is is pushed down on stack)
     * so we need to add a new file stream consisting of just a single character.
     * Wasteful, but best I can come up with at this time.
     */
    aprepro.ap_file_list.push(SEAMS::file_rec("_string_", 0, true, -1));
    std::string new_string("}");
    auto        ins = new std::istringstream(new_string); // Declare an input string stream.
    FlexLexer::yypush_buffer_state(FlexLexer::yy_create_buffer(ins, new_string.size()));

    if (aprepro.ap_options.debugging) {
      std::cerr << "DEBUG IMPORT: " << string << "\n";
    }
    return (nullptr);
  }

  char *Scanner::if_handler(double x)
  {
    if_lvl++;
    if (if_lvl >= MAX_IF_NESTING) {
      yyerror("Too many nested if statements");
    }
    else {
      if (x == 0) {
        if_state[if_lvl]    = IF_SKIP;
        if_case_run[if_lvl] = false;
      }
      else {
        suppress_nl         = true;
        if_state[if_lvl]    = INITIAL;
        if_case_run[if_lvl] = true;
      }
      if (aprepro.ap_options.debugging) {
        std::cerr << "DEBUG IF: If level " << if_lvl << " " << if_state[if_lvl] << "\n";
      }
    }
    return (nullptr);
  }

  char *Scanner::elseif_handler(double x)
  {
    if (x == 0 || if_case_run[if_lvl]) {
      if_state[if_lvl] = IF_SKIP;
    }
    else {
      suppress_nl         = 1;
      if_state[if_lvl]    = INITIAL;
      if_case_run[if_lvl] = true;
    }
    if (aprepro.ap_options.debugging) {
      std::cerr << "DEBUG IF: elseif at level " << if_lvl << " " << if_state[if_lvl] << "\n";
    }
    return (nullptr);
  }

  char *Scanner::switch_handler(double x)
  {
    // save that we are in a switch statement
    // save the value of 'x' for use in deciding which case to execute
    if (switch_active) {
      yyerror("switch statement found while switch already active. Nested switch not supported.");
    }

    switch_active          = true;
    switch_case_run        = false;
    switch_condition       = x;
    switch_skip_to_endcase = true; /* Skip everything until first case */
    suppress_nl            = true;

    if (aprepro.ap_options.debugging) {
      std::cerr << "DEBUG SWITCH: 'switch' with condition = " << switch_condition << " at line "
                << aprepro.ap_file_list.top().lineno << "\n";
    }
    return (nullptr);
  }

  char *Scanner::case_handler(double x)
  {
    // make sure we are in a switch statement
    // if 'x' matches the value saved in the switch statement
    // and no other case has been executed, then
    // execute the code in the case and set a flag indicating
    // the switch has run;
    // if 'x' does not match the value saved, then skip to endcase
    suppress_nl = true;

    if (!switch_active) {
      yyerror("case statement found outside switch statement.");
    }

    if (!switch_case_run && x == switch_condition) {
      switch_case_run = true;
      if (aprepro.ap_options.debugging) {
        fprintf(stderr,
                "DEBUG SWITCH: 'case' condition = %g matches switch condition = %g at line %d\n", x,
                switch_condition, aprepro.ap_file_list.top().lineno);
      }
    }
    else {
      if (aprepro.ap_options.debugging) {
        fprintf(stderr,
                "DEBUG SWITCH: 'case' condition = %g does not match switch condition = %g "
                "(or case already matched) at line %d\n",
                x, switch_condition, aprepro.ap_file_list.top().lineno);
      }

      // Need to skip all code until end of case
      switch_skip_to_endcase = true;
    }
    return (nullptr);
  }

  void Scanner::save_history_string()
  {
    if (!aprepro.ap_options.keep_history) {
      return;
    }

    // Don't do it if the file is the one used by execute and rescan.
    if (aprepro.ap_file_list.top().name == "_string_" ||
        aprepro.ap_file_list.top().name == "standard input") {
      return;
    }

    size_t hist_end = curr_index;
    size_t len      = hist_end - hist_start;

    if (len <= 0)
      return;

    // Clear any possible end-of-stream if e.g., reading from a istringstream.
    std::ios::iostate state = yyin.rdstate();
    size_t            loc   = yyin.tellg();
    yyin.clear();

    // Go back in the stream to where we started keeping history.
    yyin.seekg(hist_start);
    if (!yyin.good()) {
      yyerror("Stream state bad in `save_history_string` seekg");
      return;
    }

    // Read everything up to this point again and save it.
    auto tmp = new char[len + 1];
    yyin.read(tmp, len);
    if (!yyin.good()) {
      yyerror("Stream state bad in `save_history_string` read");
      return;
    }
    tmp[len] = '\0';

    history_string = tmp;
    delete[] tmp;
    hist_start = 0;

    // restore stream state
    yyin.seekg(loc);
    yyin.setstate(state);
  }
} // namespace SEAMS

/* This implementation of SEAMSFlexLexer::yylex() is required to fill the
 * vtable of the class SEAMSFlexLexer. We define the scanner's main yylex
 * function via YY_DECL to reside in the Scanner class instead. */

#ifdef yylex
#undef yylex
#endif
int FlexLexer::yylex()
{
  std::cerr << "in SEAMSFlexLexer::yylex() !" << '\n';
  return 0;
}

/* When the scanner receives an end-of-file indication from YY_INPUT, it then
 * checks the yywrap() function. If yywrap() returns false (zero), then it is
 * assumed that the function has gone ahead and set up `yyin' to point to
 * another input file, and scanning continues. If it returns true (non-zero),
 * then the scanner terminates, returning 0 to its caller. */

int FlexLexer::yywrap() { return 1; }
