// Data Analysis Report
export const DATA_ANALYSIS_MD = String.raw`
# Q4 2024 Business Analytics Report

*Executive Summary • Generated on January 15, 2025*

## 📊 Key Performance Indicators

${'```'}
Daily Active Users (DAU):   1.2M (+65% YoY)
Monthly Active Users (MAU): 4.5M (+48% YoY)
User Retention (Day 30):    68% (+12pp YoY)
Average Session Duration:   24min (+35% YoY)
${'```'}

## 🎯 Product Performance

### Feature Adoption Rates

1. **AI Assistant**: 78% of users (↑ from 45%)
2. **Collaboration Tools**: 62% of users (↑ from 38%)
3. **Analytics Dashboard**: 54% of users (↑ from 31%)
4. **Mobile App**: 41% of users (↑ from 22%)

### Customer Satisfaction

| Metric | Q4 2024 | Q3 2024 | Change |
|--------|---------|---------|--------|
| **NPS Score** | 72 | 68 | +4 |
| **CSAT** | 4.6/5 | 4.4/5 | +0.2 |
| **Support Tickets** | 2,340 | 2,890 | -19% |
| **Resolution Time** | 4.2h | 5.1h | -18% |

## 💰 Revenue Metrics

### Monthly Recurring Revenue (MRR)

- **Current MRR**: $2.8M (+42% YoY)
- **New MRR**: $340K
- **Expansion MRR**: $180K
- **Churned MRR**: $95K
- **Net New MRR**: $425K

### Customer Acquisition

${'```'}
Cost per Acquisition (CAC): $127 (-23% YoY)
Customer Lifetime Value:    $1,840 (+31% YoY)
LTV:CAC Ratio:             14.5:1
Payback Period:            3.2 months
${'```'}

## 🌍 Geographic Performance

### Revenue by Region

1. **North America**: 45% ($1.26M)
2. **Europe**: 32% ($896K)
3. **Asia-Pacific**: 18% ($504K)
4. **Other**: 5% ($140K)

### Growth Opportunities

- **APAC**: 89% YoY growth potential
- **Latin America**: Emerging market entry
- **Middle East**: Enterprise expansion

## 📱 Channel Performance

### Traffic Sources

| Channel | Sessions | Conversion | Revenue |
|---------|----------|------------|---------|
| **Organic Search** | 45% | 3.2% | $1.1M |
| **Direct** | 28% | 4.1% | $850K |
| **Social Media** | 15% | 2.8% | $420K |
| **Paid Ads** | 12% | 5.5% | $430K |

### Marketing ROI

- **Content Marketing**: 340% ROI
- **Email Campaigns**: 280% ROI
- **Social Media**: 190% ROI
- **Paid Search**: 220% ROI

## 🔍 User Behavior Analysis

### Session Patterns

- **Peak Hours**: 9-11 AM, 2-4 PM EST
- **Mobile Usage**: 67% of sessions
- **Average Pages/Session**: 4.8
- **Bounce Rate**: 23% (↓ from 31%)

### Feature Usage Heatmap

Most used features in order:
1. Dashboard (89% of users)
2. Search (76% of users)
3. Reports (64% of users)
4. Settings (45% of users)
5. Integrations (32% of users)

## 💡 Recommendations

1. **Invest** in AI capabilities (+$2M budget)
2. **Expand** sales team in APAC region
3. **Improve** onboarding to reduce churn
4. **Launch** enterprise security features

## Appendix

### Methodology

Data collected from:
- Internal analytics (Amplitude)
- Customer surveys (n=2,450)
- Financial systems (NetSuite)
- Market research (Gartner)

---

*Report prepared by Data Analytics Team • [View Interactive Dashboard](https://analytics.example.com)*
`;
