; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+sse2 | FileCheck %s -check-prefixes=SSE2
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+ssse3 | FileCheck %s -check-prefixes=SSSE3
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+sse4.2 | FileCheck %s -check-prefixes=SSE42
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx | FileCheck %s -check-prefixes=AVX1
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx2 | FileCheck %s -check-prefixes=AVX2
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx512f | FileCheck %s -check-prefixes=AVX512F
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx512vl,+avx512dq | FileCheck %s -check-prefixes=AVX512DQ
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx512vl,+avx512bw | FileCheck %s -check-prefixes=AVX512BW

declare i64        @llvm.umax.i64(i64, i64)
declare <2 x i64>  @llvm.umax.v2i64(<2 x i64>, <2 x i64>)
declare <4 x i64>  @llvm.umax.v4i64(<4 x i64>, <4 x i64>)
declare <8 x i64>  @llvm.umax.v8i64(<8 x i64>, <8 x i64>)

declare i32        @llvm.umax.i32(i32, i32)
declare <4 x i32>  @llvm.umax.v4i32(<4 x i32>, <4 x i32>)
declare <8 x i32>  @llvm.umax.v8i32(<8 x i32>, <8 x i32>)
declare <16 x i32> @llvm.umax.v16i32(<16 x i32>, <16 x i32>)

declare i16        @llvm.umax.i16(i16, i16)
declare <8 x i16>  @llvm.umax.v8i16(<8 x i16>, <8 x i16>)
declare <16 x i16> @llvm.umax.v16i16(<16 x i16>, <16 x i16>)
declare <32 x i16> @llvm.umax.v32i16(<32 x i16>, <32 x i16>)

declare i8         @llvm.umax.i8(i8,  i8)
declare <16 x i8>  @llvm.umax.v16i8(<16 x i8>, <16 x i8>)
declare <32 x i8>  @llvm.umax.v32i8(<32 x i8>, <32 x i8>)
declare <64 x i8>  @llvm.umax.v64i8(<64 x i8>, <64 x i8>)

define i32 @umax(i32 %arg) {
; SSE2-LABEL: 'umax'
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:3 SizeLat:3 for: %I64 = call i64 @llvm.umax.i64(i64 undef, i64 undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:15 Lat:8 SizeLat:15 for: %V2I64 = call <2 x i64> @llvm.umax.v2i64(<2 x i64> undef, <2 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:30 Lat:16 SizeLat:30 for: %V4I64 = call <4 x i64> @llvm.umax.v4i64(<4 x i64> undef, <4 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:60 Lat:32 SizeLat:60 for: %V8I64 = call <8 x i64> @llvm.umax.v8i64(<8 x i64> undef, <8 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.umax.i32(i32 undef, i32 undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:8 Lat:5 SizeLat:8 for: %V4I32 = call <4 x i32> @llvm.umax.v4i32(<4 x i32> undef, <4 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:16 Lat:10 SizeLat:16 for: %V8I32 = call <8 x i32> @llvm.umax.v8i32(<8 x i32> undef, <8 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:32 Lat:20 SizeLat:32 for: %V16I32 = call <16 x i32> @llvm.umax.v16i32(<16 x i32> undef, <16 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I16 = call i16 @llvm.umax.i16(i16 undef, i16 undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:3 SizeLat:3 for: %V8I16 = call <8 x i16> @llvm.umax.v8i16(<8 x i16> undef, <8 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:6 SizeLat:6 for: %V16I16 = call <16 x i16> @llvm.umax.v16i16(<16 x i16> undef, <16 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:12 Lat:12 SizeLat:12 for: %V32I16 = call <32 x i16> @llvm.umax.v32i16(<32 x i16> undef, <32 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I8 = call i8 @llvm.umax.i8(i8 undef, i8 undef)
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.umax.v16i8(<16 x i8> undef, <16 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = call <32 x i8> @llvm.umax.v32i8(<32 x i8> undef, <32 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = call <64 x i8> @llvm.umax.v64i8(<64 x i8> undef, <64 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'umax'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:3 SizeLat:3 for: %I64 = call i64 @llvm.umax.i64(i64 undef, i64 undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:15 Lat:8 SizeLat:15 for: %V2I64 = call <2 x i64> @llvm.umax.v2i64(<2 x i64> undef, <2 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:30 Lat:16 SizeLat:30 for: %V4I64 = call <4 x i64> @llvm.umax.v4i64(<4 x i64> undef, <4 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:60 Lat:32 SizeLat:60 for: %V8I64 = call <8 x i64> @llvm.umax.v8i64(<8 x i64> undef, <8 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.umax.i32(i32 undef, i32 undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:8 Lat:5 SizeLat:8 for: %V4I32 = call <4 x i32> @llvm.umax.v4i32(<4 x i32> undef, <4 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:16 Lat:10 SizeLat:16 for: %V8I32 = call <8 x i32> @llvm.umax.v8i32(<8 x i32> undef, <8 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:32 Lat:20 SizeLat:32 for: %V16I32 = call <16 x i32> @llvm.umax.v16i32(<16 x i32> undef, <16 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I16 = call i16 @llvm.umax.i16(i16 undef, i16 undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:3 SizeLat:3 for: %V8I16 = call <8 x i16> @llvm.umax.v8i16(<8 x i16> undef, <8 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:6 SizeLat:6 for: %V16I16 = call <16 x i16> @llvm.umax.v16i16(<16 x i16> undef, <16 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:12 Lat:12 SizeLat:12 for: %V32I16 = call <32 x i16> @llvm.umax.v32i16(<32 x i16> undef, <32 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I8 = call i8 @llvm.umax.i8(i8 undef, i8 undef)
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.umax.v16i8(<16 x i8> undef, <16 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = call <32 x i8> @llvm.umax.v32i8(<32 x i8> undef, <32 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = call <64 x i8> @llvm.umax.v64i8(<64 x i8> undef, <64 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'umax'
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:3 SizeLat:3 for: %I64 = call i64 @llvm.umax.i64(i64 undef, i64 undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:11 SizeLat:7 for: %V2I64 = call <2 x i64> @llvm.umax.v2i64(<2 x i64> undef, <2 x i64> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:12 Lat:22 SizeLat:14 for: %V4I64 = call <4 x i64> @llvm.umax.v4i64(<4 x i64> undef, <4 x i64> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:24 Lat:44 SizeLat:28 for: %V8I64 = call <8 x i64> @llvm.umax.v8i64(<8 x i64> undef, <8 x i64> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.umax.i32(i32 undef, i32 undef)
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = call <4 x i32> @llvm.umax.v4i32(<4 x i32> undef, <4 x i32> undef)
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = call <8 x i32> @llvm.umax.v8i32(<8 x i32> undef, <8 x i32> undef)
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = call <16 x i32> @llvm.umax.v16i32(<16 x i32> undef, <16 x i32> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I16 = call i16 @llvm.umax.i16(i16 undef, i16 undef)
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = call <8 x i16> @llvm.umax.v8i16(<8 x i16> undef, <8 x i16> undef)
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = call <16 x i16> @llvm.umax.v16i16(<16 x i16> undef, <16 x i16> undef)
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = call <32 x i16> @llvm.umax.v32i16(<32 x i16> undef, <32 x i16> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I8 = call i8 @llvm.umax.i8(i8 undef, i8 undef)
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.umax.v16i8(<16 x i8> undef, <16 x i8> undef)
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = call <32 x i8> @llvm.umax.v32i8(<32 x i8> undef, <32 x i8> undef)
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = call <64 x i8> @llvm.umax.v64i8(<64 x i8> undef, <64 x i8> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'umax'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:3 SizeLat:3 for: %I64 = call i64 @llvm.umax.i64(i64 undef, i64 undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:8 SizeLat:7 for: %V2I64 = call <2 x i64> @llvm.umax.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:11 Lat:10 SizeLat:17 for: %V4I64 = call <4 x i64> @llvm.umax.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:22 Lat:20 SizeLat:34 for: %V8I64 = call <8 x i64> @llvm.umax.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.umax.i32(i32 undef, i32 undef)
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = call <4 x i32> @llvm.umax.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:6 SizeLat:6 for: %V8I32 = call <8 x i32> @llvm.umax.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:12 SizeLat:12 for: %V16I32 = call <16 x i32> @llvm.umax.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I16 = call i16 @llvm.umax.i16(i16 undef, i16 undef)
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = call <8 x i16> @llvm.umax.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:6 SizeLat:6 for: %V16I16 = call <16 x i16> @llvm.umax.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:12 SizeLat:12 for: %V32I16 = call <32 x i16> @llvm.umax.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I8 = call i8 @llvm.umax.i8(i8 undef, i8 undef)
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.umax.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:6 SizeLat:6 for: %V32I8 = call <32 x i8> @llvm.umax.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:12 SizeLat:12 for: %V64I8 = call <64 x i8> @llvm.umax.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'umax'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:3 SizeLat:3 for: %I64 = call i64 @llvm.umax.i64(i64 undef, i64 undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:5 Lat:8 SizeLat:6 for: %V2I64 = call <2 x i64> @llvm.umax.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:5 Lat:8 SizeLat:8 for: %V4I64 = call <4 x i64> @llvm.umax.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:10 Lat:16 SizeLat:16 for: %V8I64 = call <8 x i64> @llvm.umax.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.umax.i32(i32 undef, i32 undef)
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = call <4 x i32> @llvm.umax.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = call <8 x i32> @llvm.umax.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = call <16 x i32> @llvm.umax.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I16 = call i16 @llvm.umax.i16(i16 undef, i16 undef)
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = call <8 x i16> @llvm.umax.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.umax.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.umax.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I8 = call i8 @llvm.umax.i8(i8 undef, i8 undef)
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.umax.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.umax.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.umax.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'umax'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:3 SizeLat:3 for: %I64 = call i64 @llvm.umax.i64(i64 undef, i64 undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2I64 = call <2 x i64> @llvm.umax.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4I64 = call <4 x i64> @llvm.umax.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V8I64 = call <8 x i64> @llvm.umax.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.umax.i32(i32 undef, i32 undef)
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = call <4 x i32> @llvm.umax.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = call <8 x i32> @llvm.umax.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = call <16 x i32> @llvm.umax.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I16 = call i16 @llvm.umax.i16(i16 undef, i16 undef)
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = call <8 x i16> @llvm.umax.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.umax.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V32I16 = call <32 x i16> @llvm.umax.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I8 = call i8 @llvm.umax.i8(i8 undef, i8 undef)
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.umax.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.umax.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V64I8 = call <64 x i8> @llvm.umax.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQ-LABEL: 'umax'
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:3 SizeLat:3 for: %I64 = call i64 @llvm.umax.i64(i64 undef, i64 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2I64 = call <2 x i64> @llvm.umax.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4I64 = call <4 x i64> @llvm.umax.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V8I64 = call <8 x i64> @llvm.umax.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.umax.i32(i32 undef, i32 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = call <4 x i32> @llvm.umax.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = call <8 x i32> @llvm.umax.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = call <16 x i32> @llvm.umax.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I16 = call i16 @llvm.umax.i16(i16 undef, i16 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = call <8 x i16> @llvm.umax.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.umax.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V32I16 = call <32 x i16> @llvm.umax.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I8 = call i8 @llvm.umax.i8(i8 undef, i8 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.umax.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.umax.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V64I8 = call <64 x i8> @llvm.umax.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'umax'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:3 SizeLat:3 for: %I64 = call i64 @llvm.umax.i64(i64 undef, i64 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2I64 = call <2 x i64> @llvm.umax.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4I64 = call <4 x i64> @llvm.umax.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V8I64 = call <8 x i64> @llvm.umax.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.umax.i32(i32 undef, i32 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = call <4 x i32> @llvm.umax.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = call <8 x i32> @llvm.umax.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = call <16 x i32> @llvm.umax.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I16 = call i16 @llvm.umax.i16(i16 undef, i16 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = call <8 x i16> @llvm.umax.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.umax.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = call <32 x i16> @llvm.umax.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I8 = call i8 @llvm.umax.i8(i8 undef, i8 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.umax.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.umax.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = call <64 x i8> @llvm.umax.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I64 = call i64 @llvm.umax.i64(i64 undef, i64 undef)
  %V2I64 = call <2 x i64> @llvm.umax.v2i64(<2 x i64> undef, <2 x i64> undef)
  %V4I64 = call <4 x i64> @llvm.umax.v4i64(<4 x i64> undef, <4 x i64> undef)
  %V8I64 = call <8 x i64> @llvm.umax.v8i64(<8 x i64> undef, <8 x i64> undef)

  %I32 = call i32 @llvm.umax.i32(i32 undef, i32 undef)
  %V4I32  = call <4 x i32>  @llvm.umax.v4i32(<4 x i32> undef, <4 x i32> undef)
  %V8I32  = call <8 x i32>  @llvm.umax.v8i32(<8 x i32> undef, <8 x i32> undef)
  %V16I32 = call <16 x i32> @llvm.umax.v16i32(<16 x i32> undef, <16 x i32> undef)

  %I16 = call i16 @llvm.umax.i16(i16 undef, i16 undef)
  %V8I16  = call <8 x i16>  @llvm.umax.v8i16(<8 x i16> undef, <8 x i16> undef)
  %V16I16 = call <16 x i16> @llvm.umax.v16i16(<16 x i16> undef, <16 x i16> undef)
  %V32I16 = call <32 x i16> @llvm.umax.v32i16(<32 x i16> undef, <32 x i16> undef)

  %I8 = call i8 @llvm.umax.i8(i8 undef, i8 undef)
  %V16I8 = call <16 x i8> @llvm.umax.v16i8(<16 x i8> undef, <16 x i8> undef)
  %V32I8 = call <32 x i8> @llvm.umax.v32i8(<32 x i8> undef, <32 x i8> undef)
  %V64I8 = call <64 x i8> @llvm.umax.v64i8(<64 x i8> undef, <64 x i8> undef)

  ret i32 undef
}

declare i64        @llvm.umin.i64(i64, i64)
declare <2 x i64>  @llvm.umin.v2i64(<2 x i64>, <2 x i64>)
declare <4 x i64>  @llvm.umin.v4i64(<4 x i64>, <4 x i64>)
declare <8 x i64>  @llvm.umin.v8i64(<8 x i64>, <8 x i64>)

declare i32        @llvm.umin.i32(i32, i32)
declare <4 x i32>  @llvm.umin.v4i32(<4 x i32>, <4 x i32>)
declare <8 x i32>  @llvm.umin.v8i32(<8 x i32>, <8 x i32>)
declare <16 x i32> @llvm.umin.v16i32(<16 x i32>, <16 x i32>)

declare i16        @llvm.umin.i16(i16, i16)
declare <8 x i16>  @llvm.umin.v8i16(<8 x i16>, <8 x i16>)
declare <16 x i16> @llvm.umin.v16i16(<16 x i16>, <16 x i16>)
declare <32 x i16> @llvm.umin.v32i16(<32 x i16>, <32 x i16>)

declare i8         @llvm.umin.i8(i8,  i8)
declare <16 x i8>  @llvm.umin.v16i8(<16 x i8>, <16 x i8>)
declare <32 x i8>  @llvm.umin.v32i8(<32 x i8>, <32 x i8>)
declare <64 x i8>  @llvm.umin.v64i8(<64 x i8>, <64 x i8>)

define i32 @umin(i32 %arg) {
; SSE2-LABEL: 'umin'
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:3 SizeLat:3 for: %I64 = call i64 @llvm.umin.i64(i64 undef, i64 undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:15 Lat:8 SizeLat:15 for: %V2I64 = call <2 x i64> @llvm.umin.v2i64(<2 x i64> undef, <2 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:30 Lat:16 SizeLat:30 for: %V4I64 = call <4 x i64> @llvm.umin.v4i64(<4 x i64> undef, <4 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:60 Lat:32 SizeLat:60 for: %V8I64 = call <8 x i64> @llvm.umin.v8i64(<8 x i64> undef, <8 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.umin.i32(i32 undef, i32 undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:8 Lat:5 SizeLat:8 for: %V4I32 = call <4 x i32> @llvm.umin.v4i32(<4 x i32> undef, <4 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:16 Lat:10 SizeLat:16 for: %V8I32 = call <8 x i32> @llvm.umin.v8i32(<8 x i32> undef, <8 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:32 Lat:20 SizeLat:32 for: %V16I32 = call <16 x i32> @llvm.umin.v16i32(<16 x i32> undef, <16 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I16 = call i16 @llvm.umin.i16(i16 undef, i16 undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:3 SizeLat:3 for: %V8I16 = call <8 x i16> @llvm.umin.v8i16(<8 x i16> undef, <8 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:6 SizeLat:6 for: %V16I16 = call <16 x i16> @llvm.umin.v16i16(<16 x i16> undef, <16 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:12 Lat:12 SizeLat:12 for: %V32I16 = call <32 x i16> @llvm.umin.v32i16(<32 x i16> undef, <32 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I8 = call i8 @llvm.umin.i8(i8 undef, i8 undef)
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.umin.v16i8(<16 x i8> undef, <16 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = call <32 x i8> @llvm.umin.v32i8(<32 x i8> undef, <32 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = call <64 x i8> @llvm.umin.v64i8(<64 x i8> undef, <64 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'umin'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:3 SizeLat:3 for: %I64 = call i64 @llvm.umin.i64(i64 undef, i64 undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:15 Lat:8 SizeLat:15 for: %V2I64 = call <2 x i64> @llvm.umin.v2i64(<2 x i64> undef, <2 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:30 Lat:16 SizeLat:30 for: %V4I64 = call <4 x i64> @llvm.umin.v4i64(<4 x i64> undef, <4 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:60 Lat:32 SizeLat:60 for: %V8I64 = call <8 x i64> @llvm.umin.v8i64(<8 x i64> undef, <8 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.umin.i32(i32 undef, i32 undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:8 Lat:5 SizeLat:8 for: %V4I32 = call <4 x i32> @llvm.umin.v4i32(<4 x i32> undef, <4 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:16 Lat:10 SizeLat:16 for: %V8I32 = call <8 x i32> @llvm.umin.v8i32(<8 x i32> undef, <8 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:32 Lat:20 SizeLat:32 for: %V16I32 = call <16 x i32> @llvm.umin.v16i32(<16 x i32> undef, <16 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I16 = call i16 @llvm.umin.i16(i16 undef, i16 undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:3 Lat:3 SizeLat:3 for: %V8I16 = call <8 x i16> @llvm.umin.v8i16(<8 x i16> undef, <8 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:6 SizeLat:6 for: %V16I16 = call <16 x i16> @llvm.umin.v16i16(<16 x i16> undef, <16 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:12 Lat:12 SizeLat:12 for: %V32I16 = call <32 x i16> @llvm.umin.v32i16(<32 x i16> undef, <32 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I8 = call i8 @llvm.umin.i8(i8 undef, i8 undef)
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.umin.v16i8(<16 x i8> undef, <16 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = call <32 x i8> @llvm.umin.v32i8(<32 x i8> undef, <32 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = call <64 x i8> @llvm.umin.v64i8(<64 x i8> undef, <64 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'umin'
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:3 SizeLat:3 for: %I64 = call i64 @llvm.umin.i64(i64 undef, i64 undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:11 SizeLat:7 for: %V2I64 = call <2 x i64> @llvm.umin.v2i64(<2 x i64> undef, <2 x i64> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:12 Lat:22 SizeLat:14 for: %V4I64 = call <4 x i64> @llvm.umin.v4i64(<4 x i64> undef, <4 x i64> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:24 Lat:44 SizeLat:28 for: %V8I64 = call <8 x i64> @llvm.umin.v8i64(<8 x i64> undef, <8 x i64> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.umin.i32(i32 undef, i32 undef)
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = call <4 x i32> @llvm.umin.v4i32(<4 x i32> undef, <4 x i32> undef)
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V8I32 = call <8 x i32> @llvm.umin.v8i32(<8 x i32> undef, <8 x i32> undef)
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V16I32 = call <16 x i32> @llvm.umin.v16i32(<16 x i32> undef, <16 x i32> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I16 = call i16 @llvm.umin.i16(i16 undef, i16 undef)
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = call <8 x i16> @llvm.umin.v8i16(<8 x i16> undef, <8 x i16> undef)
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V16I16 = call <16 x i16> @llvm.umin.v16i16(<16 x i16> undef, <16 x i16> undef)
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V32I16 = call <32 x i16> @llvm.umin.v32i16(<32 x i16> undef, <32 x i16> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I8 = call i8 @llvm.umin.i8(i8 undef, i8 undef)
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.umin.v16i8(<16 x i8> undef, <16 x i8> undef)
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V32I8 = call <32 x i8> @llvm.umin.v32i8(<32 x i8> undef, <32 x i8> undef)
; SSE42-NEXT:  Cost Model: Found costs of 4 for: %V64I8 = call <64 x i8> @llvm.umin.v64i8(<64 x i8> undef, <64 x i8> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'umin'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:3 SizeLat:3 for: %I64 = call i64 @llvm.umin.i64(i64 undef, i64 undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:8 SizeLat:7 for: %V2I64 = call <2 x i64> @llvm.umin.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:11 Lat:10 SizeLat:17 for: %V4I64 = call <4 x i64> @llvm.umin.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:22 Lat:20 SizeLat:34 for: %V8I64 = call <8 x i64> @llvm.umin.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.umin.i32(i32 undef, i32 undef)
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = call <4 x i32> @llvm.umin.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:6 SizeLat:6 for: %V8I32 = call <8 x i32> @llvm.umin.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:12 SizeLat:12 for: %V16I32 = call <16 x i32> @llvm.umin.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I16 = call i16 @llvm.umin.i16(i16 undef, i16 undef)
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = call <8 x i16> @llvm.umin.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:6 SizeLat:6 for: %V16I16 = call <16 x i16> @llvm.umin.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:12 SizeLat:12 for: %V32I16 = call <32 x i16> @llvm.umin.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I8 = call i8 @llvm.umin.i8(i8 undef, i8 undef)
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.umin.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:5 Lat:6 SizeLat:6 for: %V32I8 = call <32 x i8> @llvm.umin.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:10 Lat:12 SizeLat:12 for: %V64I8 = call <64 x i8> @llvm.umin.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'umin'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:3 SizeLat:3 for: %I64 = call i64 @llvm.umin.i64(i64 undef, i64 undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:5 Lat:8 SizeLat:6 for: %V2I64 = call <2 x i64> @llvm.umin.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:5 Lat:8 SizeLat:8 for: %V4I64 = call <4 x i64> @llvm.umin.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:10 Lat:16 SizeLat:16 for: %V8I64 = call <8 x i64> @llvm.umin.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.umin.i32(i32 undef, i32 undef)
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = call <4 x i32> @llvm.umin.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = call <8 x i32> @llvm.umin.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V16I32 = call <16 x i32> @llvm.umin.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I16 = call i16 @llvm.umin.i16(i16 undef, i16 undef)
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = call <8 x i16> @llvm.umin.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.umin.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.umin.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I8 = call i8 @llvm.umin.i8(i8 undef, i8 undef)
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.umin.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.umin.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.umin.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'umin'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:3 SizeLat:3 for: %I64 = call i64 @llvm.umin.i64(i64 undef, i64 undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2I64 = call <2 x i64> @llvm.umin.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4I64 = call <4 x i64> @llvm.umin.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V8I64 = call <8 x i64> @llvm.umin.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.umin.i32(i32 undef, i32 undef)
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = call <4 x i32> @llvm.umin.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = call <8 x i32> @llvm.umin.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = call <16 x i32> @llvm.umin.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I16 = call i16 @llvm.umin.i16(i16 undef, i16 undef)
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = call <8 x i16> @llvm.umin.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.umin.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V32I16 = call <32 x i16> @llvm.umin.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I8 = call i8 @llvm.umin.i8(i8 undef, i8 undef)
; AVX512F-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.umin.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.umin.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V64I8 = call <64 x i8> @llvm.umin.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQ-LABEL: 'umin'
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:3 SizeLat:3 for: %I64 = call i64 @llvm.umin.i64(i64 undef, i64 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2I64 = call <2 x i64> @llvm.umin.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4I64 = call <4 x i64> @llvm.umin.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V8I64 = call <8 x i64> @llvm.umin.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.umin.i32(i32 undef, i32 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = call <4 x i32> @llvm.umin.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = call <8 x i32> @llvm.umin.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = call <16 x i32> @llvm.umin.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I16 = call i16 @llvm.umin.i16(i16 undef, i16 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = call <8 x i16> @llvm.umin.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.umin.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V32I16 = call <32 x i16> @llvm.umin.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I8 = call i8 @llvm.umin.i8(i8 undef, i8 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.umin.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.umin.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:7 SizeLat:5 for: %V64I8 = call <64 x i8> @llvm.umin.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'umin'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:3 SizeLat:3 for: %I64 = call i64 @llvm.umin.i64(i64 undef, i64 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2I64 = call <2 x i64> @llvm.umin.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4I64 = call <4 x i64> @llvm.umin.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V8I64 = call <8 x i64> @llvm.umin.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:3 for: %I32 = call i32 @llvm.umin.i32(i32 undef, i32 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V4I32 = call <4 x i32> @llvm.umin.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V8I32 = call <8 x i32> @llvm.umin.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I32 = call <16 x i32> @llvm.umin.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I16 = call i16 @llvm.umin.i16(i16 undef, i16 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V8I16 = call <8 x i16> @llvm.umin.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.umin.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = call <32 x i16> @llvm.umin.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:4 for: %I8 = call i8 @llvm.umin.i8(i8 undef, i8 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V16I8 = call <16 x i8> @llvm.umin.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.umin.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = call <64 x i8> @llvm.umin.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I64 = call i64 @llvm.umin.i64(i64 undef, i64 undef)
  %V2I64 = call <2 x i64> @llvm.umin.v2i64(<2 x i64> undef, <2 x i64> undef)
  %V4I64 = call <4 x i64> @llvm.umin.v4i64(<4 x i64> undef, <4 x i64> undef)
  %V8I64 = call <8 x i64> @llvm.umin.v8i64(<8 x i64> undef, <8 x i64> undef)

  %I32 = call i32 @llvm.umin.i32(i32 undef, i32 undef)
  %V4I32  = call <4 x i32>  @llvm.umin.v4i32(<4 x i32> undef, <4 x i32> undef)
  %V8I32  = call <8 x i32>  @llvm.umin.v8i32(<8 x i32> undef, <8 x i32> undef)
  %V16I32 = call <16 x i32> @llvm.umin.v16i32(<16 x i32> undef, <16 x i32> undef)

  %I16 = call i16 @llvm.umin.i16(i16 undef, i16 undef)
  %V8I16  = call <8 x i16>  @llvm.umin.v8i16(<8 x i16> undef, <8 x i16> undef)
  %V16I16 = call <16 x i16> @llvm.umin.v16i16(<16 x i16> undef, <16 x i16> undef)
  %V32I16 = call <32 x i16> @llvm.umin.v32i16(<32 x i16> undef, <32 x i16> undef)

  %I8 = call i8 @llvm.umin.i8(i8 undef, i8 undef)
  %V16I8 = call <16 x i8> @llvm.umin.v16i8(<16 x i8> undef, <16 x i8> undef)
  %V32I8 = call <32 x i8> @llvm.umin.v32i8(<32 x i8> undef, <32 x i8> undef)
  %V64I8 = call <64 x i8> @llvm.umin.v64i8(<64 x i8> undef, <64 x i8> undef)

  ret i32 undef
}
