; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d -target-abi=ilp32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32IFD %s
; RUN: llc -mtriple=riscv64 -mattr=+d -target-abi=lp64 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64IFD %s
; RUN: llc -mtriple=riscv32 -mattr=+zdinx -target-abi=ilp32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32IZFINXZDINX %s
; RUN: llc -mtriple=riscv64 -mattr=+zdinx -target-abi=lp64 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64IZFINXZDINX %s

define double @func(double %d, i32 %n) nounwind {
; RV32IFD-LABEL: func:
; RV32IFD:       # %bb.0: # %entry
; RV32IFD-NEXT:    addi sp, sp, -32
; RV32IFD-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    sw a0, 16(sp)
; RV32IFD-NEXT:    sw a1, 20(sp)
; RV32IFD-NEXT:    fld fa5, 16(sp)
; RV32IFD-NEXT:    beqz a2, .LBB0_2
; RV32IFD-NEXT:  # %bb.1: # %if.else
; RV32IFD-NEXT:    addi a2, a2, -1
; RV32IFD-NEXT:    fsd fa5, 16(sp)
; RV32IFD-NEXT:    lw a0, 16(sp)
; RV32IFD-NEXT:    lw a1, 20(sp)
; RV32IFD-NEXT:    fsd fa5, 8(sp) # 8-byte Folded Spill
; RV32IFD-NEXT:    call func
; RV32IFD-NEXT:    sw a0, 16(sp)
; RV32IFD-NEXT:    sw a1, 20(sp)
; RV32IFD-NEXT:    fld fa5, 16(sp)
; RV32IFD-NEXT:    fld fa4, 8(sp) # 8-byte Folded Reload
; RV32IFD-NEXT:    fadd.d fa5, fa5, fa4
; RV32IFD-NEXT:  .LBB0_2: # %return
; RV32IFD-NEXT:    fsd fa5, 16(sp)
; RV32IFD-NEXT:    lw a0, 16(sp)
; RV32IFD-NEXT:    lw a1, 20(sp)
; RV32IFD-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 32
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: func:
; RV64IFD:       # %bb.0: # %entry
; RV64IFD-NEXT:    sext.w a2, a1
; RV64IFD-NEXT:    fmv.d.x fa5, a0
; RV64IFD-NEXT:    beqz a2, .LBB0_2
; RV64IFD-NEXT:  # %bb.1: # %if.else
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    addiw a1, a1, -1
; RV64IFD-NEXT:    fmv.x.d a0, fa5
; RV64IFD-NEXT:    fsd fa5, 0(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    call func
; RV64IFD-NEXT:    fmv.d.x fa5, a0
; RV64IFD-NEXT:    fld fa4, 0(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    fadd.d fa5, fa5, fa4
; RV64IFD-NEXT:    fmv.x.d a0, fa5
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
; RV64IFD-NEXT:  .LBB0_2: # %return
; RV64IFD-NEXT:    fmv.x.d a0, fa5
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: func:
; RV32IZFINXZDINX:       # %bb.0: # %entry
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    mv s1, a1
; RV32IZFINXZDINX-NEXT:    mv s0, a0
; RV32IZFINXZDINX-NEXT:    beqz a2, .LBB0_2
; RV32IZFINXZDINX-NEXT:  # %bb.1: # %if.else
; RV32IZFINXZDINX-NEXT:    addi a2, a2, -1
; RV32IZFINXZDINX-NEXT:    mv a0, s0
; RV32IZFINXZDINX-NEXT:    mv a1, s1
; RV32IZFINXZDINX-NEXT:    call func
; RV32IZFINXZDINX-NEXT:    fadd.d a0, a0, s0
; RV32IZFINXZDINX-NEXT:    j .LBB0_3
; RV32IZFINXZDINX-NEXT:  .LBB0_2: # %return
; RV32IZFINXZDINX-NEXT:    mv a0, s0
; RV32IZFINXZDINX-NEXT:    mv a1, s1
; RV32IZFINXZDINX-NEXT:  .LBB0_3: # %return
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: func:
; RV64IZFINXZDINX:       # %bb.0: # %entry
; RV64IZFINXZDINX-NEXT:    sext.w a2, a1
; RV64IZFINXZDINX-NEXT:    beqz a2, .LBB0_2
; RV64IZFINXZDINX-NEXT:  # %bb.1: # %if.else
; RV64IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV64IZFINXZDINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    addiw a1, a1, -1
; RV64IZFINXZDINX-NEXT:    mv s0, a0
; RV64IZFINXZDINX-NEXT:    call func
; RV64IZFINXZDINX-NEXT:    fadd.d a0, a0, s0
; RV64IZFINXZDINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    ld s0, 0(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV64IZFINXZDINX-NEXT:  .LBB0_2: # %return
; RV64IZFINXZDINX-NEXT:    ret
entry:
  %cmp = icmp eq i32 %n, 0
  br i1 %cmp, label %return, label %if.else

if.else:
  %sub = add i32 %n, -1
  %call = tail call double @func(double %d, i32 %sub)
  %add = fadd double %call, %d
  ret double %add

return:
  ret double %d
}
