; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; TODO: Run these for global isel as well.
; RUN: llc -mtriple=amdgcn -mcpu=gfx1013 -verify-machineinstrs < %s | FileCheck -check-prefixes=PRE-GFX12,GFX10,GFX1013 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1030 -verify-machineinstrs < %s | FileCheck -check-prefixes=PRE-GFX12,GFX10,GFX1030 %s
; RUN: not --crash llc -mtriple=amdgcn -mcpu=gfx1012 -verify-machineinstrs < %s 2>&1 | FileCheck -check-prefix=ERR %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 -verify-machineinstrs < %s | FileCheck -check-prefixes=PRE-GFX12,GFX11,GFX11-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 -verify-machineinstrs < %s | FileCheck -check-prefixes=PRE-GFX12,GFX11,GFX11-FAKE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1200 -mattr=+real-true16 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX12,GFX12-SDAG,GFX12-SDAG-TRUE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1200 -mattr=-real-true16 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX12,GFX12-SDAG,GFX12-SDAG-FAKE16 %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1200 -mattr=+real-true16 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX12,GFX12-GISEL,GFX12-GISEL-TRUE16 %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1200 -mattr=-real-true16 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX12,GFX12-GISEL,GFX12-GISEL-FAKE16 %s

; uint4 llvm.amdgcn.image.bvh.intersect.ray.i32.v4f32(uint node_ptr, float ray_extent, float3 ray_origin, float3 ray_dir, float3 ray_inv_dir, uint4 texture_descr)
; uint4 llvm.amdgcn.image.bvh.intersect.ray.i32.v4f16(uint node_ptr, float ray_extent, float3 ray_origin, half3 ray_dir, half3 ray_inv_dir, uint4 texture_descr)
; uint4 llvm.amdgcn.image.bvh.intersect.ray.i64.v4f32(ulong node_ptr, float ray_extent, float3 ray_origin, float3 ray_dir, float3 ray_inv_dir, uint4 texture_descr)
; uint4 llvm.amdgcn.image.bvh.intersect.ray.i64.v4f16(ulong node_ptr, float ray_extent, float3 ray_origin, half3 ray_dir, half3 ray_inv_dir, uint4 texture_descr)

declare <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i32.v4f32(i32, float, <3 x float>, <3 x float>, <3 x float>, <4 x i32>)
declare <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i32.v4f16(i32, float, <3 x float>, <3 x half>, <3 x half>, <4 x i32>)
declare <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i64.v4f32(i64, float, <3 x float>, <3 x float>, <3 x float>, <4 x i32>)
declare <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i64.v4f16(i64, float, <3 x float>, <3 x half>, <3 x half>, <4 x i32>)

; ERR: in function image_bvh_intersect_ray{{.*}}intrinsic not supported on subtarget
; Arguments are flattened to represent the actual VGPR_A layout, so we have no
; extra moves in the generated kernel.
define amdgpu_ps <4 x float> @image_bvh_intersect_ray(i32 %node_ptr, float %ray_extent, float %ray_origin_x, float %ray_origin_y, float %ray_origin_z, float %ray_dir_x, float %ray_dir_y, float %ray_dir_z, float %ray_inv_dir_x, float %ray_inv_dir_y, float %ray_inv_dir_z, <4 x i32> inreg %tdescr) {
; PRE-GFX12-LABEL: image_bvh_intersect_ray:
; PRE-GFX12:       ; %bb.0: ; %main_body
; PRE-GFX12-NEXT:    image_bvh_intersect_ray v[0:3], v[0:10], s[0:3]
; PRE-GFX12-NEXT:    s_waitcnt vmcnt(0)
; PRE-GFX12-NEXT:    ; return to shader part epilog
;
; GFX12-LABEL: image_bvh_intersect_ray:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    image_bvh_intersect_ray v[0:3], [v0, v1, v[2:4], v[5:7], v[8:10]], s[0:3]
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %ray_origin0 = insertelement <3 x float> poison, float %ray_origin_x, i32 0
  %ray_origin1 = insertelement <3 x float> %ray_origin0, float %ray_origin_y, i32 1
  %ray_origin = insertelement <3 x float> %ray_origin1, float %ray_origin_z, i32 2
  %ray_dir0 = insertelement <3 x float> poison, float %ray_dir_x, i32 0
  %ray_dir1 = insertelement <3 x float> %ray_dir0, float %ray_dir_y, i32 1
  %ray_dir = insertelement <3 x float> %ray_dir1, float %ray_dir_z, i32 2
  %ray_inv_dir0 = insertelement <3 x float> poison, float %ray_inv_dir_x, i32 0
  %ray_inv_dir1 = insertelement <3 x float> %ray_inv_dir0, float %ray_inv_dir_y, i32 1
  %ray_inv_dir = insertelement <3 x float> %ray_inv_dir1, float %ray_inv_dir_z, i32 2
  %v = call <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i32.v4f32(i32 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x float> %ray_dir, <3 x float> %ray_inv_dir, <4 x i32> %tdescr)
 %r = bitcast <4 x i32> %v to <4 x float>
 ret <4 x float> %r
}

define amdgpu_ps <4 x float> @image_bvh_intersect_ray_a16(i32 inreg %node_ptr, float inreg %ray_extent, <3 x float> inreg %ray_origin, <3 x half> inreg %ray_dir, <3 x half> inreg %ray_inv_dir, <4 x i32> inreg %tdescr) {
; GFX10-LABEL: image_bvh_intersect_ray_a16:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    s_mov_b32 s15, s12
; GFX10-NEXT:    s_mov_b32 s12, s9
; GFX10-NEXT:    s_lshr_b32 s9, s7, 16
; GFX10-NEXT:    s_pack_ll_b32_b16 s6, s6, s7
; GFX10-NEXT:    s_pack_ll_b32_b16 s7, s9, s8
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-NEXT:    v_mov_b32_e32 v3, s3
; GFX10-NEXT:    v_mov_b32_e32 v4, s4
; GFX10-NEXT:    v_mov_b32_e32 v5, s5
; GFX10-NEXT:    v_mov_b32_e32 v6, s6
; GFX10-NEXT:    v_mov_b32_e32 v7, s7
; GFX10-NEXT:    s_mov_b32 s14, s11
; GFX10-NEXT:    s_mov_b32 s13, s10
; GFX10-NEXT:    image_bvh_intersect_ray v[0:3], v[0:7], s[12:15] a16
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: image_bvh_intersect_ray_a16:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX11-NEXT:    s_lshr_b32 s2, s7, 16
; GFX11-NEXT:    s_lshr_b32 s3, s5, 16
; GFX11-NEXT:    v_dual_mov_b32 v6, s0 :: v_dual_mov_b32 v7, s1
; GFX11-NEXT:    s_pack_ll_b32_b16 s2, s3, s2
; GFX11-NEXT:    s_pack_ll_b32_b16 s3, s5, s7
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_pack_ll_b32_b16 s4, s6, s8
; GFX11-NEXT:    v_dual_mov_b32 v4, s2 :: v_dual_mov_b32 v5, s4
; GFX11-NEXT:    s_mov_b32 s15, s12
; GFX11-NEXT:    s_mov_b32 s14, s11
; GFX11-NEXT:    s_mov_b32 s13, s10
; GFX11-NEXT:    s_mov_b32 s12, s9
; GFX11-NEXT:    image_bvh_intersect_ray v[0:3], [v6, v7, v[0:2], v[3:5]], s[12:15] a16
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; GFX12-SDAG-LABEL: image_bvh_intersect_ray_a16:
; GFX12-SDAG:       ; %bb.0: ; %main_body
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX12-SDAG-NEXT:    s_lshr_b32 s2, s7, 16
; GFX12-SDAG-NEXT:    s_lshr_b32 s3, s5, 16
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v6, s0 :: v_dual_mov_b32 v7, s1
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffe
; GFX12-SDAG-NEXT:    s_pack_ll_b32_b16 s2, s3, s2
; GFX12-SDAG-NEXT:    s_pack_ll_b32_b16 s3, s5, s7
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffe
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s3
; GFX12-SDAG-NEXT:    s_pack_ll_b32_b16 s4, s6, s8
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffe
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v4, s2 :: v_dual_mov_b32 v5, s4
; GFX12-SDAG-NEXT:    s_mov_b32 s15, s12
; GFX12-SDAG-NEXT:    s_mov_b32 s14, s11
; GFX12-SDAG-NEXT:    s_mov_b32 s13, s10
; GFX12-SDAG-NEXT:    s_mov_b32 s12, s9
; GFX12-SDAG-NEXT:    image_bvh_intersect_ray v[0:3], [v6, v7, v[0:2], v[3:5]], s[12:15] a16
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    ; return to shader part epilog
;
; GFX12-GISEL-TRUE16-LABEL: image_bvh_intersect_ray_a16:
; GFX12-GISEL-TRUE16:       ; %bb.0: ; %main_body
; GFX12-GISEL-TRUE16-NEXT:    s_mov_b32 s20, s2
; GFX12-GISEL-TRUE16-NEXT:    s_mov_b32 s22, s4
; GFX12-GISEL-TRUE16-NEXT:    s_pack_ll_b32_b16 s4, s7, s5
; GFX12-GISEL-TRUE16-NEXT:    s_mov_b32 s21, s3
; GFX12-GISEL-TRUE16-NEXT:    s_pack_ll_b32_b16 s6, s8, s6
; GFX12-GISEL-TRUE16-NEXT:    s_mov_b32 s5, s4
; GFX12-GISEL-TRUE16-NEXT:    v_dual_mov_b32 v0, s20 :: v_dual_mov_b32 v1, s21
; GFX12-GISEL-TRUE16-NEXT:    v_dual_mov_b32 v2, s22 :: v_dual_mov_b32 v3, s4
; GFX12-GISEL-TRUE16-NEXT:    v_dual_mov_b32 v6, s0 :: v_dual_mov_b32 v7, s1
; GFX12-GISEL-TRUE16-NEXT:    v_dual_mov_b32 v4, s5 :: v_dual_mov_b32 v5, s6
; GFX12-GISEL-TRUE16-NEXT:    s_mov_b32 s16, s9
; GFX12-GISEL-TRUE16-NEXT:    s_mov_b32 s17, s10
; GFX12-GISEL-TRUE16-NEXT:    s_mov_b32 s18, s11
; GFX12-GISEL-TRUE16-NEXT:    s_mov_b32 s19, s12
; GFX12-GISEL-TRUE16-NEXT:    image_bvh_intersect_ray v[0:3], [v6, v7, v[0:2], v[3:5]], s[16:19] a16
; GFX12-GISEL-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    ; return to shader part epilog
;
; GFX12-GISEL-FAKE16-LABEL: image_bvh_intersect_ray_a16:
; GFX12-GISEL-FAKE16:       ; %bb.0: ; %main_body
; GFX12-GISEL-FAKE16-NEXT:    s_mov_b32 s20, s2
; GFX12-GISEL-FAKE16-NEXT:    s_mov_b32 s22, s4
; GFX12-GISEL-FAKE16-NEXT:    s_pack_ll_b32_b16 s4, s7, s5
; GFX12-GISEL-FAKE16-NEXT:    s_mov_b32 s21, s3
; GFX12-GISEL-FAKE16-NEXT:    s_pack_hh_b32_b16 s5, s7, s5
; GFX12-GISEL-FAKE16-NEXT:    s_pack_ll_b32_b16 s6, s8, s6
; GFX12-GISEL-FAKE16-NEXT:    v_dual_mov_b32 v0, s20 :: v_dual_mov_b32 v1, s21
; GFX12-GISEL-FAKE16-NEXT:    v_dual_mov_b32 v2, s22 :: v_dual_mov_b32 v3, s4
; GFX12-GISEL-FAKE16-NEXT:    v_dual_mov_b32 v6, s0 :: v_dual_mov_b32 v7, s1
; GFX12-GISEL-FAKE16-NEXT:    v_dual_mov_b32 v4, s5 :: v_dual_mov_b32 v5, s6
; GFX12-GISEL-FAKE16-NEXT:    s_mov_b32 s16, s9
; GFX12-GISEL-FAKE16-NEXT:    s_mov_b32 s17, s10
; GFX12-GISEL-FAKE16-NEXT:    s_mov_b32 s18, s11
; GFX12-GISEL-FAKE16-NEXT:    s_mov_b32 s19, s12
; GFX12-GISEL-FAKE16-NEXT:    image_bvh_intersect_ray v[0:3], [v6, v7, v[0:2], v[3:5]], s[16:19] a16
; GFX12-GISEL-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i32.v4f16(i32 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x half> %ray_dir, <3 x half> %ray_inv_dir, <4 x i32> %tdescr)
  %r = bitcast <4 x i32> %v to <4 x float>
  ret <4 x float> %r
}

; Arguments are flattened to represent the actual VGPR_A layout, so we have no
; extra moves in the generated kernel.
define amdgpu_ps <4 x float> @image_bvh64_intersect_ray(<2 x i32> %node_ptr_vec, float %ray_extent, float %ray_origin_x, float %ray_origin_y, float %ray_origin_z, float %ray_dir_x, float %ray_dir_y, float %ray_dir_z, float %ray_inv_dir_x, float %ray_inv_dir_y, float %ray_inv_dir_z, <4 x i32> inreg %tdescr) {
; PRE-GFX12-LABEL: image_bvh64_intersect_ray:
; PRE-GFX12:       ; %bb.0: ; %main_body
; PRE-GFX12-NEXT:    image_bvh64_intersect_ray v[0:3], v[0:11], s[0:3]
; PRE-GFX12-NEXT:    s_waitcnt vmcnt(0)
; PRE-GFX12-NEXT:    ; return to shader part epilog
;
; GFX12-LABEL: image_bvh64_intersect_ray:
; GFX12:       ; %bb.0: ; %main_body
; GFX12-NEXT:    image_bvh64_intersect_ray v[0:3], [v[0:1], v2, v[3:5], v[6:8], v[9:11]], s[0:3]
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    ; return to shader part epilog
main_body:
  %node_ptr = bitcast <2 x i32> %node_ptr_vec to i64
  %ray_origin0 = insertelement <3 x float> poison, float %ray_origin_x, i32 0
  %ray_origin1 = insertelement <3 x float> %ray_origin0, float %ray_origin_y, i32 1
  %ray_origin = insertelement <3 x float> %ray_origin1, float %ray_origin_z, i32 2
  %ray_dir0 = insertelement <3 x float> poison, float %ray_dir_x, i32 0
  %ray_dir1 = insertelement <3 x float> %ray_dir0, float %ray_dir_y, i32 1
  %ray_dir = insertelement <3 x float> %ray_dir1, float %ray_dir_z, i32 2
  %ray_inv_dir0 = insertelement <3 x float> poison, float %ray_inv_dir_x, i32 0
  %ray_inv_dir1 = insertelement <3 x float> %ray_inv_dir0, float %ray_inv_dir_y, i32 1
  %ray_inv_dir = insertelement <3 x float> %ray_inv_dir1, float %ray_inv_dir_z, i32 2
  %v = call <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i64.v4f32(i64 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x float> %ray_dir, <3 x float> %ray_inv_dir, <4 x i32> %tdescr)
 %r = bitcast <4 x i32> %v to <4 x float>
 ret <4 x float> %r
}

define amdgpu_ps <4 x float> @image_bvh64_intersect_ray_a16(i64 inreg %node_ptr, float inreg %ray_extent, <3 x float> inreg %ray_origin, <3 x half> inreg %ray_dir, <3 x half> inreg %ray_inv_dir, <4 x i32> inreg %tdescr) {
; GFX10-LABEL: image_bvh64_intersect_ray_a16:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    s_mov_b32 s14, s12
; GFX10-NEXT:    s_mov_b32 s12, s10
; GFX10-NEXT:    s_lshr_b32 s10, s8, 16
; GFX10-NEXT:    s_pack_ll_b32_b16 s7, s7, s8
; GFX10-NEXT:    s_pack_ll_b32_b16 s8, s10, s9
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    v_mov_b32_e32 v2, s2
; GFX10-NEXT:    v_mov_b32_e32 v3, s3
; GFX10-NEXT:    v_mov_b32_e32 v4, s4
; GFX10-NEXT:    v_mov_b32_e32 v5, s5
; GFX10-NEXT:    v_mov_b32_e32 v6, s6
; GFX10-NEXT:    v_mov_b32_e32 v7, s7
; GFX10-NEXT:    v_mov_b32_e32 v8, s8
; GFX10-NEXT:    s_mov_b32 s15, s13
; GFX10-NEXT:    s_mov_b32 s13, s11
; GFX10-NEXT:    image_bvh64_intersect_ray v[0:3], v[0:8], s[12:15] a16
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: image_bvh64_intersect_ray_a16:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_dual_mov_b32 v0, s3 :: v_dual_mov_b32 v1, s4
; GFX11-NEXT:    v_dual_mov_b32 v2, s5 :: v_dual_mov_b32 v7, s1
; GFX11-NEXT:    s_lshr_b32 s3, s6, 16
; GFX11-NEXT:    s_pack_ll_b32_b16 s1, s6, s8
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_4) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v6, s0 :: v_dual_mov_b32 v3, s1
; GFX11-NEXT:    s_lshr_b32 s0, s8, 16
; GFX11-NEXT:    v_mov_b32_e32 v8, s2
; GFX11-NEXT:    s_pack_ll_b32_b16 s0, s3, s0
; GFX11-NEXT:    s_pack_ll_b32_b16 s3, s7, s9
; GFX11-NEXT:    v_dual_mov_b32 v4, s0 :: v_dual_mov_b32 v5, s3
; GFX11-NEXT:    s_mov_b32 s15, s13
; GFX11-NEXT:    s_mov_b32 s14, s12
; GFX11-NEXT:    s_mov_b32 s13, s11
; GFX11-NEXT:    s_mov_b32 s12, s10
; GFX11-NEXT:    image_bvh64_intersect_ray v[0:3], [v[6:7], v8, v[0:2], v[3:5]], s[12:15] a16
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    ; return to shader part epilog
;
; GFX12-SDAG-LABEL: image_bvh64_intersect_ray_a16:
; GFX12-SDAG:       ; %bb.0: ; %main_body
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v0, s3 :: v_dual_mov_b32 v1, s4
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v2, s5 :: v_dual_mov_b32 v7, s1
; GFX12-SDAG-NEXT:    s_lshr_b32 s3, s6, 16
; GFX12-SDAG-NEXT:    s_pack_ll_b32_b16 s1, s6, s8
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffe
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v6, s0 :: v_dual_mov_b32 v3, s1
; GFX12-SDAG-NEXT:    s_lshr_b32 s0, s8, 16
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v8, s2
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffe
; GFX12-SDAG-NEXT:    s_pack_ll_b32_b16 s0, s3, s0
; GFX12-SDAG-NEXT:    s_pack_ll_b32_b16 s3, s7, s9
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffe
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v4, s0 :: v_dual_mov_b32 v5, s3
; GFX12-SDAG-NEXT:    s_mov_b32 s15, s13
; GFX12-SDAG-NEXT:    s_mov_b32 s14, s12
; GFX12-SDAG-NEXT:    s_mov_b32 s13, s11
; GFX12-SDAG-NEXT:    s_mov_b32 s12, s10
; GFX12-SDAG-NEXT:    image_bvh64_intersect_ray v[0:3], [v[6:7], v8, v[0:2], v[3:5]], s[12:15] a16
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    ; return to shader part epilog
;
; GFX12-GISEL-TRUE16-LABEL: image_bvh64_intersect_ray_a16:
; GFX12-GISEL-TRUE16:       ; %bb.0: ; %main_body
; GFX12-GISEL-TRUE16-NEXT:    s_mov_b32 s21, s4
; GFX12-GISEL-TRUE16-NEXT:    s_pack_ll_b32_b16 s4, s8, s6
; GFX12-GISEL-TRUE16-NEXT:    s_mov_b32 s20, s3
; GFX12-GISEL-TRUE16-NEXT:    s_mov_b32 s22, s5
; GFX12-GISEL-TRUE16-NEXT:    s_pack_ll_b32_b16 s6, s9, s7
; GFX12-GISEL-TRUE16-NEXT:    s_mov_b32 s5, s4
; GFX12-GISEL-TRUE16-NEXT:    v_dual_mov_b32 v0, s20 :: v_dual_mov_b32 v3, s4
; GFX12-GISEL-TRUE16-NEXT:    v_dual_mov_b32 v7, s1 :: v_dual_mov_b32 v6, s0
; GFX12-GISEL-TRUE16-NEXT:    v_dual_mov_b32 v8, s2 :: v_dual_mov_b32 v1, s21
; GFX12-GISEL-TRUE16-NEXT:    v_dual_mov_b32 v2, s22 :: v_dual_mov_b32 v5, s6
; GFX12-GISEL-TRUE16-NEXT:    v_mov_b32_e32 v4, s5
; GFX12-GISEL-TRUE16-NEXT:    s_mov_b32 s16, s10
; GFX12-GISEL-TRUE16-NEXT:    s_mov_b32 s17, s11
; GFX12-GISEL-TRUE16-NEXT:    s_mov_b32 s18, s12
; GFX12-GISEL-TRUE16-NEXT:    s_mov_b32 s19, s13
; GFX12-GISEL-TRUE16-NEXT:    image_bvh64_intersect_ray v[0:3], [v[6:7], v8, v[0:2], v[3:5]], s[16:19] a16
; GFX12-GISEL-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    ; return to shader part epilog
;
; GFX12-GISEL-FAKE16-LABEL: image_bvh64_intersect_ray_a16:
; GFX12-GISEL-FAKE16:       ; %bb.0: ; %main_body
; GFX12-GISEL-FAKE16-NEXT:    s_mov_b32 s20, s3
; GFX12-GISEL-FAKE16-NEXT:    s_mov_b32 s21, s4
; GFX12-GISEL-FAKE16-NEXT:    s_pack_ll_b32_b16 s4, s8, s6
; GFX12-GISEL-FAKE16-NEXT:    s_mov_b32 s22, s5
; GFX12-GISEL-FAKE16-NEXT:    s_pack_hh_b32_b16 s5, s8, s6
; GFX12-GISEL-FAKE16-NEXT:    s_pack_ll_b32_b16 s6, s9, s7
; GFX12-GISEL-FAKE16-NEXT:    v_dual_mov_b32 v0, s20 :: v_dual_mov_b32 v3, s4
; GFX12-GISEL-FAKE16-NEXT:    v_dual_mov_b32 v7, s1 :: v_dual_mov_b32 v6, s0
; GFX12-GISEL-FAKE16-NEXT:    v_dual_mov_b32 v8, s2 :: v_dual_mov_b32 v1, s21
; GFX12-GISEL-FAKE16-NEXT:    v_dual_mov_b32 v2, s22 :: v_dual_mov_b32 v5, s6
; GFX12-GISEL-FAKE16-NEXT:    v_mov_b32_e32 v4, s5
; GFX12-GISEL-FAKE16-NEXT:    s_mov_b32 s16, s10
; GFX12-GISEL-FAKE16-NEXT:    s_mov_b32 s17, s11
; GFX12-GISEL-FAKE16-NEXT:    s_mov_b32 s18, s12
; GFX12-GISEL-FAKE16-NEXT:    s_mov_b32 s19, s13
; GFX12-GISEL-FAKE16-NEXT:    image_bvh64_intersect_ray v[0:3], [v[6:7], v8, v[0:2], v[3:5]], s[16:19] a16
; GFX12-GISEL-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i64.v4f16(i64 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x half> %ray_dir, <3 x half> %ray_inv_dir, <4 x i32> %tdescr)
  %r = bitcast <4 x i32> %v to <4 x float>
  ret <4 x float> %r
}

; TODO: NSA reassign is very limited and cannot work with VGPR tuples and subregs.

define amdgpu_kernel void @image_bvh_intersect_ray_nsa_reassign(ptr %p_node_ptr, ptr %p_ray, <4 x i32> %tdescr) {
; GFX1013-LABEL: image_bvh_intersect_ray_nsa_reassign:
; GFX1013:       ; %bb.0: ; %main_body
; GFX1013-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX1013-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX1013-NEXT:    v_mov_b32_e32 v6, 4.0
; GFX1013-NEXT:    v_mov_b32_e32 v7, 0x40a00000
; GFX1013-NEXT:    v_mov_b32_e32 v8, 0x40c00000
; GFX1013-NEXT:    v_mov_b32_e32 v9, 0x40e00000
; GFX1013-NEXT:    v_mov_b32_e32 v10, 0x41000000
; GFX1013-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1013-NEXT:    v_add_co_u32 v2, s0, s8, v0
; GFX1013-NEXT:    v_add_co_ci_u32_e64 v3, s0, s9, 0, s0
; GFX1013-NEXT:    v_add_co_u32 v4, s0, s10, v0
; GFX1013-NEXT:    v_add_co_ci_u32_e64 v5, s0, s11, 0, s0
; GFX1013-NEXT:    flat_load_dword v0, v[2:3]
; GFX1013-NEXT:    flat_load_dword v1, v[4:5]
; GFX1013-NEXT:    v_mov_b32_e32 v2, 0
; GFX1013-NEXT:    v_mov_b32_e32 v3, 1.0
; GFX1013-NEXT:    v_mov_b32_e32 v4, 2.0
; GFX1013-NEXT:    v_mov_b32_e32 v5, 0x40400000
; GFX1013-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1013-NEXT:    image_bvh_intersect_ray v[0:3], v[0:10], s[12:15]
; GFX1013-NEXT:    s_waitcnt vmcnt(0)
; GFX1013-NEXT:    flat_store_dwordx4 v[0:1], v[0:3]
; GFX1013-NEXT:    s_endpgm
;
; GFX1030-LABEL: image_bvh_intersect_ray_nsa_reassign:
; GFX1030:       ; %bb.0: ; %main_body
; GFX1030-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX1030-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX1030-NEXT:    v_mov_b32_e32 v10, 0x41000000
; GFX1030-NEXT:    v_mov_b32_e32 v9, 0x40e00000
; GFX1030-NEXT:    v_mov_b32_e32 v8, 0x40c00000
; GFX1030-NEXT:    v_mov_b32_e32 v7, 0x40a00000
; GFX1030-NEXT:    v_mov_b32_e32 v6, 4.0
; GFX1030-NEXT:    v_mov_b32_e32 v5, 0x40400000
; GFX1030-NEXT:    v_mov_b32_e32 v4, 2.0
; GFX1030-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-NEXT:    v_add_co_u32 v0, s0, s0, v2
; GFX1030-NEXT:    v_add_co_ci_u32_e64 v1, null, s1, 0, s0
; GFX1030-NEXT:    v_add_co_u32 v2, s0, s2, v2
; GFX1030-NEXT:    v_add_co_ci_u32_e64 v3, null, s3, 0, s0
; GFX1030-NEXT:    flat_load_dword v0, v[0:1]
; GFX1030-NEXT:    flat_load_dword v1, v[2:3]
; GFX1030-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030-NEXT:    v_mov_b32_e32 v3, 1.0
; GFX1030-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1030-NEXT:    image_bvh_intersect_ray v[0:3], v[0:10], s[4:7]
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    flat_store_dwordx4 v[0:1], v[0:3]
; GFX1030-NEXT:    s_endpgm
;
; GFX11-LABEL: image_bvh_intersect_ray_nsa_reassign:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX11-NEXT:    v_dual_mov_b32 v7, 1.0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-NEXT:    v_dual_mov_b32 v5, 0x40a00000 :: v_dual_mov_b32 v6, 0
; GFX11-NEXT:    v_mov_b32_e32 v8, 2.0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX11-NEXT:    v_mov_b32_e32 v4, 4.0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v0, s0, s0, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, s1, 0, s0
; GFX11-NEXT:    v_add_co_u32 v2, s0, s2, v2
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, s3, 0, s0
; GFX11-NEXT:    flat_load_b32 v9, v[0:1]
; GFX11-NEXT:    flat_load_b32 v10, v[2:3]
; GFX11-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; GFX11-NEXT:    v_mov_b32_e32 v1, 0x40e00000
; GFX11-NEXT:    v_mov_b32_e32 v2, 0x41000000
; GFX11-NEXT:    v_mov_b32_e32 v3, 0x40400000
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    image_bvh_intersect_ray v[0:3], [v9, v10, v[6:8], v[3:5], v[0:2]], s[4:7]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    flat_store_b128 v[0:1], v[0:3]
; GFX11-NEXT:    s_endpgm
;
; GFX12-SDAG-LABEL: image_bvh_intersect_ray_nsa_reassign:
; GFX12-SDAG:       ; %bb.0: ; %main_body
; GFX12-SDAG-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v7, 1.0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v5, 0x40a00000 :: v_dual_mov_b32 v6, 0
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v8, 2.0
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX12-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v4, 4.0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, s0, s0, v2
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, s1, 0, s0
; GFX12-SDAG-NEXT:    v_add_co_u32 v2, s0, s2, v2
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v3, null, s3, 0, s0
; GFX12-SDAG-NEXT:    flat_load_b32 v9, v[0:1]
; GFX12-SDAG-NEXT:    flat_load_b32 v10, v[2:3]
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v1, 0x40e00000
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v2, 0x41000000
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v3, 0x40400000
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    image_bvh_intersect_ray v[0:3], [v9, v10, v[6:8], v[3:5], v[0:2]], s[4:7]
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    flat_store_b128 v[0:1], v[0:3]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: image_bvh_intersect_ray_nsa_reassign:
; GFX12-GISEL:       ; %bb.0: ; %main_body
; GFX12-GISEL-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    s_mov_b32 s10, 0x40a00000
; GFX12-GISEL-NEXT:    s_mov_b32 s9, 4.0
; GFX12-GISEL-NEXT:    s_mov_b32 s8, 0x40400000
; GFX12-GISEL-NEXT:    s_mov_b32 s12, 0x40c00000
; GFX12-GISEL-NEXT:    v_lshlrev_b32_e32 v4, 2, v0
; GFX12-GISEL-NEXT:    s_mov_b32 s14, 0x41000000
; GFX12-GISEL-NEXT:    s_mov_b32 s13, 0x40e00000
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v6, s12
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v8, s14 :: v_dual_mov_b32 v7, s13
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-GISEL-NEXT:    s_mov_b32 s2, 2.0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-GISEL-NEXT:    s_mov_b32 s0, 0
; GFX12-GISEL-NEXT:    s_mov_b32 s1, 1.0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX12-GISEL-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v4
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX12-GISEL-NEXT:    flat_load_b32 v9, v[0:1]
; GFX12-GISEL-NEXT:    flat_load_b32 v10, v[2:3]
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffe
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s8
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, s1 :: v_dual_mov_b32 v2, s2
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v4, s9 :: v_dual_mov_b32 v5, s10
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    image_bvh_intersect_ray v[0:3], [v9, v10, v[0:2], v[3:5], v[6:8]], s[4:7]
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    flat_store_b128 v[0:1], v[0:3]
; GFX12-GISEL-NEXT:    s_endpgm
main_body:
  %lid = tail call i32 @llvm.amdgcn.workitem.id.x()
  %gep_node_ptr = getelementptr inbounds i32, ptr %p_node_ptr, i32 %lid
  %node_ptr = load i32, ptr %gep_node_ptr, align 4
  %gep_ray = getelementptr inbounds float, ptr %p_ray, i32 %lid
  %ray_extent = load float, ptr %gep_ray, align 4
  %ray_origin0 = insertelement <3 x float> poison, float 0.0, i32 0
  %ray_origin1 = insertelement <3 x float> %ray_origin0, float 1.0, i32 1
  %ray_origin = insertelement <3 x float> %ray_origin1, float 2.0, i32 2
  %ray_dir0 = insertelement <3 x float> poison, float 3.0, i32 0
  %ray_dir1 = insertelement <3 x float> %ray_dir0, float 4.0, i32 1
  %ray_dir = insertelement <3 x float> %ray_dir1, float 5.0, i32 2
  %ray_inv_dir0 = insertelement <3 x float> poison, float 6.0, i32 0
  %ray_inv_dir1 = insertelement <3 x float> %ray_inv_dir0, float 7.0, i32 1
  %ray_inv_dir = insertelement <3 x float> %ray_inv_dir1, float 8.0, i32 2
  %v = call <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i32.v4f32(i32 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x float> %ray_dir, <3 x float> %ray_inv_dir, <4 x i32> %tdescr)
  store <4 x i32> %v, ptr poison
  ret void
}

define amdgpu_kernel void @image_bvh_intersect_ray_a16_nsa_reassign(ptr %p_node_ptr, ptr %p_ray, <4 x i32> %tdescr) {
; GFX1013-LABEL: image_bvh_intersect_ray_a16_nsa_reassign:
; GFX1013:       ; %bb.0: ; %main_body
; GFX1013-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX1013-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX1013-NEXT:    v_mov_b32_e32 v6, 0x46004500
; GFX1013-NEXT:    v_mov_b32_e32 v7, 0x48004700
; GFX1013-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1013-NEXT:    v_add_co_u32 v2, s0, s8, v0
; GFX1013-NEXT:    v_add_co_ci_u32_e64 v3, s0, s9, 0, s0
; GFX1013-NEXT:    v_add_co_u32 v4, s0, s10, v0
; GFX1013-NEXT:    v_add_co_ci_u32_e64 v5, s0, s11, 0, s0
; GFX1013-NEXT:    flat_load_dword v0, v[2:3]
; GFX1013-NEXT:    flat_load_dword v1, v[4:5]
; GFX1013-NEXT:    v_mov_b32_e32 v2, 0
; GFX1013-NEXT:    v_mov_b32_e32 v3, 1.0
; GFX1013-NEXT:    v_mov_b32_e32 v4, 2.0
; GFX1013-NEXT:    v_mov_b32_e32 v5, 0x44004200
; GFX1013-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1013-NEXT:    image_bvh_intersect_ray v[0:3], v[0:7], s[12:15] a16
; GFX1013-NEXT:    s_waitcnt vmcnt(0)
; GFX1013-NEXT:    flat_store_dwordx4 v[0:1], v[0:3]
; GFX1013-NEXT:    s_endpgm
;
; GFX1030-LABEL: image_bvh_intersect_ray_a16_nsa_reassign:
; GFX1030:       ; %bb.0: ; %main_body
; GFX1030-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX1030-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX1030-NEXT:    v_mov_b32_e32 v4, 2.0
; GFX1030-NEXT:    v_mov_b32_e32 v5, 0x44004200
; GFX1030-NEXT:    v_mov_b32_e32 v6, 0x46004500
; GFX1030-NEXT:    v_mov_b32_e32 v7, 0x48004700
; GFX1030-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-NEXT:    v_add_co_u32 v0, s0, s0, v2
; GFX1030-NEXT:    v_add_co_ci_u32_e64 v1, null, s1, 0, s0
; GFX1030-NEXT:    v_add_co_u32 v2, s0, s2, v2
; GFX1030-NEXT:    v_add_co_ci_u32_e64 v3, null, s3, 0, s0
; GFX1030-NEXT:    flat_load_dword v0, v[0:1]
; GFX1030-NEXT:    flat_load_dword v1, v[2:3]
; GFX1030-NEXT:    v_mov_b32_e32 v2, 0
; GFX1030-NEXT:    v_mov_b32_e32 v3, 1.0
; GFX1030-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1030-NEXT:    image_bvh_intersect_ray v[0:3], v[0:7], s[4:7] a16
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    flat_store_dwordx4 v[0:1], v[0:3]
; GFX1030-NEXT:    s_endpgm
;
; GFX11-LABEL: image_bvh_intersect_ray_a16_nsa_reassign:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    v_dual_mov_b32 v4, 1.0 :: v_dual_mov_b32 v5, 2.0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v0, s0, s0, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, s1, 0, s0
; GFX11-NEXT:    v_add_co_u32 v2, s0, s2, v2
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, s3, 0, s0
; GFX11-NEXT:    flat_load_b32 v6, v[0:1]
; GFX11-NEXT:    flat_load_b32 v7, v[2:3]
; GFX11-NEXT:    v_mov_b32_e32 v0, 0x46004200
; GFX11-NEXT:    v_mov_b32_e32 v1, 0x47004400
; GFX11-NEXT:    v_dual_mov_b32 v2, 0x48004500 :: v_dual_mov_b32 v3, 0
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    image_bvh_intersect_ray v[0:3], [v6, v7, v[3:5], v[0:2]], s[4:7] a16
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    flat_store_b128 v[0:1], v[0:3]
; GFX11-NEXT:    s_endpgm
;
; GFX12-SDAG-LABEL: image_bvh_intersect_ray_a16_nsa_reassign:
; GFX12-SDAG:       ; %bb.0: ; %main_body
; GFX12-SDAG-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v4, 1.0 :: v_dual_mov_b32 v5, 2.0
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, s0, s0, v2
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, s1, 0, s0
; GFX12-SDAG-NEXT:    v_add_co_u32 v2, s0, s2, v2
; GFX12-SDAG-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v3, null, s3, 0, s0
; GFX12-SDAG-NEXT:    flat_load_b32 v6, v[0:1]
; GFX12-SDAG-NEXT:    flat_load_b32 v7, v[2:3]
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v0, 0x46004200
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v1, 0x47004400
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v2, 0x48004500 :: v_dual_mov_b32 v3, 0
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    image_bvh_intersect_ray v[0:3], [v6, v7, v[3:5], v[0:2]], s[4:7] a16
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    flat_store_b128 v[0:1], v[0:3]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: image_bvh_intersect_ray_a16_nsa_reassign:
; GFX12-GISEL:       ; %bb.0: ; %main_body
; GFX12-GISEL-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    s_mov_b32 s8, 0x42004600
; GFX12-GISEL-NEXT:    s_mov_b32 s9, 0x44004700
; GFX12-GISEL-NEXT:    s_mov_b32 s10, 0x45004800
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_lshlrev_b32_e32 v4, 2, v0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX12-GISEL-NEXT:    s_mov_b32 s2, 2.0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-GISEL-NEXT:    s_mov_b32 s0, 0
; GFX12-GISEL-NEXT:    s_mov_b32 s1, 1.0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX12-GISEL-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v4
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX12-GISEL-NEXT:    flat_load_b32 v6, v[0:1]
; GFX12-GISEL-NEXT:    flat_load_b32 v7, v[2:3]
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffe
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s8
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v1, s1 :: v_dual_mov_b32 v2, s2
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v4, s9 :: v_dual_mov_b32 v5, s10
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    image_bvh_intersect_ray v[0:3], [v6, v7, v[0:2], v[3:5]], s[4:7] a16
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    flat_store_b128 v[0:1], v[0:3]
; GFX12-GISEL-NEXT:    s_endpgm
main_body:
  %lid = tail call i32 @llvm.amdgcn.workitem.id.x()
  %gep_node_ptr = getelementptr inbounds i32, ptr %p_node_ptr, i32 %lid
  %node_ptr = load i32, ptr %gep_node_ptr, align 4
  %gep_ray = getelementptr inbounds float, ptr %p_ray, i32 %lid
  %ray_extent = load float, ptr %gep_ray, align 4
  %ray_origin0 = insertelement <3 x float> poison, float 0.0, i32 0
  %ray_origin1 = insertelement <3 x float> %ray_origin0, float 1.0, i32 1
  %ray_origin = insertelement <3 x float> %ray_origin1, float 2.0, i32 2
  %ray_dir0 = insertelement <3 x half> poison, half 3.0, i32 0
  %ray_dir1 = insertelement <3 x half> %ray_dir0, half 4.0, i32 1
  %ray_dir = insertelement <3 x half> %ray_dir1, half 5.0, i32 2
  %ray_inv_dir0 = insertelement <3 x half> poison, half 6.0, i32 0
  %ray_inv_dir1 = insertelement <3 x half> %ray_inv_dir0, half 7.0, i32 1
  %ray_inv_dir = insertelement <3 x half> %ray_inv_dir1, half 8.0, i32 2
  %v = call <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i32.v4f16(i32 %node_ptr, float %ray_extent, <3 x float> %ray_origin, <3 x half> %ray_dir, <3 x half> %ray_inv_dir, <4 x i32> %tdescr)
  store <4 x i32> %v, ptr poison
  ret void
}

define amdgpu_kernel void @image_bvh64_intersect_ray_nsa_reassign(ptr %p_ray, <4 x i32> %tdescr) {
; GFX1013-LABEL: image_bvh64_intersect_ray_nsa_reassign:
; GFX1013:       ; %bb.0: ; %main_body
; GFX1013-NEXT:    s_clause 0x1
; GFX1013-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x24
; GFX1013-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x34
; GFX1013-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX1013-NEXT:    v_mov_b32_e32 v3, 0
; GFX1013-NEXT:    v_mov_b32_e32 v4, 1.0
; GFX1013-NEXT:    v_mov_b32_e32 v5, 2.0
; GFX1013-NEXT:    v_mov_b32_e32 v6, 0x40400000
; GFX1013-NEXT:    v_mov_b32_e32 v7, 4.0
; GFX1013-NEXT:    v_mov_b32_e32 v8, 0x40a00000
; GFX1013-NEXT:    v_mov_b32_e32 v9, 0x40c00000
; GFX1013-NEXT:    v_mov_b32_e32 v10, 0x40e00000
; GFX1013-NEXT:    v_mov_b32_e32 v11, 0x41000000
; GFX1013-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1013-NEXT:    v_add_co_u32 v0, s4, s6, v0
; GFX1013-NEXT:    v_add_co_ci_u32_e64 v1, s4, s7, 0, s4
; GFX1013-NEXT:    flat_load_dword v2, v[0:1]
; GFX1013-NEXT:    v_mov_b32_e32 v0, 0xb36211c7
; GFX1013-NEXT:    v_bfrev_b32_e32 v1, 4.0
; GFX1013-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1013-NEXT:    image_bvh64_intersect_ray v[0:3], v[0:11], s[0:3]
; GFX1013-NEXT:    s_waitcnt vmcnt(0)
; GFX1013-NEXT:    flat_store_dwordx4 v[0:1], v[0:3]
; GFX1013-NEXT:    s_endpgm
;
; GFX1030-LABEL: image_bvh64_intersect_ray_nsa_reassign:
; GFX1030:       ; %bb.0: ; %main_body
; GFX1030-NEXT:    s_clause 0x1
; GFX1030-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x24
; GFX1030-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x34
; GFX1030-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX1030-NEXT:    v_mov_b32_e32 v3, 0
; GFX1030-NEXT:    v_mov_b32_e32 v11, 0x41000000
; GFX1030-NEXT:    v_mov_b32_e32 v10, 0x40e00000
; GFX1030-NEXT:    v_mov_b32_e32 v9, 0x40c00000
; GFX1030-NEXT:    v_mov_b32_e32 v8, 0x40a00000
; GFX1030-NEXT:    v_mov_b32_e32 v7, 4.0
; GFX1030-NEXT:    v_mov_b32_e32 v6, 0x40400000
; GFX1030-NEXT:    v_mov_b32_e32 v5, 2.0
; GFX1030-NEXT:    v_mov_b32_e32 v4, 1.0
; GFX1030-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-NEXT:    v_add_co_u32 v0, s4, s6, v0
; GFX1030-NEXT:    v_add_co_ci_u32_e64 v1, null, s7, 0, s4
; GFX1030-NEXT:    flat_load_dword v2, v[0:1]
; GFX1030-NEXT:    v_bfrev_b32_e32 v1, 4.0
; GFX1030-NEXT:    v_mov_b32_e32 v0, 0xb36211c7
; GFX1030-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1030-NEXT:    image_bvh64_intersect_ray v[0:3], v[0:11], s[0:3]
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    flat_store_dwordx4 v[0:1], v[0:3]
; GFX1030-NEXT:    s_endpgm
;
; GFX11-LABEL: image_bvh64_intersect_ray_nsa_reassign:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[6:7], s[4:5], 0x24
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x34
; GFX11-NEXT:    v_dual_mov_b32 v7, 1.0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-NEXT:    v_mov_b32_e32 v2, 0x41000000
; GFX11-NEXT:    v_dual_mov_b32 v3, 0x40400000 :: v_dual_mov_b32 v4, 4.0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_dual_mov_b32 v5, 0x40a00000 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX11-NEXT:    v_mov_b32_e32 v6, 0
; GFX11-NEXT:    v_dual_mov_b32 v8, 2.0 :: v_dual_mov_b32 v9, 0xb36211c7
; GFX11-NEXT:    v_bfrev_b32_e32 v10, 4.0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v0, s4, s6, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, s7, 0, s4
; GFX11-NEXT:    flat_load_b32 v11, v[0:1]
; GFX11-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; GFX11-NEXT:    v_mov_b32_e32 v1, 0x40e00000
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    image_bvh64_intersect_ray v[0:3], [v[9:10], v11, v[6:8], v[3:5], v[0:2]], s[0:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    flat_store_b128 v[0:1], v[0:3]
; GFX11-NEXT:    s_endpgm
;
; GFX12-SDAG-LABEL: image_bvh64_intersect_ray_nsa_reassign:
; GFX12-SDAG:       ; %bb.0: ; %main_body
; GFX12-SDAG-NEXT:    s_clause 0x1
; GFX12-SDAG-NEXT:    s_load_b64 s[6:7], s[4:5], 0x24
; GFX12-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x34
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v7, 1.0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v2, 0x41000000
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v3, 0x40400000 :: v_dual_mov_b32 v4, 4.0
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v5, 0x40a00000 :: v_dual_lshlrev_b32 v0, 2, v0
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v6, 0
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v8, 2.0 :: v_dual_mov_b32 v9, 0xb36211c7
; GFX12-SDAG-NEXT:    v_bfrev_b32_e32 v10, 4.0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, s4, s6, v0
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, s7, 0, s4
; GFX12-SDAG-NEXT:    flat_load_b32 v11, v[0:1]
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v1, 0x40e00000
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    image_bvh64_intersect_ray v[0:3], [v[9:10], v11, v[6:8], v[3:5], v[0:2]], s[0:3]
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    flat_store_b128 v[0:1], v[0:3]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: image_bvh64_intersect_ray_nsa_reassign:
; GFX12-GISEL:       ; %bb.0: ; %main_body
; GFX12-GISEL-NEXT:    s_clause 0x1
; GFX12-GISEL-NEXT:    s_load_b64 s[6:7], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x34
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    s_mov_b32 s5, 1.0
; GFX12-GISEL-NEXT:    s_mov_b32 s4, 0
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v9, 0xb36211c7
; GFX12-GISEL-NEXT:    s_mov_b32 s8, 0x40400000
; GFX12-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX12-GISEL-NEXT:    s_mov_b32 s12, 0x40c00000
; GFX12-GISEL-NEXT:    s_mov_b32 s10, 0x40a00000
; GFX12-GISEL-NEXT:    s_mov_b32 s9, 4.0
; GFX12-GISEL-NEXT:    s_mov_b32 s14, 0x41000000
; GFX12-GISEL-NEXT:    s_mov_b32 s13, 0x40e00000
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v6, s12
; GFX12-GISEL-NEXT:    v_bfrev_b32_e32 v10, 4.0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v8, s14 :: v_dual_mov_b32 v3, s8
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v4, s9 :: v_dual_mov_b32 v7, s13
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v5, s10 :: v_dual_mov_b32 v0, s6
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, s7
; GFX12-GISEL-NEXT:    s_mov_b32 s6, 2.0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX12-GISEL-NEXT:    flat_load_b32 v11, v[0:1]
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffe
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v2, s6
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    image_bvh64_intersect_ray v[0:3], [v[9:10], v11, v[0:2], v[3:5], v[6:8]], s[0:3]
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    flat_store_b128 v[0:1], v[0:3]
; GFX12-GISEL-NEXT:    s_endpgm
main_body:
  %lid = tail call i32 @llvm.amdgcn.workitem.id.x()
  %gep_ray = getelementptr inbounds float, ptr %p_ray, i32 %lid
  %ray_extent = load float, ptr %gep_ray, align 4
  %ray_origin0 = insertelement <3 x float> poison, float 0.0, i32 0
  %ray_origin1 = insertelement <3 x float> %ray_origin0, float 1.0, i32 1
  %ray_origin = insertelement <3 x float> %ray_origin1, float 2.0, i32 2
  %ray_dir0 = insertelement <3 x float> poison, float 3.0, i32 0
  %ray_dir1 = insertelement <3 x float> %ray_dir0, float 4.0, i32 1
  %ray_dir = insertelement <3 x float> %ray_dir1, float 5.0, i32 2
  %ray_inv_dir0 = insertelement <3 x float> poison, float 6.0, i32 0
  %ray_inv_dir1 = insertelement <3 x float> %ray_inv_dir0, float 7.0, i32 1
  %ray_inv_dir = insertelement <3 x float> %ray_inv_dir1, float 8.0, i32 2
  %v = call <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i64.v4f32(i64 1111111111111, float %ray_extent, <3 x float> %ray_origin, <3 x float> %ray_dir, <3 x float> %ray_inv_dir, <4 x i32> %tdescr)
  store <4 x i32> %v, ptr poison
  ret void
}

define amdgpu_kernel void @image_bvh64_intersect_ray_a16_nsa_reassign(ptr %p_ray, <4 x i32> %tdescr) {
; GFX1013-LABEL: image_bvh64_intersect_ray_a16_nsa_reassign:
; GFX1013:       ; %bb.0: ; %main_body
; GFX1013-NEXT:    s_clause 0x1
; GFX1013-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x24
; GFX1013-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x34
; GFX1013-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX1013-NEXT:    v_mov_b32_e32 v3, 0
; GFX1013-NEXT:    v_mov_b32_e32 v4, 1.0
; GFX1013-NEXT:    v_mov_b32_e32 v5, 2.0
; GFX1013-NEXT:    v_mov_b32_e32 v6, 0x44004200
; GFX1013-NEXT:    v_mov_b32_e32 v7, 0x46004500
; GFX1013-NEXT:    v_mov_b32_e32 v8, 0x48004700
; GFX1013-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1013-NEXT:    v_add_co_u32 v0, s4, s6, v0
; GFX1013-NEXT:    v_add_co_ci_u32_e64 v1, s4, s7, 0, s4
; GFX1013-NEXT:    flat_load_dword v2, v[0:1]
; GFX1013-NEXT:    v_mov_b32_e32 v0, 0xb36211c6
; GFX1013-NEXT:    v_bfrev_b32_e32 v1, 4.0
; GFX1013-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1013-NEXT:    image_bvh64_intersect_ray v[0:3], v[0:8], s[0:3] a16
; GFX1013-NEXT:    s_waitcnt vmcnt(0)
; GFX1013-NEXT:    flat_store_dwordx4 v[0:1], v[0:3]
; GFX1013-NEXT:    s_endpgm
;
; GFX1030-LABEL: image_bvh64_intersect_ray_a16_nsa_reassign:
; GFX1030:       ; %bb.0: ; %main_body
; GFX1030-NEXT:    s_clause 0x1
; GFX1030-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x24
; GFX1030-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x34
; GFX1030-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX1030-NEXT:    v_mov_b32_e32 v3, 0
; GFX1030-NEXT:    v_mov_b32_e32 v5, 2.0
; GFX1030-NEXT:    v_mov_b32_e32 v4, 1.0
; GFX1030-NEXT:    v_mov_b32_e32 v6, 0x44004200
; GFX1030-NEXT:    v_mov_b32_e32 v7, 0x46004500
; GFX1030-NEXT:    v_mov_b32_e32 v8, 0x48004700
; GFX1030-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1030-NEXT:    v_add_co_u32 v0, s4, s6, v0
; GFX1030-NEXT:    v_add_co_ci_u32_e64 v1, null, s7, 0, s4
; GFX1030-NEXT:    flat_load_dword v2, v[0:1]
; GFX1030-NEXT:    v_bfrev_b32_e32 v1, 4.0
; GFX1030-NEXT:    v_mov_b32_e32 v0, 0xb36211c6
; GFX1030-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1030-NEXT:    image_bvh64_intersect_ray v[0:3], v[0:8], s[0:3] a16
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    flat_store_dwordx4 v[0:1], v[0:3]
; GFX1030-NEXT:    s_endpgm
;
; GFX11-LABEL: image_bvh64_intersect_ray_a16_nsa_reassign:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[6:7], s[4:5], 0x24
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x34
; GFX11-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-NEXT:    v_mov_b32_e32 v2, 0x48004500
; GFX11-NEXT:    v_mov_b32_e32 v4, 1.0
; GFX11-NEXT:    v_mov_b32_e32 v6, 0xb36211c6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    v_bfrev_b32_e32 v7, 4.0
; GFX11-NEXT:    v_mov_b32_e32 v5, 2.0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v0, s4, s6, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, s7, 0, s4
; GFX11-NEXT:    flat_load_b32 v8, v[0:1]
; GFX11-NEXT:    v_mov_b32_e32 v0, 0x46004200
; GFX11-NEXT:    v_mov_b32_e32 v1, 0x47004400
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    image_bvh64_intersect_ray v[0:3], [v[6:7], v8, v[3:5], v[0:2]], s[0:3] a16
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    flat_store_b128 v[0:1], v[0:3]
; GFX11-NEXT:    s_endpgm
;
; GFX12-SDAG-LABEL: image_bvh64_intersect_ray_a16_nsa_reassign:
; GFX12-SDAG:       ; %bb.0: ; %main_body
; GFX12-SDAG-NEXT:    s_clause 0x1
; GFX12-SDAG-NEXT:    s_load_b64 s[6:7], s[4:5], 0x24
; GFX12-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x34
; GFX12-SDAG-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v2, 0x48004500
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v4, 1.0
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v6, 0xb36211c6
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX12-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-SDAG-NEXT:    v_bfrev_b32_e32 v7, 4.0
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v5, 2.0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, s4, s6, v0
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, s7, 0, s4
; GFX12-SDAG-NEXT:    flat_load_b32 v8, v[0:1]
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v0, 0x46004200
; GFX12-SDAG-NEXT:    v_mov_b32_e32 v1, 0x47004400
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    image_bvh64_intersect_ray v[0:3], [v[6:7], v8, v[3:5], v[0:2]], s[0:3] a16
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    flat_store_b128 v[0:1], v[0:3]
; GFX12-SDAG-NEXT:    s_endpgm
;
; GFX12-GISEL-LABEL: image_bvh64_intersect_ray_a16_nsa_reassign:
; GFX12-GISEL:       ; %bb.0: ; %main_body
; GFX12-GISEL-NEXT:    s_clause 0x1
; GFX12-GISEL-NEXT:    s_load_b64 s[6:7], s[4:5], 0x24
; GFX12-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x34
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-GISEL-NEXT:    s_mov_b32 s5, 1.0
; GFX12-GISEL-NEXT:    s_mov_b32 s4, 0
; GFX12-GISEL-NEXT:    s_mov_b32 s8, 0x42004600
; GFX12-GISEL-NEXT:    s_mov_b32 s9, 0x44004700
; GFX12-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX12-GISEL-NEXT:    s_mov_b32 s10, 0x45004800
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v6, 0xb36211c6
; GFX12-GISEL-NEXT:    v_bfrev_b32_e32 v7, 4.0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v3, s8 :: v_dual_mov_b32 v4, s9
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v5, s10 :: v_dual_mov_b32 v0, s6
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v1, s7
; GFX12-GISEL-NEXT:    s_mov_b32 s6, 2.0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX12-GISEL-NEXT:    flat_load_b32 v8, v[0:1]
; GFX12-GISEL-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffe
; GFX12-GISEL-NEXT:    v_mov_b32_e32 v2, s6
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    image_bvh64_intersect_ray v[0:3], [v[6:7], v8, v[0:2], v[3:5]], s[0:3] a16
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    flat_store_b128 v[0:1], v[0:3]
; GFX12-GISEL-NEXT:    s_endpgm
main_body:
  %lid = tail call i32 @llvm.amdgcn.workitem.id.x()
  %gep_ray = getelementptr inbounds float, ptr %p_ray, i32 %lid
  %ray_extent = load float, ptr %gep_ray, align 4
  %ray_origin0 = insertelement <3 x float> poison, float 0.0, i32 0
  %ray_origin1 = insertelement <3 x float> %ray_origin0, float 1.0, i32 1
  %ray_origin = insertelement <3 x float> %ray_origin1, float 2.0, i32 2
  %ray_dir0 = insertelement <3 x half> poison, half 3.0, i32 0
  %ray_dir1 = insertelement <3 x half> %ray_dir0, half 4.0, i32 1
  %ray_dir = insertelement <3 x half> %ray_dir1, half 5.0, i32 2
  %ray_inv_dir0 = insertelement <3 x half> poison, half 6.0, i32 0
  %ray_inv_dir1 = insertelement <3 x half> %ray_inv_dir0, half 7.0, i32 1
  %ray_inv_dir = insertelement <3 x half> %ray_inv_dir1, half 8.0, i32 2
  %v = call <4 x i32> @llvm.amdgcn.image.bvh.intersect.ray.i64.v4f16(i64 1111111111110, float %ray_extent, <3 x float> %ray_origin, <3 x half> %ray_dir, <3 x half> %ray_inv_dir, <4 x i32> %tdescr)
  store <4 x i32> %v, ptr poison
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x()
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX11-FAKE16: {{.*}}
; GFX11-TRUE16: {{.*}}
; GFX12-SDAG-FAKE16: {{.*}}
; GFX12-SDAG-TRUE16: {{.*}}
