; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -disable-output "-passes=print<scalar-evolution>" 2>&1 | FileCheck %s

declare i1 @cond()

; FIXME: Range of phi_1 and phi_2 here can be sharpened to [10, 21).
define void @test_01() {
; CHECK-LABEL: 'test_01'
; CHECK-NEXT:  Classifying expressions for: @test_01
; CHECK-NEXT:    %phi_1 = phi i32 [ 10, %entry ], [ %phi_2, %loop ]
; CHECK-NEXT:    --> %phi_1 U: [0,31) S: [0,31) Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %phi_2 = phi i32 [ 20, %entry ], [ %phi_1, %loop ]
; CHECK-NEXT:    --> %phi_2 U: [0,31) S: [0,31) Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %cond = call i1 @cond()
; CHECK-NEXT:    --> %cond U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @test_01
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
entry:
  br label %loop

loop:
  %phi_1 = phi i32 [ 10, %entry], [%phi_2, %loop]
  %phi_2 = phi i32 [ 20, %entry], [%phi_1, %loop]
  %cond = call i1 @cond()
  br i1 %cond, label %loop, label %exit

exit:
  ret void
}

; FIXME: Both inner and outer loop Phis should have the same range [0, 3000).
define void @test_02(ptr %p, ptr %q) {
; CHECK-LABEL: 'test_02'
; CHECK-NEXT:  Classifying expressions for: @test_02
; CHECK-NEXT:    %start = load i32, ptr %p, align 4, !range !0
; CHECK-NEXT:    --> %start U: [0,1000) S: [0,1000)
; CHECK-NEXT:    %outer_phi = phi i32 [ %start, %entry ], [ %inner_lcssa, %outer_backedge ]
; CHECK-NEXT:    --> %outer_phi U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %outer_loop: Variant, %inner_loop: Invariant }
; CHECK-NEXT:    %inner_phi = phi i32 [ %outer_phi, %outer_loop ], [ %inner_load, %inner_loop ]
; CHECK-NEXT:    --> %inner_phi U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %inner_loop: Variant, %outer_loop: Variant }
; CHECK-NEXT:    %inner_load = load i32, ptr %q, align 4, !range !1
; CHECK-NEXT:    --> %inner_load U: [2000,3000) S: [2000,3000) Exits: <<Unknown>> LoopDispositions: { %inner_loop: Variant, %outer_loop: Variant }
; CHECK-NEXT:    %inner_cond = call i1 @cond()
; CHECK-NEXT:    --> %inner_cond U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %inner_loop: Variant, %outer_loop: Variant }
; CHECK-NEXT:    %inner_lcssa = phi i32 [ %inner_phi, %inner_loop ]
; CHECK-NEXT:    --> %inner_phi U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %outer_loop: Variant, %inner_loop: Variant }
; CHECK-NEXT:    %outer_cond = call i1 @cond()
; CHECK-NEXT:    --> %outer_cond U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %outer_loop: Variant, %inner_loop: Invariant }
; CHECK-NEXT:  Determining loop execution counts for: @test_02
; CHECK-NEXT:  Loop %inner_loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %inner_loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %inner_loop: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:  Loop %outer_loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %outer_loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %outer_loop: Unpredictable symbolic max backedge-taken count.
;
entry:
  %start = load i32, ptr %p, !range !0
  br label %outer_loop

outer_loop:
  %outer_phi = phi i32 [ %start, %entry], [%inner_lcssa, %outer_backedge]
  br label %inner_loop

inner_loop:
  %inner_phi = phi i32 [%outer_phi, %outer_loop], [%inner_load, %inner_loop]
  %inner_load = load i32, ptr %q, !range !1
  %inner_cond = call i1 @cond()
  br i1 %inner_cond, label %inner_loop, label %outer_backedge

outer_backedge:
  %inner_lcssa = phi i32 [%inner_phi, %inner_loop]
  %outer_cond = call i1 @cond()
  br i1 %outer_cond, label %outer_loop, label %exit

exit:
  ret void
}

; FIXME: All phis should have range [0, 3000)
define void @test_03(ptr %p, ptr %q) {
; CHECK-LABEL: 'test_03'
; CHECK-NEXT:  Classifying expressions for: @test_03
; CHECK-NEXT:    %start_1 = load i32, ptr %p, align 4, !range !0
; CHECK-NEXT:    --> %start_1 U: [0,1000) S: [0,1000)
; CHECK-NEXT:    %start_2 = load i32, ptr %q, align 4, !range !1
; CHECK-NEXT:    --> %start_2 U: [2000,3000) S: [2000,3000)
; CHECK-NEXT:    %outer_phi = phi i32 [ %start_1, %entry ], [ %inner_lcssa, %outer_backedge ]
; CHECK-NEXT:    --> %outer_phi U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %outer_loop: Variant, %inner_loop: Invariant }
; CHECK-NEXT:    %inner_phi_1 = phi i32 [ %outer_phi, %outer_loop ], [ %inner_phi_2, %inner_loop ]
; CHECK-NEXT:    --> %inner_phi_1 U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %inner_loop: Variant, %outer_loop: Variant }
; CHECK-NEXT:    %inner_phi_2 = phi i32 [ %start_2, %outer_loop ], [ %inner_phi_1, %inner_loop ]
; CHECK-NEXT:    --> %inner_phi_2 U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %inner_loop: Variant, %outer_loop: Variant }
; CHECK-NEXT:    %inner_cond = call i1 @cond()
; CHECK-NEXT:    --> %inner_cond U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %inner_loop: Variant, %outer_loop: Variant }
; CHECK-NEXT:    %inner_lcssa = phi i32 [ %inner_phi_1, %inner_loop ]
; CHECK-NEXT:    --> %inner_phi_1 U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %outer_loop: Variant, %inner_loop: Variant }
; CHECK-NEXT:    %outer_cond = call i1 @cond()
; CHECK-NEXT:    --> %outer_cond U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %outer_loop: Variant, %inner_loop: Invariant }
; CHECK-NEXT:  Determining loop execution counts for: @test_03
; CHECK-NEXT:  Loop %inner_loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %inner_loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %inner_loop: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:  Loop %outer_loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %outer_loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %outer_loop: Unpredictable symbolic max backedge-taken count.
;
entry:
  %start_1 = load i32, ptr %p, !range !0
  %start_2 = load i32, ptr %q, !range !1
  br label %outer_loop

outer_loop:
  %outer_phi = phi i32 [ %start_1, %entry], [%inner_lcssa, %outer_backedge]
  br label %inner_loop

inner_loop:
  %inner_phi_1 = phi i32 [%outer_phi, %outer_loop], [%inner_phi_2, %inner_loop]
  %inner_phi_2 = phi i32 [%start_2, %outer_loop], [%inner_phi_1, %inner_loop]
  %inner_cond = call i1 @cond()
  br i1 %inner_cond, label %inner_loop, label %outer_backedge

outer_backedge:
  %inner_lcssa = phi i32 [%inner_phi_1, %inner_loop]
  %outer_cond = call i1 @cond()
  br i1 %outer_cond, label %outer_loop, label %exit

exit:
  ret void
}

!0 = !{i32 0, i32 1000}
!1 = !{i32 2000, i32 3000}
