; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --no-generate-body-for-unused-prefixes
; i686 uses -fast-isel-abort=1 only as argument lowering is not supported, so check that FastISel didn't miss the call.
; RUN: llc < %s -fast-isel -pass-remarks-missed=sdagisel -mtriple=i686-unknown-unknown -mattr=+crc32 2>&1 >/dev/null | FileCheck %s -check-prefix=STDERR-X86 -allow-empty
; RUN: llc < %s -fast-isel -fast-isel-abort=1 -mtriple=i686-unknown-unknown -mattr=-sse4.2,+crc32 | FileCheck %s -check-prefix=X86
; RUN: llc < %s -fast-isel -fast-isel-abort=1 -mtriple=i686-unknown-unknown -mattr=+crc32 | FileCheck %s -check-prefix=X86
; RUN: llc < %s -fast-isel -fast-isel-abort=3 -mtriple=x86_64-unknown-unknown -mattr=-sse4.2,+crc32 --show-mc-encoding | FileCheck %s -check-prefix=X64
; RUN: llc < %s -fast-isel -fast-isel-abort=3 -mtriple=x86_64-unknown-unknown -mattr=+crc32 --show-mc-encoding | FileCheck %s -check-prefix=X64
; RUN: llc < %s -fast-isel -fast-isel-abort=3 -mtriple=x86_64-unknown-unknown -mattr=+crc32,+egpr --show-mc-encoding | FileCheck %s -check-prefix=EGPR

; NOTE: This should use IR equivalent to what is generated by clang/test/CodeGen/sse42-builtins.c

; STDERR-X86-NOT: FastISel missed call:   %res = call i32 @llvm.x86.sse42.crc32

; Note: %a1 is i32 as FastISel can't handle i8/i16 arguments.
define i32 @test_mm_crc32_u8(i32 %a0, i32 %a1) nounwind {
; X86-LABEL: test_mm_crc32_u8:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    crc32b %cl, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_crc32_u8:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax # encoding: [0x89,0xf8]
; X64-NEXT:    crc32b %sil, %eax # encoding: [0xf2,0x40,0x0f,0x38,0xf0,0xc6]
; X64-NEXT:    retq # encoding: [0xc3]
;
; EGPR-LABEL: test_mm_crc32_u8:
; EGPR:       # %bb.0:
; EGPR-NEXT:    movl %edi, %eax # encoding: [0x89,0xf8]
; EGPR-NEXT:    crc32b %sil, %eax # EVEX TO LEGACY Compression encoding: [0xf2,0x40,0x0f,0x38,0xf0,0xc6]
; EGPR-NEXT:    retq # encoding: [0xc3]
  %trunc = trunc i32 %a1 to i8
  %res = call i32 @llvm.x86.sse42.crc32.32.8(i32 %a0, i8 %trunc)
  ret i32 %res
}
declare i32 @llvm.x86.sse42.crc32.32.8(i32, i8) nounwind readnone

; Note: %a1 is i32 as FastISel can't handle i8/i16 arguments.
define i32 @test_mm_crc32_u16(i32 %a0, i32 %a1) nounwind {
; X86-LABEL: test_mm_crc32_u16:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    crc32w %cx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_crc32_u16:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax # encoding: [0x89,0xf8]
; X64-NEXT:    crc32w %si, %eax # encoding: [0x66,0xf2,0x0f,0x38,0xf1,0xc6]
; X64-NEXT:    retq # encoding: [0xc3]
;
; EGPR-LABEL: test_mm_crc32_u16:
; EGPR:       # %bb.0:
; EGPR-NEXT:    movl %edi, %eax # encoding: [0x89,0xf8]
; EGPR-NEXT:    crc32w %si, %eax # EVEX TO LEGACY Compression encoding: [0x66,0xf2,0x0f,0x38,0xf1,0xc6]
; EGPR-NEXT:    retq # encoding: [0xc3]
  %trunc = trunc i32 %a1 to i16
  %res = call i32 @llvm.x86.sse42.crc32.32.16(i32 %a0, i16 %trunc)
  ret i32 %res
}
declare i32 @llvm.x86.sse42.crc32.32.16(i32, i16) nounwind readnone

define i32 @test_mm_crc32_u32(i32 %a0, i32 %a1) nounwind {
; X86-LABEL: test_mm_crc32_u32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    crc32l {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_crc32_u32:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax # encoding: [0x89,0xf8]
; X64-NEXT:    crc32l %esi, %eax # encoding: [0xf2,0x0f,0x38,0xf1,0xc6]
; X64-NEXT:    retq # encoding: [0xc3]
;
; EGPR-LABEL: test_mm_crc32_u32:
; EGPR:       # %bb.0:
; EGPR-NEXT:    movl %edi, %eax # encoding: [0x89,0xf8]
; EGPR-NEXT:    crc32l %esi, %eax # EVEX TO LEGACY Compression encoding: [0xf2,0x0f,0x38,0xf1,0xc6]
; EGPR-NEXT:    retq # encoding: [0xc3]
  %res = call i32 @llvm.x86.sse42.crc32.32.32(i32 %a0, i32 %a1)
  ret i32 %res
}
declare i32 @llvm.x86.sse42.crc32.32.32(i32, i32) nounwind readnone
