<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

June 1, 2020

Host: Michael Dolan

Rotating Secretary: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Mei Chu (_TSC_) - Sony Pictures Imageworks
  * [X] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [X] John Mertic - Academy Software Foundation / Linux Foundation
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Mark Titchener (_TSC_) - Foundry
  * [ ] Carl Rand (_TSC_) - Weta Digital
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Bernard Lefebvre - Autodesk
  * [X] Troy Sobotka
  * [X] Joseph Goldstone - ARRI

# **OCIO TSC Meeting Notes**

* OpenColorIO-Config-ACES first steps
    - Michael: Thinking of setting up a meeting to discuss a starting point. Do 
      we feel that a working group would be good for oversight?
    - Sean: Could use oversight of technical maintenance, and of what goes into 
      the config; architecture vs implementation. Need to decide who owns the 
      decision making. OCIO or ACES?
    - Michael: In previous discussion Academy preferred OCIO ownership, but 
      they were happy to guide.
    - Sean: Need to discuss topics like: should the config have 300 color 
      spaces or 20?
    - Doug: It's an Interesting issue. There are cameras in there that perhaps 
      should not be there. A group can discuss what the config should be. 
      General VFX config? Or implementation of ACES?
    - Joseph: Should known broken transforms be weeded out or fixed? Can 
      someone at Canon confirm the transform is right? Could be a discussion 
      with ACES.
    - Carol: Would be useful to have someone from ACES involved.
    - Doug: From the previous conversation, we would become a product partner, 
      and ACES is involved through that. Partners will meet at events to 
      discuss how things are going. Somewhat hands off so far, and they 
      generally want external organizations to manage it. There's no active 
      certification process to test IDTs, etc. Up to product partners to own 
      their implementations.
    - Michael: Does the ACES logo program have a validation process?
    - Doug: There is a test kit, with a list of categories for levels of 
      certification; for grading software vs. a camera, for example. The test 
      kit had CTL and CLF files, etc. It may not be completed, due to ACESclip 
      being incomplete? 
    - Michael: For validation it would be great to have CI with verification of
      config against ACES test images. I would be interested in contributing 
      this if there's need.
    - Doug: There are some issues with some ACES reference images that don't 
      match CTL. I support the need to have a group meet and oversee these 
      configs.
    - Carol: Perhaps we can have an ACES Central partnership; a dedicated place 
      to talk and participate? ACES sometimes get blamed for problems with 
      implementations. We need to be partners.
    - Michael: They did express the desire to partner with OCIO. ACES just 
      wouldn't own the code.
    - Sean: Should we tease apart the concept of an ACES config? It's really 
      more of a workhorse config for the industry currently. Studios grab it 
      and use it. Different configs have different needs. Just an ACES config
      would be smaller and more straightforward. We should get a sampling of 
      users; pull them into the conversation. It's not just about ACES and 
      OCIO, but about helping the community with color management.
    - Troy: The current config has some scripting implement already.
    - **TODO**: Michael will work on getting a meeting schedule with interested 
      parties.

* Keeping track of OCIO v2 TODOs
    - Michael: Proposal to use GitHub Projects for _some_ task management:
        - [GitHub Projects](https://github.com/AcademySoftwareFoundation/OpenColorIO/projects)
    - Doug: OpenEXR has a discussion on that too, for the Imath work. People 
      have been supportive for using it.
    - Carol: Agree this would be a good place to track and split up work.
    - Doug: Documentation is the highest priority. Would like to have something 
      up and running at OCIO v2 launch time. That was going to be at SIGGRAPH, 
      but we still need to decide on a date. It could also be at DigiPro. This 
      is coming up quickly. I feel an urgency for getting something in place 
      where people can contribute to docs.
    - **TODO**: Michael to explore setting up GH Projects to help keep track of
      initiatives and priority.

* Documentation status update
    - Sean: Community feedback was fairly quiet. Started slack channel for 
      further discussion.
    - Doug: Ben replied to the post with good ideas.
    - Carol: Some replies from people interested in following along and others 
      with some ideas. Not a ton of response. I will go back and continue 
      research, and meet with Sean offline to establish a proposed plan for 
      implementation.
    - Sean: Agree. My intent is to get PR in this week with a hosted GH page to 
      look at something and talk specifics. Can currently compile docstrings 
      from C++ headers and use with Python docstrings. I've been reformatting 
      C++ headers and making them doxygen compatible. Once the implementation is 
      worked out it will become a conversation about structure and what to fill 
      in.
    - Sean: General question: Since Python and C++ docstring largely use the 
      same text, should we use abstract API docs? These could pull out 
      specifics about implementations, and can be manually written where needed.
    - Michael: I have seen other API docs that will use tabs for specific 
      language implementation. The C++ docs also do this for different C++ 
      standards.
    - Doug: Sean's doxyfy prototype had tabs for languages. 
    - Sean: It looks funny in VuePress, but could be fixed with CSS. My vision 
      is to have a generic description with language notes. I will try to do a 
      demo at the next meeting.
    - Doug: We could set up different time for a focused discussion on docs if 
      needed too.
    - Sean: Might be more people with thoughts, like Ben.
    - **TODO**: Sean will get mechanical part of docs working and can arrange 
      additional meeting from there.
    - Michael: Others can help once structure is in place.
    - Sean: Doxygen generates headers with string literals. Not sure if we 
      should be committing auto-generating headers to the repo, or let them be 
      generated as part of the build process. It would need to be rebuilt 
      every time.
    - Mark B: Better to do this in the build system. The Existing repo has the 
      same concepts for generated code.
    - Sean: It needs to be there for python bindings to be built.
    - Mark B: CMake can have target dependencies to make sure build order is 
      correct.

* Foundry SDK usage in CI?
    - John: We had a discussion around Foundry SDKs and CI build processes a 
      while back. Is this still something needed? I'm working with legal to 
      make an agreement with companies to allow SDK use in the build stack. 
      This topic was restarting to help with some needs on OTIO.
    - Mark B: There was a discussion on who would maintain the OCIO Nuke 
      nodes, but that conversation stopped. OCIO v2 scratches a lot of their 
      itches, so they chose to wait and see.
    - Mark T: Foundry would like to take ownership of the Nuke nodes and open 
      source them.
    - Mark B: The nodes are already open source. New versions could be 
      contributed there.
    - Mark T: True. We want to have more involvement with development of the 
      nodes. Nuke would be a requirement for the build process. Pete and I 
      will discuss how to proceed.
    - John: The topic with legal is for terms around SDKs for open source use, 
      so that ASWF projects could leverage these. Both of these projects are 
      good example use cases to develop that. 
    - Michael: If nodes came back into repo, CI would be needed, so that would 
      be useful.
    - Doug: CI currently doesn't build any plugins. Possible that core changes 
      could break plugins without us knowing.
    - Mark T: We tried building the Nuke nodes against OCIO v2 recently and 
      weren't able to.
    - Michael: There have been quite a few API changes.
    - Mark T: We are not against contributing the nodes to the main project for 
      hosting.
    - John: I will follow up on discussions with Foundry. We are going through 
      SDK terms and conditions.
