<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

November 2, 2020

Host: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Mei Chu (_TSC_) - Sony Pictures Imageworks
  * [X] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [ ] Carol Payne (_TSC_) - Netflix
  * [X] Mark Titchener (_TSC_) - Foundry
  * [ ] Carl Rand (_TSC_) - Weta Digital
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Bernard Lefebvre - Autodesk
  * [X] Matthias Scharfenberg - Industrial Light & Magic
  * [X] J Schulte - Industrial Light & Magic

Apologies:
  Carol Payne

# **OCIO TSC Meeting Notes**

* ILM’s v2 questions
    - Doc: https://docs.google.com/document/d/11obAVucrsJ3e5HMuR40GD8fLUGAwwfbWD_jU5xId07Y
    - Mark B: Feedback on:
        - Dynamic and grading Transforms:
            - What these are trying to represent as building blocks in OCIO. 
              Who is the target user? Useful for color sub-tasks, but not 
              necessarily a core goal of OCIO.
            - See conversation below...
        - LogCameraTransform:
            - Parameters on transform don't coincide nicely with camera 
              whitepapers or reference transforms. We understand the 
              translation but a bit of a closed box to those authoring 
              configs. Future of this transform - will additional curve 
              characteristics be needed?
        - GetEnvVariables:
            - New get/set env vars. Do they need to be in OCIO API?
        - etc.

* Dynamic and grading Transform discussion:
    - Mark B: For wider world, why are our attributes for transforms different 
      from other implementations? Might impose worldview on grading which 
      doesn't reflect industry.
    - Doug: A lot of discussion about this. Motivation explained in GH issue. 
      Not intended to change what OCIO is used for. OCIO already has ASC CDL 
      and Lut3D transforms, which are used for looks typically. Felt there was 
      a gap between those extremes. Felt need for other transforms to fit 
      between those and have advantages of both. Wasn't to change OCIO or its 
      usage. One thing at meeting that raised a lot of discussion was not about 
      transform themselves, but the dynamic parameters that were part of them. 
      To modify transforms with dynamic parameters. Main reason for this is to 
      make OCIO more usable in GPU scenarios. Without this, every change needs 
      re-compile of shader, which was a major blocker for some GPU application 
      usage.
    - Mark B: Main place we differ is nobody is authoring looks in OCIO. Being 
      done in other apps. OCIO responsible for using them only. Grading 
      transforms don't have file equivalent, that someone might want to 
      implement. Not on same parallel in our view. CDLTransform could fall into 
      this too, since FileTransform can handle a CDL. Custom shader code can 
      be glued into shader.
    - Kevin: We would love to have done dynamic adjustments in single step. 
      We're trying to do this in our playback/review tool. Much cleaner than 
      jumping back and forth. Would be nice to be able to plug something in. 
      Would also be nice if there was an agreed upon spec of what these 
      grading controls meant. Do like being able to do real time adjustment of 
      transforms, since we do that.
    - Mark B: DCC authors could need this, but not config authors. Don't see a 
      config file equivalent to some of these knobs. Would love all of this as 
      a DCC author, since it simplifies implementation, but not a lot of that 
      problem in OCIO. Makes OCIO more complex and more uncertain of use case.
    - Kevin: Had not made strict limitation on where boundary should lie. 
      Without grading transforms, dynamic parameters allow you to do thing 
      like control where an exposure change is happening. Mostly temporary 
      adjustments. Some of the grading transforms allow me to do things where 
      I have previously had to bake LUT, so idea of parameterized methods is 
      useful. I'm in the middle somewhere. Think grading transform naming is 
      wrong and misleading.
    - Mark B: Current impl with DisplayTransform controlling where pieces are 
      dynamic had idea of limiting (gamma, exposure) adjustments. Maybe we need 
      more display transforms which ensure the knobs are in the proper place. 
      Do like building block transforms to replace need for LUTs.
    - Kevin: Yes, low level ops to support this. Isn't it up to config author 
      to choose where to express the dynamic parameters? The way these two 
      features come together is what creates a risky area.
    - Doug: Yes, there is a specific tag to make things dynamic.
    - Mark B: New building blocks could be confusing. Grading transforms don't 
      have file to back them up.
    - Doug: CTF format could be used.
    - Kevin: Concern with these transforms is they are not standardized. Not a 
      big deal having additional transformations.
    - J: BLG is a black box, but fills a need in industry. CDL doesn't do that. 
      We like fixed pipeline, and limited input to what can be changed. CDL has 
      been building block for this. Who makes and communicates these decisions? 
      How do we know what the right version for a parameter number is? Does 
      that fit into OCIO core concepts?
    - Mark B: Would expect to being given CTF rather than a grading transforms 
      with dynamic parameters set.
    - Doug: Wouldn't be handed config with dynamic parameters and expect them 
      to edit it. Understand the concerns, but don't see how grading transforms 
      are different from CDL in that regard.
    - Mark B: The workflows it introduces are a big shift in the tool. If 
      someone adjusts in their config and send the config without those 
      numbers, there's an extra bit to account for.
    - Kevin: If I got a config file with parameters that would be helpful. At 
      moment we get CDLs and stuff that should match, but they don't sometimes.
    - J: The variability of these controls is something to help facilitate 
      re-baking LUTs. There's value in this, but our concern is this will 
      create dynamic version of this OCIO experience that is not intended. Can 
      forsee a future that used builtin grading tool that uses these transforms 
      and export that to handoff to studios, but would be a nightmare. 
    - Mark B: Or combining grading transforms in row. What will that mean?
    - Kevin: Nothing stopping onset grading from baking out CLF/CTF files, so 
      not that different.
    - J: Not sure if fix for these problems should exist in OCIO. Concern from 
      supervising standpoint that we'll have multiple versions of a color 
      pipeline, since it's no longer static. If Foundry opens up these tools to 
      artists for example, that would have big effect. Not what OCIO 
      foundationally supported.
    - Doug: Distinction want to emphasize is that Nuke right now allows editing 
      CDL, but there is no way to insert that back into a config and write out 
      a new one. Would be same thing with grading transforms. Someone could use 
      this and save it, but would they be allowed to edit a config?
    - J: Don't want people affecting the state of color. Shouldn't allow means 
      to affect that change, since that's not something we would do in our 
      workflow. Some industries may need this though.
    - Mark B: Concern is that they can be put in config. Perhaps some parts of 
      OCIO are for DCC tools and others for rigid color pipelines. Not sure how 
      you can merge those things.
    - Doug: What's the concern about transforms vs non?
    - MArk: Transforms can be put in configs, whereas tools are for display.
    - Doug: Use case was for these to be put in configs, with advantages over 
      CDL.
    - Michael: The use cases I have seen are for supes to create CDLs for looks
      in a review session, which can then be passed off and used in shots or in
      the config. The implementation is specific to a custom tool, but not 
      something that would be exposed in DCCs. Not needing to rebuild shader 
      interactively a big gain for this workflow.
    - Doug: Not a requirement for DCCs to make these editable. Don't see that 
      happening. Not likely DCC is going to browse a config, edit it, and write 
      it back out.
    - Mark B: Not concerned about writing back out; more concerned about artist 
      changing stuff in display pipeline.
    - Doug: Would be surprised if DCC allowed you to edit looks.
    - Mark B: If you're a DCC author, there's a different track, but that 
      problem is unrelated to config author and those maintaining transform 
      hierarchy.
    - Sean: your thought is then that OCIO should only take image to certain 
      point? If review tool did want dynamic parameters, it handles it on its 
      own and then hands off to OCIO. Seems like more room for error. Nice to 
      handle it in OCIO where transform is consistent. I see both sides points, 
      but final control of pixels is a bit exaggerated. Every DCC has exposure 
      and gamma slider. No concern that when I tweak those I am tweaking the 
      config. Imagining an OCIO display with two views, one with the canonical 
      look, and another called "editable". You would have tw switch between 
      them, allowing a supe to make creative decisions when needed, but would 
      require explicit switching between display chains. Don't see any 
      operation which would require editing the original config.
    - Mark B: Not about editing the config; about expressing changes made when 
      editing. 
    - Sean: CDL-centric workflow for example. Would need to bake the changes 
      into a file (CTF) which could be referenced. Hard though since you can't 
      switch between dynamic and file transform. Like that this gives more 
      capability than what a CDL can, but am safe in knowledge that decisions 
      can be reproduced.
    - Mark B: New file format can be designed by ACES to handle additional 
      changes. Just problem with live aspect.
    - Sean: Natural extension of DisplayTransform. Causing more issues since 
      can be placed anywhere in config.
    - Doug: The dynamic aspect is what seems to be most troubling. See that as 
      an implementation detail. There's nothing preventing an application from 
      editing parameters. The dynamic parameter is only there to allow doing it 
      interactively with GPU. Could bake out new transform continually. Whether 
      something can be edited is separate from whether developer uses these 
      tools.
    - Mark B: A DCC author will implement it at some point.
    - Doug: Most tools already have CDL transform.
    - Mark B: But none allow you to edit it live.
    - Doug: Dynamic feature there as a convenience. There because of exposure 
      contrast in viewing pipeline. That tag is there to say doing exposure at 
      front and gamma at back. Doesn't need to be there for grading parameters.
    - Kevin: Can do dynamic functionality right now with search paths, etc. We 
      abuse that for CDL selection, an explicit choice.
    - Doug: Thanks for the feedback. We have response for all of these. In 
      terms of written response, would you like answers in this doc, or in 
      separate doc?
    - J: Separate doc is preferred.
    - Michael: Will be good to share these topics and conversation with wider 
      community too, for additional input. We can continue this discussion 
      after we all have time to think through the concerns raised.
    - **Update:** After the meeting, Doug provided a written response to the 
      ILM questions: 
      https://docs.google.com/document/d/1HeA9fJvrxAVoUQ3M1p8K3gAgd7cLkHUmChCoPfmyZvQ/edit?usp=sharing

* Items for next TSC meeting agenda:
    - Overview of new PRs (1183, 1184, 1189)
        - #1183 - Add operator << for FormatMetadata
        - #1184 - Description in config files
        - #1189 - Named color transforms
    - CUDA support
