<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

OCIO v2 WORKING GROUP MEETING  
2018-11-27  
via Zoom  

Participants:
  * Dennis Adams (Sony)
  * Mark Boorer (ILM)
  * Sean Cooper (DNeg)
  * Michael Dolan (Imageworks)
  * Joseph Goldstone (ARRI)
  * Larry Gritz (Imageworks)
  * Bernard Lefebvre (Autodesk)
  * Stefan Luka (Disney)
  * Daniel Mulligan (Method)
  * Matthias Scharfenberg (ILM)
  * Kevin Wheatley (Framestore)

Hosts:
  * Doug Walker (Autodesk)
  * Patrick Hodoul (Autodesk)

Recording on Zoom cloud:  
<https://autodesk.zoom.us/rec/share/-zAbbhl6kxITaKQFhe757Lqp6qyqa3_Up8ghlMsH1rxmxZc46zP4OKEgwD8kKKfW.XjIEv0VW1yzjG4Fp>


**OVERVIEW OF NEW OPS**

   - New/improved ops (either delivered or in-progress):  Range, ASC CDL, Lut3D,
Gamma, FixedFunction, Lut1D, Log.

**OVERVIEW OF OPDATA MODEL**

   - Patrick provided an overview of the new model and why it is needed.
   - Mark expressed some dissatisfaction with the design.  
   - The OpData code does not impact the public API and could be refactored
later if someone comes up with a better proposal.  That said, the current design
was discussed and refined based on feedback from a number of members of the
community.
   - There was some discussion about the v2 dev process.  Pull requests are
generally given about two weeks for the community to comment on and always have
one or more non-Autodesk reviewers before being merged.  (If objections are
raised it can be longer.)  This process is already much(!) longer than what is
typically done at a software company (such as Autodesk) and will start to become
impractical for us if it slows down further.  We greatly appreciate the help of
those who have made time to do code reviews (shout out to Michael especially).
   - In a number of cases, we have made "design review" PRs, labelled "DO NOT
MERGE" that just have an API and some unit tests.  These are done several weeks
before the "real" PR and are intended to give the community an even wider window
of time to comment.  Furthermore, we have been creating an Issue on GitHub even
further in advance to give even more advance notice and a place to make
comments.

**INTERPOLATION ATTRIBUTE**

   - The group agreed that the Interpolation attribute on FileTransform could be
ignored for file formats such as CLF that contain multiple ops and already have
embedded interopolation attributes.
   - The ociocheck program could be extended to warn about cases where
interpolation is used with CLFs.
   - We agreed to add a default so that the interpolation attribute is always
optional.
   - It would be useful to have some control over LUT extrapolation, but the
current behavior is to clamp.

**LUT3D INVERSION QUALITY**

   - The group agreed that the fast inversion mode will be the default since it
is the only one available on both CPU and GPU.
   - The group did not feel there was a need to be able to control this from
within the config.  However there will be a means to control it from the public
API.  This could be used to extend the ociobakelut capabilities or for
application use.
   - A number of participants said they typically use 65 cubed Lut3Ds.  This
size does not strongly impact the amount of time to calculate the inverse,
rather the time is dominated by the size of the fast forward Lut3D that contains
the approximate inverse.  This is currently 32 cubed since going to 65 cubed
would take a few seconds to calculate.  (This is only done if the transform is
needed, not when loading a config.)  The group felt it was sufficient to hard
code the size of the fast LUT, more advanced users will make explicit inverses
if needed.
   - The inverse is cached, like other transforms, but is subject to the limits
of the current OCIO caching mechanism.  It is currently up to app developers to
extend the caching where needed.
   - Some comments will be added to clarify that the forward interpolation style
is ignored for inverse evaluation.  Also that the inverse is clamped to the
range of the forward transform.
   - Unlike Lut1D, the inversion process has an implicit assumption that the
input and output of a Lut3D are perceptually uniform and that other ops will
shape the input and output appropriately.
   - There was some discussion about hiding and/or turning off the inverse
transform.  Using an identity matrix no-op for the to/from_reference was
discussed.  Note: I forgot to mention during the meeting, but the v2 proposal
discusses this and proposes an "invisible" keyword that could be inserted in the
from/to_reference attribute.  (An identity matrix will not hide the transform
from users.)

**CONTROLLING COLORSPACE VISIBILITY TO USERS**

   - The group agreed that it would be useful to add a feature to allow config
authors to have more control over the visibility of ColorSpaces in various app
menus.
   - One type of filtering would be based on the type of ColorSpace.  For
example, a menu asking the user to select a rendering working space should not
show camera log spaces, it probably only wants scene-linear spaces.
   - Another type of filtering is based on the type of artist/pipeline role. 
For example, the color spaces to show a texture painter vs. what to show a
compositor.  A related type of filtering could be based on the type of room or
workstation, e.g. a review room in SDR vs. HDR.
   - Another type of filtering is for color spaces which are either versioned or
deprecated.  They should be hidden from users but available for conversions when
needed.  (Note: the v2 proposal suggests having an "inactive_colorspaces" list
similar to active_views/displays that would be available at a config level and
env var.  So there would be an alternative way of handling that scenario in
addition to the categories feature.)
   - The group felt it would be best to add just a single category field for
now, even though it may mix some different types of tags.
   - Essentially there are two types of tags, those that are known in advance
that an app developer would code against and those that are specific to a config
author.  In the latter case, the app should provide some way for the user to
specify what custom tags they want to include in the filter.
   - It may also be helpful for apps to provide a way to turn off all filtering
(or provide a sub-menu with everything).
   - The group expressed some dissatisfaction with the lack of uniformity
between apps (e.g. in how roles are implemented and UI for color space display)
and so it is important that the documentation clearly spell out the intended
purpose of various tags.
   - We are open to discussing other ways of doing this, Sean mentioned the
concept of "worlds".  We invite people to add ideas to Issue #623 on GitHub.
   - Also, we have PR #627 that has a proposed API and some unit tests for you
to review.

**CODING STYLE GUIDELINES**

   - There was some discussion of coding style and the related open issues.
   - Larry related an experience with OIIO, which has transitioned to using
clang-format.  The policy is now for all OIIO PRs to be run through
clang-format.  This is also part of Travis CI which prints a report of any
issues.
   - This modifies a lot of the code and so it's best to do it at a major
version change like v2.  Also there was recently a re-org of the OCIO folder
structure.  So for both those reasons, this would be a good time to adopt this. 
However we also need to balance it with the fact that we currently have a bunch
of PRs in progress, so we may need to wait for a break so as to not disturb
ongoing development too much.
   - We invite someone to create an Issue for clang-format and propose the
specific options to be used.  We will try to adhere to that format for the new
code being written.

**ASWF TRANSITION**

   - Larry and Michael updated the group on the ASWF transition.  Please take a
look at the recent PR for the CONTRIBUTING and GOVERNANCE files.  Also the
Charter is in the process of being added to Git as well.  The ASWF application
is available on Slack.
   - There was some discussion about the requirement of getting a Core
Infrastructure Initiative (CII) badge.  This may be done after the project gets
accepted to the ASWF, during the incubation phase.  Volunteers who could spend
some time on this would be very welcome.
   - Larry and Michael encourged the group to make a PR if you have suggested
modifications or additions to the CONTRIBUTING, GOVERNANCE, or Charter.
   - Brief discussion about who will be the voice of OCIO to other groups, e.g.
ACES.  Could be more than one person and might not need to be the ASWF TSC
leaders, if it makes sense to share the work or draw on particular expertise.

**STANDARD COLOR SPACE LIBRARY**

   - Brief discussion of Sean and Mark's idea of a standard color space library.
 Needs more definition.
