<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

OCIO v2 WORKING GROUP MEETING  
2019-01-23  
via Zoom  

Participants:
  * Mark Boorer (ILM)
  * Sean Cooper (DNeg)
  * Michael Dolan (Imageworks)
  * Joseph Goldstone (ARRI)
  * Jim Houston (consultant)
  * Bernard Lefebvre (Autodesk)
  * Thomas Mansencal (Weta)
  * Carol Payne (ILM)
  * Matthias Scharfenberg (ILM)

Hosts:
  * Doug Walker (Autodesk)
  * Patrick Hodoul (Autodesk)


Recording on Zoom cloud:  
<https://autodesk.zoom.us/rec/share/rEOHIC1hv3ifLvyREdWh5nIU5LQUY6_cFq5KuRCKH22QwqmdoQJA-ygNw8bBWGz8.OtaQY0ii9dT6NLlb>


**PULL REQUEST TRAFFIC JAM DISCUSSION**

   - We reviewed the current delay with the Autodesk PRs.  It is a big
productivity hit for our team that it is sometimes taking a month or more to
merge major PRs, especially when we have other work that needs to build on the
earlier PRs.  The topic was posed to the group for discussion to find a
solution.
   - Patrick shared that there are 7 PRs currently waiting and 3 others that are
currently blocked, which depend on the ealier ones and cannot be submited.
   - One suggestion for those that don't currently have permission from their
employer to work on OCIO and who work for an ASWF Premier member company is to
use the argument that Premier members must donate the equivalent of one
full-time engineer to open source projects each year.
   - The current PR merge rules in place allow merging PRs to which no one has
objected after a period of two weeks and Thomas asked why don't we just do that.
 Michael responded that there was some push back from some people to doing that.
 Patrick also pointed out that we really want to get people's feedback on the
PRs.
   - The group decided that it would help to have a Zoom meeting when a major PR
goes up to orient people about what it contains so that they could more easily
review it.  We will try to do that going forward.

**MATRIX ENHANCEMENTS PR #641  (up for 33 days)**

   - The enhancements to the Matrix op are:  use of doubles in the underlying op
data, SSE optimization, more stable inversion with improved tolerancing, and
many new unit tests.
   - Mark asked whether there is any performance regression due to using doubles
rather than floats and what is the motivation.  The response was that the apply
is still done at float precision and is in fact faster now since we added SSE
support.  The reason for using doubles to store the coefficients from the file
is that it makes the intermediate calculations more robust, e.g. combining
matrics and testing for identities, and allows preserving all digits when
matrices are written back out to a file.
   - The question was asked whether anyone needs more time or could the PR be
merged.  No one objected to merging it.

**LUT1D ENHANCEMENTS PR #640  (up for 36 days)**

   - The enhancements to the Lut1D op are:  support for half-domain (needed for
CLF), much faster and more robust inversion, GPU support, improved no-op
detection, new unit tests.
   - This PR is a work-in-progress since it also needs integer support (future
PR) in order to finish it and we are trying to limit the size of the PRs.  We
reviewed the unfinished aspects.
   - There was some discussion of the work that Bernard has done to address
Michael's comments in the PR.
   - The question was asked whether anyone needs more time or could the PR be
merged.  No one objected to merging it.

**NEW COLORSPACE "CATEGORY" ATTRIBUTE  PR #648  (PR 7 days, but API/tests for 64
days)**

   - The "categories" attribute holds a set of strings/tags for a ColorSpace.
   - The new getColorSpaces method on Config, returns a new ColorSpaceSet
object.  Union/intersection operators were added on the ColorSpaceSet.
   - There was some discussion of what underlying data structure to use and
Patrick and Mark discussed the pros/cons of vectors vs. sets vs. maps.
   - Sean asked if we should have a more general class for adding attributes to
ColorSpaces.
   - Thomas pointed out the risk of these features not being implemented the
same way (similar to roles).  The group agreed it was a useful feature but the
standard list and intended behavior of the categories needs to be clearly
documented.
   - Mark asked for some more time to review this PR.

**NEW GAMMA OP  PR #639  (up for 49 days)**

   - The new op is intended to support display EOTF curves.  It currently
includes pure power functions (like the ExponentTransform) as well as piecewise
functions such as the sRGB curve.  We intend to extend it to support additional
EOTF curves such as some of the ones in the ICC profile format.
   - The piecewise functions use the minimal number of free parameters and the
others (e.g. breakpoints) are calculated at double precision to avoid any
discontinuity.
   - The PR leaves the ExponentTransform in place (although it is implemented
under the hood as the new op) for backwards compatibility for both existing
configs (i.e. the Yaml parser) and API clients.
   - We discussed Sean's comment on GitHub about whether the ExponentTransform
should now be removed, particularly for API clients.  (Support for Config
clients is easier to leave in since it's just one line of code in the Yaml
parser.)  Mark and Michael want to keep the ExponentTransform for at least one
more major release and we all agreed on that.  
   - Thomas requested a warning if deprecated transforms are used in a config. 
There was agreement on adding that to ociocheck but not to write something to
std::out.  OIIO and SynColor allow libraries to register a call-back to issue
warnings, this could be a future option.
   - There was a very lengthy discussion about what name to use as people are
unhappy with the "gamma" name.   After a heated debate of many possibilities, we
decided to retain ExponentTransform for the basic power function and add
ExponentWithLinearTransform for the piecewise power function (sRGB).
