<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

October 5, 2020

Host: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Mei Chu (_TSC_) - Sony Pictures Imageworks
  * [ ] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Mark Titchener (_TSC_) - Foundry
  * [ ] Carl Rand (_TSC_) - Weta Digital
  * [ ] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Bernard Lefebvre - Autodesk
  * [X] Thomas Mansencal - Weta Digital
  * [X] Aymee Yeh - Netflix
  * [X] J Schulte - Industrial Light & Magic
  * [X] Matthias Scharfenberg - Industrial Light & Magic

Apologies
  * Doug Walker

# **OCIO TSC Meeting Notes**

* Review pending PRs:
    - #1160 - C++ API docs:
        - Initial work and structure of C++ API docs. Feedback on organization 
          of content welcome. Can look at RST or build locally. Also includes 
          some general CMake changes and removal of auto-install of 
          documentation-specific dependencies.
        - Patrick: Noticed this morning on tsc-private topic related to 
          copyright of images found with license scan. Needs a look.
    - #1159 - Improve CMake files:
        - Patrick: Not C++. Faced issues with CMake on Windows and tried to 
          fix.
    - #1157 - FileTransform interpolation:
        - Patrick: Last meeting discussed v1 not throwing if interpolation was 
          missing. Bernard checked and it is throwing for FileTransform 
          (i.e. LUTs) as expected.
    - #1156 - Meeting minutes:
        - Patrick: Needs another approval.

* Introducing Aymee Yeh:
    - Carol: Introducing Aymee to OCIO project. PM from Netflix who is 
      interested in learning more about project management in open source. 
    - Aymee: Work with Carol at Netflix on project management. Here to listen 
      to see where I can help. 
    - Carol: Provided some resources from GH repo.
    - Michael: Please let us know if you have any questions. OCIO Slack 
      workspace is a good place to discuss, and any ideas an input are very 
      appreciated.

* Issue #1162 - PROCESS.md feedback:
    - Thomas: In a good place. Would be great to have more people giving 
      feedback. Explicit approval better than silent assent.
    - Carol: Also think it looks good, but will have another look.
    - Patrick: To highlight, there's a trend in OSS that saying nothing means 
      its fine, but sometimes better to have explicit approval in a comment to 
      an issue or PR. Some feedback to know where you stand.
    - Michael: "LGTM" is a good response if you're in agreement.
    - Patrick: If you take time to read it, take a time to comment.
    - Thomas: On GH, approval is a click away also.
    - Mark B: Only comment is with big changes throughout development. Since 
      PRs were dependent on each other, decided to wait till work was more 
      complete to review. Have some concerns that there's not enough time to 
      vet work while pushing towards release date.
    - Patrick: Good concern, and why we have 4 month stabilization period to 
      test and dig into what we did. Up to you to tell us. We did our best to 
      explain and add tests, which are also a way to explain the features. 
      Please tell us if something is unclear or a concern.
    - J: Understood. Sometimes huge wave of commits takes a lot of time to 
      review. Good buffer to look and rethink it.
    - Michael: Good to take time to review PRs if you can since it's easier to 
      adjust work in progress than completed work. Probably too late to change
      architectural decisions.
    - Patrick: Best to start with unit tests and public API to get sense of 
      features and changes. Can also start with Python. Start with something 
      you are familiar with. 
    - Thomas: Whenever not finding something in Python code, looking at C++ 
      unit tests and that is very helpful.
    - Mark B: Lots of stuff from previous TSC meetings and working group 
      meetings where it's hard to track outcome of discussions. Not sure 
      whether those changes were addressed or gone over. Need to check up on a 
      lot of stuff and follow through. No issue with architectural stuff so 
      much. Two or three things to follow up on though. Worried our concerns 
      will be lost because of imposed deadline. Would be a shame if features 
      go out if solutions doesn't match spirit of previous library version.
    - Mark T: What things are you concerned about?
    - Mark B: ICC display transforms. Live grading controls and how those 
      interact. Environment resolution. Bit-depth - how it's expressed in graph 
      and config.
    - Patrick: Suggestion - build a list and next TSC meeting would like to 
      discuss these points. We can address questions over several meetings. 
      Even if we did some WG sessions and created defects for all the features, 
      we could still explain again what we all agreed to do and follow up on 
      any concerns.
    - All: Agree this is a good idea.
    - Mark: T: Others can look at areas of concerns too.
    - Patrick: Yes, we are waiting and eager to have more eyes on what we did.
    - Michael: Lots of little pieces have come together, so understood that 
      it's easier to review larger features now that they are complete.
    - J: Continuity of involvement has been challenge, with big waves of work.
    - **TODO**: Mark B and others to provide list of features for review with 
      AD team during future TSC meetings. Similar discussion to v2 working 
      group.
    
* ACES Gamut Mapping Quick Update - for FYI:
    - Carol: Matthias and I co-chairing gamut mapping wg. We put out a status 
      update and will share a link. We're getting close to moving on to 
      implementation of the algorithm as long as user testing goes well. 
      There's a test impl on GH: 
      https://community.acescentral.com/t/aces-gamut-mapping-vwg-status-update/3259
      which can be tested in Nuke, Baselight, Python, etc. Hoping to get into 
      OCIO v2 as builtin transform. Imagining OCIO big use case for this 
      operator in lots of VFX spaces. More complicated than a 3D LUT.
    - Matthias: Main reason for this implementation is precision, in particular 
      for inverting the transform. Is possible to implement in OCIO v1 with 
      shaper space potentially, but precision is compromised and made 
      non-invertible. Much more desirable to be evaluated as builtin transform. 
      Not super complicated on processing side, shouldn't slow things down.
    - Carol: May be asking for input in best way to implement, probably 
      starting early next year. Getting user testing done in the next month. 
      Finalizing architecture deliverable to Academy, which is CTL by end of 
      year.
