<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

September 29, 2020

Host: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Matthias Scharfenberg - Industrial Light & Magic
  * [X] Dennis Adams - Sony
  * [X] Thomas Mansencal - Weta Digital
  * [X] Christophe Brejon

Apologies:
  * Kevin Wheatley

# **OCIO Configs Working Group Meeting Notes**

* Update on config skeleton generation work:
    - Thomas: For practical purposes it's in a state where it should work with 
      builtin transforms. Most concerning issue right now is the ACEScc builtin 
      transform is not serialized. The transform is created correctly, but when 
      the config is written, nothing is in the config. Good that it doesn't 
      support non-existent style. Also CDL transform methods not working.
    - Doug: We have unit tests for CDLTransform, so not sure. May be untested 
      issue.
    - Thomas: Serialization issue is just this one transform. Others are fine.
    - Michael: Should we auto generate builtin transform cpp code or do the 
      work manually?
    - Doug: Depends which transforms, but if we at least agree on names, that's 
      a good step forward. If we agree to take them from CTL, as Thomas is 
      doing, that makes sense. Going to come down to manually writing the code.
    - Michael: Agree on manual approach, to have comments, etc.
    - Thomas: More thinking to generate stub files to be filled, since the data 
      is there.
    - Mark: From current config, FileTransform in there now. Will there be 
      external files?
    - Thomas: Just a placeholder until builtin transform styles are supported.
    - Michael: Thomas raised a question about direction in PR. As to whether we 
      should follow typical transform forward/inverse behavior, or have 
      separate named transform per direction?
    - Thomas: Either approach is fine with me, but prefer small things which 
      are easier to test and maintain.
    - Doug: all transform have direction attribute, so needed, but nothing 
      prevents us from having both directions as transform names.
    - Mark: Prefer log-to-lin since the inverse order has precision loss in a 
      LUT, but for the facade that the builtin transform has it shouldn't 
      matter. Use most optimal and have both in interface. If people don't need 
      to read docs and just use transforms, having both directions would make 
      it easier.
    - Matthias: From config author standpoint, good to have both.
    - Thomas: Make it clearer when going from reference. More explicit is better.
    - Mark: not sure how helpful to have every transform in both directions. 
      Do we need to do output transforms in both directions For example?
    - Doug: We don't have to explicitly put them in config if no reason to. If 
      OCIO can generate the other direction. Was that the questions, needing 
      both from_ref and to_ref?
    - Thomas: Since it's from CTL, will get both sides from some transforms. 
    - Doug: In general there is a need to combine two CTL files in repo to 
      generate a single color space. Need some logic for that. Sounds like we 
      agree that builtin transform should define strings in both directions, 
      but then there's the question of the aces repo that has CTL in both 
      directions (no inverse argument). Thomas' generator looks at CTL and 
      builds color spaces. Most of the time there are two CTLs but don't want 
      two color spaces.
    - Thomas: In aces-dev if both directions are defined, you’ll get from and 
      to reference transform in color space in the config.
    - Mark: Think that’s fine. OCIO generated in reverse not as good as manmade 
      inverse. Don't think thats a problem.
    - Thomas: Think it should stay as close to metal as possible, to aces-dev. 
      The studio config can be massaged differently, but this one as a base 
      should be close to CTL. Could be good for Scott and Alex to be able to 
      see it as a test bed.
    - Mark: Only new feature in OCIO v2 in this regard is 3D LUT inversion and 
      don't want to rely on that vs. using the actual inverse.
    - Doug: shouldn't be 3D LUTs in aces config unless there is camera vendor 
      spaces. Under the hood the builtin transforms we will just write one and 
      the other will be implemented with direction flag. CTL not ideal in this 
      regard. OCIO generated inverse will be at least as good as CTL.
    - Carol: Think an explicit definition for any 3D LUT in CTL would be a case 
      for that. If we all trust and use the inverse calculated by OCIO, that 
      should be what we use in the config.
    - Mark: The builtin transform won't show you that they need a 
      from_reference. Each has it's own implicit from_reference. If you use 
      builtin transform you can assume an inverse exists. Should guarantee that 
      all builtin transforms are invertible.
    - Carol: Should not need to define both from or to reference. Since it is 
      mathematically high precision and invertible, defining both not needed.
    - Thomas: An interesting case is the IDT going to reference and ODT from 
      reference. We could do one or other, but could do it the way CTL is 
      implemented. If we want to impose a direction we can, but think there is 
      value for Scott and Alex and AMPAS people to represent how they are 
      implemented on CTL side as faithfully as possible.
    - All: Agree that is fine.
    - Matthias: Could also serve as a guideline for how to build an OCIO 
      config. Helps see where it's good practice to have transform from and/or 
      to reference, that don't need both always defined.
    - Thomas: Yes, it's logical, that's how it flows in ACES, so good to follow 
      that.
    - Mark: Might end up having to use builtin transform with opposite name as 
      a result, but that's fine.
    - Michael: Any interest in starting work on builtin transform 
      implementation on the cpp side?
    - Mark: I am interested, but hoping to replace it eventually.
    - Michael: Good to see current implementation to understand the needs, even 
      if it changes later.
    - Mark: Will look at what Thomas has and give one of them a try.
    - Doug: Recommend not starting with ODTs. Would be better to use spline 
      operator for tonecurve, so I should provide an example of an output 
      transform first. Good to start with input transforms. Already some 
      examples in there for reference. A basic starter set, all of the ACES 
      color space conversions are done.
    - Mark: Is a LUT built at runtime?
    - Doug: In some cases no LUT is needed, when CameraLog transform can be 
      used, but we did include some examples where Lut1D is needed. A lot of 
      the curves use the same formula with different constants, so that can be 
      used when the formula is similar. ACEScc transform needs an update, but 
      there are examples of 1D LUTs in there.
    - Mark: Skeptical that they match. Had problems where formula didn't match 
      official spec at bottom of significant digits, so mixing official LUT and 
      parametric formula, not sure they will match and roundtrip.
    - Doug: Fair amount of discussion in CLF working group around this. Scott 
      and Alex signed off on this approach. Sometimes manufacturers don't do 
      good documenting for implementation because of included significant digits.
    - Matthias: Has anyone come across anything that doesn't work with this?
    - Doug: There are some examples. ACEScc needs Lut1D and some camera 
      examples (Cannon) wen their own way.
    - Michael: OCIO follows the CLF implementation, so ops should adhere to that.
    - Doug: Yes, but CTL doesn't.
    - Mark: Disappointed we're not generating these at build time, but probably 
      not expensive to build at runtime.
    - Doug: Faster than parsing LUT file.
    - Matthias: Reasoning behind maintaining color space naming from previous 
      ACES config? Where family name duplicates color space name and makes long 
      color space names. Can break combo boxes.
    - Carol: It’s the academy’s names, matching CTL transforms.
    - Matthias: Do we want to keep family name in front of everything?
    - Thomas: Can trim it.
    - Matthias: Already condensing names in builtin transforms. Would prefer 
      those names to the color space names.
    - Thomas: The current naming trying to stick to original naming, but easy 
      to change. Would be good for people to pull down the code and start to 
      play with it. Might give some ideas. One of next steps was going to do was 
      dockerize the generation. Will work with OCIO containers.
    - Michael: Aloys is working on ASWF docker images for production. Beyond 
      the current CI images, which will have full builds with tools, etc.
    - Thomas: Anything we can do to streamline the work for people would be 
      good. Docker is a good solution.
    - Doug: Agree that sounds useful.
    - Thomas: Will work on that to make the setup one click.
    - Michael: Do we have a decision on color space naming changes?
    - Mark: Once we can get a config to play with we can play with and suggest 
      changes.
    - Thomas: Can be parameterized too.
    - Mark: Could get in touch with Academy to get their blessing on improved 
      naming.
    - Thomas: Yes, need to follow up with Scott on that. Would like to have 
      official conversation with them. Work for consistent names in the future. 
      Should start official conversation.
    - Mark: Once we get something we can generate and play with that would be a 
      good point for that conversation.
    - Thomas: They can build it to look at on ACES side too.
    - Mark: Would argue away from using docker. Just a python script to run 
      would work.
    - Thomas: If it was pure python no problem, but with OCIO, etc. it gets 
      complicated.
    - Mark: Should just need pure python to build graph. Do we need all these 
      dependencies? NetworkX, etc?
    - Thomas: You could, but good to utilize libraries that are there. You can 
      replace, but more maintenance on our side.
    - Mark: Every dependency has a cost. Gets passed on to users. Having to 
      download lots of libraries to build a config not ideal.
    - Thomas: Matter of balancing cost. If you have something available that 
      works well, why reinvent the wheel? Just use that.
    - Mark: Gets hard for build engineer in studio.
    - Thomas: Is work, but helpful.
