**Features:**
* The MCAD library is now bundled with OpenSCAD
* Added len() function. Takes one vector or string parameter and returns its length.
* The index operator [] now works on strings
* The version() function will return the OpenSCAD version as a vector, e.g. [2011, 09]
* The version_num() function will return the OpenSCAD version as a number, e.g. 20110923
* hull() Now supports 3D objects
* hull() with 2D object can now use for loops and boolean operations as children
* New import() statement reads the correct file format based on the filename extension
  (.stl, .dxf and .off is supported)
* The color() statement now supports an alpha parameter, e.g. color(c=[1,0,0], alpha=0.4)
* The color() statement now supports specifying colors as strings, e.g. color("Red")
* The color() statement now overrides colors specified further down in the tree
* if()/else() and the ternary operator can now take any value type as parameter. false, 0, empty string and empty vector or illegal value type will evaluate as false, everything else as true.
* Strings can now be lexographically compared using the <, <=, >, >= operators
* Added PI constant.
* Number literals in scientific notation are now accepted by the parser
* Added import and export of the OFF file format
* Now uses standard shortcuts for save, reload and quit on Linux and Windows. F2/F3 will still work but is deprecated.

**Bugfixes:**
* Complex CSG models sometimes took extremely long time to normalize before OpenCSG preview
* square() crashed if any of the dimensions were zero
* Flush Caches didn't flush cached USE'd modules
* STL export should be a bit more robust
* Dropping a file into the editor under Windows didn't work (double C:/C:/ problem)
* On some platforms it was possible to insertion rich text in the editor, causing confusion.
* Less crashes due to CGAL assertions
* OpenCSG should now work on systems with OpenGL 1.x, given that the right extensions are available
* include now searches librarydir
* The $fs parameter yielded only half the number of segments it should have
* surface(center=true) is now correctly centered in the XY plane

**Deprecations:**
* dxf_linear_extrude() and dxf_rotate_extrude() are now deprecated.
  Use linear_extrude() and rotate_extrude() instead.
* The file, layer, origin and scale parameters to linear_extrude() and rotate_extrude()
  are now deprecated. Use an import() child instead.
* import_dxf(), import_stl() and import_off() are now deprecated. Use import() instead.
* When exporting geometry from the cmd-line, use the universal -o option. It will export to the correct file format based on the given suffix (dxf, stl, off). The -x and -s parameters are still working but deprecated.
* F2 and F3 for Save and Reload is now deprecated

