/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/RdPu.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 73, 0, 106, 255, 122, 1, 119, 255, 174, 1, 126, 255, 221, 52, 151, 255, 247, 104, 161, 255, 250, 159, 181, 255, 252, 197, 192, 255, 253, 224, 221, 255, 255, 247, 243, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_RdPu_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 72, 0, 106, 0, 73, 0, 106, 7, 73, 0, 106, 14, 74, 0, 106, 22, 74, 0, 106, 29, 74, 0, 106, 37, 75, 0, 106, 44, 75, 0, 106, 52, 76, 0, 106, 59, 76, 0, 107, 67, 76, 0, 107, 74, 77, 0, 107, 82, 77, 0, 107, 89, 78, 0, 107, 97, 78, 0, 107, 104, 78, 0, 107, 112, 79, 0, 107, 119, 79, 0, 107, 127, 80, 0, 108, 134, 80, 0, 108, 141, 80, 0, 108, 149, 81, 0, 108, 156, 81, 0, 108, 164, 82, 0, 108, 171, 82, 0, 108, 179, 82, 0, 108, 186, 83, 0, 108, 194, 83, 0, 109, 201, 84, 0, 109, 209, 84, 0, 109, 216, 84, 0, 109, 224, 85, 0, 109, 231, 85, 0, 109, 239, 86, 0, 109, 246, 86, 0, 109, 254, 86, 0, 109, 255, 87, 0, 110, 255, 87, 0, 110, 255, 87, 0, 110, 255, 88, 0, 110, 255, 88, 0, 110, 255, 89, 0, 110, 255, 89, 0, 110, 255, 89, 0, 110, 255, 90, 0, 110, 255, 90, 0, 111, 255, 91, 0, 111, 255, 91, 0, 111, 255, 91, 0, 111, 255, 92, 0, 111, 255, 92, 0, 111, 255, 92, 0, 111, 255, 93, 0, 111, 255, 93, 0, 111, 255, 94, 0, 111, 255, 94, 0, 112, 255, 94, 0, 112, 255, 95, 0, 112, 255, 95, 0, 112, 255, 96, 0, 112, 255, 96, 0, 112, 255, 96, 0, 112, 255, 97, 0, 112, 255, 97, 0, 112, 255, 97, 0, 112, 255, 98, 0, 113, 255, 98, 0, 113, 255, 99, 0, 113, 255, 99, 0, 113, 255, 99, 0, 113, 255, 100, 0, 113, 255, 100, 0, 113, 255, 100, 0, 113, 255, 101, 0, 113, 255, 101, 0, 113, 255, 102, 0, 114, 255, 102, 0, 114, 255, 102, 0, 114, 255, 103, 0, 114, 255, 103, 0, 114, 255, 104, 0, 114, 255, 104, 0, 114, 255, 104, 0, 114, 255, 105, 0, 114, 255, 105, 0, 114, 255, 105, 0, 115, 255, 106, 0, 115, 255, 106, 0, 115, 255, 107, 0, 115, 255, 107, 0, 115, 255, 107, 0, 115, 255, 108, 0, 115, 255, 108, 0, 115, 255, 108, 0, 115, 255, 109, 0, 115, 255, 109, 0, 116, 255, 110, 0, 116, 255, 110, 0, 116, 255, 110, 0, 116, 255, 111, 0, 116, 255, 111, 0, 116, 255, 111, 0, 116, 255, 112, 0, 116, 255, 112, 0, 116, 255, 113, 0, 116, 255, 113, 0, 116, 255, 113, 0, 117, 255, 114, 0, 117, 255, 114, 0, 117, 255, 114, 0, 117, 255, 115, 0, 117, 255, 115, 0, 117, 255, 116, 0, 117, 255, 116, 0, 117, 255, 116, 0, 117, 255, 117, 0, 117, 255, 117, 0, 117, 255, 117, 0, 118, 255, 118, 0, 118, 255, 118, 0, 118, 255, 119, 0, 118, 255, 119, 0, 118, 255, 119, 0, 118, 255, 120, 0, 118, 255, 120, 0, 118, 255, 120, 0, 118, 255, 121, 0, 118, 255, 121, 0, 118, 255, 121, 1, 119, 255, 122, 0, 119, 255, 122, 0, 119, 255, 123, 0, 119, 255, 123, 0, 119, 255, 124, 0, 119, 255, 124, 0, 119, 255, 124, 0, 119, 255, 125, 0, 119, 255, 125, 0, 119, 255, 126, 0, 119, 255, 126, 0, 119, 255, 126, 0, 119, 255, 127, 0, 119, 255, 127, 0, 120, 255, 128, 0, 120, 255, 128, 0, 120, 255, 129, 0, 120, 255, 129, 0, 120, 255, 129, 0, 120, 255, 130, 0, 120, 255, 130, 0, 120, 255, 131, 0, 120, 255, 131, 0, 120, 255, 131, 0, 120, 255, 132, 0, 120, 255, 132, 0, 120, 255, 133, 0, 121, 255, 133, 0, 121, 255, 133, 0, 121, 255, 134, 0, 121, 255, 134, 0, 121, 255, 135, 0, 121, 255, 135, 0, 121, 255, 136, 0, 121, 255, 136, 0, 121, 255, 136, 0, 121, 255, 137, 0, 121, 255, 137, 0, 121, 255, 138, 0, 121, 255, 138, 0, 121, 255, 138, 0, 121, 255, 139, 0, 121, 255, 139, 0, 122, 255, 140, 0, 122, 255, 140, 0, 122, 255, 140, 0, 122, 255, 141, 0, 122, 255, 141, 0, 122, 255, 142, 0, 122, 255, 142, 0, 122, 255, 142, 0, 122, 255, 143, 0, 122, 255, 143, 0, 122, 255, 144, 0, 122, 255, 144, 0, 122, 255, 145, 0, 122, 255, 145, 0, 122, 255, 145, 0, 122, 255, 146, 0, 123, 255, 146, 0, 123, 255, 147, 0, 123, 255, 147, 0, 123, 255, 147, 0, 123, 255, 148, 0, 123, 255, 148, 0, 123, 255, 149, 0, 123, 255, 149, 0, 123, 255, 149, 0, 123, 255, 150, 0, 123, 255, 150, 0, 123, 255, 151, 0, 123, 255, 151, 0, 123, 255, 151, 0, 123, 255, 152, 0, 123, 255, 152, 0, 123, 255, 153, 0, 123, 255, 153, 0, 123, 255, 153, 0, 124, 255, 154, 0, 124, 255, 154, 0, 124, 255, 155, 0, 124, 255, 155, 0, 124, 255, 155, 0, 124, 255, 156, 0, 124, 255, 156, 0, 124, 255, 157, 0, 124, 255, 157, 0, 124, 255, 158, 0, 124, 255, 158, 0, 124, 255, 158, 0, 124, 255, 159, 0, 124, 255, 159, 0, 124, 255, 160, 0, 124, 255, 160, 0, 124, 255, 160, 0, 124, 255, 161, 0, 124, 255, 161, 0, 124, 255, 162, 0, 124, 255, 162, 0, 124, 255, 162, 0, 125, 255, 163, 0, 125, 255, 163, 0, 125, 255, 164, 0, 125, 255, 164, 0, 125, 255, 164, 0, 125, 255, 165, 0, 125, 255, 165, 0, 125, 255, 166, 0, 125, 255, 166, 0, 125, 255, 166, 0, 125, 255, 167, 0, 125, 255, 167, 0, 125, 255, 168, 0, 125, 255, 168, 0, 125, 255, 168, 0, 125, 255, 169, 0, 125, 255, 169, 0, 125, 255, 170, 0, 125, 255, 170, 0, 125, 255, 170, 0, 125, 255, 171, 0, 125, 255, 171, 0, 125, 255, 172, 0, 125, 255, 172, 0, 125, 255, 172, 0, 125, 255, 173, 0, 125, 255, 173, 0, 125, 255, 173, 1, 125, 255, 174, 1, 126, 255, 174, 2, 126, 255, 175, 2, 126, 255, 175, 3, 126, 255, 175, 3, 126, 255, 176, 4, 127, 255, 176, 5, 127, 255, 176, 5, 127, 255, 177, 6, 127, 255, 177, 6, 127, 255, 177, 7, 128, 255, 178, 8, 128, 255, 178, 8, 128, 255, 179, 9, 128, 255, 179, 10, 128, 255, 179, 10, 129, 255, 180, 11, 129, 255, 180, 11, 129, 255, 180, 12, 129, 255, 181, 13, 129, 255, 181, 13, 130, 255, 181, 14, 130, 255, 182, 14, 130, 255, 182, 15, 130, 255, 183, 15, 130, 255, 183, 16, 131, 255, 183, 16, 131, 255, 184, 17, 131, 255, 184, 17, 131, 255, 184, 18, 131, 255, 185, 18, 132, 255, 185, 19, 132, 255, 185, 19, 132, 255, 186, 20, 132, 255, 186, 20, 132, 255, 187, 20, 133, 255, 187, 21, 133, 255, 187, 21, 133, 255, 188, 22, 133, 255, 188, 22, 133, 255, 188, 23, 134, 255, 189, 23, 134, 255, 189, 23, 134, 255, 190, 24, 134, 255, 190, 24, 134, 255, 190, 25, 135, 255, 191, 25, 135, 255, 191, 25, 135, 255, 191, 26, 135, 255, 192, 26, 135, 255, 192, 26, 136, 255, 192, 27, 136, 255, 193, 27, 136, 255, 193, 28, 136, 255, 194, 28, 136, 255, 194, 28, 136, 255, 194, 29, 137, 255, 195, 29, 137, 255, 195, 29, 137, 255, 195, 30, 137, 255, 196, 30, 137, 255, 196, 31, 138, 255, 196, 31, 138, 255, 197, 31, 138, 255, 197, 32, 138, 255, 198, 32, 138, 255, 198, 32, 139, 255, 198, 33, 139, 255, 199, 33, 139, 255, 199, 33, 139, 255, 199, 34, 139, 255, 200, 34, 140, 255, 200, 34, 140, 255, 201, 35, 140, 255, 201, 35, 140, 255, 201, 35, 140, 255, 202, 36, 141, 255, 202, 36, 141, 255, 202, 36, 141, 255, 203, 37, 141, 255, 203, 37, 141, 255, 203, 37, 142, 255, 204, 38, 142, 255, 204, 38, 142, 255, 205, 38, 142, 255, 205, 39, 142, 255, 205, 39, 143, 255, 206, 39, 143, 255, 206, 40, 143, 255, 206, 40, 143, 255, 207, 40, 143, 255, 207, 41, 144, 255, 208, 41, 144, 255, 208, 41, 144, 255, 208, 42, 144, 255, 209, 42, 144, 255, 209, 42, 144, 255, 209, 42, 145, 255, 210, 43, 145, 255, 210, 43, 145, 255, 210, 43, 145, 255, 211, 44, 145, 255, 211, 44, 146, 255, 212, 44, 146, 255, 212, 45, 146, 255, 212, 45, 146, 255, 213, 45, 146, 255, 213, 46, 147, 255, 213, 46, 147, 255, 214, 46, 147, 255, 214, 46, 147, 255, 215, 47, 147, 255, 215, 47, 148, 255, 215, 47, 148, 255, 216, 48, 148, 255, 216, 48, 148, 255, 216, 48, 148, 255, 217, 49, 149, 255, 217, 49, 149, 255, 218, 49, 149, 255, 218, 49, 149, 255, 218, 50, 149, 255, 219, 50, 150, 255, 219, 50, 150, 255, 219, 51, 150, 255, 220, 51, 150, 255, 220, 51, 150, 255, 220, 52, 150, 255, 221, 52, 151, 255, 221, 52, 151, 255, 221, 53, 151, 255, 221, 53, 151, 255, 222, 54, 151, 255, 222, 54, 151, 255, 222, 55, 151, 255, 222, 55, 151, 255, 223, 56, 151, 255, 223, 56, 151, 255, 223, 57, 151, 255, 223, 57, 151, 255, 223, 58, 151, 255, 224, 58, 151, 255, 224, 59, 151, 255, 224, 59, 151, 255, 224, 59, 152, 255, 224, 60, 152, 255, 225, 60, 152, 255, 225, 61, 152, 255, 225, 61, 152, 255, 225, 62, 152, 255, 226, 62, 152, 255, 226, 63, 152, 255, 226, 63, 152, 255, 226, 63, 152, 255, 226, 64, 152, 255, 227, 64, 152, 255, 227, 65, 152, 255, 227, 65, 152, 255, 227, 66, 152, 255, 228, 66, 152, 255, 228, 66, 153, 255, 228, 67, 153, 255, 228, 67, 153, 255, 228, 68, 153, 255, 229, 68, 153, 255, 229, 69, 153, 255, 229, 69, 153, 255, 229, 69, 153, 255, 229, 70, 153, 255, 230, 70, 153, 255, 230, 71, 153, 255, 230, 71, 153, 255, 230, 71, 153, 255, 230, 72, 153, 255, 231, 72, 154, 255, 231, 73, 154, 255, 231, 73, 154, 255, 231, 74, 154, 255, 232, 74, 154, 255, 232, 74, 154, 255, 232, 75, 154, 255, 232, 75, 154, 255, 232, 76, 154, 255, 233, 76, 154, 255, 233, 76, 154, 255, 233, 77, 154, 255, 233, 77, 154, 255, 233, 78, 154, 255, 234, 78, 155, 255, 234, 78, 155, 255, 234, 79, 155, 255, 234, 79, 155, 255, 234, 80, 155, 255, 235, 80, 155, 255, 235, 80, 155, 255, 235, 81, 155, 255, 235, 81, 155, 255, 235, 82, 155, 255, 236, 82, 155, 255, 236, 82, 155, 255, 236, 83, 155, 255, 236, 83, 156, 255, 236, 84, 156, 255, 237, 84, 156, 255, 237, 84, 156, 255, 237, 85, 156, 255, 237, 85, 156, 255, 237, 85, 156, 255, 238, 86, 156, 255, 238, 86, 156, 255, 238, 87, 156, 255, 238, 87, 156, 255, 238, 87, 156, 255, 239, 88, 157, 255, 239, 88, 157, 255, 239, 89, 157, 255, 239, 89, 157, 255, 239, 89, 157, 255, 240, 90, 157, 255, 240, 90, 157, 255, 240, 90, 157, 255, 240, 91, 157, 255, 240, 91, 157, 255, 241, 92, 157, 255, 241, 92, 158, 255, 241, 92, 158, 255, 241, 93, 158, 255, 241, 93, 158, 255, 241, 93, 158, 255, 242, 94, 158, 255, 242, 94, 158, 255, 242, 95, 158, 255, 242, 95, 158, 255, 242, 95, 158, 255, 243, 96, 158, 255, 243, 96, 159, 255, 243, 96, 159, 255, 243, 97, 159, 255, 243, 97, 159, 255, 244, 98, 159, 255, 244, 98, 159, 255, 244, 98, 159, 255, 244, 99, 159, 255, 244, 99, 159, 255, 244, 99, 159, 255, 245, 100, 160, 255, 245, 100, 160, 255, 245, 101, 160, 255, 245, 101, 160, 255, 245, 101, 160, 255, 246, 102, 160, 255, 246, 102, 160, 255, 246, 102, 160, 255, 246, 103, 160, 255, 246, 103, 160, 255, 246, 104, 160, 255, 250, 103, 148, 255, 250, 104, 148, 255, 250, 104, 148, 255, 250, 105, 149, 255, 250, 105, 149, 255, 250, 106, 150, 255, 250, 106, 150, 255, 250, 107, 150, 255, 250, 107, 151, 255, 250, 108, 151, 255, 250, 108, 151, 255, 250, 109, 152, 255, 250, 109, 152, 255, 250, 110, 152, 255, 250, 110, 153, 255, 250, 111, 153, 255, 250, 111, 153, 255, 250, 111, 154, 255, 250, 112, 154, 255, 250, 112, 154, 255, 250, 113, 155, 255, 250, 113, 155, 255, 250, 114, 155, 255, 250, 114, 156, 255, 250, 115, 156, 255, 250, 115, 156, 255, 250, 116, 157, 255, 250, 116, 157, 255, 250, 117, 158, 255, 250, 117, 158, 255, 250, 117, 158, 255, 250, 118, 159, 255, 250, 118, 159, 255, 250, 119, 159, 255, 250, 119, 160, 255, 250, 120, 160, 255, 249, 120, 160, 255, 249, 121, 161, 255, 249, 121, 161, 255, 249, 122, 161, 255, 249, 122, 162, 255, 249, 122, 162, 255, 249, 123, 162, 255, 249, 123, 163, 255, 249, 124, 163, 255, 249, 124, 163, 255, 249, 125, 164, 255, 249, 125, 164, 255, 249, 126, 164, 255, 249, 126, 165, 255, 249, 126, 165, 255, 249, 127, 165, 255, 249, 127, 166, 255, 249, 128, 166, 255, 249, 128, 166, 255, 249, 129, 167, 255, 249, 129, 167, 255, 249, 130, 167, 255, 249, 130, 168, 255, 249, 130, 168, 255, 249, 131, 168, 255, 249, 131, 169, 255, 249, 132, 169, 255, 249, 132, 169, 255, 249, 133, 169, 255, 249, 133, 170, 255, 249, 133, 170, 255, 249, 134, 170, 255, 249, 134, 171, 255, 249, 135, 171, 255, 249, 135, 171, 255, 249, 136, 172, 255, 249, 136, 172, 255, 249, 136, 172, 255, 249, 137, 173, 255, 249, 137, 173, 255, 249, 138, 173, 255, 249, 138, 174, 255, 249, 139, 174, 255, 249, 139, 174, 255, 249, 139, 175, 255, 249, 140, 175, 255, 249, 140, 175, 255, 249, 141, 176, 255, 248, 141, 176, 255, 248, 142, 176, 255, 248, 142, 176, 255, 248, 142, 177, 255, 248, 143, 177, 255, 248, 143, 177, 255, 248, 144, 178, 255, 248, 144, 178, 255, 248, 144, 178, 255, 248, 145, 179, 255, 248, 145, 179, 255, 248, 146, 179, 255, 248, 146, 180, 255, 248, 147, 180, 255, 248, 147, 180, 255, 248, 147, 180, 255, 248, 148, 181, 255, 248, 148, 181, 255, 248, 149, 181, 255, 248, 149, 182, 255, 248, 149, 182, 255, 248, 150, 182, 255, 248, 150, 183, 255, 248, 151, 183, 255, 248, 151, 183, 255, 248, 152, 184, 255, 248, 152, 184, 255, 248, 152, 184, 255, 248, 153, 184, 255, 248, 153, 185, 255, 247, 154, 185, 255, 247, 154, 185, 255, 247, 154, 186, 255, 247, 155, 186, 255, 247, 155, 186, 255, 247, 156, 186, 255, 247, 156, 187, 255, 247, 156, 187, 255, 247, 157, 187, 255, 247, 157, 188, 255, 247, 158, 188, 255, 247, 158, 188, 255, 247, 158, 189, 255, 247, 159, 189, 255, 250, 159, 180, 255, 250, 159, 180, 255, 250, 159, 180, 255, 250, 160, 180, 255, 250, 160, 180, 255, 250, 160, 180, 255, 250, 161, 180, 255, 250, 161, 180, 255, 250, 161, 180, 255, 250, 161, 181, 255, 250, 162, 181, 255, 250, 162, 181, 255, 250, 162, 181, 255, 250, 163, 181, 255, 250, 163, 181, 255, 250, 163, 181, 255, 251, 164, 181, 255, 251, 164, 181, 255, 251, 164, 181, 255, 251, 164, 181, 255, 251, 165, 181, 255, 251, 165, 181, 255, 251, 165, 181, 255, 251, 166, 181, 255, 251, 166, 181, 255, 251, 166, 181, 255, 251, 166, 181, 255, 251, 167, 181, 255, 251, 167, 181, 255, 251, 167, 181, 255, 251, 168, 181, 255, 251, 168, 181, 255, 251, 168, 181, 255, 251, 169, 181, 255, 251, 169, 181, 255, 251, 169, 181, 255, 251, 169, 181, 255, 251, 170, 181, 255, 251, 170, 181, 255, 251, 170, 181, 255, 252, 171, 181, 255, 252, 171, 181, 255, 252, 171, 182, 255, 252, 172, 182, 255, 252, 172, 182, 255, 252, 172, 182, 255, 252, 172, 182, 255, 252, 173, 182, 255, 252, 173, 182, 255, 252, 173, 182, 255, 252, 174, 182, 255, 252, 174, 182, 255, 252, 174, 182, 255, 252, 175, 182, 255, 252, 175, 182, 255, 252, 175, 182, 255, 252, 175, 182, 255, 252, 176, 182, 255, 252, 176, 183, 255, 252, 176, 183, 255, 252, 177, 183, 255, 252, 177, 183, 255, 252, 177, 183, 255, 252, 177, 183, 255, 252, 178, 183, 255, 252, 178, 183, 255, 252, 178, 183, 255, 252, 179, 183, 255, 252, 179, 183, 255, 252, 179, 184, 255, 252, 180, 184, 255, 252, 180, 184, 255, 252, 180, 184, 255, 252, 180, 184, 255, 252, 181, 184, 255, 252, 181, 184, 255, 252, 181, 184, 255, 252, 182, 184, 255, 252, 182, 184, 255, 252, 182, 185, 255, 252, 183, 185, 255, 252, 183, 185, 255, 252, 183, 185, 255, 252, 183, 185, 255, 252, 184, 185, 255, 252, 184, 185, 255, 252, 184, 185, 255, 252, 185, 185, 255, 252, 185, 186, 255, 252, 185, 186, 255, 252, 186, 186, 255, 252, 186, 186, 255, 252, 186, 186, 255, 252, 186, 186, 255, 252, 187, 186, 255, 252, 187, 186, 255, 252, 187, 187, 255, 252, 188, 187, 255, 252, 188, 187, 255, 252, 188, 187, 255, 252, 189, 187, 255, 252, 189, 187, 255, 252, 189, 187, 255, 252, 189, 188, 255, 252, 190, 188, 255, 252, 190, 188, 255, 252, 190, 188, 255, 252, 191, 188, 255, 252, 191, 188, 255, 252, 191, 188, 255, 252, 191, 189, 255, 252, 192, 189, 255, 252, 192, 189, 255, 252, 192, 189, 255, 252, 193, 189, 255, 252, 193, 189, 255, 252, 193, 190, 255, 252, 194, 190, 255, 252, 194, 190, 255, 252, 194, 190, 255, 252, 194, 190, 255, 252, 195, 190, 255, 252, 195, 191, 255, 252, 195, 191, 255, 252, 196, 191, 255, 252, 196, 191, 255, 252, 196, 191, 255, 251, 197, 191, 255, 252, 197, 192, 255, 252, 197, 192, 255, 252, 197, 192, 255, 252, 197, 192, 255, 252, 198, 193, 255, 252, 198, 193, 255, 252, 198, 193, 255, 252, 198, 193, 255, 252, 198, 194, 255, 252, 199, 194, 255, 252, 199, 194, 255, 252, 199, 194, 255, 252, 199, 194, 255, 252, 199, 195, 255, 252, 200, 195, 255, 252, 200, 195, 255, 252, 200, 195, 255, 252, 200, 196, 255, 252, 201, 196, 255, 252, 201, 196, 255, 252, 201, 196, 255, 252, 201, 196, 255, 252, 201, 197, 255, 252, 202, 197, 255, 252, 202, 197, 255, 252, 202, 197, 255, 252, 202, 198, 255, 252, 202, 198, 255, 252, 203, 198, 255, 252, 203, 198, 255, 252, 203, 198, 255, 252, 203, 199, 255, 252, 203, 199, 255, 252, 204, 199, 255, 252, 204, 199, 255, 252, 204, 200, 255, 252, 204, 200, 255, 252, 205, 200, 255, 252, 205, 200, 255, 252, 205, 200, 255, 252, 205, 201, 255, 252, 205, 201, 255, 252, 206, 201, 255, 252, 206, 201, 255, 252, 206, 202, 255, 252, 206, 202, 255, 252, 206, 202, 255, 252, 207, 202, 255, 252, 207, 202, 255, 252, 207, 203, 255, 252, 207, 203, 255, 252, 207, 203, 255, 252, 208, 203, 255, 252, 208, 204, 255, 252, 208, 204, 255, 252, 208, 204, 255, 252, 209, 204, 255, 252, 209, 205, 255, 252, 209, 205, 255, 252, 209, 205, 255, 252, 209, 205, 255, 252, 210, 205, 255, 252, 210, 206, 255, 252, 210, 206, 255, 252, 210, 206, 255, 252, 210, 206, 255, 252, 211, 207, 255, 252, 211, 207, 255, 252, 211, 207, 255, 252, 211, 207, 255, 252, 211, 207, 255, 252, 212, 208, 255, 252, 212, 208, 255, 252, 212, 208, 255, 252, 212, 208, 255, 252, 213, 209, 255, 252, 213, 209, 255, 252, 213, 209, 255, 252, 213, 209, 255, 252, 213, 210, 255, 252, 214, 210, 255, 252, 214, 210, 255, 252, 214, 210, 255, 252, 214, 210, 255, 252, 214, 211, 255, 252, 215, 211, 255, 252, 215, 211, 255, 252, 215, 211, 255, 252, 215, 212, 255, 252, 215, 212, 255, 252, 216, 212, 255, 252, 216, 212, 255, 252, 216, 212, 255, 252, 216, 213, 255, 252, 217, 213, 255, 252, 217, 213, 255, 252, 217, 213, 255, 252, 217, 214, 255, 252, 217, 214, 255, 252, 218, 214, 255, 252, 218, 214, 255, 252, 218, 215, 255, 252, 218, 215, 255, 252, 218, 215, 255, 252, 219, 215, 255, 252, 219, 215, 255, 252, 219, 216, 255, 252, 219, 216, 255, 253, 219, 216, 255, 253, 220, 216, 255, 253, 220, 217, 255, 253, 220, 217, 255, 253, 220, 217, 255, 253, 221, 217, 255, 253, 221, 218, 255, 253, 221, 218, 255, 253, 221, 218, 255, 253, 221, 218, 255, 253, 222, 218, 255, 253, 222, 219, 255, 253, 222, 219, 255, 253, 222, 219, 255, 253, 222, 219, 255, 253, 223, 220, 255, 253, 223, 220, 255, 253, 223, 220, 255, 253, 223, 220, 255, 252, 224, 220, 255, 253, 224, 221, 255, 253, 224, 221, 255, 253, 224, 221, 255, 253, 224, 221, 255, 253, 224, 221, 255, 253, 225, 221, 255, 253, 225, 221, 255, 253, 225, 222, 255, 253, 225, 222, 255, 253, 225, 222, 255, 253, 226, 222, 255, 253, 226, 222, 255, 253, 226, 222, 255, 253, 226, 222, 255, 253, 226, 222, 255, 253, 226, 223, 255, 253, 227, 223, 255, 253, 227, 223, 255, 253, 227, 223, 255, 253, 227, 223, 255, 253, 227, 223, 255, 253, 228, 223, 255, 253, 228, 224, 255, 253, 228, 224, 255, 253, 228, 224, 255, 253, 228, 224, 255, 253, 228, 224, 255, 253, 229, 224, 255, 253, 229, 224, 255, 253, 229, 225, 255, 253, 229, 225, 255, 253, 229, 225, 255, 253, 230, 225, 255, 253, 230, 225, 255, 253, 230, 225, 255, 253, 230, 225, 255, 253, 230, 226, 255, 253, 230, 226, 255, 253, 231, 226, 255, 253, 231, 226, 255, 253, 231, 226, 255, 253, 231, 226, 255, 253, 231, 227, 255, 253, 232, 227, 255, 253, 232, 227, 255, 253, 232, 227, 255, 253, 232, 227, 255, 253, 232, 227, 255, 253, 232, 227, 255, 253, 233, 228, 255, 253, 233, 228, 255, 253, 233, 228, 255, 253, 233, 228, 255, 253, 233, 228, 255, 253, 234, 228, 255, 253, 234, 229, 255, 253, 234, 229, 255, 253, 234, 229, 255, 253, 234, 229, 255, 253, 234, 229, 255, 253, 235, 229, 255, 253, 235, 230, 255, 253, 235, 230, 255, 253, 235, 230, 255, 253, 235, 230, 255, 253, 236, 230, 255, 253, 236, 230, 255, 254, 236, 231, 255, 254, 236, 231, 255, 254, 236, 231, 255, 254, 236, 231, 255, 254, 237, 231, 255, 254, 237, 232, 255, 254, 237, 232, 255, 254, 237, 232, 255, 254, 237, 232, 255, 254, 238, 232, 255, 254, 238, 232, 255, 254, 238, 233, 255, 254, 238, 233, 255, 254, 238, 233, 255, 254, 238, 233, 255, 254, 239, 233, 255, 254, 239, 234, 255, 254, 239, 234, 255, 254, 239, 234, 255, 254, 239, 234, 255, 254, 240, 234, 255, 254, 240, 235, 255, 254, 240, 235, 255, 254, 240, 235, 255, 254, 240, 235, 255, 254, 240, 235, 255, 254, 241, 236, 255, 254, 241, 236, 255, 254, 241, 236, 255, 254, 241, 236, 255, 254, 241, 236, 255, 254, 241, 236, 255, 254, 242, 237, 255, 254, 242, 237, 255, 254, 242, 237, 255, 254, 242, 237, 255, 254, 242, 237, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 240, 255, 254, 244, 240, 255, 254, 244, 240, 255, 254, 245, 240, 255, 254, 245, 240, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 246, 241, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_RdPu_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 72, 0, 106, 0, 73, 0, 106, 7, 73, 0, 106, 14, 73, 0, 106, 22, 74, 0, 106, 29, 74, 0, 106, 37, 74, 0, 106, 44, 75, 0, 106, 52, 75, 0, 106, 59, 75, 0, 106, 67, 76, 0, 106, 74, 76, 0, 107, 82, 76, 0, 107, 89, 77, 0, 107, 97, 77, 0, 107, 104, 77, 0, 107, 112, 78, 0, 107, 119, 78, 0, 107, 127, 78, 0, 107, 134, 79, 0, 107, 141, 79, 0, 107, 149, 79, 0, 107, 156, 79, 0, 108, 164, 80, 0, 108, 171, 80, 0, 108, 179, 80, 0, 108, 186, 81, 0, 108, 194, 81, 0, 108, 201, 81, 0, 108, 209, 82, 0, 108, 216, 82, 0, 108, 224, 82, 0, 108, 231, 83, 0, 108, 239, 83, 0, 108, 246, 83, 0, 109, 254, 84, 0, 109, 255, 84, 0, 109, 255, 84, 0, 109, 255, 84, 0, 109, 255, 85, 0, 109, 255, 85, 0, 109, 255, 85, 0, 109, 255, 86, 0, 109, 255, 86, 0, 109, 255, 86, 0, 109, 255, 87, 0, 110, 255, 87, 0, 110, 255, 87, 0, 110, 255, 88, 0, 110, 255, 88, 0, 110, 255, 88, 0, 110, 255, 88, 0, 110, 255, 89, 0, 110, 255, 89, 0, 110, 255, 89, 0, 110, 255, 90, 0, 110, 255, 90, 0, 110, 255, 90, 0, 111, 255, 91, 0, 111, 255, 91, 0, 111, 255, 91, 0, 111, 255, 92, 0, 111, 255, 92, 0, 111, 255, 92, 0, 111, 255, 102, 0, 114, 255, 103, 0, 114, 255, 103, 0, 114, 255, 103, 0, 114, 255, 103, 0, 114, 255, 104, 0, 114, 255, 104, 0, 114, 255, 104, 0, 114, 255, 105, 0, 114, 255, 105, 0, 114, 255, 105, 0, 114, 255, 106, 0, 115, 255, 106, 0, 115, 255, 106, 0, 115, 255, 107, 0, 115, 255, 107, 0, 115, 255, 107, 0, 115, 255, 107, 0, 115, 255, 108, 0, 115, 255, 108, 0, 115, 255, 108, 0, 115, 255, 109, 0, 115, 255, 109, 0, 115, 255, 109, 0, 116, 255, 110, 0, 116, 255, 110, 0, 116, 255, 110, 0, 116, 255, 110, 0, 116, 255, 111, 0, 116, 255, 111, 0, 116, 255, 111, 0, 116, 255, 112, 0, 116, 255, 112, 0, 116, 255, 112, 0, 116, 255, 113, 0, 116, 255, 113, 0, 116, 255, 113, 0, 116, 255, 113, 0, 117, 255, 114, 0, 117, 255, 114, 0, 117, 255, 114, 0, 117, 255, 115, 0, 117, 255, 115, 0, 117, 255, 115, 0, 117, 255, 116, 0, 117, 255, 116, 0, 117, 255, 116, 0, 117, 255, 116, 0, 117, 255, 117, 0, 117, 255, 117, 0, 117, 255, 117, 0, 118, 255, 118, 0, 118, 255, 118, 0, 118, 255, 118, 0, 118, 255, 119, 0, 118, 255, 119, 0, 118, 255, 119, 0, 118, 255, 119, 0, 118, 255, 120, 0, 118, 255, 120, 0, 118, 255, 120, 0, 118, 255, 121, 0, 118, 255, 121, 0, 118, 255, 121, 0, 118, 255, 121, 1, 119, 255, 122, 0, 119, 255, 122, 0, 119, 255, 122, 0, 119, 255, 123, 0, 119, 255, 123, 0, 119, 255, 123, 0, 119, 255, 124, 0, 119, 255, 124, 0, 119, 255, 124, 0, 119, 255, 125, 0, 119, 255, 125, 0, 119, 255, 125, 0, 119, 255, 126, 0, 119, 255, 126, 0, 119, 255, 126, 0, 119, 255, 127, 0, 119, 255, 127, 0, 120, 255, 127, 0, 120, 255, 128, 0, 120, 255, 128, 0, 120, 255, 128, 0, 120, 255, 129, 0, 120, 255, 129, 0, 120, 255, 129, 0, 120, 255, 130, 0, 120, 255, 130, 0, 120, 255, 130, 0, 120, 255, 131, 0, 120, 255, 131, 0, 120, 255, 131, 0, 120, 255, 132, 0, 120, 255, 132, 0, 120, 255, 132, 0, 120, 255, 133, 0, 120, 255, 133, 0, 121, 255, 133, 0, 121, 255, 134, 0, 121, 255, 134, 0, 121, 255, 134, 0, 121, 255, 135, 0, 121, 255, 135, 0, 121, 255, 135, 0, 121, 255, 136, 0, 121, 255, 136, 0, 121, 255, 136, 0, 121, 255, 137, 0, 121, 255, 137, 0, 121, 255, 137, 0, 121, 255, 138, 0, 121, 255, 138, 0, 121, 255, 138, 0, 121, 255, 139, 0, 121, 255, 139, 0, 121, 255, 139, 0, 121, 255, 140, 0, 122, 255, 140, 0, 122, 255, 140, 0, 122, 255, 141, 0, 122, 255, 141, 0, 122, 255, 141, 0, 122, 255, 142, 0, 122, 255, 142, 0, 122, 255, 142, 0, 122, 255, 153, 0, 123, 255, 153, 0, 123, 255, 154, 0, 123, 255, 154, 0, 123, 255, 154, 0, 124, 255, 155, 0, 124, 255, 155, 0, 124, 255, 155, 0, 124, 255, 156, 0, 124, 255, 156, 0, 124, 255, 156, 0, 124, 255, 157, 0, 124, 255, 157, 0, 124, 255, 157, 0, 124, 255, 157, 0, 124, 255, 158, 0, 124, 255, 158, 0, 124, 255, 158, 0, 124, 255, 159, 0, 124, 255, 159, 0, 124, 255, 159, 0, 124, 255, 160, 0, 124, 255, 160, 0, 124, 255, 160, 0, 124, 255, 161, 0, 124, 255, 161, 0, 124, 255, 161, 0, 124, 255, 162, 0, 124, 255, 162, 0, 124, 255, 162, 0, 124, 255, 163, 0, 125, 255, 163, 0, 125, 255, 163, 0, 125, 255, 164, 0, 125, 255, 164, 0, 125, 255, 164, 0, 125, 255, 165, 0, 125, 255, 165, 0, 125, 255, 165, 0, 125, 255, 166, 0, 125, 255, 166, 0, 125, 255, 166, 0, 125, 255, 166, 0, 125, 255, 167, 0, 125, 255, 167, 0, 125, 255, 167, 0, 125, 255, 168, 0, 125, 255, 168, 0, 125, 255, 168, 0, 125, 255, 169, 0, 125, 255, 169, 0, 125, 255, 169, 0, 125, 255, 170, 0, 125, 255, 170, 0, 125, 255, 170, 0, 125, 255, 171, 0, 125, 255, 171, 0, 125, 255, 171, 0, 125, 255, 172, 0, 125, 255, 172, 0, 125, 255, 172, 0, 125, 255, 173, 0, 125, 255, 173, 0, 125, 255, 173, 0, 125, 255, 173, 1, 125, 255, 174, 1, 126, 255, 174, 1, 126, 255, 174, 2, 126, 255, 175, 2, 126, 255, 175, 3, 126, 255, 175, 3, 126, 255, 176, 4, 127, 255, 176, 4, 127, 255, 176, 5, 127, 255, 176, 5, 127, 255, 177, 6, 127, 255, 177, 6, 127, 255, 177, 7, 128, 255, 178, 7, 128, 255, 178, 8, 128, 255, 178, 8, 128, 255, 178, 9, 128, 255, 179, 9, 128, 255, 179, 10, 128, 255, 179, 10, 129, 255, 180, 11, 129, 255, 180, 11, 129, 255, 180, 11, 129, 255, 180, 12, 129, 255, 181, 12, 129, 255, 181, 13, 130, 255, 181, 13, 130, 255, 182, 14, 130, 255, 182, 14, 130, 255, 182, 14, 130, 255, 183, 15, 130, 255, 183, 15, 131, 255, 183, 15, 131, 255, 183, 16, 131, 255, 184, 16, 131, 255, 184, 16, 131, 255, 184, 17, 131, 255, 185, 17, 131, 255, 185, 17, 132, 255, 185, 18, 132, 255, 185, 18, 132, 255, 186, 18, 132, 255, 186, 19, 132, 255, 186, 19, 132, 255, 187, 19, 133, 255, 187, 20, 133, 255, 187, 20, 133, 255, 187, 20, 133, 255, 188, 21, 133, 255, 188, 21, 133, 255, 188, 21, 134, 255, 189, 22, 134, 255, 189, 22, 134, 255, 189, 22, 134, 255, 190, 22, 134, 255, 190, 23, 134, 255, 190, 23, 134, 255, 190, 23, 135, 255, 191, 24, 135, 255, 191, 24, 135, 255, 191, 24, 135, 255, 192, 25, 135, 255, 192, 25, 135, 255, 202, 35, 141, 255, 202, 36, 141, 255, 202, 36, 141, 255, 202, 36, 141, 255, 203, 36, 141, 255, 203, 37, 141, 255, 203, 37, 141, 255, 204, 37, 142, 255, 204, 38, 142, 255, 204, 38, 142, 255, 205, 38, 142, 255, 205, 38, 142, 255, 205, 39, 142, 255, 205, 39, 143, 255, 206, 39, 143, 255, 206, 39, 143, 255, 206, 40, 143, 255, 207, 40, 143, 255, 207, 40, 143, 255, 207, 40, 143, 255, 207, 41, 144, 255, 208, 41, 144, 255, 208, 41, 144, 255, 208, 41, 144, 255, 209, 42, 144, 255, 209, 42, 144, 255, 209, 42, 145, 255, 210, 42, 145, 255, 210, 43, 145, 255, 210, 43, 145, 255, 210, 43, 145, 255, 211, 44, 145, 255, 211, 44, 146, 255, 211, 44, 146, 255, 212, 44, 146, 255, 212, 45, 146, 255, 212, 45, 146, 255, 212, 45, 146, 255, 213, 45, 146, 255, 213, 45, 147, 255, 213, 46, 147, 255, 214, 46, 147, 255, 214, 46, 147, 255, 214, 46, 147, 255, 215, 47, 147, 255, 215, 47, 148, 255, 215, 47, 148, 255, 215, 47, 148, 255, 216, 48, 148, 255, 216, 48, 148, 255, 216, 48, 148, 255, 217, 48, 148, 255, 217, 49, 149, 255, 217, 49, 149, 255, 218, 49, 149, 255, 218, 49, 149, 255, 218, 50, 149, 255, 218, 50, 149, 255, 219, 50, 150, 255, 219, 50, 150, 255, 219, 51, 150, 255, 220, 51, 150, 255, 220, 51, 150, 255, 220, 51, 150, 255, 220, 52, 150, 255, 221, 52, 151, 255, 221, 52, 151, 255, 221, 53, 151, 255, 221, 53, 151, 255, 221, 53, 151, 255, 222, 54, 151, 255, 222, 54, 151, 255, 222, 55, 151, 255, 222, 55, 151, 255, 222, 55, 151, 255, 222, 56, 151, 255, 223, 56, 151, 255, 223, 56, 151, 255, 223, 57, 151, 255, 223, 57, 151, 255, 223, 57, 151, 255, 224, 58, 151, 255, 224, 58, 151, 255, 224, 59, 151, 255, 224, 59, 151, 255, 224, 59, 152, 255, 224, 60, 152, 255, 225, 60, 152, 255, 225, 60, 152, 255, 225, 61, 152, 255, 225, 61, 152, 255, 225, 61, 152, 255, 225, 62, 152, 255, 226, 62, 152, 255, 226, 62, 152, 255, 226, 63, 152, 255, 226, 63, 152, 255, 226, 63, 152, 255, 226, 64, 152, 255, 227, 64, 152, 255, 227, 64, 152, 255, 227, 65, 152, 255, 227, 65, 152, 255, 227, 65, 152, 255, 227, 66, 153, 255, 228, 66, 153, 255, 228, 66, 153, 255, 228, 67, 153, 255, 228, 67, 153, 255, 228, 67, 153, 255, 228, 68, 153, 255, 229, 68, 153, 255, 229, 68, 153, 255, 229, 69, 153, 255, 229, 69, 153, 255, 229, 69, 153, 255, 229, 70, 153, 255, 230, 70, 153, 255, 230, 70, 153, 255, 230, 71, 153, 255, 230, 71, 153, 255, 230, 71, 154, 255, 230, 72, 154, 255, 231, 72, 154, 255, 231, 72, 154, 255, 231, 73, 154, 255, 231, 73, 154, 255, 231, 73, 154, 255, 237, 84, 156, 255, 237, 84, 156, 255, 237, 85, 156, 255, 237, 85, 156, 255, 237, 85, 156, 255, 237, 86, 156, 255, 238, 86, 156, 255, 238, 86, 156, 255, 238, 87, 156, 255, 238, 87, 156, 255, 238, 87, 157, 255, 238, 88, 157, 255, 239, 88, 157, 255, 239, 88, 157, 255, 239, 88, 157, 255, 239, 89, 157, 255, 239, 89, 157, 255, 239, 89, 157, 255, 240, 90, 157, 255, 240, 90, 157, 255, 240, 90, 157, 255, 240, 91, 157, 255, 240, 91, 157, 255, 240, 91, 157, 255, 240, 92, 158, 255, 241, 92, 158, 255, 241, 92, 158, 255, 241, 92, 158, 255, 241, 93, 158, 255, 241, 93, 158, 255, 241, 93, 158, 255, 242, 94, 158, 255, 242, 94, 158, 255, 242, 94, 158, 255, 242, 95, 158, 255, 242, 95, 158, 255, 242, 95, 158, 255, 242, 95, 158, 255, 243, 96, 158, 255, 243, 96, 159, 255, 243, 96, 159, 255, 243, 97, 159, 255, 243, 97, 159, 255, 243, 97, 159, 255, 244, 98, 159, 255, 244, 98, 159, 255, 244, 98, 159, 255, 244, 98, 159, 255, 244, 99, 159, 255, 244, 99, 159, 255, 244, 99, 159, 255, 245, 100, 159, 255, 245, 100, 160, 255, 245, 100, 160, 255, 245, 101, 160, 255, 245, 101, 160, 255, 245, 101, 160, 255, 245, 101, 160, 255, 246, 102, 160, 255, 246, 102, 160, 255, 246, 102, 160, 255, 246, 103, 160, 255, 246, 103, 160, 255, 246, 103, 160, 255, 246, 104, 160, 255, 249, 103, 150, 255, 249, 104, 151, 255, 249, 104, 151, 255, 249, 105, 151, 255, 249, 105, 151, 255, 249, 105, 152, 255, 249, 106, 152, 255, 249, 106, 152, 255, 249, 106, 153, 255, 249, 107, 153, 255, 249, 107, 153, 255, 249, 108, 153, 255, 249, 108, 154, 255, 249, 108, 154, 255, 249, 109, 154, 255, 249, 109, 155, 255, 249, 109, 155, 255, 249, 110, 155, 255, 249, 110, 155, 255, 249, 111, 156, 255, 249, 111, 156, 255, 249, 111, 156, 255, 249, 112, 156, 255, 249, 112, 157, 255, 249, 112, 157, 255, 249, 113, 157, 255, 249, 113, 158, 255, 249, 114, 158, 255, 249, 114, 158, 255, 249, 114, 158, 255, 249, 115, 159, 255, 249, 115, 159, 255, 249, 115, 159, 255, 249, 116, 159, 255, 249, 116, 160, 255, 249, 116, 160, 255, 249, 117, 160, 255, 249, 117, 161, 255, 249, 118, 161, 255, 249, 118, 161, 255, 249, 118, 161, 255, 249, 119, 162, 255, 249, 119, 162, 255, 249, 119, 162, 255, 249, 120, 162, 255, 249, 120, 163, 255, 249, 120, 163, 255, 249, 121, 163, 255, 249, 121, 163, 255, 249, 122, 164, 255, 249, 122, 164, 255, 249, 122, 164, 255, 249, 123, 165, 255, 249, 123, 165, 255, 249, 123, 165, 255, 249, 124, 165, 255, 249, 124, 166, 255, 249, 124, 166, 255, 249, 125, 166, 255, 249, 125, 166, 255, 249, 125, 167, 255, 249, 126, 167, 255, 249, 126, 167, 255, 249, 137, 171, 255, 249, 138, 172, 255, 249, 138, 172, 255, 249, 138, 172, 255, 249, 139, 172, 255, 249, 139, 173, 255, 249, 139, 173, 255, 249, 140, 173, 255, 249, 140, 173, 255, 249, 141, 174, 255, 249, 141, 174, 255, 249, 141, 174, 255, 249, 142, 175, 255, 249, 142, 175, 255, 249, 142, 175, 255, 249, 143, 175, 255, 249, 143, 176, 255, 249, 143, 176, 255, 249, 144, 176, 255, 249, 144, 176, 255, 249, 144, 177, 255, 249, 145, 177, 255, 249, 145, 177, 255, 249, 145, 177, 255, 249, 146, 178, 255, 249, 146, 178, 255, 249, 146, 178, 255, 249, 147, 178, 255, 249, 147, 179, 255, 249, 147, 179, 255, 248, 148, 179, 255, 248, 148, 179, 255, 248, 148, 180, 255, 248, 149, 180, 255, 248, 149, 180, 255, 248, 149, 180, 255, 248, 150, 180, 255, 248, 150, 181, 255, 248, 150, 181, 255, 248, 151, 181, 255, 248, 151, 181, 255, 248, 151, 182, 255, 248, 152, 182, 255, 248, 152, 182, 255, 248, 152, 182, 255, 248, 153, 183, 255, 248, 153, 183, 255, 248, 153, 183, 255, 248, 154, 183, 255, 248, 154, 184, 255, 248, 154, 184, 255, 248, 155, 184, 255, 248, 155, 184, 255, 248, 155, 185, 255, 248, 156, 185, 255, 248, 156, 185, 255, 248, 156, 185, 255, 248, 156, 186, 255, 248, 157, 186, 255, 248, 157, 186, 255, 248, 157, 186, 255, 248, 158, 186, 255, 248, 158, 187, 255, 247, 158, 187, 255, 247, 159, 187, 255, 250, 159, 180, 255, 250, 159, 180, 255, 250, 159, 180, 255, 250, 159, 180, 255, 250, 160, 180, 255, 250, 160, 180, 255, 250, 160, 180, 255, 250, 160, 180, 255, 250, 161, 180, 255, 250, 161, 181, 255, 250, 161, 181, 255, 250, 161, 181, 255, 250, 162, 181, 255, 250, 162, 181, 255, 250, 162, 181, 255, 250, 162, 181, 255, 250, 163, 181, 255, 250, 163, 181, 255, 250, 163, 181, 255, 250, 163, 181, 255, 250, 163, 181, 255, 251, 164, 181, 255, 251, 164, 181, 255, 251, 164, 181, 255, 251, 164, 181, 255, 251, 165, 181, 255, 251, 165, 181, 255, 251, 165, 181, 255, 251, 165, 181, 255, 251, 166, 181, 255, 251, 166, 181, 255, 251, 166, 181, 255, 251, 166, 181, 255, 251, 167, 181, 255, 251, 167, 181, 255, 251, 167, 181, 255, 251, 167, 181, 255, 251, 167, 181, 255, 251, 168, 181, 255, 251, 168, 181, 255, 251, 168, 181, 255, 251, 168, 181, 255, 251, 169, 181, 255, 251, 169, 181, 255, 251, 169, 181, 255, 251, 169, 181, 255, 251, 170, 181, 255, 251, 170, 182, 255, 251, 170, 182, 255, 251, 170, 182, 255, 251, 171, 182, 255, 251, 171, 182, 255, 251, 171, 182, 255, 251, 171, 182, 255, 251, 172, 182, 255, 251, 172, 182, 255, 251, 172, 182, 255, 251, 172, 182, 255, 251, 172, 182, 255, 251, 173, 182, 255, 251, 173, 182, 255, 251, 173, 182, 255, 251, 173, 182, 255, 252, 181, 185, 255, 252, 182, 185, 255, 252, 182, 185, 255, 252, 182, 185, 255, 252, 182, 185, 255, 252, 182, 185, 255, 252, 183, 185, 255, 252, 183, 185, 255, 252, 183, 185, 255, 252, 183, 185, 255, 252, 184, 185, 255, 252, 184, 185, 255, 252, 184, 186, 255, 252, 184, 186, 255, 252, 185, 186, 255, 252, 185, 186, 255, 252, 185, 186, 255, 252, 185, 186, 255, 252, 186, 186, 255, 252, 186, 186, 255, 252, 186, 186, 255, 252, 186, 186, 255, 252, 187, 186, 255, 252, 187, 187, 255, 252, 187, 187, 255, 252, 187, 187, 255, 252, 187, 187, 255, 252, 188, 187, 255, 252, 188, 187, 255, 252, 188, 187, 255, 252, 188, 187, 255, 252, 189, 187, 255, 252, 189, 187, 255, 252, 189, 188, 255, 252, 189, 188, 255, 252, 190, 188, 255, 252, 190, 188, 255, 252, 190, 188, 255, 252, 190, 188, 255, 252, 191, 188, 255, 252, 191, 188, 255, 252, 191, 188, 255, 252, 191, 189, 255, 252, 192, 189, 255, 252, 192, 189, 255, 252, 192, 189, 255, 252, 192, 189, 255, 252, 192, 189, 255, 252, 193, 189, 255, 252, 193, 189, 255, 252, 193, 190, 255, 252, 193, 190, 255, 252, 194, 190, 255, 252, 194, 190, 255, 252, 194, 190, 255, 252, 194, 190, 255, 252, 195, 190, 255, 252, 195, 191, 255, 252, 195, 191, 255, 252, 195, 191, 255, 252, 196, 191, 255, 252, 196, 191, 255, 252, 196, 191, 255, 252, 196, 191, 255, 251, 197, 191, 255, 252, 197, 192, 255, 252, 197, 192, 255, 252, 197, 192, 255, 252, 197, 192, 255, 252, 197, 192, 255, 252, 198, 193, 255, 252, 198, 193, 255, 252, 198, 193, 255, 252, 198, 193, 255, 252, 198, 193, 255, 252, 198, 193, 255, 252, 199, 194, 255, 252, 199, 194, 255, 252, 199, 194, 255, 252, 199, 194, 255, 252, 199, 194, 255, 252, 199, 195, 255, 252, 200, 195, 255, 252, 200, 195, 255, 252, 200, 195, 255, 252, 200, 195, 255, 252, 200, 195, 255, 252, 200, 196, 255, 252, 201, 196, 255, 252, 201, 196, 255, 252, 201, 196, 255, 252, 201, 196, 255, 252, 201, 197, 255, 252, 201, 197, 255, 252, 202, 197, 255, 252, 202, 197, 255, 252, 202, 197, 255, 252, 202, 197, 255, 252, 202, 198, 255, 252, 202, 198, 255, 252, 203, 198, 255, 252, 203, 198, 255, 252, 203, 198, 255, 252, 203, 198, 255, 252, 203, 199, 255, 252, 203, 199, 255, 252, 204, 199, 255, 252, 204, 199, 255, 252, 204, 199, 255, 252, 204, 200, 255, 252, 204, 200, 255, 252, 204, 200, 255, 252, 205, 200, 255, 252, 205, 200, 255, 252, 205, 200, 255, 252, 205, 201, 255, 252, 205, 201, 255, 252, 205, 201, 255, 252, 206, 201, 255, 252, 206, 201, 255, 252, 206, 202, 255, 252, 206, 202, 255, 252, 206, 202, 255, 252, 206, 202, 255, 252, 207, 202, 255, 252, 207, 202, 255, 252, 207, 203, 255, 252, 207, 203, 255, 252, 213, 209, 255, 252, 213, 209, 255, 252, 213, 209, 255, 252, 213, 209, 255, 252, 213, 210, 255, 252, 214, 210, 255, 252, 214, 210, 255, 252, 214, 210, 255, 252, 214, 210, 255, 252, 214, 210, 255, 252, 214, 211, 255, 252, 215, 211, 255, 252, 215, 211, 255, 252, 215, 211, 255, 252, 215, 211, 255, 252, 215, 212, 255, 252, 215, 212, 255, 252, 216, 212, 255, 252, 216, 212, 255, 252, 216, 212, 255, 252, 216, 212, 255, 252, 216, 213, 255, 252, 216, 213, 255, 252, 217, 213, 255, 252, 217, 213, 255, 252, 217, 213, 255, 252, 217, 214, 255, 252, 217, 214, 255, 252, 217, 214, 255, 252, 218, 214, 255, 252, 218, 214, 255, 252, 218, 214, 255, 252, 218, 215, 255, 252, 218, 215, 255, 252, 218, 215, 255, 252, 219, 215, 255, 252, 219, 215, 255, 252, 219, 216, 255, 252, 219, 216, 255, 252, 219, 216, 255, 252, 219, 216, 255, 252, 220, 216, 255, 252, 220, 216, 255, 252, 220, 217, 255, 252, 220, 217, 255, 253, 220, 217, 255, 253, 220, 217, 255, 253, 221, 217, 255, 253, 221, 218, 255, 253, 221, 218, 255, 253, 221, 218, 255, 253, 221, 218, 255, 253, 221, 218, 255, 253, 222, 218, 255, 253, 222, 219, 255, 253, 222, 219, 255, 253, 222, 219, 255, 253, 222, 219, 255, 253, 222, 219, 255, 253, 223, 220, 255, 253, 223, 220, 255, 253, 223, 220, 255, 253, 223, 220, 255, 253, 223, 220, 255, 252, 224, 220, 255, 253, 224, 221, 255, 253, 224, 221, 255, 253, 224, 221, 255, 253, 224, 221, 255, 253, 224, 221, 255, 253, 224, 221, 255, 253, 225, 221, 255, 253, 225, 221, 255, 253, 225, 221, 255, 253, 225, 222, 255, 253, 225, 222, 255, 253, 225, 222, 255, 253, 225, 222, 255, 253, 226, 222, 255, 253, 226, 222, 255, 253, 226, 222, 255, 253, 226, 222, 255, 253, 226, 222, 255, 253, 226, 222, 255, 253, 226, 223, 255, 253, 227, 223, 255, 253, 227, 223, 255, 253, 227, 223, 255, 253, 227, 223, 255, 253, 227, 223, 255, 253, 227, 223, 255, 253, 227, 223, 255, 253, 228, 223, 255, 253, 228, 224, 255, 253, 228, 224, 255, 253, 228, 224, 255, 253, 228, 224, 255, 253, 228, 224, 255, 253, 228, 224, 255, 253, 229, 224, 255, 253, 229, 224, 255, 253, 229, 225, 255, 253, 229, 225, 255, 253, 229, 225, 255, 253, 229, 225, 255, 253, 230, 225, 255, 253, 230, 225, 255, 253, 230, 225, 255, 253, 230, 225, 255, 253, 230, 226, 255, 253, 230, 226, 255, 253, 230, 226, 255, 253, 231, 226, 255, 253, 231, 226, 255, 253, 231, 226, 255, 253, 231, 226, 255, 253, 231, 226, 255, 253, 231, 227, 255, 253, 231, 227, 255, 253, 232, 227, 255, 253, 232, 227, 255, 253, 232, 227, 255, 253, 232, 227, 255, 253, 232, 227, 255, 253, 232, 228, 255, 253, 232, 228, 255, 253, 233, 228, 255, 253, 233, 228, 255, 254, 237, 232, 255, 254, 238, 233, 255, 254, 238, 233, 255, 254, 238, 233, 255, 254, 238, 233, 255, 254, 238, 233, 255, 254, 238, 233, 255, 254, 238, 233, 255, 254, 239, 234, 255, 254, 239, 234, 255, 254, 239, 234, 255, 254, 239, 234, 255, 254, 239, 234, 255, 254, 239, 234, 255, 254, 239, 234, 255, 254, 240, 235, 255, 254, 240, 235, 255, 254, 240, 235, 255, 254, 240, 235, 255, 254, 240, 235, 255, 254, 240, 235, 255, 254, 240, 236, 255, 254, 241, 236, 255, 254, 241, 236, 255, 254, 241, 236, 255, 254, 241, 236, 255, 254, 241, 236, 255, 254, 241, 236, 255, 254, 241, 237, 255, 254, 242, 237, 255, 254, 242, 237, 255, 254, 242, 237, 255, 254, 242, 237, 255, 254, 242, 237, 255, 254, 242, 238, 255, 254, 242, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 239, 255, 254, 243, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 240, 255, 254, 244, 240, 255, 254, 244, 240, 255, 254, 245, 240, 255, 254, 245, 240, 255, 254, 245, 240, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 246, 241, 255, 254, 246, 241, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_RdPu_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 72, 0, 106, 0, 76, 0, 106, 24, 79, 0, 107, 49, 82, 0, 108, 74, 85, 0, 109, 99, 88, 0, 110, 124, 91, 0, 111, 149, 103, 0, 114, 174, 106, 0, 115, 199, 109, 0, 115, 224, 112, 0, 116, 249, 115, 0, 117, 255, 117, 0, 118, 255, 120, 0, 118, 255, 123, 0, 119, 255, 126, 0, 119, 255, 129, 0, 120, 255, 131, 0, 120, 255, 134, 0, 121, 255, 137, 0, 121, 255, 140, 0, 122, 255, 142, 0, 122, 255, 156, 0, 124, 255, 158, 0, 124, 255, 161, 0, 124, 255, 163, 0, 125, 255, 166, 0, 125, 255, 168, 0, 125, 255, 171, 0, 125, 255, 173, 0, 125, 255, 176, 4, 127, 255, 178, 8, 128, 255, 180, 11, 129, 255, 182, 14, 130, 255, 184, 17, 131, 255, 187, 19, 133, 255, 189, 22, 134, 255, 191, 24, 135, 255, 202, 36, 141, 255, 204, 38, 142, 255, 206, 40, 143, 255, 208, 42, 144, 255, 211, 43, 145, 255, 213, 45, 146, 255, 215, 47, 147, 255, 217, 48, 148, 255, 219, 50, 149, 255, 220, 51, 150, 255, 222, 54, 151, 255, 223, 56, 151, 255, 224, 59, 151, 255, 225, 61, 152, 255, 226, 63, 152, 255, 227, 65, 152, 255, 228, 67, 153, 255, 229, 69, 153, 255, 230, 71, 153, 255, 231, 73, 154, 255, 237, 85, 156, 255, 238, 87, 157, 255, 239, 89, 157, 255, 240, 91, 157, 255, 241, 93, 158, 255, 242, 94, 158, 255, 243, 96, 159, 255, 244, 98, 159, 255, 244, 99, 159, 255, 245, 101, 160, 255, 246, 103, 160, 255, 249, 104, 151, 255, 249, 106, 152, 255, 249, 108, 154, 255, 249, 110, 155, 255, 249, 112, 157, 255, 249, 114, 158, 255, 249, 116, 159, 255, 249, 117, 161, 255, 249, 119, 162, 255, 249, 121, 163, 255, 249, 123, 165, 255, 249, 124, 166, 255, 249, 126, 167, 255, 249, 139, 172, 255, 249, 140, 174, 255, 249, 142, 175, 255, 249, 143, 176, 255, 249, 145, 177, 255, 249, 146, 178, 255, 248, 148, 179, 255, 248, 149, 180, 255, 248, 151, 181, 255, 248, 152, 182, 255, 248, 154, 184, 255, 248, 155, 185, 255, 248, 157, 186, 255, 248, 158, 187, 255, 250, 159, 180, 255, 250, 160, 180, 255, 250, 161, 180, 255, 250, 162, 181, 255, 250, 163, 181, 255, 251, 164, 181, 255, 251, 164, 181, 255, 251, 165, 181, 255, 251, 166, 181, 255, 251, 167, 181, 255, 251, 168, 181, 255, 251, 169, 181, 255, 251, 170, 182, 255, 251, 171, 182, 255, 251, 172, 182, 255, 251, 172, 182, 255, 251, 173, 182, 255, 252, 182, 185, 255, 252, 183, 185, 255, 252, 183, 185, 255, 252, 184, 186, 255, 252, 185, 186, 255, 252, 186, 186, 255, 252, 187, 186, 255, 252, 187, 187, 255, 252, 188, 187, 255, 252, 189, 187, 255, 252, 190, 188, 255, 252, 190, 188, 255, 252, 191, 189, 255, 252, 192, 189, 255, 252, 193, 189, 255, 252, 193, 190, 255, 252, 194, 190, 255, 252, 195, 190, 255, 252, 195, 191, 255, 252, 196, 191, 255, 252, 197, 192, 255, 252, 197, 192, 255, 252, 198, 193, 255, 252, 198, 193, 255, 252, 199, 194, 255, 252, 199, 194, 255, 252, 200, 195, 255, 252, 200, 195, 255, 252, 200, 196, 255, 252, 201, 196, 255, 252, 201, 197, 255, 252, 202, 197, 255, 252, 202, 198, 255, 252, 203, 198, 255, 252, 203, 198, 255, 252, 203, 199, 255, 252, 204, 199, 255, 252, 204, 200, 255, 252, 205, 200, 255, 252, 205, 201, 255, 252, 205, 201, 255, 252, 206, 201, 255, 252, 206, 202, 255, 252, 207, 202, 255, 252, 207, 203, 255, 252, 213, 209, 255, 252, 213, 209, 255, 252, 214, 210, 255, 252, 214, 210, 255, 252, 214, 210, 255, 252, 215, 211, 255, 252, 215, 211, 255, 252, 215, 212, 255, 252, 216, 212, 255, 252, 216, 212, 255, 252, 216, 213, 255, 252, 217, 213, 255, 252, 217, 213, 255, 252, 217, 214, 255, 252, 218, 214, 255, 252, 218, 214, 255, 252, 218, 215, 255, 252, 219, 215, 255, 252, 219, 215, 255, 252, 219, 216, 255, 252, 220, 216, 255, 252, 220, 216, 255, 252, 220, 217, 255, 253, 220, 217, 255, 253, 221, 217, 255, 253, 221, 218, 255, 253, 221, 218, 255, 253, 222, 218, 255, 253, 222, 219, 255, 253, 222, 219, 255, 253, 222, 219, 255, 253, 223, 220, 255, 253, 223, 220, 255, 253, 223, 220, 255, 253, 223, 220, 255, 253, 224, 221, 255, 253, 224, 221, 255, 253, 224, 221, 255, 253, 224, 221, 255, 253, 225, 221, 255, 253, 225, 221, 255, 253, 225, 222, 255, 253, 225, 222, 255, 253, 225, 222, 255, 253, 226, 222, 255, 253, 226, 222, 255, 253, 226, 222, 255, 253, 226, 222, 255, 253, 226, 223, 255, 253, 227, 223, 255, 253, 227, 223, 255, 253, 227, 223, 255, 253, 227, 223, 255, 253, 227, 223, 255, 253, 228, 223, 255, 253, 228, 224, 255, 253, 228, 224, 255, 253, 228, 224, 255, 253, 228, 224, 255, 253, 228, 224, 255, 253, 229, 224, 255, 253, 229, 224, 255, 253, 229, 225, 255, 253, 229, 225, 255, 253, 229, 225, 255, 253, 229, 225, 255, 253, 230, 225, 255, 253, 230, 225, 255, 253, 230, 225, 255, 253, 230, 225, 255, 253, 230, 226, 255, 253, 230, 226, 255, 253, 230, 226, 255, 253, 231, 226, 255, 253, 231, 226, 255, 253, 231, 226, 255, 253, 231, 226, 255, 253, 231, 227, 255, 253, 231, 227, 255, 253, 231, 227, 255, 253, 232, 227, 255, 253, 232, 227, 255, 253, 232, 227, 255, 253, 232, 227, 255, 253, 232, 227, 255, 253, 232, 228, 255, 253, 232, 228, 255, 253, 233, 228, 255, 253, 233, 228, 255, 253, 233, 228, 255, 254, 237, 232, 255, 254, 238, 233, 255, 254, 238, 233, 255, 254, 238, 233, 255, 254, 238, 233, 255, 254, 238, 233, 255, 254, 238, 233, 255, 254, 238, 233, 255, 254, 238, 233, 255, 254, 238, 233, 255, 254, 239, 234, 255, 254, 239, 234, 255, 254, 239, 234, 255, 254, 239, 234, 255, 254, 239, 234, 255, 254, 239, 234, 255, 254, 239, 234, 255, 254, 239, 234, 255, 254, 239, 234, 255, 254, 239, 234, 255, 254, 240, 235, 255, 254, 240, 235, 255, 254, 240, 235, 255, 254, 240, 235, 255, 254, 240, 235, 255, 254, 240, 235, 255, 254, 240, 235, 255, 254, 240, 235, 255, 254, 240, 235, 255, 254, 240, 235, 255, 254, 240, 236, 255, 254, 241, 236, 255, 254, 241, 236, 255, 254, 241, 236, 255, 254, 241, 236, 255, 254, 241, 236, 255, 254, 241, 236, 255, 254, 241, 236, 255, 254, 241, 236, 255, 254, 241, 236, 255, 254, 241, 236, 255, 254, 241, 236, 255, 254, 241, 236, 255, 254, 241, 237, 255, 254, 242, 237, 255, 254, 242, 237, 255, 254, 242, 237, 255, 254, 242, 237, 255, 254, 242, 237, 255, 254, 242, 237, 255, 254, 242, 237, 255, 254, 242, 237, 255, 254, 242, 237, 255, 254, 242, 237, 255, 254, 242, 237, 255, 254, 242, 237, 255, 254, 242, 237, 255, 254, 242, 238, 255, 254, 242, 238, 255, 254, 242, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 239, 255, 254, 243, 239, 255, 254, 243, 239, 255, 254, 243, 239, 255, 254, 243, 239, 255, 254, 243, 239, 255, 254, 243, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 240, 255, 254, 244, 240, 255, 254, 244, 240, 255, 254, 244, 240, 255, 254, 244, 240, 255, 254, 244, 240, 255, 254, 244, 240, 255, 254, 244, 240, 255, 254, 244, 240, 255, 254, 244, 240, 255, 254, 244, 240, 255, 254, 244, 240, 255, 254, 244, 240, 255, 254, 244, 240, 255, 254, 245, 240, 255, 254, 245, 240, 255, 254, 245, 240, 255, 254, 245, 240, 255, 254, 245, 240, 255, 254, 245, 240, 255, 254, 245, 240, 255, 254, 245, 240, 255, 254, 245, 240, 255, 254, 245, 240, 255, 254, 245, 240, 255, 254, 245, 240, 255, 254, 245, 240, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 245, 241, 255, 254, 246, 241, 255, 254, 246, 241, 255, 254, 246, 241, 255, 254, 246, 241, 255, 254, 246, 241, 255, 254, 246, 241, 255, 254, 246, 241, 255, 254, 246, 241, 255, 254, 246, 241, 255, 254, 246, 241, 255, 254, 246, 241, 255, 254, 246, 241, 255, 254, 246, 241, 255, 254, 246, 241, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 246, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255, 254, 247, 242, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_RdPu_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
