/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/YlGn.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 0, 69, 41, 255, 0, 104, 55, 255, 35, 132, 67, 255, 65, 171, 93, 255, 120, 198, 121, 255, 173, 221, 142, 255, 217, 240, 163, 255, 247, 252, 185, 255, 255, 255, 229, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_YlGn_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 0, 69, 40, 0, 0, 69, 41, 7, 0, 69, 41, 14, 0, 69, 41, 22, 0, 70, 41, 29, 0, 70, 41, 37, 0, 70, 41, 44, 0, 70, 41, 52, 0, 71, 41, 59, 0, 71, 42, 67, 0, 71, 42, 74, 0, 71, 42, 82, 0, 72, 42, 89, 0, 72, 42, 97, 0, 72, 42, 104, 0, 72, 42, 112, 0, 73, 42, 119, 0, 73, 43, 127, 0, 73, 43, 134, 0, 74, 43, 141, 0, 74, 43, 149, 0, 74, 43, 156, 0, 74, 43, 164, 0, 75, 43, 171, 0, 75, 43, 179, 0, 75, 43, 186, 0, 75, 44, 194, 0, 76, 44, 201, 0, 76, 44, 209, 0, 76, 44, 216, 0, 77, 44, 224, 0, 77, 44, 231, 0, 77, 44, 239, 0, 77, 44, 246, 0, 78, 45, 254, 0, 78, 45, 255, 0, 78, 45, 255, 0, 78, 45, 255, 0, 79, 45, 255, 0, 79, 45, 255, 0, 79, 45, 255, 0, 79, 45, 255, 0, 80, 45, 255, 0, 80, 46, 255, 0, 80, 46, 255, 0, 81, 46, 255, 0, 81, 46, 255, 0, 81, 46, 255, 0, 81, 46, 255, 0, 82, 46, 255, 0, 82, 46, 255, 0, 82, 46, 255, 0, 82, 47, 255, 0, 83, 47, 255, 0, 83, 47, 255, 0, 83, 47, 255, 0, 84, 47, 255, 0, 84, 47, 255, 0, 84, 47, 255, 0, 84, 47, 255, 0, 85, 47, 255, 0, 85, 48, 255, 0, 85, 48, 255, 0, 85, 48, 255, 0, 86, 48, 255, 0, 86, 48, 255, 0, 86, 48, 255, 0, 87, 48, 255, 0, 87, 48, 255, 0, 87, 48, 255, 0, 87, 49, 255, 0, 88, 49, 255, 0, 88, 49, 255, 0, 88, 49, 255, 0, 88, 49, 255, 0, 89, 49, 255, 0, 89, 49, 255, 0, 89, 49, 255, 0, 90, 49, 255, 0, 90, 50, 255, 0, 90, 50, 255, 0, 90, 50, 255, 0, 91, 50, 255, 0, 91, 50, 255, 0, 91, 50, 255, 0, 92, 50, 255, 0, 92, 50, 255, 0, 92, 50, 255, 0, 92, 50, 255, 0, 93, 51, 255, 0, 93, 51, 255, 0, 93, 51, 255, 0, 93, 51, 255, 0, 94, 51, 255, 0, 94, 51, 255, 0, 94, 51, 255, 0, 95, 51, 255, 0, 95, 51, 255, 0, 95, 52, 255, 0, 95, 52, 255, 0, 96, 52, 255, 0, 96, 52, 255, 0, 96, 52, 255, 0, 97, 52, 255, 0, 97, 52, 255, 0, 97, 52, 255, 0, 97, 52, 255, 0, 98, 52, 255, 0, 98, 53, 255, 0, 98, 53, 255, 0, 98, 53, 255, 0, 99, 53, 255, 0, 99, 53, 255, 0, 99, 53, 255, 0, 100, 53, 255, 0, 100, 53, 255, 0, 100, 53, 255, 0, 100, 53, 255, 0, 101, 54, 255, 0, 101, 54, 255, 0, 101, 54, 255, 0, 102, 54, 255, 0, 102, 54, 255, 0, 102, 54, 255, 0, 102, 54, 255, 0, 103, 54, 255, 0, 103, 54, 255, 0, 103, 54, 255, 0, 104, 54, 255, 0, 104, 55, 255, 0, 104, 55, 255, 0, 104, 55, 255, 1, 104, 55, 255, 1, 105, 55, 255, 1, 105, 55, 255, 1, 105, 55, 255, 2, 105, 55, 255, 2, 105, 55, 255, 2, 106, 55, 255, 3, 106, 56, 255, 3, 106, 56, 255, 3, 106, 56, 255, 3, 107, 56, 255, 4, 107, 56, 255, 4, 107, 56, 255, 4, 107, 56, 255, 5, 107, 56, 255, 5, 108, 56, 255, 5, 108, 56, 255, 6, 108, 57, 255, 6, 108, 57, 255, 6, 108, 57, 255, 6, 109, 57, 255, 7, 109, 57, 255, 7, 109, 57, 255, 7, 109, 57, 255, 8, 110, 57, 255, 8, 110, 57, 255, 8, 110, 57, 255, 9, 110, 58, 255, 9, 110, 58, 255, 9, 111, 58, 255, 10, 111, 58, 255, 10, 111, 58, 255, 10, 111, 58, 255, 11, 112, 58, 255, 11, 112, 58, 255, 11, 112, 58, 255, 12, 112, 58, 255, 12, 112, 58, 255, 12, 113, 59, 255, 13, 113, 59, 255, 13, 113, 59, 255, 13, 113, 59, 255, 14, 113, 59, 255, 14, 114, 59, 255, 14, 114, 59, 255, 15, 114, 59, 255, 15, 114, 59, 255, 15, 115, 59, 255, 15, 115, 60, 255, 16, 115, 60, 255, 16, 115, 60, 255, 16, 115, 60, 255, 17, 116, 60, 255, 17, 116, 60, 255, 17, 116, 60, 255, 17, 116, 60, 255, 18, 117, 60, 255, 18, 117, 60, 255, 18, 117, 60, 255, 18, 117, 61, 255, 19, 117, 61, 255, 19, 118, 61, 255, 19, 118, 61, 255, 20, 118, 61, 255, 20, 118, 61, 255, 20, 118, 61, 255, 20, 119, 61, 255, 21, 119, 61, 255, 21, 119, 61, 255, 21, 119, 61, 255, 21, 120, 62, 255, 22, 120, 62, 255, 22, 120, 62, 255, 22, 120, 62, 255, 22, 120, 62, 255, 23, 121, 62, 255, 23, 121, 62, 255, 23, 121, 62, 255, 23, 121, 62, 255, 24, 122, 62, 255, 24, 122, 63, 255, 24, 122, 63, 255, 24, 122, 63, 255, 25, 122, 63, 255, 25, 123, 63, 255, 25, 123, 63, 255, 25, 123, 63, 255, 26, 123, 63, 255, 26, 124, 63, 255, 26, 124, 63, 255, 26, 124, 63, 255, 27, 124, 64, 255, 27, 124, 64, 255, 27, 125, 64, 255, 27, 125, 64, 255, 28, 125, 64, 255, 28, 125, 64, 255, 28, 126, 64, 255, 28, 126, 64, 255, 29, 126, 64, 255, 29, 126, 64, 255, 29, 126, 64, 255, 29, 127, 65, 255, 30, 127, 65, 255, 30, 127, 65, 255, 30, 127, 65, 255, 30, 128, 65, 255, 31, 128, 65, 255, 31, 128, 65, 255, 31, 128, 65, 255, 31, 128, 65, 255, 31, 129, 65, 255, 32, 129, 65, 255, 32, 129, 66, 255, 32, 129, 66, 255, 32, 130, 66, 255, 33, 130, 66, 255, 33, 130, 66, 255, 33, 130, 66, 255, 33, 130, 66, 255, 34, 131, 66, 255, 34, 131, 66, 255, 34, 131, 66, 255, 34, 131, 66, 255, 35, 132, 66, 255, 35, 132, 67, 255, 35, 132, 67, 255, 35, 132, 67, 255, 35, 133, 67, 255, 36, 133, 67, 255, 36, 133, 68, 255, 36, 134, 68, 255, 36, 134, 68, 255, 37, 134, 68, 255, 37, 134, 68, 255, 37, 135, 69, 255, 37, 135, 69, 255, 38, 135, 69, 255, 38, 136, 69, 255, 38, 136, 69, 255, 38, 136, 70, 255, 39, 137, 70, 255, 39, 137, 70, 255, 39, 137, 70, 255, 39, 137, 70, 255, 40, 138, 71, 255, 40, 138, 71, 255, 40, 138, 71, 255, 40, 139, 71, 255, 41, 139, 71, 255, 41, 139, 72, 255, 41, 140, 72, 255, 41, 140, 72, 255, 41, 140, 72, 255, 42, 140, 72, 255, 42, 141, 73, 255, 42, 141, 73, 255, 42, 141, 73, 255, 43, 142, 73, 255, 43, 142, 73, 255, 43, 142, 74, 255, 43, 143, 74, 255, 44, 143, 74, 255, 44, 143, 74, 255, 44, 143, 75, 255, 44, 144, 75, 255, 45, 144, 75, 255, 45, 144, 75, 255, 45, 145, 75, 255, 45, 145, 76, 255, 45, 145, 76, 255, 46, 146, 76, 255, 46, 146, 76, 255, 46, 146, 76, 255, 46, 147, 77, 255, 47, 147, 77, 255, 47, 147, 77, 255, 47, 147, 77, 255, 47, 148, 77, 255, 48, 148, 78, 255, 48, 148, 78, 255, 48, 149, 78, 255, 48, 149, 78, 255, 49, 149, 78, 255, 49, 150, 79, 255, 49, 150, 79, 255, 49, 150, 79, 255, 49, 150, 79, 255, 50, 151, 79, 255, 50, 151, 80, 255, 50, 151, 80, 255, 50, 152, 80, 255, 51, 152, 80, 255, 51, 152, 80, 255, 51, 153, 81, 255, 51, 153, 81, 255, 52, 153, 81, 255, 52, 154, 81, 255, 52, 154, 81, 255, 52, 154, 82, 255, 52, 154, 82, 255, 53, 155, 82, 255, 53, 155, 82, 255, 53, 155, 82, 255, 53, 156, 83, 255, 54, 156, 83, 255, 54, 156, 83, 255, 54, 157, 83, 255, 54, 157, 83, 255, 55, 157, 84, 255, 55, 158, 84, 255, 55, 158, 84, 255, 55, 158, 84, 255, 55, 158, 84, 255, 56, 159, 85, 255, 56, 159, 85, 255, 56, 159, 85, 255, 56, 160, 85, 255, 57, 160, 85, 255, 57, 160, 86, 255, 57, 161, 86, 255, 57, 161, 86, 255, 58, 161, 86, 255, 58, 162, 87, 255, 58, 162, 87, 255, 58, 162, 87, 255, 58, 162, 87, 255, 59, 163, 87, 255, 59, 163, 88, 255, 59, 163, 88, 255, 59, 164, 88, 255, 60, 164, 88, 255, 60, 164, 88, 255, 60, 165, 89, 255, 60, 165, 89, 255, 61, 165, 89, 255, 61, 166, 89, 255, 61, 166, 89, 255, 61, 166, 90, 255, 61, 166, 90, 255, 62, 167, 90, 255, 62, 167, 90, 255, 62, 167, 90, 255, 62, 168, 91, 255, 63, 168, 91, 255, 63, 168, 91, 255, 63, 169, 91, 255, 63, 169, 91, 255, 64, 169, 92, 255, 64, 170, 92, 255, 64, 170, 92, 255, 64, 170, 92, 255, 65, 171, 92, 255, 65, 171, 93, 255, 66, 171, 93, 255, 66, 171, 93, 255, 67, 171, 93, 255, 67, 172, 94, 255, 68, 172, 94, 255, 68, 172, 94, 255, 69, 172, 94, 255, 69, 172, 94, 255, 70, 173, 95, 255, 70, 173, 95, 255, 70, 173, 95, 255, 71, 173, 95, 255, 71, 173, 95, 255, 72, 174, 96, 255, 72, 174, 96, 255, 73, 174, 96, 255, 73, 174, 96, 255, 74, 174, 96, 255, 74, 175, 97, 255, 75, 175, 97, 255, 75, 175, 97, 255, 76, 175, 97, 255, 76, 176, 98, 255, 77, 176, 98, 255, 77, 176, 98, 255, 78, 176, 98, 255, 78, 176, 98, 255, 78, 177, 99, 255, 79, 177, 99, 255, 79, 177, 99, 255, 80, 177, 99, 255, 80, 177, 99, 255, 81, 178, 100, 255, 81, 178, 100, 255, 82, 178, 100, 255, 82, 178, 100, 255, 83, 178, 100, 255, 83, 179, 101, 255, 83, 179, 101, 255, 84, 179, 101, 255, 84, 179, 101, 255, 85, 180, 102, 255, 85, 180, 102, 255, 86, 180, 102, 255, 86, 180, 102, 255, 87, 180, 102, 255, 87, 181, 103, 255, 87, 181, 103, 255, 88, 181, 103, 255, 88, 181, 103, 255, 89, 181, 103, 255, 89, 182, 104, 255, 90, 182, 104, 255, 90, 182, 104, 255, 90, 182, 104, 255, 91, 182, 105, 255, 91, 183, 105, 255, 92, 183, 105, 255, 92, 183, 105, 255, 93, 183, 105, 255, 93, 184, 106, 255, 93, 184, 106, 255, 94, 184, 106, 255, 94, 184, 106, 255, 95, 184, 107, 255, 95, 185, 107, 255, 96, 185, 107, 255, 96, 185, 107, 255, 96, 185, 107, 255, 97, 185, 108, 255, 97, 186, 108, 255, 98, 186, 108, 255, 98, 186, 108, 255, 98, 186, 109, 255, 99, 186, 109, 255, 99, 187, 109, 255, 100, 187, 109, 255, 100, 187, 109, 255, 100, 187, 110, 255, 101, 188, 110, 255, 101, 188, 110, 255, 102, 188, 110, 255, 102, 188, 111, 255, 103, 188, 111, 255, 103, 189, 111, 255, 103, 189, 111, 255, 104, 189, 111, 255, 104, 189, 112, 255, 105, 189, 112, 255, 105, 190, 112, 255, 105, 190, 112, 255, 106, 190, 113, 255, 106, 190, 113, 255, 107, 191, 113, 255, 107, 191, 113, 255, 107, 191, 113, 255, 108, 191, 114, 255, 108, 191, 114, 255, 109, 192, 114, 255, 109, 192, 114, 255, 109, 192, 115, 255, 110, 192, 115, 255, 110, 192, 115, 255, 111, 193, 115, 255, 111, 193, 115, 255, 111, 193, 116, 255, 112, 193, 116, 255, 112, 193, 116, 255, 112, 194, 116, 255, 113, 194, 117, 255, 113, 194, 117, 255, 114, 194, 117, 255, 114, 195, 117, 255, 114, 195, 118, 255, 115, 195, 118, 255, 115, 195, 118, 255, 116, 195, 118, 255, 116, 196, 118, 255, 116, 196, 119, 255, 117, 196, 119, 255, 117, 196, 119, 255, 118, 196, 119, 255, 118, 197, 120, 255, 118, 197, 120, 255, 119, 197, 120, 255, 119, 197, 120, 255, 119, 198, 120, 255, 120, 198, 121, 255, 120, 198, 121, 255, 121, 198, 121, 255, 121, 198, 121, 255, 122, 198, 121, 255, 122, 199, 121, 255, 123, 199, 121, 255, 123, 199, 122, 255, 123, 199, 122, 255, 124, 199, 122, 255, 124, 199, 122, 255, 125, 200, 122, 255, 125, 200, 122, 255, 126, 200, 123, 255, 126, 200, 123, 255, 127, 200, 123, 255, 127, 201, 123, 255, 127, 201, 123, 255, 128, 201, 123, 255, 128, 201, 123, 255, 129, 201, 124, 255, 129, 201, 124, 255, 130, 202, 124, 255, 130, 202, 124, 255, 130, 202, 124, 255, 131, 202, 124, 255, 131, 202, 124, 255, 132, 203, 125, 255, 132, 203, 125, 255, 133, 203, 125, 255, 133, 203, 125, 255, 133, 203, 125, 255, 134, 203, 125, 255, 134, 204, 126, 255, 135, 204, 126, 255, 135, 204, 126, 255, 136, 204, 126, 255, 136, 204, 126, 255, 136, 205, 126, 255, 137, 205, 126, 255, 137, 205, 127, 255, 138, 205, 127, 255, 138, 205, 127, 255, 139, 205, 127, 255, 139, 206, 127, 255, 139, 206, 127, 255, 140, 206, 128, 255, 140, 206, 128, 255, 141, 206, 128, 255, 141, 206, 128, 255, 141, 207, 128, 255, 142, 207, 128, 255, 142, 207, 128, 255, 143, 207, 129, 255, 143, 207, 129, 255, 144, 208, 129, 255, 144, 208, 129, 255, 144, 208, 129, 255, 145, 208, 129, 255, 145, 208, 130, 255, 146, 208, 130, 255, 146, 209, 130, 255, 146, 209, 130, 255, 147, 209, 130, 255, 147, 209, 130, 255, 148, 209, 131, 255, 148, 210, 131, 255, 149, 210, 131, 255, 149, 210, 131, 255, 149, 210, 131, 255, 150, 210, 131, 255, 150, 210, 132, 255, 151, 211, 132, 255, 151, 211, 132, 255, 151, 211, 132, 255, 152, 211, 132, 255, 152, 211, 132, 255, 153, 212, 133, 255, 153, 212, 133, 255, 153, 212, 133, 255, 154, 212, 133, 255, 154, 212, 133, 255, 155, 212, 133, 255, 155, 213, 134, 255, 155, 213, 134, 255, 156, 213, 134, 255, 156, 213, 134, 255, 157, 213, 134, 255, 157, 213, 134, 255, 157, 214, 135, 255, 158, 214, 135, 255, 158, 214, 135, 255, 159, 214, 135, 255, 159, 214, 135, 255, 159, 215, 136, 255, 160, 215, 136, 255, 160, 215, 136, 255, 161, 215, 136, 255, 161, 215, 136, 255, 161, 215, 136, 255, 162, 216, 137, 255, 162, 216, 137, 255, 163, 216, 137, 255, 163, 216, 137, 255, 163, 216, 137, 255, 164, 217, 137, 255, 164, 217, 138, 255, 165, 217, 138, 255, 165, 217, 138, 255, 165, 217, 138, 255, 166, 217, 138, 255, 166, 218, 139, 255, 167, 218, 139, 255, 167, 218, 139, 255, 167, 218, 139, 255, 168, 218, 139, 255, 168, 219, 139, 255, 169, 219, 140, 255, 169, 219, 140, 255, 169, 219, 140, 255, 170, 219, 140, 255, 170, 219, 140, 255, 171, 220, 141, 255, 171, 220, 141, 255, 171, 220, 141, 255, 172, 220, 141, 255, 172, 220, 141, 255, 172, 221, 141, 255, 173, 221, 142, 255, 173, 221, 142, 255, 174, 221, 142, 255, 174, 221, 142, 255, 174, 221, 142, 255, 175, 221, 142, 255, 175, 222, 143, 255, 175, 222, 143, 255, 176, 222, 143, 255, 176, 222, 143, 255, 176, 222, 143, 255, 177, 222, 143, 255, 177, 222, 143, 255, 178, 223, 144, 255, 178, 223, 144, 255, 178, 223, 144, 255, 179, 223, 144, 255, 179, 223, 144, 255, 179, 223, 144, 255, 180, 223, 144, 255, 180, 224, 145, 255, 180, 224, 145, 255, 181, 224, 145, 255, 181, 224, 145, 255, 181, 224, 145, 255, 182, 224, 145, 255, 182, 224, 145, 255, 182, 225, 146, 255, 183, 225, 146, 255, 183, 225, 146, 255, 184, 225, 146, 255, 184, 225, 146, 255, 184, 225, 146, 255, 185, 226, 147, 255, 185, 226, 147, 255, 185, 226, 147, 255, 186, 226, 147, 255, 186, 226, 147, 255, 186, 226, 147, 255, 187, 226, 148, 255, 187, 227, 148, 255, 187, 227, 148, 255, 188, 227, 148, 255, 188, 227, 148, 255, 188, 227, 148, 255, 189, 227, 148, 255, 189, 227, 149, 255, 189, 228, 149, 255, 190, 228, 149, 255, 190, 228, 149, 255, 190, 228, 149, 255, 191, 228, 149, 255, 191, 228, 150, 255, 192, 228, 150, 255, 192, 229, 150, 255, 192, 229, 150, 255, 193, 229, 150, 255, 193, 229, 150, 255, 193, 229, 151, 255, 194, 229, 151, 255, 194, 230, 151, 255, 194, 230, 151, 255, 195, 230, 151, 255, 195, 230, 151, 255, 195, 230, 152, 255, 196, 230, 152, 255, 196, 230, 152, 255, 196, 231, 152, 255, 197, 231, 152, 255, 197, 231, 152, 255, 197, 231, 153, 255, 198, 231, 153, 255, 198, 231, 153, 255, 198, 231, 153, 255, 199, 232, 153, 255, 199, 232, 153, 255, 199, 232, 154, 255, 200, 232, 154, 255, 200, 232, 154, 255, 200, 232, 154, 255, 201, 233, 154, 255, 201, 233, 154, 255, 201, 233, 155, 255, 202, 233, 155, 255, 202, 233, 155, 255, 202, 233, 155, 255, 203, 233, 155, 255, 203, 234, 155, 255, 203, 234, 156, 255, 204, 234, 156, 255, 204, 234, 156, 255, 204, 234, 156, 255, 205, 234, 156, 255, 205, 234, 156, 255, 206, 235, 157, 255, 206, 235, 157, 255, 206, 235, 157, 255, 207, 235, 157, 255, 207, 235, 157, 255, 207, 235, 157, 255, 208, 235, 158, 255, 208, 236, 158, 255, 208, 236, 158, 255, 209, 236, 158, 255, 209, 236, 158, 255, 209, 236, 159, 255, 210, 236, 159, 255, 210, 237, 159, 255, 210, 237, 159, 255, 211, 237, 159, 255, 211, 237, 159, 255, 211, 237, 160, 255, 212, 237, 160, 255, 212, 237, 160, 255, 212, 238, 160, 255, 213, 238, 160, 255, 213, 238, 160, 255, 213, 238, 161, 255, 214, 238, 161, 255, 214, 238, 161, 255, 214, 238, 161, 255, 215, 239, 161, 255, 215, 239, 162, 255, 215, 239, 162, 255, 216, 239, 162, 255, 216, 239, 162, 255, 216, 239, 162, 255, 216, 240, 162, 255, 217, 240, 163, 255, 217, 240, 163, 255, 217, 240, 163, 255, 217, 240, 163, 255, 218, 240, 163, 255, 218, 240, 163, 255, 218, 240, 164, 255, 218, 240, 164, 255, 219, 240, 164, 255, 219, 240, 164, 255, 219, 241, 164, 255, 219, 241, 164, 255, 220, 241, 165, 255, 220, 241, 165, 255, 220, 241, 165, 255, 220, 241, 165, 255, 221, 241, 165, 255, 221, 241, 165, 255, 221, 241, 166, 255, 221, 241, 166, 255, 222, 241, 166, 255, 222, 242, 166, 255, 222, 242, 166, 255, 222, 242, 166, 255, 223, 242, 167, 255, 223, 242, 167, 255, 223, 242, 167, 255, 223, 242, 167, 255, 224, 242, 167, 255, 224, 242, 167, 255, 224, 242, 167, 255, 224, 242, 168, 255, 225, 243, 168, 255, 225, 243, 168, 255, 225, 243, 168, 255, 225, 243, 168, 255, 226, 243, 168, 255, 226, 243, 169, 255, 226, 243, 169, 255, 226, 243, 169, 255, 227, 243, 169, 255, 227, 243, 169, 255, 227, 243, 169, 255, 227, 244, 170, 255, 227, 244, 170, 255, 228, 244, 170, 255, 228, 244, 170, 255, 228, 244, 170, 255, 228, 244, 171, 255, 229, 244, 171, 255, 229, 244, 171, 255, 229, 244, 171, 255, 229, 244, 171, 255, 230, 244, 171, 255, 230, 245, 172, 255, 230, 245, 172, 255, 230, 245, 172, 255, 231, 245, 172, 255, 231, 245, 172, 255, 231, 245, 172, 255, 231, 245, 173, 255, 232, 245, 173, 255, 232, 245, 173, 255, 232, 245, 173, 255, 232, 246, 173, 255, 232, 246, 173, 255, 233, 246, 174, 255, 233, 246, 174, 255, 233, 246, 174, 255, 233, 246, 174, 255, 234, 246, 174, 255, 234, 246, 174, 255, 234, 246, 175, 255, 234, 246, 175, 255, 235, 246, 175, 255, 235, 247, 175, 255, 235, 247, 175, 255, 235, 247, 175, 255, 235, 247, 176, 255, 236, 247, 176, 255, 236, 247, 176, 255, 236, 247, 176, 255, 236, 247, 176, 255, 237, 247, 177, 255, 237, 247, 177, 255, 237, 247, 177, 255, 237, 248, 177, 255, 238, 248, 177, 255, 238, 248, 177, 255, 238, 248, 178, 255, 238, 248, 178, 255, 238, 248, 178, 255, 239, 248, 178, 255, 239, 248, 178, 255, 239, 248, 178, 255, 239, 248, 179, 255, 240, 249, 179, 255, 240, 249, 179, 255, 240, 249, 179, 255, 240, 249, 179, 255, 241, 249, 180, 255, 241, 249, 180, 255, 241, 249, 180, 255, 241, 249, 180, 255, 241, 249, 180, 255, 242, 249, 180, 255, 242, 249, 181, 255, 242, 250, 181, 255, 242, 250, 181, 255, 243, 250, 181, 255, 243, 250, 181, 255, 243, 250, 182, 255, 243, 250, 182, 255, 243, 250, 182, 255, 244, 250, 182, 255, 244, 250, 182, 255, 244, 250, 182, 255, 244, 251, 183, 255, 245, 251, 183, 255, 245, 251, 183, 255, 245, 251, 183, 255, 245, 251, 183, 255, 245, 251, 184, 255, 246, 251, 184, 255, 246, 251, 184, 255, 246, 251, 184, 255, 246, 251, 184, 255, 246, 252, 184, 255, 247, 252, 185, 255, 247, 252, 185, 255, 247, 252, 186, 255, 247, 252, 186, 255, 247, 252, 186, 255, 247, 252, 187, 255, 247, 252, 187, 255, 247, 252, 187, 255, 247, 252, 188, 255, 247, 252, 188, 255, 247, 252, 188, 255, 247, 252, 189, 255, 248, 252, 189, 255, 248, 252, 189, 255, 248, 252, 190, 255, 248, 252, 190, 255, 248, 252, 190, 255, 248, 252, 191, 255, 248, 252, 191, 255, 248, 252, 191, 255, 248, 252, 192, 255, 248, 252, 192, 255, 248, 252, 192, 255, 248, 252, 193, 255, 248, 252, 193, 255, 249, 252, 193, 255, 249, 252, 194, 255, 249, 252, 194, 255, 249, 252, 194, 255, 249, 252, 195, 255, 249, 252, 195, 255, 249, 252, 195, 255, 249, 252, 196, 255, 249, 252, 196, 255, 249, 252, 197, 255, 249, 252, 197, 255, 249, 252, 197, 255, 249, 252, 198, 255, 249, 252, 198, 255, 250, 252, 198, 255, 250, 252, 199, 255, 250, 252, 199, 255, 250, 252, 199, 255, 250, 252, 200, 255, 250, 252, 200, 255, 250, 252, 200, 255, 250, 253, 201, 255, 250, 253, 201, 255, 250, 253, 201, 255, 250, 253, 202, 255, 250, 253, 202, 255, 250, 253, 202, 255, 250, 253, 203, 255, 250, 253, 203, 255, 251, 253, 203, 255, 251, 253, 204, 255, 251, 253, 204, 255, 251, 253, 204, 255, 251, 253, 205, 255, 251, 253, 205, 255, 251, 253, 205, 255, 251, 253, 206, 255, 251, 253, 206, 255, 251, 253, 206, 255, 251, 253, 207, 255, 251, 253, 207, 255, 251, 253, 207, 255, 251, 253, 208, 255, 251, 253, 208, 255, 252, 253, 209, 255, 252, 253, 209, 255, 252, 253, 209, 255, 252, 253, 210, 255, 252, 253, 210, 255, 252, 253, 210, 255, 252, 253, 211, 255, 252, 253, 211, 255, 252, 253, 211, 255, 252, 253, 212, 255, 252, 253, 212, 255, 252, 253, 212, 255, 252, 253, 213, 255, 252, 253, 213, 255, 252, 253, 213, 255, 252, 253, 214, 255, 252, 253, 214, 255, 252, 253, 214, 255, 253, 253, 215, 255, 253, 254, 215, 255, 253, 254, 215, 255, 253, 254, 216, 255, 253, 254, 216, 255, 253, 254, 216, 255, 253, 254, 217, 255, 253, 254, 217, 255, 253, 254, 217, 255, 253, 254, 218, 255, 253, 254, 218, 255, 253, 254, 218, 255, 253, 254, 219, 255, 253, 254, 219, 255, 253, 254, 220, 255, 253, 254, 220, 255, 253, 254, 220, 255, 253, 254, 221, 255, 253, 254, 221, 255, 254, 254, 221, 255, 254, 254, 222, 255, 254, 254, 222, 255, 254, 254, 222, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 228, 255, 254, 254, 228, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_YlGn_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 0, 69, 40, 0, 0, 69, 41, 7, 0, 69, 41, 14, 0, 69, 41, 22, 0, 69, 41, 29, 0, 70, 41, 37, 0, 70, 41, 44, 0, 70, 41, 52, 0, 70, 41, 59, 0, 70, 41, 67, 0, 71, 41, 74, 0, 71, 42, 82, 0, 71, 42, 89, 0, 71, 42, 97, 0, 71, 42, 104, 0, 72, 42, 112, 0, 72, 42, 119, 0, 72, 42, 127, 0, 72, 42, 134, 0, 73, 42, 141, 0, 73, 42, 149, 0, 73, 43, 156, 0, 73, 43, 164, 0, 73, 43, 171, 0, 74, 43, 179, 0, 74, 43, 186, 0, 74, 43, 194, 0, 74, 43, 201, 0, 74, 43, 209, 0, 75, 43, 216, 0, 75, 43, 224, 0, 75, 43, 231, 0, 75, 44, 239, 0, 76, 44, 246, 0, 76, 44, 254, 0, 76, 44, 255, 0, 76, 44, 255, 0, 76, 44, 255, 0, 77, 44, 255, 0, 77, 44, 255, 0, 77, 44, 255, 0, 77, 44, 255, 0, 78, 44, 255, 0, 78, 45, 255, 0, 78, 45, 255, 0, 78, 45, 255, 0, 78, 45, 255, 0, 79, 45, 255, 0, 79, 45, 255, 0, 79, 45, 255, 0, 79, 45, 255, 0, 79, 45, 255, 0, 80, 45, 255, 0, 80, 45, 255, 0, 80, 46, 255, 0, 80, 46, 255, 0, 81, 46, 255, 0, 81, 46, 255, 0, 81, 46, 255, 0, 81, 46, 255, 0, 81, 46, 255, 0, 82, 46, 255, 0, 82, 46, 255, 0, 82, 46, 255, 0, 89, 49, 255, 0, 90, 49, 255, 0, 90, 49, 255, 0, 90, 49, 255, 0, 90, 50, 255, 0, 90, 50, 255, 0, 91, 50, 255, 0, 91, 50, 255, 0, 91, 50, 255, 0, 91, 50, 255, 0, 91, 50, 255, 0, 92, 50, 255, 0, 92, 50, 255, 0, 92, 50, 255, 0, 92, 50, 255, 0, 93, 51, 255, 0, 93, 51, 255, 0, 93, 51, 255, 0, 93, 51, 255, 0, 93, 51, 255, 0, 94, 51, 255, 0, 94, 51, 255, 0, 94, 51, 255, 0, 94, 51, 255, 0, 95, 51, 255, 0, 95, 51, 255, 0, 95, 51, 255, 0, 95, 52, 255, 0, 95, 52, 255, 0, 96, 52, 255, 0, 96, 52, 255, 0, 96, 52, 255, 0, 96, 52, 255, 0, 97, 52, 255, 0, 97, 52, 255, 0, 97, 52, 255, 0, 97, 52, 255, 0, 97, 52, 255, 0, 98, 52, 255, 0, 98, 53, 255, 0, 98, 53, 255, 0, 98, 53, 255, 0, 99, 53, 255, 0, 99, 53, 255, 0, 99, 53, 255, 0, 99, 53, 255, 0, 99, 53, 255, 0, 100, 53, 255, 0, 100, 53, 255, 0, 100, 53, 255, 0, 100, 53, 255, 0, 101, 53, 255, 0, 101, 54, 255, 0, 101, 54, 255, 0, 101, 54, 255, 0, 101, 54, 255, 0, 102, 54, 255, 0, 102, 54, 255, 0, 102, 54, 255, 0, 102, 54, 255, 0, 103, 54, 255, 0, 103, 54, 255, 0, 103, 54, 255, 0, 103, 54, 255, 0, 104, 54, 255, 0, 104, 55, 255, 0, 104, 55, 255, 0, 104, 55, 255, 0, 104, 55, 255, 1, 104, 55, 255, 1, 105, 55, 255, 1, 105, 55, 255, 1, 105, 55, 255, 1, 105, 55, 255, 2, 105, 55, 255, 2, 105, 55, 255, 2, 106, 55, 255, 2, 106, 56, 255, 3, 106, 56, 255, 3, 106, 56, 255, 3, 106, 56, 255, 3, 106, 56, 255, 4, 107, 56, 255, 4, 107, 56, 255, 4, 107, 56, 255, 4, 107, 56, 255, 5, 107, 56, 255, 5, 107, 56, 255, 5, 108, 56, 255, 5, 108, 56, 255, 6, 108, 57, 255, 6, 108, 57, 255, 6, 108, 57, 255, 6, 109, 57, 255, 7, 109, 57, 255, 7, 109, 57, 255, 7, 109, 57, 255, 7, 109, 57, 255, 8, 109, 57, 255, 8, 110, 57, 255, 8, 110, 57, 255, 9, 110, 57, 255, 9, 110, 57, 255, 9, 110, 58, 255, 9, 110, 58, 255, 10, 111, 58, 255, 10, 111, 58, 255, 10, 111, 58, 255, 10, 111, 58, 255, 11, 111, 58, 255, 11, 111, 58, 255, 11, 112, 58, 255, 11, 112, 58, 255, 12, 112, 58, 255, 12, 112, 58, 255, 12, 112, 58, 255, 12, 113, 59, 255, 12, 113, 59, 255, 13, 113, 59, 255, 13, 113, 59, 255, 13, 113, 59, 255, 13, 113, 59, 255, 14, 114, 59, 255, 14, 114, 59, 255, 14, 114, 59, 255, 14, 114, 59, 255, 14, 114, 59, 255, 15, 114, 59, 255, 22, 120, 62, 255, 22, 120, 62, 255, 22, 121, 62, 255, 23, 121, 62, 255, 23, 121, 62, 255, 23, 121, 62, 255, 23, 121, 62, 255, 23, 121, 62, 255, 24, 122, 62, 255, 24, 122, 62, 255, 24, 122, 63, 255, 24, 122, 63, 255, 24, 122, 63, 255, 25, 122, 63, 255, 25, 123, 63, 255, 25, 123, 63, 255, 25, 123, 63, 255, 25, 123, 63, 255, 26, 123, 63, 255, 26, 124, 63, 255, 26, 124, 63, 255, 26, 124, 63, 255, 26, 124, 63, 255, 27, 124, 64, 255, 27, 124, 64, 255, 27, 125, 64, 255, 27, 125, 64, 255, 27, 125, 64, 255, 28, 125, 64, 255, 28, 125, 64, 255, 28, 125, 64, 255, 28, 126, 64, 255, 28, 126, 64, 255, 29, 126, 64, 255, 29, 126, 64, 255, 29, 126, 64, 255, 29, 127, 64, 255, 29, 127, 65, 255, 30, 127, 65, 255, 30, 127, 65, 255, 30, 127, 65, 255, 30, 127, 65, 255, 30, 128, 65, 255, 31, 128, 65, 255, 31, 128, 65, 255, 31, 128, 65, 255, 31, 128, 65, 255, 31, 128, 65, 255, 31, 129, 65, 255, 32, 129, 65, 255, 32, 129, 65, 255, 32, 129, 66, 255, 32, 129, 66, 255, 32, 130, 66, 255, 33, 130, 66, 255, 33, 130, 66, 255, 33, 130, 66, 255, 33, 130, 66, 255, 33, 130, 66, 255, 34, 131, 66, 255, 34, 131, 66, 255, 34, 131, 66, 255, 34, 131, 66, 255, 34, 131, 66, 255, 35, 132, 66, 255, 35, 132, 67, 255, 35, 132, 67, 255, 35, 132, 67, 255, 35, 132, 67, 255, 35, 133, 67, 255, 36, 133, 67, 255, 36, 133, 68, 255, 36, 133, 68, 255, 36, 134, 68, 255, 36, 134, 68, 255, 37, 134, 68, 255, 37, 134, 68, 255, 37, 135, 69, 255, 37, 135, 69, 255, 37, 135, 69, 255, 38, 135, 69, 255, 38, 136, 69, 255, 38, 136, 69, 255, 38, 136, 70, 255, 38, 136, 70, 255, 39, 137, 70, 255, 39, 137, 70, 255, 39, 137, 70, 255, 39, 137, 70, 255, 39, 137, 70, 255, 39, 138, 71, 255, 40, 138, 71, 255, 40, 138, 71, 255, 40, 138, 71, 255, 40, 139, 71, 255, 40, 139, 71, 255, 41, 139, 72, 255, 41, 139, 72, 255, 41, 140, 72, 255, 41, 140, 72, 255, 41, 140, 72, 255, 42, 140, 72, 255, 42, 141, 73, 255, 42, 141, 73, 255, 42, 141, 73, 255, 42, 141, 73, 255, 43, 142, 73, 255, 43, 142, 73, 255, 43, 142, 74, 255, 43, 142, 74, 255, 43, 143, 74, 255, 43, 143, 74, 255, 44, 143, 74, 255, 44, 143, 74, 255, 44, 144, 75, 255, 44, 144, 75, 255, 44, 144, 75, 255, 45, 144, 75, 255, 45, 144, 75, 255, 45, 145, 75, 255, 45, 145, 75, 255, 45, 145, 76, 255, 46, 145, 76, 255, 46, 146, 76, 255, 46, 146, 76, 255, 46, 146, 76, 255, 46, 146, 76, 255, 46, 147, 77, 255, 53, 155, 82, 255, 53, 155, 82, 255, 53, 155, 82, 255, 53, 155, 82, 255, 53, 156, 83, 255, 54, 156, 83, 255, 54, 156, 83, 255, 54, 156, 83, 255, 54, 157, 83, 255, 54, 157, 83, 255, 54, 157, 84, 255, 55, 157, 84, 255, 55, 158, 84, 255, 55, 158, 84, 255, 55, 158, 84, 255, 55, 158, 84, 255, 56, 159, 85, 255, 56, 159, 85, 255, 56, 159, 85, 255, 56, 159, 85, 255, 56, 160, 85, 255, 57, 160, 85, 255, 57, 160, 86, 255, 57, 160, 86, 255, 57, 161, 86, 255, 57, 161, 86, 255, 57, 161, 86, 255, 58, 161, 86, 255, 58, 162, 87, 255, 58, 162, 87, 255, 58, 162, 87, 255, 58, 162, 87, 255, 59, 163, 87, 255, 59, 163, 87, 255, 59, 163, 88, 255, 59, 163, 88, 255, 59, 164, 88, 255, 60, 164, 88, 255, 60, 164, 88, 255, 60, 164, 88, 255, 60, 165, 89, 255, 60, 165, 89, 255, 60, 165, 89, 255, 61, 165, 89, 255, 61, 166, 89, 255, 61, 166, 89, 255, 61, 166, 90, 255, 61, 166, 90, 255, 62, 167, 90, 255, 62, 167, 90, 255, 62, 167, 90, 255, 62, 167, 90, 255, 62, 168, 91, 255, 62, 168, 91, 255, 63, 168, 91, 255, 63, 168, 91, 255, 63, 169, 91, 255, 63, 169, 91, 255, 63, 169, 92, 255, 64, 169, 92, 255, 64, 170, 92, 255, 64, 170, 92, 255, 64, 170, 92, 255, 64, 170, 92, 255, 65, 171, 92, 255, 65, 171, 93, 255, 65, 171, 93, 255, 66, 171, 93, 255, 66, 171, 93, 255, 67, 171, 93, 255, 67, 172, 93, 255, 67, 172, 94, 255, 68, 172, 94, 255, 68, 172, 94, 255, 69, 172, 94, 255, 69, 172, 94, 255, 69, 173, 94, 255, 70, 173, 95, 255, 70, 173, 95, 255, 70, 173, 95, 255, 71, 173, 95, 255, 71, 173, 95, 255, 72, 174, 95, 255, 72, 174, 96, 255, 72, 174, 96, 255, 73, 174, 96, 255, 73, 174, 96, 255, 73, 174, 96, 255, 74, 175, 97, 255, 74, 175, 97, 255, 75, 175, 97, 255, 75, 175, 97, 255, 75, 175, 97, 255, 76, 175, 97, 255, 76, 176, 98, 255, 76, 176, 98, 255, 77, 176, 98, 255, 77, 176, 98, 255, 78, 176, 98, 255, 78, 176, 98, 255, 78, 177, 99, 255, 79, 177, 99, 255, 79, 177, 99, 255, 79, 177, 99, 255, 80, 177, 99, 255, 80, 177, 99, 255, 80, 178, 100, 255, 81, 178, 100, 255, 81, 178, 100, 255, 81, 178, 100, 255, 82, 178, 100, 255, 82, 178, 100, 255, 82, 179, 101, 255, 83, 179, 101, 255, 83, 179, 101, 255, 84, 179, 101, 255, 84, 179, 101, 255, 84, 179, 101, 255, 85, 180, 102, 255, 85, 180, 102, 255, 85, 180, 102, 255, 86, 180, 102, 255, 86, 180, 102, 255, 86, 180, 103, 255, 87, 181, 103, 255, 87, 181, 103, 255, 87, 181, 103, 255, 88, 181, 103, 255, 99, 187, 109, 255, 99, 187, 109, 255, 100, 187, 109, 255, 100, 187, 110, 255, 100, 187, 110, 255, 101, 188, 110, 255, 101, 188, 110, 255, 101, 188, 110, 255, 102, 188, 110, 255, 102, 188, 111, 255, 102, 188, 111, 255, 103, 189, 111, 255, 103, 189, 111, 255, 103, 189, 111, 255, 104, 189, 111, 255, 104, 189, 112, 255, 104, 189, 112, 255, 105, 190, 112, 255, 105, 190, 112, 255, 105, 190, 112, 255, 106, 190, 113, 255, 106, 190, 113, 255, 106, 190, 113, 255, 107, 191, 113, 255, 107, 191, 113, 255, 107, 191, 113, 255, 108, 191, 114, 255, 108, 191, 114, 255, 108, 191, 114, 255, 108, 192, 114, 255, 109, 192, 114, 255, 109, 192, 114, 255, 109, 192, 115, 255, 110, 192, 115, 255, 110, 192, 115, 255, 110, 193, 115, 255, 111, 193, 115, 255, 111, 193, 116, 255, 111, 193, 116, 255, 112, 193, 116, 255, 112, 193, 116, 255, 112, 194, 116, 255, 113, 194, 116, 255, 113, 194, 117, 255, 113, 194, 117, 255, 114, 194, 117, 255, 114, 194, 117, 255, 114, 195, 117, 255, 115, 195, 118, 255, 115, 195, 118, 255, 115, 195, 118, 255, 115, 195, 118, 255, 116, 195, 118, 255, 116, 196, 118, 255, 116, 196, 119, 255, 117, 196, 119, 255, 117, 196, 119, 255, 117, 196, 119, 255, 118, 196, 119, 255, 118, 197, 120, 255, 118, 197, 120, 255, 119, 197, 120, 255, 119, 197, 120, 255, 119, 197, 120, 255, 119, 198, 120, 255, 120, 198, 121, 255, 120, 198, 121, 255, 121, 198, 121, 255, 121, 198, 121, 255, 121, 198, 121, 255, 122, 198, 121, 255, 122, 199, 121, 255, 122, 199, 121, 255, 123, 199, 122, 255, 123, 199, 122, 255, 123, 199, 122, 255, 124, 199, 122, 255, 124, 199, 122, 255, 124, 200, 122, 255, 125, 200, 122, 255, 125, 200, 122, 255, 125, 200, 122, 255, 126, 200, 123, 255, 126, 200, 123, 255, 127, 200, 123, 255, 127, 201, 123, 255, 127, 201, 123, 255, 128, 201, 123, 255, 128, 201, 123, 255, 128, 201, 123, 255, 129, 201, 124, 255, 129, 201, 124, 255, 129, 202, 124, 255, 130, 202, 124, 255, 130, 202, 124, 255, 130, 202, 124, 255, 131, 202, 124, 255, 131, 202, 124, 255, 131, 202, 125, 255, 132, 203, 125, 255, 132, 203, 125, 255, 132, 203, 125, 255, 133, 203, 125, 255, 133, 203, 125, 255, 133, 203, 125, 255, 134, 203, 125, 255, 134, 204, 126, 255, 134, 204, 126, 255, 135, 204, 126, 255, 135, 204, 126, 255, 135, 204, 126, 255, 136, 204, 126, 255, 136, 204, 126, 255, 136, 205, 126, 255, 137, 205, 127, 255, 137, 205, 127, 255, 137, 205, 127, 255, 138, 205, 127, 255, 138, 205, 127, 255, 138, 205, 127, 255, 139, 206, 127, 255, 139, 206, 127, 255, 139, 206, 128, 255, 140, 206, 128, 255, 140, 206, 128, 255, 140, 206, 128, 255, 141, 206, 128, 255, 141, 207, 128, 255, 152, 211, 133, 255, 152, 211, 133, 255, 153, 212, 133, 255, 153, 212, 133, 255, 153, 212, 133, 255, 154, 212, 133, 255, 154, 212, 133, 255, 154, 212, 133, 255, 155, 212, 134, 255, 155, 213, 134, 255, 155, 213, 134, 255, 156, 213, 134, 255, 156, 213, 134, 255, 156, 213, 134, 255, 157, 213, 134, 255, 157, 213, 135, 255, 157, 214, 135, 255, 158, 214, 135, 255, 158, 214, 135, 255, 158, 214, 135, 255, 159, 214, 135, 255, 159, 214, 135, 255, 159, 214, 135, 255, 159, 215, 136, 255, 160, 215, 136, 255, 160, 215, 136, 255, 160, 215, 136, 255, 161, 215, 136, 255, 161, 215, 136, 255, 161, 215, 136, 255, 162, 216, 137, 255, 162, 216, 137, 255, 162, 216, 137, 255, 163, 216, 137, 255, 163, 216, 137, 255, 163, 216, 137, 255, 164, 216, 137, 255, 164, 217, 138, 255, 164, 217, 138, 255, 165, 217, 138, 255, 165, 217, 138, 255, 165, 217, 138, 255, 166, 217, 138, 255, 166, 217, 138, 255, 166, 218, 139, 255, 167, 218, 139, 255, 167, 218, 139, 255, 167, 218, 139, 255, 167, 218, 139, 255, 168, 218, 139, 255, 168, 218, 139, 255, 168, 219, 140, 255, 169, 219, 140, 255, 169, 219, 140, 255, 169, 219, 140, 255, 170, 219, 140, 255, 170, 219, 140, 255, 170, 219, 140, 255, 171, 220, 141, 255, 171, 220, 141, 255, 171, 220, 141, 255, 172, 220, 141, 255, 172, 220, 141, 255, 172, 220, 141, 255, 172, 221, 141, 255, 173, 221, 142, 255, 173, 221, 142, 255, 173, 221, 142, 255, 174, 221, 142, 255, 174, 221, 142, 255, 174, 221, 142, 255, 175, 221, 142, 255, 175, 221, 142, 255, 175, 222, 143, 255, 175, 222, 143, 255, 176, 222, 143, 255, 176, 222, 143, 255, 176, 222, 143, 255, 177, 222, 143, 255, 177, 222, 143, 255, 177, 222, 143, 255, 177, 223, 143, 255, 178, 223, 144, 255, 178, 223, 144, 255, 178, 223, 144, 255, 178, 223, 144, 255, 179, 223, 144, 255, 179, 223, 144, 255, 179, 223, 144, 255, 180, 223, 144, 255, 180, 224, 145, 255, 180, 224, 145, 255, 180, 224, 145, 255, 181, 224, 145, 255, 181, 224, 145, 255, 181, 224, 145, 255, 182, 224, 145, 255, 182, 224, 145, 255, 182, 225, 146, 255, 182, 225, 146, 255, 183, 225, 146, 255, 183, 225, 146, 255, 183, 225, 146, 255, 184, 225, 146, 255, 184, 225, 146, 255, 184, 225, 146, 255, 184, 225, 147, 255, 185, 226, 147, 255, 185, 226, 147, 255, 185, 226, 147, 255, 185, 226, 147, 255, 186, 226, 147, 255, 186, 226, 147, 255, 186, 226, 147, 255, 187, 226, 148, 255, 187, 227, 148, 255, 187, 227, 148, 255, 187, 227, 148, 255, 188, 227, 148, 255, 188, 227, 148, 255, 188, 227, 148, 255, 189, 227, 148, 255, 189, 227, 149, 255, 189, 227, 149, 255, 189, 228, 149, 255, 190, 228, 149, 255, 190, 228, 149, 255, 190, 228, 149, 255, 199, 232, 154, 255, 200, 232, 154, 255, 200, 232, 154, 255, 200, 232, 154, 255, 200, 232, 154, 255, 201, 232, 154, 255, 201, 233, 154, 255, 201, 233, 155, 255, 201, 233, 155, 255, 202, 233, 155, 255, 202, 233, 155, 255, 202, 233, 155, 255, 203, 233, 155, 255, 203, 233, 155, 255, 203, 234, 155, 255, 203, 234, 156, 255, 204, 234, 156, 255, 204, 234, 156, 255, 204, 234, 156, 255, 204, 234, 156, 255, 205, 234, 156, 255, 205, 234, 156, 255, 205, 234, 157, 255, 206, 235, 157, 255, 206, 235, 157, 255, 206, 235, 157, 255, 206, 235, 157, 255, 207, 235, 157, 255, 207, 235, 157, 255, 207, 235, 157, 255, 207, 235, 158, 255, 208, 236, 158, 255, 208, 236, 158, 255, 208, 236, 158, 255, 209, 236, 158, 255, 209, 236, 158, 255, 209, 236, 158, 255, 209, 236, 159, 255, 210, 236, 159, 255, 210, 237, 159, 255, 210, 237, 159, 255, 210, 237, 159, 255, 211, 237, 159, 255, 211, 237, 159, 255, 211, 237, 160, 255, 211, 237, 160, 255, 212, 237, 160, 255, 212, 237, 160, 255, 212, 238, 160, 255, 213, 238, 160, 255, 213, 238, 160, 255, 213, 238, 161, 255, 213, 238, 161, 255, 214, 238, 161, 255, 214, 238, 161, 255, 214, 238, 161, 255, 214, 239, 161, 255, 215, 239, 161, 255, 215, 239, 162, 255, 215, 239, 162, 255, 215, 239, 162, 255, 216, 239, 162, 255, 216, 239, 162, 255, 216, 239, 162, 255, 216, 240, 162, 255, 217, 240, 163, 255, 217, 240, 163, 255, 217, 240, 163, 255, 217, 240, 163, 255, 217, 240, 163, 255, 218, 240, 163, 255, 218, 240, 163, 255, 218, 240, 164, 255, 218, 240, 164, 255, 218, 240, 164, 255, 219, 240, 164, 255, 219, 240, 164, 255, 219, 240, 164, 255, 219, 241, 164, 255, 219, 241, 164, 255, 220, 241, 165, 255, 220, 241, 165, 255, 220, 241, 165, 255, 220, 241, 165, 255, 220, 241, 165, 255, 221, 241, 165, 255, 221, 241, 165, 255, 221, 241, 165, 255, 221, 241, 166, 255, 221, 241, 166, 255, 222, 241, 166, 255, 222, 241, 166, 255, 222, 242, 166, 255, 222, 242, 166, 255, 222, 242, 166, 255, 223, 242, 166, 255, 223, 242, 167, 255, 223, 242, 167, 255, 223, 242, 167, 255, 223, 242, 167, 255, 224, 242, 167, 255, 224, 242, 167, 255, 224, 242, 167, 255, 224, 242, 168, 255, 224, 242, 168, 255, 225, 243, 168, 255, 225, 243, 168, 255, 225, 243, 168, 255, 225, 243, 168, 255, 225, 243, 168, 255, 225, 243, 168, 255, 226, 243, 169, 255, 226, 243, 169, 255, 226, 243, 169, 255, 226, 243, 169, 255, 226, 243, 169, 255, 227, 243, 169, 255, 227, 243, 169, 255, 227, 243, 170, 255, 227, 244, 170, 255, 227, 244, 170, 255, 228, 244, 170, 255, 228, 244, 170, 255, 228, 244, 170, 255, 228, 244, 170, 255, 228, 244, 171, 255, 229, 244, 171, 255, 229, 244, 171, 255, 235, 247, 175, 255, 235, 247, 175, 255, 235, 247, 176, 255, 235, 247, 176, 255, 236, 247, 176, 255, 236, 247, 176, 255, 236, 247, 176, 255, 236, 247, 176, 255, 236, 247, 176, 255, 237, 247, 177, 255, 237, 247, 177, 255, 237, 247, 177, 255, 237, 248, 177, 255, 237, 248, 177, 255, 238, 248, 177, 255, 238, 248, 177, 255, 238, 248, 178, 255, 238, 248, 178, 255, 238, 248, 178, 255, 238, 248, 178, 255, 239, 248, 178, 255, 239, 248, 178, 255, 239, 248, 178, 255, 239, 248, 179, 255, 239, 248, 179, 255, 240, 249, 179, 255, 240, 249, 179, 255, 240, 249, 179, 255, 240, 249, 179, 255, 240, 249, 179, 255, 240, 249, 180, 255, 241, 249, 180, 255, 241, 249, 180, 255, 241, 249, 180, 255, 241, 249, 180, 255, 241, 249, 180, 255, 242, 249, 180, 255, 242, 249, 181, 255, 242, 250, 181, 255, 242, 250, 181, 255, 242, 250, 181, 255, 242, 250, 181, 255, 243, 250, 181, 255, 243, 250, 181, 255, 243, 250, 182, 255, 243, 250, 182, 255, 243, 250, 182, 255, 243, 250, 182, 255, 244, 250, 182, 255, 244, 250, 182, 255, 244, 250, 182, 255, 244, 250, 183, 255, 244, 251, 183, 255, 245, 251, 183, 255, 245, 251, 183, 255, 245, 251, 183, 255, 245, 251, 183, 255, 245, 251, 183, 255, 245, 251, 184, 255, 246, 251, 184, 255, 246, 251, 184, 255, 246, 251, 184, 255, 246, 251, 184, 255, 246, 251, 184, 255, 246, 252, 184, 255, 247, 252, 185, 255, 247, 252, 185, 255, 247, 252, 185, 255, 247, 252, 186, 255, 247, 252, 186, 255, 247, 252, 186, 255, 247, 252, 186, 255, 247, 252, 187, 255, 247, 252, 187, 255, 247, 252, 187, 255, 247, 252, 188, 255, 247, 252, 188, 255, 247, 252, 188, 255, 247, 252, 188, 255, 247, 252, 189, 255, 248, 252, 189, 255, 248, 252, 189, 255, 248, 252, 189, 255, 248, 252, 190, 255, 248, 252, 190, 255, 248, 252, 190, 255, 248, 252, 191, 255, 248, 252, 191, 255, 248, 252, 191, 255, 248, 252, 191, 255, 248, 252, 192, 255, 248, 252, 192, 255, 248, 252, 192, 255, 248, 252, 192, 255, 248, 252, 193, 255, 248, 252, 193, 255, 248, 252, 193, 255, 249, 252, 194, 255, 249, 252, 194, 255, 249, 252, 194, 255, 249, 252, 194, 255, 249, 252, 195, 255, 249, 252, 195, 255, 249, 252, 195, 255, 249, 252, 195, 255, 249, 252, 196, 255, 249, 252, 196, 255, 249, 252, 196, 255, 249, 252, 197, 255, 249, 252, 197, 255, 249, 252, 197, 255, 249, 252, 197, 255, 249, 252, 198, 255, 249, 252, 198, 255, 249, 252, 198, 255, 250, 252, 198, 255, 250, 252, 199, 255, 250, 252, 199, 255, 250, 252, 199, 255, 250, 252, 200, 255, 250, 252, 200, 255, 250, 252, 200, 255, 250, 253, 200, 255, 250, 253, 201, 255, 250, 253, 201, 255, 250, 253, 201, 255, 250, 253, 202, 255, 250, 253, 202, 255, 252, 253, 211, 255, 252, 253, 211, 255, 252, 253, 211, 255, 252, 253, 212, 255, 252, 253, 212, 255, 252, 253, 212, 255, 252, 253, 213, 255, 252, 253, 213, 255, 252, 253, 213, 255, 252, 253, 213, 255, 252, 253, 214, 255, 252, 253, 214, 255, 252, 253, 214, 255, 252, 253, 214, 255, 252, 253, 215, 255, 253, 254, 215, 255, 253, 254, 215, 255, 253, 254, 216, 255, 253, 254, 216, 255, 253, 254, 216, 255, 253, 254, 216, 255, 253, 254, 217, 255, 253, 254, 217, 255, 253, 254, 217, 255, 253, 254, 217, 255, 253, 254, 218, 255, 253, 254, 218, 255, 253, 254, 218, 255, 253, 254, 219, 255, 253, 254, 219, 255, 253, 254, 219, 255, 253, 254, 219, 255, 253, 254, 220, 255, 253, 254, 220, 255, 253, 254, 220, 255, 253, 254, 220, 255, 253, 254, 221, 255, 253, 254, 221, 255, 254, 254, 221, 255, 254, 254, 222, 255, 254, 254, 222, 255, 254, 254, 222, 255, 254, 254, 222, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_YlGn_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 0, 69, 40, 0, 0, 71, 41, 24, 0, 73, 42, 49, 0, 75, 43, 74, 0, 77, 44, 99, 0, 79, 45, 124, 0, 81, 46, 149, 0, 90, 50, 174, 0, 92, 50, 199, 0, 94, 51, 224, 0, 96, 52, 249, 0, 98, 53, 255, 0, 100, 53, 255, 0, 102, 54, 255, 0, 104, 55, 255, 2, 106, 55, 255, 4, 107, 56, 255, 7, 109, 57, 255, 9, 110, 57, 255, 11, 112, 58, 255, 13, 113, 59, 255, 15, 115, 59, 255, 24, 122, 62, 255, 25, 123, 63, 255, 27, 124, 64, 255, 28, 126, 64, 255, 30, 127, 65, 255, 32, 129, 65, 255, 33, 130, 66, 255, 34, 131, 66, 255, 36, 133, 68, 255, 37, 135, 69, 255, 39, 137, 70, 255, 40, 139, 71, 255, 42, 140, 72, 255, 43, 142, 74, 255, 44, 144, 75, 255, 46, 146, 76, 255, 53, 155, 82, 255, 54, 157, 84, 255, 56, 159, 85, 255, 57, 160, 86, 255, 58, 162, 87, 255, 60, 164, 88, 255, 61, 166, 89, 255, 62, 167, 90, 255, 63, 169, 91, 255, 64, 170, 92, 255, 67, 172, 94, 255, 70, 173, 95, 255, 72, 174, 96, 255, 74, 175, 97, 255, 77, 176, 98, 255, 79, 177, 99, 255, 81, 178, 100, 255, 83, 179, 101, 255, 85, 180, 102, 255, 87, 181, 103, 255, 100, 187, 110, 255, 102, 188, 111, 255, 104, 189, 112, 255, 106, 190, 113, 255, 108, 191, 114, 255, 110, 192, 115, 255, 112, 193, 116, 255, 113, 194, 117, 255, 115, 195, 118, 255, 117, 196, 119, 255, 119, 197, 120, 255, 120, 198, 121, 255, 122, 199, 121, 255, 124, 199, 122, 255, 126, 200, 123, 255, 128, 201, 123, 255, 129, 202, 124, 255, 131, 202, 124, 255, 133, 203, 125, 255, 135, 204, 126, 255, 136, 204, 126, 255, 138, 205, 127, 255, 139, 206, 128, 255, 141, 207, 128, 255, 153, 212, 133, 255, 155, 212, 134, 255, 156, 213, 134, 255, 158, 214, 135, 255, 159, 214, 135, 255, 161, 215, 136, 255, 162, 216, 137, 255, 164, 216, 137, 255, 165, 217, 138, 255, 166, 218, 139, 255, 168, 218, 139, 255, 169, 219, 140, 255, 170, 219, 140, 255, 172, 220, 141, 255, 173, 221, 142, 255, 174, 221, 142, 255, 175, 222, 143, 255, 176, 222, 143, 255, 178, 223, 144, 255, 179, 223, 144, 255, 180, 224, 145, 255, 181, 224, 145, 255, 182, 224, 145, 255, 183, 225, 146, 255, 184, 225, 146, 255, 185, 226, 147, 255, 186, 226, 147, 255, 187, 227, 148, 255, 188, 227, 148, 255, 189, 227, 149, 255, 190, 228, 149, 255, 200, 232, 154, 255, 201, 233, 154, 255, 202, 233, 155, 255, 203, 233, 155, 255, 204, 234, 156, 255, 204, 234, 156, 255, 205, 235, 157, 255, 206, 235, 157, 255, 207, 235, 157, 255, 208, 236, 158, 255, 209, 236, 158, 255, 210, 236, 159, 255, 211, 237, 159, 255, 211, 237, 160, 255, 212, 238, 160, 255, 213, 238, 161, 255, 214, 238, 161, 255, 215, 239, 161, 255, 215, 239, 162, 255, 216, 239, 162, 255, 217, 240, 163, 255, 217, 240, 163, 255, 218, 240, 163, 255, 218, 240, 164, 255, 219, 240, 164, 255, 220, 241, 164, 255, 220, 241, 165, 255, 221, 241, 165, 255, 221, 241, 165, 255, 222, 241, 166, 255, 222, 242, 166, 255, 223, 242, 167, 255, 223, 242, 167, 255, 224, 242, 167, 255, 224, 242, 168, 255, 225, 243, 168, 255, 225, 243, 168, 255, 225, 243, 168, 255, 226, 243, 169, 255, 226, 243, 169, 255, 227, 243, 169, 255, 227, 244, 170, 255, 228, 244, 170, 255, 228, 244, 170, 255, 229, 244, 171, 255, 235, 247, 175, 255, 235, 247, 176, 255, 236, 247, 176, 255, 236, 247, 176, 255, 237, 247, 177, 255, 237, 247, 177, 255, 237, 248, 177, 255, 238, 248, 177, 255, 238, 248, 178, 255, 238, 248, 178, 255, 239, 248, 178, 255, 239, 248, 179, 255, 240, 249, 179, 255, 240, 249, 179, 255, 240, 249, 179, 255, 241, 249, 180, 255, 241, 249, 180, 255, 241, 249, 180, 255, 242, 249, 181, 255, 242, 250, 181, 255, 242, 250, 181, 255, 243, 250, 181, 255, 243, 250, 182, 255, 243, 250, 182, 255, 244, 250, 182, 255, 244, 250, 182, 255, 244, 250, 183, 255, 244, 251, 183, 255, 245, 251, 183, 255, 245, 251, 183, 255, 245, 251, 184, 255, 246, 251, 184, 255, 246, 251, 184, 255, 246, 251, 184, 255, 246, 251, 184, 255, 247, 252, 185, 255, 247, 252, 185, 255, 247, 252, 186, 255, 247, 252, 186, 255, 247, 252, 186, 255, 247, 252, 187, 255, 247, 252, 187, 255, 247, 252, 188, 255, 247, 252, 188, 255, 247, 252, 188, 255, 247, 252, 189, 255, 248, 252, 189, 255, 248, 252, 190, 255, 248, 252, 190, 255, 248, 252, 190, 255, 248, 252, 191, 255, 248, 252, 191, 255, 248, 252, 191, 255, 248, 252, 192, 255, 248, 252, 192, 255, 248, 252, 192, 255, 248, 252, 193, 255, 248, 252, 193, 255, 248, 252, 193, 255, 249, 252, 194, 255, 249, 252, 194, 255, 249, 252, 194, 255, 249, 252, 195, 255, 249, 252, 195, 255, 249, 252, 195, 255, 249, 252, 196, 255, 249, 252, 196, 255, 249, 252, 196, 255, 249, 252, 196, 255, 249, 252, 197, 255, 249, 252, 197, 255, 249, 252, 197, 255, 249, 252, 198, 255, 249, 252, 198, 255, 249, 252, 198, 255, 250, 252, 198, 255, 250, 252, 199, 255, 250, 252, 199, 255, 250, 252, 199, 255, 250, 252, 199, 255, 250, 252, 200, 255, 250, 252, 200, 255, 250, 253, 200, 255, 250, 253, 200, 255, 250, 253, 201, 255, 250, 253, 201, 255, 250, 253, 201, 255, 250, 253, 201, 255, 250, 253, 202, 255, 250, 253, 202, 255, 252, 253, 211, 255, 252, 253, 211, 255, 252, 253, 211, 255, 252, 253, 212, 255, 252, 253, 212, 255, 252, 253, 212, 255, 252, 253, 212, 255, 252, 253, 212, 255, 252, 253, 213, 255, 252, 253, 213, 255, 252, 253, 213, 255, 252, 253, 213, 255, 252, 253, 213, 255, 252, 253, 214, 255, 252, 253, 214, 255, 252, 253, 214, 255, 252, 253, 214, 255, 252, 253, 214, 255, 252, 253, 215, 255, 252, 253, 215, 255, 253, 254, 215, 255, 253, 254, 215, 255, 253, 254, 215, 255, 253, 254, 215, 255, 253, 254, 216, 255, 253, 254, 216, 255, 253, 254, 216, 255, 253, 254, 216, 255, 253, 254, 216, 255, 253, 254, 216, 255, 253, 254, 217, 255, 253, 254, 217, 255, 253, 254, 217, 255, 253, 254, 217, 255, 253, 254, 217, 255, 253, 254, 217, 255, 253, 254, 218, 255, 253, 254, 218, 255, 253, 254, 218, 255, 253, 254, 218, 255, 253, 254, 218, 255, 253, 254, 218, 255, 253, 254, 218, 255, 253, 254, 219, 255, 253, 254, 219, 255, 253, 254, 219, 255, 253, 254, 219, 255, 253, 254, 219, 255, 253, 254, 219, 255, 253, 254, 219, 255, 253, 254, 219, 255, 253, 254, 220, 255, 253, 254, 220, 255, 253, 254, 220, 255, 253, 254, 220, 255, 253, 254, 220, 255, 253, 254, 220, 255, 253, 254, 220, 255, 253, 254, 220, 255, 253, 254, 220, 255, 253, 254, 221, 255, 253, 254, 221, 255, 253, 254, 221, 255, 253, 254, 221, 255, 253, 254, 221, 255, 254, 254, 221, 255, 254, 254, 221, 255, 254, 254, 221, 255, 254, 254, 221, 255, 254, 254, 222, 255, 254, 254, 222, 255, 254, 254, 222, 255, 254, 254, 222, 255, 254, 254, 222, 255, 254, 254, 222, 255, 254, 254, 222, 255, 254, 254, 222, 255, 254, 254, 222, 255, 254, 254, 222, 255, 254, 254, 222, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_YlGn_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
