/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/RdYlBu.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 49, 54, 149, 255, 69, 117, 180, 255, 116, 173, 209, 255, 171, 217, 233, 255, 224, 243, 248, 255, 255, 255, 191, 255, 254, 224, 144, 255, 253, 174, 97, 255, 244, 109, 67, 255, 215, 48, 39, 255, 165, 0, 38, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_RdYlBu_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 49, 54, 149, 0, 48, 54, 149, 7, 48, 55, 149, 14, 48, 56, 150, 22, 48, 56, 150, 29, 48, 57, 151, 37, 48, 58, 151, 44, 48, 58, 151, 52, 48, 59, 152, 59, 47, 60, 152, 67, 47, 60, 153, 74, 47, 61, 153, 82, 47, 62, 153, 89, 47, 62, 154, 97, 47, 63, 154, 104, 47, 64, 155, 112, 47, 64, 155, 119, 47, 65, 155, 127, 47, 66, 156, 134, 47, 66, 156, 141, 47, 67, 156, 149, 47, 68, 157, 156, 47, 68, 157, 164, 47, 69, 158, 171, 47, 69, 158, 179, 47, 70, 158, 186, 47, 71, 159, 194, 47, 71, 159, 201, 47, 72, 159, 209, 47, 73, 160, 216, 47, 73, 160, 224, 47, 74, 160, 231, 47, 74, 161, 239, 47, 75, 161, 246, 47, 76, 161, 254, 47, 76, 162, 255, 47, 77, 162, 255, 47, 78, 162, 255, 47, 78, 163, 255, 47, 79, 163, 255, 47, 79, 163, 255, 48, 80, 164, 255, 48, 81, 164, 255, 48, 81, 164, 255, 48, 82, 165, 255, 48, 83, 165, 255, 48, 83, 165, 255, 48, 84, 166, 255, 49, 84, 166, 255, 49, 85, 166, 255, 49, 86, 166, 255, 49, 86, 167, 255, 49, 87, 167, 255, 50, 87, 167, 255, 50, 88, 168, 255, 50, 89, 168, 255, 50, 89, 168, 255, 50, 90, 169, 255, 51, 90, 169, 255, 51, 91, 169, 255, 51, 92, 169, 255, 51, 92, 170, 255, 52, 93, 170, 255, 52, 93, 170, 255, 52, 94, 170, 255, 53, 95, 171, 255, 53, 95, 171, 255, 53, 96, 171, 255, 54, 96, 172, 255, 54, 97, 172, 255, 54, 98, 172, 255, 55, 98, 172, 255, 55, 99, 173, 255, 55, 99, 173, 255, 56, 100, 173, 255, 56, 101, 173, 255, 56, 101, 174, 255, 57, 102, 174, 255, 57, 102, 174, 255, 57, 103, 174, 255, 58, 104, 175, 255, 58, 104, 175, 255, 59, 105, 175, 255, 59, 105, 175, 255, 60, 106, 175, 255, 60, 106, 176, 255, 60, 107, 176, 255, 61, 108, 176, 255, 61, 108, 176, 255, 62, 109, 177, 255, 62, 109, 177, 255, 63, 110, 177, 255, 63, 111, 177, 255, 64, 111, 178, 255, 64, 112, 178, 255, 65, 112, 178, 255, 65, 113, 178, 255, 66, 113, 178, 255, 66, 114, 179, 255, 67, 115, 179, 255, 67, 115, 179, 255, 68, 116, 179, 255, 68, 116, 179, 255, 69, 117, 180, 255, 69, 117, 180, 255, 69, 118, 180, 255, 69, 119, 181, 255, 70, 119, 181, 255, 70, 120, 181, 255, 70, 120, 182, 255, 70, 121, 182, 255, 71, 121, 182, 255, 71, 122, 183, 255, 71, 122, 183, 255, 72, 123, 183, 255, 72, 124, 184, 255, 72, 124, 184, 255, 73, 125, 184, 255, 73, 125, 185, 255, 73, 126, 185, 255, 74, 126, 185, 255, 74, 127, 186, 255, 74, 127, 186, 255, 75, 128, 186, 255, 75, 129, 186, 255, 75, 129, 187, 255, 76, 130, 187, 255, 76, 130, 187, 255, 76, 131, 188, 255, 77, 131, 188, 255, 77, 132, 188, 255, 77, 132, 189, 255, 78, 133, 189, 255, 78, 134, 189, 255, 79, 134, 189, 255, 79, 135, 190, 255, 79, 135, 190, 255, 80, 136, 190, 255, 80, 136, 191, 255, 81, 137, 191, 255, 81, 137, 191, 255, 81, 138, 191, 255, 82, 138, 192, 255, 82, 139, 192, 255, 83, 140, 192, 255, 83, 140, 193, 255, 84, 141, 193, 255, 84, 141, 193, 255, 84, 142, 193, 255, 85, 142, 194, 255, 85, 143, 194, 255, 86, 143, 194, 255, 86, 144, 195, 255, 87, 145, 195, 255, 87, 145, 195, 255, 88, 146, 195, 255, 88, 146, 196, 255, 89, 147, 196, 255, 89, 147, 196, 255, 90, 148, 197, 255, 90, 148, 197, 255, 91, 149, 197, 255, 91, 149, 197, 255, 92, 150, 198, 255, 92, 151, 198, 255, 93, 151, 198, 255, 93, 152, 198, 255, 94, 152, 199, 255, 94, 153, 199, 255, 95, 153, 199, 255, 95, 154, 200, 255, 96, 154, 200, 255, 96, 155, 200, 255, 97, 155, 200, 255, 97, 156, 201, 255, 98, 156, 201, 255, 98, 157, 201, 255, 99, 158, 201, 255, 100, 158, 202, 255, 100, 159, 202, 255, 101, 159, 202, 255, 101, 160, 202, 255, 102, 160, 203, 255, 102, 161, 203, 255, 103, 161, 203, 255, 104, 162, 203, 255, 104, 162, 204, 255, 105, 163, 204, 255, 105, 164, 204, 255, 106, 164, 204, 255, 106, 165, 205, 255, 107, 165, 205, 255, 108, 166, 205, 255, 108, 166, 206, 255, 109, 167, 206, 255, 109, 167, 206, 255, 110, 168, 206, 255, 111, 168, 207, 255, 111, 169, 207, 255, 112, 169, 207, 255, 113, 170, 207, 255, 113, 170, 208, 255, 114, 171, 208, 255, 114, 172, 208, 255, 115, 172, 208, 255, 116, 173, 209, 255, 116, 173, 209, 255, 117, 173, 209, 255, 117, 174, 209, 255, 117, 174, 209, 255, 118, 175, 210, 255, 118, 175, 210, 255, 119, 176, 210, 255, 119, 176, 210, 255, 120, 177, 211, 255, 120, 177, 211, 255, 121, 177, 211, 255, 121, 178, 211, 255, 122, 178, 212, 255, 122, 179, 212, 255, 123, 179, 212, 255, 123, 180, 212, 255, 124, 180, 212, 255, 124, 180, 213, 255, 125, 181, 213, 255, 125, 181, 213, 255, 126, 182, 213, 255, 126, 182, 214, 255, 127, 183, 214, 255, 127, 183, 214, 255, 128, 183, 214, 255, 128, 184, 215, 255, 129, 184, 215, 255, 129, 185, 215, 255, 130, 185, 215, 255, 130, 186, 215, 255, 131, 186, 216, 255, 131, 186, 216, 255, 132, 187, 216, 255, 132, 187, 216, 255, 133, 188, 217, 255, 133, 188, 217, 255, 134, 189, 217, 255, 135, 189, 217, 255, 135, 190, 218, 255, 136, 190, 218, 255, 136, 190, 218, 255, 137, 191, 218, 255, 137, 191, 218, 255, 138, 192, 219, 255, 138, 192, 219, 255, 139, 193, 219, 255, 139, 193, 219, 255, 140, 193, 220, 255, 140, 194, 220, 255, 141, 194, 220, 255, 141, 195, 220, 255, 142, 195, 221, 255, 143, 196, 221, 255, 143, 196, 221, 255, 144, 196, 221, 255, 144, 197, 221, 255, 145, 197, 222, 255, 145, 198, 222, 255, 146, 198, 222, 255, 146, 199, 222, 255, 147, 199, 223, 255, 147, 199, 223, 255, 148, 200, 223, 255, 149, 200, 223, 255, 149, 201, 224, 255, 150, 201, 224, 255, 150, 202, 224, 255, 151, 202, 224, 255, 151, 202, 224, 255, 152, 203, 225, 255, 152, 203, 225, 255, 153, 204, 225, 255, 154, 204, 225, 255, 154, 205, 226, 255, 155, 205, 226, 255, 155, 205, 226, 255, 156, 206, 226, 255, 156, 206, 227, 255, 157, 207, 227, 255, 158, 207, 227, 255, 158, 208, 227, 255, 159, 208, 228, 255, 159, 208, 228, 255, 160, 209, 228, 255, 160, 209, 228, 255, 161, 210, 229, 255, 162, 210, 229, 255, 162, 210, 229, 255, 163, 211, 229, 255, 163, 211, 230, 255, 164, 212, 230, 255, 165, 212, 230, 255, 165, 213, 230, 255, 166, 213, 230, 255, 166, 213, 231, 255, 167, 214, 231, 255, 167, 214, 231, 255, 168, 215, 231, 255, 169, 215, 232, 255, 169, 216, 232, 255, 170, 216, 232, 255, 170, 216, 232, 255, 171, 217, 233, 255, 171, 217, 233, 255, 172, 217, 233, 255, 172, 217, 233, 255, 173, 218, 233, 255, 174, 218, 233, 255, 174, 218, 233, 255, 175, 219, 234, 255, 175, 219, 234, 255, 176, 219, 234, 255, 176, 219, 234, 255, 177, 220, 234, 255, 177, 220, 234, 255, 178, 220, 234, 255, 178, 220, 234, 255, 179, 221, 235, 255, 179, 221, 235, 255, 180, 221, 235, 255, 180, 221, 235, 255, 181, 222, 235, 255, 181, 222, 235, 255, 182, 222, 235, 255, 182, 222, 236, 255, 183, 223, 236, 255, 183, 223, 236, 255, 184, 223, 236, 255, 184, 223, 236, 255, 185, 224, 236, 255, 185, 224, 236, 255, 186, 224, 237, 255, 187, 224, 237, 255, 187, 225, 237, 255, 188, 225, 237, 255, 188, 225, 237, 255, 189, 225, 237, 255, 189, 226, 237, 255, 190, 226, 238, 255, 190, 226, 238, 255, 191, 226, 238, 255, 191, 227, 238, 255, 192, 227, 238, 255, 192, 227, 238, 255, 193, 227, 238, 255, 193, 228, 239, 255, 194, 228, 239, 255, 194, 228, 239, 255, 195, 228, 239, 255, 195, 229, 239, 255, 196, 229, 239, 255, 196, 229, 239, 255, 197, 229, 240, 255, 197, 230, 240, 255, 198, 230, 240, 255, 198, 230, 240, 255, 199, 230, 240, 255, 199, 231, 240, 255, 200, 231, 240, 255, 200, 231, 241, 255, 201, 232, 241, 255, 202, 232, 241, 255, 202, 232, 241, 255, 203, 232, 241, 255, 203, 233, 241, 255, 204, 233, 241, 255, 204, 233, 242, 255, 205, 233, 242, 255, 205, 234, 242, 255, 206, 234, 242, 255, 206, 234, 242, 255, 207, 234, 242, 255, 207, 235, 243, 255, 208, 235, 243, 255, 208, 235, 243, 255, 209, 235, 243, 255, 209, 236, 243, 255, 210, 236, 243, 255, 210, 236, 243, 255, 211, 236, 244, 255, 211, 237, 244, 255, 212, 237, 244, 255, 212, 237, 244, 255, 213, 237, 244, 255, 213, 238, 244, 255, 214, 238, 245, 255, 214, 238, 245, 255, 215, 238, 245, 255, 215, 239, 245, 255, 216, 239, 245, 255, 216, 239, 245, 255, 217, 239, 245, 255, 218, 240, 246, 255, 218, 240, 246, 255, 219, 240, 246, 255, 219, 240, 246, 255, 220, 241, 246, 255, 220, 241, 246, 255, 221, 241, 247, 255, 221, 241, 247, 255, 222, 242, 247, 255, 222, 242, 247, 255, 223, 242, 247, 255, 223, 242, 247, 255, 223, 243, 248, 255, 223, 243, 248, 255, 222, 243, 248, 255, 222, 243, 248, 255, 221, 244, 248, 255, 221, 244, 248, 255, 220, 244, 249, 255, 219, 245, 249, 255, 219, 245, 249, 255, 218, 245, 249, 255, 218, 245, 249, 255, 217, 246, 249, 255, 217, 246, 249, 255, 216, 246, 249, 255, 216, 247, 249, 255, 215, 247, 249, 255, 215, 247, 249, 255, 214, 247, 249, 255, 214, 248, 248, 255, 213, 248, 248, 255, 213, 248, 248, 255, 212, 249, 248, 255, 212, 249, 248, 255, 212, 249, 248, 255, 211, 249, 247, 255, 211, 250, 247, 255, 211, 250, 247, 255, 210, 250, 246, 255, 210, 250, 246, 255, 210, 251, 246, 255, 209, 251, 245, 255, 209, 251, 245, 255, 209, 251, 245, 255, 209, 252, 244, 255, 208, 252, 244, 255, 208, 252, 243, 255, 208, 252, 243, 255, 208, 253, 242, 255, 208, 253, 242, 255, 208, 253, 241, 255, 208, 253, 241, 255, 208, 253, 240, 255, 208, 254, 240, 255, 208, 254, 239, 255, 208, 254, 238, 255, 208, 254, 238, 255, 208, 254, 237, 255, 208, 255, 237, 255, 208, 255, 236, 255, 208, 255, 235, 255, 209, 255, 234, 255, 209, 255, 234, 255, 209, 255, 233, 255, 209, 255, 232, 255, 210, 255, 232, 255, 210, 255, 231, 255, 210, 255, 230, 255, 211, 255, 229, 255, 211, 255, 228, 255, 212, 255, 228, 255, 212, 255, 227, 255, 213, 255, 226, 255, 213, 255, 225, 255, 214, 255, 224, 255, 214, 255, 223, 255, 215, 255, 222, 255, 216, 255, 222, 255, 216, 255, 221, 255, 217, 255, 220, 255, 218, 255, 219, 255, 219, 255, 218, 255, 219, 255, 217, 255, 220, 255, 216, 255, 221, 255, 215, 255, 222, 255, 214, 255, 223, 255, 213, 255, 224, 255, 213, 255, 225, 255, 212, 255, 226, 255, 211, 255, 227, 255, 210, 255, 228, 255, 209, 255, 229, 255, 208, 255, 230, 255, 207, 255, 231, 255, 206, 255, 232, 255, 205, 255, 233, 255, 204, 255, 234, 255, 203, 255, 235, 255, 203, 255, 236, 255, 202, 255, 238, 255, 201, 255, 239, 255, 200, 255, 240, 255, 199, 255, 241, 255, 198, 255, 243, 255, 197, 255, 244, 255, 197, 255, 245, 255, 196, 255, 246, 255, 195, 255, 248, 255, 194, 255, 249, 255, 193, 255, 250, 255, 193, 255, 252, 255, 192, 255, 253, 255, 191, 255, 254, 255, 190, 255, 254, 254, 190, 255, 254, 254, 190, 255, 254, 254, 189, 255, 254, 253, 189, 255, 254, 253, 188, 255, 254, 253, 188, 255, 254, 252, 187, 255, 254, 252, 187, 255, 254, 252, 186, 255, 254, 252, 186, 255, 254, 251, 185, 255, 254, 251, 185, 255, 254, 251, 184, 255, 254, 250, 184, 255, 254, 250, 183, 255, 254, 250, 183, 255, 254, 250, 182, 255, 254, 249, 182, 255, 254, 249, 181, 255, 254, 249, 181, 255, 254, 248, 180, 255, 254, 248, 180, 255, 254, 248, 179, 255, 254, 248, 179, 255, 254, 247, 179, 255, 254, 247, 178, 255, 254, 247, 178, 255, 254, 246, 177, 255, 253, 246, 177, 255, 253, 246, 176, 255, 253, 245, 176, 255, 253, 245, 175, 255, 253, 245, 175, 255, 253, 245, 174, 255, 253, 244, 174, 255, 253, 244, 173, 255, 253, 244, 173, 255, 253, 243, 172, 255, 253, 243, 172, 255, 253, 243, 171, 255, 253, 243, 171, 255, 253, 242, 171, 255, 253, 242, 170, 255, 253, 242, 170, 255, 253, 241, 169, 255, 253, 241, 169, 255, 253, 241, 168, 255, 253, 240, 168, 255, 253, 240, 167, 255, 253, 240, 167, 255, 253, 240, 166, 255, 253, 239, 166, 255, 253, 239, 165, 255, 253, 239, 165, 255, 253, 238, 165, 255, 253, 238, 164, 255, 253, 238, 164, 255, 253, 237, 163, 255, 253, 237, 163, 255, 253, 237, 162, 255, 253, 236, 162, 255, 253, 236, 161, 255, 253, 236, 161, 255, 253, 236, 160, 255, 253, 235, 160, 255, 253, 235, 159, 255, 253, 235, 159, 255, 253, 234, 159, 255, 253, 234, 158, 255, 253, 234, 158, 255, 253, 233, 157, 255, 253, 233, 157, 255, 253, 233, 156, 255, 253, 232, 156, 255, 253, 232, 155, 255, 253, 232, 155, 255, 253, 232, 155, 255, 253, 231, 154, 255, 253, 231, 154, 255, 253, 231, 153, 255, 253, 230, 153, 255, 253, 230, 152, 255, 253, 230, 152, 255, 253, 229, 151, 255, 253, 229, 151, 255, 253, 229, 151, 255, 253, 228, 150, 255, 253, 228, 150, 255, 253, 228, 149, 255, 253, 227, 149, 255, 253, 227, 148, 255, 253, 227, 148, 255, 253, 226, 148, 255, 253, 226, 147, 255, 253, 226, 147, 255, 253, 226, 146, 255, 253, 225, 146, 255, 253, 225, 145, 255, 253, 225, 145, 255, 253, 224, 145, 255, 253, 224, 144, 255, 253, 224, 144, 255, 253, 223, 143, 255, 253, 223, 143, 255, 253, 222, 142, 255, 253, 222, 142, 255, 253, 221, 141, 255, 253, 221, 140, 255, 253, 220, 140, 255, 253, 220, 139, 255, 253, 220, 139, 255, 253, 219, 138, 255, 253, 219, 138, 255, 253, 218, 137, 255, 253, 218, 137, 255, 253, 217, 136, 255, 253, 217, 136, 255, 253, 216, 135, 255, 253, 216, 134, 255, 253, 215, 134, 255, 253, 215, 133, 255, 253, 214, 133, 255, 253, 214, 132, 255, 253, 213, 132, 255, 253, 213, 131, 255, 253, 212, 131, 255, 253, 212, 130, 255, 253, 212, 130, 255, 253, 211, 129, 255, 253, 211, 129, 255, 253, 210, 128, 255, 253, 210, 128, 255, 253, 209, 127, 255, 253, 209, 127, 255, 253, 208, 126, 255, 253, 208, 126, 255, 253, 207, 125, 255, 253, 207, 125, 255, 253, 206, 124, 255, 253, 206, 124, 255, 253, 205, 123, 255, 253, 205, 123, 255, 253, 204, 122, 255, 253, 204, 122, 255, 253, 203, 121, 255, 253, 203, 121, 255, 253, 202, 120, 255, 253, 202, 120, 255, 253, 201, 119, 255, 253, 201, 119, 255, 253, 200, 118, 255, 253, 200, 118, 255, 253, 200, 118, 255, 253, 199, 117, 255, 253, 199, 117, 255, 253, 198, 116, 255, 253, 198, 116, 255, 253, 197, 115, 255, 253, 197, 115, 255, 253, 196, 114, 255, 253, 196, 114, 255, 253, 195, 113, 255, 253, 195, 113, 255, 253, 194, 113, 255, 253, 194, 112, 255, 253, 193, 112, 255, 253, 193, 111, 255, 253, 192, 111, 255, 253, 192, 110, 255, 253, 191, 110, 255, 253, 191, 110, 255, 253, 190, 109, 255, 253, 190, 109, 255, 253, 189, 108, 255, 253, 189, 108, 255, 253, 188, 107, 255, 253, 188, 107, 255, 253, 187, 107, 255, 253, 187, 106, 255, 253, 186, 106, 255, 253, 186, 105, 255, 253, 185, 105, 255, 253, 185, 105, 255, 253, 184, 104, 255, 253, 184, 104, 255, 253, 183, 103, 255, 253, 183, 103, 255, 253, 182, 103, 255, 253, 182, 102, 255, 253, 181, 102, 255, 253, 181, 101, 255, 253, 180, 101, 255, 253, 180, 101, 255, 253, 179, 100, 255, 253, 179, 100, 255, 253, 178, 100, 255, 253, 178, 99, 255, 253, 177, 99, 255, 253, 176, 99, 255, 253, 176, 98, 255, 253, 175, 98, 255, 253, 175, 97, 255, 253, 174, 97, 255, 253, 174, 97, 255, 252, 173, 96, 255, 252, 173, 96, 255, 252, 172, 96, 255, 252, 172, 95, 255, 252, 171, 95, 255, 252, 170, 94, 255, 252, 170, 94, 255, 252, 169, 93, 255, 252, 169, 93, 255, 252, 168, 93, 255, 252, 167, 92, 255, 252, 167, 92, 255, 252, 166, 91, 255, 252, 166, 91, 255, 251, 165, 90, 255, 251, 165, 90, 255, 251, 164, 90, 255, 251, 163, 89, 255, 251, 163, 89, 255, 251, 162, 89, 255, 251, 162, 88, 255, 251, 161, 88, 255, 251, 160, 87, 255, 251, 160, 87, 255, 251, 159, 87, 255, 251, 159, 86, 255, 251, 158, 86, 255, 251, 157, 85, 255, 250, 157, 85, 255, 250, 156, 85, 255, 250, 155, 84, 255, 250, 155, 84, 255, 250, 154, 84, 255, 250, 154, 83, 255, 250, 153, 83, 255, 250, 152, 83, 255, 250, 152, 82, 255, 250, 151, 82, 255, 250, 151, 82, 255, 250, 150, 81, 255, 250, 149, 81, 255, 249, 149, 81, 255, 249, 148, 80, 255, 249, 147, 80, 255, 249, 147, 80, 255, 249, 146, 79, 255, 249, 146, 79, 255, 249, 145, 79, 255, 249, 144, 78, 255, 249, 144, 78, 255, 249, 143, 78, 255, 249, 142, 78, 255, 249, 142, 77, 255, 248, 141, 77, 255, 248, 141, 77, 255, 248, 140, 76, 255, 248, 139, 76, 255, 248, 139, 76, 255, 248, 138, 76, 255, 248, 137, 75, 255, 248, 137, 75, 255, 248, 136, 75, 255, 248, 135, 74, 255, 248, 135, 74, 255, 247, 134, 74, 255, 247, 134, 74, 255, 247, 133, 73, 255, 247, 132, 73, 255, 247, 132, 73, 255, 247, 131, 73, 255, 247, 130, 72, 255, 247, 130, 72, 255, 247, 129, 72, 255, 247, 128, 72, 255, 247, 128, 72, 255, 246, 127, 71, 255, 246, 126, 71, 255, 246, 126, 71, 255, 246, 125, 71, 255, 246, 124, 70, 255, 246, 124, 70, 255, 246, 123, 70, 255, 246, 122, 70, 255, 246, 122, 70, 255, 246, 121, 69, 255, 245, 120, 69, 255, 245, 120, 69, 255, 245, 119, 69, 255, 245, 118, 69, 255, 245, 118, 69, 255, 245, 117, 68, 255, 245, 116, 68, 255, 245, 116, 68, 255, 245, 115, 68, 255, 244, 114, 68, 255, 244, 114, 68, 255, 244, 113, 67, 255, 244, 112, 67, 255, 244, 111, 67, 255, 244, 111, 67, 255, 244, 110, 67, 255, 244, 109, 67, 255, 244, 109, 67, 255, 243, 108, 66, 255, 243, 108, 66, 255, 243, 107, 66, 255, 242, 107, 65, 255, 242, 106, 65, 255, 242, 105, 65, 255, 242, 105, 64, 255, 241, 104, 64, 255, 241, 104, 64, 255, 241, 103, 63, 255, 241, 103, 63, 255, 240, 102, 63, 255, 240, 102, 63, 255, 240, 101, 62, 255, 239, 101, 62, 255, 239, 100, 62, 255, 239, 100, 61, 255, 239, 99, 61, 255, 238, 99, 61, 255, 238, 98, 60, 255, 238, 98, 60, 255, 237, 97, 60, 255, 237, 96, 60, 255, 237, 96, 59, 255, 237, 95, 59, 255, 236, 95, 59, 255, 236, 94, 58, 255, 236, 94, 58, 255, 236, 93, 58, 255, 235, 93, 57, 255, 235, 92, 57, 255, 235, 92, 57, 255, 234, 91, 57, 255, 234, 91, 56, 255, 234, 90, 56, 255, 234, 89, 56, 255, 233, 89, 55, 255, 233, 88, 55, 255, 233, 88, 55, 255, 232, 87, 55, 255, 232, 87, 54, 255, 232, 86, 54, 255, 232, 86, 54, 255, 231, 85, 54, 255, 231, 84, 53, 255, 231, 84, 53, 255, 230, 83, 53, 255, 230, 83, 52, 255, 230, 82, 52, 255, 230, 82, 52, 255, 229, 81, 52, 255, 229, 80, 51, 255, 229, 80, 51, 255, 228, 79, 51, 255, 228, 79, 50, 255, 228, 78, 50, 255, 228, 78, 50, 255, 227, 77, 50, 255, 227, 76, 49, 255, 227, 76, 49, 255, 226, 75, 49, 255, 226, 75, 49, 255, 226, 74, 48, 255, 226, 73, 48, 255, 225, 73, 48, 255, 225, 72, 48, 255, 225, 72, 47, 255, 225, 71, 47, 255, 224, 70, 47, 255, 224, 70, 46, 255, 224, 69, 46, 255, 223, 68, 46, 255, 223, 68, 46, 255, 223, 67, 45, 255, 222, 67, 45, 255, 222, 66, 45, 255, 222, 65, 45, 255, 222, 65, 44, 255, 221, 64, 44, 255, 221, 63, 44, 255, 221, 63, 44, 255, 220, 62, 43, 255, 220, 61, 43, 255, 220, 61, 43, 255, 220, 60, 43, 255, 219, 59, 42, 255, 219, 59, 42, 255, 219, 58, 42, 255, 218, 57, 42, 255, 218, 57, 41, 255, 218, 56, 41, 255, 218, 55, 41, 255, 217, 55, 41, 255, 217, 54, 41, 255, 217, 53, 40, 255, 216, 52, 40, 255, 216, 52, 40, 255, 216, 51, 40, 255, 216, 50, 39, 255, 215, 49, 39, 255, 215, 49, 39, 255, 215, 48, 39, 255, 214, 47, 39, 255, 214, 47, 39, 255, 213, 47, 39, 255, 213, 46, 39, 255, 212, 46, 39, 255, 212, 45, 39, 255, 211, 45, 39, 255, 211, 45, 39, 255, 210, 44, 39, 255, 210, 44, 39, 255, 210, 43, 39, 255, 209, 43, 39, 255, 209, 43, 39, 255, 208, 42, 39, 255, 208, 42, 39, 255, 207, 41, 39, 255, 207, 41, 39, 255, 206, 41, 39, 255, 206, 40, 39, 255, 205, 40, 39, 255, 205, 39, 39, 255, 204, 39, 39, 255, 204, 39, 39, 255, 203, 38, 39, 255, 203, 38, 39, 255, 202, 37, 39, 255, 202, 37, 39, 255, 201, 37, 39, 255, 201, 36, 39, 255, 200, 36, 39, 255, 200, 35, 39, 255, 199, 35, 39, 255, 199, 34, 39, 255, 198, 34, 39, 255, 198, 34, 39, 255, 197, 33, 39, 255, 197, 33, 39, 255, 196, 32, 39, 255, 196, 32, 39, 255, 196, 32, 39, 255, 195, 31, 39, 255, 195, 31, 39, 255, 194, 30, 39, 255, 194, 30, 39, 255, 193, 29, 39, 255, 193, 29, 39, 255, 192, 29, 39, 255, 192, 28, 39, 255, 191, 28, 39, 255, 191, 27, 39, 255, 190, 27, 39, 255, 190, 26, 39, 255, 189, 26, 39, 255, 189, 26, 39, 255, 188, 25, 39, 255, 188, 25, 39, 255, 187, 24, 39, 255, 187, 24, 39, 255, 186, 23, 39, 255, 186, 23, 39, 255, 185, 22, 39, 255, 185, 22, 39, 255, 184, 21, 39, 255, 184, 21, 39, 255, 183, 21, 39, 255, 183, 20, 39, 255, 182, 20, 39, 255, 182, 19, 39, 255, 181, 19, 39, 255, 181, 18, 39, 255, 180, 18, 39, 255, 180, 17, 39, 255, 179, 17, 39, 255, 179, 16, 39, 255, 178, 16, 39, 255, 178, 15, 39, 255, 177, 14, 38, 255, 177, 14, 38, 255, 176, 13, 38, 255, 176, 13, 38, 255, 175, 12, 38, 255, 175, 12, 38, 255, 174, 11, 38, 255, 174, 10, 38, 255, 173, 10, 38, 255, 173, 9, 38, 255, 172, 9, 38, 255, 172, 8, 38, 255, 171, 7, 38, 255, 171, 7, 38, 255, 170, 6, 38, 255, 170, 6, 38, 255, 169, 5, 38, 255, 169, 4, 38, 255, 168, 4, 38, 255, 168, 3, 38, 255, 167, 3, 38, 255, 167, 2, 38, 255, 166, 2, 38, 255, 166, 1, 38, 255, 165, 1, 38, 255, 165, 0, 38, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_RdYlBu_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 49, 54, 149, 0, 48, 54, 149, 7, 48, 55, 149, 14, 48, 55, 150, 22, 48, 56, 150, 29, 48, 56, 150, 37, 48, 57, 150, 44, 48, 57, 151, 52, 48, 58, 151, 59, 48, 58, 151, 67, 48, 59, 152, 74, 48, 59, 152, 82, 47, 60, 152, 89, 47, 61, 153, 97, 47, 61, 153, 104, 47, 62, 153, 112, 47, 62, 154, 119, 47, 63, 154, 127, 47, 63, 154, 134, 47, 64, 155, 141, 47, 64, 155, 149, 47, 65, 155, 156, 47, 65, 155, 164, 47, 66, 156, 171, 47, 66, 156, 179, 47, 67, 156, 186, 47, 67, 157, 194, 47, 68, 157, 201, 47, 68, 157, 209, 47, 69, 157, 216, 47, 69, 158, 224, 47, 70, 158, 231, 47, 70, 158, 239, 47, 71, 159, 246, 47, 71, 159, 254, 47, 72, 159, 255, 47, 72, 159, 255, 47, 73, 160, 255, 48, 73, 160, 255, 48, 74, 160, 255, 48, 74, 160, 255, 48, 75, 161, 255, 48, 75, 161, 255, 48, 76, 161, 255, 48, 76, 161, 255, 48, 77, 162, 255, 48, 77, 162, 255, 48, 78, 162, 255, 49, 78, 162, 255, 49, 79, 163, 255, 49, 79, 163, 255, 49, 80, 163, 255, 53, 93, 170, 255, 53, 93, 170, 255, 53, 94, 170, 255, 54, 94, 170, 255, 54, 95, 170, 255, 54, 95, 171, 255, 54, 96, 171, 255, 54, 96, 171, 255, 55, 97, 171, 255, 55, 97, 172, 255, 55, 98, 172, 255, 55, 98, 172, 255, 56, 99, 172, 255, 56, 99, 172, 255, 56, 99, 173, 255, 56, 100, 173, 255, 57, 100, 173, 255, 57, 101, 173, 255, 57, 101, 174, 255, 57, 102, 174, 255, 58, 102, 174, 255, 58, 103, 174, 255, 58, 103, 174, 255, 58, 104, 175, 255, 59, 104, 175, 255, 59, 105, 175, 255, 59, 105, 175, 255, 60, 106, 175, 255, 60, 106, 176, 255, 60, 107, 176, 255, 61, 107, 176, 255, 61, 108, 176, 255, 61, 108, 176, 255, 62, 108, 176, 255, 62, 109, 177, 255, 62, 109, 177, 255, 63, 110, 177, 255, 63, 110, 177, 255, 64, 111, 177, 255, 64, 111, 178, 255, 64, 112, 178, 255, 65, 112, 178, 255, 65, 113, 178, 255, 65, 113, 178, 255, 66, 114, 178, 255, 66, 114, 179, 255, 67, 114, 179, 255, 67, 115, 179, 255, 67, 115, 179, 255, 68, 116, 179, 255, 68, 116, 179, 255, 69, 117, 180, 255, 69, 117, 180, 255, 69, 118, 180, 255, 69, 118, 180, 255, 69, 119, 181, 255, 70, 119, 181, 255, 70, 119, 181, 255, 70, 120, 182, 255, 70, 120, 182, 255, 71, 121, 182, 255, 71, 121, 182, 255, 71, 122, 183, 255, 71, 122, 183, 255, 71, 123, 183, 255, 72, 123, 183, 255, 72, 123, 184, 255, 72, 124, 184, 255, 73, 124, 184, 255, 73, 125, 184, 255, 73, 125, 185, 255, 73, 126, 185, 255, 74, 126, 185, 255, 74, 127, 185, 255, 74, 127, 186, 255, 74, 127, 186, 255, 75, 128, 186, 255, 75, 128, 186, 255, 75, 129, 187, 255, 76, 129, 187, 255, 76, 130, 187, 255, 76, 130, 187, 255, 77, 131, 187, 255, 77, 131, 188, 255, 77, 131, 188, 255, 77, 132, 188, 255, 78, 132, 188, 255, 78, 133, 189, 255, 78, 133, 189, 255, 79, 134, 189, 255, 79, 134, 189, 255, 79, 135, 190, 255, 80, 135, 190, 255, 80, 135, 190, 255, 81, 136, 190, 255, 81, 136, 190, 255, 81, 137, 191, 255, 82, 137, 191, 255, 82, 138, 191, 255, 82, 138, 191, 255, 83, 138, 192, 255, 83, 139, 192, 255, 93, 151, 198, 255, 93, 151, 198, 255, 94, 151, 198, 255, 94, 152, 199, 255, 94, 152, 199, 255, 95, 153, 199, 255, 95, 153, 199, 255, 96, 154, 199, 255, 96, 154, 200, 255, 96, 154, 200, 255, 97, 155, 200, 255, 97, 155, 200, 255, 98, 156, 200, 255, 98, 156, 201, 255, 98, 157, 201, 255, 99, 157, 201, 255, 99, 158, 201, 255, 100, 158, 202, 255, 100, 158, 202, 255, 101, 159, 202, 255, 101, 159, 202, 255, 101, 160, 202, 255, 102, 160, 203, 255, 102, 161, 203, 255, 103, 161, 203, 255, 103, 161, 203, 255, 104, 162, 203, 255, 104, 162, 204, 255, 105, 163, 204, 255, 105, 163, 204, 255, 105, 164, 204, 255, 106, 164, 204, 255, 106, 164, 205, 255, 107, 165, 205, 255, 107, 165, 205, 255, 108, 166, 205, 255, 108, 166, 205, 255, 109, 167, 206, 255, 109, 167, 206, 255, 110, 167, 206, 255, 110, 168, 206, 255, 111, 168, 207, 255, 111, 169, 207, 255, 112, 169, 207, 255, 112, 170, 207, 255, 113, 170, 207, 255, 113, 170, 208, 255, 114, 171, 208, 255, 114, 171, 208, 255, 115, 172, 208, 255, 115, 172, 208, 255, 116, 173, 209, 255, 116, 173, 209, 255, 116, 173, 209, 255, 117, 174, 209, 255, 117, 174, 209, 255, 117, 174, 209, 255, 118, 175, 210, 255, 118, 175, 210, 255, 119, 175, 210, 255, 119, 176, 210, 255, 119, 176, 210, 255, 120, 176, 211, 255, 120, 177, 211, 255, 121, 177, 211, 255, 121, 177, 211, 255, 121, 178, 211, 255, 122, 178, 211, 255, 122, 178, 212, 255, 123, 179, 212, 255, 123, 179, 212, 255, 123, 180, 212, 255, 124, 180, 212, 255, 124, 180, 213, 255, 125, 181, 213, 255, 125, 181, 213, 255, 125, 181, 213, 255, 126, 182, 213, 255, 126, 182, 214, 255, 127, 182, 214, 255, 127, 183, 214, 255, 127, 183, 214, 255, 128, 183, 214, 255, 128, 184, 214, 255, 129, 184, 215, 255, 129, 184, 215, 255, 129, 185, 215, 255, 130, 185, 215, 255, 130, 185, 215, 255, 131, 186, 216, 255, 131, 186, 216, 255, 132, 186, 216, 255, 132, 187, 216, 255, 132, 187, 216, 255, 133, 187, 216, 255, 133, 188, 217, 255, 134, 188, 217, 255, 134, 189, 217, 255, 135, 189, 217, 255, 135, 189, 217, 255, 135, 190, 218, 255, 136, 190, 218, 255, 147, 199, 223, 255, 148, 199, 223, 255, 148, 200, 223, 255, 149, 200, 223, 255, 149, 200, 223, 255, 149, 201, 224, 255, 150, 201, 224, 255, 150, 201, 224, 255, 151, 202, 224, 255, 151, 202, 224, 255, 152, 202, 225, 255, 152, 203, 225, 255, 153, 203, 225, 255, 153, 204, 225, 255, 153, 204, 225, 255, 154, 204, 226, 255, 154, 205, 226, 255, 155, 205, 226, 255, 155, 205, 226, 255, 156, 206, 226, 255, 156, 206, 226, 255, 157, 206, 227, 255, 157, 207, 227, 255, 157, 207, 227, 255, 158, 207, 227, 255, 158, 208, 227, 255, 159, 208, 228, 255, 159, 208, 228, 255, 160, 209, 228, 255, 160, 209, 228, 255, 161, 209, 228, 255, 161, 210, 229, 255, 162, 210, 229, 255, 162, 210, 229, 255, 162, 211, 229, 255, 163, 211, 229, 255, 163, 211, 230, 255, 164, 212, 230, 255, 164, 212, 230, 255, 165, 212, 230, 255, 165, 213, 230, 255, 166, 213, 230, 255, 166, 213, 231, 255, 167, 214, 231, 255, 167, 214, 231, 255, 168, 214, 231, 255, 168, 215, 231, 255, 169, 215, 232, 255, 169, 215, 232, 255, 169, 216, 232, 255, 170, 216, 232, 255, 170, 216, 232, 255, 171, 217, 233, 255, 171, 217, 233, 255, 172, 217, 233, 255, 172, 217, 233, 255, 173, 217, 233, 255, 173, 218, 233, 255, 173, 218, 233, 255, 174, 218, 233, 255, 174, 218, 233, 255, 175, 219, 234, 255, 175, 219, 234, 255, 175, 219, 234, 255, 176, 219, 234, 255, 176, 219, 234, 255, 177, 220, 234, 255, 177, 220, 234, 255, 177, 220, 234, 255, 178, 220, 234, 255, 178, 220, 235, 255, 179, 221, 235, 255, 179, 221, 235, 255, 180, 221, 235, 255, 180, 221, 235, 255, 180, 221, 235, 255, 181, 222, 235, 255, 181, 222, 235, 255, 182, 222, 235, 255, 182, 222, 235, 255, 182, 222, 236, 255, 183, 223, 236, 255, 183, 223, 236, 255, 184, 223, 236, 255, 184, 223, 236, 255, 185, 223, 236, 255, 185, 224, 236, 255, 185, 224, 236, 255, 186, 224, 237, 255, 186, 224, 237, 255, 187, 224, 237, 255, 187, 225, 237, 255, 187, 225, 237, 255, 188, 225, 237, 255, 188, 225, 237, 255, 189, 225, 237, 255, 189, 226, 237, 255, 190, 226, 238, 255, 190, 226, 238, 255, 190, 226, 238, 255, 191, 226, 238, 255, 191, 227, 238, 255, 192, 227, 238, 255, 203, 232, 241, 255, 203, 232, 241, 255, 203, 233, 241, 255, 204, 233, 242, 255, 204, 233, 242, 255, 205, 233, 242, 255, 205, 234, 242, 255, 205, 234, 242, 255, 206, 234, 242, 255, 206, 234, 242, 255, 207, 234, 242, 255, 207, 235, 243, 255, 208, 235, 243, 255, 208, 235, 243, 255, 208, 235, 243, 255, 209, 235, 243, 255, 209, 236, 243, 255, 210, 236, 243, 255, 210, 236, 243, 255, 210, 236, 244, 255, 211, 236, 244, 255, 211, 237, 244, 255, 212, 237, 244, 255, 212, 237, 244, 255, 213, 237, 244, 255, 213, 237, 244, 255, 213, 238, 244, 255, 214, 238, 244, 255, 214, 238, 245, 255, 215, 238, 245, 255, 215, 238, 245, 255, 215, 239, 245, 255, 216, 239, 245, 255, 216, 239, 245, 255, 217, 239, 245, 255, 217, 239, 245, 255, 217, 240, 246, 255, 218, 240, 246, 255, 218, 240, 246, 255, 219, 240, 246, 255, 219, 240, 246, 255, 220, 241, 246, 255, 220, 241, 246, 255, 220, 241, 247, 255, 221, 241, 247, 255, 221, 241, 247, 255, 222, 242, 247, 255, 222, 242, 247, 255, 222, 242, 247, 255, 223, 242, 247, 255, 223, 242, 247, 255, 223, 243, 248, 255, 223, 243, 248, 255, 222, 243, 248, 255, 222, 243, 248, 255, 222, 243, 248, 255, 221, 244, 248, 255, 221, 244, 248, 255, 220, 244, 248, 255, 220, 244, 248, 255, 219, 245, 249, 255, 219, 245, 249, 255, 219, 245, 249, 255, 218, 245, 249, 255, 218, 246, 249, 255, 217, 246, 249, 255, 217, 246, 248, 255, 216, 246, 248, 255, 216, 246, 248, 255, 216, 247, 248, 255, 215, 247, 248, 255, 215, 247, 248, 255, 215, 247, 248, 255, 214, 248, 248, 255, 214, 248, 248, 255, 214, 248, 247, 255, 213, 248, 247, 255, 213, 248, 247, 255, 213, 249, 247, 255, 213, 249, 246, 255, 212, 249, 246, 255, 212, 249, 246, 255, 212, 249, 246, 255, 212, 250, 245, 255, 212, 250, 245, 255, 211, 250, 245, 255, 211, 250, 244, 255, 211, 250, 244, 255, 211, 251, 243, 255, 211, 251, 243, 255, 211, 251, 243, 255, 211, 251, 242, 255, 211, 251, 242, 255, 211, 251, 241, 255, 211, 252, 241, 255, 211, 252, 240, 255, 211, 252, 240, 255, 211, 252, 239, 255, 211, 252, 239, 255, 211, 252, 238, 255, 211, 252, 238, 255, 212, 252, 237, 255, 218, 255, 225, 255, 218, 255, 225, 255, 218, 255, 224, 255, 219, 255, 223, 255, 219, 255, 223, 255, 219, 255, 222, 255, 220, 255, 221, 255, 220, 255, 221, 255, 220, 255, 220, 255, 221, 255, 219, 255, 221, 255, 219, 255, 222, 255, 218, 255, 222, 255, 217, 255, 222, 255, 217, 255, 223, 255, 216, 255, 224, 255, 215, 255, 224, 255, 215, 255, 225, 255, 214, 255, 225, 255, 213, 255, 226, 255, 212, 255, 226, 255, 212, 255, 227, 255, 211, 255, 228, 255, 210, 255, 228, 255, 210, 255, 229, 255, 209, 255, 230, 255, 208, 255, 231, 255, 207, 255, 231, 255, 207, 255, 232, 255, 206, 255, 233, 255, 205, 255, 234, 255, 204, 255, 235, 255, 204, 255, 236, 255, 203, 255, 236, 255, 202, 255, 237, 255, 202, 255, 238, 255, 201, 255, 239, 255, 200, 255, 240, 255, 199, 255, 241, 255, 199, 255, 242, 255, 198, 255, 243, 255, 197, 255, 244, 255, 197, 255, 245, 255, 196, 255, 246, 255, 195, 255, 247, 255, 195, 255, 248, 255, 194, 255, 249, 255, 193, 255, 250, 255, 193, 255, 251, 255, 192, 255, 252, 255, 192, 255, 253, 255, 191, 255, 254, 255, 190, 255, 254, 254, 190, 255, 254, 254, 190, 255, 254, 254, 189, 255, 254, 254, 189, 255, 254, 253, 189, 255, 254, 253, 188, 255, 254, 253, 188, 255, 254, 253, 187, 255, 254, 252, 187, 255, 254, 252, 187, 255, 254, 252, 186, 255, 254, 252, 186, 255, 254, 252, 185, 255, 254, 251, 185, 255, 254, 251, 185, 255, 254, 251, 184, 255, 254, 251, 184, 255, 254, 250, 184, 255, 254, 250, 183, 255, 254, 250, 183, 255, 254, 250, 182, 255, 254, 249, 182, 255, 254, 249, 182, 255, 254, 249, 181, 255, 254, 249, 181, 255, 254, 248, 181, 255, 254, 248, 180, 255, 254, 248, 180, 255, 254, 248, 179, 255, 254, 248, 179, 255, 254, 247, 179, 255, 254, 247, 178, 255, 254, 247, 178, 255, 254, 247, 178, 255, 254, 246, 177, 255, 254, 246, 177, 255, 254, 246, 176, 255, 254, 246, 176, 255, 254, 245, 176, 255, 254, 245, 175, 255, 254, 245, 175, 255, 253, 245, 175, 255, 253, 244, 174, 255, 253, 244, 174, 255, 253, 244, 173, 255, 253, 244, 173, 255, 253, 243, 173, 255, 253, 243, 172, 255, 253, 243, 172, 255, 253, 243, 172, 255, 253, 243, 171, 255, 253, 236, 161, 255, 253, 236, 161, 255, 253, 236, 161, 255, 253, 235, 160, 255, 253, 235, 160, 255, 253, 235, 160, 255, 253, 235, 159, 255, 253, 234, 159, 255, 253, 234, 158, 255, 253, 234, 158, 255, 253, 234, 158, 255, 253, 233, 157, 255, 253, 233, 157, 255, 253, 233, 157, 255, 253, 233, 156, 255, 253, 232, 156, 255, 253, 232, 156, 255, 253, 232, 155, 255, 253, 232, 155, 255, 253, 231, 154, 255, 253, 231, 154, 255, 253, 231, 154, 255, 253, 231, 153, 255, 253, 230, 153, 255, 253, 230, 153, 255, 253, 230, 152, 255, 253, 230, 152, 255, 253, 229, 152, 255, 253, 229, 151, 255, 253, 229, 151, 255, 253, 229, 151, 255, 253, 228, 150, 255, 253, 228, 150, 255, 253, 228, 150, 255, 253, 228, 149, 255, 253, 227, 149, 255, 253, 227, 148, 255, 253, 227, 148, 255, 253, 227, 148, 255, 253, 226, 147, 255, 253, 226, 147, 255, 253, 226, 147, 255, 253, 226, 146, 255, 253, 225, 146, 255, 253, 225, 146, 255, 253, 225, 145, 255, 253, 225, 145, 255, 253, 224, 145, 255, 253, 224, 144, 255, 253, 224, 144, 255, 253, 224, 144, 255, 253, 223, 143, 255, 253, 223, 143, 255, 253, 223, 142, 255, 253, 222, 142, 255, 253, 222, 141, 255, 253, 221, 141, 255, 253, 221, 141, 255, 253, 221, 140, 255, 253, 220, 140, 255, 253, 220, 139, 255, 253, 220, 139, 255, 253, 219, 138, 255, 253, 219, 138, 255, 253, 218, 138, 255, 253, 218, 137, 255, 253, 218, 137, 255, 253, 217, 136, 255, 253, 217, 136, 255, 253, 217, 135, 255, 253, 216, 135, 255, 253, 216, 135, 255, 253, 215, 134, 255, 253, 215, 134, 255, 253, 215, 133, 255, 253, 214, 133, 255, 253, 214, 133, 255, 253, 214, 132, 255, 253, 213, 132, 255, 253, 213, 131, 255, 253, 212, 131, 255, 253, 212, 131, 255, 253, 212, 130, 255, 253, 211, 130, 255, 253, 211, 129, 255, 253, 211, 129, 255, 253, 210, 129, 255, 253, 210, 128, 255, 253, 209, 128, 255, 253, 209, 127, 255, 253, 209, 127, 255, 253, 208, 127, 255, 253, 208, 126, 255, 253, 207, 126, 255, 253, 207, 125, 255, 253, 207, 125, 255, 253, 206, 125, 255, 253, 206, 124, 255, 253, 205, 124, 255, 253, 205, 123, 255, 253, 205, 123, 255, 253, 204, 123, 255, 253, 194, 113, 255, 253, 194, 113, 255, 253, 193, 112, 255, 253, 193, 112, 255, 253, 192, 112, 255, 253, 192, 111, 255, 253, 192, 111, 255, 253, 191, 110, 255, 253, 191, 110, 255, 253, 190, 110, 255, 253, 190, 109, 255, 253, 190, 109, 255, 253, 189, 109, 255, 253, 189, 108, 255, 253, 188, 108, 255, 253, 188, 108, 255, 253, 188, 107, 255, 253, 187, 107, 255, 253, 187, 107, 255, 253, 186, 106, 255, 253, 186, 106, 255, 253, 186, 106, 255, 253, 185, 105, 255, 253, 185, 105, 255, 253, 184, 105, 255, 253, 184, 104, 255, 253, 184, 104, 255, 253, 183, 104, 255, 253, 183, 103, 255, 253, 182, 103, 255, 253, 182, 103, 255, 253, 182, 102, 255, 253, 181, 102, 255, 253, 181, 102, 255, 253, 180, 101, 255, 253, 180, 101, 255, 253, 180, 101, 255, 253, 179, 100, 255, 253, 179, 100, 255, 253, 178, 100, 255, 253, 178, 100, 255, 253, 178, 99, 255, 253, 177, 99, 255, 253, 177, 99, 255, 253, 176, 98, 255, 253, 176, 98, 255, 253, 175, 98, 255, 253, 175, 98, 255, 253, 175, 97, 255, 253, 174, 97, 255, 253, 174, 97, 255, 252, 173, 96, 255, 252, 173, 96, 255, 252, 172, 96, 255, 252, 172, 95, 255, 252, 172, 95, 255, 252, 171, 95, 255, 252, 171, 94, 255, 252, 170, 94, 255, 252, 170, 94, 255, 252, 169, 93, 255, 252, 169, 93, 255, 252, 168, 93, 255, 252, 168, 92, 255, 252, 167, 92, 255, 252, 167, 92, 255, 252, 166, 91, 255, 252, 166, 91, 255, 252, 165, 91, 255, 251, 165, 90, 255, 251, 164, 90, 255, 251, 164, 90, 255, 251, 163, 89, 255, 251, 163, 89, 255, 251, 162, 89, 255, 251, 162, 89, 255, 251, 162, 88, 255, 251, 161, 88, 255, 251, 161, 88, 255, 251, 160, 87, 255, 251, 160, 87, 255, 251, 159, 87, 255, 251, 159, 87, 255, 251, 158, 86, 255, 251, 158, 86, 255, 251, 157, 86, 255, 250, 157, 85, 255, 250, 156, 85, 255, 250, 156, 85, 255, 250, 155, 85, 255, 250, 155, 84, 255, 250, 154, 84, 255, 250, 154, 84, 255, 250, 153, 84, 255, 250, 153, 83, 255, 250, 152, 83, 255, 250, 152, 83, 255, 250, 151, 83, 255, 250, 151, 82, 255, 250, 150, 82, 255, 250, 150, 82, 255, 249, 149, 82, 255, 248, 136, 75, 255, 248, 135, 75, 255, 247, 135, 75, 255, 247, 134, 75, 255, 247, 134, 74, 255, 247, 133, 74, 255, 247, 133, 74, 255, 247, 132, 74, 255, 247, 132, 74, 255, 247, 131, 73, 255, 247, 131, 73, 255, 247, 130, 73, 255, 247, 130, 73, 255, 247, 129, 72, 255, 247, 129, 72, 255, 247, 128, 72, 255, 246, 128, 72, 255, 246, 127, 72, 255, 246, 126, 71, 255, 246, 126, 71, 255, 246, 125, 71, 255, 246, 125, 71, 255, 246, 124, 71, 255, 246, 124, 71, 255, 246, 123, 70, 255, 246, 123, 70, 255, 246, 122, 70, 255, 246, 122, 70, 255, 246, 121, 70, 255, 245, 121, 70, 255, 245, 120, 69, 255, 245, 120, 69, 255, 245, 119, 69, 255, 245, 119, 69, 255, 245, 118, 69, 255, 245, 117, 69, 255, 245, 117, 68, 255, 245, 116, 68, 255, 245, 116, 68, 255, 245, 115, 68, 255, 245, 115, 68, 255, 244, 114, 68, 255, 244, 114, 68, 255, 244, 113, 67, 255, 244, 113, 67, 255, 244, 112, 67, 255, 244, 111, 67, 255, 244, 111, 67, 255, 244, 110, 67, 255, 244, 110, 67, 255, 244, 109, 67, 255, 244, 109, 67, 255, 243, 108, 66, 255, 243, 108, 66, 255, 243, 107, 66, 255, 243, 107, 66, 255, 242, 107, 65, 255, 242, 106, 65, 255, 242, 106, 65, 255, 242, 105, 65, 255, 242, 105, 64, 255, 241, 104, 64, 255, 241, 104, 64, 255, 241, 104, 64, 255, 241, 103, 63, 255, 240, 103, 63, 255, 240, 102, 63, 255, 240, 102, 63, 255, 240, 101, 62, 255, 240, 101, 62, 255, 239, 101, 62, 255, 239, 100, 62, 255, 239, 100, 61, 255, 239, 99, 61, 255, 238, 99, 61, 255, 238, 98, 61, 255, 238, 98, 60, 255, 238, 98, 60, 255, 238, 97, 60, 255, 237, 97, 60, 255, 237, 96, 60, 255, 237, 96, 59, 255, 237, 95, 59, 255, 236, 95, 59, 255, 236, 95, 59, 255, 236, 94, 58, 255, 236, 94, 58, 255, 236, 93, 58, 255, 235, 93, 58, 255, 235, 92, 57, 255, 235, 92, 57, 255, 235, 91, 57, 255, 234, 91, 57, 255, 234, 91, 57, 255, 234, 90, 56, 255, 234, 90, 56, 255, 234, 89, 56, 255, 233, 89, 56, 255, 233, 88, 55, 255, 233, 88, 55, 255, 233, 87, 55, 255, 232, 87, 55, 255, 232, 86, 55, 255, 226, 74, 49, 255, 226, 73, 49, 255, 226, 73, 48, 255, 225, 72, 48, 255, 225, 72, 48, 255, 225, 72, 48, 255, 225, 71, 47, 255, 225, 71, 47, 255, 224, 70, 47, 255, 224, 70, 47, 255, 224, 69, 47, 255, 224, 69, 46, 255, 223, 68, 46, 255, 223, 68, 46, 255, 223, 67, 46, 255, 223, 67, 46, 255, 223, 66, 45, 255, 222, 66, 45, 255, 222, 65, 45, 255, 222, 65, 45, 255, 222, 64, 44, 255, 221, 64, 44, 255, 221, 63, 44, 255, 221, 63, 44, 255, 221, 62, 44, 255, 220, 62, 43, 255, 220, 61, 43, 255, 220, 61, 43, 255, 220, 60, 43, 255, 220, 60, 43, 255, 219, 59, 42, 255, 219, 59, 42, 255, 219, 58, 42, 255, 219, 58, 42, 255, 218, 57, 42, 255, 218, 57, 41, 255, 218, 56, 41, 255, 218, 55, 41, 255, 217, 55, 41, 255, 217, 54, 41, 255, 217, 54, 41, 255, 217, 53, 40, 255, 217, 53, 40, 255, 216, 52, 40, 255, 216, 51, 40, 255, 216, 51, 40, 255, 216, 50, 39, 255, 215, 50, 39, 255, 215, 49, 39, 255, 215, 48, 39, 255, 215, 48, 39, 255, 214, 47, 39, 255, 214, 47, 39, 255, 214, 47, 39, 255, 213, 46, 39, 255, 213, 46, 39, 255, 212, 46, 39, 255, 212, 45, 39, 255, 212, 45, 39, 255, 211, 45, 39, 255, 211, 45, 39, 255, 211, 44, 39, 255, 210, 44, 39, 255, 210, 44, 39, 255, 209, 43, 39, 255, 209, 43, 39, 255, 209, 43, 39, 255, 208, 42, 39, 255, 208, 42, 39, 255, 207, 42, 39, 255, 207, 41, 39, 255, 207, 41, 39, 255, 206, 41, 39, 255, 206, 40, 39, 255, 206, 40, 39, 255, 205, 40, 39, 255, 205, 39, 39, 255, 204, 39, 39, 255, 204, 39, 39, 255, 204, 38, 39, 255, 203, 38, 39, 255, 203, 38, 39, 255, 202, 37, 39, 255, 202, 37, 39, 255, 202, 37, 39, 255, 201, 36, 39, 255, 201, 36, 39, 255, 200, 36, 39, 255, 200, 35, 39, 255, 200, 35, 39, 255, 199, 35, 39, 255, 199, 34, 39, 255, 199, 34, 39, 255, 198, 34, 39, 255, 198, 33, 39, 255, 197, 33, 39, 255, 197, 33, 39, 255, 197, 32, 39, 255, 196, 32, 39, 255, 196, 32, 39, 255, 195, 31, 39, 255, 195, 31, 39, 255, 185, 21, 39, 255, 184, 21, 39, 255, 184, 20, 39, 255, 183, 20, 39, 255, 183, 20, 39, 255, 183, 19, 39, 255, 182, 19, 39, 255, 182, 19, 39, 255, 181, 18, 39, 255, 181, 18, 39, 255, 181, 17, 39, 255, 180, 17, 39, 255, 180, 17, 39, 255, 180, 16, 39, 255, 179, 16, 39, 255, 179, 16, 38, 255, 178, 15, 38, 255, 178, 15, 38, 255, 178, 14, 38, 255, 177, 14, 38, 255, 177, 14, 38, 255, 176, 13, 38, 255, 176, 13, 38, 255, 176, 12, 38, 255, 175, 12, 38, 255, 175, 11, 38, 255, 174, 11, 38, 255, 174, 11, 38, 255, 174, 10, 38, 255, 173, 10, 38, 255, 173, 9, 38, 255, 172, 9, 38, 255, 172, 8, 38, 255, 172, 8, 38, 255, 171, 7, 38, 255, 171, 7, 38, 255, 170, 6, 38, 255, 170, 6, 38, 255, 170, 5, 38, 255, 169, 5, 38, 255, 169, 4, 38, 255, 168, 4, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 166, 2, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_RdYlBu_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 49, 54, 149, 0, 48, 59, 152, 24, 47, 64, 155, 49, 47, 69, 158, 74, 48, 74, 160, 99, 49, 79, 163, 124, 54, 96, 171, 149, 56, 100, 173, 174, 59, 105, 175, 199, 62, 109, 177, 224, 66, 113, 178, 249, 69, 118, 180, 255, 71, 122, 183, 255, 73, 126, 185, 255, 76, 130, 187, 255, 79, 133, 189, 255, 82, 137, 191, 255, 94, 152, 199, 255, 98, 156, 201, 255, 101, 160, 202, 255, 105, 163, 204, 255, 109, 167, 206, 255, 113, 170, 208, 255, 117, 174, 209, 255, 120, 176, 211, 255, 123, 179, 212, 255, 126, 182, 214, 255, 130, 185, 215, 255, 133, 187, 216, 255, 136, 190, 218, 255, 150, 202, 224, 255, 154, 204, 226, 255, 157, 207, 227, 255, 161, 209, 228, 255, 164, 212, 230, 255, 167, 214, 231, 255, 171, 217, 233, 255, 174, 218, 233, 255, 177, 220, 234, 255, 180, 221, 235, 255, 183, 223, 236, 255, 186, 224, 236, 255, 188, 225, 237, 255, 191, 227, 238, 255, 205, 233, 242, 255, 207, 235, 243, 255, 210, 236, 243, 255, 213, 237, 244, 255, 216, 239, 245, 255, 218, 240, 246, 255, 221, 241, 247, 255, 223, 243, 248, 255, 221, 244, 248, 255, 218, 245, 249, 255, 216, 247, 248, 255, 214, 248, 247, 255, 212, 249, 246, 255, 211, 250, 244, 255, 211, 251, 241, 255, 211, 252, 238, 255, 219, 255, 223, 255, 221, 255, 220, 255, 223, 255, 216, 255, 227, 255, 212, 255, 231, 255, 207, 255, 235, 255, 203, 255, 240, 255, 199, 255, 245, 255, 196, 255, 251, 255, 192, 255, 254, 254, 190, 255, 254, 253, 188, 255, 254, 252, 186, 255, 254, 250, 184, 255, 254, 249, 182, 255, 254, 248, 180, 255, 254, 247, 178, 255, 254, 246, 176, 255, 253, 244, 174, 255, 253, 243, 172, 255, 253, 236, 161, 255, 253, 235, 159, 255, 253, 233, 157, 255, 253, 232, 156, 255, 253, 231, 154, 255, 253, 230, 152, 255, 253, 229, 151, 255, 253, 228, 149, 255, 253, 227, 148, 255, 253, 225, 146, 255, 253, 224, 144, 255, 253, 223, 143, 255, 253, 221, 141, 255, 253, 220, 139, 255, 253, 218, 137, 255, 253, 217, 135, 255, 253, 215, 134, 255, 253, 213, 132, 255, 253, 212, 130, 255, 253, 210, 129, 255, 253, 209, 127, 255, 253, 207, 126, 255, 253, 206, 124, 255, 253, 204, 123, 255, 253, 193, 112, 255, 253, 191, 110, 255, 253, 190, 109, 255, 253, 188, 108, 255, 253, 187, 106, 255, 253, 185, 105, 255, 253, 184, 104, 255, 253, 182, 103, 255, 253, 181, 102, 255, 253, 179, 101, 255, 253, 178, 100, 255, 253, 177, 99, 255, 253, 175, 98, 255, 253, 174, 97, 255, 252, 172, 95, 255, 252, 171, 94, 255, 252, 169, 93, 255, 252, 167, 92, 255, 252, 166, 91, 255, 251, 164, 90, 255, 251, 163, 89, 255, 251, 161, 88, 255, 251, 160, 87, 255, 251, 158, 86, 255, 250, 157, 86, 255, 250, 155, 85, 255, 250, 154, 84, 255, 250, 152, 83, 255, 250, 151, 82, 255, 250, 149, 82, 255, 248, 135, 75, 255, 247, 134, 74, 255, 247, 132, 74, 255, 247, 131, 73, 255, 247, 129, 73, 255, 247, 128, 72, 255, 246, 127, 72, 255, 246, 125, 71, 255, 246, 124, 71, 255, 246, 122, 70, 255, 245, 121, 70, 255, 245, 120, 69, 255, 245, 118, 69, 255, 245, 117, 68, 255, 245, 116, 68, 255, 244, 114, 68, 255, 244, 113, 67, 255, 244, 111, 67, 255, 244, 110, 67, 255, 244, 109, 67, 255, 243, 108, 66, 255, 243, 107, 65, 255, 242, 106, 65, 255, 242, 105, 64, 255, 241, 104, 64, 255, 241, 103, 63, 255, 240, 102, 63, 255, 240, 101, 62, 255, 239, 100, 62, 255, 239, 99, 61, 255, 238, 98, 61, 255, 238, 97, 60, 255, 237, 97, 60, 255, 237, 96, 59, 255, 236, 95, 59, 255, 236, 94, 58, 255, 235, 93, 58, 255, 235, 92, 57, 255, 235, 91, 57, 255, 234, 90, 57, 255, 234, 90, 56, 255, 233, 89, 56, 255, 233, 88, 55, 255, 232, 87, 55, 255, 226, 74, 49, 255, 226, 73, 48, 255, 225, 72, 48, 255, 225, 72, 48, 255, 225, 71, 47, 255, 224, 70, 47, 255, 224, 69, 47, 255, 223, 68, 46, 255, 223, 68, 46, 255, 223, 67, 46, 255, 222, 66, 45, 255, 222, 65, 45, 255, 222, 64, 45, 255, 221, 64, 44, 255, 221, 63, 44, 255, 221, 62, 44, 255, 220, 61, 43, 255, 220, 60, 43, 255, 219, 60, 43, 255, 219, 59, 42, 255, 219, 58, 42, 255, 218, 57, 42, 255, 218, 56, 41, 255, 218, 56, 41, 255, 217, 55, 41, 255, 217, 54, 41, 255, 217, 53, 40, 255, 217, 53, 40, 255, 216, 52, 40, 255, 216, 51, 40, 255, 216, 50, 39, 255, 215, 50, 39, 255, 215, 49, 39, 255, 215, 48, 39, 255, 214, 47, 39, 255, 214, 47, 39, 255, 213, 47, 39, 255, 213, 46, 39, 255, 212, 46, 39, 255, 212, 45, 39, 255, 212, 45, 39, 255, 211, 45, 39, 255, 211, 44, 39, 255, 210, 44, 39, 255, 210, 44, 39, 255, 209, 43, 39, 255, 209, 43, 39, 255, 209, 43, 39, 255, 208, 42, 39, 255, 208, 42, 39, 255, 207, 41, 39, 255, 207, 41, 39, 255, 206, 41, 39, 255, 206, 40, 39, 255, 206, 40, 39, 255, 205, 40, 39, 255, 205, 40, 39, 255, 205, 39, 39, 255, 204, 39, 39, 255, 204, 39, 39, 255, 203, 38, 39, 255, 203, 38, 39, 255, 203, 38, 39, 255, 202, 37, 39, 255, 202, 37, 39, 255, 202, 37, 39, 255, 201, 36, 39, 255, 201, 36, 39, 255, 201, 36, 39, 255, 200, 36, 39, 255, 200, 35, 39, 255, 200, 35, 39, 255, 199, 35, 39, 255, 199, 35, 39, 255, 199, 34, 39, 255, 198, 34, 39, 255, 198, 34, 39, 255, 198, 33, 39, 255, 198, 33, 39, 255, 197, 33, 39, 255, 197, 33, 39, 255, 197, 32, 39, 255, 196, 32, 39, 255, 196, 32, 39, 255, 196, 32, 39, 255, 196, 31, 39, 255, 195, 31, 39, 255, 195, 31, 39, 255, 195, 31, 39, 255, 184, 21, 39, 255, 184, 21, 39, 255, 184, 20, 39, 255, 184, 20, 39, 255, 183, 20, 39, 255, 183, 20, 39, 255, 183, 20, 39, 255, 183, 19, 39, 255, 182, 19, 39, 255, 182, 19, 39, 255, 182, 19, 39, 255, 182, 18, 39, 255, 182, 18, 39, 255, 181, 18, 39, 255, 181, 18, 39, 255, 181, 18, 39, 255, 181, 17, 39, 255, 180, 17, 39, 255, 180, 17, 39, 255, 180, 17, 39, 255, 180, 17, 39, 255, 180, 16, 39, 255, 179, 16, 39, 255, 179, 16, 39, 255, 179, 16, 39, 255, 179, 16, 38, 255, 179, 15, 38, 255, 178, 15, 38, 255, 178, 15, 38, 255, 178, 15, 38, 255, 178, 15, 38, 255, 178, 14, 38, 255, 178, 14, 38, 255, 177, 14, 38, 255, 177, 14, 38, 255, 177, 14, 38, 255, 177, 14, 38, 255, 177, 13, 38, 255, 176, 13, 38, 255, 176, 13, 38, 255, 176, 13, 38, 255, 176, 13, 38, 255, 176, 13, 38, 255, 176, 12, 38, 255, 176, 12, 38, 255, 175, 12, 38, 255, 175, 12, 38, 255, 175, 12, 38, 255, 175, 12, 38, 255, 175, 11, 38, 255, 175, 11, 38, 255, 174, 11, 38, 255, 174, 11, 38, 255, 174, 11, 38, 255, 174, 11, 38, 255, 174, 11, 38, 255, 174, 10, 38, 255, 174, 10, 38, 255, 174, 10, 38, 255, 173, 10, 38, 255, 173, 10, 38, 255, 173, 10, 38, 255, 173, 9, 38, 255, 173, 9, 38, 255, 173, 9, 38, 255, 173, 9, 38, 255, 173, 9, 38, 255, 172, 9, 38, 255, 172, 9, 38, 255, 172, 8, 38, 255, 172, 8, 38, 255, 172, 8, 38, 255, 172, 8, 38, 255, 172, 8, 38, 255, 172, 8, 38, 255, 172, 8, 38, 255, 171, 8, 38, 255, 171, 7, 38, 255, 171, 7, 38, 255, 171, 7, 38, 255, 171, 7, 38, 255, 171, 7, 38, 255, 171, 7, 38, 255, 171, 7, 38, 255, 171, 7, 38, 255, 171, 6, 38, 255, 171, 6, 38, 255, 170, 6, 38, 255, 170, 6, 38, 255, 170, 6, 38, 255, 170, 6, 38, 255, 170, 6, 38, 255, 170, 6, 38, 255, 170, 6, 38, 255, 170, 5, 38, 255, 170, 5, 38, 255, 170, 5, 38, 255, 170, 5, 38, 255, 170, 5, 38, 255, 169, 5, 38, 255, 169, 5, 38, 255, 169, 5, 38, 255, 169, 5, 38, 255, 169, 5, 38, 255, 169, 5, 38, 255, 169, 4, 38, 255, 169, 4, 38, 255, 169, 4, 38, 255, 169, 4, 38, 255, 169, 4, 38, 255, 169, 4, 38, 255, 169, 4, 38, 255, 169, 4, 38, 255, 168, 4, 38, 255, 168, 4, 38, 255, 168, 4, 38, 255, 168, 4, 38, 255, 168, 4, 38, 255, 168, 4, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 167, 3, 38, 255, 167, 3, 38, 255, 167, 3, 38, 255, 167, 3, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 166, 2, 38, 255, 166, 2, 38, 255, 166, 2, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 165, 1, 38, 255, 165, 1, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_RdYlBu_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
