/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/PiYG.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 39, 100, 25, 255, 77, 146, 33, 255, 127, 188, 65, 255, 184, 225, 134, 255, 230, 245, 208, 255, 247, 247, 247, 255, 253, 224, 239, 255, 241, 182, 218, 255, 222, 119, 174, 255, 197, 27, 125, 255, 142, 1, 82, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PiYG_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 39, 100, 24, 0, 39, 100, 25, 7, 39, 100, 25, 14, 40, 101, 25, 22, 40, 101, 25, 29, 40, 102, 25, 37, 41, 102, 25, 44, 41, 103, 25, 52, 41, 103, 25, 59, 42, 103, 25, 67, 42, 104, 25, 74, 42, 104, 26, 82, 43, 105, 26, 89, 43, 105, 26, 97, 43, 106, 26, 104, 44, 106, 26, 112, 44, 107, 26, 119, 44, 107, 26, 127, 45, 107, 26, 134, 45, 108, 26, 141, 45, 108, 26, 149, 46, 109, 26, 156, 46, 109, 27, 164, 46, 110, 27, 171, 47, 110, 27, 179, 47, 111, 27, 186, 47, 111, 27, 194, 48, 111, 27, 201, 48, 112, 27, 209, 48, 112, 27, 216, 49, 113, 27, 224, 49, 113, 27, 231, 50, 114, 27, 239, 50, 114, 28, 246, 50, 115, 28, 254, 51, 115, 28, 255, 51, 115, 28, 255, 51, 116, 28, 255, 52, 116, 28, 255, 52, 117, 28, 255, 52, 117, 28, 255, 53, 118, 28, 255, 53, 118, 28, 255, 54, 119, 28, 255, 54, 119, 28, 255, 54, 119, 29, 255, 55, 120, 29, 255, 55, 120, 29, 255, 55, 121, 29, 255, 56, 121, 29, 255, 56, 122, 29, 255, 56, 122, 29, 255, 57, 123, 29, 255, 57, 123, 29, 255, 58, 123, 29, 255, 58, 124, 29, 255, 58, 124, 29, 255, 59, 125, 30, 255, 59, 125, 30, 255, 59, 126, 30, 255, 60, 126, 30, 255, 60, 127, 30, 255, 61, 127, 30, 255, 61, 128, 30, 255, 61, 128, 30, 255, 62, 128, 30, 255, 62, 129, 30, 255, 63, 129, 30, 255, 63, 130, 30, 255, 63, 130, 30, 255, 64, 131, 30, 255, 64, 131, 31, 255, 64, 132, 31, 255, 65, 132, 31, 255, 65, 133, 31, 255, 66, 133, 31, 255, 66, 133, 31, 255, 66, 134, 31, 255, 67, 134, 31, 255, 67, 135, 31, 255, 68, 135, 31, 255, 68, 136, 31, 255, 68, 136, 31, 255, 69, 137, 31, 255, 69, 137, 31, 255, 70, 138, 31, 255, 70, 138, 32, 255, 70, 138, 32, 255, 71, 139, 32, 255, 71, 139, 32, 255, 71, 140, 32, 255, 72, 140, 32, 255, 72, 141, 32, 255, 73, 141, 32, 255, 73, 142, 32, 255, 74, 142, 32, 255, 74, 143, 32, 255, 74, 143, 32, 255, 75, 143, 32, 255, 75, 144, 32, 255, 76, 144, 32, 255, 76, 145, 32, 255, 76, 145, 32, 255, 77, 146, 33, 255, 77, 146, 33, 255, 78, 147, 33, 255, 78, 147, 34, 255, 79, 147, 34, 255, 79, 148, 34, 255, 80, 148, 35, 255, 80, 149, 35, 255, 81, 149, 35, 255, 81, 149, 36, 255, 82, 150, 36, 255, 82, 150, 36, 255, 83, 151, 37, 255, 83, 151, 37, 255, 84, 151, 37, 255, 84, 152, 37, 255, 85, 152, 38, 255, 85, 153, 38, 255, 86, 153, 38, 255, 86, 153, 39, 255, 87, 154, 39, 255, 87, 154, 39, 255, 88, 155, 40, 255, 88, 155, 40, 255, 89, 155, 40, 255, 89, 156, 41, 255, 89, 156, 41, 255, 90, 157, 41, 255, 90, 157, 42, 255, 91, 157, 42, 255, 91, 158, 42, 255, 92, 158, 43, 255, 92, 159, 43, 255, 93, 159, 43, 255, 93, 160, 43, 255, 94, 160, 44, 255, 94, 160, 44, 255, 95, 161, 44, 255, 95, 161, 45, 255, 96, 162, 45, 255, 96, 162, 45, 255, 97, 162, 46, 255, 97, 163, 46, 255, 98, 163, 46, 255, 98, 164, 47, 255, 99, 164, 47, 255, 99, 164, 47, 255, 100, 165, 48, 255, 100, 165, 48, 255, 101, 166, 48, 255, 101, 166, 48, 255, 102, 166, 49, 255, 102, 167, 49, 255, 103, 167, 49, 255, 103, 168, 50, 255, 104, 168, 50, 255, 104, 169, 50, 255, 105, 169, 51, 255, 105, 169, 51, 255, 106, 170, 51, 255, 106, 170, 52, 255, 107, 171, 52, 255, 107, 171, 52, 255, 107, 171, 52, 255, 108, 172, 53, 255, 108, 172, 53, 255, 109, 173, 53, 255, 109, 173, 54, 255, 110, 173, 54, 255, 110, 174, 54, 255, 111, 174, 55, 255, 111, 175, 55, 255, 112, 175, 55, 255, 112, 176, 56, 255, 113, 176, 56, 255, 113, 176, 56, 255, 114, 177, 57, 255, 114, 177, 57, 255, 115, 178, 57, 255, 115, 178, 57, 255, 116, 178, 58, 255, 116, 179, 58, 255, 117, 179, 58, 255, 117, 180, 59, 255, 118, 180, 59, 255, 118, 181, 59, 255, 119, 181, 60, 255, 119, 181, 60, 255, 120, 182, 60, 255, 120, 182, 61, 255, 121, 183, 61, 255, 121, 183, 61, 255, 122, 183, 61, 255, 122, 184, 62, 255, 123, 184, 62, 255, 123, 185, 62, 255, 124, 185, 63, 255, 124, 185, 63, 255, 125, 186, 63, 255, 125, 186, 64, 255, 126, 187, 64, 255, 126, 187, 64, 255, 127, 188, 65, 255, 127, 188, 65, 255, 128, 188, 66, 255, 128, 189, 67, 255, 129, 189, 68, 255, 130, 189, 68, 255, 130, 190, 69, 255, 131, 190, 70, 255, 131, 190, 70, 255, 132, 191, 71, 255, 132, 191, 72, 255, 133, 192, 72, 255, 134, 192, 73, 255, 134, 192, 74, 255, 135, 193, 75, 255, 135, 193, 75, 255, 136, 193, 76, 255, 136, 194, 77, 255, 137, 194, 77, 255, 138, 194, 78, 255, 138, 195, 79, 255, 139, 195, 79, 255, 139, 195, 80, 255, 140, 196, 81, 255, 140, 196, 81, 255, 141, 197, 82, 255, 141, 197, 83, 255, 142, 197, 83, 255, 143, 198, 84, 255, 143, 198, 85, 255, 144, 198, 85, 255, 144, 199, 86, 255, 145, 199, 87, 255, 145, 199, 88, 255, 146, 200, 88, 255, 147, 200, 89, 255, 147, 200, 90, 255, 148, 201, 90, 255, 148, 201, 91, 255, 149, 202, 92, 255, 149, 202, 92, 255, 150, 202, 93, 255, 150, 203, 94, 255, 151, 203, 94, 255, 152, 203, 95, 255, 152, 204, 96, 255, 153, 204, 96, 255, 153, 204, 97, 255, 154, 205, 98, 255, 154, 205, 98, 255, 155, 206, 99, 255, 155, 206, 100, 255, 156, 206, 100, 255, 157, 207, 101, 255, 157, 207, 102, 255, 158, 207, 102, 255, 158, 208, 103, 255, 159, 208, 104, 255, 159, 208, 104, 255, 160, 209, 105, 255, 160, 209, 106, 255, 161, 210, 106, 255, 162, 210, 107, 255, 162, 210, 108, 255, 163, 211, 108, 255, 163, 211, 109, 255, 164, 211, 110, 255, 164, 212, 110, 255, 165, 212, 111, 255, 165, 212, 112, 255, 166, 213, 112, 255, 167, 213, 113, 255, 167, 214, 114, 255, 168, 214, 114, 255, 168, 214, 115, 255, 169, 215, 116, 255, 169, 215, 116, 255, 170, 215, 117, 255, 170, 216, 117, 255, 171, 216, 118, 255, 171, 216, 119, 255, 172, 217, 119, 255, 173, 217, 120, 255, 173, 218, 121, 255, 174, 218, 121, 255, 174, 218, 122, 255, 175, 219, 123, 255, 175, 219, 123, 255, 176, 219, 124, 255, 176, 220, 125, 255, 177, 220, 125, 255, 177, 220, 126, 255, 178, 221, 127, 255, 179, 221, 127, 255, 179, 222, 128, 255, 180, 222, 129, 255, 180, 222, 129, 255, 181, 223, 130, 255, 181, 223, 131, 255, 182, 223, 131, 255, 182, 224, 132, 255, 183, 224, 133, 255, 183, 224, 133, 255, 184, 225, 134, 255, 184, 225, 135, 255, 185, 225, 136, 255, 185, 225, 136, 255, 186, 225, 137, 255, 186, 226, 138, 255, 187, 226, 138, 255, 187, 226, 139, 255, 188, 226, 140, 255, 188, 226, 141, 255, 189, 227, 141, 255, 189, 227, 142, 255, 190, 227, 143, 255, 190, 227, 144, 255, 190, 227, 144, 255, 191, 228, 145, 255, 191, 228, 146, 255, 192, 228, 146, 255, 192, 228, 147, 255, 193, 228, 148, 255, 193, 229, 149, 255, 194, 229, 149, 255, 194, 229, 150, 255, 195, 229, 151, 255, 195, 229, 151, 255, 196, 230, 152, 255, 196, 230, 153, 255, 197, 230, 154, 255, 197, 230, 154, 255, 197, 230, 155, 255, 198, 231, 156, 255, 198, 231, 156, 255, 199, 231, 157, 255, 199, 231, 158, 255, 200, 231, 159, 255, 200, 232, 159, 255, 201, 232, 160, 255, 201, 232, 161, 255, 202, 232, 162, 255, 202, 232, 162, 255, 202, 233, 163, 255, 203, 233, 164, 255, 203, 233, 164, 255, 204, 233, 165, 255, 204, 233, 166, 255, 205, 233, 167, 255, 205, 234, 167, 255, 206, 234, 168, 255, 206, 234, 169, 255, 207, 234, 169, 255, 207, 234, 170, 255, 207, 235, 171, 255, 208, 235, 172, 255, 208, 235, 172, 255, 209, 235, 173, 255, 209, 235, 174, 255, 210, 236, 175, 255, 210, 236, 175, 255, 211, 236, 176, 255, 211, 236, 177, 255, 211, 236, 177, 255, 212, 237, 178, 255, 212, 237, 179, 255, 213, 237, 180, 255, 213, 237, 180, 255, 214, 237, 181, 255, 214, 238, 182, 255, 215, 238, 182, 255, 215, 238, 183, 255, 215, 238, 184, 255, 216, 238, 185, 255, 216, 239, 185, 255, 217, 239, 186, 255, 217, 239, 187, 255, 218, 239, 187, 255, 218, 239, 188, 255, 218, 240, 189, 255, 219, 240, 190, 255, 219, 240, 190, 255, 220, 240, 191, 255, 220, 240, 192, 255, 221, 241, 193, 255, 221, 241, 193, 255, 222, 241, 194, 255, 222, 241, 195, 255, 222, 241, 195, 255, 223, 241, 196, 255, 223, 242, 197, 255, 224, 242, 198, 255, 224, 242, 198, 255, 225, 242, 199, 255, 225, 242, 200, 255, 225, 243, 201, 255, 226, 243, 201, 255, 226, 243, 202, 255, 227, 243, 203, 255, 227, 243, 203, 255, 228, 244, 204, 255, 228, 244, 205, 255, 228, 244, 206, 255, 229, 244, 206, 255, 229, 244, 207, 255, 230, 244, 207, 255, 231, 244, 207, 255, 232, 244, 207, 255, 233, 244, 207, 255, 234, 244, 207, 255, 235, 243, 207, 255, 236, 243, 208, 255, 237, 243, 208, 255, 238, 243, 208, 255, 239, 243, 208, 255, 240, 243, 208, 255, 241, 242, 208, 255, 241, 242, 208, 255, 242, 242, 209, 255, 243, 242, 209, 255, 244, 242, 209, 255, 245, 242, 209, 255, 245, 241, 210, 255, 246, 241, 210, 255, 247, 241, 210, 255, 248, 241, 211, 255, 248, 241, 211, 255, 249, 241, 211, 255, 250, 241, 212, 255, 250, 241, 212, 255, 251, 240, 212, 255, 251, 240, 213, 255, 252, 240, 213, 255, 252, 240, 214, 255, 253, 240, 214, 255, 253, 240, 215, 255, 254, 240, 215, 255, 254, 240, 216, 255, 255, 240, 216, 255, 255, 240, 217, 255, 255, 240, 217, 255, 255, 239, 218, 255, 255, 239, 218, 255, 255, 239, 219, 255, 255, 239, 219, 255, 255, 239, 220, 255, 255, 239, 220, 255, 255, 239, 221, 255, 255, 239, 222, 255, 255, 239, 222, 255, 255, 239, 223, 255, 255, 239, 223, 255, 255, 239, 224, 255, 255, 239, 224, 255, 255, 239, 225, 255, 255, 239, 226, 255, 255, 239, 226, 255, 255, 239, 227, 255, 255, 239, 227, 255, 255, 239, 228, 255, 255, 239, 229, 255, 255, 239, 229, 255, 255, 240, 230, 255, 255, 240, 230, 255, 255, 240, 231, 255, 255, 240, 231, 255, 255, 240, 232, 255, 255, 240, 233, 255, 255, 240, 233, 255, 255, 240, 234, 255, 255, 240, 234, 255, 255, 240, 235, 255, 255, 240, 235, 255, 255, 241, 236, 255, 255, 241, 236, 255, 255, 241, 237, 255, 255, 241, 237, 255, 255, 241, 238, 255, 255, 241, 238, 255, 255, 241, 239, 255, 255, 242, 239, 255, 255, 242, 240, 255, 255, 242, 240, 255, 255, 242, 241, 255, 255, 242, 241, 255, 254, 242, 241, 255, 254, 243, 242, 255, 254, 243, 242, 255, 253, 243, 242, 255, 253, 243, 243, 255, 252, 243, 243, 255, 252, 243, 243, 255, 252, 244, 244, 255, 251, 244, 244, 255, 251, 244, 244, 255, 251, 244, 245, 255, 250, 244, 245, 255, 250, 245, 245, 255, 250, 245, 245, 255, 249, 245, 245, 255, 249, 245, 246, 255, 249, 245, 246, 255, 248, 246, 246, 255, 248, 246, 246, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 246, 247, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 245, 246, 255, 247, 245, 246, 255, 247, 245, 246, 255, 247, 245, 245, 255, 247, 244, 245, 255, 248, 244, 245, 255, 248, 244, 245, 255, 248, 244, 245, 255, 248, 244, 245, 255, 248, 243, 245, 255, 248, 243, 244, 255, 248, 243, 244, 255, 248, 243, 244, 255, 248, 242, 244, 255, 248, 242, 244, 255, 249, 242, 244, 255, 249, 242, 244, 255, 249, 241, 244, 255, 249, 241, 243, 255, 249, 241, 243, 255, 249, 241, 243, 255, 249, 241, 243, 255, 249, 240, 243, 255, 249, 240, 243, 255, 249, 240, 243, 255, 249, 240, 243, 255, 249, 239, 243, 255, 250, 239, 243, 255, 250, 239, 242, 255, 250, 239, 242, 255, 250, 239, 242, 255, 250, 238, 242, 255, 250, 238, 242, 255, 250, 238, 242, 255, 250, 238, 242, 255, 250, 237, 242, 255, 250, 237, 242, 255, 250, 237, 242, 255, 250, 237, 241, 255, 250, 236, 241, 255, 250, 236, 241, 255, 251, 236, 241, 255, 251, 236, 241, 255, 251, 236, 241, 255, 251, 235, 241, 255, 251, 235, 241, 255, 251, 235, 241, 255, 251, 235, 241, 255, 251, 234, 241, 255, 251, 234, 241, 255, 251, 234, 241, 255, 251, 234, 240, 255, 251, 234, 240, 255, 251, 233, 240, 255, 251, 233, 240, 255, 251, 233, 240, 255, 251, 233, 240, 255, 251, 232, 240, 255, 252, 232, 240, 255, 252, 232, 240, 255, 252, 232, 240, 255, 252, 232, 240, 255, 252, 231, 240, 255, 252, 231, 240, 255, 252, 231, 240, 255, 252, 231, 240, 255, 252, 230, 240, 255, 252, 230, 239, 255, 252, 230, 239, 255, 252, 230, 239, 255, 252, 230, 239, 255, 252, 229, 239, 255, 252, 229, 239, 255, 252, 229, 239, 255, 252, 229, 239, 255, 252, 228, 239, 255, 252, 228, 239, 255, 252, 228, 239, 255, 252, 228, 239, 255, 252, 228, 239, 255, 252, 227, 239, 255, 252, 227, 239, 255, 252, 227, 239, 255, 252, 227, 239, 255, 252, 226, 239, 255, 252, 226, 239, 255, 252, 226, 239, 255, 252, 226, 239, 255, 252, 226, 239, 255, 252, 225, 239, 255, 252, 225, 239, 255, 252, 225, 239, 255, 252, 225, 239, 255, 252, 224, 239, 255, 252, 224, 239, 255, 252, 224, 239, 255, 252, 224, 239, 255, 252, 224, 239, 255, 252, 223, 238, 255, 252, 223, 238, 255, 252, 222, 238, 255, 252, 222, 238, 255, 252, 222, 237, 255, 252, 221, 237, 255, 252, 221, 237, 255, 252, 220, 237, 255, 252, 220, 237, 255, 252, 220, 236, 255, 251, 219, 236, 255, 251, 219, 236, 255, 251, 218, 236, 255, 251, 218, 236, 255, 251, 217, 235, 255, 251, 217, 235, 255, 251, 217, 235, 255, 251, 216, 235, 255, 251, 216, 234, 255, 251, 215, 234, 255, 250, 215, 234, 255, 250, 215, 234, 255, 250, 214, 234, 255, 250, 214, 233, 255, 250, 213, 233, 255, 250, 213, 233, 255, 250, 213, 233, 255, 250, 212, 232, 255, 250, 212, 232, 255, 250, 211, 232, 255, 249, 211, 232, 255, 249, 210, 232, 255, 249, 210, 231, 255, 249, 210, 231, 255, 249, 209, 231, 255, 249, 209, 231, 255, 249, 208, 231, 255, 249, 208, 230, 255, 249, 208, 230, 255, 248, 207, 230, 255, 248, 207, 230, 255, 248, 206, 230, 255, 248, 206, 229, 255, 248, 206, 229, 255, 248, 205, 229, 255, 248, 205, 229, 255, 248, 204, 228, 255, 247, 204, 228, 255, 247, 204, 228, 255, 247, 203, 228, 255, 247, 203, 228, 255, 247, 202, 227, 255, 247, 202, 227, 255, 247, 201, 227, 255, 247, 201, 227, 255, 247, 201, 227, 255, 246, 200, 226, 255, 246, 200, 226, 255, 246, 199, 226, 255, 246, 199, 226, 255, 246, 199, 226, 255, 246, 198, 225, 255, 246, 198, 225, 255, 246, 197, 225, 255, 245, 197, 225, 255, 245, 197, 225, 255, 245, 196, 224, 255, 245, 196, 224, 255, 245, 195, 224, 255, 245, 195, 224, 255, 245, 194, 224, 255, 245, 194, 223, 255, 244, 194, 223, 255, 244, 193, 223, 255, 244, 193, 223, 255, 244, 192, 223, 255, 244, 192, 222, 255, 244, 192, 222, 255, 244, 191, 222, 255, 244, 191, 222, 255, 243, 190, 222, 255, 243, 190, 221, 255, 243, 190, 221, 255, 243, 189, 221, 255, 243, 189, 221, 255, 243, 188, 221, 255, 243, 188, 221, 255, 243, 188, 220, 255, 242, 187, 220, 255, 242, 187, 220, 255, 242, 186, 220, 255, 242, 186, 220, 255, 242, 185, 219, 255, 242, 185, 219, 255, 242, 185, 219, 255, 241, 184, 219, 255, 241, 184, 219, 255, 241, 183, 218, 255, 241, 183, 218, 255, 241, 183, 218, 255, 241, 182, 218, 255, 241, 182, 218, 255, 240, 181, 217, 255, 240, 181, 217, 255, 240, 180, 217, 255, 240, 180, 216, 255, 240, 179, 216, 255, 240, 178, 215, 255, 239, 178, 215, 255, 239, 177, 215, 255, 239, 177, 214, 255, 239, 176, 214, 255, 239, 175, 213, 255, 238, 175, 213, 255, 238, 174, 213, 255, 238, 174, 212, 255, 238, 173, 212, 255, 238, 172, 211, 255, 238, 172, 211, 255, 237, 171, 211, 255, 237, 171, 210, 255, 237, 170, 210, 255, 237, 169, 209, 255, 237, 169, 209, 255, 236, 168, 208, 255, 236, 168, 208, 255, 236, 167, 208, 255, 236, 166, 207, 255, 236, 166, 207, 255, 236, 165, 206, 255, 235, 165, 206, 255, 235, 164, 206, 255, 235, 163, 205, 255, 235, 163, 205, 255, 235, 162, 204, 255, 234, 162, 204, 255, 234, 161, 203, 255, 234, 160, 203, 255, 234, 160, 203, 255, 234, 159, 202, 255, 234, 158, 202, 255, 233, 158, 201, 255, 233, 157, 201, 255, 233, 157, 200, 255, 233, 156, 200, 255, 233, 155, 200, 255, 232, 155, 199, 255, 232, 154, 199, 255, 232, 154, 198, 255, 232, 153, 198, 255, 232, 152, 198, 255, 231, 152, 197, 255, 231, 151, 197, 255, 231, 151, 196, 255, 231, 150, 196, 255, 231, 149, 195, 255, 231, 149, 195, 255, 230, 148, 194, 255, 230, 147, 194, 255, 230, 147, 194, 255, 230, 146, 193, 255, 230, 146, 193, 255, 229, 145, 192, 255, 229, 144, 192, 255, 229, 144, 191, 255, 229, 143, 191, 255, 229, 143, 191, 255, 229, 142, 190, 255, 228, 141, 190, 255, 228, 141, 189, 255, 228, 140, 189, 255, 228, 139, 188, 255, 228, 139, 188, 255, 227, 138, 188, 255, 227, 138, 187, 255, 227, 137, 187, 255, 227, 136, 186, 255, 227, 136, 186, 255, 226, 135, 185, 255, 226, 134, 185, 255, 226, 134, 184, 255, 226, 133, 184, 255, 226, 133, 184, 255, 226, 132, 183, 255, 225, 131, 183, 255, 225, 131, 182, 255, 225, 130, 182, 255, 225, 129, 181, 255, 225, 129, 181, 255, 224, 128, 180, 255, 224, 128, 180, 255, 224, 127, 179, 255, 224, 126, 179, 255, 224, 126, 179, 255, 223, 125, 178, 255, 223, 124, 178, 255, 223, 124, 177, 255, 223, 123, 177, 255, 223, 122, 176, 255, 223, 122, 176, 255, 222, 121, 175, 255, 222, 121, 175, 255, 222, 120, 175, 255, 222, 119, 174, 255, 222, 119, 174, 255, 221, 118, 173, 255, 221, 117, 173, 255, 221, 117, 172, 255, 221, 116, 172, 255, 220, 115, 171, 255, 220, 114, 171, 255, 220, 114, 170, 255, 220, 113, 170, 255, 220, 112, 169, 255, 219, 112, 169, 255, 219, 111, 168, 255, 219, 110, 168, 255, 219, 109, 168, 255, 218, 109, 167, 255, 218, 108, 167, 255, 218, 107, 166, 255, 218, 107, 166, 255, 217, 106, 165, 255, 217, 105, 165, 255, 217, 104, 164, 255, 217, 104, 164, 255, 217, 103, 163, 255, 216, 102, 163, 255, 216, 101, 162, 255, 216, 101, 162, 255, 216, 100, 161, 255, 215, 99, 161, 255, 215, 98, 160, 255, 215, 98, 160, 255, 215, 97, 160, 255, 214, 96, 159, 255, 214, 96, 159, 255, 214, 95, 158, 255, 214, 94, 158, 255, 214, 93, 157, 255, 213, 92, 157, 255, 213, 92, 156, 255, 213, 91, 156, 255, 213, 90, 155, 255, 212, 89, 155, 255, 212, 89, 154, 255, 212, 88, 154, 255, 212, 87, 153, 255, 211, 86, 153, 255, 211, 86, 152, 255, 211, 85, 152, 255, 211, 84, 151, 255, 210, 83, 151, 255, 210, 82, 150, 255, 210, 82, 150, 255, 210, 81, 150, 255, 209, 80, 149, 255, 209, 79, 149, 255, 209, 78, 148, 255, 209, 77, 148, 255, 208, 77, 147, 255, 208, 76, 147, 255, 208, 75, 146, 255, 208, 74, 146, 255, 207, 73, 145, 255, 207, 72, 145, 255, 207, 72, 144, 255, 207, 71, 144, 255, 206, 70, 143, 255, 206, 69, 143, 255, 206, 68, 142, 255, 206, 67, 142, 255, 205, 66, 141, 255, 205, 65, 141, 255, 205, 65, 140, 255, 205, 64, 140, 255, 204, 63, 139, 255, 204, 62, 139, 255, 204, 61, 138, 255, 204, 60, 138, 255, 203, 59, 137, 255, 203, 58, 137, 255, 203, 57, 137, 255, 203, 56, 136, 255, 202, 55, 136, 255, 202, 54, 135, 255, 202, 53, 135, 255, 202, 52, 134, 255, 201, 51, 134, 255, 201, 50, 133, 255, 201, 49, 133, 255, 201, 48, 132, 255, 200, 46, 132, 255, 200, 45, 131, 255, 200, 44, 131, 255, 200, 43, 130, 255, 199, 42, 130, 255, 199, 40, 129, 255, 199, 39, 129, 255, 199, 38, 128, 255, 198, 37, 128, 255, 198, 35, 127, 255, 198, 34, 127, 255, 197, 32, 126, 255, 197, 31, 126, 255, 197, 29, 125, 255, 197, 28, 125, 255, 196, 26, 124, 255, 196, 26, 124, 255, 195, 26, 123, 255, 195, 26, 123, 255, 194, 25, 123, 255, 194, 25, 122, 255, 193, 25, 122, 255, 192, 25, 121, 255, 192, 24, 121, 255, 191, 24, 120, 255, 191, 24, 120, 255, 190, 24, 119, 255, 190, 23, 119, 255, 189, 23, 119, 255, 189, 23, 118, 255, 188, 23, 118, 255, 188, 22, 117, 255, 187, 22, 117, 255, 186, 22, 116, 255, 186, 22, 116, 255, 185, 21, 116, 255, 185, 21, 115, 255, 184, 21, 115, 255, 184, 21, 114, 255, 183, 20, 114, 255, 183, 20, 113, 255, 182, 20, 113, 255, 182, 20, 112, 255, 181, 19, 112, 255, 181, 19, 112, 255, 180, 19, 111, 255, 179, 19, 111, 255, 179, 18, 110, 255, 178, 18, 110, 255, 178, 18, 109, 255, 177, 18, 109, 255, 177, 17, 109, 255, 176, 17, 108, 255, 176, 17, 108, 255, 175, 17, 107, 255, 175, 16, 107, 255, 174, 16, 106, 255, 173, 16, 106, 255, 173, 16, 106, 255, 172, 15, 105, 255, 172, 15, 105, 255, 171, 15, 104, 255, 171, 14, 104, 255, 170, 14, 104, 255, 170, 14, 103, 255, 169, 14, 103, 255, 169, 13, 102, 255, 168, 13, 102, 255, 168, 13, 101, 255, 167, 13, 101, 255, 166, 12, 101, 255, 166, 12, 100, 255, 165, 12, 100, 255, 165, 11, 99, 255, 164, 11, 99, 255, 164, 11, 98, 255, 163, 11, 98, 255, 163, 10, 98, 255, 162, 10, 97, 255, 162, 10, 97, 255, 161, 9, 96, 255, 161, 9, 96, 255, 160, 9, 96, 255, 160, 9, 95, 255, 159, 8, 95, 255, 158, 8, 94, 255, 158, 8, 94, 255, 157, 7, 94, 255, 157, 7, 93, 255, 156, 7, 93, 255, 156, 7, 92, 255, 155, 6, 92, 255, 155, 6, 91, 255, 154, 6, 91, 255, 154, 6, 91, 255, 153, 5, 90, 255, 153, 5, 90, 255, 152, 5, 89, 255, 152, 5, 89, 255, 151, 4, 89, 255, 150, 4, 88, 255, 150, 4, 88, 255, 149, 4, 87, 255, 149, 3, 87, 255, 148, 3, 87, 255, 148, 3, 86, 255, 147, 3, 86, 255, 147, 3, 85, 255, 146, 2, 85, 255, 146, 2, 85, 255, 145, 2, 84, 255, 145, 2, 84, 255, 144, 2, 83, 255, 144, 1, 83, 255, 143, 1, 83, 255, 143, 1, 82, 255, 142, 1, 82, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PiYG_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 39, 100, 24, 0, 39, 100, 25, 7, 39, 100, 25, 14, 39, 101, 25, 22, 40, 101, 25, 29, 40, 101, 25, 37, 40, 102, 25, 44, 40, 102, 25, 52, 41, 102, 25, 59, 41, 103, 25, 67, 41, 103, 25, 74, 41, 103, 25, 82, 42, 104, 25, 89, 42, 104, 26, 97, 42, 104, 26, 104, 43, 105, 26, 112, 43, 105, 26, 119, 43, 105, 26, 127, 43, 106, 26, 134, 44, 106, 26, 141, 44, 107, 26, 149, 44, 107, 26, 156, 45, 107, 26, 164, 45, 108, 26, 171, 45, 108, 26, 179, 45, 108, 26, 186, 46, 109, 26, 194, 46, 109, 27, 201, 46, 109, 27, 209, 46, 110, 27, 216, 47, 110, 27, 224, 47, 110, 27, 231, 47, 111, 27, 239, 48, 111, 27, 246, 48, 112, 27, 254, 48, 112, 27, 255, 48, 112, 27, 255, 49, 113, 27, 255, 49, 113, 27, 255, 49, 113, 27, 255, 50, 114, 27, 255, 50, 114, 27, 255, 50, 114, 28, 255, 51, 115, 28, 255, 51, 115, 28, 255, 51, 115, 28, 255, 51, 116, 28, 255, 52, 116, 28, 255, 52, 117, 28, 255, 52, 117, 28, 255, 53, 117, 28, 255, 53, 118, 28, 255, 61, 127, 30, 255, 61, 128, 30, 255, 61, 128, 30, 255, 62, 128, 30, 255, 62, 129, 30, 255, 62, 129, 30, 255, 63, 129, 30, 255, 63, 130, 30, 255, 63, 130, 30, 255, 63, 130, 30, 255, 64, 131, 30, 255, 64, 131, 30, 255, 64, 131, 31, 255, 65, 132, 31, 255, 65, 132, 31, 255, 65, 133, 31, 255, 66, 133, 31, 255, 66, 133, 31, 255, 66, 134, 31, 255, 67, 134, 31, 255, 67, 134, 31, 255, 67, 135, 31, 255, 67, 135, 31, 255, 68, 135, 31, 255, 68, 136, 31, 255, 68, 136, 31, 255, 69, 137, 31, 255, 69, 137, 31, 255, 69, 137, 31, 255, 70, 138, 31, 255, 70, 138, 32, 255, 70, 138, 32, 255, 71, 139, 32, 255, 71, 139, 32, 255, 71, 139, 32, 255, 72, 140, 32, 255, 72, 140, 32, 255, 72, 141, 32, 255, 72, 141, 32, 255, 73, 141, 32, 255, 73, 142, 32, 255, 73, 142, 32, 255, 74, 142, 32, 255, 74, 143, 32, 255, 74, 143, 32, 255, 75, 144, 32, 255, 75, 144, 32, 255, 75, 144, 32, 255, 76, 145, 32, 255, 76, 145, 32, 255, 76, 145, 32, 255, 77, 146, 33, 255, 77, 146, 33, 255, 78, 146, 33, 255, 78, 147, 33, 255, 78, 147, 34, 255, 79, 147, 34, 255, 79, 148, 34, 255, 79, 148, 34, 255, 80, 148, 35, 255, 80, 149, 35, 255, 81, 149, 35, 255, 81, 149, 35, 255, 81, 150, 36, 255, 82, 150, 36, 255, 82, 150, 36, 255, 83, 151, 36, 255, 83, 151, 37, 255, 83, 151, 37, 255, 84, 152, 37, 255, 84, 152, 38, 255, 85, 152, 38, 255, 85, 152, 38, 255, 85, 153, 38, 255, 86, 153, 39, 255, 86, 153, 39, 255, 86, 154, 39, 255, 87, 154, 39, 255, 87, 154, 40, 255, 88, 155, 40, 255, 88, 155, 40, 255, 88, 155, 40, 255, 89, 156, 41, 255, 89, 156, 41, 255, 90, 156, 41, 255, 90, 157, 41, 255, 90, 157, 42, 255, 91, 157, 42, 255, 91, 158, 42, 255, 92, 158, 42, 255, 92, 158, 43, 255, 92, 159, 43, 255, 93, 159, 43, 255, 93, 159, 43, 255, 93, 160, 44, 255, 94, 160, 44, 255, 94, 160, 44, 255, 95, 161, 44, 255, 95, 161, 45, 255, 95, 161, 45, 255, 96, 162, 45, 255, 96, 162, 45, 255, 107, 171, 52, 255, 107, 171, 52, 255, 107, 171, 52, 255, 108, 172, 53, 255, 108, 172, 53, 255, 109, 172, 53, 255, 109, 173, 53, 255, 109, 173, 54, 255, 110, 173, 54, 255, 110, 174, 54, 255, 111, 174, 54, 255, 111, 174, 55, 255, 111, 175, 55, 255, 112, 175, 55, 255, 112, 175, 55, 255, 112, 176, 56, 255, 113, 176, 56, 255, 113, 176, 56, 255, 114, 177, 56, 255, 114, 177, 57, 255, 114, 177, 57, 255, 115, 178, 57, 255, 115, 178, 57, 255, 116, 178, 58, 255, 116, 179, 58, 255, 116, 179, 58, 255, 117, 179, 58, 255, 117, 180, 59, 255, 118, 180, 59, 255, 118, 180, 59, 255, 118, 181, 59, 255, 119, 181, 60, 255, 119, 181, 60, 255, 120, 182, 60, 255, 120, 182, 60, 255, 120, 182, 61, 255, 121, 183, 61, 255, 121, 183, 61, 255, 121, 183, 61, 255, 122, 184, 62, 255, 122, 184, 62, 255, 123, 184, 62, 255, 123, 185, 62, 255, 123, 185, 63, 255, 124, 185, 63, 255, 124, 186, 63, 255, 125, 186, 63, 255, 125, 186, 64, 255, 125, 187, 64, 255, 126, 187, 64, 255, 126, 187, 64, 255, 127, 188, 65, 255, 127, 188, 65, 255, 128, 188, 66, 255, 128, 188, 66, 255, 128, 189, 67, 255, 129, 189, 67, 255, 129, 189, 68, 255, 130, 190, 69, 255, 130, 190, 69, 255, 131, 190, 70, 255, 131, 190, 70, 255, 132, 191, 71, 255, 132, 191, 71, 255, 133, 191, 72, 255, 133, 192, 73, 255, 133, 192, 73, 255, 134, 192, 74, 255, 134, 192, 74, 255, 135, 193, 75, 255, 135, 193, 75, 255, 136, 193, 76, 255, 136, 194, 76, 255, 137, 194, 77, 255, 137, 194, 77, 255, 138, 194, 78, 255, 138, 195, 79, 255, 138, 195, 79, 255, 139, 195, 80, 255, 139, 196, 80, 255, 140, 196, 81, 255, 140, 196, 81, 255, 141, 196, 82, 255, 141, 197, 82, 255, 142, 197, 83, 255, 142, 197, 83, 255, 143, 198, 84, 255, 143, 198, 85, 255, 143, 198, 85, 255, 144, 198, 86, 255, 144, 199, 86, 255, 145, 199, 87, 255, 145, 199, 87, 255, 146, 200, 88, 255, 146, 200, 88, 255, 147, 200, 89, 255, 147, 200, 89, 255, 147, 201, 90, 255, 148, 201, 90, 255, 148, 201, 91, 255, 149, 202, 92, 255, 149, 202, 92, 255, 161, 210, 106, 255, 162, 210, 107, 255, 162, 210, 107, 255, 162, 210, 108, 255, 163, 211, 108, 255, 163, 211, 109, 255, 164, 211, 110, 255, 164, 212, 110, 255, 165, 212, 111, 255, 165, 212, 111, 255, 166, 213, 112, 255, 166, 213, 112, 255, 166, 213, 113, 255, 167, 213, 113, 255, 167, 214, 114, 255, 168, 214, 114, 255, 168, 214, 115, 255, 169, 215, 115, 255, 169, 215, 116, 255, 169, 215, 116, 255, 170, 215, 117, 255, 170, 216, 118, 255, 171, 216, 118, 255, 171, 216, 119, 255, 172, 217, 119, 255, 172, 217, 120, 255, 173, 217, 120, 255, 173, 217, 121, 255, 173, 218, 121, 255, 174, 218, 122, 255, 174, 218, 122, 255, 175, 219, 123, 255, 175, 219, 123, 255, 176, 219, 124, 255, 176, 219, 124, 255, 176, 220, 125, 255, 177, 220, 125, 255, 177, 220, 126, 255, 178, 221, 127, 255, 178, 221, 127, 255, 179, 221, 128, 255, 179, 222, 128, 255, 180, 222, 129, 255, 180, 222, 129, 255, 180, 222, 130, 255, 181, 223, 130, 255, 181, 223, 131, 255, 182, 223, 131, 255, 182, 224, 132, 255, 183, 224, 132, 255, 183, 224, 133, 255, 183, 224, 133, 255, 184, 225, 134, 255, 184, 225, 135, 255, 185, 225, 135, 255, 185, 225, 136, 255, 185, 225, 136, 255, 186, 225, 137, 255, 186, 226, 137, 255, 186, 226, 138, 255, 187, 226, 139, 255, 187, 226, 139, 255, 188, 226, 140, 255, 188, 226, 140, 255, 188, 227, 141, 255, 189, 227, 142, 255, 189, 227, 142, 255, 189, 227, 143, 255, 190, 227, 143, 255, 190, 227, 144, 255, 191, 227, 144, 255, 191, 228, 145, 255, 191, 228, 146, 255, 192, 228, 146, 255, 192, 228, 147, 255, 192, 228, 147, 255, 193, 228, 148, 255, 193, 229, 148, 255, 194, 229, 149, 255, 194, 229, 150, 255, 194, 229, 150, 255, 195, 229, 151, 255, 195, 229, 151, 255, 195, 230, 152, 255, 196, 230, 152, 255, 196, 230, 153, 255, 196, 230, 154, 255, 197, 230, 154, 255, 197, 230, 155, 255, 198, 230, 155, 255, 198, 231, 156, 255, 198, 231, 157, 255, 199, 231, 157, 255, 199, 231, 158, 255, 199, 231, 158, 255, 200, 231, 159, 255, 200, 232, 159, 255, 200, 232, 160, 255, 201, 232, 161, 255, 201, 232, 161, 255, 202, 232, 162, 255, 202, 232, 162, 255, 202, 232, 163, 255, 212, 237, 178, 255, 212, 237, 179, 255, 213, 237, 179, 255, 213, 237, 180, 255, 213, 237, 181, 255, 214, 237, 181, 255, 214, 238, 182, 255, 214, 238, 182, 255, 215, 238, 183, 255, 215, 238, 183, 255, 215, 238, 184, 255, 216, 238, 185, 255, 216, 239, 185, 255, 216, 239, 186, 255, 217, 239, 186, 255, 217, 239, 187, 255, 218, 239, 187, 255, 218, 239, 188, 255, 218, 239, 189, 255, 219, 240, 189, 255, 219, 240, 190, 255, 219, 240, 190, 255, 220, 240, 191, 255, 220, 240, 191, 255, 220, 240, 192, 255, 221, 241, 193, 255, 221, 241, 193, 255, 221, 241, 194, 255, 222, 241, 194, 255, 222, 241, 195, 255, 222, 241, 196, 255, 223, 241, 196, 255, 223, 242, 197, 255, 223, 242, 197, 255, 224, 242, 198, 255, 224, 242, 198, 255, 224, 242, 199, 255, 225, 242, 200, 255, 225, 243, 200, 255, 226, 243, 201, 255, 226, 243, 201, 255, 226, 243, 202, 255, 227, 243, 203, 255, 227, 243, 203, 255, 227, 243, 204, 255, 228, 244, 204, 255, 228, 244, 205, 255, 228, 244, 205, 255, 229, 244, 206, 255, 229, 244, 207, 255, 229, 244, 207, 255, 230, 244, 207, 255, 231, 244, 207, 255, 232, 244, 207, 255, 232, 244, 207, 255, 233, 244, 207, 255, 234, 244, 207, 255, 235, 244, 208, 255, 235, 243, 208, 255, 236, 243, 208, 255, 237, 243, 208, 255, 238, 243, 208, 255, 238, 243, 208, 255, 239, 243, 208, 255, 240, 243, 208, 255, 240, 242, 209, 255, 241, 242, 209, 255, 242, 242, 209, 255, 242, 242, 209, 255, 243, 242, 209, 255, 243, 242, 210, 255, 244, 242, 210, 255, 245, 242, 210, 255, 245, 242, 210, 255, 246, 241, 211, 255, 246, 241, 211, 255, 247, 241, 211, 255, 247, 241, 212, 255, 247, 241, 212, 255, 248, 241, 212, 255, 248, 241, 213, 255, 249, 241, 213, 255, 249, 241, 214, 255, 249, 241, 214, 255, 250, 241, 214, 255, 250, 241, 215, 255, 250, 241, 215, 255, 250, 240, 216, 255, 250, 240, 216, 255, 250, 240, 216, 255, 250, 240, 217, 255, 250, 240, 217, 255, 250, 240, 218, 255, 250, 240, 218, 255, 250, 240, 219, 255, 250, 240, 219, 255, 250, 240, 220, 255, 250, 240, 220, 255, 250, 240, 221, 255, 250, 240, 221, 255, 250, 240, 222, 255, 250, 240, 222, 255, 253, 241, 230, 255, 253, 241, 231, 255, 253, 241, 231, 255, 253, 241, 232, 255, 253, 241, 232, 255, 253, 241, 233, 255, 253, 241, 233, 255, 253, 241, 234, 255, 253, 241, 234, 255, 253, 241, 234, 255, 253, 241, 235, 255, 253, 241, 235, 255, 253, 241, 236, 255, 253, 241, 236, 255, 253, 241, 237, 255, 253, 242, 237, 255, 253, 242, 238, 255, 253, 242, 238, 255, 253, 242, 238, 255, 253, 242, 239, 255, 253, 242, 239, 255, 253, 242, 240, 255, 253, 242, 240, 255, 253, 242, 240, 255, 253, 243, 241, 255, 253, 243, 241, 255, 253, 243, 241, 255, 253, 243, 242, 255, 253, 243, 242, 255, 253, 243, 242, 255, 252, 243, 243, 255, 252, 243, 243, 255, 252, 244, 243, 255, 252, 244, 244, 255, 251, 244, 244, 255, 251, 244, 244, 255, 251, 244, 244, 255, 250, 244, 245, 255, 250, 244, 245, 255, 250, 245, 245, 255, 250, 245, 245, 255, 249, 245, 245, 255, 249, 245, 246, 255, 249, 245, 246, 255, 248, 245, 246, 255, 248, 246, 246, 255, 248, 246, 246, 255, 248, 246, 246, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 246, 247, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 245, 246, 255, 247, 245, 246, 255, 247, 245, 246, 255, 247, 245, 245, 255, 247, 245, 245, 255, 247, 244, 245, 255, 248, 244, 245, 255, 248, 244, 245, 255, 248, 244, 245, 255, 248, 244, 245, 255, 248, 244, 245, 255, 248, 243, 245, 255, 248, 243, 245, 255, 248, 243, 244, 255, 248, 243, 244, 255, 248, 243, 244, 255, 248, 242, 244, 255, 248, 242, 244, 255, 248, 242, 244, 255, 248, 242, 244, 255, 249, 242, 244, 255, 249, 242, 244, 255, 249, 241, 244, 255, 249, 241, 244, 255, 249, 241, 243, 255, 249, 241, 243, 255, 249, 241, 243, 255, 249, 240, 243, 255, 249, 240, 243, 255, 249, 240, 243, 255, 249, 240, 243, 255, 249, 240, 243, 255, 249, 240, 243, 255, 249, 239, 243, 255, 249, 239, 243, 255, 249, 239, 243, 255, 250, 239, 243, 255, 250, 239, 242, 255, 250, 238, 242, 255, 250, 238, 242, 255, 250, 238, 242, 255, 250, 238, 242, 255, 250, 238, 242, 255, 250, 238, 242, 255, 250, 237, 242, 255, 250, 237, 242, 255, 251, 232, 240, 255, 251, 232, 240, 255, 251, 232, 240, 255, 251, 232, 240, 255, 251, 232, 240, 255, 251, 232, 240, 255, 252, 231, 240, 255, 252, 231, 240, 255, 252, 231, 240, 255, 252, 231, 240, 255, 252, 231, 240, 255, 252, 230, 240, 255, 252, 230, 240, 255, 252, 230, 240, 255, 252, 230, 240, 255, 252, 230, 239, 255, 252, 230, 239, 255, 252, 229, 239, 255, 252, 229, 239, 255, 252, 229, 239, 255, 252, 229, 239, 255, 252, 229, 239, 255, 252, 228, 239, 255, 252, 228, 239, 255, 252, 228, 239, 255, 252, 228, 239, 255, 252, 228, 239, 255, 252, 228, 239, 255, 252, 227, 239, 255, 252, 227, 239, 255, 252, 227, 239, 255, 252, 227, 239, 255, 252, 227, 239, 255, 252, 227, 239, 255, 252, 226, 239, 255, 252, 226, 239, 255, 252, 226, 239, 255, 252, 226, 239, 255, 252, 226, 239, 255, 252, 225, 239, 255, 252, 225, 239, 255, 252, 225, 239, 255, 252, 225, 239, 255, 252, 225, 239, 255, 252, 225, 239, 255, 252, 224, 239, 255, 252, 224, 239, 255, 252, 224, 239, 255, 252, 224, 239, 255, 252, 224, 239, 255, 252, 224, 239, 255, 252, 223, 238, 255, 252, 223, 238, 255, 252, 223, 238, 255, 252, 222, 238, 255, 252, 222, 238, 255, 252, 222, 238, 255, 252, 221, 237, 255, 252, 221, 237, 255, 252, 221, 237, 255, 252, 220, 237, 255, 252, 220, 237, 255, 252, 220, 236, 255, 252, 219, 236, 255, 251, 219, 236, 255, 251, 219, 236, 255, 251, 218, 236, 255, 251, 218, 236, 255, 251, 218, 235, 255, 251, 217, 235, 255, 251, 217, 235, 255, 251, 217, 235, 255, 251, 216, 235, 255, 251, 216, 235, 255, 251, 216, 234, 255, 251, 215, 234, 255, 250, 215, 234, 255, 250, 215, 234, 255, 250, 214, 234, 255, 250, 214, 234, 255, 250, 214, 233, 255, 250, 213, 233, 255, 250, 213, 233, 255, 250, 213, 233, 255, 250, 212, 233, 255, 250, 212, 233, 255, 250, 212, 232, 255, 249, 211, 232, 255, 249, 211, 232, 255, 249, 211, 232, 255, 249, 210, 232, 255, 249, 210, 231, 255, 249, 210, 231, 255, 249, 209, 231, 255, 249, 209, 231, 255, 249, 209, 231, 255, 249, 208, 231, 255, 249, 208, 230, 255, 248, 208, 230, 255, 248, 208, 230, 255, 248, 207, 230, 255, 248, 207, 230, 255, 246, 198, 225, 255, 246, 198, 225, 255, 246, 197, 225, 255, 245, 197, 225, 255, 245, 197, 225, 255, 245, 196, 225, 255, 245, 196, 224, 255, 245, 196, 224, 255, 245, 195, 224, 255, 245, 195, 224, 255, 245, 195, 224, 255, 245, 195, 224, 255, 245, 194, 224, 255, 244, 194, 223, 255, 244, 194, 223, 255, 244, 193, 223, 255, 244, 193, 223, 255, 244, 193, 223, 255, 244, 192, 223, 255, 244, 192, 222, 255, 244, 192, 222, 255, 244, 191, 222, 255, 244, 191, 222, 255, 243, 191, 222, 255, 243, 190, 222, 255, 243, 190, 221, 255, 243, 190, 221, 255, 243, 189, 221, 255, 243, 189, 221, 255, 243, 189, 221, 255, 243, 188, 221, 255, 243, 188, 221, 255, 243, 188, 220, 255, 242, 187, 220, 255, 242, 187, 220, 255, 242, 187, 220, 255, 242, 186, 220, 255, 242, 186, 220, 255, 242, 186, 219, 255, 242, 185, 219, 255, 242, 185, 219, 255, 242, 185, 219, 255, 241, 184, 219, 255, 241, 184, 219, 255, 241, 184, 219, 255, 241, 183, 218, 255, 241, 183, 218, 255, 241, 183, 218, 255, 241, 182, 218, 255, 241, 182, 218, 255, 241, 182, 218, 255, 240, 181, 217, 255, 240, 181, 217, 255, 240, 180, 217, 255, 240, 180, 216, 255, 240, 179, 216, 255, 240, 179, 216, 255, 240, 179, 216, 255, 239, 178, 215, 255, 239, 178, 215, 255, 239, 177, 215, 255, 239, 177, 214, 255, 239, 176, 214, 255, 239, 176, 214, 255, 239, 175, 213, 255, 238, 175, 213, 255, 238, 174, 213, 255, 238, 174, 212, 255, 238, 173, 212, 255, 238, 173, 212, 255, 238, 172, 211, 255, 238, 172, 211, 255, 237, 171, 211, 255, 237, 171, 210, 255, 237, 170, 210, 255, 237, 170, 210, 255, 237, 169, 209, 255, 237, 169, 209, 255, 237, 168, 209, 255, 236, 168, 208, 255, 236, 167, 208, 255, 236, 167, 208, 255, 236, 166, 207, 255, 236, 166, 207, 255, 236, 166, 207, 255, 235, 165, 206, 255, 235, 165, 206, 255, 235, 164, 206, 255, 235, 164, 205, 255, 235, 163, 205, 255, 235, 163, 205, 255, 235, 162, 204, 255, 234, 162, 204, 255, 234, 161, 204, 255, 234, 161, 203, 255, 234, 160, 203, 255, 234, 160, 203, 255, 234, 159, 202, 255, 234, 159, 202, 255, 233, 158, 202, 255, 233, 158, 201, 255, 233, 157, 201, 255, 229, 144, 192, 255, 229, 144, 191, 255, 229, 143, 191, 255, 229, 143, 191, 255, 229, 142, 190, 255, 228, 142, 190, 255, 228, 141, 190, 255, 228, 141, 189, 255, 228, 140, 189, 255, 228, 140, 189, 255, 228, 139, 188, 255, 228, 139, 188, 255, 227, 138, 188, 255, 227, 138, 187, 255, 227, 137, 187, 255, 227, 137, 186, 255, 227, 136, 186, 255, 227, 136, 186, 255, 227, 135, 185, 255, 226, 135, 185, 255, 226, 134, 185, 255, 226, 134, 184, 255, 226, 133, 184, 255, 226, 133, 184, 255, 226, 132, 183, 255, 225, 132, 183, 255, 225, 131, 183, 255, 225, 131, 182, 255, 225, 130, 182, 255, 225, 130, 182, 255, 225, 129, 181, 255, 225, 129, 181, 255, 224, 128, 180, 255, 224, 128, 180, 255, 224, 127, 180, 255, 224, 127, 179, 255, 224, 126, 179, 255, 224, 126, 179, 255, 224, 125, 178, 255, 223, 125, 178, 255, 223, 124, 178, 255, 223, 124, 177, 255, 223, 123, 177, 255, 223, 123, 176, 255, 223, 122, 176, 255, 222, 122, 176, 255, 222, 121, 175, 255, 222, 121, 175, 255, 222, 120, 175, 255, 222, 120, 174, 255, 222, 119, 174, 255, 222, 119, 174, 255, 221, 118, 173, 255, 221, 117, 173, 255, 221, 117, 172, 255, 221, 116, 172, 255, 221, 116, 172, 255, 220, 115, 171, 255, 220, 115, 171, 255, 220, 114, 171, 255, 220, 114, 170, 255, 220, 113, 170, 255, 220, 112, 169, 255, 219, 112, 169, 255, 219, 111, 169, 255, 219, 111, 168, 255, 219, 110, 168, 255, 219, 110, 168, 255, 218, 109, 167, 255, 218, 108, 167, 255, 218, 108, 166, 255, 218, 107, 166, 255, 218, 107, 166, 255, 218, 106, 165, 255, 217, 105, 165, 255, 217, 105, 165, 255, 217, 104, 164, 255, 217, 104, 164, 255, 217, 103, 163, 255, 216, 102, 163, 255, 216, 102, 163, 255, 216, 101, 162, 255, 216, 101, 162, 255, 216, 100, 162, 255, 215, 99, 161, 255, 215, 99, 161, 255, 215, 98, 160, 255, 215, 98, 160, 255, 215, 97, 160, 255, 215, 96, 159, 255, 214, 96, 159, 255, 214, 95, 159, 255, 214, 95, 158, 255, 214, 94, 158, 255, 214, 93, 157, 255, 213, 93, 157, 255, 213, 92, 157, 255, 213, 91, 156, 255, 213, 91, 156, 255, 213, 90, 155, 255, 212, 90, 155, 255, 212, 89, 155, 255, 212, 88, 154, 255, 207, 69, 144, 255, 207, 69, 144, 255, 206, 68, 143, 255, 206, 67, 143, 255, 206, 67, 143, 255, 206, 66, 142, 255, 206, 65, 142, 255, 205, 65, 141, 255, 205, 64, 141, 255, 205, 63, 141, 255, 205, 63, 140, 255, 205, 62, 140, 255, 204, 61, 140, 255, 204, 60, 139, 255, 204, 60, 139, 255, 204, 59, 138, 255, 204, 58, 138, 255, 203, 58, 138, 255, 203, 57, 137, 255, 203, 56, 137, 255, 203, 55, 136, 255, 203, 55, 136, 255, 202, 54, 136, 255, 202, 53, 135, 255, 202, 52, 135, 255, 202, 52, 134, 255, 202, 51, 134, 255, 201, 50, 134, 255, 201, 49, 133, 255, 201, 48, 133, 255, 201, 48, 133, 255, 201, 47, 132, 255, 200, 46, 132, 255, 200, 45, 131, 255, 200, 44, 131, 255, 200, 43, 131, 255, 200, 42, 130, 255, 199, 42, 130, 255, 199, 41, 129, 255, 199, 40, 129, 255, 199, 39, 129, 255, 199, 38, 128, 255, 198, 37, 128, 255, 198, 36, 127, 255, 198, 35, 127, 255, 198, 33, 127, 255, 197, 32, 126, 255, 197, 31, 126, 255, 197, 30, 126, 255, 197, 29, 125, 255, 197, 27, 125, 255, 196, 26, 124, 255, 196, 26, 124, 255, 195, 26, 124, 255, 195, 26, 123, 255, 195, 26, 123, 255, 194, 25, 123, 255, 194, 25, 122, 255, 193, 25, 122, 255, 193, 25, 122, 255, 192, 25, 121, 255, 192, 24, 121, 255, 192, 24, 120, 255, 191, 24, 120, 255, 191, 24, 120, 255, 190, 24, 119, 255, 190, 23, 119, 255, 189, 23, 119, 255, 189, 23, 118, 255, 188, 23, 118, 255, 188, 23, 118, 255, 188, 22, 117, 255, 187, 22, 117, 255, 187, 22, 117, 255, 186, 22, 116, 255, 186, 22, 116, 255, 185, 21, 116, 255, 185, 21, 115, 255, 185, 21, 115, 255, 184, 21, 115, 255, 184, 21, 114, 255, 183, 20, 114, 255, 183, 20, 113, 255, 182, 20, 113, 255, 182, 20, 113, 255, 182, 20, 112, 255, 181, 19, 112, 255, 181, 19, 112, 255, 180, 19, 111, 255, 180, 19, 111, 255, 179, 19, 111, 255, 179, 18, 110, 255, 179, 18, 110, 255, 178, 18, 110, 255, 178, 18, 109, 255, 177, 18, 109, 255, 177, 17, 109, 255, 176, 17, 108, 255, 176, 17, 108, 255, 175, 17, 108, 255, 175, 16, 107, 255, 175, 16, 107, 255, 163, 11, 98, 255, 163, 11, 98, 255, 162, 10, 97, 255, 162, 10, 97, 255, 161, 10, 97, 255, 161, 10, 96, 255, 161, 10, 96, 255, 160, 9, 96, 255, 160, 9, 95, 255, 159, 9, 95, 255, 159, 9, 95, 255, 158, 8, 94, 255, 158, 8, 94, 255, 158, 8, 94, 255, 157, 8, 93, 255, 157, 7, 93, 255, 156, 7, 93, 255, 156, 7, 92, 255, 155, 7, 92, 255, 155, 7, 92, 255, 155, 6, 91, 255, 154, 6, 91, 255, 154, 6, 91, 255, 153, 6, 90, 255, 153, 5, 90, 255, 153, 5, 90, 255, 152, 5, 89, 255, 152, 5, 89, 255, 151, 5, 89, 255, 151, 4, 89, 255, 150, 4, 88, 255, 150, 4, 88, 255, 150, 4, 88, 255, 149, 4, 87, 255, 149, 3, 87, 255, 148, 3, 87, 255, 148, 3, 86, 255, 147, 3, 86, 255, 147, 3, 86, 255, 147, 3, 85, 255, 146, 2, 85, 255, 146, 2, 85, 255, 145, 2, 84, 255, 145, 2, 84, 255, 144, 2, 84, 255, 144, 1, 83, 255, 144, 1, 83, 255, 143, 1, 83, 255, 143, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PiYG_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 39, 100, 24, 0, 41, 103, 25, 24, 44, 106, 26, 49, 47, 110, 27, 74, 49, 113, 27, 99, 52, 117, 28, 124, 63, 129, 30, 149, 66, 133, 31, 174, 68, 136, 31, 199, 71, 140, 32, 224, 74, 143, 32, 249, 77, 146, 33, 255, 81, 149, 35, 255, 84, 152, 38, 255, 88, 155, 40, 255, 91, 158, 42, 255, 95, 161, 44, 255, 108, 172, 53, 255, 111, 175, 55, 255, 115, 178, 57, 255, 118, 180, 59, 255, 121, 183, 61, 255, 125, 186, 63, 255, 128, 188, 66, 255, 132, 191, 71, 255, 135, 193, 75, 255, 139, 195, 80, 255, 143, 198, 84, 255, 146, 200, 88, 255, 150, 202, 92, 255, 164, 212, 110, 255, 168, 214, 114, 255, 171, 216, 118, 255, 174, 218, 122, 255, 178, 220, 126, 255, 181, 223, 130, 255, 184, 225, 134, 255, 187, 226, 138, 255, 189, 227, 142, 255, 192, 228, 146, 255, 194, 229, 150, 255, 197, 230, 154, 255, 200, 231, 158, 255, 202, 232, 162, 255, 214, 237, 181, 255, 216, 238, 185, 255, 218, 239, 189, 255, 221, 241, 193, 255, 223, 242, 196, 255, 225, 243, 200, 255, 227, 244, 204, 255, 230, 244, 207, 255, 235, 244, 208, 255, 239, 243, 208, 255, 243, 242, 209, 255, 246, 241, 211, 255, 249, 241, 213, 255, 250, 240, 216, 255, 250, 240, 218, 255, 250, 240, 221, 255, 253, 241, 232, 255, 253, 241, 234, 255, 253, 242, 237, 255, 253, 242, 239, 255, 253, 243, 241, 255, 252, 244, 243, 255, 250, 244, 245, 255, 249, 245, 246, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 245, 246, 255, 248, 244, 245, 255, 248, 243, 245, 255, 248, 242, 244, 255, 249, 241, 244, 255, 249, 240, 243, 255, 249, 239, 243, 255, 250, 239, 242, 255, 250, 238, 242, 255, 251, 232, 240, 255, 252, 231, 240, 255, 252, 230, 240, 255, 252, 230, 239, 255, 252, 229, 239, 255, 252, 228, 239, 255, 252, 227, 239, 255, 252, 226, 239, 255, 252, 226, 239, 255, 252, 225, 239, 255, 252, 224, 239, 255, 252, 223, 238, 255, 252, 222, 237, 255, 252, 220, 237, 255, 251, 219, 236, 255, 251, 217, 235, 255, 251, 216, 235, 255, 250, 215, 234, 255, 250, 213, 233, 255, 250, 212, 232, 255, 249, 211, 232, 255, 249, 209, 231, 255, 249, 208, 230, 255, 248, 207, 230, 255, 245, 197, 225, 255, 245, 196, 224, 255, 245, 195, 224, 255, 244, 193, 223, 255, 244, 192, 223, 255, 244, 191, 222, 255, 243, 190, 221, 255, 243, 189, 221, 255, 242, 187, 220, 255, 242, 186, 220, 255, 242, 185, 219, 255, 241, 184, 219, 255, 241, 183, 218, 255, 241, 182, 218, 255, 240, 180, 217, 255, 240, 179, 216, 255, 239, 177, 214, 255, 239, 175, 213, 255, 238, 174, 212, 255, 238, 172, 211, 255, 237, 171, 210, 255, 237, 169, 209, 255, 236, 168, 208, 255, 236, 166, 207, 255, 235, 165, 206, 255, 235, 163, 205, 255, 235, 162, 204, 255, 234, 160, 203, 255, 234, 159, 202, 255, 233, 158, 201, 255, 229, 144, 191, 255, 229, 142, 190, 255, 228, 141, 189, 255, 228, 139, 188, 255, 227, 138, 187, 255, 227, 137, 186, 255, 227, 135, 185, 255, 226, 134, 184, 255, 226, 133, 184, 255, 225, 131, 183, 255, 225, 130, 182, 255, 225, 129, 181, 255, 224, 127, 180, 255, 224, 126, 179, 255, 223, 125, 178, 255, 223, 124, 177, 255, 223, 122, 176, 255, 222, 121, 175, 255, 222, 120, 175, 255, 222, 119, 174, 255, 221, 117, 173, 255, 221, 116, 172, 255, 220, 115, 171, 255, 220, 114, 170, 255, 220, 112, 169, 255, 219, 111, 169, 255, 219, 110, 168, 255, 218, 109, 167, 255, 218, 107, 166, 255, 218, 106, 165, 255, 217, 105, 165, 255, 217, 104, 164, 255, 216, 102, 163, 255, 216, 101, 162, 255, 216, 100, 161, 255, 215, 99, 161, 255, 215, 97, 160, 255, 214, 96, 159, 255, 214, 95, 158, 255, 214, 94, 158, 255, 213, 93, 157, 255, 213, 92, 156, 255, 213, 90, 156, 255, 212, 89, 155, 255, 207, 70, 144, 255, 207, 68, 144, 255, 206, 67, 143, 255, 206, 66, 142, 255, 206, 65, 142, 255, 205, 64, 141, 255, 205, 63, 140, 255, 205, 61, 140, 255, 204, 60, 139, 255, 204, 59, 138, 255, 204, 58, 138, 255, 203, 57, 137, 255, 203, 56, 136, 255, 203, 54, 136, 255, 202, 53, 135, 255, 202, 52, 135, 255, 202, 51, 134, 255, 201, 50, 133, 255, 201, 48, 133, 255, 201, 47, 132, 255, 200, 46, 132, 255, 200, 45, 131, 255, 200, 43, 131, 255, 199, 42, 130, 255, 199, 41, 129, 255, 199, 39, 129, 255, 199, 38, 128, 255, 198, 37, 128, 255, 198, 35, 127, 255, 198, 34, 127, 255, 197, 32, 126, 255, 197, 31, 126, 255, 197, 29, 125, 255, 197, 28, 125, 255, 196, 26, 124, 255, 196, 26, 124, 255, 195, 26, 123, 255, 195, 26, 123, 255, 194, 25, 123, 255, 194, 25, 122, 255, 193, 25, 122, 255, 193, 25, 121, 255, 192, 25, 121, 255, 192, 24, 121, 255, 191, 24, 120, 255, 191, 24, 120, 255, 190, 24, 119, 255, 190, 23, 119, 255, 189, 23, 119, 255, 189, 23, 118, 255, 188, 23, 118, 255, 188, 23, 117, 255, 187, 22, 117, 255, 187, 22, 117, 255, 186, 22, 116, 255, 186, 22, 116, 255, 186, 22, 116, 255, 185, 21, 115, 255, 185, 21, 115, 255, 184, 21, 115, 255, 184, 21, 114, 255, 184, 21, 114, 255, 183, 20, 114, 255, 183, 20, 113, 255, 182, 20, 113, 255, 182, 20, 113, 255, 182, 20, 113, 255, 181, 19, 112, 255, 181, 19, 112, 255, 181, 19, 112, 255, 180, 19, 111, 255, 180, 19, 111, 255, 179, 19, 111, 255, 179, 18, 111, 255, 179, 18, 110, 255, 178, 18, 110, 255, 178, 18, 110, 255, 178, 18, 109, 255, 177, 18, 109, 255, 177, 17, 109, 255, 177, 17, 109, 255, 176, 17, 108, 255, 176, 17, 108, 255, 176, 17, 108, 255, 176, 17, 108, 255, 175, 17, 107, 255, 175, 16, 107, 255, 175, 16, 107, 255, 174, 16, 107, 255, 163, 11, 98, 255, 163, 11, 98, 255, 162, 10, 98, 255, 162, 10, 97, 255, 162, 10, 97, 255, 162, 10, 97, 255, 161, 10, 97, 255, 161, 10, 96, 255, 161, 10, 96, 255, 161, 9, 96, 255, 160, 9, 96, 255, 160, 9, 96, 255, 160, 9, 95, 255, 160, 9, 95, 255, 159, 9, 95, 255, 159, 9, 95, 255, 159, 9, 95, 255, 159, 8, 95, 255, 158, 8, 94, 255, 158, 8, 94, 255, 158, 8, 94, 255, 158, 8, 94, 255, 157, 8, 94, 255, 157, 8, 93, 255, 157, 8, 93, 255, 157, 7, 93, 255, 157, 7, 93, 255, 156, 7, 93, 255, 156, 7, 93, 255, 156, 7, 93, 255, 156, 7, 92, 255, 156, 7, 92, 255, 155, 7, 92, 255, 155, 7, 92, 255, 155, 7, 92, 255, 155, 6, 92, 255, 155, 6, 91, 255, 154, 6, 91, 255, 154, 6, 91, 255, 154, 6, 91, 255, 154, 6, 91, 255, 154, 6, 91, 255, 154, 6, 91, 255, 153, 6, 91, 255, 153, 6, 90, 255, 153, 6, 90, 255, 153, 5, 90, 255, 153, 5, 90, 255, 153, 5, 90, 255, 152, 5, 90, 255, 152, 5, 90, 255, 152, 5, 90, 255, 152, 5, 89, 255, 152, 5, 89, 255, 152, 5, 89, 255, 152, 5, 89, 255, 151, 5, 89, 255, 151, 5, 89, 255, 151, 5, 89, 255, 151, 5, 89, 255, 151, 4, 89, 255, 151, 4, 88, 255, 151, 4, 88, 255, 150, 4, 88, 255, 150, 4, 88, 255, 150, 4, 88, 255, 150, 4, 88, 255, 150, 4, 88, 255, 150, 4, 88, 255, 150, 4, 88, 255, 150, 4, 88, 255, 149, 4, 88, 255, 149, 4, 87, 255, 149, 4, 87, 255, 149, 4, 87, 255, 149, 4, 87, 255, 149, 4, 87, 255, 149, 3, 87, 255, 149, 3, 87, 255, 149, 3, 87, 255, 149, 3, 87, 255, 148, 3, 87, 255, 148, 3, 87, 255, 148, 3, 87, 255, 148, 3, 86, 255, 148, 3, 86, 255, 148, 3, 86, 255, 148, 3, 86, 255, 148, 3, 86, 255, 148, 3, 86, 255, 148, 3, 86, 255, 147, 3, 86, 255, 147, 3, 86, 255, 147, 3, 86, 255, 147, 3, 86, 255, 147, 3, 86, 255, 147, 3, 86, 255, 147, 3, 86, 255, 147, 3, 86, 255, 147, 3, 85, 255, 147, 3, 85, 255, 147, 3, 85, 255, 147, 2, 85, 255, 146, 2, 85, 255, 146, 2, 85, 255, 146, 2, 85, 255, 146, 2, 85, 255, 146, 2, 85, 255, 146, 2, 85, 255, 146, 2, 85, 255, 146, 2, 85, 255, 146, 2, 85, 255, 146, 2, 85, 255, 146, 2, 85, 255, 146, 2, 85, 255, 146, 2, 85, 255, 146, 2, 85, 255, 145, 2, 84, 255, 145, 2, 84, 255, 145, 2, 84, 255, 145, 2, 84, 255, 145, 2, 84, 255, 145, 2, 84, 255, 145, 2, 84, 255, 145, 2, 84, 255, 145, 2, 84, 255, 145, 2, 84, 255, 145, 2, 84, 255, 145, 2, 84, 255, 145, 2, 84, 255, 145, 2, 84, 255, 145, 2, 84, 255, 145, 2, 84, 255, 145, 2, 84, 255, 145, 2, 84, 255, 144, 2, 84, 255, 144, 2, 84, 255, 144, 2, 84, 255, 144, 2, 84, 255, 144, 2, 84, 255, 144, 2, 84, 255, 144, 2, 84, 255, 144, 2, 84, 255, 144, 2, 83, 255, 144, 1, 83, 255, 144, 1, 83, 255, 144, 1, 83, 255, 144, 1, 83, 255, 144, 1, 83, 255, 144, 1, 83, 255, 144, 1, 83, 255, 144, 1, 83, 255, 144, 1, 83, 255, 144, 1, 83, 255, 144, 1, 83, 255, 144, 1, 83, 255, 144, 1, 83, 255, 144, 1, 83, 255, 144, 1, 83, 255, 144, 1, 83, 255, 143, 1, 83, 255, 143, 1, 83, 255, 143, 1, 83, 255, 143, 1, 83, 255, 143, 1, 83, 255, 143, 1, 83, 255, 143, 1, 83, 255, 143, 1, 83, 255, 143, 1, 83, 255, 143, 1, 83, 255, 143, 1, 83, 255, 143, 1, 83, 255, 143, 1, 83, 255, 143, 1, 83, 255, 143, 1, 83, 255, 143, 1, 83, 255, 143, 1, 83, 255, 143, 1, 83, 255, 143, 1, 83, 255, 143, 1, 83, 255, 143, 1, 83, 255, 143, 1, 83, 255, 143, 1, 83, 255, 143, 1, 83, 255, 143, 1, 82, 255, 143, 1, 82, 255, 143, 1, 82, 255, 143, 1, 82, 255, 143, 1, 82, 255, 143, 1, 82, 255, 143, 1, 82, 255, 143, 1, 82, 255, 143, 1, 82, 255, 143, 1, 82, 255, 143, 1, 82, 255, 143, 1, 82, 255, 143, 1, 82, 255, 143, 1, 82, 255, 143, 1, 82, 255, 143, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 142, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 82, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255, 141, 1, 81, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PiYG_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
