/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/RdBu.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 5, 48, 97, 255, 33, 102, 172, 255, 67, 147, 195, 255, 146, 197, 222, 255, 209, 229, 240, 255, 247, 247, 247, 255, 253, 219, 199, 255, 244, 165, 130, 255, 214, 96, 77, 255, 178, 24, 43, 255, 103, 0, 31, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_RdBu_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 5, 47, 97, 0, 5, 48, 97, 7, 5, 48, 98, 14, 5, 49, 99, 22, 6, 49, 99, 29, 6, 50, 100, 37, 6, 50, 101, 44, 7, 51, 101, 52, 7, 51, 102, 59, 7, 52, 103, 67, 8, 52, 103, 74, 8, 53, 104, 82, 8, 53, 105, 89, 9, 54, 106, 97, 9, 54, 106, 104, 9, 55, 107, 112, 10, 55, 108, 119, 10, 56, 108, 127, 10, 56, 109, 134, 11, 57, 110, 141, 11, 57, 111, 149, 11, 58, 111, 156, 12, 58, 112, 164, 12, 59, 113, 171, 12, 59, 113, 179, 13, 60, 114, 186, 13, 60, 115, 194, 13, 61, 116, 201, 14, 61, 116, 209, 14, 62, 117, 216, 14, 62, 118, 224, 15, 63, 118, 231, 15, 64, 119, 239, 15, 64, 120, 246, 15, 65, 121, 254, 16, 65, 121, 255, 16, 66, 122, 255, 16, 66, 123, 255, 17, 67, 123, 255, 17, 67, 124, 255, 17, 68, 125, 255, 17, 68, 126, 255, 18, 69, 126, 255, 18, 69, 127, 255, 18, 70, 128, 255, 19, 70, 129, 255, 19, 71, 129, 255, 19, 71, 130, 255, 19, 72, 131, 255, 20, 72, 131, 255, 20, 73, 132, 255, 20, 73, 133, 255, 21, 74, 134, 255, 21, 74, 134, 255, 21, 75, 135, 255, 21, 76, 136, 255, 22, 76, 137, 255, 22, 77, 137, 255, 22, 77, 138, 255, 22, 78, 139, 255, 23, 78, 140, 255, 23, 79, 140, 255, 23, 79, 141, 255, 23, 80, 142, 255, 24, 80, 143, 255, 24, 81, 143, 255, 24, 81, 144, 255, 24, 82, 145, 255, 25, 83, 146, 255, 25, 83, 146, 255, 25, 84, 147, 255, 25, 84, 148, 255, 26, 85, 148, 255, 26, 85, 149, 255, 26, 86, 150, 255, 26, 86, 151, 255, 27, 87, 151, 255, 27, 87, 152, 255, 27, 88, 153, 255, 27, 88, 154, 255, 28, 89, 154, 255, 28, 90, 155, 255, 28, 90, 156, 255, 28, 91, 157, 255, 28, 91, 158, 255, 29, 92, 158, 255, 29, 92, 159, 255, 29, 93, 160, 255, 29, 93, 161, 255, 30, 94, 161, 255, 30, 95, 162, 255, 30, 95, 163, 255, 30, 96, 164, 255, 31, 96, 164, 255, 31, 97, 165, 255, 31, 97, 166, 255, 31, 98, 167, 255, 31, 98, 167, 255, 32, 99, 168, 255, 32, 100, 169, 255, 32, 100, 170, 255, 32, 101, 170, 255, 32, 101, 171, 255, 33, 102, 172, 255, 33, 102, 172, 255, 33, 103, 172, 255, 33, 103, 172, 255, 33, 104, 173, 255, 33, 104, 173, 255, 33, 104, 173, 255, 33, 105, 174, 255, 33, 105, 174, 255, 33, 106, 174, 255, 33, 106, 174, 255, 34, 107, 175, 255, 34, 107, 175, 255, 34, 108, 175, 255, 34, 108, 175, 255, 34, 108, 176, 255, 34, 109, 176, 255, 35, 109, 176, 255, 35, 110, 176, 255, 35, 110, 177, 255, 35, 111, 177, 255, 35, 111, 177, 255, 36, 112, 177, 255, 36, 112, 178, 255, 36, 113, 178, 255, 36, 113, 178, 255, 36, 113, 178, 255, 37, 114, 179, 255, 37, 114, 179, 255, 37, 115, 179, 255, 37, 115, 179, 255, 38, 116, 180, 255, 38, 116, 180, 255, 38, 116, 180, 255, 38, 117, 180, 255, 39, 117, 181, 255, 39, 118, 181, 255, 39, 118, 181, 255, 40, 119, 181, 255, 40, 119, 181, 255, 40, 120, 182, 255, 40, 120, 182, 255, 41, 120, 182, 255, 41, 121, 182, 255, 41, 121, 183, 255, 42, 122, 183, 255, 42, 122, 183, 255, 42, 123, 183, 255, 43, 123, 183, 255, 43, 124, 184, 255, 44, 124, 184, 255, 44, 124, 184, 255, 44, 125, 184, 255, 45, 125, 185, 255, 45, 126, 185, 255, 45, 126, 185, 255, 46, 127, 185, 255, 46, 127, 185, 255, 47, 128, 186, 255, 47, 128, 186, 255, 47, 128, 186, 255, 48, 129, 186, 255, 48, 129, 187, 255, 48, 130, 187, 255, 49, 130, 187, 255, 49, 131, 187, 255, 50, 131, 187, 255, 50, 131, 188, 255, 51, 132, 188, 255, 51, 132, 188, 255, 51, 133, 188, 255, 52, 133, 188, 255, 52, 134, 189, 255, 53, 134, 189, 255, 53, 134, 189, 255, 54, 135, 189, 255, 54, 135, 189, 255, 55, 136, 190, 255, 55, 136, 190, 255, 55, 137, 190, 255, 56, 137, 190, 255, 56, 138, 190, 255, 57, 138, 191, 255, 57, 138, 191, 255, 58, 139, 191, 255, 58, 139, 191, 255, 59, 140, 191, 255, 59, 140, 192, 255, 60, 141, 192, 255, 60, 141, 192, 255, 61, 141, 192, 255, 61, 142, 192, 255, 62, 142, 193, 255, 62, 143, 193, 255, 63, 143, 193, 255, 63, 144, 193, 255, 64, 144, 193, 255, 64, 144, 194, 255, 65, 145, 194, 255, 65, 145, 194, 255, 66, 146, 194, 255, 66, 146, 194, 255, 67, 147, 195, 255, 68, 147, 195, 255, 68, 148, 195, 255, 69, 148, 195, 255, 70, 149, 196, 255, 71, 149, 196, 255, 72, 150, 196, 255, 73, 150, 196, 255, 73, 151, 197, 255, 74, 151, 197, 255, 75, 151, 197, 255, 76, 152, 197, 255, 77, 152, 198, 255, 77, 153, 198, 255, 78, 153, 198, 255, 79, 154, 198, 255, 80, 154, 199, 255, 81, 155, 199, 255, 81, 155, 199, 255, 82, 156, 199, 255, 83, 156, 200, 255, 84, 157, 200, 255, 85, 157, 200, 255, 85, 158, 200, 255, 86, 158, 201, 255, 87, 159, 201, 255, 88, 159, 201, 255, 89, 160, 202, 255, 89, 160, 202, 255, 90, 161, 202, 255, 91, 161, 202, 255, 92, 162, 203, 255, 92, 162, 203, 255, 93, 163, 203, 255, 94, 163, 203, 255, 95, 164, 204, 255, 96, 164, 204, 255, 96, 165, 204, 255, 97, 165, 204, 255, 98, 166, 205, 255, 99, 166, 205, 255, 99, 167, 205, 255, 100, 167, 205, 255, 101, 168, 206, 255, 102, 168, 206, 255, 102, 169, 206, 255, 103, 169, 206, 255, 104, 170, 207, 255, 105, 170, 207, 255, 105, 171, 207, 255, 106, 171, 208, 255, 107, 172, 208, 255, 108, 172, 208, 255, 109, 172, 208, 255, 109, 173, 209, 255, 110, 173, 209, 255, 111, 174, 209, 255, 112, 174, 209, 255, 112, 175, 210, 255, 113, 175, 210, 255, 114, 176, 210, 255, 115, 176, 210, 255, 115, 177, 211, 255, 116, 177, 211, 255, 117, 178, 211, 255, 118, 178, 211, 255, 118, 179, 212, 255, 119, 179, 212, 255, 120, 180, 212, 255, 121, 180, 213, 255, 121, 181, 213, 255, 122, 181, 213, 255, 123, 182, 213, 255, 124, 182, 214, 255, 124, 183, 214, 255, 125, 183, 214, 255, 126, 184, 214, 255, 127, 184, 215, 255, 127, 185, 215, 255, 128, 185, 215, 255, 129, 186, 215, 255, 130, 186, 216, 255, 130, 187, 216, 255, 131, 187, 216, 255, 132, 188, 217, 255, 133, 188, 217, 255, 133, 189, 217, 255, 134, 189, 217, 255, 135, 190, 218, 255, 136, 190, 218, 255, 136, 191, 218, 255, 137, 191, 218, 255, 138, 192, 219, 255, 139, 192, 219, 255, 139, 193, 219, 255, 140, 193, 220, 255, 141, 193, 220, 255, 142, 194, 220, 255, 142, 194, 220, 255, 143, 195, 221, 255, 144, 195, 221, 255, 145, 196, 221, 255, 145, 196, 221, 255, 146, 197, 222, 255, 147, 197, 222, 255, 147, 197, 222, 255, 148, 198, 222, 255, 149, 198, 222, 255, 149, 198, 223, 255, 150, 199, 223, 255, 151, 199, 223, 255, 151, 199, 223, 255, 152, 200, 223, 255, 152, 200, 223, 255, 153, 200, 224, 255, 154, 200, 224, 255, 154, 201, 224, 255, 155, 201, 224, 255, 156, 201, 224, 255, 156, 202, 224, 255, 157, 202, 225, 255, 158, 202, 225, 255, 158, 203, 225, 255, 159, 203, 225, 255, 159, 203, 225, 255, 160, 204, 226, 255, 161, 204, 226, 255, 161, 204, 226, 255, 162, 204, 226, 255, 163, 205, 226, 255, 163, 205, 226, 255, 164, 205, 227, 255, 165, 206, 227, 255, 165, 206, 227, 255, 166, 206, 227, 255, 166, 207, 227, 255, 167, 207, 227, 255, 168, 207, 228, 255, 168, 208, 228, 255, 169, 208, 228, 255, 169, 208, 228, 255, 170, 209, 228, 255, 171, 209, 229, 255, 171, 209, 229, 255, 172, 209, 229, 255, 173, 210, 229, 255, 173, 210, 229, 255, 174, 210, 229, 255, 174, 211, 230, 255, 175, 211, 230, 255, 176, 211, 230, 255, 176, 212, 230, 255, 177, 212, 230, 255, 177, 212, 230, 255, 178, 213, 231, 255, 179, 213, 231, 255, 179, 213, 231, 255, 180, 214, 231, 255, 181, 214, 231, 255, 181, 214, 232, 255, 182, 214, 232, 255, 182, 215, 232, 255, 183, 215, 232, 255, 184, 215, 232, 255, 184, 216, 232, 255, 185, 216, 233, 255, 185, 216, 233, 255, 186, 217, 233, 255, 187, 217, 233, 255, 187, 217, 233, 255, 188, 218, 233, 255, 188, 218, 234, 255, 189, 218, 234, 255, 190, 219, 234, 255, 190, 219, 234, 255, 191, 219, 234, 255, 191, 219, 234, 255, 192, 220, 235, 255, 193, 220, 235, 255, 193, 220, 235, 255, 194, 221, 235, 255, 194, 221, 235, 255, 195, 221, 236, 255, 196, 222, 236, 255, 196, 222, 236, 255, 197, 222, 236, 255, 197, 223, 236, 255, 198, 223, 236, 255, 199, 223, 237, 255, 199, 224, 237, 255, 200, 224, 237, 255, 200, 224, 237, 255, 201, 225, 237, 255, 202, 225, 237, 255, 202, 225, 238, 255, 203, 225, 238, 255, 203, 226, 238, 255, 204, 226, 238, 255, 205, 226, 238, 255, 205, 227, 239, 255, 206, 227, 239, 255, 206, 227, 239, 255, 207, 228, 239, 255, 208, 228, 239, 255, 208, 228, 239, 255, 243, 220, 226, 255, 242, 220, 226, 255, 242, 220, 227, 255, 242, 221, 227, 255, 242, 221, 228, 255, 242, 221, 228, 255, 242, 222, 229, 255, 242, 222, 229, 255, 242, 222, 230, 255, 241, 222, 230, 255, 241, 223, 231, 255, 241, 223, 231, 255, 241, 223, 232, 255, 241, 224, 232, 255, 241, 224, 233, 255, 241, 224, 233, 255, 240, 224, 234, 255, 240, 225, 234, 255, 240, 225, 234, 255, 240, 225, 235, 255, 240, 226, 235, 255, 240, 226, 236, 255, 240, 226, 236, 255, 239, 227, 236, 255, 239, 227, 237, 255, 239, 227, 237, 255, 239, 227, 237, 255, 239, 228, 238, 255, 239, 228, 238, 255, 239, 228, 238, 255, 238, 229, 239, 255, 238, 229, 239, 255, 238, 229, 239, 255, 238, 230, 239, 255, 238, 230, 240, 255, 238, 230, 240, 255, 238, 231, 240, 255, 238, 231, 241, 255, 238, 231, 241, 255, 237, 231, 241, 255, 237, 232, 241, 255, 237, 232, 241, 255, 237, 232, 242, 255, 237, 233, 242, 255, 237, 233, 242, 255, 237, 233, 242, 255, 237, 233, 242, 255, 237, 234, 243, 255, 237, 234, 243, 255, 237, 234, 243, 255, 237, 235, 243, 255, 237, 235, 243, 255, 237, 235, 243, 255, 237, 235, 244, 255, 237, 236, 244, 255, 237, 236, 244, 255, 237, 236, 244, 255, 237, 236, 244, 255, 237, 237, 244, 255, 237, 237, 244, 255, 237, 237, 244, 255, 237, 238, 244, 255, 237, 238, 244, 255, 237, 238, 245, 255, 237, 238, 245, 255, 237, 239, 245, 255, 238, 239, 245, 255, 238, 239, 245, 255, 238, 239, 245, 255, 238, 240, 245, 255, 238, 240, 245, 255, 238, 240, 245, 255, 238, 240, 245, 255, 239, 241, 245, 255, 239, 241, 245, 255, 239, 241, 245, 255, 239, 241, 245, 255, 239, 241, 245, 255, 239, 242, 245, 255, 240, 242, 245, 255, 240, 242, 246, 255, 240, 242, 246, 255, 240, 243, 246, 255, 241, 243, 246, 255, 241, 243, 246, 255, 241, 243, 246, 255, 241, 243, 246, 255, 242, 244, 246, 255, 242, 244, 246, 255, 242, 244, 246, 255, 242, 244, 246, 255, 243, 244, 246, 255, 243, 245, 246, 255, 243, 245, 246, 255, 244, 245, 246, 255, 244, 245, 246, 255, 244, 245, 246, 255, 245, 246, 246, 255, 245, 246, 246, 255, 245, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 247, 247, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 245, 246, 255, 247, 245, 245, 255, 247, 245, 245, 255, 247, 244, 245, 255, 248, 244, 245, 255, 248, 244, 244, 255, 248, 243, 244, 255, 248, 243, 244, 255, 248, 243, 244, 255, 248, 242, 243, 255, 248, 242, 243, 255, 249, 242, 243, 255, 249, 241, 242, 255, 249, 241, 242, 255, 249, 241, 242, 255, 249, 241, 241, 255, 249, 240, 241, 255, 249, 240, 241, 255, 250, 240, 240, 255, 250, 239, 240, 255, 250, 239, 240, 255, 250, 239, 239, 255, 250, 238, 239, 255, 250, 238, 239, 255, 250, 238, 238, 255, 251, 237, 238, 255, 251, 237, 238, 255, 251, 237, 237, 255, 251, 237, 237, 255, 251, 236, 236, 255, 251, 236, 236, 255, 252, 236, 236, 255, 252, 235, 235, 255, 252, 235, 235, 255, 252, 235, 234, 255, 252, 234, 234, 255, 252, 234, 233, 255, 252, 234, 233, 255, 252, 234, 233, 255, 253, 233, 232, 255, 253, 233, 232, 255, 253, 233, 231, 255, 253, 232, 231, 255, 253, 232, 230, 255, 253, 232, 230, 255, 253, 231, 229, 255, 253, 231, 229, 255, 253, 231, 228, 255, 254, 231, 228, 255, 254, 230, 227, 255, 254, 230, 227, 255, 254, 230, 226, 255, 254, 229, 226, 255, 254, 229, 225, 255, 254, 229, 225, 255, 254, 229, 224, 255, 254, 228, 224, 255, 254, 228, 223, 255, 254, 228, 223, 255, 254, 228, 222, 255, 254, 227, 222, 255, 255, 227, 221, 255, 255, 227, 220, 255, 255, 226, 220, 255, 255, 226, 219, 255, 255, 226, 219, 255, 255, 226, 218, 255, 255, 225, 218, 255, 255, 225, 217, 255, 255, 225, 216, 255, 255, 225, 216, 255, 255, 224, 215, 255, 255, 224, 215, 255, 255, 224, 214, 255, 255, 224, 214, 255, 255, 223, 213, 255, 255, 223, 212, 255, 255, 223, 212, 255, 255, 223, 211, 255, 255, 223, 211, 255, 254, 222, 210, 255, 254, 222, 209, 255, 254, 222, 209, 255, 254, 222, 208, 255, 254, 221, 208, 255, 254, 221, 207, 255, 254, 221, 206, 255, 254, 221, 206, 255, 254, 221, 205, 255, 254, 220, 204, 255, 254, 220, 204, 255, 254, 220, 203, 255, 253, 220, 203, 255, 253, 220, 202, 255, 253, 219, 201, 255, 253, 219, 201, 255, 253, 219, 200, 255, 253, 219, 199, 255, 253, 219, 199, 255, 252, 218, 198, 255, 252, 218, 197, 255, 252, 217, 197, 255, 252, 217, 196, 255, 252, 216, 195, 255, 252, 216, 194, 255, 252, 215, 194, 255, 252, 215, 193, 255, 252, 214, 192, 255, 252, 214, 192, 255, 252, 213, 191, 255, 252, 213, 190, 255, 252, 212, 189, 255, 252, 211, 189, 255, 251, 211, 188, 255, 251, 210, 187, 255, 251, 210, 186, 255, 251, 209, 186, 255, 251, 209, 185, 255, 251, 208, 184, 255, 251, 208, 184, 255, 251, 207, 183, 255, 251, 207, 182, 255, 251, 206, 182, 255, 251, 206, 181, 255, 251, 205, 180, 255, 251, 205, 179, 255, 250, 204, 179, 255, 250, 204, 178, 255, 250, 203, 177, 255, 250, 203, 177, 255, 250, 202, 176, 255, 250, 202, 175, 255, 250, 201, 175, 255, 250, 201, 174, 255, 250, 200, 173, 255, 250, 200, 172, 255, 250, 199, 172, 255, 250, 198, 171, 255, 249, 198, 170, 255, 249, 197, 170, 255, 249, 197, 169, 255, 249, 196, 168, 255, 249, 196, 168, 255, 249, 195, 167, 255, 249, 195, 166, 255, 249, 194, 166, 255, 249, 194, 165, 255, 249, 193, 164, 255, 249, 193, 164, 255, 249, 192, 163, 255, 248, 192, 162, 255, 248, 191, 162, 255, 248, 191, 161, 255, 248, 190, 160, 255, 248, 190, 160, 255, 248, 189, 159, 255, 248, 188, 158, 255, 248, 188, 158, 255, 248, 187, 157, 255, 248, 187, 156, 255, 248, 186, 156, 255, 247, 186, 155, 255, 247, 185, 154, 255, 247, 185, 154, 255, 247, 184, 153, 255, 247, 184, 152, 255, 247, 183, 152, 255, 247, 183, 151, 255, 247, 182, 150, 255, 247, 182, 150, 255, 247, 181, 149, 255, 247, 181, 148, 255, 246, 180, 148, 255, 246, 179, 147, 255, 246, 179, 146, 255, 246, 178, 146, 255, 246, 178, 145, 255, 246, 177, 144, 255, 246, 177, 144, 255, 246, 176, 143, 255, 246, 176, 143, 255, 246, 175, 142, 255, 245, 175, 141, 255, 245, 174, 141, 255, 245, 174, 140, 255, 245, 173, 139, 255, 245, 173, 139, 255, 245, 172, 138, 255, 245, 171, 137, 255, 245, 171, 137, 255, 245, 170, 136, 255, 245, 170, 136, 255, 244, 169, 135, 255, 244, 169, 134, 255, 244, 168, 134, 255, 244, 168, 133, 255, 244, 167, 132, 255, 244, 167, 132, 255, 244, 166, 131, 255, 244, 165, 131, 255, 244, 165, 130, 255, 243, 164, 129, 255, 243, 164, 129, 255, 243, 163, 128, 255, 243, 162, 128, 255, 242, 162, 127, 255, 242, 161, 126, 255, 242, 160, 126, 255, 241, 160, 125, 255, 241, 159, 125, 255, 241, 159, 124, 255, 241, 158, 123, 255, 240, 157, 123, 255, 240, 157, 122, 255, 240, 156, 122, 255, 240, 155, 121, 255, 239, 155, 120, 255, 239, 154, 120, 255, 239, 153, 119, 255, 238, 153, 119, 255, 238, 152, 118, 255, 238, 151, 118, 255, 238, 151, 117, 255, 237, 150, 116, 255, 237, 149, 116, 255, 237, 149, 115, 255, 236, 148, 115, 255, 236, 147, 114, 255, 236, 147, 114, 255, 236, 146, 113, 255, 235, 145, 113, 255, 235, 145, 112, 255, 235, 144, 111, 255, 234, 143, 111, 255, 234, 143, 110, 255, 234, 142, 110, 255, 234, 142, 109, 255, 233, 141, 109, 255, 233, 140, 108, 255, 233, 140, 108, 255, 232, 139, 107, 255, 232, 138, 106, 255, 232, 138, 106, 255, 232, 137, 105, 255, 231, 136, 105, 255, 231, 136, 104, 255, 231, 135, 104, 255, 230, 134, 103, 255, 230, 134, 103, 255, 230, 133, 102, 255, 230, 132, 102, 255, 229, 132, 101, 255, 229, 131, 101, 255, 229, 130, 100, 255, 228, 130, 100, 255, 228, 129, 99, 255, 228, 128, 99, 255, 227, 128, 98, 255, 227, 127, 98, 255, 227, 126, 97, 255, 227, 126, 97, 255, 226, 125, 96, 255, 226, 124, 96, 255, 226, 123, 95, 255, 225, 123, 95, 255, 225, 122, 94, 255, 225, 121, 94, 255, 225, 121, 93, 255, 224, 120, 93, 255, 224, 119, 92, 255, 224, 119, 92, 255, 223, 118, 91, 255, 223, 117, 91, 255, 223, 117, 90, 255, 222, 116, 90, 255, 222, 115, 89, 255, 222, 115, 89, 255, 222, 114, 88, 255, 221, 113, 88, 255, 221, 113, 87, 255, 221, 112, 87, 255, 220, 111, 86, 255, 220, 110, 86, 255, 220, 110, 85, 255, 219, 109, 85, 255, 219, 108, 85, 255, 219, 108, 84, 255, 219, 107, 84, 255, 218, 106, 83, 255, 218, 106, 83, 255, 218, 105, 82, 255, 217, 104, 82, 255, 217, 103, 81, 255, 217, 103, 81, 255, 216, 102, 80, 255, 216, 101, 80, 255, 216, 101, 80, 255, 215, 100, 79, 255, 215, 99, 79, 255, 215, 99, 78, 255, 214, 98, 78, 255, 214, 97, 77, 255, 214, 96, 77, 255, 214, 96, 77, 255, 213, 95, 76, 255, 213, 94, 76, 255, 213, 94, 75, 255, 212, 93, 75, 255, 212, 93, 75, 255, 212, 92, 74, 255, 211, 92, 74, 255, 211, 91, 74, 255, 210, 90, 73, 255, 210, 90, 73, 255, 210, 89, 72, 255, 209, 89, 72, 255, 209, 88, 72, 255, 209, 87, 71, 255, 208, 87, 71, 255, 208, 86, 71, 255, 208, 86, 70, 255, 207, 85, 70, 255, 207, 85, 70, 255, 207, 84, 69, 255, 206, 83, 69, 255, 206, 83, 68, 255, 206, 82, 68, 255, 205, 82, 68, 255, 205, 81, 67, 255, 205, 80, 67, 255, 204, 80, 67, 255, 204, 79, 66, 255, 204, 79, 66, 255, 203, 78, 66, 255, 203, 77, 65, 255, 203, 77, 65, 255, 202, 76, 65, 255, 202, 76, 64, 255, 202, 75, 64, 255, 201, 74, 64, 255, 201, 74, 63, 255, 200, 73, 63, 255, 200, 72, 63, 255, 200, 72, 62, 255, 199, 71, 62, 255, 199, 71, 61, 255, 199, 70, 61, 255, 198, 69, 61, 255, 198, 69, 60, 255, 198, 68, 60, 255, 197, 67, 60, 255, 197, 67, 59, 255, 197, 66, 59, 255, 196, 66, 59, 255, 196, 65, 58, 255, 196, 64, 58, 255, 195, 64, 58, 255, 195, 63, 57, 255, 195, 62, 57, 255, 194, 62, 57, 255, 194, 61, 56, 255, 193, 60, 56, 255, 193, 60, 56, 255, 193, 59, 55, 255, 192, 58, 55, 255, 192, 58, 55, 255, 192, 57, 55, 255, 191, 56, 54, 255, 191, 55, 54, 255, 191, 55, 54, 255, 190, 54, 53, 255, 190, 53, 53, 255, 190, 53, 53, 255, 189, 52, 52, 255, 189, 51, 52, 255, 189, 51, 52, 255, 188, 50, 51, 255, 188, 49, 51, 255, 187, 48, 51, 255, 187, 48, 50, 255, 187, 47, 50, 255, 186, 46, 50, 255, 186, 45, 49, 255, 186, 44, 49, 255, 185, 44, 49, 255, 185, 43, 49, 255, 185, 42, 48, 255, 184, 41, 48, 255, 184, 40, 48, 255, 184, 40, 47, 255, 183, 39, 47, 255, 183, 38, 47, 255, 182, 37, 46, 255, 182, 36, 46, 255, 182, 35, 46, 255, 181, 34, 46, 255, 181, 33, 45, 255, 181, 33, 45, 255, 180, 32, 45, 255, 180, 31, 44, 255, 180, 30, 44, 255, 179, 29, 44, 255, 179, 28, 44, 255, 178, 26, 43, 255, 178, 25, 43, 255, 178, 24, 43, 255, 177, 23, 42, 255, 176, 23, 42, 255, 176, 23, 42, 255, 175, 22, 42, 255, 174, 22, 42, 255, 174, 22, 42, 255, 173, 21, 42, 255, 172, 21, 42, 255, 171, 21, 42, 255, 171, 20, 42, 255, 170, 20, 42, 255, 169, 20, 42, 255, 168, 19, 42, 255, 168, 19, 42, 255, 167, 19, 42, 255, 166, 18, 41, 255, 165, 18, 41, 255, 165, 18, 41, 255, 164, 17, 41, 255, 163, 17, 41, 255, 162, 17, 41, 255, 162, 16, 41, 255, 161, 16, 41, 255, 160, 16, 41, 255, 159, 15, 41, 255, 159, 15, 41, 255, 158, 15, 41, 255, 157, 14, 40, 255, 156, 14, 40, 255, 156, 14, 40, 255, 155, 14, 40, 255, 154, 13, 40, 255, 154, 13, 40, 255, 153, 13, 40, 255, 152, 12, 40, 255, 151, 12, 40, 255, 151, 12, 40, 255, 150, 11, 40, 255, 149, 11, 39, 255, 148, 11, 39, 255, 148, 10, 39, 255, 147, 10, 39, 255, 146, 10, 39, 255, 145, 10, 39, 255, 145, 9, 39, 255, 144, 9, 39, 255, 143, 9, 39, 255, 142, 8, 38, 255, 142, 8, 38, 255, 141, 8, 38, 255, 140, 8, 38, 255, 140, 7, 38, 255, 139, 7, 38, 255, 138, 7, 38, 255, 137, 6, 38, 255, 137, 6, 37, 255, 136, 6, 37, 255, 135, 6, 37, 255, 134, 6, 37, 255, 134, 5, 37, 255, 133, 5, 37, 255, 132, 5, 37, 255, 131, 5, 37, 255, 131, 4, 36, 255, 130, 4, 36, 255, 129, 4, 36, 255, 129, 4, 36, 255, 128, 4, 36, 255, 127, 4, 36, 255, 126, 3, 36, 255, 126, 3, 36, 255, 125, 3, 35, 255, 124, 3, 35, 255, 123, 3, 35, 255, 123, 3, 35, 255, 122, 2, 35, 255, 121, 2, 35, 255, 121, 2, 35, 255, 120, 2, 34, 255, 119, 2, 34, 255, 118, 2, 34, 255, 118, 2, 34, 255, 117, 1, 34, 255, 116, 1, 34, 255, 115, 1, 33, 255, 115, 1, 33, 255, 114, 1, 33, 255, 113, 1, 33, 255, 113, 1, 33, 255, 112, 1, 33, 255, 111, 1, 33, 255, 110, 0, 32, 255, 110, 0, 32, 255, 109, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 107, 0, 32, 255, 106, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 104, 0, 31, 255, 103, 0, 31, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_RdBu_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 5, 47, 97, 0, 5, 48, 97, 7, 5, 48, 98, 14, 5, 49, 98, 22, 5, 49, 99, 29, 6, 49, 99, 37, 6, 50, 100, 44, 6, 50, 100, 52, 6, 51, 101, 59, 7, 51, 102, 67, 7, 51, 102, 74, 7, 52, 103, 82, 8, 52, 103, 89, 8, 53, 104, 97, 8, 53, 104, 104, 8, 53, 105, 112, 9, 54, 105, 119, 9, 54, 106, 127, 9, 55, 107, 134, 9, 55, 107, 141, 10, 55, 108, 149, 10, 56, 108, 156, 10, 56, 109, 164, 11, 57, 109, 171, 11, 57, 110, 179, 11, 57, 111, 186, 11, 58, 111, 194, 12, 58, 112, 201, 12, 59, 112, 209, 12, 59, 113, 216, 12, 59, 113, 224, 13, 60, 114, 231, 13, 60, 115, 239, 13, 61, 115, 246, 13, 61, 116, 254, 13, 62, 116, 255, 14, 62, 117, 255, 14, 62, 117, 255, 14, 63, 118, 255, 14, 63, 119, 255, 15, 64, 119, 255, 15, 64, 120, 255, 15, 64, 120, 255, 15, 65, 121, 255, 16, 65, 122, 255, 16, 66, 122, 255, 16, 66, 123, 255, 16, 67, 123, 255, 16, 67, 124, 255, 17, 67, 124, 255, 17, 68, 125, 255, 17, 68, 126, 255, 23, 79, 141, 255, 23, 80, 142, 255, 23, 80, 142, 255, 24, 81, 143, 255, 24, 81, 144, 255, 24, 82, 144, 255, 24, 82, 145, 255, 24, 82, 145, 255, 25, 83, 146, 255, 25, 83, 147, 255, 25, 84, 147, 255, 25, 84, 148, 255, 25, 85, 148, 255, 26, 85, 149, 255, 26, 85, 150, 255, 26, 86, 150, 255, 26, 86, 151, 255, 26, 87, 151, 255, 27, 87, 152, 255, 27, 88, 152, 255, 27, 88, 153, 255, 27, 88, 154, 255, 27, 89, 154, 255, 28, 89, 155, 255, 28, 90, 155, 255, 28, 90, 156, 255, 28, 91, 157, 255, 28, 91, 157, 255, 29, 92, 158, 255, 29, 92, 158, 255, 29, 92, 159, 255, 29, 93, 160, 255, 29, 93, 160, 255, 29, 94, 161, 255, 30, 94, 162, 255, 30, 95, 162, 255, 30, 95, 163, 255, 30, 96, 163, 255, 30, 96, 164, 255, 31, 96, 165, 255, 31, 97, 165, 255, 31, 97, 166, 255, 31, 98, 166, 255, 31, 98, 167, 255, 31, 99, 168, 255, 32, 99, 168, 255, 32, 100, 169, 255, 32, 100, 169, 255, 32, 100, 170, 255, 32, 101, 171, 255, 32, 101, 171, 255, 33, 102, 172, 255, 33, 102, 172, 255, 33, 102, 172, 255, 33, 103, 172, 255, 33, 103, 172, 255, 33, 104, 173, 255, 33, 104, 173, 255, 33, 104, 173, 255, 33, 105, 173, 255, 33, 105, 174, 255, 33, 105, 174, 255, 33, 106, 174, 255, 34, 106, 174, 255, 34, 106, 174, 255, 34, 107, 175, 255, 34, 107, 175, 255, 34, 107, 175, 255, 34, 108, 175, 255, 34, 108, 175, 255, 34, 109, 176, 255, 35, 109, 176, 255, 35, 109, 176, 255, 35, 110, 176, 255, 35, 110, 176, 255, 35, 110, 177, 255, 35, 111, 177, 255, 36, 111, 177, 255, 36, 111, 177, 255, 36, 112, 177, 255, 36, 112, 178, 255, 36, 112, 178, 255, 37, 113, 178, 255, 37, 113, 178, 255, 37, 113, 178, 255, 37, 114, 179, 255, 37, 114, 179, 255, 38, 115, 179, 255, 38, 115, 179, 255, 38, 115, 179, 255, 38, 116, 179, 255, 39, 116, 180, 255, 39, 116, 180, 255, 39, 117, 180, 255, 39, 117, 180, 255, 40, 117, 180, 255, 40, 118, 181, 255, 40, 118, 181, 255, 40, 118, 181, 255, 41, 119, 181, 255, 41, 119, 181, 255, 41, 119, 181, 255, 48, 129, 186, 255, 49, 129, 186, 255, 49, 130, 187, 255, 49, 130, 187, 255, 50, 130, 187, 255, 50, 131, 187, 255, 50, 131, 187, 255, 51, 131, 187, 255, 51, 132, 188, 255, 51, 132, 188, 255, 51, 132, 188, 255, 52, 133, 188, 255, 52, 133, 188, 255, 52, 133, 188, 255, 53, 134, 189, 255, 53, 134, 189, 255, 53, 134, 189, 255, 54, 135, 189, 255, 54, 135, 189, 255, 54, 135, 189, 255, 55, 136, 190, 255, 55, 136, 190, 255, 55, 137, 190, 255, 56, 137, 190, 255, 56, 137, 190, 255, 57, 138, 190, 255, 57, 138, 191, 255, 57, 138, 191, 255, 58, 139, 191, 255, 58, 139, 191, 255, 58, 139, 191, 255, 59, 140, 191, 255, 59, 140, 192, 255, 60, 140, 192, 255, 60, 141, 192, 255, 60, 141, 192, 255, 61, 141, 192, 255, 61, 142, 192, 255, 61, 142, 193, 255, 62, 142, 193, 255, 62, 143, 193, 255, 63, 143, 193, 255, 63, 143, 193, 255, 63, 144, 193, 255, 64, 144, 193, 255, 64, 145, 194, 255, 65, 145, 194, 255, 65, 145, 194, 255, 65, 146, 194, 255, 66, 146, 194, 255, 66, 146, 194, 255, 67, 147, 195, 255, 67, 147, 195, 255, 68, 147, 195, 255, 69, 148, 195, 255, 69, 148, 195, 255, 70, 149, 196, 255, 71, 149, 196, 255, 71, 149, 196, 255, 72, 150, 196, 255, 73, 150, 196, 255, 73, 150, 197, 255, 74, 151, 197, 255, 75, 151, 197, 255, 75, 152, 197, 255, 76, 152, 197, 255, 77, 152, 198, 255, 77, 153, 198, 255, 78, 153, 198, 255, 78, 154, 198, 255, 79, 154, 198, 255, 80, 154, 199, 255, 80, 155, 199, 255, 81, 155, 199, 255, 82, 156, 199, 255, 82, 156, 200, 255, 83, 156, 200, 255, 84, 157, 200, 255, 84, 157, 200, 255, 85, 158, 200, 255, 85, 158, 201, 255, 86, 158, 201, 255, 87, 159, 201, 255, 87, 159, 201, 255, 88, 159, 201, 255, 89, 160, 202, 255, 89, 160, 202, 255, 90, 161, 202, 255, 90, 161, 202, 255, 91, 161, 202, 255, 92, 162, 203, 255, 92, 162, 203, 255, 93, 163, 203, 255, 93, 163, 203, 255, 94, 163, 203, 255, 95, 164, 204, 255, 95, 164, 204, 255, 96, 165, 204, 255, 96, 165, 204, 255, 97, 165, 204, 255, 98, 166, 205, 255, 98, 166, 205, 255, 115, 177, 211, 255, 115, 177, 211, 255, 116, 177, 211, 255, 117, 178, 211, 255, 117, 178, 211, 255, 118, 178, 212, 255, 118, 179, 212, 255, 119, 179, 212, 255, 120, 180, 212, 255, 120, 180, 212, 255, 121, 180, 213, 255, 121, 181, 213, 255, 122, 181, 213, 255, 123, 182, 213, 255, 123, 182, 213, 255, 124, 182, 214, 255, 124, 183, 214, 255, 125, 183, 214, 255, 126, 184, 214, 255, 126, 184, 215, 255, 127, 184, 215, 255, 127, 185, 215, 255, 128, 185, 215, 255, 129, 186, 215, 255, 129, 186, 216, 255, 130, 186, 216, 255, 130, 187, 216, 255, 131, 187, 216, 255, 132, 187, 216, 255, 132, 188, 217, 255, 133, 188, 217, 255, 133, 189, 217, 255, 134, 189, 217, 255, 135, 189, 218, 255, 135, 190, 218, 255, 136, 190, 218, 255, 136, 191, 218, 255, 137, 191, 218, 255, 138, 191, 219, 255, 138, 192, 219, 255, 139, 192, 219, 255, 139, 193, 219, 255, 140, 193, 219, 255, 141, 193, 220, 255, 141, 194, 220, 255, 142, 194, 220, 255, 142, 194, 220, 255, 143, 195, 221, 255, 144, 195, 221, 255, 144, 196, 221, 255, 145, 196, 221, 255, 145, 196, 221, 255, 146, 197, 222, 255, 146, 197, 222, 255, 147, 197, 222, 255, 147, 197, 222, 255, 148, 198, 222, 255, 149, 198, 222, 255, 149, 198, 222, 255, 150, 198, 223, 255, 150, 199, 223, 255, 151, 199, 223, 255, 151, 199, 223, 255, 152, 199, 223, 255, 152, 200, 223, 255, 153, 200, 223, 255, 153, 200, 224, 255, 154, 200, 224, 255, 154, 201, 224, 255, 155, 201, 224, 255, 155, 201, 224, 255, 156, 201, 224, 255, 156, 202, 224, 255, 157, 202, 225, 255, 157, 202, 225, 255, 158, 202, 225, 255, 158, 203, 225, 255, 159, 203, 225, 255, 159, 203, 225, 255, 160, 203, 225, 255, 160, 204, 226, 255, 161, 204, 226, 255, 161, 204, 226, 255, 162, 204, 226, 255, 162, 205, 226, 255, 163, 205, 226, 255, 163, 205, 226, 255, 164, 205, 227, 255, 164, 206, 227, 255, 165, 206, 227, 255, 165, 206, 227, 255, 166, 206, 227, 255, 166, 207, 227, 255, 167, 207, 227, 255, 167, 207, 228, 255, 168, 207, 228, 255, 168, 208, 228, 255, 169, 208, 228, 255, 169, 208, 228, 255, 170, 208, 228, 255, 170, 209, 228, 255, 171, 209, 229, 255, 171, 209, 229, 255, 184, 216, 232, 255, 185, 216, 233, 255, 185, 216, 233, 255, 186, 217, 233, 255, 186, 217, 233, 255, 187, 217, 233, 255, 187, 217, 233, 255, 188, 218, 233, 255, 188, 218, 234, 255, 189, 218, 234, 255, 189, 218, 234, 255, 190, 219, 234, 255, 190, 219, 234, 255, 191, 219, 234, 255, 191, 219, 234, 255, 191, 220, 235, 255, 192, 220, 235, 255, 192, 220, 235, 255, 193, 220, 235, 255, 193, 221, 235, 255, 194, 221, 235, 255, 194, 221, 235, 255, 195, 221, 235, 255, 195, 222, 236, 255, 196, 222, 236, 255, 196, 222, 236, 255, 197, 222, 236, 255, 197, 223, 236, 255, 198, 223, 236, 255, 198, 223, 236, 255, 199, 223, 237, 255, 199, 224, 237, 255, 200, 224, 237, 255, 200, 224, 237, 255, 201, 224, 237, 255, 201, 225, 237, 255, 202, 225, 237, 255, 202, 225, 238, 255, 203, 225, 238, 255, 203, 226, 238, 255, 203, 226, 238, 255, 204, 226, 238, 255, 204, 226, 238, 255, 205, 227, 238, 255, 205, 227, 239, 255, 206, 227, 239, 255, 206, 227, 239, 255, 207, 228, 239, 255, 207, 228, 239, 255, 208, 228, 239, 255, 208, 228, 239, 255, 236, 222, 229, 255, 236, 222, 229, 255, 236, 222, 229, 255, 235, 222, 230, 255, 235, 222, 230, 255, 235, 223, 231, 255, 235, 223, 231, 255, 235, 223, 231, 255, 235, 223, 232, 255, 235, 224, 232, 255, 235, 224, 233, 255, 235, 224, 233, 255, 234, 224, 233, 255, 234, 225, 234, 255, 234, 225, 234, 255, 234, 225, 234, 255, 234, 225, 235, 255, 234, 226, 235, 255, 234, 226, 235, 255, 234, 226, 236, 255, 234, 226, 236, 255, 233, 226, 236, 255, 233, 227, 237, 255, 233, 227, 237, 255, 233, 227, 237, 255, 233, 227, 237, 255, 233, 228, 238, 255, 233, 228, 238, 255, 233, 228, 238, 255, 233, 228, 239, 255, 232, 229, 239, 255, 232, 229, 239, 255, 232, 229, 239, 255, 232, 229, 239, 255, 232, 230, 240, 255, 232, 230, 240, 255, 232, 230, 240, 255, 232, 230, 240, 255, 232, 231, 240, 255, 232, 231, 241, 255, 232, 231, 241, 255, 232, 231, 241, 255, 231, 232, 241, 255, 231, 232, 241, 255, 231, 232, 242, 255, 231, 232, 242, 255, 231, 232, 242, 255, 231, 233, 242, 255, 231, 233, 242, 255, 231, 233, 242, 255, 231, 233, 242, 255, 239, 237, 244, 255, 239, 237, 244, 255, 239, 238, 244, 255, 239, 238, 244, 255, 239, 238, 244, 255, 239, 238, 244, 255, 239, 238, 244, 255, 239, 239, 245, 255, 239, 239, 245, 255, 239, 239, 245, 255, 239, 239, 245, 255, 239, 240, 245, 255, 239, 240, 245, 255, 239, 240, 245, 255, 239, 240, 245, 255, 239, 240, 245, 255, 239, 241, 245, 255, 240, 241, 245, 255, 240, 241, 245, 255, 240, 241, 245, 255, 240, 241, 245, 255, 240, 242, 245, 255, 240, 242, 245, 255, 240, 242, 246, 255, 240, 242, 246, 255, 241, 242, 246, 255, 241, 242, 246, 255, 241, 243, 246, 255, 241, 243, 246, 255, 241, 243, 246, 255, 241, 243, 246, 255, 242, 243, 246, 255, 242, 244, 246, 255, 242, 244, 246, 255, 242, 244, 246, 255, 242, 244, 246, 255, 243, 244, 246, 255, 243, 244, 246, 255, 243, 245, 246, 255, 243, 245, 246, 255, 244, 245, 246, 255, 244, 245, 246, 255, 244, 245, 246, 255, 244, 245, 246, 255, 245, 245, 246, 255, 245, 246, 246, 255, 245, 246, 246, 255, 245, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 247, 247, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 245, 246, 255, 247, 245, 246, 255, 247, 245, 245, 255, 247, 245, 245, 255, 247, 244, 245, 255, 247, 244, 245, 255, 248, 244, 245, 255, 248, 244, 244, 255, 248, 243, 244, 255, 248, 243, 244, 255, 248, 243, 244, 255, 248, 243, 243, 255, 248, 242, 243, 255, 248, 242, 243, 255, 249, 242, 243, 255, 249, 242, 242, 255, 249, 241, 242, 255, 249, 241, 242, 255, 249, 241, 242, 255, 249, 241, 241, 255, 249, 240, 241, 255, 249, 240, 241, 255, 249, 240, 241, 255, 250, 240, 240, 255, 250, 240, 240, 255, 250, 239, 240, 255, 250, 239, 239, 255, 250, 239, 239, 255, 250, 239, 239, 255, 250, 238, 238, 255, 250, 238, 238, 255, 251, 238, 238, 255, 251, 238, 237, 255, 251, 237, 237, 255, 251, 237, 237, 255, 251, 237, 236, 255, 251, 237, 236, 255, 251, 236, 236, 255, 251, 236, 235, 255, 251, 236, 235, 255, 251, 236, 235, 255, 252, 235, 234, 255, 252, 235, 234, 255, 252, 235, 234, 255, 252, 235, 233, 255, 252, 234, 233, 255, 252, 234, 232, 255, 252, 234, 232, 255, 253, 228, 222, 255, 253, 228, 222, 255, 253, 228, 221, 255, 254, 227, 221, 255, 254, 227, 220, 255, 254, 227, 220, 255, 254, 227, 220, 255, 254, 227, 219, 255, 254, 226, 219, 255, 254, 226, 218, 255, 254, 226, 218, 255, 254, 226, 217, 255, 254, 226, 217, 255, 254, 225, 217, 255, 254, 225, 216, 255, 254, 225, 216, 255, 254, 225, 215, 255, 254, 224, 215, 255, 254, 224, 214, 255, 254, 224, 214, 255, 254, 224, 213, 255, 254, 224, 213, 255, 254, 223, 212, 255, 254, 223, 212, 255, 254, 223, 211, 255, 254, 223, 211, 255, 254, 223, 211, 255, 254, 222, 210, 255, 254, 222, 210, 255, 254, 222, 209, 255, 254, 222, 209, 255, 254, 222, 208, 255, 254, 222, 208, 255, 254, 221, 207, 255, 254, 221, 207, 255, 254, 221, 206, 255, 254, 221, 206, 255, 254, 221, 205, 255, 254, 220, 205, 255, 254, 220, 204, 255, 254, 220, 204, 255, 254, 220, 203, 255, 253, 220, 203, 255, 253, 220, 202, 255, 253, 219, 202, 255, 253, 219, 201, 255, 253, 219, 201, 255, 253, 219, 200, 255, 253, 219, 200, 255, 253, 219, 199, 255, 253, 219, 199, 255, 252, 218, 198, 255, 252, 218, 198, 255, 252, 217, 197, 255, 252, 217, 196, 255, 252, 217, 196, 255, 252, 216, 195, 255, 252, 216, 195, 255, 252, 215, 194, 255, 252, 215, 193, 255, 252, 215, 193, 255, 252, 214, 192, 255, 252, 214, 192, 255, 252, 213, 191, 255, 252, 213, 191, 255, 252, 212, 190, 255, 252, 212, 189, 255, 252, 212, 189, 255, 251, 211, 188, 255, 251, 211, 188, 255, 251, 210, 187, 255, 251, 210, 187, 255, 251, 210, 186, 255, 251, 209, 185, 255, 251, 209, 185, 255, 251, 208, 184, 255, 251, 208, 184, 255, 251, 207, 183, 255, 251, 207, 183, 255, 251, 207, 182, 255, 251, 206, 182, 255, 251, 206, 181, 255, 251, 205, 180, 255, 251, 205, 180, 255, 250, 205, 179, 255, 250, 204, 179, 255, 250, 204, 178, 255, 250, 203, 178, 255, 250, 203, 177, 255, 250, 202, 177, 255, 250, 202, 176, 255, 250, 202, 175, 255, 250, 201, 175, 255, 250, 201, 174, 255, 250, 200, 174, 255, 250, 200, 173, 255, 250, 200, 173, 255, 250, 199, 172, 255, 250, 199, 172, 255, 249, 198, 171, 255, 249, 198, 171, 255, 249, 197, 170, 255, 247, 186, 156, 255, 247, 186, 155, 255, 247, 185, 155, 255, 247, 185, 154, 255, 247, 185, 154, 255, 247, 184, 153, 255, 247, 184, 152, 255, 247, 183, 152, 255, 247, 183, 151, 255, 247, 182, 151, 255, 247, 182, 150, 255, 247, 182, 150, 255, 247, 181, 149, 255, 247, 181, 149, 255, 246, 180, 148, 255, 246, 180, 148, 255, 246, 179, 147, 255, 246, 179, 147, 255, 246, 179, 146, 255, 246, 178, 146, 255, 246, 178, 145, 255, 246, 177, 145, 255, 246, 177, 144, 255, 246, 176, 144, 255, 246, 176, 143, 255, 246, 176, 142, 255, 246, 175, 142, 255, 245, 175, 141, 255, 245, 174, 141, 255, 245, 174, 140, 255, 245, 173, 140, 255, 245, 173, 139, 255, 245, 173, 139, 255, 245, 172, 138, 255, 245, 172, 138, 255, 245, 171, 137, 255, 245, 171, 137, 255, 245, 170, 136, 255, 245, 170, 136, 255, 244, 170, 135, 255, 244, 169, 135, 255, 244, 169, 134, 255, 244, 168, 134, 255, 244, 168, 133, 255, 244, 167, 133, 255, 244, 167, 132, 255, 244, 167, 132, 255, 244, 166, 131, 255, 244, 166, 131, 255, 244, 165, 130, 255, 244, 165, 130, 255, 243, 164, 129, 255, 243, 164, 129, 255, 243, 163, 128, 255, 243, 163, 128, 255, 243, 162, 127, 255, 242, 162, 127, 255, 242, 161, 127, 255, 242, 161, 126, 255, 242, 160, 126, 255, 241, 160, 125, 255, 241, 159, 125, 255, 241, 159, 124, 255, 241, 158, 124, 255, 241, 158, 123, 255, 240, 157, 123, 255, 240, 157, 122, 255, 240, 156, 122, 255, 240, 156, 121, 255, 239, 155, 121, 255, 239, 155, 120, 255, 239, 154, 120, 255, 239, 153, 120, 255, 239, 153, 119, 255, 238, 152, 119, 255, 238, 152, 118, 255, 238, 151, 118, 255, 238, 151, 117, 255, 237, 150, 117, 255, 237, 150, 116, 255, 237, 149, 116, 255, 237, 149, 115, 255, 236, 148, 115, 255, 236, 148, 115, 255, 236, 147, 114, 255, 236, 147, 114, 255, 236, 146, 113, 255, 235, 146, 113, 255, 235, 145, 112, 255, 235, 145, 112, 255, 235, 144, 112, 255, 234, 143, 111, 255, 234, 143, 111, 255, 234, 142, 110, 255, 234, 142, 110, 255, 233, 141, 109, 255, 233, 141, 109, 255, 233, 140, 109, 255, 233, 140, 108, 255, 233, 139, 108, 255, 232, 139, 107, 255, 232, 138, 107, 255, 226, 124, 96, 255, 226, 123, 95, 255, 225, 123, 95, 255, 225, 122, 95, 255, 225, 122, 94, 255, 225, 121, 94, 255, 224, 121, 93, 255, 224, 120, 93, 255, 224, 120, 93, 255, 224, 119, 92, 255, 224, 118, 92, 255, 223, 118, 91, 255, 223, 117, 91, 255, 223, 117, 91, 255, 223, 116, 90, 255, 222, 116, 90, 255, 222, 115, 89, 255, 222, 115, 89, 255, 222, 114, 89, 255, 221, 114, 88, 255, 221, 113, 88, 255, 221, 112, 87, 255, 221, 112, 87, 255, 220, 111, 87, 255, 220, 111, 86, 255, 220, 110, 86, 255, 220, 110, 86, 255, 219, 109, 85, 255, 219, 109, 85, 255, 219, 108, 84, 255, 219, 107, 84, 255, 218, 107, 84, 255, 218, 106, 83, 255, 218, 106, 83, 255, 218, 105, 83, 255, 218, 105, 82, 255, 217, 104, 82, 255, 217, 104, 81, 255, 217, 103, 81, 255, 217, 102, 81, 255, 216, 102, 80, 255, 216, 101, 80, 255, 216, 101, 80, 255, 216, 100, 79, 255, 215, 100, 79, 255, 215, 99, 79, 255, 215, 98, 78, 255, 215, 98, 78, 255, 214, 97, 78, 255, 214, 97, 77, 255, 214, 96, 77, 255, 214, 96, 77, 255, 213, 95, 76, 255, 213, 95, 76, 255, 213, 94, 76, 255, 212, 94, 75, 255, 212, 93, 75, 255, 212, 93, 75, 255, 212, 92, 74, 255, 211, 92, 74, 255, 211, 91, 74, 255, 211, 91, 74, 255, 211, 91, 73, 255, 210, 90, 73, 255, 210, 90, 73, 255, 210, 89, 72, 255, 209, 89, 72, 255, 209, 88, 72, 255, 209, 88, 72, 255, 209, 87, 71, 255, 208, 87, 71, 255, 208, 86, 71, 255, 208, 86, 70, 255, 208, 85, 70, 255, 207, 85, 70, 255, 207, 84, 70, 255, 207, 84, 69, 255, 206, 83, 69, 255, 206, 83, 69, 255, 206, 82, 68, 255, 206, 82, 68, 255, 205, 81, 68, 255, 205, 81, 68, 255, 205, 81, 67, 255, 204, 80, 67, 255, 204, 80, 67, 255, 204, 79, 66, 255, 204, 79, 66, 255, 203, 78, 66, 255, 203, 78, 66, 255, 203, 77, 65, 255, 203, 77, 65, 255, 202, 76, 65, 255, 202, 76, 64, 255, 202, 75, 64, 255, 201, 75, 64, 255, 201, 74, 64, 255, 201, 74, 63, 255, 201, 73, 63, 255, 200, 73, 63, 255, 200, 72, 63, 255, 200, 72, 62, 255, 199, 71, 62, 255, 192, 56, 55, 255, 192, 56, 55, 255, 191, 55, 54, 255, 191, 54, 54, 255, 191, 54, 54, 255, 191, 53, 54, 255, 190, 53, 53, 255, 190, 52, 53, 255, 190, 52, 53, 255, 189, 51, 53, 255, 189, 51, 52, 255, 189, 50, 52, 255, 189, 50, 52, 255, 188, 49, 52, 255, 188, 49, 51, 255, 188, 48, 51, 255, 187, 47, 51, 255, 187, 47, 51, 255, 187, 46, 50, 255, 187, 46, 50, 255, 186, 45, 50, 255, 186, 45, 50, 255, 186, 44, 49, 255, 185, 43, 49, 255, 185, 43, 49, 255, 185, 42, 49, 255, 185, 42, 48, 255, 184, 41, 48, 255, 184, 40, 48, 255, 184, 40, 48, 255, 183, 39, 47, 255, 183, 38, 47, 255, 183, 38, 47, 255, 183, 37, 47, 255, 182, 36, 46, 255, 182, 36, 46, 255, 182, 35, 46, 255, 181, 34, 46, 255, 181, 34, 45, 255, 181, 33, 45, 255, 181, 32, 45, 255, 180, 31, 45, 255, 180, 31, 44, 255, 180, 30, 44, 255, 179, 29, 44, 255, 179, 28, 44, 255, 179, 28, 44, 255, 179, 27, 43, 255, 178, 26, 43, 255, 178, 25, 43, 255, 178, 24, 43, 255, 177, 23, 42, 255, 177, 23, 42, 255, 176, 23, 42, 255, 175, 23, 42, 255, 175, 22, 42, 255, 174, 22, 42, 255, 174, 22, 42, 255, 173, 21, 42, 255, 173, 21, 42, 255, 172, 21, 42, 255, 171, 21, 42, 255, 171, 20, 42, 255, 170, 20, 42, 255, 170, 20, 42, 255, 169, 20, 42, 255, 168, 19, 42, 255, 168, 19, 42, 255, 167, 19, 42, 255, 167, 19, 42, 255, 166, 18, 41, 255, 165, 18, 41, 255, 165, 18, 41, 255, 164, 18, 41, 255, 164, 17, 41, 255, 163, 17, 41, 255, 162, 17, 41, 255, 162, 17, 41, 255, 161, 16, 41, 255, 161, 16, 41, 255, 160, 16, 41, 255, 160, 16, 41, 255, 159, 15, 41, 255, 158, 15, 41, 255, 158, 15, 40, 255, 157, 15, 40, 255, 157, 14, 40, 255, 156, 14, 40, 255, 155, 14, 40, 255, 155, 14, 40, 255, 154, 13, 40, 255, 154, 13, 40, 255, 153, 13, 40, 255, 152, 13, 40, 255, 152, 12, 40, 255, 151, 12, 40, 255, 151, 12, 39, 255, 150, 12, 39, 255, 149, 11, 39, 255, 149, 11, 39, 255, 148, 11, 39, 255, 148, 11, 39, 255, 132, 6, 36, 255, 132, 5, 36, 255, 131, 5, 36, 255, 130, 5, 36, 255, 130, 5, 36, 255, 129, 5, 36, 255, 129, 5, 36, 255, 128, 4, 36, 255, 127, 4, 36, 255, 127, 4, 36, 255, 126, 4, 35, 255, 126, 4, 35, 255, 125, 3, 35, 255, 125, 3, 35, 255, 124, 3, 35, 255, 123, 3, 35, 255, 123, 3, 35, 255, 122, 3, 35, 255, 122, 3, 35, 255, 121, 2, 35, 255, 120, 2, 34, 255, 120, 2, 34, 255, 119, 2, 34, 255, 119, 2, 34, 255, 118, 2, 34, 255, 118, 2, 34, 255, 117, 2, 34, 255, 116, 1, 34, 255, 116, 1, 33, 255, 115, 1, 33, 255, 115, 1, 33, 255, 114, 1, 33, 255, 113, 1, 33, 255, 113, 1, 33, 255, 112, 1, 33, 255, 112, 1, 33, 255, 111, 1, 32, 255, 111, 0, 32, 255, 110, 0, 32, 255, 109, 0, 32, 255, 109, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 107, 0, 32, 255, 107, 0, 31, 255, 106, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 103, 0, 31, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_RdBu_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 5, 47, 97, 0, 7, 51, 102, 24, 10, 55, 108, 49, 12, 59, 113, 74, 14, 63, 119, 99, 17, 67, 124, 124, 24, 82, 145, 149, 26, 86, 151, 174, 28, 90, 156, 199, 30, 94, 162, 224, 31, 98, 167, 249, 33, 102, 172, 255, 33, 106, 174, 255, 35, 109, 176, 255, 36, 112, 178, 255, 38, 115, 179, 255, 40, 118, 181, 255, 50, 130, 187, 255, 52, 133, 188, 255, 55, 136, 190, 255, 58, 139, 191, 255, 61, 142, 192, 255, 65, 145, 194, 255, 69, 148, 195, 255, 74, 151, 197, 255, 79, 154, 199, 255, 84, 157, 200, 255, 89, 160, 202, 255, 94, 163, 203, 255, 99, 166, 205, 255, 119, 179, 212, 255, 124, 182, 214, 255, 128, 185, 215, 255, 133, 188, 217, 255, 137, 191, 218, 255, 142, 194, 220, 255, 146, 197, 222, 255, 150, 198, 223, 255, 153, 200, 224, 255, 157, 202, 225, 255, 160, 204, 226, 255, 164, 205, 227, 255, 167, 207, 228, 255, 171, 209, 229, 255, 187, 217, 233, 255, 190, 219, 234, 255, 193, 220, 235, 255, 196, 222, 236, 255, 199, 224, 237, 255, 202, 225, 238, 255, 206, 227, 239, 255, 236, 222, 228, 255, 235, 223, 231, 255, 234, 224, 233, 255, 234, 226, 235, 255, 233, 227, 237, 255, 232, 229, 239, 255, 232, 230, 240, 255, 231, 232, 241, 255, 231, 233, 242, 255, 239, 238, 244, 255, 239, 239, 245, 255, 239, 240, 245, 255, 240, 241, 245, 255, 241, 242, 246, 255, 242, 243, 246, 255, 243, 244, 246, 255, 244, 245, 246, 255, 246, 246, 246, 255, 247, 246, 246, 255, 247, 245, 245, 255, 248, 243, 244, 255, 249, 242, 243, 255, 249, 241, 241, 255, 250, 239, 240, 255, 250, 238, 238, 255, 251, 237, 237, 255, 251, 236, 235, 255, 252, 235, 233, 255, 253, 228, 221, 255, 254, 227, 219, 255, 254, 226, 217, 255, 254, 225, 215, 255, 254, 224, 213, 255, 254, 223, 211, 255, 254, 222, 209, 255, 254, 221, 207, 255, 254, 220, 204, 255, 253, 220, 202, 255, 253, 219, 200, 255, 252, 218, 198, 255, 252, 216, 195, 255, 252, 214, 193, 255, 252, 213, 190, 255, 251, 211, 188, 255, 251, 209, 185, 255, 251, 207, 183, 255, 251, 206, 181, 255, 250, 204, 178, 255, 250, 202, 176, 255, 250, 201, 174, 255, 250, 199, 172, 255, 249, 197, 170, 255, 247, 185, 154, 255, 247, 183, 152, 255, 247, 182, 150, 255, 246, 180, 148, 255, 246, 178, 146, 255, 246, 177, 144, 255, 246, 175, 142, 255, 245, 174, 140, 255, 245, 172, 138, 255, 245, 171, 137, 255, 244, 169, 135, 255, 244, 168, 133, 255, 244, 166, 131, 255, 244, 165, 130, 255, 243, 163, 128, 255, 242, 161, 127, 255, 241, 160, 125, 255, 241, 158, 123, 255, 240, 156, 122, 255, 239, 155, 120, 255, 238, 153, 119, 255, 238, 151, 118, 255, 237, 150, 116, 255, 236, 148, 115, 255, 236, 146, 113, 255, 235, 145, 112, 255, 234, 143, 111, 255, 234, 142, 110, 255, 233, 140, 108, 255, 232, 138, 107, 255, 226, 123, 95, 255, 225, 122, 94, 255, 224, 120, 93, 255, 224, 119, 92, 255, 223, 117, 91, 255, 222, 116, 90, 255, 222, 114, 89, 255, 221, 113, 88, 255, 220, 111, 87, 255, 220, 110, 86, 255, 219, 108, 85, 255, 218, 107, 84, 255, 218, 106, 83, 255, 217, 104, 82, 255, 217, 103, 81, 255, 216, 101, 80, 255, 215, 100, 79, 255, 215, 99, 78, 255, 214, 97, 77, 255, 214, 96, 77, 255, 213, 95, 76, 255, 212, 94, 75, 255, 212, 93, 75, 255, 211, 91, 74, 255, 211, 90, 73, 255, 210, 89, 73, 255, 209, 88, 72, 255, 209, 87, 71, 255, 208, 86, 71, 255, 208, 85, 70, 255, 207, 84, 69, 255, 206, 83, 69, 255, 206, 82, 68, 255, 205, 81, 68, 255, 205, 80, 67, 255, 204, 79, 67, 255, 204, 78, 66, 255, 203, 77, 65, 255, 202, 76, 65, 255, 202, 75, 64, 255, 201, 75, 64, 255, 201, 74, 63, 255, 200, 73, 63, 255, 200, 72, 62, 255, 192, 56, 55, 255, 192, 55, 55, 255, 191, 54, 54, 255, 191, 54, 54, 255, 190, 53, 53, 255, 190, 52, 53, 255, 189, 51, 52, 255, 189, 50, 52, 255, 188, 49, 52, 255, 188, 48, 51, 255, 187, 47, 51, 255, 187, 46, 50, 255, 186, 45, 50, 255, 186, 44, 49, 255, 185, 43, 49, 255, 185, 42, 49, 255, 185, 41, 48, 255, 184, 40, 48, 255, 184, 40, 48, 255, 183, 39, 47, 255, 183, 38, 47, 255, 182, 37, 46, 255, 182, 36, 46, 255, 182, 35, 46, 255, 181, 34, 45, 255, 181, 33, 45, 255, 180, 32, 45, 255, 180, 31, 44, 255, 180, 30, 44, 255, 179, 29, 44, 255, 179, 28, 44, 255, 178, 26, 43, 255, 178, 25, 43, 255, 178, 24, 43, 255, 177, 23, 42, 255, 176, 23, 42, 255, 176, 23, 42, 255, 175, 22, 42, 255, 174, 22, 42, 255, 174, 22, 42, 255, 173, 21, 42, 255, 172, 21, 42, 255, 172, 21, 42, 255, 171, 20, 42, 255, 170, 20, 42, 255, 170, 20, 42, 255, 169, 20, 42, 255, 168, 19, 42, 255, 168, 19, 42, 255, 167, 19, 42, 255, 166, 18, 41, 255, 166, 18, 41, 255, 165, 18, 41, 255, 165, 18, 41, 255, 164, 17, 41, 255, 163, 17, 41, 255, 163, 17, 41, 255, 162, 17, 41, 255, 162, 16, 41, 255, 161, 16, 41, 255, 160, 16, 41, 255, 160, 16, 41, 255, 159, 15, 41, 255, 159, 15, 41, 255, 158, 15, 41, 255, 158, 15, 40, 255, 157, 15, 40, 255, 157, 14, 40, 255, 156, 14, 40, 255, 156, 14, 40, 255, 155, 14, 40, 255, 155, 14, 40, 255, 154, 13, 40, 255, 154, 13, 40, 255, 153, 13, 40, 255, 153, 13, 40, 255, 152, 13, 40, 255, 152, 12, 40, 255, 151, 12, 40, 255, 151, 12, 39, 255, 151, 12, 39, 255, 150, 12, 39, 255, 150, 11, 39, 255, 149, 11, 39, 255, 149, 11, 39, 255, 148, 11, 39, 255, 148, 11, 39, 255, 148, 11, 39, 255, 147, 11, 39, 255, 132, 6, 36, 255, 131, 5, 36, 255, 131, 5, 36, 255, 131, 5, 36, 255, 130, 5, 36, 255, 130, 5, 36, 255, 130, 5, 36, 255, 129, 5, 36, 255, 129, 5, 36, 255, 129, 4, 36, 255, 128, 4, 36, 255, 128, 4, 36, 255, 128, 4, 36, 255, 127, 4, 36, 255, 127, 4, 36, 255, 127, 4, 36, 255, 126, 4, 35, 255, 126, 4, 35, 255, 126, 4, 35, 255, 125, 4, 35, 255, 125, 3, 35, 255, 125, 3, 35, 255, 124, 3, 35, 255, 124, 3, 35, 255, 124, 3, 35, 255, 123, 3, 35, 255, 123, 3, 35, 255, 123, 3, 35, 255, 123, 3, 35, 255, 122, 3, 35, 255, 122, 3, 35, 255, 122, 3, 35, 255, 121, 3, 35, 255, 121, 3, 35, 255, 121, 2, 35, 255, 121, 2, 34, 255, 120, 2, 34, 255, 120, 2, 34, 255, 120, 2, 34, 255, 120, 2, 34, 255, 119, 2, 34, 255, 119, 2, 34, 255, 119, 2, 34, 255, 119, 2, 34, 255, 119, 2, 34, 255, 118, 2, 34, 255, 118, 2, 34, 255, 118, 2, 34, 255, 118, 2, 34, 255, 117, 2, 34, 255, 117, 2, 34, 255, 117, 2, 34, 255, 117, 2, 34, 255, 117, 2, 34, 255, 116, 1, 34, 255, 116, 1, 34, 255, 116, 1, 34, 255, 116, 1, 33, 255, 116, 1, 33, 255, 115, 1, 33, 255, 115, 1, 33, 255, 115, 1, 33, 255, 115, 1, 33, 255, 115, 1, 33, 255, 115, 1, 33, 255, 114, 1, 33, 255, 114, 1, 33, 255, 114, 1, 33, 255, 114, 1, 33, 255, 114, 1, 33, 255, 114, 1, 33, 255, 113, 1, 33, 255, 113, 1, 33, 255, 113, 1, 33, 255, 113, 1, 33, 255, 113, 1, 33, 255, 113, 1, 33, 255, 112, 1, 33, 255, 112, 1, 33, 255, 112, 1, 33, 255, 112, 1, 33, 255, 112, 1, 33, 255, 112, 1, 33, 255, 112, 1, 33, 255, 111, 1, 33, 255, 111, 1, 33, 255, 111, 1, 33, 255, 111, 1, 32, 255, 111, 1, 32, 255, 111, 1, 32, 255, 111, 0, 32, 255, 111, 0, 32, 255, 110, 0, 32, 255, 110, 0, 32, 255, 110, 0, 32, 255, 110, 0, 32, 255, 110, 0, 32, 255, 110, 0, 32, 255, 110, 0, 32, 255, 110, 0, 32, 255, 110, 0, 32, 255, 109, 0, 32, 255, 109, 0, 32, 255, 109, 0, 32, 255, 109, 0, 32, 255, 109, 0, 32, 255, 109, 0, 32, 255, 109, 0, 32, 255, 109, 0, 32, 255, 109, 0, 32, 255, 109, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 107, 0, 32, 255, 107, 0, 32, 255, 107, 0, 32, 255, 107, 0, 32, 255, 107, 0, 32, 255, 107, 0, 32, 255, 107, 0, 32, 255, 107, 0, 32, 255, 107, 0, 32, 255, 107, 0, 32, 255, 107, 0, 31, 255, 107, 0, 31, 255, 107, 0, 31, 255, 107, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 30, 255, 103, 0, 30, 255, 103, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_RdBu_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
