/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */

#ifndef _SH4LT_TIME_INFO_H_
#define _SH4LT_TIME_INFO_H_

#include <stdint.h>

struct sh4lt_time_info {
  int64_t system_clock_date;  //< time in nanoseconds since epoch.
  int64_t steady_clock_date;  //< time in nanoseconds with a steady clock time since epoch.
  int64_t buffer_number;      //< current buffer index, starting from zero.
  int64_t buffer_date;        //< playhead date for the beginning of the buffer, in nanoseconds.
  int64_t buffer_duration;    //< buffer duration, in nanoseconds.
};

typedef struct sh4lt_time_info sh4lt_time_info_t;

#endif
