Module pre_post_processing.step
===============================

Classes
-------

`Debug(num_inputs: int = 1, name: Optional[str] = None)`
:   Step that can be arbitrarily inserted in the pre or post processing pipeline.
    It will make the outputs of the previous Step also become graph outputs so their value can be more easily debugged.
    
    The output will be duplicated into two outputs, one will be renamed with a suffix "_next",
    another will be renamed with a suffix "_debug". The "_next" outputs will feed into the next step,
    the "_debug" outputs will become graph outputs.
    
    Initialize Debug step
    Args:
        num_inputs: Number of inputs from previous Step to make graph outputs.
        name: Optional name for Step. Defaults to 'Debug'

    ### Ancestors (in MRO)

    * pre_post_processing.step.Step

`Step(inputs: List[str], outputs: List[str], name: Optional[str] = None)`
:   Base class for a pre or post processing step.
    
    Initialize the step.
    
    Args:
        inputs: List of default input names.
        outputs: List of default output names.
        name: Step name. Defaults to the derived class name.

    ### Descendants

    * pre_post_processing.step.Debug
    * pre_post_processing.steps.general.ArgMax
    * pre_post_processing.steps.general.Identity
    * pre_post_processing.steps.general.ReverseAxis
    * pre_post_processing.steps.general.Softmax
    * pre_post_processing.steps.general.Split
    * pre_post_processing.steps.general.Squeeze
    * pre_post_processing.steps.general.Transpose
    * pre_post_processing.steps.general.Unsqueeze
    * pre_post_processing.steps.nlp.BertTokenizer
    * pre_post_processing.steps.nlp.BertTokenizerQADecoder
    * pre_post_processing.steps.nlp.SentencePieceTokenizer
    * pre_post_processing.steps.vision.CenterCrop
    * pre_post_processing.steps.vision.ConvertBGRToImage
    * pre_post_processing.steps.vision.ConvertImageToBGR
    * pre_post_processing.steps.vision.DrawBoundingBoxes
    * pre_post_processing.steps.vision.FloatToImageBytes
    * pre_post_processing.steps.vision.ImageBytesToFloat
    * pre_post_processing.steps.vision.LetterBox
    * pre_post_processing.steps.vision.Normalize
    * pre_post_processing.steps.vision.PixelsToYCbCr
    * pre_post_processing.steps.vision.Resize
    * pre_post_processing.steps.vision.ScaleNMSBoundingBoxesAndKeyPoints
    * pre_post_processing.steps.vision.SelectBestBoundingBoxesByNMS
    * pre_post_processing.steps.vision.SplitOutBoxAndScoreWithConf
    * pre_post_processing.steps.vision.YCbCrToPixels

    ### Class variables

    `prefix`
    :

    ### Methods

    `apply(self, graph: onnx.onnx_ml_pb2.GraphProto, checker_context: onnx.onnx_cpp2py_export.checker.CheckerContext, graph_outputs_to_maintain: List[str])`
    :   Create a graph for this step that can be appended to the provided graph.
        The PrePostProcessor will handle merging the two.
        
        Args:
            graph_outputs_to_maintain: List of output names to maintain in the graph by additional effort.
                For outputs having multiple consumers, these outputs will be consumed by default and prevent
                connection from the subsequent steps.
                This outputs is generated by IOEntryValuePreserver.

    `connect(self, entry: pre_post_processing.utils.IoMapEntry)`
    :   Connect the value name from a previous step to an input of this step so they match.
        This makes joining the GraphProto created by each step trivial.