# indentedGrammarExample.py
#
# Copyright (c) 2006,2016  Paul McGuire
#
# A sample of a pyparsing grammar using indentation for
# grouping (like Python does).
#
# Updated to use IndentedBlock helper method.
#

from pyparsing import *


data = """\
def A(z):
  A1
  B = 100
  G = A2
  A2
  A3
B
def BB(a,b,c):
  BB1
  def BBA():
    bba1
    bba2
    bba3
C
D
def spam(x,y):
     def eggs(z):
         pass
"""


stmt = Forward()
suite = IndentedBlock(stmt)

identifier = Word(alphas, alphanums)
funcDecl = (
    "def" + identifier + Group("(" + Optional(DelimitedList(identifier)) + ")") + ":"
)
funcDef = Group(funcDecl + suite)

rvalue = Forward()
funcCall = Group(identifier + "(" + Optional(DelimitedList(rvalue)) + ")")
rvalue << (funcCall | identifier | Word(nums))
assignment = Group(identifier + "=" + rvalue)
stmt << (funcDef | assignment | identifier)

module_body = OneOrMore(stmt)

print(data)
parseTree = module_body.parse_string(data)
parseTree.pprint()
