// This file implements the IDebugDocumentTextAuthor Interface and Gateway for Python.
// Generated by makegw.py

#include "stdafx.h"
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "PyIDebugDocumentInfo.h"
#include "PyIDebugDocument.h"
#include "PyIDebugDocumentText.h"
#include "PyIDebugDocumentTextAuthor.h"

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIDebugDocumentTextAuthor::PyIDebugDocumentTextAuthor(IUnknown *pdisp) : PyIDebugDocumentText(pdisp)
{
    ob_type = &type;
}

PyIDebugDocumentTextAuthor::~PyIDebugDocumentTextAuthor() {}

/* static */ IDebugDocumentTextAuthor *PyIDebugDocumentTextAuthor::GetI(PyObject *self)
{
    return (IDebugDocumentTextAuthor *)PyIDebugDocumentText::GetI(self);
}

// @pymethod |PyIDebugDocumentTextAuthor|InsertText|Description of InsertText.
PyObject *PyIDebugDocumentTextAuthor::InsertText(PyObject *self, PyObject *args)
{
    IDebugDocumentTextAuthor *pIDDTA = GetI(self);
    if (pIDDTA == NULL)
        return NULL;
    // @pyparm int|cCharacterPosition||Description for cCharacterPosition
    // @pyparm int|cNumToInsert||Description for cNumToInsert
    // @pyparm <o unicode>|pcharText||Description for pcharText
    PyObject *obpcharText;
    ULONG cCharacterPosition;
    ULONG cNumToInsert;
    BSTR pcharText;
    if (!PyArg_ParseTuple(args, "iiO:InsertText", &cCharacterPosition, &cNumToInsert, &obpcharText))
        return NULL;
    BOOL bPythonIsHappy = TRUE;
    if (!PyCom_BstrFromPyObject(obpcharText, &pcharText))
        bPythonIsHappy = FALSE;
    if (!bPythonIsHappy)
        return NULL;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIDDTA->InsertText(cCharacterPosition, cNumToInsert, pcharText);
    if (pcharText)
        SysFreeString(pcharText);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return OleSetOleError(hr);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIDebugDocumentTextAuthor|RemoveText|Description of RemoveText.
PyObject *PyIDebugDocumentTextAuthor::RemoveText(PyObject *self, PyObject *args)
{
    IDebugDocumentTextAuthor *pIDDTA = GetI(self);
    if (pIDDTA == NULL)
        return NULL;
    // @pyparm int|cCharacterPosition||Description for cCharacterPosition
    // @pyparm int|cNumToRemove||Description for cNumToRemove
    ULONG cCharacterPosition;
    ULONG cNumToRemove;
    if (!PyArg_ParseTuple(args, "ii:RemoveText", &cCharacterPosition, &cNumToRemove))
        return NULL;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIDDTA->RemoveText(cCharacterPosition, cNumToRemove);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return OleSetOleError(hr);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIDebugDocumentTextAuthor|ReplaceText|Description of ReplaceText.
PyObject *PyIDebugDocumentTextAuthor::ReplaceText(PyObject *self, PyObject *args)
{
    IDebugDocumentTextAuthor *pIDDTA = GetI(self);
    if (pIDDTA == NULL)
        return NULL;
    // @pyparm int|cCharacterPosition||Description for cCharacterPosition
    // @pyparm int|cNumToReplace||Description for cNumToReplace
    // @pyparm <o unicode>|pcharText||Description for pcharText
    PyObject *obpcharText;
    ULONG cCharacterPosition;
    ULONG cNumToReplace;
    BSTR pcharText;
    if (!PyArg_ParseTuple(args, "iiO:ReplaceText", &cCharacterPosition, &cNumToReplace, &obpcharText))
        return NULL;
    BOOL bPythonIsHappy = TRUE;
    if (!PyCom_BstrFromPyObject(obpcharText, &pcharText))
        bPythonIsHappy = FALSE;
    if (!bPythonIsHappy)
        return NULL;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIDDTA->ReplaceText(cCharacterPosition, cNumToReplace, pcharText);
    if (pcharText)
        SysFreeString(pcharText);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return OleSetOleError(hr);
    Py_INCREF(Py_None);
    return Py_None;
}

// @object PyIDebugDocumentTextAuthor|This preliminary interface is provided by text documents that support editing.
// Derived from <o PyIDebugDocumentText>
static struct PyMethodDef PyIDebugDocumentTextAuthor_methods[] = {
    {"InsertText", PyIDebugDocumentTextAuthor::InsertText, 1},    // @pymeth InsertText|Description of InsertText
    {"RemoveText", PyIDebugDocumentTextAuthor::RemoveText, 1},    // @pymeth RemoveText|Description of RemoveText
    {"ReplaceText", PyIDebugDocumentTextAuthor::ReplaceText, 1},  // @pymeth ReplaceText|Description of ReplaceText
    {NULL}};

PyComTypeObject PyIDebugDocumentTextAuthor::type("PyIDebugDocumentTextAuthor", &PyIDebugDocumentText::type,
                                                 sizeof(PyIDebugDocumentTextAuthor), PyIDebugDocumentTextAuthor_methods,
                                                 GET_PYCOM_CTOR(PyIDebugDocumentTextAuthor));
// ---------------------------------------------------
//
// Gateway Implementation

// Std delegation
// IDebugDocumentInfo
STDMETHODIMP PyGDebugDocumentTextAuthor::GetName(DOCUMENTNAMETYPE dnt, BSTR *pbstrName)
{
    return PyGDebugDocumentText::GetName(dnt, pbstrName);
}
STDMETHODIMP PyGDebugDocumentTextAuthor::GetDocumentClassId(CLSID *pclsidDocument)
{
    return PyGDebugDocumentText::GetDocumentClassId(pclsidDocument);
}

// IDebugDocument
STDMETHODIMP PyGDebugDocumentTextAuthor::GetDocumentAttributes(TEXT_DOC_ATTR __RPC_FAR *ptextdocattr)
{
    return PyGDebugDocumentText::GetDocumentAttributes(ptextdocattr);
}

STDMETHODIMP PyGDebugDocumentTextAuthor::GetSize(ULONG __RPC_FAR *pcNumLines, ULONG __RPC_FAR *pcNumChars)
{
    return PyGDebugDocumentText::GetSize(pcNumLines, pcNumChars);
}
STDMETHODIMP PyGDebugDocumentTextAuthor::GetPositionOfLine(ULONG cLineNumber, ULONG __RPC_FAR *pcCharacterPosition)
{
    return PyGDebugDocumentText::GetPositionOfLine(cLineNumber, pcCharacterPosition);
}
STDMETHODIMP PyGDebugDocumentTextAuthor::GetLineOfPosition(ULONG cCharacterPosition, ULONG __RPC_FAR *pcLineNumber,
                                                           ULONG __RPC_FAR *pcCharacterOffsetInLine)
{
    return PyGDebugDocumentText::GetLineOfPosition(cCharacterPosition, pcLineNumber, pcCharacterOffsetInLine);
}
STDMETHODIMP PyGDebugDocumentTextAuthor::GetText(ULONG cCharacterPosition, WCHAR __RPC_FAR *pcharText,
                                                 SOURCE_TEXT_ATTR __RPC_FAR *pstaTextAttr, ULONG __RPC_FAR *pcNumChars,
                                                 ULONG cMaxChars)
{
    return PyGDebugDocumentText::GetText(cCharacterPosition, pcharText, pstaTextAttr, pcNumChars, cMaxChars);
}

STDMETHODIMP PyGDebugDocumentTextAuthor::GetPositionOfContext(IDebugDocumentContext __RPC_FAR *psc,
                                                              ULONG __RPC_FAR *pcCharacterPosition,
                                                              ULONG __RPC_FAR *cNumChars)
{
    return PyGDebugDocumentText::GetPositionOfContext(psc, pcCharacterPosition, cNumChars);
}
STDMETHODIMP PyGDebugDocumentTextAuthor::GetContextOfPosition(ULONG cCharacterPosition, ULONG cNumChars,
                                                              IDebugDocumentContext __RPC_FAR *__RPC_FAR *ppsc)
{
    return PyGDebugDocumentText::GetContextOfPosition(cCharacterPosition, cNumChars, ppsc);
}

STDMETHODIMP PyGDebugDocumentTextAuthor::InsertText(
    /* [in] */ ULONG cCharacterPosition,
    /* [in] */ ULONG cNumToInsert,
    /* [size_is][in] */ OLECHAR __RPC_FAR pcharText[])
{
    PY_GATEWAY_METHOD;
    PyObject *obpcharText;
    obpcharText = PyWinObject_FromOLECHAR(pcharText);
    HRESULT hr = InvokeViaPolicy("InsertText", NULL, "iiO", cCharacterPosition, cNumToInsert, obpcharText);
    Py_XDECREF(obpcharText);
    return hr;
}

STDMETHODIMP PyGDebugDocumentTextAuthor::RemoveText(
    /* [in] */ ULONG cCharacterPosition,
    /* [in] */ ULONG cNumToRemove)
{
    PY_GATEWAY_METHOD;
    HRESULT hr = InvokeViaPolicy("RemoveText", NULL, "ii", cCharacterPosition, cNumToRemove);
    return hr;
}

STDMETHODIMP PyGDebugDocumentTextAuthor::ReplaceText(
    /* [in] */ ULONG cCharacterPosition,
    /* [in] */ ULONG cNumToReplace,
    /* [size_is][in] */ OLECHAR __RPC_FAR pcharText[])
{
    PY_GATEWAY_METHOD;
    PyObject *obpcharText;
    obpcharText = PyWinObject_FromOLECHAR(pcharText);
    HRESULT hr = InvokeViaPolicy("ReplaceText", NULL, "iiO", cCharacterPosition, cNumToReplace, obpcharText);
    Py_XDECREF(obpcharText);
    return hr;
}
