/* this is a file autogenerated by spice_codegen.py */
/*
  Copyright (C) 2013 Red Hat, Inc.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, see <http://www.gnu.org/licenses/>.
*/

#include <config.h>
#include "common/messages.h"
#include <string.h>
#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <spice/protocol.h>
#include <spice/macros.h>
#include "common/marshaller.h"

#ifdef _MSC_VER
#pragma warning(disable:4101)
#pragma warning(disable:4018)
#endif

void spice_marshall_msg_migrate(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgMigrate *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgMigrate *src;
    src = (const SpiceMsgMigrate *)msg;

    spice_marshaller_add_uint32(m, src->flags);
}

void spice_marshall_SpiceMsgData(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgData *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
}

void spice_marshall_msg_set_ack(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgSetAck *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgSetAck *src;
    src = (const SpiceMsgSetAck *)msg;

    spice_marshaller_add_uint32(m, src->generation);
    spice_marshaller_add_uint32(m, src->window);
}

void spice_marshall_msg_ping(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgPing *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgPing *src;
    src = (const SpiceMsgPing *)msg;

    spice_marshaller_add_uint32(m, src->id);
    spice_marshaller_add_uint64(m, src->timestamp);
    /* Remaining data must be appended manually */
}

void spice_marshall_msg_wait_for_channels(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgWaitForChannels *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgWaitForChannels *src;
    const SpiceWaitForChannel *  wait_list__element;
    uint32_t i;
    src = (const SpiceMsgWaitForChannels *)msg;

    spice_marshaller_add_uint8(m, src->wait_count);
    wait_list__element = src->wait_list;
    for (i = 0; i < src->wait_count; i++) {
        const SpiceWaitForChannel *src2;
        src2 = (const SpiceWaitForChannel *)wait_list__element;

        spice_marshaller_add_uint8(m, src2->channel_type);
        spice_marshaller_add_uint8(m, src2->channel_id);
        spice_marshaller_add_uint64(m, src2->message_serial);
        wait_list__element++;
    }
}

void spice_marshall_msg_disconnecting(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisconnect *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgDisconnect *src;
    src = (const SpiceMsgDisconnect *)msg;

    spice_marshaller_add_uint64(m, src->time_stamp);
    spice_marshaller_add_uint32(m, src->reason);
}

void spice_marshall_msg_notify(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgNotify *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgNotify *src;
    src = (const SpiceMsgNotify *)msg;

    spice_marshaller_add_uint64(m, src->time_stamp);
    spice_marshaller_add_uint32(m, src->severity);
    spice_marshaller_add_uint32(m, src->visibilty);
    spice_marshaller_add_uint32(m, src->what);
    spice_marshaller_add_uint32(m, src->message_len);
    /* Don't marshall @nomarshal message */
}

void spice_marshall_SpiceMsgEmpty(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgEmpty *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
}

SPICE_GNUC_UNUSED static void spice_marshall_array_uint8(SpiceMarshaller *m, const uint8_t *ptr, unsigned count)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    uint32_t i;

    for (i = 0; i < count; i++) {
        spice_marshaller_add_uint8(m, *ptr++);
    }
}

void spice_marshall_msg_main_migrate_begin(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgMainMigrationBegin *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgMainMigrationBegin *src;
    src = (const SpiceMsgMainMigrationBegin *)msg;

    /* dst_info */ {
        spice_marshaller_add_uint16(m, src->dst_info.port);
        spice_marshaller_add_uint16(m, src->dst_info.sport);
        spice_marshaller_add_uint32(m, src->dst_info.host_size);
        m2 = spice_marshaller_get_ptr_submarshaller(m);
        spice_marshall_array_uint8(m2, src->dst_info.host_data, src->dst_info.host_size);
        spice_marshaller_add_uint32(m, src->dst_info.cert_subject_size);
        m2 = spice_marshaller_get_ptr_submarshaller(m);
        if (src->dst_info.cert_subject_data != NULL) {
            spice_marshall_array_uint8(m2, src->dst_info.cert_subject_data, src->dst_info.cert_subject_size);
        }
    }
}

void spice_marshall_msg_main_init(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgMainInit *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgMainInit *src;
    src = (const SpiceMsgMainInit *)msg;

    spice_marshaller_add_uint32(m, src->session_id);
    spice_marshaller_add_uint32(m, src->display_channels_hint);
    spice_marshaller_add_uint32(m, src->supported_mouse_modes);
    spice_marshaller_add_uint32(m, src->current_mouse_mode);
    spice_marshaller_add_uint32(m, src->agent_connected);
    spice_marshaller_add_uint32(m, src->agent_tokens);
    spice_marshaller_add_uint32(m, src->multi_media_time);
    spice_marshaller_add_uint32(m, src->ram_hint);
}

void spice_marshall_msg_main_channels_list(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgChannels *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgChannels *src;
    const SpiceChannelId *  channels__element;
    uint32_t i;
    src = (const SpiceMsgChannels *)msg;

    spice_marshaller_add_uint32(m, src->num_of_channels);
    channels__element = src->channels;
    for (i = 0; i < src->num_of_channels; i++) {
        const SpiceChannelId *src2;
        src2 = (const SpiceChannelId *)channels__element;

        spice_marshaller_add_uint8(m, src2->type);
        spice_marshaller_add_uint8(m, src2->id);
        channels__element++;
    }
}

void spice_marshall_msg_main_mouse_mode(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgMainMouseMode *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgMainMouseMode *src;
    src = (const SpiceMsgMainMouseMode *)msg;

    spice_marshaller_add_uint16(m, src->supported_modes);
    spice_marshaller_add_uint16(m, src->current_mode);
}

void spice_marshall_msg_main_multi_media_time(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgMainMultiMediaTime *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgMainMultiMediaTime *src;
    src = (const SpiceMsgMainMultiMediaTime *)msg;

    spice_marshaller_add_uint32(m, src->time);
}

void spice_marshall_msg_main_agent_disconnected(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgMainAgentDisconnect *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgMainAgentDisconnect *src;
    src = (const SpiceMsgMainAgentDisconnect *)msg;

    spice_marshaller_add_uint32(m, src->error_code);
}

void spice_marshall_msg_main_agent_token(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgMainAgentTokens *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgMainAgentTokens *src;
    src = (const SpiceMsgMainAgentTokens *)msg;

    spice_marshaller_add_uint32(m, src->num_tokens);
}

void spice_marshall_msg_main_migrate_switch_host(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgMainMigrationSwitchHost *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgMainMigrationSwitchHost *src;
    src = (const SpiceMsgMainMigrationSwitchHost *)msg;

    spice_marshaller_add_uint16(m, src->port);
    spice_marshaller_add_uint16(m, src->sport);
    spice_marshaller_add_uint32(m, src->host_size);
    m2 = spice_marshaller_get_ptr_submarshaller(m);
    if (src->host_data != NULL) {
        spice_marshall_array_uint8(m2, src->host_data, src->host_size);
    }
    spice_marshaller_add_uint32(m, src->cert_subject_size);
    m2 = spice_marshaller_get_ptr_submarshaller(m);
    if (src->cert_subject_data != NULL) {
        spice_marshall_array_uint8(m2, src->cert_subject_data, src->cert_subject_size);
    }
}

void spice_marshall_msg_main_name(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgMainName *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgMainName *src;
    const uint8_t *  name__element;
    uint32_t i;
    src = (const SpiceMsgMainName *)msg;

    spice_marshaller_add_uint32(m, src->name_len);
    name__element = src->name;
    for (i = 0; i < src->name_len; i++) {
        spice_marshaller_add_uint8(m, *name__element);
        name__element++;
    }
}

void spice_marshall_msg_main_uuid(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgMainUuid *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgMainUuid *src;
    const uint8_t *  uuid__element;
    uint32_t i;
    src = (const SpiceMsgMainUuid *)msg;

    uuid__element = src->uuid;
    for (i = 0; i < 16; i++) {
        spice_marshaller_add_uint8(m, *uuid__element);
        uuid__element++;
    }
}

void spice_marshall_msg_main_agent_connected_tokens(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgMainAgentConnectedTokens *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgMainAgentConnectedTokens *src;
    src = (const SpiceMsgMainAgentConnectedTokens *)msg;

    spice_marshaller_add_uint32(m, src->num_tokens);
}

void spice_marshall_msg_main_migrate_begin_seamless(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgMainMigrateBeginSeamless *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgMainMigrateBeginSeamless *src;
    src = (const SpiceMsgMainMigrateBeginSeamless *)msg;

    /* dst_info */ {
        spice_marshaller_add_uint16(m, src->dst_info.port);
        spice_marshaller_add_uint16(m, src->dst_info.sport);
        spice_marshaller_add_uint32(m, src->dst_info.host_size);
        m2 = spice_marshaller_get_ptr_submarshaller(m);
        spice_marshall_array_uint8(m2, src->dst_info.host_data, src->dst_info.host_size);
        spice_marshaller_add_uint32(m, src->dst_info.cert_subject_size);
        m2 = spice_marshaller_get_ptr_submarshaller(m);
        if (src->dst_info.cert_subject_data != NULL) {
            spice_marshall_array_uint8(m2, src->dst_info.cert_subject_data, src->dst_info.cert_subject_size);
        }
    }
    spice_marshaller_add_uint32(m, src->src_mig_version);
}

void spice_marshall_msg_display_mode(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayMode *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgDisplayMode *src;
    src = (const SpiceMsgDisplayMode *)msg;

    spice_marshaller_add_uint32(m, src->x_res);
    spice_marshaller_add_uint32(m, src->y_res);
    spice_marshaller_add_uint32(m, src->bits);
}

void spice_marshall_msg_display_copy_bits(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayCopyBits *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgDisplayCopyBits *src;
    uint32_t i;
    src = (const SpiceMsgDisplayCopyBits *)msg;

    /* base */ {
        spice_marshaller_add_uint32(m, src->base.surface_id);
        /* box */ {
            spice_marshaller_add_int32(m, src->base.box.top);
            spice_marshaller_add_int32(m, src->base.box.left);
            spice_marshaller_add_int32(m, src->base.box.bottom);
            spice_marshaller_add_int32(m, src->base.box.right);
        }
        /* clip */ {
            spice_marshaller_add_uint8(m, src->base.clip.type);
            if (src->base.clip.type == SPICE_CLIP_TYPE_RECTS) {
                const SpiceRect *  rects__element;
                spice_marshaller_add_uint32(m, src->base.clip.rects->num_rects);
                rects__element = src->base.clip.rects->rects;
                for (i = 0; i < src->base.clip.rects->num_rects; i++) {
                    const SpiceRect *src2;
                    src2 = (const SpiceRect *)rects__element;

                    spice_marshaller_add_int32(m, src2->top);
                    spice_marshaller_add_int32(m, src2->left);
                    spice_marshaller_add_int32(m, src2->bottom);
                    spice_marshaller_add_int32(m, src2->right);
                    rects__element++;
                }
            }
        }
    }
    /* src_pos */ {
        spice_marshaller_add_int32(m, src->src_pos.x);
        spice_marshaller_add_int32(m, src->src_pos.y);
    }
}

void spice_marshall_msg_display_inval_list(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceResourceList *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceResourceList *src;
    const SpiceResourceID *  resources__element;
    uint32_t i;
    src = (const SpiceResourceList *)msg;

    spice_marshaller_add_uint16(m, src->count);
    resources__element = src->resources;
    for (i = 0; i < src->count; i++) {
        const SpiceResourceID *src2;
        src2 = (const SpiceResourceID *)resources__element;

        spice_marshaller_add_uint8(m, src2->type);
        spice_marshaller_add_uint64(m, src2->id);
        resources__element++;
    }
}

void spice_marshall_msg_display_inval_all_pixmaps(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgWaitForChannels *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgWaitForChannels *src;
    const SpiceWaitForChannel *  wait_list__element;
    uint32_t i;
    src = (const SpiceMsgWaitForChannels *)msg;

    spice_marshaller_add_uint8(m, src->wait_count);
    wait_list__element = src->wait_list;
    for (i = 0; i < src->wait_count; i++) {
        const SpiceWaitForChannel *src2;
        src2 = (const SpiceWaitForChannel *)wait_list__element;

        spice_marshaller_add_uint8(m, src2->channel_type);
        spice_marshaller_add_uint8(m, src2->channel_id);
        spice_marshaller_add_uint64(m, src2->message_serial);
        wait_list__element++;
    }
}

void spice_marshall_msg_display_inval_palette(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayInvalOne *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgDisplayInvalOne *src;
    src = (const SpiceMsgDisplayInvalOne *)msg;

    spice_marshaller_add_uint64(m, src->id);
}

void spice_marshall_msg_display_stream_create(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayStreamCreate *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgDisplayStreamCreate *src;
    uint32_t i;
    src = (const SpiceMsgDisplayStreamCreate *)msg;

    spice_marshaller_add_uint32(m, src->surface_id);
    spice_marshaller_add_uint32(m, src->id);
    spice_marshaller_add_uint8(m, src->flags);
    spice_marshaller_add_uint8(m, src->codec_type);
    spice_marshaller_add_uint64(m, src->stamp);
    spice_marshaller_add_uint32(m, src->stream_width);
    spice_marshaller_add_uint32(m, src->stream_height);
    spice_marshaller_add_uint32(m, src->src_width);
    spice_marshaller_add_uint32(m, src->src_height);
    /* dest */ {
        spice_marshaller_add_int32(m, src->dest.top);
        spice_marshaller_add_int32(m, src->dest.left);
        spice_marshaller_add_int32(m, src->dest.bottom);
        spice_marshaller_add_int32(m, src->dest.right);
    }
    /* clip */ {
        spice_marshaller_add_uint8(m, src->clip.type);
        if (src->clip.type == SPICE_CLIP_TYPE_RECTS) {
            const SpiceRect *  rects__element;
            spice_marshaller_add_uint32(m, src->clip.rects->num_rects);
            rects__element = src->clip.rects->rects;
            for (i = 0; i < src->clip.rects->num_rects; i++) {
                const SpiceRect *src2;
                src2 = (const SpiceRect *)rects__element;

                spice_marshaller_add_int32(m, src2->top);
                spice_marshaller_add_int32(m, src2->left);
                spice_marshaller_add_int32(m, src2->bottom);
                spice_marshaller_add_int32(m, src2->right);
                rects__element++;
            }
        }
    }
}

void spice_marshall_msg_display_stream_data(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayStreamData *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgDisplayStreamData *src;
    src = (const SpiceMsgDisplayStreamData *)msg;

    /* base */ {
        spice_marshaller_add_uint32(m, src->base.id);
        spice_marshaller_add_uint32(m, src->base.multi_media_time);
    }
    spice_marshaller_add_uint32(m, src->data_size);
    /* Don't marshall @nomarshal data */
}

void spice_marshall_msg_display_stream_clip(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayStreamClip *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgDisplayStreamClip *src;
    uint32_t i;
    src = (const SpiceMsgDisplayStreamClip *)msg;

    spice_marshaller_add_uint32(m, src->id);
    /* clip */ {
        spice_marshaller_add_uint8(m, src->clip.type);
        if (src->clip.type == SPICE_CLIP_TYPE_RECTS) {
            const SpiceRect *  rects__element;
            spice_marshaller_add_uint32(m, src->clip.rects->num_rects);
            rects__element = src->clip.rects->rects;
            for (i = 0; i < src->clip.rects->num_rects; i++) {
                const SpiceRect *src2;
                src2 = (const SpiceRect *)rects__element;

                spice_marshaller_add_int32(m, src2->top);
                spice_marshaller_add_int32(m, src2->left);
                spice_marshaller_add_int32(m, src2->bottom);
                spice_marshaller_add_int32(m, src2->right);
                rects__element++;
            }
        }
    }
}

void spice_marshall_msg_display_stream_destroy(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayStreamDestroy *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgDisplayStreamDestroy *src;
    src = (const SpiceMsgDisplayStreamDestroy *)msg;

    spice_marshaller_add_uint32(m, src->id);
}

void spice_marshall_msg_display_draw_fill(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayDrawFill *msg, SpiceMarshaller **brush_pat_out, SpiceMarshaller **mask_bitmap_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    *brush_pat_out = NULL;
    *mask_bitmap_out = NULL;
}

void spice_marshall_msg_display_draw_opaque(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayDrawOpaque *msg, SpiceMarshaller **src_bitmap_out, SpiceMarshaller **pat_out, SpiceMarshaller **mask_bitmap_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    *src_bitmap_out = NULL;
    *pat_out = NULL;
    *mask_bitmap_out = NULL;
}

void spice_marshall_Palette(SpiceMarshaller *m, const SpicePalette *ptr)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpicePalette *src;
    const uint32_t *  ents__element;
    uint32_t i;

    src = (const SpicePalette *)ptr;

    spice_marshaller_add_uint64(m, src->unique);
    spice_marshaller_add_uint16(m, src->num_ents);
    ents__element = src->ents;
    for (i = 0; i < src->num_ents; i++) {
        spice_marshaller_add_uint32(m, *ents__element);
        ents__element++;
    }
}

void spice_marshall_Image(SpiceMarshaller *m, const SpiceImage *ptr, SpiceMarshaller **bitmap_palette_out, SpiceMarshaller **lzplt_palette_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceImage *src;
    *bitmap_palette_out = NULL;
    *lzplt_palette_out = NULL;

    src = (const SpiceImage *)ptr;

    /* descriptor */ {
        spice_marshaller_add_uint64(m, src->descriptor.id);
        spice_marshaller_add_uint8(m, src->descriptor.type);
        spice_marshaller_add_uint8(m, src->descriptor.flags);
        spice_marshaller_add_uint32(m, src->descriptor.width);
        spice_marshaller_add_uint32(m, src->descriptor.height);
    }
    if (src->descriptor.type == SPICE_IMAGE_TYPE_BITMAP) {
        spice_marshaller_add_uint8(m, src->u.bitmap.format);
        spice_marshaller_add_uint8(m, src->u.bitmap.flags);
        spice_marshaller_add_uint32(m, src->u.bitmap.x);
        spice_marshaller_add_uint32(m, src->u.bitmap.y);
        spice_marshaller_add_uint32(m, src->u.bitmap.stride);
        if ((src->u.bitmap.flags & SPICE_BITMAP_FLAGS_PAL_FROM_CACHE)) {
            spice_marshaller_add_uint64(m, src->u.bitmap.palette_id);
        } else if (1) {
            *bitmap_palette_out = spice_marshaller_get_ptr_submarshaller(m);
        }
        /* Don't marshall @nomarshal data */
    } else if (src->descriptor.type == SPICE_IMAGE_TYPE_QUIC) {
        spice_marshaller_add_uint32(m, src->u.quic.data_size);
        /* Don't marshall @nomarshal data */
    } else if (src->descriptor.type == SPICE_IMAGE_TYPE_LZ_RGB || src->descriptor.type == SPICE_IMAGE_TYPE_GLZ_RGB) {
        spice_marshaller_add_uint32(m, src->u.lz_rgb.data_size);
        /* Don't marshall @nomarshal data */
    } else if (src->descriptor.type == SPICE_IMAGE_TYPE_JPEG) {
        spice_marshaller_add_uint32(m, src->u.jpeg.data_size);
        /* Don't marshall @nomarshal data */
    } else if (src->descriptor.type == SPICE_IMAGE_TYPE_LZ4) {
        spice_marshaller_add_uint32(m, src->u.lz4.data_size);
        /* Don't marshall @nomarshal data */
    } else if (src->descriptor.type == SPICE_IMAGE_TYPE_LZ_PLT) {
        spice_marshaller_add_uint8(m, src->u.lz_plt.flags);
        spice_marshaller_add_uint32(m, src->u.lz_plt.data_size);
        if ((src->u.lz_plt.flags & SPICE_BITMAP_FLAGS_PAL_FROM_CACHE)) {
            spice_marshaller_add_uint64(m, src->u.lz_plt.palette_id);
        } else if (1) {
            *lzplt_palette_out = spice_marshaller_get_ptr_submarshaller(m);
        }
        /* Don't marshall @nomarshal data */
    } else if (src->descriptor.type == SPICE_IMAGE_TYPE_ZLIB_GLZ_RGB) {
        spice_marshaller_add_uint32(m, src->u.zlib_glz.glz_data_size);
        spice_marshaller_add_uint32(m, src->u.zlib_glz.data_size);
        /* Don't marshall @nomarshal data */
    } else if (src->descriptor.type == SPICE_IMAGE_TYPE_JPEG_ALPHA) {
        spice_marshaller_add_uint8(m, src->u.jpeg_alpha.flags);
        spice_marshaller_add_uint32(m, src->u.jpeg_alpha.jpeg_size);
        spice_marshaller_add_uint32(m, src->u.jpeg_alpha.data_size);
        /* Don't marshall @nomarshal data */
    } else if (src->descriptor.type == SPICE_IMAGE_TYPE_SURFACE) {
        spice_marshaller_add_uint32(m, src->u.surface.surface_id);
    }
}

void spice_marshall_msg_display_draw_copy(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayDrawCopy *msg, SpiceMarshaller **src_bitmap_out, SpiceMarshaller **mask_bitmap_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgDisplayDrawCopy *src;
    uint32_t i;
    *src_bitmap_out = NULL;
    *mask_bitmap_out = NULL;
    src = (const SpiceMsgDisplayDrawCopy *)msg;

    /* base */ {
        spice_marshaller_add_uint32(m, src->base.surface_id);
        /* box */ {
            spice_marshaller_add_int32(m, src->base.box.top);
            spice_marshaller_add_int32(m, src->base.box.left);
            spice_marshaller_add_int32(m, src->base.box.bottom);
            spice_marshaller_add_int32(m, src->base.box.right);
        }
        /* clip */ {
            spice_marshaller_add_uint8(m, src->base.clip.type);
            if (src->base.clip.type == SPICE_CLIP_TYPE_RECTS) {
                const SpiceRect *  rects__element;
                spice_marshaller_add_uint32(m, src->base.clip.rects->num_rects);
                rects__element = src->base.clip.rects->rects;
                for (i = 0; i < src->base.clip.rects->num_rects; i++) {
                    const SpiceRect *src2;
                    src2 = (const SpiceRect *)rects__element;

                    spice_marshaller_add_int32(m, src2->top);
                    spice_marshaller_add_int32(m, src2->left);
                    spice_marshaller_add_int32(m, src2->bottom);
                    spice_marshaller_add_int32(m, src2->right);
                    rects__element++;
                }
            }
        }
    }
    /* data */ {
        *src_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
        /* src_area */ {
            spice_marshaller_add_int32(m, src->data.src_area.top);
            spice_marshaller_add_int32(m, src->data.src_area.left);
            spice_marshaller_add_int32(m, src->data.src_area.bottom);
            spice_marshaller_add_int32(m, src->data.src_area.right);
        }
        spice_marshaller_add_uint16(m, src->data.rop_descriptor);
        spice_marshaller_add_uint8(m, src->data.scale_mode);
        /* mask */ {
            spice_marshaller_add_uint8(m, src->data.mask.flags);
            /* pos */ {
                spice_marshaller_add_int32(m, src->data.mask.pos.x);
                spice_marshaller_add_int32(m, src->data.mask.pos.y);
            }
            *mask_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
        }
    }
}

void spice_marshall_msg_display_draw_blend(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayDrawCopy *msg, SpiceMarshaller **src_bitmap_out, SpiceMarshaller **mask_bitmap_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgDisplayDrawCopy *src;
    uint32_t i;
    *src_bitmap_out = NULL;
    *mask_bitmap_out = NULL;
    src = (const SpiceMsgDisplayDrawCopy *)msg;

    /* base */ {
        spice_marshaller_add_uint32(m, src->base.surface_id);
        /* box */ {
            spice_marshaller_add_int32(m, src->base.box.top);
            spice_marshaller_add_int32(m, src->base.box.left);
            spice_marshaller_add_int32(m, src->base.box.bottom);
            spice_marshaller_add_int32(m, src->base.box.right);
        }
        /* clip */ {
            spice_marshaller_add_uint8(m, src->base.clip.type);
            if (src->base.clip.type == SPICE_CLIP_TYPE_RECTS) {
                const SpiceRect *  rects__element;
                spice_marshaller_add_uint32(m, src->base.clip.rects->num_rects);
                rects__element = src->base.clip.rects->rects;
                for (i = 0; i < src->base.clip.rects->num_rects; i++) {
                    const SpiceRect *src2;
                    src2 = (const SpiceRect *)rects__element;

                    spice_marshaller_add_int32(m, src2->top);
                    spice_marshaller_add_int32(m, src2->left);
                    spice_marshaller_add_int32(m, src2->bottom);
                    spice_marshaller_add_int32(m, src2->right);
                    rects__element++;
                }
            }
        }
    }
    /* data */ {
        *src_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
        /* src_area */ {
            spice_marshaller_add_int32(m, src->data.src_area.top);
            spice_marshaller_add_int32(m, src->data.src_area.left);
            spice_marshaller_add_int32(m, src->data.src_area.bottom);
            spice_marshaller_add_int32(m, src->data.src_area.right);
        }
        spice_marshaller_add_uint16(m, src->data.rop_descriptor);
        spice_marshaller_add_uint8(m, src->data.scale_mode);
        /* mask */ {
            spice_marshaller_add_uint8(m, src->data.mask.flags);
            /* pos */ {
                spice_marshaller_add_int32(m, src->data.mask.pos.x);
                spice_marshaller_add_int32(m, src->data.mask.pos.y);
            }
            *mask_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
        }
    }
}

void spice_marshall_msg_display_draw_blackness(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayDrawBlackness *msg, SpiceMarshaller **mask_bitmap_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgDisplayDrawBlackness *src;
    uint32_t i;
    *mask_bitmap_out = NULL;
    src = (const SpiceMsgDisplayDrawBlackness *)msg;

    /* base */ {
        spice_marshaller_add_uint32(m, src->base.surface_id);
        /* box */ {
            spice_marshaller_add_int32(m, src->base.box.top);
            spice_marshaller_add_int32(m, src->base.box.left);
            spice_marshaller_add_int32(m, src->base.box.bottom);
            spice_marshaller_add_int32(m, src->base.box.right);
        }
        /* clip */ {
            spice_marshaller_add_uint8(m, src->base.clip.type);
            if (src->base.clip.type == SPICE_CLIP_TYPE_RECTS) {
                const SpiceRect *  rects__element;
                spice_marshaller_add_uint32(m, src->base.clip.rects->num_rects);
                rects__element = src->base.clip.rects->rects;
                for (i = 0; i < src->base.clip.rects->num_rects; i++) {
                    const SpiceRect *src2;
                    src2 = (const SpiceRect *)rects__element;

                    spice_marshaller_add_int32(m, src2->top);
                    spice_marshaller_add_int32(m, src2->left);
                    spice_marshaller_add_int32(m, src2->bottom);
                    spice_marshaller_add_int32(m, src2->right);
                    rects__element++;
                }
            }
        }
    }
    /* data */ {
        /* mask */ {
            spice_marshaller_add_uint8(m, src->data.mask.flags);
            /* pos */ {
                spice_marshaller_add_int32(m, src->data.mask.pos.x);
                spice_marshaller_add_int32(m, src->data.mask.pos.y);
            }
            *mask_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
        }
    }
}

void spice_marshall_msg_display_draw_whiteness(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayDrawWhiteness *msg, SpiceMarshaller **mask_bitmap_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgDisplayDrawWhiteness *src;
    uint32_t i;
    *mask_bitmap_out = NULL;
    src = (const SpiceMsgDisplayDrawWhiteness *)msg;

    /* base */ {
        spice_marshaller_add_uint32(m, src->base.surface_id);
        /* box */ {
            spice_marshaller_add_int32(m, src->base.box.top);
            spice_marshaller_add_int32(m, src->base.box.left);
            spice_marshaller_add_int32(m, src->base.box.bottom);
            spice_marshaller_add_int32(m, src->base.box.right);
        }
        /* clip */ {
            spice_marshaller_add_uint8(m, src->base.clip.type);
            if (src->base.clip.type == SPICE_CLIP_TYPE_RECTS) {
                const SpiceRect *  rects__element;
                spice_marshaller_add_uint32(m, src->base.clip.rects->num_rects);
                rects__element = src->base.clip.rects->rects;
                for (i = 0; i < src->base.clip.rects->num_rects; i++) {
                    const SpiceRect *src2;
                    src2 = (const SpiceRect *)rects__element;

                    spice_marshaller_add_int32(m, src2->top);
                    spice_marshaller_add_int32(m, src2->left);
                    spice_marshaller_add_int32(m, src2->bottom);
                    spice_marshaller_add_int32(m, src2->right);
                    rects__element++;
                }
            }
        }
    }
    /* data */ {
        /* mask */ {
            spice_marshaller_add_uint8(m, src->data.mask.flags);
            /* pos */ {
                spice_marshaller_add_int32(m, src->data.mask.pos.x);
                spice_marshaller_add_int32(m, src->data.mask.pos.y);
            }
            *mask_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
        }
    }
}

void spice_marshall_msg_display_draw_invers(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayDrawInvers *msg, SpiceMarshaller **mask_bitmap_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgDisplayDrawInvers *src;
    uint32_t i;
    *mask_bitmap_out = NULL;
    src = (const SpiceMsgDisplayDrawInvers *)msg;

    /* base */ {
        spice_marshaller_add_uint32(m, src->base.surface_id);
        /* box */ {
            spice_marshaller_add_int32(m, src->base.box.top);
            spice_marshaller_add_int32(m, src->base.box.left);
            spice_marshaller_add_int32(m, src->base.box.bottom);
            spice_marshaller_add_int32(m, src->base.box.right);
        }
        /* clip */ {
            spice_marshaller_add_uint8(m, src->base.clip.type);
            if (src->base.clip.type == SPICE_CLIP_TYPE_RECTS) {
                const SpiceRect *  rects__element;
                spice_marshaller_add_uint32(m, src->base.clip.rects->num_rects);
                rects__element = src->base.clip.rects->rects;
                for (i = 0; i < src->base.clip.rects->num_rects; i++) {
                    const SpiceRect *src2;
                    src2 = (const SpiceRect *)rects__element;

                    spice_marshaller_add_int32(m, src2->top);
                    spice_marshaller_add_int32(m, src2->left);
                    spice_marshaller_add_int32(m, src2->bottom);
                    spice_marshaller_add_int32(m, src2->right);
                    rects__element++;
                }
            }
        }
    }
    /* data */ {
        /* mask */ {
            spice_marshaller_add_uint8(m, src->data.mask.flags);
            /* pos */ {
                spice_marshaller_add_int32(m, src->data.mask.pos.x);
                spice_marshaller_add_int32(m, src->data.mask.pos.y);
            }
            *mask_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
        }
    }
}

void spice_marshall_msg_display_draw_rop3(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayDrawRop3 *msg, SpiceMarshaller **src_bitmap_out, SpiceMarshaller **pat_out, SpiceMarshaller **mask_bitmap_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    *src_bitmap_out = NULL;
    *pat_out = NULL;
    *mask_bitmap_out = NULL;
}

void spice_marshall_msg_display_draw_stroke(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayDrawStroke *msg, SpiceMarshaller **style_out, SpiceMarshaller **pat_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    *style_out = NULL;
    *pat_out = NULL;
}

void spice_marshall_msg_display_draw_text(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayDrawText *msg, SpiceMarshaller **fore_brush_pat_out, SpiceMarshaller **back_brush_pat_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    *fore_brush_pat_out = NULL;
    *back_brush_pat_out = NULL;
}

void spice_marshall_msg_display_draw_transparent(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayDrawTransparent *msg, SpiceMarshaller **src_bitmap_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgDisplayDrawTransparent *src;
    uint32_t i;
    *src_bitmap_out = NULL;
    src = (const SpiceMsgDisplayDrawTransparent *)msg;

    /* base */ {
        spice_marshaller_add_uint32(m, src->base.surface_id);
        /* box */ {
            spice_marshaller_add_int32(m, src->base.box.top);
            spice_marshaller_add_int32(m, src->base.box.left);
            spice_marshaller_add_int32(m, src->base.box.bottom);
            spice_marshaller_add_int32(m, src->base.box.right);
        }
        /* clip */ {
            spice_marshaller_add_uint8(m, src->base.clip.type);
            if (src->base.clip.type == SPICE_CLIP_TYPE_RECTS) {
                const SpiceRect *  rects__element;
                spice_marshaller_add_uint32(m, src->base.clip.rects->num_rects);
                rects__element = src->base.clip.rects->rects;
                for (i = 0; i < src->base.clip.rects->num_rects; i++) {
                    const SpiceRect *src2;
                    src2 = (const SpiceRect *)rects__element;

                    spice_marshaller_add_int32(m, src2->top);
                    spice_marshaller_add_int32(m, src2->left);
                    spice_marshaller_add_int32(m, src2->bottom);
                    spice_marshaller_add_int32(m, src2->right);
                    rects__element++;
                }
            }
        }
    }
    /* data */ {
        *src_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
        /* src_area */ {
            spice_marshaller_add_int32(m, src->data.src_area.top);
            spice_marshaller_add_int32(m, src->data.src_area.left);
            spice_marshaller_add_int32(m, src->data.src_area.bottom);
            spice_marshaller_add_int32(m, src->data.src_area.right);
        }
        spice_marshaller_add_uint32(m, src->data.src_color);
        spice_marshaller_add_uint32(m, src->data.true_color);
    }
}

void spice_marshall_msg_display_draw_alpha_blend(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayDrawAlphaBlend *msg, SpiceMarshaller **src_bitmap_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgDisplayDrawAlphaBlend *src;
    uint32_t i;
    *src_bitmap_out = NULL;
    src = (const SpiceMsgDisplayDrawAlphaBlend *)msg;

    /* base */ {
        spice_marshaller_add_uint32(m, src->base.surface_id);
        /* box */ {
            spice_marshaller_add_int32(m, src->base.box.top);
            spice_marshaller_add_int32(m, src->base.box.left);
            spice_marshaller_add_int32(m, src->base.box.bottom);
            spice_marshaller_add_int32(m, src->base.box.right);
        }
        /* clip */ {
            spice_marshaller_add_uint8(m, src->base.clip.type);
            if (src->base.clip.type == SPICE_CLIP_TYPE_RECTS) {
                const SpiceRect *  rects__element;
                spice_marshaller_add_uint32(m, src->base.clip.rects->num_rects);
                rects__element = src->base.clip.rects->rects;
                for (i = 0; i < src->base.clip.rects->num_rects; i++) {
                    const SpiceRect *src2;
                    src2 = (const SpiceRect *)rects__element;

                    spice_marshaller_add_int32(m, src2->top);
                    spice_marshaller_add_int32(m, src2->left);
                    spice_marshaller_add_int32(m, src2->bottom);
                    spice_marshaller_add_int32(m, src2->right);
                    rects__element++;
                }
            }
        }
    }
    /* data */ {
        spice_marshaller_add_uint8(m, src->data.alpha_flags);
        spice_marshaller_add_uint8(m, src->data.alpha);
        *src_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
        /* src_area */ {
            spice_marshaller_add_int32(m, src->data.src_area.top);
            spice_marshaller_add_int32(m, src->data.src_area.left);
            spice_marshaller_add_int32(m, src->data.src_area.bottom);
            spice_marshaller_add_int32(m, src->data.src_area.right);
        }
    }
}

void spice_marshall_msg_display_surface_create(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgSurfaceCreate *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgSurfaceCreate *src;
    src = (const SpiceMsgSurfaceCreate *)msg;

    spice_marshaller_add_uint32(m, src->surface_id);
    spice_marshaller_add_uint32(m, src->width);
    spice_marshaller_add_uint32(m, src->height);
    spice_marshaller_add_uint32(m, src->format);
    spice_marshaller_add_uint32(m, src->flags);
}

void spice_marshall_msg_display_surface_destroy(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgSurfaceDestroy *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgSurfaceDestroy *src;
    src = (const SpiceMsgSurfaceDestroy *)msg;

    spice_marshaller_add_uint32(m, src->surface_id);
}

void spice_marshall_msg_display_stream_data_sized(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayStreamDataSized *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgDisplayStreamDataSized *src;
    src = (const SpiceMsgDisplayStreamDataSized *)msg;

    /* base */ {
        spice_marshaller_add_uint32(m, src->base.id);
        spice_marshaller_add_uint32(m, src->base.multi_media_time);
    }
    spice_marshaller_add_uint32(m, src->width);
    spice_marshaller_add_uint32(m, src->height);
    /* dest */ {
        spice_marshaller_add_int32(m, src->dest.top);
        spice_marshaller_add_int32(m, src->dest.left);
        spice_marshaller_add_int32(m, src->dest.bottom);
        spice_marshaller_add_int32(m, src->dest.right);
    }
    spice_marshaller_add_uint32(m, src->data_size);
    /* Don't marshall @nomarshal data */
}

void spice_marshall_msg_display_monitors_config(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayMonitorsConfig *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgDisplayMonitorsConfig *src;
    const SpiceHead *  heads__element;
    uint32_t i;
    src = (const SpiceMsgDisplayMonitorsConfig *)msg;

    spice_marshaller_add_uint16(m, src->count);
    spice_marshaller_add_uint16(m, src->max_allowed);
    heads__element = src->heads;
    for (i = 0; i < src->count; i++) {
        const SpiceHead *src2;
        src2 = (const SpiceHead *)heads__element;

        spice_marshaller_add_uint32(m, src2->monitor_id);
        spice_marshaller_add_uint32(m, src2->surface_id);
        spice_marshaller_add_uint32(m, src2->width);
        spice_marshaller_add_uint32(m, src2->height);
        spice_marshaller_add_uint32(m, src2->x);
        spice_marshaller_add_uint32(m, src2->y);
        spice_marshaller_add_uint32(m, src2->flags);
        heads__element++;
    }
}

void spice_marshall_msg_display_draw_composite(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayDrawComposite *msg, SpiceMarshaller **src_bitmap_out, SpiceMarshaller **mask_bitmap_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    *src_bitmap_out = NULL;
    *mask_bitmap_out = NULL;
}

void spice_marshall_msg_display_stream_activate_report(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayStreamActivateReport *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgDisplayStreamActivateReport *src;
    src = (const SpiceMsgDisplayStreamActivateReport *)msg;

    spice_marshaller_add_uint32(m, src->stream_id);
    spice_marshaller_add_uint32(m, src->unique_id);
    spice_marshaller_add_uint32(m, src->max_window_size);
    spice_marshaller_add_uint32(m, src->timeout_ms);
}

void spice_marshall_msg_display_gl_scanout_unix(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayGlScanoutUnix *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgDisplayGlScanoutUnix *src;
    src = (const SpiceMsgDisplayGlScanoutUnix *)msg;

    spice_marshaller_add_fd(m, src->drm_dma_buf_fd);
    spice_marshaller_add_uint32(m, src->width);
    spice_marshaller_add_uint32(m, src->height);
    spice_marshaller_add_uint32(m, src->stride);
    spice_marshaller_add_uint32(m, src->drm_fourcc_format);
    spice_marshaller_add_uint32(m, src->flags);
}

void spice_marshall_msg_display_gl_draw(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayGlDraw *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgDisplayGlDraw *src;
    src = (const SpiceMsgDisplayGlDraw *)msg;

    spice_marshaller_add_uint32(m, src->x);
    spice_marshaller_add_uint32(m, src->y);
    spice_marshaller_add_uint32(m, src->w);
    spice_marshaller_add_uint32(m, src->h);
}

void spice_marshall_msg_display_gl_scanout2_unix(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayGlScanout2Unix *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgDisplayGlScanout2Unix *src;
    const SpiceGlPlaneUnix *  planes__element;
    uint32_t i;
    src = (const SpiceMsgDisplayGlScanout2Unix *)msg;

    spice_marshaller_add_uint32(m, src->width);
    spice_marshaller_add_uint32(m, src->height);
    spice_marshaller_add_uint32(m, src->fourcc);
    spice_marshaller_add_uint32(m, src->flags);
    spice_marshaller_add_uint8(m, src->num_planes);
    spice_marshaller_add_uint64(m, src->modifier);
    planes__element = src->planes;
    for (i = 0; i < src->num_planes; i++) {
        const SpiceGlPlaneUnix *src2;
        src2 = (const SpiceGlPlaneUnix *)planes__element;

        spice_marshaller_add_fd(m, src2->fd);
        spice_marshaller_add_uint32(m, src2->offset);
        spice_marshaller_add_uint32(m, src2->stride);
        planes__element++;
    }
}

void spice_marshall_msg_inputs_init(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgInputsInit *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgInputsInit *src;
    src = (const SpiceMsgInputsInit *)msg;

    spice_marshaller_add_uint16(m, src->keyboard_modifiers);
}

void spice_marshall_msg_inputs_key_modifiers(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgInputsKeyModifiers *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgInputsKeyModifiers *src;
    src = (const SpiceMsgInputsKeyModifiers *)msg;

    spice_marshaller_add_uint16(m, src->modifiers);
}

void spice_marshall_msg_cursor_init(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgCursorInit *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgCursorInit *src;
    src = (const SpiceMsgCursorInit *)msg;

    /* position */ {
        spice_marshaller_add_int16(m, src->position.x);
        spice_marshaller_add_int16(m, src->position.y);
    }
    spice_marshaller_add_uint16(m, src->trail_length);
    spice_marshaller_add_uint16(m, src->trail_frequency);
    spice_marshaller_add_uint8(m, src->visible);
    /* cursor */ {
        spice_marshaller_add_uint16(m, src->cursor.flags);
        if (!(src->cursor.flags & SPICE_CURSOR_FLAGS_NONE)) {
            spice_marshaller_add_uint64(m, src->cursor.header.unique);
            spice_marshaller_add_uint8(m, src->cursor.header.type);
            spice_marshaller_add_uint16(m, src->cursor.header.width);
            spice_marshaller_add_uint16(m, src->cursor.header.height);
            spice_marshaller_add_uint16(m, src->cursor.header.hot_spot_x);
            spice_marshaller_add_uint16(m, src->cursor.header.hot_spot_y);
        }
        /* Remaining data must be appended manually */
    }
}

void spice_marshall_msg_cursor_set(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgCursorSet *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgCursorSet *src;
    src = (const SpiceMsgCursorSet *)msg;

    /* position */ {
        spice_marshaller_add_int16(m, src->position.x);
        spice_marshaller_add_int16(m, src->position.y);
    }
    spice_marshaller_add_uint8(m, src->visible);
    /* cursor */ {
        spice_marshaller_add_uint16(m, src->cursor.flags);
        if (!(src->cursor.flags & SPICE_CURSOR_FLAGS_NONE)) {
            spice_marshaller_add_uint64(m, src->cursor.header.unique);
            spice_marshaller_add_uint8(m, src->cursor.header.type);
            spice_marshaller_add_uint16(m, src->cursor.header.width);
            spice_marshaller_add_uint16(m, src->cursor.header.height);
            spice_marshaller_add_uint16(m, src->cursor.header.hot_spot_x);
            spice_marshaller_add_uint16(m, src->cursor.header.hot_spot_y);
        }
        /* Remaining data must be appended manually */
    }
}

void spice_marshall_msg_cursor_move(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgCursorMove *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgCursorMove *src;
    src = (const SpiceMsgCursorMove *)msg;

    /* position */ {
        spice_marshaller_add_int16(m, src->position.x);
        spice_marshaller_add_int16(m, src->position.y);
    }
}

void spice_marshall_msg_cursor_trail(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgCursorTrail *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgCursorTrail *src;
    src = (const SpiceMsgCursorTrail *)msg;

    spice_marshaller_add_uint16(m, src->length);
    spice_marshaller_add_uint16(m, src->frequency);
}

void spice_marshall_msg_cursor_inval_one(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgDisplayInvalOne *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgDisplayInvalOne *src;
    src = (const SpiceMsgDisplayInvalOne *)msg;

    spice_marshaller_add_uint64(m, src->id);
}

void spice_marshall_msg_playback_data(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgPlaybackPacket *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgPlaybackPacket *src;
    src = (const SpiceMsgPlaybackPacket *)msg;

    spice_marshaller_add_uint32(m, src->time);
    /* Remaining data must be appended manually */
}

void spice_marshall_msg_playback_mode(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgPlaybackMode *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgPlaybackMode *src;
    src = (const SpiceMsgPlaybackMode *)msg;

    spice_marshaller_add_uint32(m, src->time);
    spice_marshaller_add_uint16(m, src->mode);
    /* Remaining data must be appended manually */
}

void spice_marshall_msg_playback_start(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgPlaybackStart *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgPlaybackStart *src;
    src = (const SpiceMsgPlaybackStart *)msg;

    spice_marshaller_add_uint32(m, src->channels);
    spice_marshaller_add_uint16(m, src->format);
    spice_marshaller_add_uint32(m, src->frequency);
    spice_marshaller_add_uint32(m, src->time);
}

void spice_marshall_SpiceMsgAudioVolume(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgAudioVolume *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgAudioVolume *src;
    const uint16_t *  volume__element;
    uint32_t i;
    src = (const SpiceMsgAudioVolume *)msg;

    spice_marshaller_add_uint8(m, src->nchannels);
    volume__element = src->volume;
    for (i = 0; i < src->nchannels; i++) {
        spice_marshaller_add_uint16(m, *volume__element);
        volume__element++;
    }
}

void spice_marshall_SpiceMsgAudioMute(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgAudioMute *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgAudioMute *src;
    src = (const SpiceMsgAudioMute *)msg;

    spice_marshaller_add_uint8(m, src->mute);
}

void spice_marshall_msg_playback_latency(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgPlaybackLatency *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgPlaybackLatency *src;
    src = (const SpiceMsgPlaybackLatency *)msg;

    spice_marshaller_add_uint32(m, src->latency_ms);
}

void spice_marshall_msg_record_start(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgRecordStart *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgRecordStart *src;
    src = (const SpiceMsgRecordStart *)msg;

    spice_marshaller_add_uint32(m, src->channels);
    spice_marshaller_add_uint16(m, src->format);
    spice_marshaller_add_uint32(m, src->frequency);
}

#ifdef USE_SMARTCARD
void spice_marshall_msg_smartcard_data(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgSmartcard *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgSmartcard *src;
    src = (const SpiceMsgSmartcard *)msg;

    spice_marshaller_add_uint32(m, src->type);
    spice_marshaller_add_uint32(m, src->reader_id);
    spice_marshaller_add_uint32(m, src->length);
    /* Don't marshall @nomarshal data */
}

#endif /* USE_SMARTCARD */
void spice_marshall_SpiceMsgCompressedData(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgCompressedData *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgCompressedData *src;
    src = (const SpiceMsgCompressedData *)msg;

    spice_marshaller_add_uint8(m, src->type);
    if (src->type == SPICE_DATA_COMPRESSION_TYPE_NONE) {
    } else if (1) {
        spice_marshaller_add_uint32(m, src->uncompressed_size);
    }
    /* Remaining data must be appended manually */
}

void spice_marshall_msg_port_init(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgPortInit *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgPortInit *src;
    src = (const SpiceMsgPortInit *)msg;

    spice_marshaller_add_uint32(m, src->name_size);
    m2 = spice_marshaller_get_ptr_submarshaller(m);
    spice_marshall_array_uint8(m2, src->name, src->name_size);
    spice_marshaller_add_uint8(m, src->opened);
}

void spice_marshall_msg_port_event(SPICE_GNUC_UNUSED SpiceMarshaller *m, SPICE_GNUC_UNUSED const SpiceMsgPortEvent *msg)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgPortEvent *src;
    src = (const SpiceMsgPortEvent *)msg;

    spice_marshaller_add_uint8(m, src->event);
}

void spice_marshall_String(SpiceMarshaller *m, const SpiceString *ptr)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceString *src;
    SpiceRasterGlyph * const *glyphs__element;
    uint32_t i;
    uint32_t j;

    src = (const SpiceString *)ptr;

    spice_marshaller_add_uint16(m, src->length);
    spice_marshaller_add_uint8(m, src->flags);
    if ((src->flags & SPICE_STRING_FLAGS_RASTER_A1)) {
        glyphs__element = src->glyphs;
        for (i = 0; i < src->length; i++) {
            const SpiceRasterGlyph *src2;
            const uint8_t *  data__element;
            src2 = (const SpiceRasterGlyph *)*glyphs__element;

            /* render_pos */ {
                spice_marshaller_add_int32(m, src2->render_pos.x);
                spice_marshaller_add_int32(m, src2->render_pos.y);
            }
            /* glyph_origin */ {
                spice_marshaller_add_int32(m, src2->glyph_origin.x);
                spice_marshaller_add_int32(m, src2->glyph_origin.y);
            }
            spice_marshaller_add_uint16(m, src2->width);
            spice_marshaller_add_uint16(m, src2->height);
            data__element = src2->data;
            for (j = 0; j < ((((uint64_t) src2->width + 7U) / 8U ) * src2->height); j++) {
                spice_marshaller_add_uint8(m, *data__element);
                data__element++;
            }
            glyphs__element++;
        }
    } else if ((src->flags & SPICE_STRING_FLAGS_RASTER_A4)) {
        glyphs__element = src->glyphs;
        for (i = 0; i < src->length; i++) {
            const SpiceRasterGlyph *src2;
            const uint8_t *  data__element;
            src2 = (const SpiceRasterGlyph *)*glyphs__element;

            /* render_pos */ {
                spice_marshaller_add_int32(m, src2->render_pos.x);
                spice_marshaller_add_int32(m, src2->render_pos.y);
            }
            /* glyph_origin */ {
                spice_marshaller_add_int32(m, src2->glyph_origin.x);
                spice_marshaller_add_int32(m, src2->glyph_origin.y);
            }
            spice_marshaller_add_uint16(m, src2->width);
            spice_marshaller_add_uint16(m, src2->height);
            data__element = src2->data;
            for (j = 0; j < ((((uint64_t) 4 * src2->width + 7U) / 8U ) * src2->height); j++) {
                spice_marshaller_add_uint8(m, *data__element);
                data__element++;
            }
            glyphs__element++;
        }
    } else if ((src->flags & SPICE_STRING_FLAGS_RASTER_A8)) {
        glyphs__element = src->glyphs;
        for (i = 0; i < src->length; i++) {
            const SpiceRasterGlyph *src2;
            const uint8_t *  data__element;
            src2 = (const SpiceRasterGlyph *)*glyphs__element;

            /* render_pos */ {
                spice_marshaller_add_int32(m, src2->render_pos.x);
                spice_marshaller_add_int32(m, src2->render_pos.y);
            }
            /* glyph_origin */ {
                spice_marshaller_add_int32(m, src2->glyph_origin.x);
                spice_marshaller_add_int32(m, src2->glyph_origin.y);
            }
            spice_marshaller_add_uint16(m, src2->width);
            spice_marshaller_add_uint16(m, src2->height);
            data__element = src2->data;
            for (j = 0; j < ((uint64_t) src2->width * src2->height); j++) {
                spice_marshaller_add_uint8(m, *data__element);
                data__element++;
            }
            glyphs__element++;
        }
    }
}
void spice_marshall_Rect(SpiceMarshaller *m, const SpiceRect *ptr)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceRect *src;

    src = (const SpiceRect *)ptr;

    spice_marshaller_add_int32(m, src->top);
    spice_marshaller_add_int32(m, src->left);
    spice_marshaller_add_int32(m, src->bottom);
    spice_marshaller_add_int32(m, src->right);
}
void spice_marshall_Point(SpiceMarshaller *m, const SpicePoint *ptr)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpicePoint *src;

    src = (const SpicePoint *)ptr;

    spice_marshaller_add_int32(m, src->x);
    spice_marshaller_add_int32(m, src->y);
}
void spice_marshall_DisplayBase(SpiceMarshaller *m, const SpiceMsgDisplayBase *ptr)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceMsgDisplayBase *src;
    uint32_t i;

    src = (const SpiceMsgDisplayBase *)ptr;

    spice_marshaller_add_uint32(m, src->surface_id);
    /* box */ {
        spice_marshaller_add_int32(m, src->box.top);
        spice_marshaller_add_int32(m, src->box.left);
        spice_marshaller_add_int32(m, src->box.bottom);
        spice_marshaller_add_int32(m, src->box.right);
    }
    /* clip */ {
        spice_marshaller_add_uint8(m, src->clip.type);
        if (src->clip.type == SPICE_CLIP_TYPE_RECTS) {
            const SpiceRect *  rects__element;
            spice_marshaller_add_uint32(m, src->clip.rects->num_rects);
            rects__element = src->clip.rects->rects;
            for (i = 0; i < src->clip.rects->num_rects; i++) {
                const SpiceRect *src2;
                src2 = (const SpiceRect *)rects__element;

                spice_marshaller_add_int32(m, src2->top);
                spice_marshaller_add_int32(m, src2->left);
                spice_marshaller_add_int32(m, src2->bottom);
                spice_marshaller_add_int32(m, src2->right);
                rects__element++;
            }
        }
    }
}
void spice_marshall_Fill(SpiceMarshaller *m, const SpiceFill *ptr, SpiceMarshaller **brush_pat_out, SpiceMarshaller **mask_bitmap_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceFill *src;
    *brush_pat_out = NULL;
    *mask_bitmap_out = NULL;

    src = (const SpiceFill *)ptr;

    /* brush */ {
        spice_marshaller_add_uint8(m, src->brush.type);
        if (src->brush.type == SPICE_BRUSH_TYPE_SOLID) {
            spice_marshaller_add_uint32(m, src->brush.u.color);
        } else if (src->brush.type == SPICE_BRUSH_TYPE_PATTERN) {
            *brush_pat_out = spice_marshaller_get_ptr_submarshaller(m);
            /* pos */ {
                spice_marshaller_add_int32(m, src->brush.u.pattern.pos.x);
                spice_marshaller_add_int32(m, src->brush.u.pattern.pos.y);
            }
        }
    }
    spice_marshaller_add_uint16(m, src->rop_descriptor);
    /* mask */ {
        spice_marshaller_add_uint8(m, src->mask.flags);
        /* pos */ {
            spice_marshaller_add_int32(m, src->mask.pos.x);
            spice_marshaller_add_int32(m, src->mask.pos.y);
        }
        *mask_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
    }
}
void spice_marshall_Opaque(SpiceMarshaller *m, const SpiceOpaque *ptr, SpiceMarshaller **src_bitmap_out, SpiceMarshaller **pat_out, SpiceMarshaller **mask_bitmap_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceOpaque *src;
    *src_bitmap_out = NULL;
    *pat_out = NULL;
    *mask_bitmap_out = NULL;

    src = (const SpiceOpaque *)ptr;

    *src_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
    /* src_area */ {
        spice_marshaller_add_int32(m, src->src_area.top);
        spice_marshaller_add_int32(m, src->src_area.left);
        spice_marshaller_add_int32(m, src->src_area.bottom);
        spice_marshaller_add_int32(m, src->src_area.right);
    }
    /* brush */ {
        spice_marshaller_add_uint8(m, src->brush.type);
        if (src->brush.type == SPICE_BRUSH_TYPE_SOLID) {
            spice_marshaller_add_uint32(m, src->brush.u.color);
        } else if (src->brush.type == SPICE_BRUSH_TYPE_PATTERN) {
            *pat_out = spice_marshaller_get_ptr_submarshaller(m);
            /* pos */ {
                spice_marshaller_add_int32(m, src->brush.u.pattern.pos.x);
                spice_marshaller_add_int32(m, src->brush.u.pattern.pos.y);
            }
        }
    }
    spice_marshaller_add_uint16(m, src->rop_descriptor);
    spice_marshaller_add_uint8(m, src->scale_mode);
    /* mask */ {
        spice_marshaller_add_uint8(m, src->mask.flags);
        /* pos */ {
            spice_marshaller_add_int32(m, src->mask.pos.x);
            spice_marshaller_add_int32(m, src->mask.pos.y);
        }
        *mask_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
    }
}
void spice_marshall_Copy(SpiceMarshaller *m, const SpiceCopy *ptr, SpiceMarshaller **src_bitmap_out, SpiceMarshaller **mask_bitmap_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceCopy *src;
    *src_bitmap_out = NULL;
    *mask_bitmap_out = NULL;

    src = (const SpiceCopy *)ptr;

    *src_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
    /* src_area */ {
        spice_marshaller_add_int32(m, src->src_area.top);
        spice_marshaller_add_int32(m, src->src_area.left);
        spice_marshaller_add_int32(m, src->src_area.bottom);
        spice_marshaller_add_int32(m, src->src_area.right);
    }
    spice_marshaller_add_uint16(m, src->rop_descriptor);
    spice_marshaller_add_uint8(m, src->scale_mode);
    /* mask */ {
        spice_marshaller_add_uint8(m, src->mask.flags);
        /* pos */ {
            spice_marshaller_add_int32(m, src->mask.pos.x);
            spice_marshaller_add_int32(m, src->mask.pos.y);
        }
        *mask_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
    }
}
void spice_marshall_Blend(SpiceMarshaller *m, const SpiceCopy *ptr, SpiceMarshaller **src_bitmap_out, SpiceMarshaller **mask_bitmap_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceCopy *src;
    *src_bitmap_out = NULL;
    *mask_bitmap_out = NULL;

    src = (const SpiceCopy *)ptr;

    *src_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
    /* src_area */ {
        spice_marshaller_add_int32(m, src->src_area.top);
        spice_marshaller_add_int32(m, src->src_area.left);
        spice_marshaller_add_int32(m, src->src_area.bottom);
        spice_marshaller_add_int32(m, src->src_area.right);
    }
    spice_marshaller_add_uint16(m, src->rop_descriptor);
    spice_marshaller_add_uint8(m, src->scale_mode);
    /* mask */ {
        spice_marshaller_add_uint8(m, src->mask.flags);
        /* pos */ {
            spice_marshaller_add_int32(m, src->mask.pos.x);
            spice_marshaller_add_int32(m, src->mask.pos.y);
        }
        *mask_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
    }
}
void spice_marshall_Blackness(SpiceMarshaller *m, const SpiceBlackness *ptr, SpiceMarshaller **mask_bitmap_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceBlackness *src;
    *mask_bitmap_out = NULL;

    src = (const SpiceBlackness *)ptr;

    /* mask */ {
        spice_marshaller_add_uint8(m, src->mask.flags);
        /* pos */ {
            spice_marshaller_add_int32(m, src->mask.pos.x);
            spice_marshaller_add_int32(m, src->mask.pos.y);
        }
        *mask_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
    }
}
void spice_marshall_Whiteness(SpiceMarshaller *m, const SpiceWhiteness *ptr, SpiceMarshaller **mask_bitmap_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceWhiteness *src;
    *mask_bitmap_out = NULL;

    src = (const SpiceWhiteness *)ptr;

    /* mask */ {
        spice_marshaller_add_uint8(m, src->mask.flags);
        /* pos */ {
            spice_marshaller_add_int32(m, src->mask.pos.x);
            spice_marshaller_add_int32(m, src->mask.pos.y);
        }
        *mask_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
    }
}
void spice_marshall_Invers(SpiceMarshaller *m, const SpiceInvers *ptr, SpiceMarshaller **mask_bitmap_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceInvers *src;
    *mask_bitmap_out = NULL;

    src = (const SpiceInvers *)ptr;

    /* mask */ {
        spice_marshaller_add_uint8(m, src->mask.flags);
        /* pos */ {
            spice_marshaller_add_int32(m, src->mask.pos.x);
            spice_marshaller_add_int32(m, src->mask.pos.y);
        }
        *mask_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
    }
}
void spice_marshall_Rop3(SpiceMarshaller *m, const SpiceRop3 *ptr, SpiceMarshaller **src_bitmap_out, SpiceMarshaller **pat_out, SpiceMarshaller **mask_bitmap_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceRop3 *src;
    *src_bitmap_out = NULL;
    *pat_out = NULL;
    *mask_bitmap_out = NULL;

    src = (const SpiceRop3 *)ptr;

    *src_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
    /* src_area */ {
        spice_marshaller_add_int32(m, src->src_area.top);
        spice_marshaller_add_int32(m, src->src_area.left);
        spice_marshaller_add_int32(m, src->src_area.bottom);
        spice_marshaller_add_int32(m, src->src_area.right);
    }
    /* brush */ {
        spice_marshaller_add_uint8(m, src->brush.type);
        if (src->brush.type == SPICE_BRUSH_TYPE_SOLID) {
            spice_marshaller_add_uint32(m, src->brush.u.color);
        } else if (src->brush.type == SPICE_BRUSH_TYPE_PATTERN) {
            *pat_out = spice_marshaller_get_ptr_submarshaller(m);
            /* pos */ {
                spice_marshaller_add_int32(m, src->brush.u.pattern.pos.x);
                spice_marshaller_add_int32(m, src->brush.u.pattern.pos.y);
            }
        }
    }
    spice_marshaller_add_uint8(m, src->rop3);
    spice_marshaller_add_uint8(m, src->scale_mode);
    /* mask */ {
        spice_marshaller_add_uint8(m, src->mask.flags);
        /* pos */ {
            spice_marshaller_add_int32(m, src->mask.pos.x);
            spice_marshaller_add_int32(m, src->mask.pos.y);
        }
        *mask_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
    }
}
void spice_marshall_Path(SpiceMarshaller *m, const SpicePath *ptr)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpicePath *src;
    SpicePathSeg * const *segments__element;
    uint32_t i;
    uint32_t j;

    src = (const SpicePath *)ptr;

    spice_marshaller_add_uint32(m, src->num_segments);
    segments__element = src->segments;
    for (i = 0; i < src->num_segments; i++) {
        const SpicePathSeg *src2;
        const SpicePointFix *  points__element;
        src2 = (const SpicePathSeg *)*segments__element;

        spice_marshaller_add_uint8(m, src2->flags);
        spice_marshaller_add_uint32(m, src2->count);
        points__element = src2->points;
        for (j = 0; j < src2->count; j++) {
            const SpicePointFix *src3;
            src3 = (const SpicePointFix *)points__element;

            spice_marshaller_add_int32(m, src3->x);
            spice_marshaller_add_int32(m, src3->y);
            points__element++;
        }
        segments__element++;
    }
}

SPICE_GNUC_UNUSED static void spice_marshall_array_int32(SpiceMarshaller *m, const int32_t *ptr, unsigned count)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    uint32_t i;

    for (i = 0; i < count; i++) {
        spice_marshaller_add_int32(m, *ptr++);
    }
}

void spice_marshall_Stroke(SpiceMarshaller *m, const SpiceStroke *ptr, SpiceMarshaller **style_out, SpiceMarshaller **pat_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceStroke *src;
    *style_out = NULL;
    *pat_out = NULL;

    src = (const SpiceStroke *)ptr;

    m2 = spice_marshaller_get_ptr_submarshaller(m);
    spice_marshall_Path(m2, src->path);
    /* attr */ {
        spice_marshaller_add_uint8(m, src->attr.flags);
        if ((src->attr.flags & SPICE_LINE_FLAGS_STYLED)) {
            spice_marshaller_add_uint8(m, src->attr.style_nseg);
        }
        if ((src->attr.flags & SPICE_LINE_FLAGS_STYLED)) {
            *style_out = spice_marshaller_get_ptr_submarshaller(m);
        }
    }
    /* brush */ {
        spice_marshaller_add_uint8(m, src->brush.type);
        if (src->brush.type == SPICE_BRUSH_TYPE_SOLID) {
            spice_marshaller_add_uint32(m, src->brush.u.color);
        } else if (src->brush.type == SPICE_BRUSH_TYPE_PATTERN) {
            *pat_out = spice_marshaller_get_ptr_submarshaller(m);
            /* pos */ {
                spice_marshaller_add_int32(m, src->brush.u.pattern.pos.x);
                spice_marshaller_add_int32(m, src->brush.u.pattern.pos.y);
            }
        }
    }
    spice_marshaller_add_uint16(m, src->fore_mode);
    spice_marshaller_add_uint16(m, src->back_mode);
}
void spice_marshall_Text(SpiceMarshaller *m, const SpiceText *ptr, SpiceMarshaller **fore_brush_pat_out, SpiceMarshaller **back_brush_pat_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceText *src;
    *fore_brush_pat_out = NULL;
    *back_brush_pat_out = NULL;

    src = (const SpiceText *)ptr;

    m2 = spice_marshaller_get_ptr_submarshaller(m);
    spice_marshall_String(m2, src->str);
    /* back_area */ {
        spice_marshaller_add_int32(m, src->back_area.top);
        spice_marshaller_add_int32(m, src->back_area.left);
        spice_marshaller_add_int32(m, src->back_area.bottom);
        spice_marshaller_add_int32(m, src->back_area.right);
    }
    /* fore_brush */ {
        spice_marshaller_add_uint8(m, src->fore_brush.type);
        if (src->fore_brush.type == SPICE_BRUSH_TYPE_SOLID) {
            spice_marshaller_add_uint32(m, src->fore_brush.u.color);
        } else if (src->fore_brush.type == SPICE_BRUSH_TYPE_PATTERN) {
            *fore_brush_pat_out = spice_marshaller_get_ptr_submarshaller(m);
            /* pos */ {
                spice_marshaller_add_int32(m, src->fore_brush.u.pattern.pos.x);
                spice_marshaller_add_int32(m, src->fore_brush.u.pattern.pos.y);
            }
        }
    }
    /* back_brush */ {
        spice_marshaller_add_uint8(m, src->back_brush.type);
        if (src->back_brush.type == SPICE_BRUSH_TYPE_SOLID) {
            spice_marshaller_add_uint32(m, src->back_brush.u.color);
        } else if (src->back_brush.type == SPICE_BRUSH_TYPE_PATTERN) {
            *back_brush_pat_out = spice_marshaller_get_ptr_submarshaller(m);
            /* pos */ {
                spice_marshaller_add_int32(m, src->back_brush.u.pattern.pos.x);
                spice_marshaller_add_int32(m, src->back_brush.u.pattern.pos.y);
            }
        }
    }
    spice_marshaller_add_uint16(m, src->fore_mode);
    spice_marshaller_add_uint16(m, src->back_mode);
}
void spice_marshall_Transparent(SpiceMarshaller *m, const SpiceTransparent *ptr, SpiceMarshaller **src_bitmap_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceTransparent *src;
    *src_bitmap_out = NULL;

    src = (const SpiceTransparent *)ptr;

    *src_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
    /* src_area */ {
        spice_marshaller_add_int32(m, src->src_area.top);
        spice_marshaller_add_int32(m, src->src_area.left);
        spice_marshaller_add_int32(m, src->src_area.bottom);
        spice_marshaller_add_int32(m, src->src_area.right);
    }
    spice_marshaller_add_uint32(m, src->src_color);
    spice_marshaller_add_uint32(m, src->true_color);
}
void spice_marshall_AlphaBlend(SpiceMarshaller *m, const SpiceAlphaBlend *ptr, SpiceMarshaller **src_bitmap_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceAlphaBlend *src;
    *src_bitmap_out = NULL;

    src = (const SpiceAlphaBlend *)ptr;

    spice_marshaller_add_uint8(m, src->alpha_flags);
    spice_marshaller_add_uint8(m, src->alpha);
    *src_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
    /* src_area */ {
        spice_marshaller_add_int32(m, src->src_area.top);
        spice_marshaller_add_int32(m, src->src_area.left);
        spice_marshaller_add_int32(m, src->src_area.bottom);
        spice_marshaller_add_int32(m, src->src_area.right);
    }
}
void spice_marshall_Composite(SpiceMarshaller *m, const SpiceComposite *ptr, SpiceMarshaller **src_bitmap_out, SpiceMarshaller **mask_bitmap_out)
{
    SPICE_GNUC_UNUSED SpiceMarshaller *m2;
    const SpiceComposite *src;
    *src_bitmap_out = NULL;
    *mask_bitmap_out = NULL;

    src = (const SpiceComposite *)ptr;

    spice_marshaller_add_uint32(m, src->flags);
    *src_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
    if ((src->flags & SPICE_COMPOSITE_HAS_MASK)) {
        *mask_bitmap_out = spice_marshaller_get_ptr_submarshaller(m);
    }
    if ((src->flags & SPICE_COMPOSITE_HAS_SRC_TRANSFORM)) {
        spice_marshaller_add_uint32(m, src->src_transform.t00);
        spice_marshaller_add_uint32(m, src->src_transform.t01);
        spice_marshaller_add_uint32(m, src->src_transform.t02);
        spice_marshaller_add_uint32(m, src->src_transform.t10);
        spice_marshaller_add_uint32(m, src->src_transform.t11);
        spice_marshaller_add_uint32(m, src->src_transform.t12);
    }
    if ((src->flags & SPICE_COMPOSITE_HAS_MASK_TRANSFORM)) {
        spice_marshaller_add_uint32(m, src->mask_transform.t00);
        spice_marshaller_add_uint32(m, src->mask_transform.t01);
        spice_marshaller_add_uint32(m, src->mask_transform.t02);
        spice_marshaller_add_uint32(m, src->mask_transform.t10);
        spice_marshaller_add_uint32(m, src->mask_transform.t11);
        spice_marshaller_add_uint32(m, src->mask_transform.t12);
    }
    /* src_origin */ {
        spice_marshaller_add_int16(m, src->src_origin.x);
        spice_marshaller_add_int16(m, src->src_origin.y);
    }
    /* mask_origin */ {
        spice_marshaller_add_int16(m, src->mask_origin.x);
        spice_marshaller_add_int16(m, src->mask_origin.y);
    }
}
