// Copyright 2020 The Gitea Authors. All rights reserved.
// SPDX-License-Identifier: MIT

package repos

import (
	"fmt"

	"code.gitea.io/sdk/gitea"
	"github.com/urfave/cli/v3"
)

var typeFilterFlag = cli.StringFlag{
	Name:     "type",
	Aliases:  []string{"T"},
	Required: false,
	Usage:    "Filter by type: fork, mirror, source",
}

func getTypeFilter(cmd *cli.Command) (filter gitea.RepoType, err error) {
	t := cmd.String("type")
	filter = gitea.RepoTypeNone
	switch t {
	case "":
		filter = gitea.RepoTypeNone
	case "fork":
		filter = gitea.RepoTypeFork
	case "mirror":
		filter = gitea.RepoTypeMirror
	case "source":
		filter = gitea.RepoTypeSource
	default:
		err = fmt.Errorf("invalid repo type '%s'. valid: fork, mirror, source", t)
	}
	return
}
