% Release notes of the 3.0.5 version of `TFEL`, `MFront` and `MTest`
% Thomas Helfer
% 2019

This is mainly a bug fix version of the `3.0` series. All tickets
solved are described below.

# Tickets fixed

## Ticket #193: Error in the computation of the consistent tangent operator in the `OrthotropicElastic5.mfront` and `OrthotropicElastic6.mfront` example

For more details, see: <https://sourceforge.net/p/tfel/tickets/193/>

## Ticket #188: Default constructor of the `qt` class is ill formed: noexcept specifier is not correcty defined

For more details, see: <https://sourceforge.net/p/tfel/tickets/188/>

## Ticket #185: Problem on transposition of fourth order tensor

The `ST2toST2TransposeExpr<A>` class expected that class `A` defines the
`IndexType` `typedef`, but this is not a requirement of the
`ST2toST2Concept` concept. Thus the `transpose` operation did not work
for all classes matching this concept. In particular, the following code
used to fail:

~~~~
const auto tM2 = transpose(Stensor4::Id() * Stensor4::Id());
~~~~

For more details, see: <https://sourceforge.net/p/tfel/tickets/184/>

## Ticket #181: Runge-Kutta DSL does not handle `NaN` values

For most algorithms with correction-prediction, the Runge-Kutta DSL has
two strategies to evaluate the error. The first one (the default) is the
euclidian norm and the second one the based on the absolute norm. The
DSL switches from one strategy to the other depending on the size of
unknowns.

The trouble only concerns the second strategy.

For more details, see: <https://sourceforge.net/p/tfel/tickets/181/>

## Ticket #180: "return false" doesn't work with some Runge-Kutta integrators

The issue concerns all the rk algorithms without local time-step
control (`euler`, `rk2`, `rk4`) which are not used in practice.

For more details, see: <https://sourceforge.net/p/tfel/tickets/180/>

## Ticket #178: Name of the python module is wrong under `Mac OS`

For more details, see: <https://sourceforge.net/p/tfel/tickets/178/>

## Ticket #175: Add `rpath`to the `TFEL` libraries when generating the library on `Mac Os`

For more details, see: <https://sourceforge.net/p/tfel/tickets/175/>

## Ticket #170: Default parameters' values precision

The default parameters' values were truncated to 6 significant digits
(default number of digits of the `std::ostream` class).

For more details, see: <https://sourceforge.net/p/tfel/tickets/170/>

# Ticket #133: Equation giving dn_ddai page 20  in the tutorial is wrong

For more details, see: <https://sourceforge.net/p/tfel/tickets/133/>
