<!-- This file is generated by scripts/link-docs.mjs. Do not edit manually. -->
# Tinymist Emacs Support for Typst

Run and configure tinymist in Emacs for Typst.

## Features

See [Tinymist Features](https://github.com/Myriad-Dreamin/tinymist#features) for a list of features.

## Finding Executable

To enable LSP, you must install `tinymist`. You can find `tinymist` by:

- Night versions available at [GitHub Actions](https://github.com/Myriad-Dreamin/tinymist/actions).

- Stable versions available at [GitHub Releases](https://github.com/Myriad-Dreamin/tinymist/releases).
  \
  If you are using the latest version of [typst-ts-mode](https://codeberg.org/meow_king/typst-ts-mode), then you can use command `typst-ts-lsp-download-binary` to download the latest stable binary of `tinymist` at `typst-ts-lsp-download-path`.

- Build from source by cargo. You can also compile and install **latest** `tinymist` by [Cargo](https://www.rust-lang.org/tools/install).
  ```bash
  cargo install --git https://github.com/Myriad-Dreamin/tinymist --locked tinymist-cli
  ```

## Setup Server

```el
(with-eval-after-load 'eglot
  (with-eval-after-load 'typst-ts-mode
    (add-to-list 'eglot-server-programs
                 `((typst-ts-mode) .
                   ,(eglot-alternatives `(,typst-ts-lsp-download-path
                                          "tinymist"
                                          "typst-lsp"))))))
```

Above code adds `tinymist` downloaded by `typst-ts-lsp-download-binary`, `tinymist` in your PATH and `typst-lsp` in your `PATH` to the `typst-ts-mode` entry of `eglot-server-programs`.

## Extra Settings

### Configuring Language Server

You can either use `eglot-workspace-configuration` or specifying launch arguments for `tinymist`.

#### eglot-workspace-configuration

For example, if you want to export PDF on save:

```el
  (setq-default eglot-workspace-configuration
                '(:tinymist (:exportPdf "onSave")))
```

You can also have configuration per directory. Be sure to look at the documentation of `eglot-workspace-configuration` by [`describe-symbol`](https://www.gnu.org/software/emacs/manual/html_node/emacs/Name-Help.html)..

See [Tinymist Server Configuration](/editors/neovim/Configuration.md) for references.

#### Launch Arguments

For example:

```el
(with-eval-after-load 'eglot
  (with-eval-after-load 'typst-ts-mode
    (add-to-list 'eglot-server-programs
                 `((typst-ts-mode) .
                   ,(eglot-alternatives `((,typst-ts-lsp-download-path "--font-path" "<your-font-path>")
                                          ("tinymist" "--font-path" "<your-font-path>")
                                          "typst-lsp"))))))
```

You can run command `tinymist help lsp` to view all available launch arguments for configuration.
