/* i386-linux.elf-so_entry.h
   created from i386-linux.elf-so_entry.bin, 5575 (0x15c7) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2025 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2025 Laszlo Molnar
   Copyright (C) 2000-2025 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_I386_LINUX_ELF_SO_ENTRY_SIZE    5575
#define STUB_I386_LINUX_ELF_SO_ENTRY_ADLER32 0xcd9b0983
#define STUB_I386_LINUX_ELF_SO_ENTRY_CRC32   0x2f7643c5

unsigned char stub_i386_linux_elf_so_entry[5575] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */ 192,  8,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */  16,  0, 13,  0,233,252,255,255,255,233,252,255,255,255,  0,  0,
/* 0x0040 */  85,137,229, 87, 86, 83,129,236, 68, 16,  0,  0,186,  0,  0,  0,
/* 0x0050 */   0,232,  4,  0,  0,  0,117,112,120,  0, 95,185, 16,  0,  0,  0,
/* 0x0060 */ 184,100,  1,  0,  0,137,251,205,128,137,198,131,248,234,117, 13,
/* 0x0070 */ 184,100,  1,  0,  0,137,251,137,209,205,128,137,198,133,246,121,
/* 0x0080 */  66,232,  9,  0,  0,  0, 47,100,101,118, 47,115,104,109,  0, 94,
/* 0x0090 */ 185,  2,  0, 65,  0,186,192,  1,  0,  0,137,243,106,  5, 88,205,
/* 0x00a0 */ 128,137,198,133,192,121, 28,232, 13,  0,  0,  0,109,101,109,102,
/* 0x00b0 */ 100, 95, 99,114,101, 97,116,101,  0, 88, 80,232,252,255,255,255,
/* 0x00c0 */ 131,196,  4,141,189,244,239,255,255,137,251,106,122, 88,205,128,
/* 0x00d0 */ 199,133,220,239,255,255,  0,  0,  0,  0,232,  4,  0,  0,  0, 97,
/* 0x00e0 */ 110,100,  0, 88,106,  3, 87, 80,232,216,  3,  0,  0,131,196, 12,
/* 0x00f0 */ 133,192,116, 45,232,  4,  0,  0,  0, 76,105,110,  0, 88,106,  3,
/* 0x0100 */  87, 80,232,190,  3,  0,  0,131,196, 12,133,192,117, 19,128,189,
/* 0x0110 */ 118,240,255,255, 52,126, 10,199,133,220,239,255,255,  1,  0,  0,
/* 0x0120 */   0,131,189,220,239,255,255,  0,117,126,131,125, 16,  0,117, 28,
/* 0x0130 */ 232,252,255,255,255,137, 69, 16,133,192,117, 16,141,133,244,239,
/* 0x0140 */ 255,255,137, 69, 16,198,133,244,239,255,255,  0,131,189,220,239,
/* 0x0150 */ 255,255,  0,117, 83,131,254,218,117, 78,131,125, 16,  0,116, 72,
/* 0x0160 */ 139, 85, 16,128, 58,  0,117, 26,141,133,244,247,255,255, 80, 82,
/* 0x0170 */ 232,150,  1,  0,  0,131,196,  8,137,193,133,192, 15,136,233,  0,
/* 0x0180 */   0,  0,185,194,  0,  0,  0,186,192,  1,  0,  0,139, 93, 16,106,
/* 0x0190 */   5, 88,205,128,137,198,137,193,133,192, 15,136,203,  0,  0,  0,
/* 0x01a0 */ 139, 93, 16,106, 10, 88,205,128,131,125,  8,  0,116, 16,232,252,
/* 0x01b0 */ 255,255,255,247,208, 35, 69,  8, 41, 69,  8,  1, 69, 12,131,125,
/* 0x01c0 */  12,  0,116, 85,131,189,220,239,255,255,  0,116, 22,137,243,139,
/* 0x01d0 */  77, 12,106, 93, 88,205,128,137,193,133,192, 15,136,138,  0,  0,
/* 0x01e0 */   0,235, 54,139, 77, 12, 73,191,  0,  0,  0,  0,137,243,137,250,
/* 0x01f0 */ 106, 19, 88,205,128,198,133,243,239,255,255,  0,141,141,243,239,
/* 0x0200 */ 255,255,186,  1,  0,  0,  0,137,243,106,  4, 88,205,128,137,243,
/* 0x0210 */ 137,249,137,250,106, 19, 88,205,128,131,125,  8,  0,116, 26,232,
/* 0x0220 */ 252,255,255,255,137,194,247,208,133, 69,  8,116, 12,247,218,137,
/* 0x0230 */ 243,139, 77,  8,106,  4, 88,205,128,106,  0, 86,131,125,  8,  1,
/* 0x0240 */  25,192,131,224,240,131,192, 17, 80,106,  3,255,117, 12,255,117,
/* 0x0250 */   8,232,252,255,255,255,137,194,131,196, 24,137,193, 61,  0,240,
/* 0x0260 */ 255,255,119,  7,141, 70,  1,137,193,  9,209,137,200,141,101,244,
/* 0x0270 */  91, 94, 95,201,195, 85,137,229, 86, 83,131,236, 72,106, 64,104,
/* 0x0280 */ 255,  0,  0,  0,141,117,184, 86,232,252,255,255,255,131,196, 12,
/* 0x0290 */ 139, 93,  8,137,241,106,106, 88,205,128,137,198,133,192,120, 21,
/* 0x02a0 */  15,183, 69,192, 37,  0,240,  0,  0,186,  0,  0,  0,  0, 61,  0,
/* 0x02b0 */  64,  0,  0,116, 44,131,254,254,117, 15,185,192,  1,  0,  0,139,
/* 0x02c0 */  93,  8,106, 39, 88,205,128,137,198,133,246,121, 18,131,125, 12,
/* 0x02d0 */   0,116, 12, 86,255,117,  8,232,252,255,255,255,131,196,  8,137,
/* 0x02e0 */ 242,137,208,141,101,248, 91, 94,201,195,139, 68, 36,  4,137,194,
/* 0x02f0 */ 131,226, 31,131,224, 63,131,250, 26,118, 12,168, 32,116,  5,131,
/* 0x0300 */ 232, 70,235,  3,131,232, 43,131,192, 64,195, 85,137,229, 87, 86,
/* 0x0310 */  83,131,236, 32,232, 12,  0,  0,  0, 47,100, 97,116, 97, 47,100,
/* 0x0320 */  97,116, 97, 47,  0, 90,139,  2,139, 77,  8,137,  1,139, 66,  4,
/* 0x0330 */ 137, 65,  4,102,139, 66,  8,102,137, 65,  8,138, 66, 10,136, 65,
/* 0x0340 */  10,198, 65, 11,  0,106,  1, 81,232, 40,255,255,255,131,196,  8,
/* 0x0350 */ 232, 19,  0,  0,  0, 47,112,114,111, 99, 47,115,101,108,102, 47,
/* 0x0360 */  99,109,100,108,105,110,101,  0, 91,137, 93,220,185,  0,  0,  0,
/* 0x0370 */   0,137,202,106,  5, 88,205,128,137, 69,240,139,117, 12,186,255,
/* 0x0380 */  15,  0,  0,137,195,137,241,106,  3, 88,205,128,137,199,139, 93,
/* 0x0390 */ 240,106,  6, 88,205,128,133,255,121, 11,255,117,220,232,252,255,
/* 0x03a0 */ 255,255,131,196,  4,198,  4, 62,  0,128, 62,  0,116,  6, 70,128,
/* 0x03b0 */  62,  0,117,250,137,247,128, 62, 47,116,  6, 78,128, 62, 47,117,
/* 0x03c0 */ 250,137,117,224,137,248, 41,240, 80, 86,139, 69,  8,131,192, 10,
/* 0x03d0 */  80,232,252,255,255,255,137,195,198,  0,  0,106,  0,255,117,  8,
/* 0x03e0 */ 232,144,254,255,255,131,196, 20,131,248,243,117, 87,232, 17,  0,
/* 0x03f0 */   0,  0, 99,111,109, 46,116,101,114,109,117,120, 47,102,105,108,
/* 0x0400 */ 101,115,  0, 90,139,  2,139, 77,  8,137, 65, 11,139, 66,  4,137,
/* 0x0410 */  65, 15,139, 66,  8,137, 65, 19,139, 66, 12,137, 65, 23,137,202,
/* 0x0420 */ 131,194, 27,137,248, 43, 69,224, 80,255,117,224, 82,232,252,255,
/* 0x0430 */ 255,255,137,195,198,  0,  0,106,  1,255,117,  8,232, 52,254,255,
/* 0x0440 */ 255,131,196, 20,232,  7,  0,  0,  0, 47, 99, 97, 99,104,101,  0,
/* 0x0450 */  90,139,  2,137,  3,102,139, 66,  4,102,137, 67,  4,141,115,  6,
/* 0x0460 */ 198,  6,  0,106,  1,255,117,  8,232,  8,254,255,255,131,196,  8,
/* 0x0470 */ 232,  5,  0,  0,  0, 47,117,112,120,  0, 88,139,  0,137,  6,141,
/* 0x0480 */ 126,  4,106, 20, 88,205,128,137,198, 80,232, 91,254,255,255,136,
/* 0x0490 */   7,137,240,193,232,  6,137,  4, 36,232, 76,254,255,255,136, 71,
/* 0x04a0 */   1,137,240,193,232, 12,137,  4, 36,232, 60,254,255,255,131,196,
/* 0x04b0 */   4,136, 71,  2,198, 71,  3,  0,184,  0,  0,  0,  0,141,101,244,
/* 0x04c0 */  91, 94, 95,201,195, 86, 83,139,116, 36, 12,139, 92, 36, 16,139,
/* 0x04d0 */  76, 36, 20, 73,131,249,255,116, 30,138, 22,131,202, 32, 15,190,
/* 0x04e0 */ 210,138,  3,131,200, 32, 15,190,192, 67, 70, 41,194,137,208,117,
/* 0x04f0 */  11, 73,131,249,255,117,226,184,  0,  0,  0,  0, 91, 94,195,  0,
/* 0x0500 */  85,137,229, 87, 86, 83,131,236, 24,139,125, 12,232,  4,  0,  0,
/* 0x0510 */   0,117,112,120,  0, 90,185, 16,  0,  0,  0,184,100,  1,  0,  0,
/* 0x0520 */ 137,211,205,128,137,198,131,248,234,117, 16,185,  0,  0,  0,  0,
/* 0x0530 */ 184,100,  1,  0,  0,137,211,205,128,137,198,133,246, 15,137,148,
/* 0x0540 */   0,  0,  0,232,  9,  0,  0,  0, 47,100,101,118, 47,115,104,109,
/* 0x0550 */   0, 94,185,  2,  0, 65,  0,186,192,  1,  0,  0,137,243,106,  5,
/* 0x0560 */  88,205,128,137,198,133,192,121,110,137,194,131,248,235, 15,133,
/* 0x0570 */ 161,  0,  0,  0,184,  2,  0,  0,  0,232, 62,  0,  0,  0, 85, 80,
/* 0x0580 */  88, 45, 53, 46, 48, 32,119, 97,110,116,115, 32,109,101,109,102,
/* 0x0590 */ 100, 95, 99,114,101, 97,116,101, 40, 41, 44, 32,111,114, 32,110,
/* 0x05a0 */ 101,101,100,115, 32, 47,100,101,118, 47,115,104,109, 40, 44, 79,
/* 0x05b0 */  95, 84, 77, 80, 70, 73, 76, 69, 44, 41, 10,  0, 89,186, 61,  0,
/* 0x05c0 */   0,  0,137,195,106,  4, 88,205,128,184,127,  0,  0,  0,137,195,
/* 0x05d0 */ 106,  1, 88,205,128,235,254,137,243,137,249,106, 93, 88,205,128,
/* 0x05e0 */ 137,194,133,192,120, 47,106,  0, 86,131,125,  8,  1, 25,192,131,
/* 0x05f0 */ 224,240,131,192, 17, 80,106,  3, 87,255,117,  8,232,252,255,255,
/* 0x0600 */ 255,137,195,232,252,255,255,255,131,196, 24,137,218, 57,195,115,
/* 0x0610 */   4,141, 84, 30,  1,137,208,141,101,244, 91, 94, 95,201,195,  0,
/* 0x0620 */  96,232,128,  0,  0,  0,243, 15, 30,251,  1,219,116,  2,243,195,
/* 0x0630 */ 139, 30,131,238,252, 17,219,195, 94,102,131,126,  8,  2,116,  1,
/* 0x0640 */ 244,139, 14,141,137, 24,  1,  0,  0, 81,106, 90, 87,141, 66,234,
/* 0x0650 */  80, 82, 86,137,229,129,236, 24,  1,  0,  0,131,228,248,106,  0,
/* 0x0660 */ 137,231, 87, 81,106,  0,232,245,  0,  0,  0,131,196, 12,169,  0,
/* 0x0670 */   8,  0,  0,116,  1,244,137,194,193,232, 12,193,224, 12, 41,194,
/* 0x0680 */  74,139,117,  0,139, 62,  1,199,137,120,  8,137,230,185, 24,  1,
/* 0x0690 */   0,  0,243,164,137,236,137, 68, 36, 16, 94, 82,255, 54, 84,139,
/* 0x06a0 */  78,  4,141,118, 12,137,199,  1,241, 81,139, 84, 36, 16, 49,219,
/* 0x06b0 */  49,201,131,205,255,252,168,164,255,210,114,251,141, 65,  1,255,
/* 0x06c0 */ 210, 17,192,255,210,115,248,131,232,  3,114, 11,193,224,  8,172,
/* 0x06d0 */ 131,240,255,116, 45,137,197,141, 65,  1,255,210, 17,201,255,210,
/* 0x06e0 */  17,201,117, 13,137,193,131,192,  2,255,210, 17,201,255,210,115,
/* 0x06f0 */ 248,129,253,  0,243,255,255, 17,193, 86,141, 52, 47,243,164, 94,
/* 0x0700 */ 235,182, 89, 57,206,116,  1,244, 89,139,124, 36, 20,139, 68, 36,
/* 0x0710 */  16,137,  7, 88,137, 71,  8,139, 84, 36, 20,137,249, 91, 88,106,
/* 0x0720 */   0, 83,106,  4, 88,205,128,106, 18,106,  5, 82, 87,137,227,106,
/* 0x0730 */  90, 88,205,128,139, 92, 36, 16,131,196, 24,106,  6, 88,205,128,
/* 0x0740 */ 131,199, 12,255,231,141, 92, 36,  4,106, 90, 88,205,128, 61,  0,
/* 0x0750 */ 240,255,255,114,  1,244,194, 24,  0,184,  0,240,255,255,195,  0,
/* 0x0760 */  49,192,195,135, 92, 36,  4,139, 76, 36,  8,176,106,232, 98,  0,
/* 0x0770 */   0,  0,139, 92, 36,  4,195, 85,137,229, 83,139, 93,  8,176,122,
/* 0x0780 */ 232, 79,  0,  0,  0, 91, 93,195, 85,137,229, 83,139, 93,  8,139,
/* 0x0790 */  77, 12,176, 39,232, 59,  0,  0,  0, 91, 93,195, 85,137,229, 87,
/* 0x07a0 */ 139, 77, 16,139, 69, 12,139,125,  8,243,170, 95, 93,195, 85,137,
/* 0x07b0 */ 229, 87, 86,139, 77, 16,139,117, 12,139,125,  8,243,164,137,248,
/* 0x07c0 */  94, 95, 93,195,204,195, 83,141, 92, 36,  8,176, 90,232,  2,  0,
/* 0x07d0 */   0,  0, 91,195, 15,182,192, 80,205,128, 90, 61,  0,240,255,255,
/* 0x07e0 */ 115,  1,195,244,129,236,  0,  2,  0,  0, 49,210,232, 16,  0,  0,
/* 0x07f0 */   0, 47,112,114,111, 99, 47,115,101,108,102, 47, 97,117,120,118,
/* 0x0800 */   0, 89,106,156, 91,184, 39,  1,  0,  0,205,128,133,192,124, 40,
/* 0x0810 */ 137,197,186,  0,  2,  0,  0,137,225,137,195,106,  3, 88,205,128,
/* 0x0820 */ 133,192,124, 20,137,193,137,230,173,133,192,116, 11,131,248,  6,
/* 0x0830 */ 173,116, 10,131,233,  8,117,240,184,  0, 16,  0,  0,247,216,129,
/* 0x0840 */ 196,  0,  2,  0,  0, 80,137,235,106,  6, 88,205,128, 95, 90,232,
/* 0x0850 */  20,  0,  0,  0,  0, 46,115,121,109,116, 97, 98,  0, 46,115,116,
/* 0x0860 */ 114,116, 97, 98,  0, 46,115,104,115,116,114,116, 97, 98,  0, 46,
/* 0x0870 */ 114,101,108, 72, 85, 77, 70, 95, 65,  0, 46,114,101,108, 72, 85,
/* 0x0880 */  77, 70, 95, 76,  0, 46,114,101,108, 85, 77, 70, 95, 65, 78, 68,
/* 0x0890 */  82, 79, 73, 68,  0, 46,114,101,108, 85, 77, 70, 95, 76, 73, 78,
/* 0x08a0 */  85, 88,  0, 46,114,101,108, 69, 76, 70, 77, 65, 73, 78, 88,  0,
/* 0x08b0 */  46,114,101,108, 69, 76, 70, 77, 65, 73, 78, 90,  0,  0,  0,  0,
/* 0x08c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x08d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x08e0 */   0,  0,  0,  0,  0,  0,  0,  0, 31,  0,  0,  0,  1,  0,  0,  0,
/* 0x08f0 */   6,  0,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  5,  0,  0,  0,
/* 0x0900 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x0910 */  27,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0920 */ 240, 12,  0,  0,  8,  0,  0,  0, 14,  0,  0,  0,  1,  0,  0,  0,
/* 0x0930 */   4,  0,  0,  0,  8,  0,  0,  0, 42,  0,  0,  0,  1,  0,  0,  0,
/* 0x0940 */   6,  0,  0,  0,  0,  0,  0,  0, 57,  0,  0,  0,  5,  0,  0,  0,
/* 0x0950 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x0960 */  38,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0970 */ 248, 12,  0,  0,  8,  0,  0,  0, 14,  0,  0,  0,  3,  0,  0,  0,
/* 0x0980 */   4,  0,  0,  0,  8,  0,  0,  0, 53,  0,  0,  0,  1,  0,  0,  0,
/* 0x0990 */   6,  0,  0,  0,  0,  0,  0,  0, 64,  0,  0,  0,191,  4,  0,  0,
/* 0x09a0 */   0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x09b0 */  49,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x09c0 */   0, 13,  0,  0, 80,  0,  0,  0, 14,  0,  0,  0,  5,  0,  0,  0,
/* 0x09d0 */   4,  0,  0,  0,  8,  0,  0,  0, 69,  0,  0,  0,  1,  0,  0,  0,
/* 0x09e0 */   6,  0,  0,  0,  0,  0,  0,  0,  0,  5,  0,  0, 31,  1,  0,  0,
/* 0x09f0 */   0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a00 */  65,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a10 */  80, 13,  0,  0, 16,  0,  0,  0, 14,  0,  0,  0,  7,  0,  0,  0,
/* 0x0a20 */   4,  0,  0,  0,  8,  0,  0,  0, 83,  0,  0,  0,  1,  0,  0,  0,
/* 0x0a30 */   6,  0,  0,  0,  0,  0,  0,  0, 32,  6,  0,  0, 64,  1,  0,  0,
/* 0x0a40 */   0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a50 */  79,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a60 */  96, 13,  0,  0,  8,  0,  0,  0, 14,  0,  0,  0,  9,  0,  0,  0,
/* 0x0a70 */   4,  0,  0,  0,  8,  0,  0,  0, 96,  0,  0,  0,  1,  0,  0,  0,
/* 0x0a80 */   0,  0,  0,  0,  0,  0,  0,  0, 96,  7,  0,  0,244,  0,  0,  0,
/* 0x0a90 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x0aa0 */  92,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ab0 */ 104, 13,  0,  0,  8,  0,  0,  0, 14,  0,  0,  0, 11,  0,  0,  0,
/* 0x0ac0 */   4,  0,  0,  0,  8,  0,  0,  0, 17,  0,  0,  0,  3,  0,  0,  0,
/* 0x0ad0 */   0,  0,  0,  0,  0,  0,  0,  0, 84,  8,  0,  0,105,  0,  0,  0,
/* 0x0ae0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x0af0 */   1,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b00 */  64, 11,  0,  0, 48,  1,  0,  0, 15,  0,  0,  0,  8,  0,  0,  0,
/* 0x0b10 */   4,  0,  0,  0, 16,  0,  0,  0,  9,  0,  0,  0,  3,  0,  0,  0,
/* 0x0b20 */   0,  0,  0,  0,  0,  0,  0,  0,112, 12,  0,  0,128,  0,  0,  0,
/* 0x0b30 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  9,  0,
/* 0x0b60 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 11,  0,
/* 0x0b70 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  9,  0,
/* 0x0b80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  1,  0,
/* 0x0b90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  3,  0,
/* 0x0ba0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  5,  0,
/* 0x0bb0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  7,  0,
/* 0x0bc0 */   8,  0,  0,  0, 57,  1,  0,  0,  0,  0,  0,  0, 16,  0,  9,  0,
/* 0x0bd0 */  22,  0,  0,  0, 78,  0,  0,  0,  0,  0,  0,  0, 16,  0, 11,  0,
/* 0x0be0 */  30,  0,  0,  0,  0,  0,  0,  0, 53,  2,  0,  0, 18,  0,  5,  0,
/* 0x0bf0 */  54,  0,  0,  0,102,  0,  0,  0,  0,  0,  0,  0, 16,  0, 11,  0,
/* 0x0c00 */  59,  0,  0,  0,  0,  0,  0,  0, 31,  1,  0,  0, 18,  0,  7,  0,
/* 0x0c10 */  81,  0,  0,  0, 23,  0,  0,  0,  0,  0,  0,  0, 16,  0, 11,  0,
/* 0x0c20 */  87,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 16,  0, 11,  0,
/* 0x0c30 */ 102,  0,  0,  0, 60,  0,  0,  0,  0,  0,  0,  0, 16,  0, 11,  0,
/* 0x0c40 */ 109,  0,  0,  0,100,  0,  0,  0,  0,  0,  0,  0, 16,  0, 11,  0,
/* 0x0c50 */ 117,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0, 16,  0, 11,  0,
/* 0x0c60 */ 122,  0,  0,  0, 40,  0,  0,  0,  0,  0,  0,  0, 16,  0, 11,  0,
/* 0x0c70 */   0, 95,115,116, 97,114,116,  0,103,101,116, 95,112, 97,103,101,
/* 0x0c80 */  95,109, 97,115,107,  0,109,101,109,112, 99,112,121,  0,117,112,
/* 0x0c90 */ 120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100, 95, 97,110,
/* 0x0ca0 */ 100,114,111,105,100,  0,109,109, 97,112,  0,117,112,120, 95,109,
/* 0x0cb0 */ 109, 97,112, 95, 97,110,100, 95,102,100, 95,108,105,110,117,120,
/* 0x0cc0 */   0,117,110, 97,109,101,  0,103,101,116, 95,117,112,120,102,110,
/* 0x0cd0 */  95,112, 97,116,104,  0,109,101,109,115,101,116,  0,109,121, 95,
/* 0x0ce0 */  98,107,112,116,  0,115,116, 97,116,  0,109,107,100,105,114,  0,
/* 0x0cf0 */   1,  0,  0,  0,  2, 10,  0,  0,  1,  0,  0,  0,  2, 12,  0,  0,
/* 0x0d00 */ 124,  0,  0,  0,  2, 16,  0,  0,241,  0,  0,  0,  2, 14,  0,  0,
/* 0x0d10 */ 111,  1,  0,  0,  2,  8,  0,  0,224,  1,  0,  0,  2,  8,  0,  0,
/* 0x0d20 */  18,  2,  0,  0,  2, 11,  0,  0, 73,  2,  0,  0,  2, 15,  0,  0,
/* 0x0d30 */ 152,  2,  0,  0,  2, 16,  0,  0, 94,  3,  0,  0,  2, 16,  0,  0,
/* 0x0d40 */ 146,  3,  0,  0,  2,  9,  0,  0,238,  3,  0,  0,  2,  9,  0,  0,
/* 0x0d50 */ 253,  0,  0,  0,  2, 11,  0,  0,  4,  1,  0,  0,  2,  8,  0,  0,
/* 0x0d60 */   2,  0,  0,  0,  2,  2,  0,  0,240,  0,  0,  0,  2,  1,  0,  0,
/* 0x0d70 */ 102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,102, 51,
/* 0x0d80 */  50, 45,105, 51, 56, 54, 10, 10, 83,101, 99,116,105,111,110,115,
/* 0x0d90 */  58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32,
/* 0x0da0 */  32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86, 77,
/* 0x0db0 */  65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32,
/* 0x0dc0 */  32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,103,110,
/* 0x0dd0 */  32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 72, 85, 77, 70,
/* 0x0de0 */  95, 65, 32, 32, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32,
/* 0x0df0 */  32, 48, 32, 32, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x0e00 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32, 72, 85, 77, 70,
/* 0x0e10 */  95, 76, 32, 32, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32,
/* 0x0e20 */  32, 48, 32, 32, 48, 51, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x0e30 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 50, 32, 85, 77, 70, 95,
/* 0x0e40 */  65, 78, 68, 82, 79, 73, 68, 32, 32, 32, 48, 52, 98,102, 32, 32,
/* 0x0e50 */  48, 32, 32, 48, 32, 32, 48, 52, 48, 32, 32, 50, 42, 42, 50, 32,
/* 0x0e60 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32, 85, 77,
/* 0x0e70 */  70, 95, 76, 73, 78, 85, 88, 32, 32, 32, 32, 32, 48, 49, 49,102,
/* 0x0e80 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 53, 48, 48, 32, 32, 50, 42,
/* 0x0e90 */  42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 52,
/* 0x0ea0 */  32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 32, 32, 32, 32, 32, 48,
/* 0x0eb0 */  49, 52, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 54, 50, 48, 32,
/* 0x0ec0 */  32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x0ed0 */  32, 32, 53, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 32, 32, 32,
/* 0x0ee0 */  32, 32, 48,102, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 55, 54,
/* 0x0ef0 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x0f00 */  83, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10,
/* 0x0f10 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x0f20 */  32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 48, 32, 69, 76, 70, 77,
/* 0x0f30 */  65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x0f40 */  32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48,
/* 0x0f50 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48,
/* 0x0f60 */  48, 48, 32,108, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x0f70 */  73, 78, 88, 32, 48, 32, 95,115,116, 97,114,116, 10, 48, 48, 48,
/* 0x0f80 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 72, 85,
/* 0x0f90 */  77, 70, 95, 65, 32, 48, 32, 72, 85, 77, 70, 95, 65, 10, 48, 48,
/* 0x0fa0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 72,
/* 0x0fb0 */  85, 77, 70, 95, 76, 32, 48, 32, 72, 85, 77, 70, 95, 76, 10, 48,
/* 0x0fc0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x0fd0 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 32, 48, 32, 85, 77,
/* 0x0fe0 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x0ff0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 85, 77, 70, 95, 76,
/* 0x1000 */  73, 78, 85, 88, 32, 48, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88,
/* 0x1010 */  10, 48, 48, 48, 48, 48, 49, 51, 57, 32,103, 32, 32, 32, 32, 32,
/* 0x1020 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 48, 32,103,101,116,
/* 0x1030 */  95,112, 97,103,101, 95,109, 97,115,107, 10, 48, 48, 48, 48, 48,
/* 0x1040 */  48, 52,101, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x1050 */  65, 73, 78, 90, 32, 48, 32,109,101,109,112, 99,112,121, 10, 48,
/* 0x1060 */  48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32,
/* 0x1070 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 32, 48, 50, 51, 53,
/* 0x1080 */  32,117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100,
/* 0x1090 */  95, 97,110,100,114,111,105,100, 10, 48, 48, 48, 48, 48, 48, 54,
/* 0x10a0 */  54, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x10b0 */  78, 90, 32, 48, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48,
/* 0x10c0 */  48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 85, 77, 70, 95, 76,
/* 0x10d0 */  73, 78, 85, 88, 32, 48, 49, 49,102, 32,117,112,120, 95,109,109,
/* 0x10e0 */  97,112, 95, 97,110,100, 95,102,100, 95,108,105,110,117,120, 10,
/* 0x10f0 */  48, 48, 48, 48, 48, 48, 49, 55, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x1100 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,117,110, 97,109,
/* 0x1110 */ 101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32,
/* 0x1120 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,103,101,
/* 0x1130 */ 116, 95,117,112,120,102,110, 95,112, 97,116,104, 10, 48, 48, 48,
/* 0x1140 */  48, 48, 48, 51, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x1150 */  70, 77, 65, 73, 78, 90, 32, 48, 32,109,101,109,115,101,116, 10,
/* 0x1160 */  48, 48, 48, 48, 48, 48, 54, 52, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x1170 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,109,121, 95, 98,
/* 0x1180 */ 107,112,116, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32,103, 32, 32,
/* 0x1190 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,
/* 0x11a0 */ 115,116, 97,116, 10, 48, 48, 48, 48, 48, 48, 50, 56, 32,103, 32,
/* 0x11b0 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48,
/* 0x11c0 */  32,109,107,100,105,114, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x11d0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x11e0 */  72, 85, 77, 70, 95, 65, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x11f0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1200 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x1210 */  48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x1220 */  32, 32, 32, 32, 32,117,112,120, 95,109,109, 97,112, 95, 97,110,
/* 0x1230 */ 100, 95,102,100, 95, 97,110,100,114,111,105,100, 10, 10, 82, 69,
/* 0x1240 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x1250 */  32, 70, 79, 82, 32, 91, 72, 85, 77, 70, 95, 76, 93, 58, 10, 79,
/* 0x1260 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x1270 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x1280 */  48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x1290 */  67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,117,112,120, 95,109,
/* 0x12a0 */ 109, 97,112, 95, 97,110,100, 95,102,100, 95,108,105,110,117,120,
/* 0x12b0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x12c0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 85, 77, 70, 95, 65, 78,
/* 0x12d0 */  68, 82, 79, 73, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x12e0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x12f0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 55,
/* 0x1300 */  99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x1310 */  32, 32, 32, 32,109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48,
/* 0x1320 */  48, 48,102, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,
/* 0x1330 */  32, 32, 32, 32, 32, 32, 32,103,101,116, 95,117,112,120,102,110,
/* 0x1340 */  95,112, 97,116,104, 10, 48, 48, 48, 48, 48, 49, 54,102, 32, 82,
/* 0x1350 */  95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x1360 */  32,103,101,116, 95,112, 97,103,101, 95,109, 97,115,107, 10, 48,
/* 0x1370 */  48, 48, 48, 48, 49,101, 48, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x1380 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 32,103,101,116, 95,112, 97,
/* 0x1390 */ 103,101, 95,109, 97,115,107, 10, 48, 48, 48, 48, 48, 50, 49, 50,
/* 0x13a0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x13b0 */  32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 50, 52, 57,
/* 0x13c0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x13d0 */  32, 32, 32,109,101,109,115,101,116, 10, 48, 48, 48, 48, 48, 50,
/* 0x13e0 */  57, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x13f0 */  32, 32, 32, 32, 32,109,121, 95, 98,107,112,116, 10, 48, 48, 48,
/* 0x1400 */  48, 48, 51, 53,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50,
/* 0x1410 */  32, 32, 32, 32, 32, 32, 32, 32,109,121, 95, 98,107,112,116, 10,
/* 0x1420 */  48, 48, 48, 48, 48, 51, 57, 50, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x1430 */  67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,112, 99,
/* 0x1440 */ 112,121, 10, 48, 48, 48, 48, 48, 51,101,101, 32, 82, 95, 51, 56,
/* 0x1450 */  54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,109,101,
/* 0x1460 */ 109,112, 99,112,121, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x1470 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 85,
/* 0x1480 */  77, 70, 95, 76, 73, 78, 85, 88, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x1490 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x14a0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x14b0 */  48, 48,102,100, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,
/* 0x14c0 */  32, 32, 32, 32, 32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48,
/* 0x14d0 */  48, 49, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,
/* 0x14e0 */  32, 32, 32, 32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,
/* 0x14f0 */ 109, 97,115,107, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x1500 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 76,
/* 0x1510 */  70, 77, 65, 73, 78, 88, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x1520 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1530 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x1540 */  48, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x1550 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 10, 82,
/* 0x1560 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x1570 */  83, 32, 70, 79, 82, 32, 91, 69, 76, 70, 77, 65, 73, 78, 90, 93,
/* 0x1580 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x1590 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x15a0 */  85, 69, 10, 48, 48, 48, 48, 48, 48,102, 48, 32, 82, 95, 51, 56,
/* 0x15b0 */  54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x15c0 */  70, 77, 65, 73, 78, 88, 10
};
