# git config

> Керує спеціальними параметрами конфігурації для репозиторію Git.
> Конфігурації можуть бути локальні (для поточного репозиторію) або глобальні (для поточного користувача).
> Більше інформації: <https://git-scm.com/docs/git-config>.

- Надає перелік лише локальних налаштувань (що зберігаються у `.git/config` поточного репозиторію):

`git config {{[-l|--list]}} --local`

- Надає перелік лише глобальних налаштувань (що зберігаються у `~/.gitconfig`):

`git config {{[-l|--list]}} --global`

- Отримує значення для наданого параметру конфігурації:

`git config alias.unstage`

- Встановлює глобальне значення для наданого параметру конфігурації:

`git config --global alias.unstage "reset HEAD --"`

- Повертає значення по замовчанню для наданого глобального параметру конфігурації:

`git config --global --unset alias.unstage`

- Відкриває для редагування файл конфігурацій поточного репозиторію у редакторі по замовчуванню:

`git config {{[-e|--edit]}}`

- Відкриває для редагування файл з глобальними конфігураціями у редакторі по замовчанню:

`git config --global {{[-e|--edit]}}`
