/* valaclass.c generated by valac, the Vala compiler
 * generated from valaclass.vala, do not modify */

/* valaclass.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	gboolean _is_partial;
	gboolean _is_sealed;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean* _is_compact;
	gboolean* _is_opaque;
	gboolean* _is_immutable;
	gboolean* _is_singleton;
	ValaList* base_types;
	ValaHashMap* implicit_implementations;
	ValaCreationMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _static_destructor;
};

static gint ValaClass_private_offset;
static gpointer vala_class_parent_class = NULL;

static gboolean* _bool_dup (gboolean* self);
static void vala_class_set_has_class_private_fields (ValaClass* self,
                                              gboolean value);
static guint _vala_symbol_hash_func_ghash_func (gconstpointer key);
static gboolean _vala_symbol_equal_func_gequal_func (gconstpointer a,
                                              gconstpointer b);
static void vala_class_set_default_construction_method (ValaClass* self,
                                                 ValaCreationMethod* value);
static void vala_class_set_constructor (ValaClass* self,
                                 ValaConstructor* value);
static void vala_class_set_class_constructor (ValaClass* self,
                                       ValaConstructor* value);
static void vala_class_set_static_constructor (ValaClass* self,
                                        ValaConstructor* value);
static void vala_class_set_destructor (ValaClass* self,
                                ValaDestructor* value);
static void vala_class_set_static_destructor (ValaClass* self,
                                       ValaDestructor* value);
static void vala_class_set_class_destructor (ValaClass* self,
                                      ValaDestructor* value);
static void vala_class_real_add_field (ValaSymbol* base,
                                ValaField* f);
static void vala_class_real_add_method (ValaSymbol* base,
                                 ValaMethod* m);
static void vala_class_real_add_property (ValaSymbol* base,
                                   ValaProperty* prop);
static void vala_class_real_add_constructor (ValaSymbol* base,
                                      ValaConstructor* c);
static void vala_class_real_add_destructor (ValaSymbol* base,
                                     ValaDestructor* d);
static void vala_class_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_class_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                                        ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static void vala_class_get_all_prerequisites (ValaClass* self,
                                       ValaInterface* iface,
                                       ValaList* list);
static gboolean vala_class_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_class_finalize (ValaCodeNode * obj);
static GType vala_class_get_type_once (void);

static inline gpointer
vala_class_get_instance_private (ValaClass* self)
{
	return G_STRUCT_MEMBER_P (self, ValaClass_private_offset);
}

ValaClass*
vala_class_get_base_class (ValaClass* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_class;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_class_set_base_class (ValaClass* self,
                           ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_class);
	self->priv->_base_class = _tmp0_;
}

gboolean
vala_class_get_is_abstract (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_class_set_is_abstract (ValaClass* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

gboolean
vala_class_get_is_partial (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_partial;
	return result;
}

void
vala_class_set_is_partial (ValaClass* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_partial = value;
}

gboolean
vala_class_get_is_sealed (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_sealed;
	return result;
}

void
vala_class_set_is_sealed (ValaClass* self,
                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_sealed = value;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

gboolean
vala_class_get_is_compact (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_compact;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_compact (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp7_;
		} else {
			gboolean _tmp8_;
			gboolean* _tmp9_;
			_tmp8_ = vala_code_node_has_attribute ((ValaCodeNode*) self, "Compact");
			_tmp9_ = __bool_dup0 (&_tmp8_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp9_;
		}
	}
	_tmp10_ = self->priv->_is_compact;
	result = *_tmp10_;
	return result;
}

gboolean
vala_class_get_is_opaque (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_opaque;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		gboolean* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "Compact", "opaque", FALSE);
		_tmp2_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_is_opaque);
		self->priv->_is_opaque = _tmp2_;
	}
	_tmp3_ = self->priv->_is_opaque;
	result = *_tmp3_;
	return result;
}

gboolean
vala_class_get_is_immutable (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_immutable (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp7_;
		} else {
			gboolean _tmp8_;
			gboolean* _tmp9_;
			_tmp8_ = vala_code_node_has_attribute ((ValaCodeNode*) self, "Immutable");
			_tmp9_ = __bool_dup0 (&_tmp8_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp9_;
		}
	}
	_tmp10_ = self->priv->_is_immutable;
	result = *_tmp10_;
	return result;
}

gboolean
vala_class_get_is_singleton (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_singleton;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		gboolean* _tmp2_;
		_tmp1_ = vala_code_node_has_attribute ((ValaCodeNode*) self, "SingleInstance");
		_tmp2_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_is_singleton);
		self->priv->_is_singleton = _tmp2_;
	}
	_tmp3_ = self->priv->_is_singleton;
	result = *_tmp3_;
	return result;
}

gboolean
vala_class_get_has_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_private_fields;
	return result;
}

void
vala_class_set_has_private_fields (ValaClass* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_private_fields = value;
}

gboolean
vala_class_get_has_class_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_class_private_fields;
	return result;
}

static void
vala_class_set_has_class_private_fields (ValaClass* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_class_private_fields = value;
}

static guint
_vala_symbol_hash_func_ghash_func (gconstpointer key)
{
	guint result;
	result = vala_symbol_hash_func ((ValaSymbol*) key);
	return result;
}

static gboolean
_vala_symbol_equal_func_gequal_func (gconstpointer a,
                                     gconstpointer b)
{
	gboolean result;
	result = vala_symbol_equal_func ((ValaSymbol*) a, (ValaSymbol*) b);
	return result;
}

ValaCreationMethod*
vala_class_get_default_construction_method (ValaClass* self)
{
	ValaCreationMethod* result;
	ValaCreationMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_default_construction_method (ValaClass* self,
                                            ValaCreationMethod* value)
{
	ValaCreationMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp0_;
}

ValaConstructor*
vala_class_get_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_constructor (ValaClass* self,
                            ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_constructor);
	self->priv->_constructor = _tmp0_;
	_tmp1_ = self->priv->_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_class_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_constructor (ValaClass* self,
                                  ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	self->priv->_class_constructor = _tmp0_;
	_tmp1_ = self->priv->_class_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_static_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_constructor (ValaClass* self,
                                   ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	self->priv->_static_constructor = _tmp0_;
	_tmp1_ = self->priv->_static_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_destructor (ValaClass* self,
                           ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_destructor);
	self->priv->_destructor = _tmp0_;
	_tmp1_ = self->priv->_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_static_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_destructor (ValaClass* self,
                                  ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	self->priv->_static_destructor = _tmp0_;
	_tmp1_ = self->priv->_static_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_class_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_destructor (ValaClass* self,
                                 ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	self->priv->_class_destructor = _tmp0_;
	_tmp1_ = self->priv->_class_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

gboolean
vala_class_get_is_error_base (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_has_attribute ((ValaCodeNode*) self, "ErrorBase");
	return result;
}

/**
 * Creates a new class.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @param comment          class documentation
 * @return                 newly created class
 */
ValaClass*
vala_class_construct (GType object_type,
                      const gchar* name,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaClass* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaClass*
vala_class_new (const gchar* name,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}

/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void
vala_class_add_base_type (ValaClass* self,
                          ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->base_types;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}

/**
 * Returns the base type list.
 *
 * @return list of base types
 */
ValaList*
vala_class_get_base_types (ValaClass* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->base_types;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
static void
vala_class_real_add_field (ValaSymbol* base,
                           ValaField* f)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbolAccessibility _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	self = (ValaClass*) base;
	g_return_if_fail (f != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_field ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), f);
	_tmp1_ = vala_symbol_get_access ((ValaSymbol*) f);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaMemberBinding _tmp3_;
		ValaMemberBinding _tmp4_;
		_tmp3_ = vala_field_get_binding (f);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp5_ = FALSE;
		ValaSymbolAccessibility _tmp6_;
		ValaSymbolAccessibility _tmp7_;
		_tmp6_ = vala_symbol_get_access ((ValaSymbol*) f);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaMemberBinding _tmp8_;
			ValaMemberBinding _tmp9_;
			_tmp8_ = vala_field_get_binding (f);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ == VALA_MEMBER_BINDING_CLASS;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
}

/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
static void
vala_class_real_add_method (ValaSymbol* base,
                            ValaMethod* m)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	gboolean _tmp25_ = FALSE;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	self = (ValaClass*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = vala_method_get_binding (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != VALA_MEMBER_BINDING_STATIC) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		ValaSourceReference* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaParameter* _tmp15_;
		ValaParameter* _tmp16_;
		ValaScope* _tmp17_;
		ValaScope* _tmp18_;
		ValaParameter* _tmp19_;
		ValaParameter* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		ValaParameter* _tmp23_;
		ValaParameter* _tmp24_;
		_tmp3_ = vala_method_get_this_parameter (m);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaScope* _tmp5_;
			ValaScope* _tmp6_;
			ValaParameter* _tmp7_;
			ValaParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_method_get_this_parameter (m);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			vala_scope_remove (_tmp6_, _tmp10_);
		}
		_tmp11_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) m, (ValaTypeSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_parameter_new ("this", _tmp12_, _tmp14_);
		_tmp16_ = _tmp15_;
		vala_method_set_this_parameter (m, _tmp16_);
		_vala_code_node_unref0 (_tmp16_);
		_vala_code_node_unref0 (_tmp12_);
		_tmp17_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_method_get_this_parameter (m);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_symbol_get_name ((ValaSymbol*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_method_get_this_parameter (m);
		_tmp24_ = _tmp23_;
		vala_scope_add (_tmp18_, _tmp22_, (ValaSymbol*) _tmp24_);
	}
	_tmp26_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp27_ = _tmp26_;
	if (!VALA_IS_VOID_TYPE (_tmp27_)) {
		ValaList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		_tmp28_ = vala_method_get_postconditions (m);
		_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp25_ = _tmp30_ > 0;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		ValaLocalVariable* _tmp31_;
		ValaLocalVariable* _tmp32_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaDataType* _tmp41_;
		ValaDataType* _tmp42_;
		ValaSourceReference* _tmp43_;
		ValaSourceReference* _tmp44_;
		ValaLocalVariable* _tmp45_;
		ValaLocalVariable* _tmp46_;
		ValaLocalVariable* _tmp47_;
		ValaLocalVariable* _tmp48_;
		_tmp31_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp32_ = _tmp31_;
		if (_tmp32_ != NULL) {
			ValaScope* _tmp33_;
			ValaScope* _tmp34_;
			ValaLocalVariable* _tmp35_;
			ValaLocalVariable* _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			_tmp33_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_symbol_get_name ((ValaSymbol*) _tmp36_);
			_tmp38_ = _tmp37_;
			vala_scope_remove (_tmp34_, _tmp38_);
		}
		_tmp39_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_data_type_copy (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp44_ = _tmp43_;
		_tmp45_ = vala_local_variable_new (_tmp42_, "result", NULL, _tmp44_);
		_tmp46_ = _tmp45_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp46_);
		_vala_code_node_unref0 (_tmp46_);
		_vala_code_node_unref0 (_tmp42_);
		_tmp47_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp48_ = _tmp47_;
		vala_local_variable_set_is_result (_tmp48_, TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		const gchar* _tmp49_;
		const gchar* _tmp50_;
		ValaCreationMethod* cm = NULL;
		gboolean _tmp51_ = FALSE;
		ValaCreationMethod* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		gboolean _tmp67_ = FALSE;
		gboolean _tmp68_;
		_tmp49_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp50_ = _tmp49_;
		if (_tmp50_ == NULL) {
			vala_class_set_default_construction_method (self, G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		cm = G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
		_tmp52_ = cm;
		_tmp53_ = vala_creation_method_get_class_name (_tmp52_);
		_tmp54_ = _tmp53_;
		if (_tmp54_ != NULL) {
			ValaCreationMethod* _tmp55_;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			_tmp55_ = cm;
			_tmp56_ = vala_creation_method_get_class_name (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp59_ = _tmp58_;
			_tmp51_ = g_strcmp0 (_tmp57_, _tmp59_) != 0;
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			ValaSourceReference* _tmp60_;
			ValaSourceReference* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			ValaCreationMethod* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp63_ = _tmp62_;
			_tmp64_ = cm;
			_tmp65_ = vala_creation_method_get_class_name (_tmp64_);
			_tmp66_ = _tmp65_;
			vala_report_error (_tmp61_, "missing return type in method `%s.%s´", _tmp63_, _tmp66_);
			_g_free0 (_tmp63_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			return;
		}
		_tmp68_ = self->priv->_is_abstract;
		if (_tmp68_) {
			ValaCreationMethod* _tmp69_;
			ValaSymbolAccessibility _tmp70_;
			ValaSymbolAccessibility _tmp71_;
			_tmp69_ = cm;
			_tmp70_ = vala_symbol_get_access ((ValaSymbol*) _tmp69_);
			_tmp71_ = _tmp70_;
			_tmp67_ = _tmp71_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
		} else {
			_tmp67_ = FALSE;
		}
		if (_tmp67_) {
			gboolean _tmp72_;
			gboolean _tmp73_;
			_tmp72_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp73_ = _tmp72_;
			if (_tmp73_) {
				ValaSourceReference* _tmp74_;
				ValaSourceReference* _tmp75_;
				_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp75_ = _tmp74_;
				vala_report_warning (_tmp75_, "Creation method of abstract class cannot be public.");
			} else {
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp77_ = _tmp76_;
				vala_report_error (_tmp77_, "Creation method of abstract class cannot be public.");
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				return;
			}
		}
	}
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

ValaHashMap*
vala_class_get_implicit_implementations (ValaClass* self)
{
	ValaHashMap* _tmp0_;
	ValaHashMap* _tmp1_;
	ValaHashMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->implicit_implementations;
	_tmp1_ = _vala_map_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
static void
vala_class_real_add_property (ValaSymbol* base,
                              ValaProperty* prop)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaField* _tmp16_;
	ValaField* _tmp17_;
	self = (ValaClass*) base;
	g_return_if_fail (prop != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp0_ = vala_property_get_binding (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != VALA_MEMBER_BINDING_STATIC) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaScope* _tmp8_;
		ValaScope* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaParameter* _tmp14_;
		ValaParameter* _tmp15_;
		_tmp2_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) prop, (ValaTypeSymbol*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_parameter_new ("this", _tmp3_, _tmp5_);
		_tmp7_ = _tmp6_;
		vala_property_set_this_parameter (prop, _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
		_vala_code_node_unref0 (_tmp3_);
		_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) prop);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_property_get_this_parameter (prop);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_property_get_this_parameter (prop);
		_tmp15_ = _tmp14_;
		vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
	}
	_tmp16_ = vala_property_get_field (prop);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaField* _tmp18_;
		ValaField* _tmp19_;
		_tmp18_ = vala_property_get_field (prop);
		_tmp19_ = _tmp18_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp19_);
	}
}

static void
vala_class_real_add_constructor (ValaSymbol* base,
                                 ValaConstructor* c)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp14_;
	ValaMemberBinding _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_constructor_get_binding (c);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaConstructor* _tmp2_;
			ValaConstructor* _tmp3_;
			_tmp2_ = vala_class_get_constructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a constructor");
			}
			vala_class_set_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaConstructor* _tmp6_;
			ValaConstructor* _tmp7_;
			_tmp6_ = vala_class_get_class_constructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class constructor");
			}
			vala_class_set_class_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaConstructor* _tmp10_;
			ValaConstructor* _tmp11_;
			_tmp10_ = vala_class_get_static_constructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static constructor");
			}
			vala_class_set_static_constructor (self, c);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp14_ = vala_constructor_get_binding (c);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != VALA_MEMBER_BINDING_STATIC) {
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaParameter* _tmp28_;
		ValaParameter* _tmp29_;
		ValaScope* _tmp30_;
		ValaScope* _tmp31_;
		ValaParameter* _tmp32_;
		ValaParameter* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		ValaParameter* _tmp36_;
		ValaParameter* _tmp37_;
		_tmp16_ = vala_constructor_get_this_parameter (c);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != NULL) {
			ValaScope* _tmp18_;
			ValaScope* _tmp19_;
			ValaParameter* _tmp20_;
			ValaParameter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) c);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_constructor_get_this_parameter (c);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_scope_remove (_tmp19_, _tmp23_);
		}
		_tmp24_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) c, (ValaTypeSymbol*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_parameter_new ("this", _tmp25_, _tmp27_);
		_tmp29_ = _tmp28_;
		vala_constructor_set_this_parameter (c, _tmp29_);
		_vala_code_node_unref0 (_tmp29_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp30_ = vala_symbol_get_scope ((ValaSymbol*) c);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_constructor_get_this_parameter (c);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_symbol_get_name ((ValaSymbol*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_constructor_get_this_parameter (c);
		_tmp37_ = _tmp36_;
		vala_scope_add (_tmp31_, _tmp35_, (ValaSymbol*) _tmp37_);
	}
}

static void
vala_class_real_add_destructor (ValaSymbol* base,
                                ValaDestructor* d)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp14_;
	ValaMemberBinding _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_destructor_get_binding (d);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaDestructor* _tmp2_;
			ValaDestructor* _tmp3_;
			_tmp2_ = vala_class_get_destructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a destructor");
			}
			vala_class_set_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaDestructor* _tmp6_;
			ValaDestructor* _tmp7_;
			_tmp6_ = vala_class_get_class_destructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class destructor");
			}
			vala_class_set_class_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaDestructor* _tmp10_;
			ValaDestructor* _tmp11_;
			_tmp10_ = vala_class_get_static_destructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static destructor");
			}
			vala_class_set_static_destructor (self, d);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp14_ = vala_destructor_get_binding (d);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != VALA_MEMBER_BINDING_STATIC) {
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaParameter* _tmp28_;
		ValaParameter* _tmp29_;
		ValaScope* _tmp30_;
		ValaScope* _tmp31_;
		ValaParameter* _tmp32_;
		ValaParameter* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		ValaParameter* _tmp36_;
		ValaParameter* _tmp37_;
		_tmp16_ = vala_destructor_get_this_parameter (d);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != NULL) {
			ValaScope* _tmp18_;
			ValaScope* _tmp19_;
			ValaParameter* _tmp20_;
			ValaParameter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) d);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_destructor_get_this_parameter (d);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_scope_remove (_tmp19_, _tmp23_);
		}
		_tmp24_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) d, (ValaTypeSymbol*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_parameter_new ("this", _tmp25_, _tmp27_);
		_tmp29_ = _tmp28_;
		vala_destructor_set_this_parameter (d, _tmp29_);
		_vala_code_node_unref0 (_tmp29_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp30_ = vala_symbol_get_scope ((ValaSymbol*) d);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_destructor_get_this_parameter (d);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_symbol_get_name ((ValaSymbol*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_destructor_get_this_parameter (d);
		_tmp37_ = _tmp36_;
		vala_scope_add (_tmp31_, _tmp35_, (ValaSymbol*) _tmp37_);
	}
}

static void
vala_class_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_class (visitor, self);
}

static void
vala_class_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaClass * self;
	ValaConstructor* _tmp9_;
	ValaConstructor* _tmp10_;
	ValaConstructor* _tmp13_;
	ValaConstructor* _tmp14_;
	ValaConstructor* _tmp17_;
	ValaConstructor* _tmp18_;
	ValaDestructor* _tmp21_;
	ValaDestructor* _tmp22_;
	ValaDestructor* _tmp25_;
	ValaDestructor* _tmp26_;
	ValaDestructor* _tmp29_;
	ValaDestructor* _tmp30_;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		gint _type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_index = 0;
		_tmp0_ = self->priv->base_types;
		_type_list = _tmp0_;
		_tmp1_ = _type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_size = _tmp3_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			_type_index = _type_index + 1;
			_tmp4_ = _type_index;
			_tmp5_ = _type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _type_list;
			_tmp7_ = vala_list_get (_tmp6_, _type_index);
			type = (ValaDataType*) _tmp7_;
			_tmp8_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, visitor);
			_vala_code_node_unref0 (type);
		}
	}
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->accept_children ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), visitor);
	_tmp9_ = vala_class_get_constructor (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValaConstructor* _tmp11_;
		ValaConstructor* _tmp12_;
		_tmp11_ = vala_class_get_constructor (self);
		_tmp12_ = _tmp11_;
		vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
	}
	_tmp13_ = vala_class_get_class_constructor (self);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != NULL) {
		ValaConstructor* _tmp15_;
		ValaConstructor* _tmp16_;
		_tmp15_ = vala_class_get_class_constructor (self);
		_tmp16_ = _tmp15_;
		vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
	}
	_tmp17_ = vala_class_get_static_constructor (self);
	_tmp18_ = _tmp17_;
	if (_tmp18_ != NULL) {
		ValaConstructor* _tmp19_;
		ValaConstructor* _tmp20_;
		_tmp19_ = vala_class_get_static_constructor (self);
		_tmp20_ = _tmp19_;
		vala_code_node_accept ((ValaCodeNode*) _tmp20_, visitor);
	}
	_tmp21_ = vala_class_get_destructor (self);
	_tmp22_ = _tmp21_;
	if (_tmp22_ != NULL) {
		ValaDestructor* _tmp23_;
		ValaDestructor* _tmp24_;
		_tmp23_ = vala_class_get_destructor (self);
		_tmp24_ = _tmp23_;
		vala_code_node_accept ((ValaCodeNode*) _tmp24_, visitor);
	}
	_tmp25_ = vala_class_get_static_destructor (self);
	_tmp26_ = _tmp25_;
	if (_tmp26_ != NULL) {
		ValaDestructor* _tmp27_;
		ValaDestructor* _tmp28_;
		_tmp27_ = vala_class_get_static_destructor (self);
		_tmp28_ = _tmp27_;
		vala_code_node_accept ((ValaCodeNode*) _tmp28_, visitor);
	}
	_tmp29_ = vala_class_get_class_destructor (self);
	_tmp30_ = _tmp29_;
	if (_tmp30_ != NULL) {
		ValaDestructor* _tmp31_;
		ValaDestructor* _tmp32_;
		_tmp31_ = vala_class_get_class_destructor (self);
		_tmp32_ = _tmp31_;
		vala_code_node_accept ((ValaCodeNode*) _tmp32_, visitor);
	}
}

static gboolean
vala_class_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaClass * self;
	gboolean result;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}

gboolean
vala_class_is_fundamental (ValaClass* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_class_get_is_compact (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		ValaClass* _tmp3_;
		_tmp3_ = self->priv->_base_class;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                               ValaTypeSymbol* t)
{
	ValaClass * self;
	gboolean result;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = self->priv->base_types;
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			_base_type_index = _base_type_index + 1;
			_tmp4_ = _base_type_index;
			_tmp5_ = _base_type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _base_type_list;
			_tmp7_ = vala_list_get (_tmp6_, _base_type_index);
			base_type = (ValaDataType*) _tmp7_;
			_tmp10_ = base_type;
			_tmp11_ = vala_data_type_get_type_symbol (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ != NULL) {
				ValaDataType* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				_tmp13_ = base_type;
				_tmp14_ = vala_data_type_get_type_symbol (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp9_ = _tmp15_ != G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				ValaDataType* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				_tmp16_ = base_type;
				_tmp17_ = vala_data_type_get_type_symbol (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp8_ = vala_typesymbol_is_subtype_of (_tmp18_, t);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	result = FALSE;
	return result;
}

static void
vala_class_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->base_types;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->base_types;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->base_types;
					vala_list_set (_tmp9_, i, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static void
vala_class_get_all_prerequisites (ValaClass* self,
                                  ValaInterface* iface,
                                  ValaList* list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp0_;
		gint _prereq_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _prereq_index = 0;
		_tmp0_ = vala_interface_get_prerequisites (iface);
		_prereq_list = _tmp0_;
		_tmp1_ = _prereq_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_prereq_size = _tmp3_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaTypeSymbol* type = NULL;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			_prereq_index = _prereq_index + 1;
			_tmp4_ = _prereq_index;
			_tmp5_ = _prereq_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _prereq_list;
			_tmp7_ = vala_list_get (_tmp6_, _prereq_index);
			prereq = (ValaDataType*) _tmp7_;
			_tmp8_ = prereq;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = _vala_code_node_ref0 (_tmp10_);
			type = _tmp11_;
			_tmp12_ = type;
			if (_tmp12_ == NULL) {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp13_ = type;
			vala_collection_add ((ValaCollection*) list, _tmp13_);
			_tmp14_ = type;
			if (VALA_IS_INTERFACE (_tmp14_)) {
				ValaTypeSymbol* _tmp15_;
				_tmp15_ = type;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_INTERFACE, ValaInterface), list);
			}
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (prereq);
		}
	}
}

gboolean
vala_class_is_a (ValaClass* self,
                 ValaObjectTypeSymbol* t)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_base_type_index = _base_type_index + 1;
			_tmp4_ = _base_type_index;
			_tmp5_ = _base_type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _base_type_list;
			_tmp7_ = vala_list_get (_tmp6_, _base_type_index);
			base_type = (ValaDataType*) _tmp7_;
			_tmp8_ = base_type;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			if (VALA_IS_CLASS (_tmp10_)) {
				ValaDataType* _tmp11_;
				ValaTypeSymbol* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				_tmp11_ = base_type;
				_tmp12_ = vala_data_type_get_type_symbol (_tmp11_);
				_tmp13_ = _tmp12_;
				if (vala_class_is_a (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_CLASS, ValaClass), t)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					return result;
				}
			} else {
				ValaDataType* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				_tmp14_ = base_type;
				_tmp15_ = vala_data_type_get_type_symbol (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_ == G_TYPE_CHECK_INSTANCE_CAST (t, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	result = FALSE;
	return result;
}

gboolean
vala_class_implements (ValaClass* self,
                       ValaInterface* i)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (i != NULL, FALSE);
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_base_type_index = _base_type_index + 1;
			_tmp4_ = _base_type_index;
			_tmp5_ = _base_type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _base_type_list;
			_tmp7_ = vala_list_get (_tmp6_, _base_type_index);
			base_type = (ValaDataType*) _tmp7_;
			_tmp8_ = base_type;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ == G_TYPE_CHECK_INSTANCE_CAST (i, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	result = FALSE;
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_class_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaClass * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	gboolean _tmp71_ = FALSE;
	ValaClass* _tmp72_;
	gboolean _tmp83_ = FALSE;
	gboolean _tmp84_;
	gboolean _tmp85_;
	gboolean _tmp93_ = FALSE;
	gboolean _tmp94_;
	gboolean _tmp95_;
	gboolean _tmp107_ = FALSE;
	gboolean _tmp108_ = FALSE;
	gboolean _tmp109_;
	gboolean _tmp110_;
	gboolean _tmp121_;
	gboolean _tmp133_ = FALSE;
	gboolean _tmp134_ = FALSE;
	ValaClass* _tmp135_;
	ValaConstructor* _tmp248_;
	ValaConstructor* _tmp249_;
	ValaConstructor* _tmp252_;
	ValaConstructor* _tmp253_;
	ValaConstructor* _tmp256_;
	ValaConstructor* _tmp257_;
	ValaDestructor* _tmp260_;
	ValaDestructor* _tmp261_;
	ValaDestructor* _tmp264_;
	ValaDestructor* _tmp265_;
	ValaDestructor* _tmp268_;
	ValaDestructor* _tmp269_;
	gboolean _tmp308_;
	gboolean _tmp309_;
	ValaList* prerequisites = NULL;
	GEqualFunc _tmp350_;
	ValaArrayList* _tmp351_;
	ValaList* missing_prereqs = NULL;
	GEqualFunc _tmp367_;
	ValaArrayList* _tmp368_;
	ValaList* _tmp382_;
	gint _tmp383_;
	gint _tmp384_;
	ValaSourceFileType _tmp408_;
	ValaSourceFileType _tmp409_;
	ValaSemanticAnalyzer* _tmp626_;
	ValaSemanticAnalyzer* _tmp627_;
	ValaSourceFile* _tmp628_;
	ValaSemanticAnalyzer* _tmp629_;
	ValaSemanticAnalyzer* _tmp630_;
	ValaSymbol* _tmp631_;
	gboolean _tmp632_;
	gboolean _tmp633_;
	gboolean result;
	self = (ValaClass*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	if (!VALA_CODE_NODE_CLASS (vala_class_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), context)) {
		result = FALSE;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _base_type_reference_list = NULL;
		ValaList* _tmp24_;
		gint _base_type_reference_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _base_type_reference_index = 0;
		_tmp24_ = vala_class_get_base_types (self);
		_base_type_reference_list = _tmp24_;
		_tmp25_ = _base_type_reference_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_base_type_reference_size = _tmp27_;
		_base_type_reference_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			ValaDataType* base_type_reference = NULL;
			ValaList* _tmp30_;
			gpointer _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			ValaDataType* _tmp41_;
			ValaDataType* _tmp49_;
			_base_type_reference_index = _base_type_reference_index + 1;
			_tmp28_ = _base_type_reference_index;
			_tmp29_ = _base_type_reference_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _base_type_reference_list;
			_tmp31_ = vala_list_get (_tmp30_, _base_type_reference_index);
			base_type_reference = (ValaDataType*) _tmp31_;
			_tmp32_ = base_type_reference;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp32_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp33_ = base_type_reference;
			if (!VALA_IS_OBJECT_TYPE (_tmp33_)) {
				ValaSourceReference* _tmp34_;
				ValaSourceReference* _tmp35_;
				ValaDataType* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp35_ = _tmp34_;
				_tmp36_ = base_type_reference;
				_tmp37_ = vala_code_node_to_string ((ValaCodeNode*) _tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp40_ = _tmp39_;
				vala_report_error (_tmp35_, "base type `%s' of class `%s' is not an object type", _tmp38_, _tmp40_);
				_g_free0 (_tmp40_);
				_g_free0 (_tmp38_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp41_ = base_type_reference;
			if (!vala_data_type_is_accessible (_tmp41_, (ValaSymbol*) self)) {
				ValaSourceReference* _tmp42_;
				ValaSourceReference* _tmp43_;
				ValaDataType* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp43_ = _tmp42_;
				_tmp44_ = base_type_reference;
				_tmp45_ = vala_code_node_to_string ((ValaCodeNode*) _tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp48_ = _tmp47_;
				vala_report_error (_tmp43_, "base type `%s' is less accessible than class `%s'", _tmp46_, _tmp48_);
				_g_free0 (_tmp48_);
				_g_free0 (_tmp46_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp49_ = base_type_reference;
			if (!vala_data_type_check_type_arguments (_tmp49_, context, FALSE)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (base_type_reference);
		}
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp50_;
		gint _type_size = 0;
		ValaList* _tmp51_;
		gint _tmp52_;
		gint _tmp53_;
		gint _type_index = 0;
		_tmp50_ = self->priv->base_types;
		_type_list = _tmp50_;
		_tmp51_ = _type_list;
		_tmp52_ = vala_collection_get_size ((ValaCollection*) _tmp51_);
		_tmp53_ = _tmp52_;
		_type_size = _tmp53_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp54_;
			gint _tmp55_;
			ValaDataType* type = NULL;
			ValaList* _tmp56_;
			gpointer _tmp57_;
			ValaDataType* _tmp58_;
			ValaSemanticAnalyzer* _tmp59_;
			ValaSemanticAnalyzer* _tmp60_;
			ValaDataType* _tmp61_;
			_type_index = _type_index + 1;
			_tmp54_ = _type_index;
			_tmp55_ = _type_size;
			if (!(_tmp54_ < _tmp55_)) {
				break;
			}
			_tmp56_ = _type_list;
			_tmp57_ = vala_list_get (_tmp56_, _type_index);
			type = (ValaDataType*) _tmp57_;
			_tmp58_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp58_, context);
			_tmp59_ = vala_code_context_get_analyzer (context);
			_tmp60_ = _tmp59_;
			_tmp61_ = type;
			vala_semantic_analyzer_check_type (_tmp60_, _tmp61_);
			_vala_code_node_unref0 (type);
		}
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp62_;
		gint _p_size = 0;
		ValaList* _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		gint _p_index = 0;
		_tmp62_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp62_;
		_tmp63_ = _p_list;
		_tmp64_ = vala_collection_get_size ((ValaCollection*) _tmp63_);
		_tmp65_ = _tmp64_;
		_p_size = _tmp65_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp66_;
			gint _tmp67_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp68_;
			gpointer _tmp69_;
			ValaTypeParameter* _tmp70_;
			_p_index = _p_index + 1;
			_tmp66_ = _p_index;
			_tmp67_ = _p_size;
			if (!(_tmp66_ < _tmp67_)) {
				break;
			}
			_tmp68_ = _p_list;
			_tmp69_ = vala_list_get (_tmp68_, _p_index);
			p = (ValaTypeParameter*) _tmp69_;
			_tmp70_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp70_, context);
			_vala_code_node_unref0 (p);
		}
	}
	_tmp72_ = self->priv->_base_class;
	if (_tmp72_ != NULL) {
		ValaClass* _tmp73_;
		gboolean _tmp74_;
		gboolean _tmp75_;
		_tmp73_ = self->priv->_base_class;
		_tmp74_ = vala_class_get_is_singleton (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp71_ = _tmp75_;
	} else {
		_tmp71_ = FALSE;
	}
	if (_tmp71_) {
		ValaSourceReference* _tmp76_;
		ValaSourceReference* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		ValaClass* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp77_ = _tmp76_;
		_tmp78_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp79_ = _tmp78_;
		_tmp80_ = self->priv->_base_class;
		_tmp81_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp80_);
		_tmp82_ = _tmp81_;
		vala_report_error (_tmp77_, "`%s' cannot inherit from SingleInstance class `%s'", _tmp79_, _tmp82_);
		_g_free0 (_tmp82_);
		_g_free0 (_tmp79_);
	}
	_tmp84_ = vala_class_get_is_singleton (self);
	_tmp85_ = _tmp84_;
	if (_tmp85_) {
		ValaSemanticAnalyzer* _tmp86_;
		ValaSemanticAnalyzer* _tmp87_;
		ValaClass* _tmp88_;
		_tmp86_ = vala_code_context_get_analyzer (context);
		_tmp87_ = _tmp86_;
		_tmp88_ = _tmp87_->object_type;
		_tmp83_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp88_);
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaSourceReference* _tmp89_;
		ValaSourceReference* _tmp90_;
		gchar* _tmp91_;
		gchar* _tmp92_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp92_ = _tmp91_;
		vala_report_error (_tmp90_, "SingleInstance class `%s' requires inheritance from `GLib.Object'", _tmp92_);
		_g_free0 (_tmp92_);
	}
	_tmp94_ = vala_class_get_is_singleton (self);
	_tmp95_ = _tmp94_;
	if (_tmp95_) {
		ValaConstructor* _tmp96_;
		ValaConstructor* _tmp97_;
		_tmp96_ = vala_class_get_constructor (self);
		_tmp97_ = _tmp96_;
		_tmp93_ = _tmp97_ == NULL;
	} else {
		_tmp93_ = FALSE;
	}
	if (_tmp93_) {
		ValaConstructor* c = NULL;
		ValaSourceReference* _tmp98_;
		ValaSourceReference* _tmp99_;
		ValaConstructor* _tmp100_;
		ValaConstructor* _tmp101_;
		ValaSourceReference* _tmp102_;
		ValaSourceReference* _tmp103_;
		ValaBlock* _tmp104_;
		ValaBlock* _tmp105_;
		ValaConstructor* _tmp106_;
		_tmp98_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp99_ = _tmp98_;
		_tmp100_ = vala_constructor_new (_tmp99_);
		c = _tmp100_;
		_tmp101_ = c;
		_tmp102_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp103_ = _tmp102_;
		_tmp104_ = vala_block_new (_tmp103_);
		_tmp105_ = _tmp104_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp101_, _tmp105_);
		_vala_code_node_unref0 (_tmp105_);
		_tmp106_ = c;
		vala_symbol_add_constructor ((ValaSymbol*) self, _tmp106_);
		_vala_code_node_unref0 (c);
	}
	_tmp109_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp110_ = _tmp109_;
	if (!_tmp110_) {
		ValaClass* _tmp111_;
		_tmp111_ = self->priv->_base_class;
		_tmp108_ = _tmp111_ != NULL;
	} else {
		_tmp108_ = FALSE;
	}
	if (_tmp108_) {
		ValaClass* _tmp112_;
		gboolean _tmp113_;
		_tmp112_ = self->priv->_base_class;
		_tmp113_ = _tmp112_->priv->_is_sealed;
		_tmp107_ = _tmp113_;
	} else {
		_tmp107_ = FALSE;
	}
	if (_tmp107_) {
		ValaSourceReference* _tmp114_;
		ValaSourceReference* _tmp115_;
		gchar* _tmp116_;
		gchar* _tmp117_;
		ValaClass* _tmp118_;
		gchar* _tmp119_;
		gchar* _tmp120_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp114_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp115_ = _tmp114_;
		_tmp116_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp117_ = _tmp116_;
		_tmp118_ = self->priv->_base_class;
		_tmp119_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp118_);
		_tmp120_ = _tmp119_;
		vala_report_error (_tmp115_, "`%s' cannot inherit from sealed class `%s'", _tmp117_, _tmp120_);
		_g_free0 (_tmp120_);
		_g_free0 (_tmp117_);
	}
	_tmp121_ = self->priv->_is_sealed;
	if (_tmp121_) {
		gboolean _tmp122_;
		gboolean _tmp123_;
		gboolean _tmp128_;
		_tmp122_ = vala_class_get_is_compact (self);
		_tmp123_ = _tmp122_;
		if (_tmp123_) {
			ValaSourceReference* _tmp124_;
			ValaSourceReference* _tmp125_;
			gchar* _tmp126_;
			gchar* _tmp127_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp125_ = _tmp124_;
			_tmp126_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp127_ = _tmp126_;
			vala_report_error (_tmp125_, "Sealed class `%s' cannot be compact", _tmp127_);
			_g_free0 (_tmp127_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp128_ = self->priv->_is_abstract;
		if (_tmp128_) {
			ValaSourceReference* _tmp129_;
			ValaSourceReference* _tmp130_;
			gchar* _tmp131_;
			gchar* _tmp132_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp129_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp130_ = _tmp129_;
			_tmp131_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp132_ = _tmp131_;
			vala_report_error (_tmp130_, "Sealed class `%s' cannot be abstract", _tmp132_);
			_g_free0 (_tmp132_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	}
	_tmp135_ = self->priv->_base_class;
	if (_tmp135_ != NULL) {
		ValaClass* _tmp136_;
		gboolean _tmp137_;
		gboolean _tmp138_;
		_tmp136_ = self->priv->_base_class;
		_tmp137_ = vala_class_get_is_compact (_tmp136_);
		_tmp138_ = _tmp137_;
		_tmp134_ = !_tmp138_;
	} else {
		_tmp134_ = FALSE;
	}
	if (_tmp134_) {
		_tmp133_ = vala_code_node_has_attribute ((ValaCodeNode*) self, "Compact");
	} else {
		_tmp133_ = FALSE;
	}
	if (_tmp133_) {
		ValaSourceReference* _tmp139_;
		ValaSourceReference* _tmp140_;
		gchar* _tmp141_;
		gchar* _tmp142_;
		ValaClass* _tmp143_;
		gchar* _tmp144_;
		gchar* _tmp145_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp139_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp140_ = _tmp139_;
		_tmp141_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp142_ = _tmp141_;
		_tmp143_ = self->priv->_base_class;
		_tmp144_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp143_);
		_tmp145_ = _tmp144_;
		vala_report_error (_tmp140_, "Compact class `%s' cannot inherit from non-compact class `%s'", _tmp142_, _tmp145_);
		_g_free0 (_tmp145_);
		_g_free0 (_tmp142_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp146_;
		gint _en_size = 0;
		ValaList* _tmp147_;
		gint _tmp148_;
		gint _tmp149_;
		gint _en_index = 0;
		_tmp146_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp146_;
		_tmp147_ = _en_list;
		_tmp148_ = vala_collection_get_size ((ValaCollection*) _tmp147_);
		_tmp149_ = _tmp148_;
		_en_size = _tmp149_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp150_;
			gint _tmp151_;
			ValaEnum* en = NULL;
			ValaList* _tmp152_;
			gpointer _tmp153_;
			ValaEnum* _tmp154_;
			_en_index = _en_index + 1;
			_tmp150_ = _en_index;
			_tmp151_ = _en_size;
			if (!(_tmp150_ < _tmp151_)) {
				break;
			}
			_tmp152_ = _en_list;
			_tmp153_ = vala_list_get (_tmp152_, _en_index);
			en = (ValaEnum*) _tmp153_;
			_tmp154_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp154_, context);
			_vala_code_node_unref0 (en);
		}
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp155_;
		gint _f_size = 0;
		ValaList* _tmp156_;
		gint _tmp157_;
		gint _tmp158_;
		gint _f_index = 0;
		_tmp155_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp155_;
		_tmp156_ = _f_list;
		_tmp157_ = vala_collection_get_size ((ValaCollection*) _tmp156_);
		_tmp158_ = _tmp157_;
		_f_size = _tmp158_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp159_;
			gint _tmp160_;
			ValaField* f = NULL;
			ValaList* _tmp161_;
			gpointer _tmp162_;
			gboolean _tmp163_ = FALSE;
			gboolean _tmp164_;
			gboolean _tmp165_;
			ValaField* _tmp203_;
			_f_index = _f_index + 1;
			_tmp159_ = _f_index;
			_tmp160_ = _f_size;
			if (!(_tmp159_ < _tmp160_)) {
				break;
			}
			_tmp161_ = _f_list;
			_tmp162_ = vala_list_get (_tmp161_, _f_index);
			f = (ValaField*) _tmp162_;
			_tmp164_ = vala_class_get_is_compact (self);
			_tmp165_ = _tmp164_;
			if (_tmp165_) {
				ValaField* _tmp166_;
				ValaMemberBinding _tmp167_;
				ValaMemberBinding _tmp168_;
				_tmp166_ = f;
				_tmp167_ = vala_field_get_binding (_tmp166_);
				_tmp168_ = _tmp167_;
				_tmp163_ = _tmp168_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp163_ = FALSE;
			}
			if (_tmp163_) {
				gboolean _tmp169_ = FALSE;
				gboolean _tmp170_ = FALSE;
				gboolean _tmp171_;
				gboolean _tmp172_;
				gboolean _tmp181_ = FALSE;
				gboolean _tmp182_ = FALSE;
				gboolean _tmp183_;
				gboolean _tmp184_;
				ValaField* _tmp197_;
				ValaMemberBinding _tmp198_;
				ValaMemberBinding _tmp199_;
				_tmp171_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp172_ = _tmp171_;
				if (!_tmp172_) {
					gboolean _tmp173_;
					gboolean _tmp174_;
					_tmp173_ = vala_class_get_is_opaque (self);
					_tmp174_ = _tmp173_;
					_tmp170_ = !_tmp174_;
				} else {
					_tmp170_ = FALSE;
				}
				if (_tmp170_) {
					ValaField* _tmp175_;
					ValaSymbolAccessibility _tmp176_;
					ValaSymbolAccessibility _tmp177_;
					_tmp175_ = f;
					_tmp176_ = vala_symbol_get_access ((ValaSymbol*) _tmp175_);
					_tmp177_ = _tmp176_;
					_tmp169_ = _tmp177_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp169_ = FALSE;
				}
				if (_tmp169_) {
					ValaField* _tmp178_;
					ValaSourceReference* _tmp179_;
					ValaSourceReference* _tmp180_;
					_tmp178_ = f;
					_tmp179_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp178_);
					_tmp180_ = _tmp179_;
					vala_report_error (_tmp180_, "private fields are only supported in opaque compact classes, use [Comp" \
"act (opaque = true)]");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp183_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp184_ = _tmp183_;
				if (!_tmp184_) {
					gboolean _tmp185_;
					gboolean _tmp186_;
					_tmp185_ = vala_class_get_is_opaque (self);
					_tmp186_ = _tmp185_;
					_tmp182_ = _tmp186_;
				} else {
					_tmp182_ = FALSE;
				}
				if (_tmp182_) {
					gboolean _tmp187_ = FALSE;
					ValaField* _tmp188_;
					ValaSymbolAccessibility _tmp189_;
					ValaSymbolAccessibility _tmp190_;
					_tmp188_ = f;
					_tmp189_ = vala_symbol_get_access ((ValaSymbol*) _tmp188_);
					_tmp190_ = _tmp189_;
					if (_tmp190_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
						_tmp187_ = TRUE;
					} else {
						ValaField* _tmp191_;
						ValaSymbolAccessibility _tmp192_;
						ValaSymbolAccessibility _tmp193_;
						_tmp191_ = f;
						_tmp192_ = vala_symbol_get_access ((ValaSymbol*) _tmp191_);
						_tmp193_ = _tmp192_;
						_tmp187_ = _tmp193_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
					}
					_tmp181_ = _tmp187_;
				} else {
					_tmp181_ = FALSE;
				}
				if (_tmp181_) {
					ValaField* _tmp194_;
					ValaSourceReference* _tmp195_;
					ValaSourceReference* _tmp196_;
					_tmp194_ = f;
					_tmp195_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp194_);
					_tmp196_ = _tmp195_;
					vala_report_error (_tmp196_, "fields in opaque compact classes must be private or internal");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp197_ = f;
				_tmp198_ = vala_field_get_binding (_tmp197_);
				_tmp199_ = _tmp198_;
				if (_tmp199_ == VALA_MEMBER_BINDING_CLASS) {
					ValaField* _tmp200_;
					ValaSourceReference* _tmp201_;
					ValaSourceReference* _tmp202_;
					_tmp200_ = f;
					_tmp201_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp200_);
					_tmp202_ = _tmp201_;
					vala_report_error (_tmp202_, "class fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
			_tmp203_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp203_, context);
			_vala_code_node_unref0 (f);
		}
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp204_;
		gint _c_size = 0;
		ValaList* _tmp205_;
		gint _tmp206_;
		gint _tmp207_;
		gint _c_index = 0;
		_tmp204_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp204_;
		_tmp205_ = _c_list;
		_tmp206_ = vala_collection_get_size ((ValaCollection*) _tmp205_);
		_tmp207_ = _tmp206_;
		_c_size = _tmp207_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp208_;
			gint _tmp209_;
			ValaConstant* c = NULL;
			ValaList* _tmp210_;
			gpointer _tmp211_;
			ValaConstant* _tmp212_;
			_c_index = _c_index + 1;
			_tmp208_ = _c_index;
			_tmp209_ = _c_size;
			if (!(_tmp208_ < _tmp209_)) {
				break;
			}
			_tmp210_ = _c_list;
			_tmp211_ = vala_list_get (_tmp210_, _c_index);
			c = (ValaConstant*) _tmp211_;
			_tmp212_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp212_, context);
			_vala_code_node_unref0 (c);
		}
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp213_;
		gint _m_size = 0;
		ValaList* _tmp214_;
		gint _tmp215_;
		gint _tmp216_;
		gint _m_index = 0;
		_tmp213_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp213_;
		_tmp214_ = _m_list;
		_tmp215_ = vala_collection_get_size ((ValaCollection*) _tmp214_);
		_tmp216_ = _tmp215_;
		_m_size = _tmp216_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp217_;
			gint _tmp218_;
			ValaMethod* m = NULL;
			ValaList* _tmp219_;
			gpointer _tmp220_;
			ValaMethod* _tmp221_;
			_m_index = _m_index + 1;
			_tmp217_ = _m_index;
			_tmp218_ = _m_size;
			if (!(_tmp217_ < _tmp218_)) {
				break;
			}
			_tmp219_ = _m_list;
			_tmp220_ = vala_list_get (_tmp219_, _m_index);
			m = (ValaMethod*) _tmp220_;
			_tmp221_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp221_, context);
			_vala_code_node_unref0 (m);
		}
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp222_;
		gint _prop_size = 0;
		ValaList* _tmp223_;
		gint _tmp224_;
		gint _tmp225_;
		gint _prop_index = 0;
		_tmp222_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp222_;
		_tmp223_ = _prop_list;
		_tmp224_ = vala_collection_get_size ((ValaCollection*) _tmp223_);
		_tmp225_ = _tmp224_;
		_prop_size = _tmp225_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp226_;
			gint _tmp227_;
			ValaProperty* prop = NULL;
			ValaList* _tmp228_;
			gpointer _tmp229_;
			gboolean _tmp230_ = FALSE;
			ValaProperty* _tmp231_;
			ValaProperty* _tmp238_;
			_prop_index = _prop_index + 1;
			_tmp226_ = _prop_index;
			_tmp227_ = _prop_size;
			if (!(_tmp226_ < _tmp227_)) {
				break;
			}
			_tmp228_ = _prop_list;
			_tmp229_ = vala_list_get (_tmp228_, _prop_index);
			prop = (ValaProperty*) _tmp229_;
			_tmp231_ = prop;
			if (vala_code_node_has_attribute ((ValaCodeNode*) _tmp231_, "NoAccessorMethod")) {
				ValaSemanticAnalyzer* _tmp232_;
				ValaSemanticAnalyzer* _tmp233_;
				ValaClass* _tmp234_;
				_tmp232_ = vala_code_context_get_analyzer (context);
				_tmp233_ = _tmp232_;
				_tmp234_ = _tmp233_->object_type;
				_tmp230_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp234_);
			} else {
				_tmp230_ = FALSE;
			}
			if (_tmp230_) {
				ValaProperty* _tmp235_;
				ValaSourceReference* _tmp236_;
				ValaSourceReference* _tmp237_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp235_ = prop;
				_tmp236_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp235_);
				_tmp237_ = _tmp236_;
				vala_report_error (_tmp237_, "NoAccessorMethod is only allowed for properties in classes derived fro" \
"m GLib.Object");
				result = FALSE;
				_vala_code_node_unref0 (prop);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp238_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp238_, context);
			_vala_code_node_unref0 (prop);
		}
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp239_;
		gint _sig_size = 0;
		ValaList* _tmp240_;
		gint _tmp241_;
		gint _tmp242_;
		gint _sig_index = 0;
		_tmp239_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp239_;
		_tmp240_ = _sig_list;
		_tmp241_ = vala_collection_get_size ((ValaCollection*) _tmp240_);
		_tmp242_ = _tmp241_;
		_sig_size = _tmp242_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp243_;
			gint _tmp244_;
			ValaSignal* sig = NULL;
			ValaList* _tmp245_;
			gpointer _tmp246_;
			ValaSignal* _tmp247_;
			_sig_index = _sig_index + 1;
			_tmp243_ = _sig_index;
			_tmp244_ = _sig_size;
			if (!(_tmp243_ < _tmp244_)) {
				break;
			}
			_tmp245_ = _sig_list;
			_tmp246_ = vala_list_get (_tmp245_, _sig_index);
			sig = (ValaSignal*) _tmp246_;
			_tmp247_ = sig;
			vala_code_node_check ((ValaCodeNode*) _tmp247_, context);
			_vala_code_node_unref0 (sig);
		}
	}
	_tmp248_ = vala_class_get_constructor (self);
	_tmp249_ = _tmp248_;
	if (_tmp249_ != NULL) {
		ValaConstructor* _tmp250_;
		ValaConstructor* _tmp251_;
		_tmp250_ = vala_class_get_constructor (self);
		_tmp251_ = _tmp250_;
		vala_code_node_check ((ValaCodeNode*) _tmp251_, context);
	}
	_tmp252_ = vala_class_get_class_constructor (self);
	_tmp253_ = _tmp252_;
	if (_tmp253_ != NULL) {
		ValaConstructor* _tmp254_;
		ValaConstructor* _tmp255_;
		_tmp254_ = vala_class_get_class_constructor (self);
		_tmp255_ = _tmp254_;
		vala_code_node_check ((ValaCodeNode*) _tmp255_, context);
	}
	_tmp256_ = vala_class_get_static_constructor (self);
	_tmp257_ = _tmp256_;
	if (_tmp257_ != NULL) {
		ValaConstructor* _tmp258_;
		ValaConstructor* _tmp259_;
		_tmp258_ = vala_class_get_static_constructor (self);
		_tmp259_ = _tmp258_;
		vala_code_node_check ((ValaCodeNode*) _tmp259_, context);
	}
	_tmp260_ = vala_class_get_destructor (self);
	_tmp261_ = _tmp260_;
	if (_tmp261_ != NULL) {
		ValaDestructor* _tmp262_;
		ValaDestructor* _tmp263_;
		_tmp262_ = vala_class_get_destructor (self);
		_tmp263_ = _tmp262_;
		vala_code_node_check ((ValaCodeNode*) _tmp263_, context);
	}
	_tmp264_ = vala_class_get_static_destructor (self);
	_tmp265_ = _tmp264_;
	if (_tmp265_ != NULL) {
		ValaDestructor* _tmp266_;
		ValaDestructor* _tmp267_;
		_tmp266_ = vala_class_get_static_destructor (self);
		_tmp267_ = _tmp266_;
		vala_code_node_check ((ValaCodeNode*) _tmp267_, context);
	}
	_tmp268_ = vala_class_get_class_destructor (self);
	_tmp269_ = _tmp268_;
	if (_tmp269_ != NULL) {
		ValaDestructor* _tmp270_;
		ValaDestructor* _tmp271_;
		_tmp270_ = vala_class_get_class_destructor (self);
		_tmp271_ = _tmp270_;
		vala_code_node_check ((ValaCodeNode*) _tmp271_, context);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp272_;
		gint _cl_size = 0;
		ValaList* _tmp273_;
		gint _tmp274_;
		gint _tmp275_;
		gint _cl_index = 0;
		_tmp272_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp272_;
		_tmp273_ = _cl_list;
		_tmp274_ = vala_collection_get_size ((ValaCollection*) _tmp273_);
		_tmp275_ = _tmp274_;
		_cl_size = _tmp275_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp276_;
			gint _tmp277_;
			ValaClass* cl = NULL;
			ValaList* _tmp278_;
			gpointer _tmp279_;
			ValaClass* _tmp280_;
			_cl_index = _cl_index + 1;
			_tmp276_ = _cl_index;
			_tmp277_ = _cl_size;
			if (!(_tmp276_ < _tmp277_)) {
				break;
			}
			_tmp278_ = _cl_list;
			_tmp279_ = vala_list_get (_tmp278_, _cl_index);
			cl = (ValaClass*) _tmp279_;
			_tmp280_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp280_, context);
			_vala_code_node_unref0 (cl);
		}
	}
	{
		ValaList* _iface_list = NULL;
		ValaList* _tmp281_;
		gint _iface_size = 0;
		ValaList* _tmp282_;
		gint _tmp283_;
		gint _tmp284_;
		gint _iface_index = 0;
		_tmp281_ = vala_object_type_symbol_get_interfaces ((ValaObjectTypeSymbol*) self);
		_iface_list = _tmp281_;
		_tmp282_ = _iface_list;
		_tmp283_ = vala_collection_get_size ((ValaCollection*) _tmp282_);
		_tmp284_ = _tmp283_;
		_iface_size = _tmp284_;
		_iface_index = -1;
		while (TRUE) {
			gint _tmp285_;
			gint _tmp286_;
			ValaInterface* iface = NULL;
			ValaList* _tmp287_;
			gpointer _tmp288_;
			ValaInterface* _tmp289_;
			_iface_index = _iface_index + 1;
			_tmp285_ = _iface_index;
			_tmp286_ = _iface_size;
			if (!(_tmp285_ < _tmp286_)) {
				break;
			}
			_tmp287_ = _iface_list;
			_tmp288_ = vala_list_get (_tmp287_, _iface_index);
			iface = (ValaInterface*) _tmp288_;
			_tmp289_ = iface;
			vala_code_node_check ((ValaCodeNode*) _tmp289_, context);
			_vala_code_node_unref0 (iface);
		}
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp290_;
		gint _st_size = 0;
		ValaList* _tmp291_;
		gint _tmp292_;
		gint _tmp293_;
		gint _st_index = 0;
		_tmp290_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp290_;
		_tmp291_ = _st_list;
		_tmp292_ = vala_collection_get_size ((ValaCollection*) _tmp291_);
		_tmp293_ = _tmp292_;
		_st_size = _tmp293_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp294_;
			gint _tmp295_;
			ValaStruct* st = NULL;
			ValaList* _tmp296_;
			gpointer _tmp297_;
			ValaStruct* _tmp298_;
			_st_index = _st_index + 1;
			_tmp294_ = _st_index;
			_tmp295_ = _st_size;
			if (!(_tmp294_ < _tmp295_)) {
				break;
			}
			_tmp296_ = _st_list;
			_tmp297_ = vala_list_get (_tmp296_, _st_index);
			st = (ValaStruct*) _tmp297_;
			_tmp298_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp298_, context);
			_vala_code_node_unref0 (st);
		}
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp299_;
		gint _d_size = 0;
		ValaList* _tmp300_;
		gint _tmp301_;
		gint _tmp302_;
		gint _d_index = 0;
		_tmp299_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp299_;
		_tmp300_ = _d_list;
		_tmp301_ = vala_collection_get_size ((ValaCollection*) _tmp300_);
		_tmp302_ = _tmp301_;
		_d_size = _tmp302_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp303_;
			gint _tmp304_;
			ValaDelegate* d = NULL;
			ValaList* _tmp305_;
			gpointer _tmp306_;
			ValaDelegate* _tmp307_;
			_d_index = _d_index + 1;
			_tmp303_ = _d_index;
			_tmp304_ = _d_size;
			if (!(_tmp303_ < _tmp304_)) {
				break;
			}
			_tmp305_ = _d_list;
			_tmp306_ = vala_list_get (_tmp305_, _d_index);
			d = (ValaDelegate*) _tmp306_;
			_tmp307_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp307_, context);
			_vala_code_node_unref0 (d);
		}
	}
	_tmp308_ = vala_class_get_is_compact (self);
	_tmp309_ = _tmp308_;
	if (_tmp309_) {
		gboolean _tmp325_ = FALSE;
		gboolean _tmp326_ = FALSE;
		gboolean _tmp327_ = FALSE;
		gboolean _tmp328_;
		gboolean _tmp329_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp310_;
			gint _base_type_size = 0;
			ValaList* _tmp311_;
			gint _tmp312_;
			gint _tmp313_;
			gint _base_type_index = 0;
			_tmp310_ = vala_class_get_base_types (self);
			_base_type_list = _tmp310_;
			_tmp311_ = _base_type_list;
			_tmp312_ = vala_collection_get_size ((ValaCollection*) _tmp311_);
			_tmp313_ = _tmp312_;
			_base_type_size = _tmp313_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp314_;
				gint _tmp315_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp316_;
				gpointer _tmp317_;
				ValaDataType* _tmp318_;
				ValaTypeSymbol* _tmp319_;
				ValaTypeSymbol* _tmp320_;
				_base_type_index = _base_type_index + 1;
				_tmp314_ = _base_type_index;
				_tmp315_ = _base_type_size;
				if (!(_tmp314_ < _tmp315_)) {
					break;
				}
				_tmp316_ = _base_type_list;
				_tmp317_ = vala_list_get (_tmp316_, _base_type_index);
				base_type = (ValaDataType*) _tmp317_;
				_tmp318_ = base_type;
				_tmp319_ = vala_data_type_get_type_symbol (_tmp318_);
				_tmp320_ = _tmp319_;
				if (VALA_IS_INTERFACE (_tmp320_)) {
					ValaSourceReference* _tmp321_;
					ValaSourceReference* _tmp322_;
					gchar* _tmp323_;
					gchar* _tmp324_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp321_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp322_ = _tmp321_;
					_tmp323_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp324_ = _tmp323_;
					vala_report_error (_tmp322_, "compact classes `%s' may not implement interfaces", _tmp324_);
					_g_free0 (_tmp324_);
				}
				_vala_code_node_unref0 (base_type);
			}
		}
		_tmp328_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp329_ = _tmp328_;
		if (!_tmp329_) {
			gboolean _tmp330_;
			gboolean _tmp331_;
			_tmp330_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp331_ = _tmp330_;
			_tmp327_ = !_tmp331_;
		} else {
			_tmp327_ = FALSE;
		}
		if (_tmp327_) {
			ValaClass* _tmp332_;
			_tmp332_ = self->priv->_base_class;
			_tmp326_ = _tmp332_ != NULL;
		} else {
			_tmp326_ = FALSE;
		}
		if (_tmp326_) {
			ValaClass* _tmp333_;
			ValaSemanticAnalyzer* _tmp334_;
			ValaSemanticAnalyzer* _tmp335_;
			ValaClass* _tmp336_;
			_tmp333_ = self->priv->_base_class;
			_tmp334_ = vala_code_context_get_analyzer (context);
			_tmp335_ = _tmp334_;
			_tmp336_ = _tmp335_->gsource_type;
			_tmp325_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp333_, (ValaTypeSymbol*) _tmp336_);
		} else {
			_tmp325_ = FALSE;
		}
		if (_tmp325_) {
			{
				ValaList* _f_list = NULL;
				ValaList* _tmp337_;
				gint _f_size = 0;
				ValaList* _tmp338_;
				gint _tmp339_;
				gint _tmp340_;
				gint _f_index = 0;
				_tmp337_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
				_f_list = _tmp337_;
				_tmp338_ = _f_list;
				_tmp339_ = vala_collection_get_size ((ValaCollection*) _tmp338_);
				_tmp340_ = _tmp339_;
				_f_size = _tmp340_;
				_f_index = -1;
				while (TRUE) {
					gint _tmp341_;
					gint _tmp342_;
					ValaField* f = NULL;
					ValaList* _tmp343_;
					gpointer _tmp344_;
					ValaField* _tmp345_;
					ValaMemberBinding _tmp346_;
					ValaMemberBinding _tmp347_;
					_f_index = _f_index + 1;
					_tmp341_ = _f_index;
					_tmp342_ = _f_size;
					if (!(_tmp341_ < _tmp342_)) {
						break;
					}
					_tmp343_ = _f_list;
					_tmp344_ = vala_list_get (_tmp343_, _f_index);
					f = (ValaField*) _tmp344_;
					_tmp345_ = f;
					_tmp346_ = vala_field_get_binding (_tmp345_);
					_tmp347_ = _tmp346_;
					if (_tmp347_ == VALA_MEMBER_BINDING_INSTANCE) {
						ValaSourceReference* _tmp348_;
						ValaSourceReference* _tmp349_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp348_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp349_ = _tmp348_;
						vala_report_error (_tmp349_, "derived compact classes may not have instance fields");
						_vala_code_node_unref0 (f);
						break;
					}
					_vala_code_node_unref0 (f);
				}
			}
		}
	}
	_tmp350_ = g_direct_equal;
	_tmp351_ = vala_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp350_);
	prerequisites = (ValaList*) _tmp351_;
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp352_;
		gint _base_type_size = 0;
		ValaList* _tmp353_;
		gint _tmp354_;
		gint _tmp355_;
		gint _base_type_index = 0;
		_tmp352_ = vala_class_get_base_types (self);
		_base_type_list = _tmp352_;
		_tmp353_ = _base_type_list;
		_tmp354_ = vala_collection_get_size ((ValaCollection*) _tmp353_);
		_tmp355_ = _tmp354_;
		_base_type_size = _tmp355_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp356_;
			gint _tmp357_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp358_;
			gpointer _tmp359_;
			ValaDataType* _tmp360_;
			ValaTypeSymbol* _tmp361_;
			ValaTypeSymbol* _tmp362_;
			_base_type_index = _base_type_index + 1;
			_tmp356_ = _base_type_index;
			_tmp357_ = _base_type_size;
			if (!(_tmp356_ < _tmp357_)) {
				break;
			}
			_tmp358_ = _base_type_list;
			_tmp359_ = vala_list_get (_tmp358_, _base_type_index);
			base_type = (ValaDataType*) _tmp359_;
			_tmp360_ = base_type;
			_tmp361_ = vala_data_type_get_type_symbol (_tmp360_);
			_tmp362_ = _tmp361_;
			if (VALA_IS_INTERFACE (_tmp362_)) {
				ValaDataType* _tmp363_;
				ValaTypeSymbol* _tmp364_;
				ValaTypeSymbol* _tmp365_;
				ValaList* _tmp366_;
				_tmp363_ = base_type;
				_tmp364_ = vala_data_type_get_type_symbol (_tmp363_);
				_tmp365_ = _tmp364_;
				_tmp366_ = prerequisites;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp365_, VALA_TYPE_INTERFACE, ValaInterface), _tmp366_);
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	_tmp367_ = g_str_equal;
	_tmp368_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp367_);
	missing_prereqs = (ValaList*) _tmp368_;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp369_;
		gint _prereq_size = 0;
		ValaList* _tmp370_;
		gint _tmp371_;
		gint _tmp372_;
		gint _prereq_index = 0;
		_tmp369_ = prerequisites;
		_prereq_list = _tmp369_;
		_tmp370_ = _prereq_list;
		_tmp371_ = vala_collection_get_size ((ValaCollection*) _tmp370_);
		_tmp372_ = _tmp371_;
		_prereq_size = _tmp372_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp373_;
			gint _tmp374_;
			ValaTypeSymbol* prereq = NULL;
			ValaList* _tmp375_;
			gpointer _tmp376_;
			ValaTypeSymbol* _tmp377_;
			_prereq_index = _prereq_index + 1;
			_tmp373_ = _prereq_index;
			_tmp374_ = _prereq_size;
			if (!(_tmp373_ < _tmp374_)) {
				break;
			}
			_tmp375_ = _prereq_list;
			_tmp376_ = vala_list_get (_tmp375_, _prereq_index);
			prereq = (ValaTypeSymbol*) _tmp376_;
			_tmp377_ = prereq;
			if (!vala_class_is_a (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp377_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))) {
				ValaList* _tmp378_;
				ValaTypeSymbol* _tmp379_;
				gchar* _tmp380_;
				gchar* _tmp381_;
				_tmp378_ = missing_prereqs;
				_tmp379_ = prereq;
				_tmp380_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp379_);
				_tmp381_ = _tmp380_;
				vala_list_insert (_tmp378_, 0, _tmp381_);
				_g_free0 (_tmp381_);
			}
			_vala_code_node_unref0 (prereq);
		}
	}
	_tmp382_ = missing_prereqs;
	_tmp383_ = vala_collection_get_size ((ValaCollection*) _tmp382_);
	_tmp384_ = _tmp383_;
	if (_tmp384_ > 0) {
		gchar* error_string = NULL;
		gchar* _tmp385_;
		gchar* _tmp386_;
		gchar* _tmp387_;
		gchar* _tmp388_;
		gboolean first = FALSE;
		const gchar* _tmp403_;
		gchar* _tmp404_;
		ValaSourceReference* _tmp405_;
		ValaSourceReference* _tmp406_;
		const gchar* _tmp407_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp385_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp386_ = _tmp385_;
		_tmp387_ = g_strdup_printf ("%s: some prerequisites (", _tmp386_);
		_tmp388_ = _tmp387_;
		_g_free0 (_tmp386_);
		error_string = _tmp388_;
		first = TRUE;
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp389_;
			gint _s_size = 0;
			ValaList* _tmp390_;
			gint _tmp391_;
			gint _tmp392_;
			gint _s_index = 0;
			_tmp389_ = missing_prereqs;
			_s_list = _tmp389_;
			_tmp390_ = _s_list;
			_tmp391_ = vala_collection_get_size ((ValaCollection*) _tmp390_);
			_tmp392_ = _tmp391_;
			_s_size = _tmp392_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp393_;
				gint _tmp394_;
				gchar* s = NULL;
				ValaList* _tmp395_;
				gpointer _tmp396_;
				_s_index = _s_index + 1;
				_tmp393_ = _s_index;
				_tmp394_ = _s_size;
				if (!(_tmp393_ < _tmp394_)) {
					break;
				}
				_tmp395_ = _s_list;
				_tmp396_ = vala_list_get (_tmp395_, _s_index);
				s = (gchar*) _tmp396_;
				if (first) {
					const gchar* _tmp397_;
					const gchar* _tmp398_;
					gchar* _tmp399_;
					_tmp397_ = error_string;
					_tmp398_ = s;
					_tmp399_ = g_strdup_printf ("%s`%s'", _tmp397_, _tmp398_);
					_g_free0 (error_string);
					error_string = _tmp399_;
					first = FALSE;
				} else {
					const gchar* _tmp400_;
					const gchar* _tmp401_;
					gchar* _tmp402_;
					_tmp400_ = error_string;
					_tmp401_ = s;
					_tmp402_ = g_strdup_printf ("%s, `%s'", _tmp400_, _tmp401_);
					_g_free0 (error_string);
					error_string = _tmp402_;
				}
				_g_free0 (s);
			}
		}
		_tmp403_ = error_string;
		_tmp404_ = g_strconcat (_tmp403_, ") are not met", NULL);
		_g_free0 (error_string);
		error_string = _tmp404_;
		_tmp405_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp406_ = _tmp405_;
		_tmp407_ = error_string;
		vala_report_error (_tmp406_, "%s", _tmp407_);
		_g_free0 (error_string);
	}
	_tmp408_ = vala_symbol_get_source_type ((ValaSymbol*) self);
	_tmp409_ = _tmp408_;
	if (_tmp409_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp560_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp410_;
			gint _base_type_size = 0;
			ValaList* _tmp411_;
			gint _tmp412_;
			gint _tmp413_;
			gint _base_type_index = 0;
			_tmp410_ = vala_class_get_base_types (self);
			_base_type_list = _tmp410_;
			_tmp411_ = _base_type_list;
			_tmp412_ = vala_collection_get_size ((ValaCollection*) _tmp411_);
			_tmp413_ = _tmp412_;
			_base_type_size = _tmp413_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp414_;
				gint _tmp415_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp416_;
				gpointer _tmp417_;
				ValaDataType* _tmp418_;
				ValaTypeSymbol* _tmp419_;
				ValaTypeSymbol* _tmp420_;
				_base_type_index = _base_type_index + 1;
				_tmp414_ = _base_type_index;
				_tmp415_ = _base_type_size;
				if (!(_tmp414_ < _tmp415_)) {
					break;
				}
				_tmp416_ = _base_type_list;
				_tmp417_ = vala_list_get (_tmp416_, _base_type_index);
				base_type = (ValaDataType*) _tmp417_;
				_tmp418_ = base_type;
				_tmp419_ = vala_data_type_get_type_symbol (_tmp418_);
				_tmp420_ = _tmp419_;
				if (VALA_IS_INTERFACE (_tmp420_)) {
					ValaInterface* iface = NULL;
					ValaDataType* _tmp421_;
					ValaTypeSymbol* _tmp422_;
					ValaTypeSymbol* _tmp423_;
					gboolean _tmp424_ = FALSE;
					ValaClass* _tmp425_;
					_tmp421_ = base_type;
					_tmp422_ = vala_data_type_get_type_symbol (_tmp421_);
					_tmp423_ = _tmp422_;
					iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp423_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp425_ = self->priv->_base_class;
					if (_tmp425_ != NULL) {
						ValaClass* _tmp426_;
						ValaInterface* _tmp427_;
						_tmp426_ = self->priv->_base_class;
						_tmp427_ = iface;
						_tmp424_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp426_, (ValaTypeSymbol*) _tmp427_);
					} else {
						_tmp424_ = FALSE;
					}
					if (_tmp424_) {
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						ValaList* _m_list = NULL;
						ValaInterface* _tmp428_;
						ValaList* _tmp429_;
						gint _m_size = 0;
						ValaList* _tmp430_;
						gint _tmp431_;
						gint _tmp432_;
						gint _m_index = 0;
						_tmp428_ = iface;
						_tmp429_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp428_);
						_m_list = _tmp429_;
						_tmp430_ = _m_list;
						_tmp431_ = vala_collection_get_size ((ValaCollection*) _tmp430_);
						_tmp432_ = _tmp431_;
						_m_size = _tmp432_;
						_m_index = -1;
						while (TRUE) {
							gint _tmp433_;
							gint _tmp434_;
							ValaMethod* m = NULL;
							ValaList* _tmp435_;
							gpointer _tmp436_;
							ValaMethod* _tmp437_;
							gboolean _tmp438_;
							gboolean _tmp439_;
							_m_index = _m_index + 1;
							_tmp433_ = _m_index;
							_tmp434_ = _m_size;
							if (!(_tmp433_ < _tmp434_)) {
								break;
							}
							_tmp435_ = _m_list;
							_tmp436_ = vala_list_get (_tmp435_, _m_index);
							m = (ValaMethod*) _tmp436_;
							_tmp437_ = m;
							_tmp438_ = vala_method_get_is_abstract (_tmp437_);
							_tmp439_ = _tmp438_;
							if (_tmp439_) {
								gboolean implemented = FALSE;
								ValaClass* base_class = NULL;
								implemented = FALSE;
								base_class = self;
								while (TRUE) {
									gboolean _tmp440_ = FALSE;
									ValaClass* _tmp441_;
									ValaClass* _tmp494_;
									ValaClass* _tmp495_;
									_tmp441_ = base_class;
									if (_tmp441_ != NULL) {
										_tmp440_ = !implemented;
									} else {
										_tmp440_ = FALSE;
									}
									if (!_tmp440_) {
										break;
									}
									{
										ValaList* _impl_list = NULL;
										ValaClass* _tmp442_;
										ValaList* _tmp443_;
										gint _impl_size = 0;
										ValaList* _tmp444_;
										gint _tmp445_;
										gint _tmp446_;
										gint _impl_index = 0;
										_tmp442_ = base_class;
										_tmp443_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp442_);
										_impl_list = _tmp443_;
										_tmp444_ = _impl_list;
										_tmp445_ = vala_collection_get_size ((ValaCollection*) _tmp444_);
										_tmp446_ = _tmp445_;
										_impl_size = _tmp446_;
										_impl_index = -1;
										while (TRUE) {
											gint _tmp447_;
											gint _tmp448_;
											ValaMethod* impl = NULL;
											ValaList* _tmp449_;
											gpointer _tmp450_;
											gboolean _tmp451_ = FALSE;
											ValaMethod* _tmp452_;
											ValaMethod* _tmp453_;
											ValaMethod* _tmp454_;
											ValaMethod* _tmp455_;
											_impl_index = _impl_index + 1;
											_tmp447_ = _impl_index;
											_tmp448_ = _impl_size;
											if (!(_tmp447_ < _tmp448_)) {
												break;
											}
											_tmp449_ = _impl_list;
											_tmp450_ = vala_list_get (_tmp449_, _impl_index);
											impl = (ValaMethod*) _tmp450_;
											_tmp452_ = impl;
											_tmp453_ = vala_method_get_base_interface_method (_tmp452_);
											_tmp454_ = _tmp453_;
											_tmp455_ = m;
											if (_tmp454_ == _tmp455_) {
												_tmp451_ = TRUE;
											} else {
												gboolean _tmp456_ = FALSE;
												gboolean _tmp457_ = FALSE;
												gboolean _tmp458_ = FALSE;
												gboolean _tmp459_ = FALSE;
												ValaClass* _tmp460_;
												_tmp460_ = base_class;
												if (_tmp460_ != self) {
													ValaMethod* _tmp461_;
													ValaMethod* _tmp462_;
													ValaMethod* _tmp463_;
													_tmp461_ = impl;
													_tmp462_ = vala_method_get_base_interface_method (_tmp461_);
													_tmp463_ = _tmp462_;
													_tmp459_ = _tmp463_ == NULL;
												} else {
													_tmp459_ = FALSE;
												}
												if (_tmp459_) {
													ValaMethod* _tmp464_;
													const gchar* _tmp465_;
													const gchar* _tmp466_;
													ValaMethod* _tmp467_;
													const gchar* _tmp468_;
													const gchar* _tmp469_;
													_tmp464_ = impl;
													_tmp465_ = vala_symbol_get_name ((ValaSymbol*) _tmp464_);
													_tmp466_ = _tmp465_;
													_tmp467_ = m;
													_tmp468_ = vala_symbol_get_name ((ValaSymbol*) _tmp467_);
													_tmp469_ = _tmp468_;
													_tmp458_ = g_strcmp0 (_tmp466_, _tmp469_) == 0;
												} else {
													_tmp458_ = FALSE;
												}
												if (_tmp458_) {
													gboolean _tmp470_ = FALSE;
													ValaMethod* _tmp471_;
													ValaDataType* _tmp472_;
													ValaDataType* _tmp473_;
													_tmp471_ = impl;
													_tmp472_ = vala_method_get_base_interface_type (_tmp471_);
													_tmp473_ = _tmp472_;
													if (_tmp473_ == NULL) {
														_tmp470_ = TRUE;
													} else {
														ValaMethod* _tmp474_;
														ValaDataType* _tmp475_;
														ValaDataType* _tmp476_;
														ValaTypeSymbol* _tmp477_;
														ValaTypeSymbol* _tmp478_;
														ValaInterface* _tmp479_;
														_tmp474_ = impl;
														_tmp475_ = vala_method_get_base_interface_type (_tmp474_);
														_tmp476_ = _tmp475_;
														_tmp477_ = vala_data_type_get_type_symbol (_tmp476_);
														_tmp478_ = _tmp477_;
														_tmp479_ = iface;
														_tmp470_ = _tmp478_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp479_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
													}
													_tmp457_ = _tmp470_;
												} else {
													_tmp457_ = FALSE;
												}
												if (_tmp457_) {
													ValaMethod* _tmp480_;
													ValaMethod* _tmp481_;
													_tmp480_ = impl;
													_tmp481_ = m;
													_tmp456_ = vala_method_compatible_no_error (_tmp480_, _tmp481_);
												} else {
													_tmp456_ = FALSE;
												}
												_tmp451_ = _tmp456_;
											}
											if (_tmp451_) {
												ValaMethod* _tmp482_;
												ValaVersionAttribute* _tmp483_;
												ValaVersionAttribute* _tmp484_;
												ValaSourceReference* _tmp485_;
												ValaSourceReference* _tmp486_;
												ValaMethod* _tmp487_;
												ValaMethod* _tmp488_;
												ValaMethod* _tmp489_;
												ValaMethod* _tmp490_;
												_tmp482_ = impl;
												_tmp483_ = vala_symbol_get_version ((ValaSymbol*) _tmp482_);
												_tmp484_ = _tmp483_;
												_tmp485_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp486_ = _tmp485_;
												vala_version_attribute_check (_tmp484_, context, _tmp486_);
												_tmp487_ = impl;
												vala_symbol_set_used ((ValaSymbol*) _tmp487_, TRUE);
												implemented = TRUE;
												_tmp488_ = impl;
												_tmp489_ = vala_method_get_base_interface_method (_tmp488_);
												_tmp490_ = _tmp489_;
												if (_tmp490_ == NULL) {
													ValaHashMap* _tmp491_;
													ValaMethod* _tmp492_;
													ValaMethod* _tmp493_;
													_tmp491_ = self->priv->implicit_implementations;
													_tmp492_ = m;
													_tmp493_ = impl;
													vala_map_set ((ValaMap*) _tmp491_, _tmp492_, _tmp493_);
												}
												_vala_code_node_unref0 (impl);
												break;
											}
											_vala_code_node_unref0 (impl);
										}
									}
									_tmp494_ = base_class;
									_tmp495_ = _tmp494_->priv->_base_class;
									base_class = _tmp495_;
								}
								if (!implemented) {
									ValaSourceReference* _tmp496_;
									ValaSourceReference* _tmp497_;
									gchar* _tmp498_;
									gchar* _tmp499_;
									ValaMethod* _tmp500_;
									gchar* _tmp501_;
									gchar* _tmp502_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp496_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp497_ = _tmp496_;
									_tmp498_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp499_ = _tmp498_;
									_tmp500_ = m;
									_tmp501_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp500_);
									_tmp502_ = _tmp501_;
									vala_report_error (_tmp497_, "`%s' does not implement interface method `%s'", _tmp499_, _tmp502_);
									_g_free0 (_tmp502_);
									_g_free0 (_tmp499_);
								}
							}
							_vala_code_node_unref0 (m);
						}
					}
					{
						ValaList* _prop_list = NULL;
						ValaInterface* _tmp503_;
						ValaList* _tmp504_;
						gint _prop_size = 0;
						ValaList* _tmp505_;
						gint _tmp506_;
						gint _tmp507_;
						gint _prop_index = 0;
						_tmp503_ = iface;
						_tmp504_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp503_);
						_prop_list = _tmp504_;
						_tmp505_ = _prop_list;
						_tmp506_ = vala_collection_get_size ((ValaCollection*) _tmp505_);
						_tmp507_ = _tmp506_;
						_prop_size = _tmp507_;
						_prop_index = -1;
						while (TRUE) {
							gint _tmp508_;
							gint _tmp509_;
							ValaProperty* prop = NULL;
							ValaList* _tmp510_;
							gpointer _tmp511_;
							ValaProperty* _tmp512_;
							gboolean _tmp513_;
							gboolean _tmp514_;
							_prop_index = _prop_index + 1;
							_tmp508_ = _prop_index;
							_tmp509_ = _prop_size;
							if (!(_tmp508_ < _tmp509_)) {
								break;
							}
							_tmp510_ = _prop_list;
							_tmp511_ = vala_list_get (_tmp510_, _prop_index);
							prop = (ValaProperty*) _tmp511_;
							_tmp512_ = prop;
							_tmp513_ = vala_property_get_is_abstract (_tmp512_);
							_tmp514_ = _tmp513_;
							if (_tmp514_) {
								ValaSymbol* sym = NULL;
								ValaClass* base_class = NULL;
								ValaSymbol* _tmp527_;
								sym = NULL;
								base_class = self;
								while (TRUE) {
									gboolean _tmp515_ = FALSE;
									ValaClass* _tmp516_;
									ValaClass* _tmp518_;
									ValaScope* _tmp519_;
									ValaScope* _tmp520_;
									ValaProperty* _tmp521_;
									const gchar* _tmp522_;
									const gchar* _tmp523_;
									ValaSymbol* _tmp524_;
									ValaClass* _tmp525_;
									ValaClass* _tmp526_;
									_tmp516_ = base_class;
									if (_tmp516_ != NULL) {
										ValaSymbol* _tmp517_;
										_tmp517_ = sym;
										_tmp515_ = !VALA_IS_PROPERTY (_tmp517_);
									} else {
										_tmp515_ = FALSE;
									}
									if (!_tmp515_) {
										break;
									}
									_tmp518_ = base_class;
									_tmp519_ = vala_symbol_get_scope ((ValaSymbol*) _tmp518_);
									_tmp520_ = _tmp519_;
									_tmp521_ = prop;
									_tmp522_ = vala_symbol_get_name ((ValaSymbol*) _tmp521_);
									_tmp523_ = _tmp522_;
									_tmp524_ = vala_scope_lookup (_tmp520_, _tmp523_);
									_vala_code_node_unref0 (sym);
									sym = _tmp524_;
									_tmp525_ = base_class;
									_tmp526_ = _tmp525_->priv->_base_class;
									base_class = _tmp526_;
								}
								_tmp527_ = sym;
								if (VALA_IS_PROPERTY (_tmp527_)) {
									ValaProperty* base_prop = NULL;
									ValaSymbol* _tmp528_;
									ValaProperty* _tmp529_;
									gchar* invalid_match = NULL;
									gboolean _tmp530_ = FALSE;
									ValaProperty* _tmp531_;
									gboolean _tmp532_;
									gboolean _tmp533_;
									ValaSymbol* _tmp547_;
									ValaVersionAttribute* _tmp548_;
									ValaVersionAttribute* _tmp549_;
									ValaSourceReference* _tmp550_;
									ValaSourceReference* _tmp551_;
									ValaSymbol* _tmp552_;
									_tmp528_ = sym;
									_tmp529_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp528_, VALA_TYPE_PROPERTY, ValaProperty));
									base_prop = _tmp529_;
									invalid_match = NULL;
									_tmp531_ = base_prop;
									_tmp532_ = vala_symbol_get_hides ((ValaSymbol*) _tmp531_);
									_tmp533_ = _tmp532_;
									if (!_tmp533_) {
										ValaProperty* _tmp534_;
										ValaProperty* _tmp535_;
										gchar* _tmp536_ = NULL;
										gboolean _tmp537_;
										_tmp534_ = base_prop;
										_tmp535_ = prop;
										_tmp537_ = vala_property_compatible (_tmp534_, _tmp535_, &_tmp536_);
										_g_free0 (invalid_match);
										invalid_match = _tmp536_;
										_tmp530_ = !_tmp537_;
									} else {
										_tmp530_ = FALSE;
									}
									if (_tmp530_) {
										ValaSourceReference* _tmp538_;
										ValaSourceReference* _tmp539_;
										ValaProperty* _tmp540_;
										gchar* _tmp541_;
										gchar* _tmp542_;
										ValaProperty* _tmp543_;
										gchar* _tmp544_;
										gchar* _tmp545_;
										const gchar* _tmp546_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp538_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp539_ = _tmp538_;
										_tmp540_ = prop;
										_tmp541_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp540_);
										_tmp542_ = _tmp541_;
										_tmp543_ = base_prop;
										_tmp544_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp543_);
										_tmp545_ = _tmp544_;
										_tmp546_ = invalid_match;
										vala_report_error (_tmp539_, "Type and/or accessors of inherited properties `%s' and `%s' do not mat" \
"ch: %s.", _tmp542_, _tmp545_, _tmp546_);
										_g_free0 (_tmp545_);
										_g_free0 (_tmp542_);
									}
									_tmp547_ = sym;
									_tmp548_ = vala_symbol_get_version (_tmp547_);
									_tmp549_ = _tmp548_;
									_tmp550_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp551_ = _tmp550_;
									vala_version_attribute_check (_tmp549_, context, _tmp551_);
									_tmp552_ = sym;
									vala_symbol_set_used (_tmp552_, TRUE);
									_g_free0 (invalid_match);
									_vala_code_node_unref0 (base_prop);
								} else {
									ValaSourceReference* _tmp553_;
									ValaSourceReference* _tmp554_;
									gchar* _tmp555_;
									gchar* _tmp556_;
									ValaProperty* _tmp557_;
									gchar* _tmp558_;
									gchar* _tmp559_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp553_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp554_ = _tmp553_;
									_tmp555_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp556_ = _tmp555_;
									_tmp557_ = prop;
									_tmp558_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp557_);
									_tmp559_ = _tmp558_;
									vala_report_error (_tmp554_, "`%s' does not implement interface property `%s'", _tmp556_, _tmp559_);
									_g_free0 (_tmp559_);
									_g_free0 (_tmp556_);
								}
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (prop);
						}
					}
				}
				_vala_code_node_unref0 (base_type);
			}
		}
		_tmp560_ = self->priv->_is_abstract;
		if (!_tmp560_) {
			ValaClass* base_class = NULL;
			ValaClass* _tmp561_;
			_tmp561_ = self->priv->_base_class;
			base_class = _tmp561_;
			while (TRUE) {
				gboolean _tmp562_ = FALSE;
				ValaClass* _tmp563_;
				ValaClass* _tmp624_;
				ValaClass* _tmp625_;
				_tmp563_ = base_class;
				if (_tmp563_ != NULL) {
					ValaClass* _tmp564_;
					gboolean _tmp565_;
					_tmp564_ = base_class;
					_tmp565_ = _tmp564_->priv->_is_abstract;
					_tmp562_ = _tmp565_;
				} else {
					_tmp562_ = FALSE;
				}
				if (!_tmp562_) {
					break;
				}
				{
					ValaList* _base_method_list = NULL;
					ValaClass* _tmp566_;
					ValaList* _tmp567_;
					gint _base_method_size = 0;
					ValaList* _tmp568_;
					gint _tmp569_;
					gint _tmp570_;
					gint _base_method_index = 0;
					_tmp566_ = base_class;
					_tmp567_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp566_);
					_base_method_list = _tmp567_;
					_tmp568_ = _base_method_list;
					_tmp569_ = vala_collection_get_size ((ValaCollection*) _tmp568_);
					_tmp570_ = _tmp569_;
					_base_method_size = _tmp570_;
					_base_method_index = -1;
					while (TRUE) {
						gint _tmp571_;
						gint _tmp572_;
						ValaMethod* base_method = NULL;
						ValaList* _tmp573_;
						gpointer _tmp574_;
						ValaMethod* _tmp575_;
						gboolean _tmp576_;
						gboolean _tmp577_;
						_base_method_index = _base_method_index + 1;
						_tmp571_ = _base_method_index;
						_tmp572_ = _base_method_size;
						if (!(_tmp571_ < _tmp572_)) {
							break;
						}
						_tmp573_ = _base_method_list;
						_tmp574_ = vala_list_get (_tmp573_, _base_method_index);
						base_method = (ValaMethod*) _tmp574_;
						_tmp575_ = base_method;
						_tmp576_ = vala_method_get_is_abstract (_tmp575_);
						_tmp577_ = _tmp576_;
						if (_tmp577_) {
							ValaMethod* override_method = NULL;
							ValaMethod* _tmp578_;
							const gchar* _tmp579_;
							const gchar* _tmp580_;
							ValaSymbol* _tmp581_;
							ValaMethod* _tmp582_;
							gboolean _tmp583_ = FALSE;
							ValaMethod* _tmp584_;
							_tmp578_ = base_method;
							_tmp579_ = vala_symbol_get_name ((ValaSymbol*) _tmp578_);
							_tmp580_ = _tmp579_;
							_tmp581_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp580_);
							_tmp582_ = VALA_IS_METHOD (_tmp581_) ? ((ValaMethod*) _tmp581_) : NULL;
							if (_tmp582_ == NULL) {
								_vala_code_node_unref0 (_tmp581_);
							}
							override_method = _tmp582_;
							_tmp584_ = override_method;
							if (_tmp584_ == NULL) {
								_tmp583_ = TRUE;
							} else {
								ValaMethod* _tmp585_;
								gboolean _tmp586_;
								gboolean _tmp587_;
								_tmp585_ = override_method;
								_tmp586_ = vala_method_get_overrides (_tmp585_);
								_tmp587_ = _tmp586_;
								_tmp583_ = !_tmp587_;
							}
							if (_tmp583_) {
								ValaSourceReference* _tmp588_;
								ValaSourceReference* _tmp589_;
								gchar* _tmp590_;
								gchar* _tmp591_;
								ValaMethod* _tmp592_;
								gchar* _tmp593_;
								gchar* _tmp594_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp588_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp589_ = _tmp588_;
								_tmp590_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp591_ = _tmp590_;
								_tmp592_ = base_method;
								_tmp593_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp592_);
								_tmp594_ = _tmp593_;
								vala_report_error (_tmp589_, "`%s' does not implement abstract method `%s'", _tmp591_, _tmp594_);
								_g_free0 (_tmp594_);
								_g_free0 (_tmp591_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
				}
				{
					ValaList* _base_property_list = NULL;
					ValaClass* _tmp595_;
					ValaList* _tmp596_;
					gint _base_property_size = 0;
					ValaList* _tmp597_;
					gint _tmp598_;
					gint _tmp599_;
					gint _base_property_index = 0;
					_tmp595_ = base_class;
					_tmp596_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp595_);
					_base_property_list = _tmp596_;
					_tmp597_ = _base_property_list;
					_tmp598_ = vala_collection_get_size ((ValaCollection*) _tmp597_);
					_tmp599_ = _tmp598_;
					_base_property_size = _tmp599_;
					_base_property_index = -1;
					while (TRUE) {
						gint _tmp600_;
						gint _tmp601_;
						ValaProperty* base_property = NULL;
						ValaList* _tmp602_;
						gpointer _tmp603_;
						ValaProperty* _tmp604_;
						gboolean _tmp605_;
						gboolean _tmp606_;
						_base_property_index = _base_property_index + 1;
						_tmp600_ = _base_property_index;
						_tmp601_ = _base_property_size;
						if (!(_tmp600_ < _tmp601_)) {
							break;
						}
						_tmp602_ = _base_property_list;
						_tmp603_ = vala_list_get (_tmp602_, _base_property_index);
						base_property = (ValaProperty*) _tmp603_;
						_tmp604_ = base_property;
						_tmp605_ = vala_property_get_is_abstract (_tmp604_);
						_tmp606_ = _tmp605_;
						if (_tmp606_) {
							ValaProperty* override_property = NULL;
							ValaProperty* _tmp607_;
							const gchar* _tmp608_;
							const gchar* _tmp609_;
							ValaSymbol* _tmp610_;
							ValaProperty* _tmp611_;
							gboolean _tmp612_ = FALSE;
							ValaProperty* _tmp613_;
							_tmp607_ = base_property;
							_tmp608_ = vala_symbol_get_name ((ValaSymbol*) _tmp607_);
							_tmp609_ = _tmp608_;
							_tmp610_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp609_);
							_tmp611_ = VALA_IS_PROPERTY (_tmp610_) ? ((ValaProperty*) _tmp610_) : NULL;
							if (_tmp611_ == NULL) {
								_vala_code_node_unref0 (_tmp610_);
							}
							override_property = _tmp611_;
							_tmp613_ = override_property;
							if (_tmp613_ == NULL) {
								_tmp612_ = TRUE;
							} else {
								ValaProperty* _tmp614_;
								gboolean _tmp615_;
								gboolean _tmp616_;
								_tmp614_ = override_property;
								_tmp615_ = vala_property_get_overrides (_tmp614_);
								_tmp616_ = _tmp615_;
								_tmp612_ = !_tmp616_;
							}
							if (_tmp612_) {
								ValaSourceReference* _tmp617_;
								ValaSourceReference* _tmp618_;
								gchar* _tmp619_;
								gchar* _tmp620_;
								ValaProperty* _tmp621_;
								gchar* _tmp622_;
								gchar* _tmp623_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp617_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp618_ = _tmp617_;
								_tmp619_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp620_ = _tmp619_;
								_tmp621_ = base_property;
								_tmp622_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp621_);
								_tmp623_ = _tmp622_;
								vala_report_error (_tmp618_, "`%s' does not implement abstract property `%s'", _tmp620_, _tmp623_);
								_g_free0 (_tmp623_);
								_g_free0 (_tmp620_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
				}
				_tmp624_ = base_class;
				_tmp625_ = _tmp624_->priv->_base_class;
				base_class = _tmp625_;
			}
		}
	}
	_tmp626_ = vala_code_context_get_analyzer (context);
	_tmp627_ = _tmp626_;
	_tmp628_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp627_, _tmp628_);
	_tmp629_ = vala_code_context_get_analyzer (context);
	_tmp630_ = _tmp629_;
	_tmp631_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp630_, _tmp631_);
	_tmp632_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp633_ = _tmp632_;
	result = !_tmp633_;
	_vala_iterable_unref0 (missing_prereqs);
	_vala_iterable_unref0 (prerequisites);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_class_class_init (ValaClassClass * klass,
                       gpointer klass_data)
{
	vala_class_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_class_finalize;
	g_type_class_adjust_private_offset (klass, &ValaClass_private_offset);
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_class_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_class_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_class_real_add_property;
	((ValaSymbolClass *) klass)->add_constructor = (void (*) (ValaSymbol*, ValaConstructor*)) vala_class_real_add_constructor;
	((ValaSymbolClass *) klass)->add_destructor = (void (*) (ValaSymbol*, ValaDestructor*)) vala_class_real_add_destructor;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_class_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_class_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_class_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_class_real_check;
}

static void
vala_class_instance_init (ValaClass * self,
                          gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	self->priv = vala_class_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->base_types = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _vala_symbol_hash_func_ghash_func, _vala_symbol_equal_func_gequal_func, _tmp2_);
	self->priv->implicit_implementations = _tmp3_;
}

static void
vala_class_finalize (ValaCodeNode * obj)
{
	ValaClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CLASS, ValaClass);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_is_compact);
	_g_free0 (self->priv->_is_opaque);
	_g_free0 (self->priv->_is_immutable);
	_g_free0 (self->priv->_is_singleton);
	_vala_iterable_unref0 (self->priv->base_types);
	_vala_map_unref0 (self->priv->implicit_implementations);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}

/**
 * Represents a class declaration in the source code.
 */
static GType
vala_class_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
	GType vala_class_type_id;
	vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
	ValaClass_private_offset = g_type_add_instance_private (vala_class_type_id, sizeof (ValaClassPrivate));
	return vala_class_type_id;
}

GType
vala_class_get_type (void)
{
	static volatile gsize vala_class_type_id__once = 0;
	if (g_once_init_enter (&vala_class_type_id__once)) {
		GType vala_class_type_id;
		vala_class_type_id = vala_class_get_type_once ();
		g_once_init_leave (&vala_class_type_id__once, vala_class_type_id);
	}
	return vala_class_type_id__once;
}

