#!-------------------------------------------------------------------------------------------------!
#!   CP2K: A general program to perform molecular dynamics simulations                             !
#!   Copyright 2000-2025 CP2K developers group <https://cp2k.org>                                  !
#!                                                                                                 !
#!   SPDX-License-Identifier: GPL-2.0-or-later                                                     !
#!-------------------------------------------------------------------------------------------------!

cmake_minimum_required(VERSION 3.22)
include(CMakeFindDependencyMacro)

if(NOT TARGET cp2k::cp2k)
  set(CMAKE_MODULE_PATH "${CMAKE_CURRENT_LIST_DIR}/modules"
                        ${CMAKE_MODULE_PATH})

  # store CXX compiler id. Used in MKL package.
  set(CP2K_CXX_COMPILER_ID GNU)
  if(NOT ${CMAKE_CXX_COMPILER_ID})
    set(CMAKE_CXX_COMPILER_ID ${CP2K_CXX_COMPILER_ID})
  endif()

  set(CP2K_BLAS_VENDOR OpenBLAS)
  set(CP2K_SCALAPACK_VENDOR GENERIC)
  set(CP2K_BLAS_LINK_LIBRARIES D:/a/msys64/ucrt64/lib/libopenblas.dll.a)
  set(CP2K_LAPACK_LINK_LIBRARIES D:/a/msys64/ucrt64/lib/libopenblas.dll.a)
  set(CP2K_SCALAPACK_LINK_LIBRARIES )
  set(CP2K_USE_FFTW3_WITH_MKL OFF)
  set(CP2K_CONFIG_PACKAGE ON)
  find_dependency(Lapack REQUIRED)

  # define lapack and blas TARGETS

  if(OFF)
    find_dependency(SCALAPACK REQUIRED)
  endif()
  unset(CP2K_CONFIG_PACKAGE)

  set(cp2k_VERSION 2025.1)

  find_dependency(DBCSR 2.5 REQUIRED)

  if(OFF)
    find_dependency(LibXSMM REQUIRED)
  endif()

  if(OFF)
    # Find hip
    find_dependency(hipfft REQUIRED IMPORTED CONFIG)
    find_dependency(hipblas REQUIRED IMPORTED CONFIG)
  endif()

  if(OFF)
    find_dependency(CUDAToolkit REQUIRED)
  endif()
  if(OFF)
    find_dependency(Elpa REQUIRED)
  endif()

  if(OFF)
    find_dependency(DLAF REQUIRED)
  endif()

  if(ON)
    find_dependency(LibXC 7 REQUIRED)
  endif()

  if(OFF)
    find_dependency(cosma REQUIRED)
  endif()

  if(OFF)
    find_dependency(MPI REQUIRED)
  endif()

  if(ON)
    find_dependency(Fftw REQUIRED)
  endif()
  # QUIP
  if(OFF)
    find_dependency(Quip REQUIRED)
  endif()

  # libint

  if(ON)
    find_dependency(Libint2 REQUIRED)
  endif()

  # spglib

  if(ON)
    find_dependency(LibSPG REQUIRED)
  endif()

  if(OFF)
    find_dependency(SPLA REQUIRED)
  endif()

  if(OFF)
    find_dependency(sirius REQUIRED)
  endif()

  if(OFF)
    find_dependency(SuperLU REQUIRED)
  endif()

  if(OFF)
    find_dependency(Metis)
  endif()

  if(OFF)
    # PEXSI 1.2 uses cmake as build system
    find_dependency(PEXSI REQUIRED)
  endif()

  if(OFF)
    find_dependency(Plumed REQUIRED)
  endif()

  if(OFF)
    find_dependency(Torch REQUIRED)
  endif()

  include("${CMAKE_CURRENT_LIST_DIR}/cp2kTargets.cmake")

  # Clean-up module path.
  list(REMOVE_ITEM CMAKE_MODULE_PATH "${CMAKE_CURRENT_LIST_DIR}/modules")

endif()
