
#ifndef KNOTIFYCONFIG_EXPORT_H
#define KNOTIFYCONFIG_EXPORT_H

#ifdef KNOTIFYCONFIG_STATIC_DEFINE
#  define KNOTIFYCONFIG_EXPORT
#  define KNOTIFYCONFIG_NO_EXPORT
#else
#  ifndef KNOTIFYCONFIG_EXPORT
#    ifdef KF6NotifyConfig_EXPORTS
        /* We are building this library */
#      define KNOTIFYCONFIG_EXPORT __declspec(dllexport)
#    else
        /* We are using this library */
#      define KNOTIFYCONFIG_EXPORT __declspec(dllimport)
#    endif
#  endif

#  ifndef KNOTIFYCONFIG_NO_EXPORT
#    define KNOTIFYCONFIG_NO_EXPORT 
#  endif
#endif

#ifndef KNOTIFYCONFIG_DECL_DEPRECATED
#  define KNOTIFYCONFIG_DECL_DEPRECATED __declspec(deprecated)
#endif

#ifndef KNOTIFYCONFIG_DECL_DEPRECATED_EXPORT
#  define KNOTIFYCONFIG_DECL_DEPRECATED_EXPORT KNOTIFYCONFIG_EXPORT KNOTIFYCONFIG_DECL_DEPRECATED
#endif

#ifndef KNOTIFYCONFIG_DECL_DEPRECATED_NO_EXPORT
#  define KNOTIFYCONFIG_DECL_DEPRECATED_NO_EXPORT KNOTIFYCONFIG_NO_EXPORT KNOTIFYCONFIG_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KNOTIFYCONFIG_NO_DEPRECATED
#    define KNOTIFYCONFIG_NO_DEPRECATED
#  endif
#endif
#include <knotifyconfig_version.h>

#define KNOTIFYCONFIG_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KNOTIFYCONFIG_NO_DEPRECATED) && !defined(KNOTIFYCONFIG_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KNOTIFYCONFIG_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KNOTIFYCONFIG_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KNOTIFYCONFIG_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KNOTIFYCONFIG_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KNOTIFYCONFIG_NO_DEPRECATED_WARNINGS) && !defined(KNOTIFYCONFIG_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KNOTIFYCONFIG_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KNOTIFYCONFIG_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KNOTIFYCONFIG_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KNOTIFYCONFIG_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KNOTIFYCONFIG_NO_DEPRECATED)
#  undef KNOTIFYCONFIG_DEPRECATED
#  define KNOTIFYCONFIG_DEPRECATED_EXPORT KNOTIFYCONFIG_EXPORT
#  define KNOTIFYCONFIG_DEPRECATED_NO_EXPORT KNOTIFYCONFIG_NO_EXPORT
#elif defined(KNOTIFYCONFIG_NO_DEPRECATED_WARNINGS)
#  define KNOTIFYCONFIG_DEPRECATED
#  define KNOTIFYCONFIG_DEPRECATED_EXPORT KNOTIFYCONFIG_EXPORT
#  define KNOTIFYCONFIG_DEPRECATED_NO_EXPORT KNOTIFYCONFIG_NO_EXPORT
#else
#  define KNOTIFYCONFIG_DEPRECATED KNOTIFYCONFIG_DECL_DEPRECATED
#  define KNOTIFYCONFIG_DEPRECATED_EXPORT KNOTIFYCONFIG_DECL_DEPRECATED_EXPORT
#  define KNOTIFYCONFIG_DEPRECATED_NO_EXPORT KNOTIFYCONFIG_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KNOTIFYCONFIG_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KNOTIFYCONFIG_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KNOTIFYCONFIG_NO_DEPRECATED
#  define KNOTIFYCONFIG_DISABLE_DEPRECATED_BEFORE_AND_AT KNOTIFYCONFIG_VERSION
#endif
#ifdef KNOTIFYCONFIG_NO_DEPRECATED_WARNINGS
#  define KNOTIFYCONFIG_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KNOTIFYCONFIG_DEPRECATED_WARNINGS_SINCE
#  ifdef KNOTIFYCONFIG_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KNOTIFYCONFIG_DEPRECATED_WARNINGS_SINCE KNOTIFYCONFIG_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KNOTIFYCONFIG_DEPRECATED_WARNINGS_SINCE KNOTIFYCONFIG_VERSION
#  endif
#endif

#ifndef KNOTIFYCONFIG_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KNOTIFYCONFIG_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KNOTIFYCONFIG_DEPRECATED
#  define KNOTIFYCONFIG_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KNOTIFYCONFIG_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KNOTIFYCONFIG_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KNOTIFYCONFIG_EXPORT_H */
