--
--  Copyright (C) 2014-2022, AdaCore
--  SPDX-License-Identifier: Apache-2.0
--

with Langkit_Support.Internal.Analysis; use Langkit_Support.Internal.Analysis;
with Langkit_Support.Internal.Conversions;
use Langkit_Support.Internal.Conversions;

with Libadalang.Generic_API; use Libadalang.Generic_API;

package body Libadalang.Private_Converters is

   function "+"
     (Entity : Langkit_Support.Internal.Analysis.Internal_Entity)
      return Implementation.Internal_Entity
     with Import,
          External_Name => "Libadalang__from_generic_internal_entity";
   function "+"
     (Entity : Implementation.Internal_Entity)
      return Langkit_Support.Internal.Analysis.Internal_Entity
     with Import,
          External_Name => "Libadalang__to_generic_internal_entity";
   --  See the corresponding exports in $.Generic_Impl

   -----------------------
   -- From_Generic_Node --
   -----------------------

   function From_Generic_Node
     (Node : Lk_Node) return Implementation.Internal_Entity is
   begin
      return +Unwrap_Node (Node);
   end From_Generic_Node;

   ---------------------
   -- To_Generic_Node --
   ---------------------

   function To_Generic_Node
     (Entity : Implementation.Internal_Entity) return Lk_Node is
   begin
      return Wrap_Node (Self_Id, +Entity);
   end To_Generic_Node;

end Libadalang.Private_Converters;
