%feature("docstring") OT::IterativeThresholdExceedance
"Iterative threshold exceedance.

Parameters
----------
dimension : int, optional
    Dimension of the input data, default is 1
operator : :class:`~openturns.ComparisonOperator`, optional
    Comparison operator, default is :class:`~openturns.Greater`
threshold : float, optional
    Threshold value, default is 0.0

Notes
-----
This class iteratively counts the number of threshold exceedances
of an iteratively increasing
dataset without storing any data in memory.

See also
--------
IterativeAlgorithm

Examples
--------
>>> import openturns as ot
>>> ot.RandomGenerator.SetSeed(0)
>>> dim = 5
>>> threshold = 0.5
>>> algo = ot.IterativeThresholdExceedance(dim, ot.Greater(), threshold)
>>> n = ot.Normal(dim)
>>> size = 50

Increment with 50 points:

>>> for i in range(size):
...     point = n.getRealization()
...     algo.increment(point)
>>> print(algo.getThresholdExceedance())
[14,14,14,17,12]
>>> print(algo.getIterationNumber())
50

Increment with one sample of size 50:

>>> sample = n.getSample(size)
>>> algo.increment(sample)
>>> print(algo.getIterationNumber())
100
>>> print(algo.getThresholdExceedance())
[38,30,35,27,32]"

// ---------------------------------------------------------------------

%feature("docstring") OT::IterativeThresholdExceedance::getThresholdExceedance
"Returns the number of threshold exceedances per component

Returns
-------
thresholdExceedance : :class:`~openturns.Point`
    Number of threshold exceedances per component."

// ---------------------------------------------------------------------

%feature("docstring") OT::IterativeThresholdExceedance::getThresholdValue
"Returns the value of the threshold

Returns
-------
thresholdValue : float
    the value of the threshold."

// ---------------------------------------------------------------------

%feature("docstring") OT::IterativeThresholdExceedance::getRatio
"Returns the ratio of threshold exceedances per iteration

Returns
-------
ratio : :class:`~openturns.Point`
    Ratio of threshold exceedances per iteration, per component."
