%feature("docstring") OT::MeixnerDistributionFactory
"Meixner Distribution factory.

Notes
-----
The parameters are estimated using the following moments estimators:

.. math::
    :nowrap:

    \\begin{align}
      \\displaystyle\\Hat{\\gamma_1} = \\frac{\\frac{1}{n}\\sum_{i=1}^{n} (x_i-\\Hat{x}_n)^3}{\\Hat{\\sigma}_n^3}\\\\
      \\displaystyle\\Hat{\\gamma_2} = \\frac{\\frac{1}{n}\\sum_{i=1}^{n} (x_i-\\Hat{x}_n)^4}{\\Hat{\\sigma}_n^4}\\\\
      \\displaystyle\\Hat{\\delta} =   \\frac{1}{\\Hat{\\gamma_2}_n-\\Hat{\\gamma_1}_n^2-3}\\\\
      \\displaystyle\\Hat{\\beta} =    sign(\\Hat{\\gamma_1}_n)arcos( 2-\\Hat{\\delta}_n (\\Hat{\\gamma_2}_n-3))\\\\
      \\displaystyle\\Hat{\\alpha} =   (\\Hat{\\sigma}_n^2(\\cos\\Hat{\\beta}_n+1) )^{1/3}
    \\end{align}

where :math:`\\gamma_2` is defined if :math:`\\Hat{\\gamma_2}_n \\geq 2\\Hat{\\gamma_1}_n +3`.

See also
--------
DistributionFactory, MeixnerDistribution"

// ---------------------------------------------------------------------

%feature("docstring") OT::MeixnerDistributionFactory::buildAsMeixnerDistribution
"Estimate the distribution as native distribution.


**Available usages**:

    buildAsMeixnerDistribution()

    buildAsMeixnerDistribution(*sample*)

    buildAsMeixnerDistribution(*param*)

Parameters
----------
sample : 2-d sequence of float
    Sample from which the distribution parameters are estimated.
param : sequence of float
   The parameters of the :class:`~openturns.MeixnerDistribution`.

Returns
-------
distribution : :class:`~openturns.MeixnerDistribution`
    The estimated distribution as a MeixnerDistribution.
    
    In the first usage, the default MeixnerDistribution distribution is built."

