#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadapthistorygetstep_ TSADAPTHISTORYGETSTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadapthistorygetstep_ tsadapthistorygetstep
#endif
PETSC_EXTERN void tsadapthistorygetstep_(TSAdapt *a, PetscInt *b, PetscReal *c, PetscReal *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  *ierr = TSAdaptHistoryGetStep(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadapthistorysethistory_ TSADAPTHISTORYSETHISTORY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadapthistorysethistory_ tsadapthistorysethistory
#endif
PETSC_EXTERN void tsadapthistorysethistory_(TSAdapt *a, PetscInt *b, PetscReal c[], PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = TSAdaptHistorySetHistory(*a, *b, c, *d ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsadapthistorysettrajectory_ TSADAPTHISTORYSETTRAJECTORY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsadapthistorysettrajectory_ tsadapthistorysettrajectory
#endif
PETSC_EXTERN void tsadapthistorysettrajectory_(TSAdapt *a, TSTrajectory *b, PetscBool *c, PetscErrorCode *ierr)
{
  *ierr = TSAdaptHistorySetTrajectory(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
