#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerasciigetstderr_ PETSCVIEWERASCIIGETSTDERR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerasciigetstderr_ petscviewerasciigetstderr
#endif
PETSC_EXTERN void petscviewerasciigetstderr_(MPI_Fint *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscViewerASCIIGetStderr(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerasciiopen_ PETSCVIEWERASCIIOPEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerasciiopen_ petscviewerasciiopen
#endif
PETSC_EXTERN void petscviewerasciiopen_(MPI_Fint *a, char b[], PetscViewer *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscViewerASCIIOpen(MPI_Comm_f2c(*(a)), c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
