#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petsclandau.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexlandauaddmaxwellians_ DMPLEXLANDAUADDMAXWELLIANS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexlandauaddmaxwellians_ dmplexlandauaddmaxwellians
#endif
PETSC_EXTERN void dmplexlandauaddmaxwellians_(DM *a, Vec *b, PetscReal *c, PetscReal d[], PetscReal e[], PetscInt *f, PetscInt *g, PetscInt *h, void *i, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  *ierr = DMPlexLandauAddMaxwellians(*a, *b, *c, d, e, *f, *g, *h, i);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petsclandau.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexlandaucreatevelocityspace_ DMPLEXLANDAUCREATEVELOCITYSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexlandaucreatevelocityspace_ dmplexlandaucreatevelocityspace
#endif
PETSC_EXTERN void dmplexlandaucreatevelocityspace_(MPI_Fint *a, PetscInt *b, char c[], Vec *d, Mat *e, DM *f, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(e);
  CHKFORTRANNULLOBJECT(f);
  *ierr = DMPlexLandauCreateVelocitySpace(MPI_Comm_f2c(*(a)), *b, c_c, d, e, f);
  if (*ierr) return;
  FREECHAR(c, c_c);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petsclandau.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexlandaudestroyvelocityspace_ DMPLEXLANDAUDESTROYVELOCITYSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexlandaudestroyvelocityspace_ dmplexlandaudestroyvelocityspace
#endif
PETSC_EXTERN void dmplexlandaudestroyvelocityspace_(DM *a, PetscErrorCode *ierr)
{
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = DMPlexLandauDestroyVelocitySpace(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petsclandau.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexlandauprintnorms_ DMPLEXLANDAUPRINTNORMS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexlandauprintnorms_ dmplexlandauprintnorms
#endif
PETSC_EXTERN void dmplexlandauprintnorms_(Vec *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexLandauPrintNorms(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petsclandau.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexlandaucreatemassmatrix_ DMPLEXLANDAUCREATEMASSMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexlandaucreatemassmatrix_ dmplexlandaucreatemassmatrix
#endif
PETSC_EXTERN void dmplexlandaucreatemassmatrix_(DM *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexLandauCreateMassMatrix(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petsclandau.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexlandauifunction_ DMPLEXLANDAUIFUNCTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexlandauifunction_ dmplexlandauifunction
#endif
PETSC_EXTERN void dmplexlandauifunction_(TS *a, PetscReal *b, Vec *c, Vec *d, Vec *e, void *f, PetscErrorCode *ierr)
{
  *ierr = DMPlexLandauIFunction(*a, *b, *c, *d, *e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petsclandau.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexlandauijacobian_ DMPLEXLANDAUIJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexlandauijacobian_ dmplexlandauijacobian
#endif
PETSC_EXTERN void dmplexlandauijacobian_(TS *a, PetscReal *b, Vec *c, Vec *d, PetscReal *e, Mat *f, Mat *g, void *h, PetscErrorCode *ierr)
{
  *ierr = DMPlexLandauIJacobian(*a, *b, *c, *d, *e, *f, *g, h);
  if (*ierr) return;
}
