#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectgetnewtag_ PETSCOBJECTGETNEWTAG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectgetnewtag_ petscobjectgetnewtag
#endif
PETSC_EXTERN void petscobjectgetnewtag_(PetscObject *a, PetscMPIInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscObjectGetNewTag(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectslistgetglobalnumbering_ PETSCOBJECTSLISTGETGLOBALNUMBERING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectslistgetglobalnumbering_ petscobjectslistgetglobalnumbering
#endif
PETSC_EXTERN void petscobjectslistgetglobalnumbering_(MPI_Fint *a, PetscInt *b, PetscObject c[], PetscInt *d, PetscInt *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  *ierr = PetscObjectsListGetGlobalNumbering(MPI_Comm_f2c(*(a)), *b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsccommgetnewtag_ PETSCCOMMGETNEWTAG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsccommgetnewtag_ petsccommgetnewtag
#endif
PETSC_EXTERN void petsccommgetnewtag_(MPI_Fint *a, PetscMPIInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscCommGetNewTag(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
}
