#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesngssettolerances_ SNESNGSSETTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesngssettolerances_ snesngssettolerances
#endif
PETSC_EXTERN void snesngssettolerances_(SNES *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscInt *e, PetscErrorCode *ierr)
{
  *ierr = SNESNGSSetTolerances(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesngsgettolerances_ SNESNGSGETTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesngsgettolerances_ snesngsgettolerances
#endif
PETSC_EXTERN void snesngsgettolerances_(SNES *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscInt *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLINTEGER(e);
  *ierr = SNESNGSGetTolerances(*a, b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesngssetsweeps_ SNESNGSSETSWEEPS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesngssetsweeps_ snesngssetsweeps
#endif
PETSC_EXTERN void snesngssetsweeps_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = SNESNGSSetSweeps(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesngsgetsweeps_ SNESNGSGETSWEEPS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesngsgetsweeps_ snesngsgetsweeps
#endif
PETSC_EXTERN void snesngsgetsweeps_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = SNESNGSGetSweeps(*a, b);
  if (*ierr) return;
}
