#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatesection_ DMPLEXCREATESECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatesection_ dmplexcreatesection
#endif
PETSC_EXTERN void dmplexcreatesection_(DM *a, DMLabel b[], const PetscInt c[], const PetscInt d[], PetscInt *e, const PetscInt f[], const IS g[], const IS h[], IS *i, PetscSection *j, PetscErrorCode *ierr)
{
  PetscBool null_j = !*(void**) j ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLOBJECT(j);
  *ierr = DMPlexCreateSection(*a, b, c, d, *e, f, g, h, *i, j);
  if (*ierr) return;
  if (! null_j && !*(void**) j) *(void **) j = (void *)-2;
}
