#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matscattergetvecscatter_ MATSCATTERGETVECSCATTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matscattergetvecscatter_ matscattergetvecscatter
#endif
PETSC_EXTERN void matscattergetvecscatter_(Mat *a, VecScatter *b, PetscErrorCode *ierr)
{
  *ierr = MatScatterGetVecScatter(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatescatter_ MATCREATESCATTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatescatter_ matcreatescatter
#endif
PETSC_EXTERN void matcreatescatter_(MPI_Fint *a, VecScatter *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatCreateScatter(MPI_Comm_f2c(*(a)), *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matscattersetvecscatter_ MATSCATTERSETVECSCATTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matscattersetvecscatter_ matscattersetvecscatter
#endif
PETSC_EXTERN void matscattersetvecscatter_(Mat *a, VecScatter *b, PetscErrorCode *ierr)
{
  *ierr = MatScatterSetVecScatter(*a, *b);
  if (*ierr) return;
}
