# @HEADER
# ************************************************************************
#
#            TriBITS: Tribal Build, Integrate, and Test System
#                    Copyright 2013 Sandia Corporation
#
# Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
# the U.S. Government retains certain rights in this software.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# 3. Neither the name of the Corporation nor the names of the
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# ************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Trilinos/Stokhos clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################

if(CMAKE_VERSION VERSION_LESS 3.3)
  set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
    "Stokhos requires CMake 3.3 or later for 'if (... IN_LIST ...)'"
    )
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
  return()
endif()
cmake_minimum_required(VERSION 3.3...3.23.0)

## ---------------------------------------------------------------------------
## Compilers used by Trilinos/Stokhos build
## ---------------------------------------------------------------------------

set(Stokhos_CXX_COMPILER "D:/a/msys64/ucrt64/bin/g++.exe")

set(Stokhos_C_COMPILER "D:/a/msys64/ucrt64/bin/gcc.exe")

set(Stokhos_Fortran_COMPILER "D:/a/msys64/ucrt64/bin/gfortran.exe")
# Deprecated!
set(Stokhos_FORTRAN_COMPILER "D:/a/msys64/ucrt64/bin/gfortran.exe") 


## ---------------------------------------------------------------------------
## Compiler flags used by Trilinos/Stokhos build
## ---------------------------------------------------------------------------

## Give the build type
set(Stokhos_CMAKE_BUILD_TYPE "Release")

## Set compiler flags, including those determined by build type
set(Stokhos_CXX_FLAGS [[ ]])

set(Stokhos_C_FLAGS [[  -march=nocona -msahf -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong ]])

set(Stokhos_Fortran_FLAGS [[ ]])
# Deprecated
set(Stokhos_FORTRAN_FLAGS [[ ]])

## Extra link flags (e.g., specification of fortran libraries)
set(Stokhos_EXTRA_LD_FLAGS [[]])

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
set(Stokhos_SHARED_LIB_RPATH_COMMAND "/ucrt64/lib")
set(Stokhos_BUILD_SHARED_LIBS "ON")

set(Stokhos_LINKER D:/a/msys64/ucrt64/bin/ld.exe)
set(Stokhos_AR D:/a/msys64/ucrt64/bin/ar.exe)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## Base install location (if not in the build tree)
set(Stokhos_INSTALL_DIR "/ucrt64")

## List of package libraries
set(Stokhos_LIBRARIES Stokhos::all_libs)

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

set(Stokhos_MPI_LIBRARIES "")
set(Stokhos_MPI_LIBRARY_DIRS "")
set(Stokhos_MPI_INCLUDE_DIRS "")
set(Stokhos_MPI_EXEC "")
set(Stokhos_MPI_EXEC_MAX_NUMPROCS "")
set(Stokhos_MPI_EXEC_NUMPROCS_FLAG "")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

# Enables/Disables for upstream package dependencies
set(Stokhos_ENABLE_Teuchos ON)
set(Stokhos_ENABLE_Kokkos ON)
set(Stokhos_ENABLE_EpetraExt OFF)
set(Stokhos_ENABLE_Ifpack OFF)
set(Stokhos_ENABLE_ML OFF)
set(Stokhos_ENABLE_Anasazi OFF)
set(Stokhos_ENABLE_Sacado ON)
set(Stokhos_ENABLE_NOX ON)
set(Stokhos_ENABLE_Isorropia OFF)
set(Stokhos_ENABLE_KokkosKernels ON)
set(Stokhos_ENABLE_TeuchosKokkosComm ON)
set(Stokhos_ENABLE_Tpetra OFF)
set(Stokhos_ENABLE_Ifpack2 OFF)
set(Stokhos_ENABLE_MueLu OFF)
set(Stokhos_ENABLE_Belos ON)
set(Stokhos_ENABLE_Amesos2 OFF)
set(Stokhos_ENABLE_Thyra ON)
set(Stokhos_ENABLE_Xpetra OFF)
set(Stokhos_ENABLE_ForUQTK OFF)
set(Stokhos_ENABLE_CUDA OFF)
set(Stokhos_ENABLE_Thrust OFF)
set(Stokhos_ENABLE_Cusp OFF)
set(Stokhos_ENABLE_CUSPARSE OFF)
set(Stokhos_ENABLE_Clp OFF)
set(Stokhos_ENABLE_GLPK OFF)
set(Stokhos_ENABLE_qpOASES OFF)
set(Stokhos_ENABLE_Boost OFF)
set(Stokhos_ENABLE_MATLABLib OFF)
set(Stokhos_ENABLE_MKL OFF)

# Exported cache variables
set(Stokhos_ENABLE_EXPLICIT_INSTANTIATION "ON")
set(HAVE_STOKHOS_EXPLICIT_INSTANTIATION "ON")
set(Stokhos_ENABLE_DEBUG "OFF")
set(STOKHOS_DEBUG "OFF")
set(Stokhos_ENABLE_TEUCHOS_TIME_MONITOR "ON")
set(STOKHOS_TEUCHOS_TIME_MONITOR "ON")
set(Stokhos_ENABLE_Experimental "OFF")
set(STOKHOS_EXPERIMENTAL "OFF")
set(Stokhos_ENABLE_Ensemble_Reduction "OFF")
set(HAVE_STOKHOS_ENSEMBLE_REDUCT "OFF")
set(Stokhos_ENABLE_Ensemble_GEMV "ON")
set(HAVE_STOKHOS_ENSEMBLE_GEMV "ON")
set(Stokhos_ENABLE_Ensemble_Scalar_Type "ON")
set(HAVE_STOKHOS_ENSEMBLE_SCALAR_TYPE "ON")
set(Stokhos_ENABLE_PCE_Scalar_Type "ON")
set(HAVE_STOKHOS_PCE_SCALAR_TYPE "ON")
set(Stokhos_ENABLE_OpenMP "OFF")
set(HAVE_STOKHOS_OPENMP "OFF")

# Include configuration of dependent packages
if (NOT TARGET Teuchos::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../Teuchos/TeuchosConfig.cmake")
endif()
if (NOT TARGET Kokkos::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../Kokkos/KokkosConfig.cmake")
endif()
if (NOT TARGET Sacado::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../Sacado/SacadoConfig.cmake")
endif()
if (NOT TARGET NOX::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../NOX/NOXConfig.cmake")
endif()
if (NOT TARGET KokkosKernels::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../KokkosKernels/KokkosKernelsConfig.cmake")
endif()
if (NOT TARGET TeuchosKokkosComm::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../TeuchosKokkosComm/TeuchosKokkosCommConfig.cmake")
endif()
if (NOT TARGET Belos::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../Belos/BelosConfig.cmake")
endif()
if (NOT TARGET Thyra::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../Thyra/ThyraConfig.cmake")
endif()

# Import Stokhos targets
include("${CMAKE_CURRENT_LIST_DIR}/StokhosTargets.cmake")

# Standard TriBITS-compliant external package variables
set(Stokhos_IS_TRIBITS_COMPLIANT TRUE)
set(Stokhos_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE "${CMAKE_CURRENT_LIST_FILE}")
set(Stokhos_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE_DIR "${CMAKE_CURRENT_LIST_DIR}")


## ----------------------------------------------------------------------------
## Create deprecated non-namespaced library targets for backwards compatibility
## ----------------------------------------------------------------------------

set(Stokhos_EXPORTED_PACKAGE_LIBS_NAMES "stokhos;stokhos_sacado")

foreach(libname IN LISTS Stokhos_EXPORTED_PACKAGE_LIBS_NAMES)
  if (NOT TARGET ${libname})
    add_library(${libname} INTERFACE IMPORTED)
    target_link_libraries(${libname}
       INTERFACE Stokhos::${libname})
    set(deprecationMessage
      "WARNING: The non-namespaced target '${libname}' is deprecated!"
      "  If always using newer versions of the project 'Trilinos', then use the"
      " new namespaced target 'Stokhos::${libname}', or better yet,"
      " 'Stokhos::all_libs' to be less sensitive to changes in the definition"
      " of targets in the package 'Stokhos'.  Or, to maintain compatibility with"
      " older or newer versions the project 'Trilinos', instead link against the"
      " libraries specified by the variable 'Stokhos_LIBRARIES'."
      )
    string(REPLACE ";" "" deprecationMessage "${deprecationMessage}")
    set_target_properties(${libname}
      PROPERTIES DEPRECATION "${deprecationMessage}" )
  endif()
endforeach()
