/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.internal.precompiled;

import java.io.File;
import java.net.URLClassLoader;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.configuration.CompileOperationFactory;
import org.gradle.configuration.ScriptTarget;
import org.gradle.groovy.scripts.internal.CompileOperation;
import org.gradle.groovy.scripts.internal.ScriptCompilationHandler;
import org.gradle.initialization.ClassLoaderScopeRegistry;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.model.dsl.internal.transform.ClosureCreationInterceptingVerifier;
import org.gradle.plugin.devel.internal.precompiled.PrecompiledGroovyScript;

@CacheableTask
abstract class CompileGroovyScriptPluginsTask
extends DefaultTask {
    private final ScriptCompilationHandler scriptCompilationHandler;
    private final CompileOperationFactory compileOperationFactory;
    private final FileSystemOperations fileSystemOperations;
    private final ClassLoaderScope classLoaderScope;
    private final Provider<Directory> intermediatePluginClassesDirectory;
    private final Provider<Directory> intermediatePluginMetadataDirectory;

    @Inject
    public CompileGroovyScriptPluginsTask(ScriptCompilationHandler scriptCompilationHandler, ClassLoaderScopeRegistry classLoaderScopeRegistry, CompileOperationFactory compileOperationFactory, FileSystemOperations fileSystemOperations) {
        this.scriptCompilationHandler = scriptCompilationHandler;
        this.compileOperationFactory = compileOperationFactory;
        this.fileSystemOperations = fileSystemOperations;
        this.classLoaderScope = classLoaderScopeRegistry.getCoreAndPluginsScope();
        Project project = this.getProject();
        DirectoryProperty buildDir = project.getLayout().getBuildDirectory();
        this.intermediatePluginClassesDirectory = buildDir.dir("groovy-dsl-plugins/work/classes");
        this.intermediatePluginMetadataDirectory = buildDir.dir("groovy-dsl-plugins/work/metadata");
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @SkipWhenEmpty
    abstract ConfigurableFileCollection getScriptFiles();

    @Classpath
    abstract ConfigurableFileCollection getClasspath();

    @OutputDirectory
    abstract DirectoryProperty getPrecompiledGroovyScriptsOutputDirectory();

    @Internal
    abstract ListProperty<PrecompiledGroovyScript> getScriptPlugins();

    @TaskAction
    void compileScripts() {
        URLClassLoader compileClassLoader = new URLClassLoader(DefaultClassPath.of((Iterable)this.getClasspath()).getAsURLArray(), this.classLoaderScope.getLocalClassLoader());
        this.fileSystemOperations.delete(spec -> spec.delete(new Object[]{this.intermediatePluginMetadataDirectory, this.intermediatePluginClassesDirectory}));
        ((Directory)this.intermediatePluginMetadataDirectory.get()).getAsFile().mkdirs();
        ((Directory)this.intermediatePluginClassesDirectory.get()).getAsFile().mkdirs();
        for (PrecompiledGroovyScript scriptPlugin : (List)this.getScriptPlugins().get()) {
            this.compileBuildScript(scriptPlugin, compileClassLoader);
        }
        this.fileSystemOperations.sync(copySpec -> {
            copySpec.from(new Object[]{((Directory)this.intermediatePluginClassesDirectory.get()).getAsFileTree().getFiles()});
            copySpec.into((Object)this.getPrecompiledGroovyScriptsOutputDirectory());
        });
        ClassLoaderUtils.tryClose((ClassLoader)compileClassLoader);
    }

    private void compileBuildScript(PrecompiledGroovyScript scriptPlugin, ClassLoader compileClassLoader) {
        ScriptTarget target = scriptPlugin.getScriptTarget();
        CompileOperation scriptCompileOperation = this.compileOperationFactory.getScriptCompileOperation(scriptPlugin.getBodySource(), target);
        File scriptMetadataDir = CompileGroovyScriptPluginsTask.subdirectory(this.intermediatePluginMetadataDirectory, scriptPlugin.getId());
        File scriptClassesDir = CompileGroovyScriptPluginsTask.subdirectory(this.intermediatePluginClassesDirectory, scriptPlugin.getId());
        this.scriptCompilationHandler.compileToDir(scriptPlugin.getBodySource(), compileClassLoader, scriptClassesDir, scriptMetadataDir, scriptCompileOperation, target.getScriptClass(), ClosureCreationInterceptingVerifier.INSTANCE);
    }

    private static File subdirectory(Provider<Directory> root, String subdirPath) {
        return ((Directory)root.get()).dir(subdirPath).getAsFile();
    }
}

