/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import java.util.Optional;
import org.gradle.api.InvalidUserDataException;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.fingerprint.InputFingerprinter;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.changes.DefaultIncrementalInputProperties;
import org.gradle.internal.execution.history.changes.ExecutionStateChangeDetector;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.execution.history.changes.IncrementalInputProperties;
import org.gradle.internal.execution.history.changes.RebuildExecutionStateChanges;
import org.gradle.internal.execution.steps.CachingContext;
import org.gradle.internal.execution.steps.IncrementalChangesContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.ValidationFinishedContext;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.snapshot.ValueSnapshot;

public class ResolveChangesStep<R extends Result>
implements Step<CachingContext, R> {
    private static final String NO_HISTORY = "No history is available.";
    private static final String VALIDATION_FAILED = "Incremental execution has been disabled to ensure correctness. Please consult deprecation warnings for more details.";
    private final ExecutionStateChangeDetector changeDetector;
    private final Step<? super IncrementalChangesContext, R> delegate;

    public ResolveChangesStep(ExecutionStateChangeDetector changeDetector, Step<? super IncrementalChangesContext, R> delegate) {
        this.changeDetector = changeDetector;
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, final CachingContext context) {
        final Optional<BeforeExecutionState> beforeExecutionState = context.getBeforeExecutionState();
        final ExecutionStateChanges changes = context.getRebuildReason().map(rebuildReason -> new RebuildExecutionStateChanges((String)rebuildReason, (ImmutableSortedMap<String, CurrentFileCollectionFingerprint>)((ImmutableSortedMap)beforeExecutionState.map(BeforeExecutionState::getInputFileProperties).orElse(null)), ResolveChangesStep.createIncrementalInputProperties(work))).orElseGet(() -> beforeExecutionState.map(beforeExecution -> context.getAfterPreviousExecutionState().map(afterPreviousExecution -> context.getValidationProblems().map(__ -> ResolveChangesStep.rebuildChanges(work, beforeExecution, VALIDATION_FAILED)).orElseGet(() -> this.changeDetector.detectChanges((AfterPreviousExecutionState)afterPreviousExecution, (BeforeExecutionState)beforeExecution, work, ResolveChangesStep.createIncrementalInputProperties(work)))).orElseGet(() -> ResolveChangesStep.rebuildChanges(work, beforeExecution, NO_HISTORY))).orElse(null));
        return this.delegate.execute(work, new IncrementalChangesContext(){

            @Override
            public Optional<ExecutionStateChanges> getChanges() {
                return Optional.ofNullable(changes);
            }

            @Override
            public CachingState getCachingState() {
                return context.getCachingState();
            }

            @Override
            public Optional<String> getRebuildReason() {
                return context.getRebuildReason();
            }

            @Override
            public WorkValidationContext getValidationContext() {
                return context.getValidationContext();
            }

            @Override
            public ImmutableSortedMap<String, ValueSnapshot> getInputProperties() {
                return context.getInputProperties();
            }

            @Override
            public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getInputFileProperties() {
                return context.getInputFileProperties();
            }

            @Override
            public UnitOfWork.Identity getIdentity() {
                return context.getIdentity();
            }

            @Override
            public File getWorkspace() {
                return context.getWorkspace();
            }

            @Override
            public Optional<ExecutionHistoryStore> getHistory() {
                return context.getHistory();
            }

            @Override
            public Optional<AfterPreviousExecutionState> getAfterPreviousExecutionState() {
                return context.getAfterPreviousExecutionState();
            }

            @Override
            public Optional<ValidationFinishedContext.ValidationResult> getValidationProblems() {
                return context.getValidationProblems();
            }

            @Override
            public Optional<BeforeExecutionState> getBeforeExecutionState() {
                return beforeExecutionState;
            }
        });
    }

    private static ExecutionStateChanges rebuildChanges(UnitOfWork work, BeforeExecutionState beforeExecution, String rebuildReason) {
        return new RebuildExecutionStateChanges(rebuildReason, beforeExecution.getInputFileProperties(), ResolveChangesStep.createIncrementalInputProperties(work));
    }

    private static IncrementalInputProperties createIncrementalInputProperties(UnitOfWork work) {
        UnitOfWork.InputChangeTrackingStrategy inputChangeTrackingStrategy = work.getInputChangeTrackingStrategy();
        switch (inputChangeTrackingStrategy) {
            case NONE: {
                return IncrementalInputProperties.NONE;
            }
            case ALL_PARAMETERS: {
                return IncrementalInputProperties.ALL;
            }
            case INCREMENTAL_PARAMETERS: {
                final ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
                InputFingerprinter.InputVisitor visitor = new InputFingerprinter.InputVisitor(){

                    @Override
                    public void visitInputFileProperty(String propertyName, InputFingerprinter.InputPropertyType type, InputFingerprinter.FileValueSupplier valueSupplier) {
                        if (type.isIncremental()) {
                            Object value = valueSupplier.getValue();
                            if (value == null) {
                                throw new InvalidUserDataException("Must specify a value for incremental input property '" + propertyName + "'.");
                            }
                            builder.put((Object)propertyName, value);
                        }
                    }
                };
                work.visitIdentityInputs(visitor);
                work.visitRegularInputs(visitor);
                return new DefaultIncrementalInputProperties((ImmutableBiMap<String, Object>)builder.build());
            }
        }
        throw new AssertionError((Object)("Unknown InputChangeTrackingStrategy: " + (Object)((Object)inputChangeTrackingStrategy)));
    }
}

