/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea.model;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.plugins.ide.idea.model.Dependency;
import org.gradle.plugins.ide.idea.model.FilePath;
import org.gradle.plugins.ide.idea.model.IdeaLanguageLevel;
import org.gradle.plugins.ide.idea.model.IdeaModuleIml;
import org.gradle.plugins.ide.idea.model.Module;
import org.gradle.plugins.ide.idea.model.Path;
import org.gradle.plugins.ide.idea.model.PathFactory;
import org.gradle.plugins.ide.idea.model.internal.IdeaDependenciesProvider;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.plugins.ide.internal.resolver.DefaultGradleApiSourcesResolver;
import org.gradle.util.internal.ConfigureUtil;

public class IdeaModule {
    private String name;
    private Set<File> sourceDirs;
    private Set<File> generatedSourceDirs = Sets.newLinkedHashSet();
    private Set<File> resourceDirs = Sets.newLinkedHashSet();
    private Set<File> testResourceDirs = Sets.newLinkedHashSet();
    private Map<String, Map<String, Collection<Configuration>>> scopes = Maps.newLinkedHashMap();
    private boolean downloadSources = true;
    private boolean downloadJavadoc;
    private File contentRoot;
    private Set<File> testSourceDirs;
    private Set<File> excludeDirs;
    private Boolean inheritOutputDirs;
    private File outputDir;
    private File testOutputDir;
    private Map<String, File> pathVariables = Maps.newLinkedHashMap();
    private String jdkName;
    private IdeaLanguageLevel languageLevel;
    private JavaVersion targetBytecodeVersion;
    private final IdeaModuleIml iml;
    private final Project project;
    private PathFactory pathFactory;
    private boolean offline;
    private Map<String, Iterable<File>> singleEntryLibraries;

    public IdeaModule(Project project, IdeaModuleIml iml) {
        this.project = project;
        this.iml = iml;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<File> getSourceDirs() {
        return this.sourceDirs;
    }

    public void setSourceDirs(Set<File> sourceDirs) {
        this.sourceDirs = sourceDirs;
    }

    public Set<File> getGeneratedSourceDirs() {
        return this.generatedSourceDirs;
    }

    public void setGeneratedSourceDirs(Set<File> generatedSourceDirs) {
        this.generatedSourceDirs = generatedSourceDirs;
    }

    public Map<String, Map<String, Collection<Configuration>>> getScopes() {
        return this.scopes;
    }

    public void setScopes(Map<String, Map<String, Collection<Configuration>>> scopes) {
        this.scopes = scopes;
    }

    public boolean isDownloadSources() {
        return this.downloadSources;
    }

    public void setDownloadSources(boolean downloadSources) {
        this.downloadSources = downloadSources;
    }

    public boolean isDownloadJavadoc() {
        return this.downloadJavadoc;
    }

    public void setDownloadJavadoc(boolean downloadJavadoc) {
        this.downloadJavadoc = downloadJavadoc;
    }

    public File getContentRoot() {
        return this.contentRoot;
    }

    public void setContentRoot(File contentRoot) {
        this.contentRoot = contentRoot;
    }

    public Set<File> getTestSourceDirs() {
        return this.testSourceDirs;
    }

    public void setTestSourceDirs(Set<File> testSourceDirs) {
        this.testSourceDirs = testSourceDirs;
    }

    public Set<File> getResourceDirs() {
        return this.resourceDirs;
    }

    public void setResourceDirs(Set<File> resourceDirs) {
        this.resourceDirs = resourceDirs;
    }

    public Set<File> getTestResourceDirs() {
        return this.testResourceDirs;
    }

    public void setTestResourceDirs(Set<File> testResourceDirs) {
        this.testResourceDirs = testResourceDirs;
    }

    public Set<File> getExcludeDirs() {
        return this.excludeDirs;
    }

    public void setExcludeDirs(Set<File> excludeDirs) {
        this.excludeDirs = excludeDirs;
    }

    public Boolean getInheritOutputDirs() {
        return this.inheritOutputDirs;
    }

    public void setInheritOutputDirs(Boolean inheritOutputDirs) {
        this.inheritOutputDirs = inheritOutputDirs;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public File getTestOutputDir() {
        return this.testOutputDir;
    }

    public void setTestOutputDir(File testOutputDir) {
        this.testOutputDir = testOutputDir;
    }

    public Map<String, File> getPathVariables() {
        return this.pathVariables;
    }

    public void setPathVariables(Map<String, File> pathVariables) {
        this.pathVariables = pathVariables;
    }

    public String getJdkName() {
        return this.jdkName;
    }

    public void setJdkName(String jdkName) {
        this.jdkName = jdkName;
    }

    public IdeaLanguageLevel getLanguageLevel() {
        return this.languageLevel;
    }

    public void setLanguageLevel(IdeaLanguageLevel languageLevel) {
        this.languageLevel = languageLevel;
    }

    public JavaVersion getTargetBytecodeVersion() {
        return this.targetBytecodeVersion;
    }

    public void setTargetBytecodeVersion(JavaVersion targetBytecodeVersion) {
        this.targetBytecodeVersion = targetBytecodeVersion;
    }

    public IdeaModuleIml getIml() {
        return this.iml;
    }

    public Project getProject() {
        return this.project;
    }

    public PathFactory getPathFactory() {
        return this.pathFactory;
    }

    public void setPathFactory(PathFactory pathFactory) {
        this.pathFactory = pathFactory;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public Map<String, Iterable<File>> getSingleEntryLibraries() {
        return this.singleEntryLibraries;
    }

    public void setSingleEntryLibraries(Map<String, Iterable<File>> singleEntryLibraries) {
        this.singleEntryLibraries = singleEntryLibraries;
    }

    public void iml(Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)this.getIml());
    }

    public void iml(Action<? super IdeaModuleIml> action) {
        action.execute((Object)this.iml);
    }

    public File getOutputFile() {
        return new File(this.iml.getGenerateTo(), this.getName() + ".iml");
    }

    public void setOutputFile(File newOutputFile) {
        this.setName(newOutputFile.getName().replaceFirst("\\.iml$", ""));
        this.getIml().setGenerateTo(newOutputFile.getParentFile());
    }

    public Set<Dependency> resolveDependencies() {
        ProjectInternal projectInternal = (ProjectInternal)this.project;
        IdeArtifactRegistry ideArtifactRegistry = (IdeArtifactRegistry)projectInternal.getServices().get(IdeArtifactRegistry.class);
        ProjectStateRegistry projectRegistry = (ProjectStateRegistry)projectInternal.getServices().get(ProjectStateRegistry.class);
        IdeaDependenciesProvider ideaDependenciesProvider = new IdeaDependenciesProvider((Project)projectInternal, ideArtifactRegistry, projectRegistry, new DefaultGradleApiSourcesResolver(this.project));
        return ideaDependenciesProvider.provide(this);
    }

    public void mergeXmlModule(Module xmlModule) {
        this.iml.getBeforeMerged().execute((Object)xmlModule);
        FilePath contentRoot = this.getPathFactory().path(this.getContentRoot());
        Set<Path> sourceFolders = this.pathsOf(this.existing(this.getSourceDirs()));
        Set<Path> generatedSourceFolders = this.pathsOf(this.existing(this.getGeneratedSourceDirs()));
        Set<Path> testSourceFolders = this.pathsOf(this.existing(this.getTestSourceDirs()));
        Set<Path> resourceFolders = this.pathsOf(this.existing(this.getResourceDirs()));
        Set<Path> testResourceFolders = this.pathsOf(this.existing(this.getTestResourceDirs()));
        Set<Path> excludeFolders = this.pathsOf(this.getExcludeDirs());
        FilePath outputDir = this.getOutputDir() != null ? this.getPathFactory().path(this.getOutputDir()) : null;
        FilePath testOutputDir = this.getTestOutputDir() != null ? this.getPathFactory().path(this.getTestOutputDir()) : null;
        Set<Dependency> dependencies = this.resolveDependencies();
        String level = this.getLanguageLevel() != null ? this.getLanguageLevel().getLevel() : null;
        xmlModule.configure(contentRoot, sourceFolders, testSourceFolders, resourceFolders, testResourceFolders, generatedSourceFolders, excludeFolders, this.getInheritOutputDirs(), outputDir, testOutputDir, dependencies, this.getJdkName(), level);
        this.iml.getWhenMerged().execute((Object)xmlModule);
    }

    private Set<File> existing(Set<File> files) {
        return Sets.filter(files, (Predicate)new Predicate<File>(){

            public boolean apply(File file) {
                return file.exists();
            }
        });
    }

    private Set<Path> pathsOf(Set<File> files) {
        return files.stream().map(file -> this.getPathFactory().path((File)file)).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

