/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.buildsrc;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.initialization.buildsrc.BuildBuildSrcBuildOperationType;
import org.gradle.initialization.buildsrc.BuildSrcBuildListenerFactory;
import org.gradle.initialization.buildsrc.BuildSrcDetector;
import org.gradle.initialization.buildsrc.BuildSrcUpdateFactory;
import org.gradle.internal.Actions;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.PublicBuildPath;
import org.gradle.internal.build.StandAloneNestedBuild;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.plugin.management.internal.PluginRequests;

@ServiceScope(value=Scopes.Build.class)
public class BuildSourceBuilder {
    private static final BuildBuildSrcBuildOperationType.Result BUILD_BUILDSRC_RESULT = new BuildBuildSrcBuildOperationType.Result(){};
    private final BuildState currentBuild;
    private final FileLockManager fileLockManager;
    private final BuildOperationExecutor buildOperationExecutor;
    private final CachedClasspathTransformer cachedClasspathTransformer;
    private final BuildSrcBuildListenerFactory buildSrcBuildListenerFactory;
    private final BuildStateRegistry buildRegistry;
    private final PublicBuildPath publicBuildPath;
    private static final LockOptions LOCK_OPTIONS = LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.Exclusive).useCrossVersionImplementation();

    public BuildSourceBuilder(BuildState currentBuild, FileLockManager fileLockManager, BuildOperationExecutor buildOperationExecutor, CachedClasspathTransformer cachedClasspathTransformer, BuildSrcBuildListenerFactory buildSrcBuildListenerFactory, BuildStateRegistry buildRegistry, PublicBuildPath publicBuildPath) {
        this.currentBuild = currentBuild;
        this.fileLockManager = fileLockManager;
        this.buildOperationExecutor = buildOperationExecutor;
        this.cachedClasspathTransformer = cachedClasspathTransformer;
        this.buildSrcBuildListenerFactory = buildSrcBuildListenerFactory;
        this.buildRegistry = buildRegistry;
        this.publicBuildPath = publicBuildPath;
    }

    public ClassPath buildAndGetClassPath(GradleInternal gradle) {
        SettingsInternal settings = gradle.getSettings();
        File buildSrcDir = settings.getBuildSrcDir();
        ClassLoaderScope parentClassLoaderScope = settings.getClassLoaderScope();
        return this.createBuildSourceClasspath(buildSrcDir, gradle.getStartParameter(), parentClassLoaderScope);
    }

    private ClassPath createBuildSourceClasspath(File buildSrcDir, StartParameter containingBuildParameters, final ClassLoaderScope parentClassLoaderScope) {
        if (!BuildSrcDetector.isValidBuildSrcBuild(buildSrcDir)) {
            return ClassPath.EMPTY;
        }
        StartParameterInternal buildSrcStartParameter = this.buildSrcStartParameterFor(buildSrcDir, containingBuildParameters);
        final BuildDefinition buildDefinition = BuildDefinition.fromStartParameterForBuild(buildSrcStartParameter, "buildSrc", buildSrcDir, PluginRequests.EMPTY, (Action<? super DependencySubstitutions>)Actions.doNothing(), this.publicBuildPath, true);
        File customBuildFile = buildSrcStartParameter.getBuildFile();
        assert (customBuildFile == null);
        return (ClassPath)this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<ClassPath>(){

            public ClassPath call(BuildOperationContext context) {
                ClassPath classPath = BuildSourceBuilder.this.buildBuildSrc(buildDefinition, parentClassLoaderScope);
                context.setResult((Object)BUILD_BUILDSRC_RESULT);
                return classPath;
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Build buildSrc").progressDisplayName("Building buildSrc").details((Object)new BuildBuildSrcBuildOperationType.Details(){

                    @Override
                    public String getBuildPath() {
                        return BuildSourceBuilder.this.publicBuildPath.getBuildPath().toString();
                    }
                });
            }
        });
    }

    private StartParameterInternal buildSrcStartParameterFor(File buildSrcDir, StartParameter containingBuildParameters) {
        StartParameterInternal buildSrcStartParameter = (StartParameterInternal)containingBuildParameters.newBuild();
        buildSrcStartParameter.setCurrentDir(buildSrcDir);
        buildSrcStartParameter.setProjectProperties(containingBuildParameters.getProjectProperties());
        buildSrcStartParameter.doNotSearchUpwards();
        buildSrcStartParameter.setProfile(containingBuildParameters.isProfile());
        return buildSrcStartParameter;
    }

    private ClassPath buildBuildSrc(BuildDefinition buildDefinition, ClassLoaderScope parentClassLoaderScope) {
        StandAloneNestedBuild nestedBuild = this.buildRegistry.addBuildSrcNestedBuild(buildDefinition, this.currentBuild);
        return nestedBuild.run(buildController -> {
            buildController.getGradle().setClassLoaderScope(parentClassLoaderScope);
            try (FileLock ignored = this.buildSrcBuildLockFor(buildDefinition);){
                ClassPath classPath = new BuildSrcUpdateFactory((BuildTreeLifecycleController)buildController, this.buildSrcBuildListenerFactory, this.cachedClasspathTransformer).create();
                return classPath;
            }
        });
    }

    private FileLock buildSrcBuildLockFor(BuildDefinition buildDefinition) {
        return this.fileLockManager.lock(new File(buildDefinition.getBuildRootDir(), ".gradle/noVersion/buildSrc"), LOCK_OPTIONS, "buildSrc build lock");
    }
}

