/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.io;

import java.util.Comparator;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;

public final class OSAgnosticPathUtil {
    public static final Comparator<String> COMPARATOR = (path1, path2) -> {
        if (path1 == path2) {
            return 0;
        }
        if (path1 == null) {
            return -1;
        }
        if (path2 == null) {
            return 1;
        }
        int length1 = path1.length();
        int length2 = path2.length();
        boolean ignoreCase = !SystemInfo.isFileSystemCaseSensitive;
        for (int pos = 0; pos < length1 && pos < length2; ++pos) {
            char ch2;
            char ch1 = path1.charAt(pos);
            if (ch1 == (ch2 = path2.charAt(pos))) continue;
            if (ch1 == '/') {
                if (ch2 == '\\') continue;
                return -1;
            }
            if (ch1 == '\\') {
                if (ch2 == '/') continue;
                return -1;
            }
            if (ch2 == '/' || ch2 == '\\') {
                return 1;
            }
            int diff = StringUtil.compare(ch1, ch2, ignoreCase);
            if (diff == 0) continue;
            return diff;
        }
        return Integer.compare(length1, length2);
    };
}

